/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.layer;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.undo.UndoManager;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.operation.union.CascadedPolygonUnion;
import org.meteoinfo.data.mapdata.AttributeTable;
import org.meteoinfo.data.mapdata.Field;
import org.meteoinfo.data.mapdata.ShapeFileManage;
import org.meteoinfo.geoprocess.GeoComputation;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.GenericFileFilter;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.global.colors.ColorUtil;
import org.meteoinfo.layer.ChartSet;
import org.meteoinfo.layer.LabelSet;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.legend.ChartBreak;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.LabelBreak;
import org.meteoinfo.legend.LegendManage;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.shape.ChartGraphic;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.PointShape;
import org.meteoinfo.shape.PointZShape;
import org.meteoinfo.shape.Polygon;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.Polyline;
import org.meteoinfo.shape.PolylineShape;
import org.meteoinfo.shape.PolylineZShape;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.ShapeTypes;
import org.meteoinfo.table.DataColumn;
import org.meteoinfo.table.DataColumnCollection;
import org.meteoinfo.table.DataRow;
import org.meteoinfo.table.DataTable;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class VectorLayer
extends MapLayer {
    private boolean _avoidCollision;
    private List<Shape> _shapeList;
    private AttributeTable _attributeTable;
    private LabelSet _labelSet;
    private List<Graphic> _labelPoints;
    private ChartSet _chartSet;
    private List<ChartGraphic> _chartPoints;
    private int _identiferShape;
    private float _drawingZoom = 1.0f;
    private List<Shape> _originShapes = null;
    private AttributeTable _originAttributeTable = null;
    private List<Graphic> _originLabelPoints = null;
    private List<ChartGraphic> _originChartPoints = null;
    private boolean _projected = false;
    private boolean editing = false;
    private Shape editingShape;
    private final UndoManager undoManager = new UndoManager();

    public VectorLayer(ShapeTypes shapeType) {
        this.setLayerType(LayerTypes.VectorLayer);
        this.setShapeType(shapeType);
        this._avoidCollision = false;
        this._attributeTable = new AttributeTable();
        this._labelSet = new LabelSet();
        this._labelPoints = new ArrayList<Graphic>();
        this._chartSet = new ChartSet();
        this._chartPoints = new ArrayList<ChartGraphic>();
        this._shapeList = new ArrayList<Shape>();
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme(shapeType);
        super.setLegendScheme(ls);
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public boolean getAvoidCollision() {
        return this._avoidCollision;
    }

    public void setAvoidCollision(boolean istrue) {
        this._avoidCollision = istrue;
    }

    public int getShapeNum() {
        return this._shapeList.size();
    }

    public List<? extends Shape> getShapes() {
        return this._shapeList;
    }

    public void setShapes(List<? extends Shape> shapes) {
        this._shapeList = shapes;
    }

    public AttributeTable getAttributeTable() {
        return this._attributeTable;
    }

    public void setAttributeTable(AttributeTable table) {
        this._attributeTable = table;
    }

    public int getIdentiferShape() {
        return this._identiferShape;
    }

    public void setIdentiferShape(int idx) {
        this._identiferShape = idx;
    }

    @Override
    public void setTransparency(int trans) {
        super.setTransparency(trans);
        switch (this.getShapeType()) {
            case Polygon: 
            case PolygonM: 
            case PolygonZ: {
                for (int i = 0; i < this.getLegendScheme().getBreakNum(); ++i) {
                    PolygonBreak aPGB = (PolygonBreak)this.getLegendScheme().getLegendBreaks().get(i);
                    int alpha = (int)((1.0 - (double)trans / 100.0) * 255.0);
                    Color aColor = aPGB.getColor();
                    aPGB.setColor(new Color(aColor.getRed(), aColor.getGreen(), aColor.getBlue(), alpha));
                }
                break;
            }
        }
    }

    public LabelSet getLabelSet() {
        return this._labelSet;
    }

    public void setLabelSet(LabelSet ls) {
        this._labelSet = ls;
    }

    public List<Graphic> getLabelPoints() {
        return this._labelPoints;
    }

    public void setLabelPoints(List<Graphic> lps) {
        this._labelPoints = lps;
    }

    public ChartSet getChartSet() {
        return this._chartSet;
    }

    public void setChartSet(ChartSet cs) {
        this._chartSet = cs;
    }

    public List<ChartGraphic> getChartPoints() {
        return this._chartPoints;
    }

    public void setChartPoints(List<ChartGraphic> cps) {
        this._chartPoints = cps;
    }

    public float getDrawingZoom() {
        return this._drawingZoom;
    }

    public void setDrawingZoom(float zoom) {
        this._drawingZoom = zoom;
    }

    public boolean isProjected() {
        return this._projected;
    }

    public void setProjected(boolean istrue) {
        this._projected = istrue;
    }

    @Override
    public void setLegendScheme(LegendScheme value) {
        super.setLegendScheme(value);
        List<String> fieldNames = this._attributeTable.getTable().getColumnNames();
        switch (value.getLegendType()) {
            case UniqueValue: {
                if (fieldNames.contains(value.getFieldName())) break;
                LegendScheme ls = this.getLegendScheme();
                ls.setFieldName(fieldNames.get(0));
                for (int i = 0; i < this.getShapeNum(); ++i) {
                    ColorBreak cb = ls.getLegendBreaks().get(i);
                    cb.setStartValue(this.getCellValue(fieldNames.get(0), i));
                    cb.setEndValue(cb.getStartValue());
                }
                break;
            }
            case GraduatedColor: {
                if (fieldNames.contains(value.getFieldName()) || value.isGeometry()) break;
                String fName = "";
                if (fieldNames.size() > 0) {
                    fName = fieldNames.get(0);
                }
                LegendScheme ls = this.createLegendScheme(LegendType.SingleSymbol, fName);
                super.setLegendScheme(ls);
            }
        }
        this.updateLegendIndexes();
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean value) {
        this.editing = value;
    }

    public Shape getEditingShape() {
        return this.editingShape;
    }

    public void setEditingShape(Shape value) {
        this.editingShape = value;
        for (Shape shape : this._shapeList) {
            shape.setEditing(false);
        }
        this.editingShape.setEditing(true);
    }

    public void updateChartsProp() {
        for (Graphic graphic : this._chartPoints) {
            ChartBreak aCP = (ChartBreak)graphic.getLegend();
            aCP.setLegendScheme(this._chartSet.getLegendScheme());
            aCP.setMinSize(this._chartSet.getMinSize());
            aCP.setMaxSize(this._chartSet.getMaxSize());
            aCP.setMinValue(this._chartSet.getMinValue());
            aCP.setMaxValue(this._chartSet.getMaxValue());
            aCP.setBarWidth(this._chartSet.getBarWidth());
            aCP.setAlignType(this._chartSet.getAlignType());
            aCP.setView3D(this._chartSet.isView3D());
            aCP.setThickness(this._chartSet.getThickness());
            aCP.setDrawLabel(this._chartSet.isDrawLabel());
            aCP.setLabelColor(this._chartSet.getLabelColor());
            aCP.setLabelFont(this._chartSet.getLabelFont());
        }
    }

    public void addCharts() {
        ArrayList<Shape> shapeList = new ArrayList<Shape>(this._shapeList);
        int shapeIdx = -1;
        PointD aPoint = new PointD();
        List<Integer> selShapeIdx = this.getSelectedShapeIndexes();
        boolean isShapeSel = true;
        if (selShapeIdx.isEmpty()) {
            isShapeSel = false;
        }
        for (Shape aShape : shapeList) {
            ++shapeIdx;
            if (isShapeSel && !aShape.isSelected()) continue;
            PointShape aPS = new PointShape();
            switch (this.getShapeType()) {
                case Point: 
                case PointM: 
                case PointZ: {
                    aPS.setPoint((PointD)((PointShape)aShape).getPoint().clone());
                    break;
                }
                case Polyline: 
                case PolylineM: 
                case PolylineZ: {
                    int pIdx = ((PolylineShape)aShape).getPoints().size() / 2;
                    aPS.setPoint((PointD)((PolylineShape)aShape).getPoints().get(pIdx - 1).clone());
                    break;
                }
                case Polygon: 
                case PolygonM: 
                case PolygonZ: {
                    Extent aExtent = aShape.getExtent();
                    aPoint.X = (aExtent.minX + aExtent.maxX) / 2.0;
                    aPoint.Y = (aExtent.minY + aExtent.maxY) / 2.0;
                    aPS.setPoint(aPoint);
                }
            }
            ChartBreak aCP = new ChartBreak(this._chartSet.getChartType());
            for (String fn : this._chartSet.getFieldNames()) {
                aCP.getChartData().add(Float.valueOf(Float.parseFloat(this.getCellValue(fn, shapeIdx).toString())));
            }
            aCP.setXShift(this._chartSet.getXShift());
            aCP.setYShift(this._chartSet.getYShift());
            aCP.setLegendScheme(this._chartSet.getLegendScheme());
            aCP.setMinSize(this._chartSet.getMinSize());
            aCP.setMaxSize(this._chartSet.getMaxSize());
            aCP.setMinValue(this._chartSet.getMinValue());
            aCP.setMaxValue(this._chartSet.getMaxValue());
            aCP.setBarWidth(this._chartSet.getBarWidth());
            aCP.setAlignType(this._chartSet.getAlignType());
            aCP.setView3D(this._chartSet.isView3D());
            aCP.setThickness(this._chartSet.getThickness());
            aCP.setShapeIndex(shapeIdx);
            aCP.setDrawLabel(this._chartSet.isDrawLabel());
            aCP.setLabelColor(this._chartSet.getLabelColor());
            aCP.setLabelFont(this._chartSet.getLabelFont());
            aCP.setDecimalDigits(this._chartSet.getDecimalDigits());
            ChartGraphic aGraphic = new ChartGraphic(aPS, aCP);
            this.addChart(aGraphic);
        }
        this._chartSet.setDrawCharts(true);
    }

    public void updateChartSet() {
        double[] minMax;
        ArrayList<Double> minList = new ArrayList<Double>();
        ArrayList<Double> maxList = new ArrayList<Double>();
        ArrayList<Double> sumList = new ArrayList<Double>();
        List<String> fieldNames = this._chartSet.getFieldNames();
        for (int i = 0; i < this.getShapeNum(); ++i) {
            ArrayList<Double> vList = new ArrayList<Double>();
            double sum = 0.0;
            for (int j = 0; j < fieldNames.size(); ++j) {
                double v = Double.parseDouble(this.getCellValue(fieldNames.get(j), i).toString());
                vList.add(v);
                sum += v;
            }
            minMax = MIMath.getMinMaxValue(vList, -9999.0);
            minList.add(minMax[0]);
            maxList.add(minMax[1]);
            sumList.add(sum);
        }
        switch (this._chartSet.getChartType()) {
            case BarChart: {
                minMax = MIMath.getMinMaxValue(minList, -9999.0);
                this._chartSet.setMinValue((float)minMax[0]);
                minMax = MIMath.getMinMaxValue(maxList, -9999.0);
                this._chartSet.setMaxValue((float)minMax[1]);
                break;
            }
            case PieChart: {
                minMax = MIMath.getMinMaxValue(sumList, -9999.0);
                this._chartSet.setMinValue((float)minMax[0]);
                this._chartSet.setMaxValue((float)minMax[1]);
            }
        }
    }

    public void updateCharts() {
        for (ChartGraphic cg : this._chartPoints) {
            ChartBreak aCP = (ChartBreak)cg.getLegend();
            int shapeIdx = aCP.getShapeIndex();
            aCP.getChartData().clear();
            for (String fn : this._chartSet.getFieldNames()) {
                aCP.getChartData().add(Float.valueOf(Float.parseFloat(this.getCellValue(fn, shapeIdx).toString())));
            }
            aCP.setXShift(this._chartSet.getXShift());
            aCP.setYShift(this._chartSet.getYShift());
            aCP.setLegendScheme(this._chartSet.getLegendScheme());
            aCP.setMinSize(this._chartSet.getMinSize());
            aCP.setMaxSize(this._chartSet.getMaxSize());
            aCP.setMinValue(this._chartSet.getMinValue());
            aCP.setMaxValue(this._chartSet.getMaxValue());
            aCP.setBarWidth(this._chartSet.getBarWidth());
            aCP.setAlignType(this._chartSet.getAlignType());
            aCP.setView3D(this._chartSet.isView3D());
            aCP.setThickness(this._chartSet.getThickness());
            aCP.setDrawLabel(this._chartSet.isDrawLabel());
            aCP.setLabelColor(this._chartSet.getLabelColor());
            aCP.setLabelFont(this._chartSet.getLabelFont());
            aCP.setDecimalDigits(this._chartSet.getDecimalDigits());
        }
        this._chartSet.setDrawCharts(true);
    }

    public void addChart(ChartGraphic aCP) {
        this._chartPoints.add(aCP);
    }

    public void removeCharts() {
        this._chartPoints.clear();
        this._chartSet.setDrawCharts(false);
    }

    public Shape getShape(int idx) {
        return this._shapeList.get(idx);
    }

    public void addShape(Shape aShape) {
        this._shapeList.add(aShape);
        this.updateLayerExtent(aShape);
    }

    public Shape findShape_contains(Shape other) {
        for (Shape s : this._shapeList) {
            if (!s.contains(other)) continue;
            return s;
        }
        return null;
    }

    public Shape findShape_crosses(Shape other) {
        for (Shape s : this._shapeList) {
            if (!s.crosses(other)) continue;
            return s;
        }
        return null;
    }

    public Shape findReformShape(PolylineShape other) {
        if (this.getShapeType().isLine()) {
            return this.findShape_crosses(other);
        }
        if (this.getShapeType().isPolygon()) {
            PointShape a = new PointShape();
            a.setPoint(other.getPoints().get(0));
            PolygonShape r = (PolygonShape)this.findShape_contains(a);
            if (r == null) {
                return null;
            }
            PointShape b = new PointShape();
            b.setPoint(other.getPoints().get(other.getPointNum() - 1));
            if (r.contains(b)) {
                return r;
            }
            return null;
        }
        return null;
    }

    public List<Integer> selectShapes(Extent extent) {
        return this.selectShapes(extent, false);
    }

    public List<Integer> selectShapes(Extent aExtent, boolean isSingleSel) {
        return this.selectShapes(aExtent, this._shapeList, isSingleSel);
    }

    /*
     * Unable to fully structure code
     */
    public List<Integer> selectShapes(Extent aExtent, List<Shape> shapes, boolean isSingleSel) {
        selectedShapes = new ArrayList<Integer>();
        sp = aExtent.getCenterPoint();
        block0 : switch (1.$SwitchMap$org$meteoinfo$shape$ShapeTypes[this.getShapeType().ordinal()]) {
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                for (i = 0; i < shapes.size(); ++i) {
                    aPS = (PointShape)shapes.get(i);
                    if (!MIMath.pointInExtent(aPS.getPoint(), aExtent)) continue;
                    selectedShapes.add(this._shapeList.indexOf(aPS));
                    if (isSingleSel) break block0;
                }
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                dislist = new ArrayList<Double>();
                for (i = 0; i < shapes.size(); ++i) {
                    aPLS = (PolylineShape)shapes.get(i);
                    if (!MIMath.isExtentCross(aExtent, aPLS.getExtent()).booleanValue() || (sel = GeoComputation.selectPolylineShape(sp, aPLS, aExtent.getWidth() / 2.0)) == null) continue;
                    if (dislist.size() <= 0) ** GOTO lbl25
                    for (j = 0; j < dislist.size(); ++j) {
                        if (!((Double)sel < (Double)dislist.get(j))) continue;
                        selectedShapes.add(j, this._shapeList.indexOf(aPLS));
                        dislist.add(j, (Double)sel);
                        ** GOTO lbl29
                    }
                    ** GOTO lbl29
lbl25:
                    // 1 sources

                    selectedShapes.add(this._shapeList.indexOf(aPLS));
                    dislist.add((Double)sel);
lbl29:
                    // 3 sources

                    if (isSingleSel) break block0;
                }
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                block8: for (i = shapes.size() - 1; i >= 0; --i) {
                    aPGS = (PolygonShape)shapes.get(i);
                    if (isSingleSel) {
                        if (!GeoComputation.pointInPolygon(aPGS, sp)) continue;
                        selectedShapes.add(this._shapeList.indexOf(aPGS));
                        break block0;
                    }
                    if (GeoComputation.pointInPolygon(aPGS, sp)) {
                        selectedShapes.add(this._shapeList.indexOf(aPGS));
                        continue;
                    }
                    if (!MIMath.isExtentCross(aExtent, aPGS.getExtent()).booleanValue()) continue;
                    for (j = 0; j < aPGS.getPolygons().get(0).getOutLine().size(); ++j) {
                        if (!MIMath.pointInExtent(aPGS.getPolygons().get(0).getOutLine().get(j), aExtent)) continue;
                        selectedShapes.add(this._shapeList.indexOf(aPGS));
                        continue block8;
                    }
                }
                break;
            }
        }
        return selectedShapes;
    }

    public List<Integer> selectShapes(PolygonShape polygonShape) {
        ArrayList<Integer> selIdxs = new ArrayList<Integer>();
        for (int i = 0; i < this._shapeList.size(); ++i) {
            boolean isIn = false;
            List<? extends PointD> points = this._shapeList.get(i).getPoints();
            for (PointD pointD : points) {
                if (!GeoComputation.pointInPolygon(polygonShape, pointD)) continue;
                isIn = true;
                break;
            }
            if (!isIn) continue;
            this._shapeList.get(i).setSelected(true);
            selIdxs.add(i);
        }
        return selIdxs;
    }

    public void sqlSelect(String expression) {
        this.sqlSelect(expression, SelectType.NEW);
    }

    public void sqlSelect(String expression, String selType) {
        SelectType st = SelectType.valueOf(selType.toUpperCase());
        this.sqlSelect(expression, st);
    }

    public void sqlSelect(String expression, SelectType selType) {
        List<DataRow> rows = this._attributeTable.getTable().select(expression);
        ArrayList<Integer> rowIdxs = new ArrayList<Integer>();
        for (DataRow row : rows) {
            rowIdxs.add(row.getRowIndex());
        }
        switch (selType) {
            case NEW: {
                for (int i = 0; i < this.getShapeNum(); ++i) {
                    if (rowIdxs.contains(i)) {
                        this._shapeList.get(i).setSelected(true);
                        continue;
                    }
                    this._shapeList.get(i).setSelected(false);
                }
                break;
            }
            case ADD_TO_CURRENT: {
                for (int i = 0; i < this.getShapeNum(); ++i) {
                    if (!rowIdxs.contains(i)) continue;
                    this._shapeList.get(i).setSelected(true);
                }
                break;
            }
            case REMOVE_FROM_CURRENT: {
                for (int i = 0; i < this.getShapeNum(); ++i) {
                    if (!rowIdxs.contains(i)) continue;
                    this._shapeList.get(i).setSelected(false);
                }
                break;
            }
            case SELECT_FROM_CURRENT: {
                for (int i = 0; i < this.getShapeNum(); ++i) {
                    if (!this._shapeList.get(i).isSelected() || rowIdxs.contains(i)) continue;
                    this._shapeList.get(i).setSelected(false);
                }
                break;
            }
        }
    }

    public Shape selectShape(PointD p) {
        Coordinate c = new Coordinate(p.X, p.Y);
        Point point = new GeometryFactory().createPoint(c);
        for (Shape shape : this._shapeList) {
            if (!point.within(shape.toGeometry())) continue;
            return shape;
        }
        return null;
    }

    public Object[] selectPolygonHole(PointD p) {
        for (Shape shape : this._shapeList) {
            int i = 0;
            for (Polygon polygon : ((PolygonShape)shape).getPolygons()) {
                if (polygon.hasHole() && GeoComputation.pointInPolygon(polygon.getOutLine(), p)) {
                    int j = 0;
                    for (List<? extends PointD> hole : polygon.getHoleLines()) {
                        if (GeoComputation.pointInPolygon(hole, p)) {
                            return new Object[]{shape, i, j};
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public List<DataRow> getSelectedDataRows() {
        List<DataRow> rows = this.getDataRows();
        ArrayList<DataRow> selRows = new ArrayList<DataRow>();
        int i = 0;
        for (Shape shape : this._shapeList) {
            if (shape.isSelected()) {
                selRows.add(rows.get(i));
            }
            ++i;
        }
        return selRows;
    }

    public List<? extends Shape> getSelectedShapes() {
        ArrayList<Shape> selShapes = new ArrayList<Shape>();
        for (Shape shape : this._shapeList) {
            if (!shape.isSelected()) continue;
            selShapes.add(shape);
        }
        return selShapes;
    }

    public List<Integer> getSelectedShapeIndexes() {
        ArrayList<Integer> selIndexes = new ArrayList<Integer>();
        for (int i = 0; i < this.getShapeNum(); ++i) {
            if (!this._shapeList.get(i).isSelected()) continue;
            selIndexes.add(i);
        }
        return selIndexes;
    }

    public List<Shape> getVisibleShapes() {
        ArrayList<Shape> visShapes = new ArrayList<Shape>();
        for (Shape shape : this._shapeList) {
            if (!shape.isVisible()) continue;
            visShapes.add(shape);
        }
        return visShapes;
    }

    public void clearSelectedShapes() {
        for (Shape aShape : this._shapeList) {
            if (!aShape.isSelected()) continue;
            aShape.setSelected(false);
        }
    }

    public boolean hasSelectedShapes() {
        for (Shape shape : this._shapeList) {
            if (!shape.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void clearEditingShape() {
        if (this.editingShape != null) {
            this.editingShape.setEditing(false);
        }
    }

    public int getFieldNumber() {
        return this._attributeTable.getTable().getColumns().size();
    }

    public String getFieldName(int FieldIndex) {
        return ((DataColumn)this._attributeTable.getTable().getColumns().get(FieldIndex)).getColumnName();
    }

    public List<String> getFieldNames() {
        ArrayList<String> FNList = new ArrayList<String>();
        for (int i = 0; i < this.getFieldNumber(); ++i) {
            FNList.add(this.getFieldName(i));
        }
        return FNList;
    }

    public List<Field> getFields() {
        DataColumnCollection cols = this._attributeTable.getTable().getColumns();
        ArrayList<Field> fields = new ArrayList<Field>();
        for (DataColumn col : cols) {
            fields.add((Field)col);
        }
        return fields;
    }

    public Field getField(int idx) {
        return (Field)this._attributeTable.getTable().getColumns().get(idx);
    }

    public Field getField(String fieldName) {
        return (Field)this._attributeTable.getTable().getColumns().get(fieldName);
    }

    public int getFieldIdxByName(String fieldName) {
        int fieldIdx = -1;
        for (int i = 0; i < this.getFieldNumber(); ++i) {
            if (!((DataColumn)this._attributeTable.getTable().getColumns().get(i)).getColumnName().equals(fieldName)) continue;
            fieldIdx = i;
            break;
        }
        return fieldIdx;
    }

    public Object getCellValue(int fieldIndex, int shapeIndex) {
        return this._attributeTable.getTable().getValue(shapeIndex, fieldIndex);
    }

    public Object getCellValue(String fieldName, int shapeIndex) {
        return this._attributeTable.getTable().getValue(shapeIndex, fieldName);
    }

    public List<DataRow> getDataRows() {
        return this._attributeTable.getTable().getRows();
    }

    public void editAddField(Field aField) {
        for (int i = 0; i < this.getFieldNumber(); ++i) {
            if (!aField.getColumnName().equals(((DataColumn)this._attributeTable.getTable().getColumns().get(i)).getColumnName())) continue;
            aField.setColumnName(aField.getColumnName() + "_1");
        }
        this._attributeTable.getTable().getColumns().add(aField);
    }

    public void editAddField(String fieldName, DataType fieldType) {
        Field aField = new Field(fieldName, fieldType);
        this.editAddField(aField);
    }

    public void editRemoveField(String fieldName) {
        this._attributeTable.getTable().removeColumn(this.getField(fieldName));
    }

    public void editRenameField(String fieldName, String newFieldName) {
        this._attributeTable.getTable().renameColumn(this.getField(fieldName), newFieldName);
    }

    private void insertRecord(int position) throws Exception {
        DataRow aDR = this._attributeTable.getTable().newRow();
        this._attributeTable.getTable().getRows().add(position, aDR);
    }

    private void insertRecord(int position, DataRow record) throws Exception {
        this._attributeTable.getTable().getRows().add(position, record);
    }

    public void editCellValue(String fieldName, int shapeIndex, Object value) {
        ((DataRow)this._attributeTable.getTable().getRows().get(shapeIndex)).setValue(fieldName, value);
    }

    public void editCellValue(int fieldIndex, int shapeIndex, Object value) {
        ((DataRow)this._attributeTable.getTable().getRows().get(shapeIndex)).setValue(fieldIndex, value);
    }

    public double getMinValue(String fieldName) {
        if (((Field)this._attributeTable.getTable().getColumns().get(fieldName)).isNumeric()) {
            double min = 0.0;
            int dNum = 0;
            for (int i = 0; i < this.getShapeNum(); ++i) {
                double aValue = Double.parseDouble(this.getCellValue(fieldName, i).toString());
                if (Math.abs(aValue / this.getLegendScheme().getUndefValue() - 1.0) < 0.01) continue;
                if (dNum == 0) {
                    min = aValue;
                } else if (min > aValue) {
                    min = aValue;
                }
                ++dNum;
            }
            return min;
        }
        return 0.0;
    }

    public void joinTable(DataTable dataTable, String colName) {
        this.joinTable(dataTable, colName, false);
    }

    public void joinTable(DataTable dataTable, String colName, boolean isUpdate) {
        DataTable thisTable = this._attributeTable.getTable();
        thisTable.join(dataTable, colName, isUpdate);
        this._attributeTable.updateDataTable();
    }

    public void joinTable(DataTable dataTable, String colName_this, String colName_in, boolean isUpdate) {
        DataTable thisTable = this._attributeTable.getTable();
        thisTable.join(dataTable, colName_this, colName_in, isUpdate);
        this._attributeTable.updateDataTable();
    }

    public void removeJoins() {
        DataTable thisTable = this._attributeTable.getTable();
        for (DataColumn col : thisTable.getColumns()) {
            if (!col.isJoined()) continue;
            thisTable.removeColumn(col);
        }
    }

    public boolean editInsertShape(Shape aShape, int position) throws Exception {
        if (position < 0) {
            position = 0;
        } else if (position > this._shapeList.size()) {
            position = this._shapeList.size();
        }
        this._shapeList.add(position, aShape);
        this.insertRecord(position);
        this.updateLayerExtent(aShape);
        return true;
    }

    public boolean editInsertShape(Shape aShape, int position, DataRow record) throws Exception {
        if (position < 0) {
            position = 0;
        } else if (position > this._shapeList.size()) {
            position = this._shapeList.size();
        }
        this._shapeList.add(position, aShape);
        this.insertRecord(position, record);
        this.updateLayerExtent(aShape);
        return true;
    }

    public boolean editAddShape(Shape aShape) throws Exception {
        int pos = this._shapeList.size();
        return this.editInsertShape(aShape, pos);
    }

    public void editAddShape(Shape aShape, List<Object> fvalues) throws Exception {
        int pos = this._shapeList.size();
        this.editInsertShape(aShape, pos);
        for (int i = 0; i < this.getFieldNumber(); ++i) {
            this.editCellValue(i, pos, fvalues.get(i));
        }
    }

    public void editRemoveShape(Shape shape) {
        int idx = this._shapeList.indexOf(shape);
        if (idx >= 0) {
            this._shapeList.remove(shape);
            this._attributeTable.getTable().removeRow(idx);
        }
    }

    private void updateLayerExtent(Shape aShape) {
        if (this.getShapeNum() == 1) {
            this.setExtent((Extent)aShape.getExtent().clone());
        } else {
            this.setExtent(MIMath.getLagerExtent(this.getExtent(), aShape.getExtent()));
        }
    }

    private void updateLayerExtent() {
        if (this.getShapeNum() == 1) {
            this.setExtent((Extent)this._shapeList.get(0).getExtent().clone());
        } else {
            this.setExtent((Extent)this._shapeList.get(0).getExtent().clone());
            for (int i = 1; i < this.getShapeNum(); ++i) {
                this.setExtent(MIMath.getLagerExtent(this.getExtent(), this._shapeList.get(i).getExtent()));
            }
        }
    }

    @Override
    public void saveFile() {
        File aFile = new File(this.getFileName());
        if (aFile.exists()) {
            this.saveFile(aFile.getAbsolutePath());
        } else {
            JFileChooser aDlg = new JFileChooser();
            String curDir = System.getProperty("user.dir");
            aDlg.setCurrentDirectory(new File(curDir));
            String[] fileExts = new String[]{"shp"};
            GenericFileFilter pFileFilter = new GenericFileFilter(fileExts, "Shape File (*.shp)");
            aDlg.setFileFilter(pFileFilter);
            aDlg.setAcceptAllFileFilterUsed(false);
            if (0 == aDlg.showSaveDialog(null)) {
                aFile = aDlg.getSelectedFile();
                System.setProperty("user.dir", aFile.getParent());
                String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
                String fileName = aFile.getAbsolutePath();
                if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                    fileName = fileName + "." + extent;
                }
                this.saveFile(fileName);
            }
        }
    }

    @Override
    public void saveFile(String shpfilepath) {
        this.setFileName(shpfilepath);
        try {
            ShapeFileManage.saveShapeFile(shpfilepath, this);
        }
        catch (IOException ex) {
            Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void saveFile(String shpfilepath, String encoding) {
        this.setFileName(shpfilepath);
        try {
            ShapeFileManage.saveShapeFile(shpfilepath, this, encoding);
        }
        catch (IOException ex) {
            Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public VectorLayer buffer(double distance, boolean onlySel, boolean isMerge) {
        List<Object> shapes = new ArrayList();
        if (onlySel) {
            for (Shape aShape : this._shapeList) {
                if (!aShape.isSelected()) continue;
                shapes.add(aShape);
            }
        } else {
            shapes = this._shapeList;
        }
        VectorLayer newLayer = new VectorLayer(ShapeTypes.Polygon);
        newLayer.setProjInfo(this.getProjInfo());
        if (isMerge) {
            ArrayList<Geometry> bgeos = new ArrayList<Geometry>();
            for (Shape shape : shapes) {
                bgeos.add(shape.toGeometry().buffer(distance));
            }
            Geometry geometry = CascadedPolygonUnion.union(bgeos);
            PolygonShape polygonShape = new PolygonShape(geometry);
            try {
                newLayer.editAddShape(polygonShape);
            }
            catch (Exception ex) {
                Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            for (Shape shape : shapes) {
                Shape shape2 = shape.buffer(distance);
                try {
                    newLayer.editAddShape(shape2);
                }
                catch (Exception ex) {
                    Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return newLayer;
    }

    /*
     * WARNING - void declaration
     */
    public VectorLayer convexhull(boolean onlySel, boolean isMerge) {
        List<Object> shapes = new ArrayList();
        if (onlySel) {
            for (Shape aShape : this._shapeList) {
                if (!aShape.isSelected()) continue;
                shapes.add(aShape);
            }
        } else {
            shapes = this._shapeList;
        }
        VectorLayer newLayer = new VectorLayer(ShapeTypes.Polygon);
        newLayer.setProjInfo(this.getProjInfo());
        if (shapes.size() == 1) {
            Shape rshape = ((Shape)shapes.get(0)).convexHull();
            try {
                newLayer.editAddShape(rshape);
            }
            catch (Exception exception) {
                Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, exception);
            }
        } else if (isMerge) {
            void var6_8;
            Geometry[] geos = new Geometry[shapes.size()];
            boolean bl = false;
            while (var6_8 < geos.length) {
                geos[var6_8] = ((Shape)shapes.get((int)var6_8)).toGeometry();
                ++var6_8;
            }
            GeometryFactory geometryFactory = new GeometryFactory();
            GeometryCollection gs = geometryFactory.createGeometryCollection(geos);
            Geometry ch = gs.convexHull();
            PolygonShape rshape = new PolygonShape(ch);
            try {
                newLayer.editAddShape(rshape);
            }
            catch (Exception ex) {
                Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            for (Shape shape : shapes) {
                Shape rshape = shape.convexHull();
                try {
                    newLayer.editAddShape(rshape);
                }
                catch (Exception ex) {
                    Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return newLayer;
    }

    public VectorLayer clip(VectorLayer clipLayer) {
        return this.clip(clipLayer, false);
    }

    public VectorLayer clip(VectorLayer clipLayer, boolean onlySel) {
        ArrayList<PolygonShape> shapes = new ArrayList();
        if (onlySel) {
            for (Shape shape : clipLayer.getShapes()) {
                if (!shape.isSelected()) continue;
                shapes.add((PolygonShape)shape);
            }
        } else {
            shapes = clipLayer.getShapes();
        }
        return this.clip(shapes);
    }

    public VectorLayer clip(List<PolygonShape> clipPolys) {
        VectorLayer newLayer = (VectorLayer)this.cloneValue();
        DataTable aTable = new DataTable();
        for (DataColumn aDC : this.getAttributeTable().getTable().getColumns()) {
            Field bDC = new Field(aDC.getColumnName(), aDC.getDataType());
            aTable.getColumns().add(bDC);
        }
        newLayer.setShapes(new ArrayList());
        for (PolygonShape aPGS : clipPolys) {
            for (int i = 0; i < this.getShapeNum(); ++i) {
                Shape bShape = this.getShapes().get(i);
                DataRow aDR = (DataRow)this.getAttributeTable().getTable().getRows().get(i);
                Shape clipShape = bShape.intersection(aPGS);
                if (clipShape == null) continue;
                newLayer.addShape(clipShape);
                try {
                    aTable.addRow((DataRow)aDR.clone());
                    continue;
                }
                catch (Exception ex) {
                    Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        newLayer.getAttributeTable().setTable(aTable);
        newLayer.setLegendScheme((LegendScheme)this.getLegendScheme().clone());
        return newLayer;
    }

    public VectorLayer clip_bak(List<PolygonShape> clipPolys) {
        VectorLayer newLayer = (VectorLayer)this.cloneValue();
        DataTable aTable = new DataTable();
        for (DataColumn aDC : this.getAttributeTable().getTable().getColumns()) {
            Field bDC = new Field(aDC.getColumnName(), aDC.getDataType());
            aTable.getColumns().add(bDC);
        }
        newLayer.setShapes(new ArrayList());
        for (PolygonShape aPGS : clipPolys) {
            for (int i = 0; i < this.getShapeNum(); ++i) {
                Shape bShape = this.getShapes().get(i);
                DataRow aDR = (DataRow)this.getAttributeTable().getTable().getRows().get(i);
                for (Polygon polygon : aPGS.getPolygons()) {
                    Shape clipShape = GeoComputation.clipShape(bShape, polygon.getOutLine());
                    if (clipShape == null) continue;
                    newLayer.addShape(clipShape);
                    try {
                        aTable.addRow((DataRow)aDR.clone());
                    }
                    catch (Exception ex) {
                        Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
        newLayer.getAttributeTable().setTable(aTable);
        newLayer.setLegendScheme((LegendScheme)this.getLegendScheme().clone());
        newLayer.setTransparency(this.getTransparency());
        return newLayer;
    }

    public VectorLayer intersection(VectorLayer ilayer, boolean onlySel, boolean onlySelOther) {
        ArrayList<PolygonShape> ishapes = new ArrayList<PolygonShape>();
        if (onlySelOther) {
            for (Shape shape : ilayer.getSelectedShapes()) {
                ishapes.add((PolygonShape)shape);
            }
        } else {
            for (Shape shape : ilayer.getShapes()) {
                ishapes.add((PolygonShape)shape);
            }
        }
        return this.intersection(ishapes, onlySel);
    }

    public VectorLayer intersection(List<PolygonShape> clipPolys, boolean onlySel) {
        VectorLayer newLayer = (VectorLayer)this.cloneValue();
        DataTable aTable = new DataTable();
        for (DataColumn aDC : this.getAttributeTable().getTable().getColumns()) {
            Field bDC = new Field(aDC.getColumnName(), aDC.getDataType());
            aTable.getColumns().add(bDC);
        }
        newLayer.setShapes(new ArrayList());
        for (int i = 0; i < this.getShapeNum(); ++i) {
            Shape clipShape;
            DataRow aDR;
            Shape bShape = this.getShapes().get(i);
            if (onlySel) {
                if (!bShape.isSelected()) continue;
                aDR = (DataRow)this.getAttributeTable().getTable().getRows().get(i);
                for (PolygonShape aPGS : clipPolys) {
                    clipShape = bShape.intersection(aPGS);
                    if (clipShape == null) continue;
                    newLayer.addShape(clipShape);
                    try {
                        aTable.addRow((DataRow)aDR.clone());
                    }
                    catch (Exception ex) {
                        Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                continue;
            }
            aDR = (DataRow)this.getAttributeTable().getTable().getRows().get(i);
            for (PolygonShape aPGS : clipPolys) {
                clipShape = bShape.intersection(aPGS);
                if (clipShape == null) continue;
                newLayer.addShape(clipShape);
                try {
                    aTable.addRow((DataRow)aDR.clone());
                }
                catch (Exception ex) {
                    Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        newLayer.getAttributeTable().setTable(aTable);
        newLayer.setLegendScheme((LegendScheme)this.getLegendScheme().clone());
        newLayer.setTransparency(this.getTransparency());
        return newLayer;
    }

    public VectorLayer difference(List<PolygonShape> clipPolys, boolean onlySel) {
        VectorLayer newLayer = (VectorLayer)this.cloneValue();
        DataTable aTable = new DataTable();
        for (DataColumn aDC : this.getAttributeTable().getTable().getColumns()) {
            Field bDC = new Field(aDC.getColumnName(), aDC.getDataType());
            aTable.getColumns().add(bDC);
        }
        List<? extends Shape> shapes = onlySel ? this.getSelectedShapes() : this._shapeList;
        List<DataRow> dataRows = onlySel ? this.getSelectedDataRows() : this.getDataRows();
        newLayer.setShapes(new ArrayList());
        for (int i = 0; i < shapes.size(); ++i) {
            boolean isNull;
            Shape bShape = shapes.get(i);
            DataRow dataRow = dataRows.get(i);
            Shape clipShape = bShape.difference(clipPolys.get(0));
            boolean bl = isNull = clipShape == null;
            if (isNull) continue;
            if (clipPolys.size() > 1) {
                for (int j = 1; j < clipPolys.size(); ++j) {
                    if ((clipShape = clipShape.difference(clipPolys.get(j))) != null) continue;
                    isNull = true;
                    break;
                }
                if (isNull) continue;
                newLayer.addShape(clipShape);
                try {
                    aTable.addRow((DataRow)dataRow.clone());
                }
                catch (Exception ex) {
                    Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            newLayer.addShape(clipShape);
            try {
                aTable.addRow((DataRow)dataRow.clone());
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        newLayer.getAttributeTable().setTable(aTable);
        newLayer.setLegendScheme((LegendScheme)this.getLegendScheme().clone());
        newLayer.setTransparency(this.getTransparency());
        return newLayer;
    }

    public VectorLayer symDifference(List<PolygonShape> clipPolys, boolean onlySel) {
        Shape bShape;
        int i;
        VectorLayer newLayer = (VectorLayer)this.cloneValue();
        DataTable aTable = new DataTable();
        for (DataColumn aDC : this.getAttributeTable().getTable().getColumns()) {
            Field bDC = new Field(aDC.getColumnName(), aDC.getDataType());
            aTable.getColumns().add(bDC);
        }
        List<? extends Shape> shapes = onlySel ? this.getSelectedShapes() : this._shapeList;
        List<DataRow> dataRows = onlySel ? this.getSelectedDataRows() : this.getDataRows();
        newLayer.setShapes(new ArrayList());
        for (i = 0; i < shapes.size(); ++i) {
            boolean isNull;
            bShape = shapes.get(i);
            DataRow dataRow = dataRows.get(i);
            Shape clipShape = bShape.difference(clipPolys.get(0));
            boolean bl = isNull = clipShape == null;
            if (isNull) continue;
            if (clipPolys.size() > 1) {
                for (int j = 1; j < clipPolys.size(); ++j) {
                    if ((clipShape = clipShape.difference(clipPolys.get(j))) != null) continue;
                    isNull = true;
                    break;
                }
                if (isNull) continue;
                newLayer.addShape(clipShape);
                try {
                    aTable.addRow((DataRow)dataRow.clone());
                }
                catch (Exception ex) {
                    Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            newLayer.addShape(clipShape);
            try {
                aTable.addRow((DataRow)dataRow.clone());
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        newLayer.getAttributeTable().setTable(aTable);
        for (i = 0; i < clipPolys.size(); ++i) {
            boolean isNull;
            bShape = clipPolys.get(i);
            Shape clipShape = bShape.difference(shapes.get(0));
            boolean bl = isNull = clipShape == null;
            if (isNull) continue;
            if (shapes.size() > 1) {
                for (int j = 1; j < shapes.size(); ++j) {
                    if ((clipShape = clipShape.difference(shapes.get(j))) != null) continue;
                    isNull = true;
                    break;
                }
                if (isNull) continue;
                try {
                    newLayer.editAddShape(clipShape);
                }
                catch (Exception ex) {
                    Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            try {
                newLayer.editAddShape(clipShape);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(VectorLayer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        newLayer.setLegendScheme((LegendScheme)this.getLegendScheme().clone());
        newLayer.setTransparency(this.getTransparency());
        return newLayer;
    }

    public void addLabel(Graphic aLP) {
        this._labelPoints.add(aLP);
    }

    public Graphic getLabel(String text) {
        for (Graphic lb : this._labelPoints) {
            if (!((LabelBreak)lb.getLegend()).getText().equals(text)) continue;
            return lb;
        }
        return null;
    }

    public void moveLabel(String text, float x, float y) {
        Graphic lb = this.getLabel(text);
        if (lb != null) {
            this.moveLabel(lb, x, y);
        }
    }

    public void moveLabel(Graphic lb, float x, float y) {
        LabelBreak lbb = (LabelBreak)lb.getLegend();
        lbb.setXShift(lbb.getXShift() + x);
        lbb.setYShift(lbb.getYShift() + y);
    }

    public void removeLabels() {
        this._labelPoints.clear();
        this._labelSet.setDrawLabels(false);
    }

    public void addLabels() {
        this.addLabelsByColor();
        this._labelSet.setDrawLabels(true);
    }

    private void addLabelsByColor() {
        int shapeIdx = -1;
        String dFormat = "%1$.1f";
        boolean isData = false;
        if (((Field)this._attributeTable.getTable().getColumns().get(this._labelSet.getFieldName())).isNumeric()) {
            if (this._labelSet.isAutoDecimal()) {
                double min = this.getMinValue(this._labelSet.getFieldName());
                this._labelSet.setDecimalDigits(MIMath.getDecimalNum(min));
            }
            dFormat = "%1$." + String.valueOf(this._labelSet.getDecimalDigits()) + "f";
            isData = true;
        }
        List<Integer> selShapeIdx = this.getSelectedShapeIndexes();
        boolean isShapeSel = true;
        if (selShapeIdx.isEmpty()) {
            isShapeSel = false;
        }
        for (Shape aShape : this._shapeList) {
            ++shapeIdx;
            if (isShapeSel && !aShape.isSelected()) continue;
            ColorBreak aCB = null;
            if (this.getLegendScheme().getLegendType() == LegendType.SingleSymbol) {
                aCB = this.getLegendScheme().getLegendBreaks().get(0);
            } else if (this.getLegendScheme().getFieldName() != null) {
                String vStr = this.getCellValue(this.getLegendScheme().getFieldName(), shapeIdx).toString().trim();
                aCB = this.getColorBreak(vStr);
            }
            if (aCB == null || !aCB.isDrawShape()) continue;
            PointShape aPS = new PointShape();
            switch (this.getShapeType()) {
                case Point: 
                case PointM: 
                case PointZ: {
                    aPS.setPoint((PointD)((PointShape)aShape).getPoint().clone());
                    break;
                }
                case Polyline: 
                case PolylineM: 
                case PolylineZ: {
                    int pIdx = ((PolylineShape)aShape).getPoints().size() / 2;
                    aPS.setPoint((PointD)((PolylineShape)aShape).getPoints().get(pIdx - 1).clone());
                    break;
                }
                case Polygon: 
                case PolygonM: 
                case PolygonZ: {
                    Extent aExtent = aShape.getExtent();
                    PointD aPoint = new PointD();
                    aPoint.X = (aExtent.minX + aExtent.maxX) / 2.0;
                    aPoint.Y = (aExtent.minY + aExtent.maxY) / 2.0;
                    aPS.setPoint(aPoint);
                }
            }
            LabelBreak aLP = new LabelBreak();
            if (isData) {
                if (this._labelSet.isAutoDecimal()) {
                    aLP.setText(DataConvert.removeTailingZeros(this.getCellValue(this._labelSet.getFieldName(), shapeIdx).toString()));
                } else {
                    aLP.setText(String.format(dFormat, Double.parseDouble(this.getCellValue(this._labelSet.getFieldName(), shapeIdx).toString())));
                }
            } else {
                aLP.setText(this.getCellValue(this._labelSet.getFieldName(), shapeIdx).toString());
            }
            if (this._labelSet.isColorByLegend()) {
                aLP.setColor(aCB.getColor());
            } else {
                aLP.setColor(this._labelSet.getLabelColor());
            }
            aLP.setFont(this._labelSet.getLabelFont());
            aLP.setAlignType(this._labelSet.getLabelAlignType());
            aLP.setYShift(this._labelSet.getYOffset());
            aLP.setXShift(this._labelSet.getXOffset());
            Graphic aGraphic = new Graphic(aPS, aLP);
            this.addLabel(aGraphic);
        }
    }

    private ColorBreak getColorBreak(String vStr) {
        ColorBreak aCB = null;
        block0 : switch (this.getLegendScheme().getLegendType()) {
            case SingleSymbol: {
                aCB = this.getLegendScheme().getLegendBreaks().get(0);
                break;
            }
            case UniqueValue: {
                for (int j = 0; j < this.getLegendScheme().getLegendBreaks().size(); ++j) {
                    if (!vStr.equals(this.getLegendScheme().getLegendBreaks().get(j).getStartValue().toString())) continue;
                    aCB = this.getLegendScheme().getLegendBreaks().get(j);
                    break block0;
                }
                break;
            }
            case GraduatedColor: {
                double value = "".equals(vStr) || vStr == null ? 0.0 : Double.parseDouble(vStr);
                int blNum = 0;
                for (int j = 0; j < this.getLegendScheme().getLegendBreaks().size(); ++j) {
                    ColorBreak aPB = this.getLegendScheme().getLegendBreaks().get(j);
                    if (!(value == Double.parseDouble(aPB.getStartValue().toString()) || value > Double.parseDouble(aPB.getStartValue().toString()) && value < Double.parseDouble(aPB.getEndValue().toString())) && (++blNum != this.getLegendScheme().getLegendBreaks().size() || value != Double.parseDouble(aPB.getEndValue().toString()))) continue;
                    aCB = aPB;
                    break block0;
                }
                break;
            }
        }
        return aCB;
    }

    public void addLabelsContourDynamic(Extent sExtent) {
        if (this._labelSet.isAutoDecimal()) {
            double min = this.getMinValue(this._labelSet.getFieldName());
            this._labelSet.setDecimalDigits(MIMath.getDecimalNum(min));
        }
        String dFormat = "%1$." + String.valueOf(this._labelSet.getDecimalDigits()) + "f";
        int shapeIdx = 0;
        for (Shape aShape : this._shapeList) {
            PolylineShape aPLS = (PolylineShape)aShape;
            Extent IExtent = aPLS.getExtent();
            if (IExtent.maxX - IExtent.minX > (sExtent.maxX - sExtent.minX) / 10.0 || IExtent.maxY - IExtent.minY > (sExtent.maxY - sExtent.minY) / 10.0) {
                LabelBreak aLP = new LabelBreak();
                int pIdx = aPLS.getPoints().size() / 2;
                PointShape aPS = new PointShape();
                aPS.setPoint(aPLS.getPoints().get(pIdx - 1));
                String text = this._labelSet.isAutoDecimal() ? DataConvert.removeTailingZeros(this.getCellValue(this._labelSet.getFieldName(), shapeIdx).toString()) : String.format(dFormat, Double.parseDouble(this.getCellValue(this._labelSet.getFieldName(), shapeIdx).toString()));
                aLP.setText(text);
                aLP.setFont(this._labelSet.getLabelFont());
                aLP.setAlignType(this._labelSet.getLabelAlignType());
                aLP.setYShift(this._labelSet.getYOffset());
                switch (this.getLegendScheme().getLegendType()) {
                    case SingleSymbol: {
                        PolylineBreak aPLB = (PolylineBreak)this.getLegendScheme().getLegendBreaks().get(0);
                        aLP.setColor(aPLB.getColor());
                        break;
                    }
                    case UniqueValue: {
                        PolylineBreak aPLB;
                        String vStr = this.getCellValue(this._labelSet.getFieldName(), shapeIdx).toString();
                        for (int j = 0; j < this.getLegendScheme().getLegendBreaks().size(); ++j) {
                            aPLB = (PolylineBreak)this.getLegendScheme().getLegendBreaks().get(j);
                            if (!vStr.equals(aPLB.getStartValue().toString())) continue;
                            aLP.setColor(aPLB.getColor());
                        }
                        break;
                    }
                    case GraduatedColor: {
                        PolylineBreak aPLB;
                        String vStr = this.getCellValue(this._labelSet.getFieldName(), shapeIdx).toString();
                        double value = Double.parseDouble(vStr);
                        int blNum = 0;
                        for (int j = 0; j < this.getLegendScheme().getLegendBreaks().size(); ++j) {
                            aPLB = (PolylineBreak)this.getLegendScheme().getLegendBreaks().get(j);
                            if (!(value == Double.parseDouble(aPLB.getStartValue().toString()) || value > Double.parseDouble(aPLB.getStartValue().toString()) && value < Double.parseDouble(aPLB.getEndValue().toString())) && (++blNum != this.getLegendScheme().getLegendBreaks().size() || value != Double.parseDouble(aPLB.getEndValue().toString()))) continue;
                            aLP.setColor(aPLB.getColor());
                        }
                        break;
                    }
                }
                Graphic aGraphic = new Graphic(aPS, aLP);
                this.addLabel(aGraphic);
            }
            ++shapeIdx;
        }
        this._labelSet.setDrawLabels(true);
    }

    public void updateOriginData() {
        this._originAttributeTable = (AttributeTable)this._attributeTable.clone();
        this._originShapes = new ArrayList<Shape>();
        for (Shape aShape : this._shapeList) {
            this._originShapes.add((Shape)aShape.clone());
        }
        this._originLabelPoints = new ArrayList<Graphic>(this._labelPoints);
        this._originChartPoints = new ArrayList<ChartGraphic>(this._chartPoints);
        this._projected = true;
    }

    public void getOriginData() {
        this._attributeTable = (AttributeTable)this._originAttributeTable.clone();
        this._shapeList = new ArrayList<Shape>();
        for (Shape aShape : this._originShapes) {
            this._shapeList.add((Shape)aShape.clone());
        }
        this._labelPoints = this._originLabelPoints;
        this._chartPoints = this._originChartPoints;
        this.updateExtent();
    }

    public void saveAsKMLFile(String fileName) {
        if (this.getShapeType().isPoint()) {
            this.saveAsKMLFile_Point(fileName);
        } else if (this.getShapeType().isLine()) {
            this.saveAsKMLFile_Polyline(fileName);
        } else if (this.getShapeType().isPolygon()) {
            this.saveAsKMLFile_Polygon(fileName);
        }
    }

    private void saveAsKMLFile_Polygon(String fileName) {
        try {
            String str;
            SAXTransformerFactory fac = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = fac.newTransformerHandler();
            Transformer transformer = handler.getTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            FileOutputStream outStream = new FileOutputStream(fileName);
            StreamResult resultxml = new StreamResult(outStream);
            handler.setResult(resultxml);
            AttributesImpl atts = new AttributesImpl();
            handler.startDocument();
            atts.addAttribute("", "", "xmlns", String.class.getName(), "http://www.opengis.net/kml/2.2");
            handler.startElement("", "", "kml", atts);
            atts.clear();
            handler.startElement("", "", "Document", atts);
            handler.startElement("", "", "Name", atts);
            handler.characters(fileName.toCharArray(), 0, fileName.length());
            handler.endElement("", "", "Name");
            int styleNum = 0;
            for (ColorBreak cb : this.getLegendScheme().getLegendBreaks()) {
                atts.addAttribute("", "", "id", "", "pg" + String.valueOf(styleNum));
                handler.startElement("", "", "StyleMap", atts);
                atts.clear();
                handler.startElement("", "", "Pair", atts);
                handler.startElement("", "", "key", atts);
                str = "normal";
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "key");
                handler.startElement("", "", "styleUrl", atts);
                str = "#pgn" + String.valueOf(styleNum);
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "styleUrl");
                handler.endElement("", "", "Pair");
                handler.startElement("", "", "Pair", atts);
                handler.startElement("", "", "key", atts);
                str = "highlight";
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "key");
                handler.startElement("", "", "styleUrl", atts);
                str = "#pgn";
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "styleUrl");
                handler.endElement("", "", "Pair");
                handler.endElement("", "", "StyleMap");
                PolygonBreak pgb = (PolygonBreak)cb;
                atts.addAttribute("", "", "id", "", "pgn" + String.valueOf(styleNum));
                handler.startElement("", "", "Style", atts);
                atts.clear();
                handler.startElement("", "", "LineStyle", atts);
                handler.startElement("", "", "color", atts);
                str = ColorUtil.toKMLColor(pgb.getOutlineColor());
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "color");
                handler.startElement("", "", "width", atts);
                str = String.valueOf((int)pgb.getOutlineSize());
                if (!pgb.isDrawOutline()) {
                    str = "0";
                }
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "width");
                handler.endElement("", "", "LineStyle");
                handler.startElement("", "", "PolyStyle", atts);
                handler.startElement("", "", "color", atts);
                str = ColorUtil.toKMLColor(pgb.getColor());
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "color");
                handler.startElement("", "", "fill", atts);
                str = "1";
                if (!pgb.isDrawFill()) {
                    str = "0";
                }
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "fill");
                handler.endElement("", "", "PolyStyle");
                handler.endElement("", "", "Style");
                ++styleNum;
            }
            atts.addAttribute("", "", "id", "", "pgh");
            handler.startElement("", "", "Style", atts);
            atts.clear();
            handler.startElement("", "", "LineStyle", atts);
            handler.startElement("", "", "color", atts);
            str = "00000000";
            handler.characters(str.toCharArray(), 0, str.length());
            handler.endElement("", "", "color");
            handler.endElement("", "", "LineStyle");
            handler.startElement("", "", "PolyStyle", atts);
            handler.startElement("", "", "color", atts);
            str = "a0ff00ff";
            handler.characters(str.toCharArray(), 0, str.length());
            handler.endElement("", "", "color");
            handler.startElement("", "", "fill", atts);
            str = "1";
            handler.characters(str.toCharArray(), 0, str.length());
            handler.endElement("", "", "fill");
            handler.endElement("", "", "PolyStyle");
            handler.endElement("", "", "Style");
            handler.startElement("", "", "Folder", atts);
            handler.startElement("", "", "name", atts);
            str = fileName;
            handler.characters(str.toCharArray(), 0, str.length());
            handler.endElement("", "", "name");
            handler.startElement("", "", "description", atts);
            str = "Generated using MeteoInfo";
            handler.characters(str.toCharArray(), 0, str.length());
            handler.endElement("", "", "description");
            boolean hasSelShape = this.hasSelectedShapes();
            for (Shape shp : this._shapeList) {
                PolygonShape pgs = (PolygonShape)shp;
                if (hasSelShape && !pgs.isSelected()) continue;
                double currentLevel = pgs.lowValue;
                int levelNum = pgs.getLegendIndex();
                for (Polygon polygon : pgs.getPolygons()) {
                    handler.startElement("", "", "Placemark", atts);
                    handler.startElement("", "", "name", atts);
                    str = "Level " + String.valueOf(currentLevel);
                    handler.characters(str.toCharArray(), 0, str.length());
                    handler.endElement("", "", "name");
                    handler.startElement("", "", "description", atts);
                    str = "Level " + String.valueOf(currentLevel);
                    handler.characters(str.toCharArray(), 0, str.length());
                    handler.endElement("", "", "description");
                    handler.startElement("", "", "styleUrl", atts);
                    str = "#pg" + String.valueOf(levelNum);
                    handler.characters(str.toCharArray(), 0, str.length());
                    handler.endElement("", "", "styleUrl");
                    handler.startElement("", "", "Polygon", atts);
                    handler.startElement("", "", "outerBoundaryIs", atts);
                    handler.startElement("", "", "LinearRing", atts);
                    handler.startElement("", "", "coordinates", atts);
                    for (PointD pointD : polygon.getOutLine()) {
                        str = String.valueOf(pointD.X) + "," + String.valueOf(pointD.Y) + " ";
                        handler.characters(str.toCharArray(), 0, str.length());
                    }
                    handler.endElement("", "", "coordinates");
                    handler.endElement("", "", "LinearRing");
                    handler.endElement("", "", "outerBoundaryIs");
                    if (((PolygonBreak)this.getLegendScheme().getLegendBreaks().get(levelNum)).isDrawFill() && polygon.hasHole()) {
                        for (List list : polygon.getHoleLines()) {
                            handler.startElement("", "", "innerBoundaryIs", atts);
                            handler.startElement("", "", "LinearRing", atts);
                            handler.startElement("", "", "coordinates", atts);
                            for (PointD point : list) {
                                str = String.valueOf(point.X) + "," + String.valueOf(point.Y) + " ";
                                handler.characters(str.toCharArray(), 0, str.length());
                            }
                            handler.endElement("", "", "coordinates");
                            handler.endElement("", "", "LinearRing");
                            handler.endElement("", "", "innerBoundaryIs");
                        }
                    }
                    handler.endElement("", "", "Polygon");
                    handler.endElement("", "", "Placemark");
                }
            }
            handler.endElement("", "", "Folder");
            handler.endElement("", "", "Document");
            handler.endElement("", "", "kml");
            handler.endDocument();
            ((OutputStream)outStream).close();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveAsKMLFile_Polyline(String fileName) {
        try {
            String str;
            SAXTransformerFactory fac = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = fac.newTransformerHandler();
            Transformer transformer = handler.getTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            FileOutputStream outStream = new FileOutputStream(fileName);
            StreamResult resultxml = new StreamResult(outStream);
            handler.setResult(resultxml);
            AttributesImpl atts = new AttributesImpl();
            handler.startDocument();
            atts.addAttribute("", "", "xmlns", String.class.getName(), "http://www.opengis.net/kml/2.2");
            handler.startElement("", "", "kml", atts);
            atts.clear();
            handler.startElement("", "", "Document", atts);
            handler.startElement("", "", "Name", atts);
            handler.characters(fileName.toCharArray(), 0, fileName.length());
            handler.endElement("", "", "Name");
            int styleNum = 0;
            for (ColorBreak cb : this.getLegendScheme().getLegendBreaks()) {
                atts.addAttribute("", "", "id", "", "pg" + String.valueOf(styleNum));
                handler.startElement("", "", "StyleMap", atts);
                atts.clear();
                handler.startElement("", "", "Pair", atts);
                handler.startElement("", "", "key", atts);
                str = "normal";
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "key");
                handler.startElement("", "", "styleUrl", atts);
                str = "#pgn" + String.valueOf(styleNum);
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "styleUrl");
                handler.endElement("", "", "Pair");
                handler.startElement("", "", "Pair", atts);
                handler.startElement("", "", "key", atts);
                str = "highlight";
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "key");
                handler.startElement("", "", "styleUrl", atts);
                str = "#pgn";
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "styleUrl");
                handler.endElement("", "", "Pair");
                handler.endElement("", "", "StyleMap");
                PolylineBreak pgb = (PolylineBreak)cb;
                atts.addAttribute("", "", "id", "", "pgn" + String.valueOf(styleNum));
                handler.startElement("", "", "Style", atts);
                atts.clear();
                handler.startElement("", "", "LineStyle", atts);
                handler.startElement("", "", "color", atts);
                str = ColorUtil.toKMLColor(pgb.getColor());
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "color");
                handler.endElement("", "", "LineStyle");
                handler.endElement("", "", "Style");
                ++styleNum;
            }
            atts.addAttribute("", "", "id", "", "pgh");
            handler.startElement("", "", "Style", atts);
            atts.clear();
            handler.startElement("", "", "LineStyle", atts);
            handler.startElement("", "", "color", atts);
            str = "00000000";
            handler.characters(str.toCharArray(), 0, str.length());
            handler.endElement("", "", "color");
            handler.endElement("", "", "LineStyle");
            handler.endElement("", "", "Style");
            handler.startElement("", "", "Folder", atts);
            handler.startElement("", "", "name", atts);
            str = fileName;
            handler.characters(str.toCharArray(), 0, str.length());
            handler.endElement("", "", "name");
            handler.startElement("", "", "description", atts);
            str = "Generated using MeteoInfo";
            handler.characters(str.toCharArray(), 0, str.length());
            handler.endElement("", "", "description");
            boolean hasSelShape = this.hasSelectedShapes();
            for (Shape shp : this._shapeList) {
                PolylineShape pgs = (PolylineShape)shp;
                if (hasSelShape && !pgs.isSelected()) continue;
                double currentLevel = pgs.getValue();
                int levelNum = pgs.getLegendIndex();
                int i = 0;
                for (Polyline polyline : pgs.getPolylines()) {
                    handler.startElement("", "", "Placemark", atts);
                    handler.startElement("", "", "name", atts);
                    str = "Level " + String.valueOf(currentLevel);
                    handler.characters(str.toCharArray(), 0, str.length());
                    handler.endElement("", "", "name");
                    handler.startElement("", "", "description", atts);
                    str = "Level " + String.valueOf(currentLevel);
                    handler.characters(str.toCharArray(), 0, str.length());
                    handler.endElement("", "", "description");
                    handler.startElement("", "", "styleUrl", atts);
                    str = "#pg" + String.valueOf(levelNum);
                    handler.characters(str.toCharArray(), 0, str.length());
                    handler.endElement("", "", "styleUrl");
                    handler.startElement("", "", "LineString", atts);
                    handler.startElement("", "", "coordinates", atts);
                    for (PointD pointD : polyline.getPointList()) {
                        str = String.valueOf(pointD.X) + "," + String.valueOf(pointD.Y);
                        if (this.getShapeType() == ShapeTypes.PolylineZ) {
                            str = str + "," + String.valueOf(((PolylineZShape)shp).getZArray()[i]);
                        }
                        str = str + " ";
                        handler.characters(str.toCharArray(), 0, str.length());
                        ++i;
                    }
                    handler.endElement("", "", "coordinates");
                    handler.endElement("", "", "LineString");
                    handler.endElement("", "", "Placemark");
                }
            }
            handler.endElement("", "", "Folder");
            handler.endElement("", "", "Document");
            handler.endElement("", "", "kml");
            handler.endDocument();
            ((OutputStream)outStream).close();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveAsKMLFile_Point(String fileName) {
        try {
            String str;
            SAXTransformerFactory fac = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = fac.newTransformerHandler();
            Transformer transformer = handler.getTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            FileOutputStream outStream = new FileOutputStream(fileName);
            StreamResult resultxml = new StreamResult(outStream);
            handler.setResult(resultxml);
            AttributesImpl atts = new AttributesImpl();
            handler.startDocument();
            atts.addAttribute("", "", "xmlns", String.class.getName(), "http://www.opengis.net/kml/2.2");
            handler.startElement("", "", "kml", atts);
            atts.clear();
            handler.startElement("", "", "Document", atts);
            handler.startElement("", "", "Name", atts);
            handler.characters(fileName.toCharArray(), 0, fileName.length());
            handler.endElement("", "", "Name");
            int styleNum = 0;
            for (ColorBreak cb : this.getLegendScheme().getLegendBreaks()) {
                atts.addAttribute("", "", "id", "", "pg" + String.valueOf(styleNum));
                handler.startElement("", "", "StyleMap", atts);
                atts.clear();
                handler.startElement("", "", "Pair", atts);
                handler.startElement("", "", "key", atts);
                str = "normal";
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "key");
                handler.startElement("", "", "styleUrl", atts);
                str = "#pgn" + String.valueOf(styleNum);
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "styleUrl");
                handler.endElement("", "", "Pair");
                handler.startElement("", "", "Pair", atts);
                handler.startElement("", "", "key", atts);
                str = "highlight";
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "key");
                handler.startElement("", "", "styleUrl", atts);
                str = "#pgn";
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "styleUrl");
                handler.endElement("", "", "Pair");
                handler.endElement("", "", "StyleMap");
                PointBreak pgb = (PointBreak)cb;
                atts.addAttribute("", "", "id", "", "pgn" + String.valueOf(styleNum));
                handler.startElement("", "", "Style", atts);
                atts.clear();
                handler.startElement("", "", "BalloonStyle", atts);
                handler.startElement("", "", "bgColor", atts);
                str = ColorUtil.toKMLColor(pgb.getColor());
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "bgColor");
                handler.endElement("", "", "BalloonStyle");
                handler.endElement("", "", "Style");
                ++styleNum;
            }
            atts.addAttribute("", "", "id", "", "pgh");
            handler.startElement("", "", "Style", atts);
            atts.clear();
            handler.startElement("", "", "BalloonStyle", atts);
            handler.startElement("", "", "color", atts);
            str = "00000000";
            handler.characters(str.toCharArray(), 0, str.length());
            handler.endElement("", "", "color");
            handler.endElement("", "", "BalloonStyle");
            handler.endElement("", "", "Style");
            handler.startElement("", "", "Folder", atts);
            handler.startElement("", "", "name", atts);
            str = fileName;
            handler.characters(str.toCharArray(), 0, str.length());
            handler.endElement("", "", "name");
            handler.startElement("", "", "description", atts);
            str = "Generated using MeteoInfo";
            handler.characters(str.toCharArray(), 0, str.length());
            handler.endElement("", "", "description");
            boolean hasSelShape = this.hasSelectedShapes();
            int shapIdx = 0;
            for (Shape shp : this._shapeList) {
                PointShape pgs = (PointShape)shp;
                if (hasSelShape && !pgs.isSelected()) {
                    ++shapIdx;
                    continue;
                }
                double currentLevel = pgs.getValue();
                int levelNum = pgs.getLegendIndex();
                handler.startElement("", "", "Placemark", atts);
                if (this.getLabelSet().isDrawLabels()) {
                    handler.startElement("", "", "name", atts);
                    str = this.getCellValue(this.getLabelSet().getFieldName(), shapIdx).toString();
                    handler.characters(str.toCharArray(), 0, str.length());
                    handler.endElement("", "", "name");
                }
                handler.startElement("", "", "description", atts);
                str = "Level " + String.valueOf(currentLevel);
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "description");
                handler.startElement("", "", "styleUrl", atts);
                str = "#pg" + String.valueOf(levelNum);
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "styleUrl");
                handler.startElement("", "", "Point", atts);
                handler.startElement("", "", "coordinates", atts);
                str = String.valueOf(pgs.getPoint().X) + "," + String.valueOf(pgs.getPoint().Y);
                if (this.getShapeType() == ShapeTypes.PointZ) {
                    str = str + "," + String.valueOf(((PointZShape)shp).getZ());
                }
                handler.characters(str.toCharArray(), 0, str.length());
                handler.endElement("", "", "coordinates");
                handler.endElement("", "", "Point");
                handler.endElement("", "", "Placemark");
            }
            handler.endElement("", "", "Folder");
            handler.endElement("", "", "Document");
            handler.endElement("", "", "kml");
            handler.endDocument();
            ((OutputStream)outStream).close();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void updateExtent() {
        for (int i = 0; i < this._shapeList.size(); ++i) {
            if (i == 0) {
                this.setExtent((Extent)this._shapeList.get(i).getExtent().clone());
                continue;
            }
            this.setExtent(MIMath.getLagerExtent(this.getExtent(), this._shapeList.get(i).getExtent()));
        }
    }

    public void updateLegendScheme(LegendType aLT, String fieldName) {
        this.setLegendScheme(this.createLegendScheme(aLT, fieldName));
    }

    public void updateLegendIndexes() {
        LegendScheme ls = this.getLegendScheme();
        switch (ls.getLegendType()) {
            case UniqueValue: {
                int shapeIdx = 0;
                if (this.getField(ls.getFieldName()).isNumeric()) {
                    for (Shape shape : this.getShapes()) {
                        String vStr = this.getCellValue(ls.getFieldName(), shapeIdx).toString();
                        shape.setLegendIndex(-1);
                        for (int i = 0; i < ls.getBreakNum(); ++i) {
                            if (!MIMath.doubleEquals(Double.parseDouble(ls.getLegendBreaks().get(i).getStartValue().toString()), Double.parseDouble(vStr))) continue;
                            shape.setLegendIndex(i);
                            break;
                        }
                        ++shapeIdx;
                    }
                } else {
                    for (Shape shape : this.getShapes()) {
                        String vStr = this.getCellValue(ls.getFieldName(), shapeIdx).toString();
                        shape.setLegendIndex(-1);
                        for (int i = 0; i < ls.getBreakNum(); ++i) {
                            if (!vStr.equals(ls.getLegendBreaks().get(i).getStartValue().toString())) continue;
                            shape.setLegendIndex(i);
                            break;
                        }
                        ++shapeIdx;
                    }
                }
                break;
            }
            case GraduatedColor: {
                if (ls.isGeometry()) break;
                int shapeIdx = 0;
                for (Shape shape : this.getShapes()) {
                    shape.setLegendIndex(-1);
                    String vStr = this.getCellValue(ls.getFieldName(), shapeIdx).toString();
                    double v = Double.parseDouble(vStr);
                    int blNum = 0;
                    for (int i = 0; i < ls.getBreakNum(); ++i) {
                        ColorBreak cb = ls.getLegendBreaks().get(i);
                        if (!(MIMath.doubleEquals(v, Double.parseDouble(cb.getStartValue().toString())) || v > Double.parseDouble(cb.getStartValue().toString()) && v < Double.parseDouble(cb.getEndValue().toString())) && (++blNum != ls.getBreakNum() || v != Double.parseDouble(cb.getEndValue().toString()))) continue;
                        shape.setLegendIndex(i);
                        break;
                    }
                    ++shapeIdx;
                }
                break;
            }
            default: {
                for (Shape shape : this.getShapes()) {
                    shape.setLegendIndex(0);
                }
            }
        }
    }

    public LegendScheme createLegendScheme(LegendType aLT, String fieldName) {
        ShapeTypes aST = this.getShapeType();
        LegendScheme aLS = new LegendScheme(this.getShapeType());
        double min = aLS.getMinValue();
        double max = aLS.getMaxValue();
        switch (aLT) {
            case SingleSymbol: {
                Color aColor = Color.black;
                float size = 1.0f;
                switch (aST) {
                    case Point: 
                    case PointM: 
                    case PointZ: {
                        aColor = Color.black;
                        size = 5.0f;
                        break;
                    }
                    case Polyline: 
                    case PolylineM: 
                    case PolylineZ: {
                        aColor = Color.black;
                        break;
                    }
                    case Polygon: 
                    case PolygonM: 
                    case PolygonZ: 
                    case Image: {
                        aColor = new Color(255, 251, 195);
                    }
                }
                aLS = LegendManage.createSingleSymbolLegendScheme(aST, aColor, size);
                break;
            }
            case UniqueValue: {
                ArrayList<String> valueList = new ArrayList<String>();
                boolean isDateField = false;
                DataType colType = this.getAttributeTable().getTable().getColumns().get(fieldName).getDataType();
                if (colType == DataType.DATE) {
                    isDateField = true;
                }
                ArrayList<String> captions = new ArrayList<String>();
                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy/M/d");
                for (int i = 0; i < this.getAttributeTable().getTable().getRows().size(); ++i) {
                    Object value = ((DataRow)this.getAttributeTable().getTable().getRows().get(i)).getValue(fieldName);
                    if (valueList.contains(value.toString())) continue;
                    valueList.add(value.toString());
                    if (!isDateField) continue;
                    captions.add(format.format((LocalDateTime)value));
                }
                Color[] colors = valueList.size() <= 13 ? LegendManage.createRainBowColors(valueList.size()) : LegendManage.createRandomColors(valueList.size());
                Color[] newcolors = new Color[colors.length + 1];
                newcolors[0] = Color.white;
                for (int i = 1; i < newcolors.length; ++i) {
                    newcolors[i] = colors[i - 1];
                }
                aLS = isDateField ? LegendManage.createUniqValueLegendScheme(valueList, captions, newcolors, aST, min, max, aLS.getHasNoData(), aLS.getUndefValue()) : LegendManage.createUniqValueLegendScheme(valueList, newcolors, aST, min, max, aLS.getHasNoData(), aLS.getUndefValue());
                aLS.setFieldName(fieldName);
                break;
            }
            case GraduatedColor: {
                double[] S = new double[this.getAttributeTable().getTable().getRows().size()];
                for (int i = 0; i < S.length; ++i) {
                    S[i] = Double.parseDouble(((DataRow)this.getAttributeTable().getTable().getRows().get(i)).getValue(fieldName).toString());
                }
                double[] minmax = MIMath.getMinMaxValue(S, aLS.getUndefValue());
                min = minmax[0];
                if (min == (max = minmax[1])) {
                    JOptionPane.showMessageDialog(null, "The values of all shapes are same!");
                    break;
                }
                double[] CValues = LegendManage.createContourValues(min, max);
                Color[] colors = LegendManage.createRainBowColors(CValues.length + 1);
                aLS = LegendManage.createGraduatedLegendScheme(CValues, colors, aST, min, max, aLS.getHasNoData(), aLS.getUndefValue());
                aLS.setFieldName(fieldName);
            }
        }
        return aLS;
    }

    @Override
    public Object clone() {
        VectorLayer aLayer = new VectorLayer(this.getShapeType());
        aLayer.setExtent((Extent)this.getExtent().clone());
        aLayer.setFileName(this.getFileName());
        aLayer.setHandle(this.getHandle());
        aLayer.setLayerName(this.getLayerName());
        if (this._projected) {
            for (Shape shape : this._originShapes) {
                aLayer.addShape((Shape)shape.clone());
            }
            aLayer.setAttributeTable((AttributeTable)this._originAttributeTable.clone());
        } else {
            for (Shape shape : this._shapeList) {
                aLayer.addShape((Shape)shape.clone());
            }
            aLayer.setAttributeTable((AttributeTable)this._attributeTable.clone());
        }
        aLayer.setLegendScheme((LegendScheme)this.getLegendScheme().clone());
        aLayer.setTransparency(this.getTransparency());
        aLayer.setLayerDrawType(this.getLayerDrawType());
        aLayer.setVisible(this.isVisible());
        aLayer.setLabelSet(this._labelSet);
        aLayer.setExpanded(this.isExpanded());
        aLayer.setAvoidCollision(this._avoidCollision);
        aLayer.setMaskout(this.isMaskout());
        aLayer.setTag(this.getTag());
        return aLayer;
    }

    public Object cloneShapes() {
        VectorLayer aLayer = new VectorLayer(this.getShapeType());
        aLayer.setExtent((Extent)this.getExtent().clone());
        aLayer.setLayerName(this.getLayerName());
        aLayer.setProjInfo(this.getProjInfo());
        aLayer.setLegendScheme((LegendScheme)this.getLegendScheme().clone());
        if (this._projected) {
            for (Shape shape : this._originShapes) {
                aLayer.addShape((Shape)shape.clone());
            }
        } else {
            for (Shape shape : this._shapeList) {
                aLayer.addShape((Shape)shape.clone());
            }
        }
        aLayer.setTransparency(this.getTransparency());
        aLayer.setLayerDrawType(this.getLayerDrawType());
        aLayer.setVisible(this.isVisible());
        aLayer.setLabelSet(this._labelSet);
        aLayer.setExpanded(this.isExpanded());
        aLayer.setAvoidCollision(this._avoidCollision);
        aLayer.setMaskout(this.isMaskout());
        return aLayer;
    }

    public Object cloneValue() {
        VectorLayer aLayer = new VectorLayer(this.getShapeType());
        aLayer.setLayerName(this.getLayerName());
        aLayer.setProjInfo(this.getProjInfo());
        aLayer.setLayerDrawType(this.getLayerDrawType());
        aLayer.setVisible(this.isVisible());
        aLayer.setLabelSet(this._labelSet);
        aLayer.setExpanded(this.isExpanded());
        aLayer.setAvoidCollision(this._avoidCollision);
        aLayer.setMaskout(this.isMaskout());
        return aLayer;
    }

    @Override
    public String getLayerInfo() {
        String str = "Layer name: " + this.getLayerName();
        str = str + System.getProperty("line.separator") + "Layer file: " + this.getFileName();
        str = str + System.getProperty("line.separator") + "Layer type: " + (Object)((Object)this.getLayerType());
        str = str + System.getProperty("line.separator") + "Shape type: " + (Object)((Object)this.getShapeType());
        str = str + System.getProperty("line.separator") + "Shape count: " + String.valueOf(this.getShapeNum());
        str = str + System.getProperty("line.separator") + "Fields:";
        for (Field field : this.getFields()) {
            str = str + System.getProperty("line.separator") + "\t" + field.getColumnName() + ": " + field.getDataTypeName();
        }
        return str;
    }

    static enum SelectType {
        NEW,
        ADD_TO_CURRENT,
        REMOVE_FROM_CURRENT,
        SELECT_FROM_CURRENT;

    }
}

