/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.map;

import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableModel;
import javax.swing.undo.UndoableEdit;
import org.freehep.graphicsio.emf.EMFGraphics2D;
import org.freehep.graphicsio.ps.PSGraphics2D;
import org.meteoinfo.data.mapdata.Field;
import org.meteoinfo.data.mapdata.MapDataManage;
import org.meteoinfo.data.mapdata.webmap.GeoPosition;
import org.meteoinfo.data.mapdata.webmap.IWebMapPanel;
import org.meteoinfo.data.mapdata.webmap.TileLoadListener;
import org.meteoinfo.data.mapdata.webmap.WebMapProvider;
import org.meteoinfo.drawing.Draw;
import org.meteoinfo.geoprocess.GeoComputation;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.Direction;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.FrmMeasurement;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointF;
import org.meteoinfo.global.colors.ColorUtil;
import org.meteoinfo.global.event.GraphicSelectedEvent;
import org.meteoinfo.global.event.IGraphicSelectedListener;
import org.meteoinfo.global.event.ILayersUpdatedListener;
import org.meteoinfo.global.event.IProjectionChangedListener;
import org.meteoinfo.global.event.IShapeSelectedListener;
import org.meteoinfo.global.event.IUndoEditListener;
import org.meteoinfo.global.event.IViewExtentChangedListener;
import org.meteoinfo.global.event.LayersUpdatedEvent;
import org.meteoinfo.global.event.ProjectionChangedEvent;
import org.meteoinfo.global.event.ShapeSelectedEvent;
import org.meteoinfo.global.event.UndoEditEvent;
import org.meteoinfo.global.event.ViewExtentChangedEvent;
import org.meteoinfo.global.util.BigDecimalUtil;
import org.meteoinfo.global.util.GeoUtil;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.image.ImageUtil;
import org.meteoinfo.layer.ChartSet;
import org.meteoinfo.layer.ImageLayer;
import org.meteoinfo.layer.LabelSet;
import org.meteoinfo.layer.LayerCollection;
import org.meteoinfo.layer.LayerDrawType;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.RasterLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.layer.VisibleScale;
import org.meteoinfo.layer.WebMapLayer;
import org.meteoinfo.layout.Edge;
import org.meteoinfo.legend.AlignType;
import org.meteoinfo.legend.ArrowBreak;
import org.meteoinfo.legend.BreakTypes;
import org.meteoinfo.legend.ChartBreak;
import org.meteoinfo.legend.ChartTypes;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.FrmLabelSymbolSet;
import org.meteoinfo.legend.FrmPointSymbolSet;
import org.meteoinfo.legend.FrmPolygonSymbolSet;
import org.meteoinfo.legend.FrmPolylineSymbolSet;
import org.meteoinfo.legend.LabelBreak;
import org.meteoinfo.legend.LegendManage;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.legend.LineStyles;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PointStyle;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.map.FrmIdentifer;
import org.meteoinfo.map.FrmIdentiferGrid;
import org.meteoinfo.map.FrmVerticeEdit;
import org.meteoinfo.map.GridLabel;
import org.meteoinfo.map.MapViewUndoRedo;
import org.meteoinfo.map.MaskOut;
import org.meteoinfo.map.MouseTools;
import org.meteoinfo.map.ProjectionSet;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.ProjectionUtil;
import org.meteoinfo.projection.Reproject;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.shape.ChartGraphic;
import org.meteoinfo.shape.CircleShape;
import org.meteoinfo.shape.CurveLineShape;
import org.meteoinfo.shape.CurvePolygonShape;
import org.meteoinfo.shape.EllipseShape;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.GraphicCollection;
import org.meteoinfo.shape.PointShape;
import org.meteoinfo.shape.PointZ;
import org.meteoinfo.shape.PointZShape;
import org.meteoinfo.shape.Polygon;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.Polyline;
import org.meteoinfo.shape.PolylineShape;
import org.meteoinfo.shape.RectangleShape;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.ShapeTypes;
import org.meteoinfo.shape.StationModelShape;
import org.meteoinfo.shape.WindArrow;
import org.meteoinfo.shape.WindBarb;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import wcontour.Contour;
import wcontour.global.PointD;

public class MapView
extends JPanel
implements IWebMapPanel {
    private final EventListenerList _listeners = new EventListenerList();
    private TileLoadListener tileLoadListener = new TileLoadListener(this);
    public FrmIdentifer frmIdentifer = null;
    public FrmIdentiferGrid _frmIdentiferGrid = null;
    private FrmMeasurement _frmMeasure = null;
    private BufferedImage _mapBitmap = new BufferedImage(10, 10, 2);
    private boolean newPaint = false;
    private boolean doubleBuffer = true;
    private boolean _antiAlias = false;
    private boolean _pointAntiAlias = true;
    private boolean _highSpeedWheelZoom = true;
    private boolean _lockViewUpdate = false;
    private LayerCollection layers = new LayerCollection();
    private int _selectedLayer;
    private Extent _extent = new Extent();
    private Extent _viewExtent = new Extent();
    private Extent _drawExtent = new Extent();
    private double _scaleX = 1.0;
    private double _scaleY = 1.0;
    private boolean fixMapScale = false;
    private int zoomLevel = 1;
    private double _XYScaleFactor = 1.0;
    private Color _selectColor = Color.yellow;
    private boolean _isGeoMap = true;
    private boolean _isLayoutMap = false;
    private final ProjectionSet _projection = new ProjectionSet();
    private MouseTools _mouseTool = MouseTools.None;
    private VectorLayer _lonLatLayer = null;
    private GraphicCollection _graphicCollection = new GraphicCollection();
    private final GraphicCollection _selectedGraphics = new GraphicCollection();
    private GraphicCollection _visibleGraphics = new GraphicCollection();
    private java.awt.Rectangle _selectedRectangle = new java.awt.Rectangle();
    private Edge _resizeSelectedEdge = Edge.None;
    private java.awt.Rectangle _resizeRectangle = new java.awt.Rectangle();
    public boolean _drawIdentiferShape = false;
    private boolean _mouseDoubleClicked = false;
    Point _mouseDownPoint = new Point(0, 0);
    Point _mouseLastPos = new Point(0, 0);
    Point _mousePos = new Point(0, 0);
    private int _xShift = 0;
    private int _yShift = 0;
    private double _paintScale = 1.0;
    private MaskOut _maskOut;
    private GeneralPath _maskOutGraphicsPath = new GeneralPath();
    private FrmPointSymbolSet _frmPointSymbolSet = null;
    private FrmPolylineSymbolSet _frmPolylineSymbolSet = null;
    private FrmPolygonSymbolSet _frmPolygonSymbolSet = null;
    private FrmLabelSymbolSet _frmLabelSymbolSet = null;
    private boolean _startNewGraphic = true;
    private List<PointF> _graphicPoints = new ArrayList<PointF>();
    private PointBreak _defPointBreak = new PointBreak();
    private LabelBreak _defLabelBreak = new LabelBreak();
    private PolylineBreak _defPolylineBreak = new PolylineBreak();
    private PolygonBreak _defPolygonBreak = new PolygonBreak();
    private final List<org.meteoinfo.global.PointD> _editingVertices = new ArrayList<org.meteoinfo.global.PointD>();
    private int _editingVerticeIndex;
    private boolean _dragMode = false;
    private boolean _multiGlobalDraw = true;
    private List<String> _xGridStrs = new ArrayList<String>();
    private List<String> _yGridStrs = new ArrayList<String>();
    private final List<Object[]> _xGridPosLabel = new ArrayList<Object[]>();
    private final List<Object[]> _yGridPosLabel = new ArrayList<Object[]>();
    private boolean _drawGridTickLine = false;
    private Color _gridLineColor = Color.gray;
    private float _gridLineSize = 1.0f;
    private LineStyles _gridLineStyle = LineStyles.DASH;
    private boolean _drawGridLine = false;
    private double _gridXDelt = 10.0;
    private double _gridYDelt = 10.0;
    private float _gridXOrigin = -180.0f;
    private float _gridYOrigin = -90.0f;
    private boolean _gridDeltChanged = false;
    private List<GridLabel> _gridLabels = new ArrayList<GridLabel>();
    private LocalDateTime _lastMouseWheelTime;
    private Timer _mouseWheelDetctionTimer;

    public MapView() {
        this.setSize(200, 200);
        this.setDoubleBuffered(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MapView.this.onComponentResized(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MapView.this.onMouseClicked(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MapView.this.onMousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MapView.this.onMouseReleased(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                MapView.this.onMouseMoved(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                MapView.this.onMouseDragged(e);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                MapView.this.onMouseWheelMoved(e);
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                MapView.this.onKeyTyped(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
                MapView.this.onKeyPressed(e);
            }

            @Override
            public void keyReleased(KeyEvent e) {
                MapView.this.onKeyReleased(e);
            }
        });
        this._mouseWheelDetctionTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LocalDateTime now = LocalDateTime.now();
                if (Duration.between(MapView.this._lastMouseWheelTime, now).toMillis() > 200L) {
                    MapView.this._xShift = 0;
                    MapView.this._yShift = 0;
                    MapView.this._paintScale = 1.0;
                    MapView.this.repaintNew();
                    MapView.this._mouseWheelDetctionTimer.stop();
                }
            }
        });
        this.setBackground(new Color(255, 255, 255, 0));
        this._maskOut = new MaskOut(this);
        this._mouseTool = MouseTools.None;
        this._viewExtent.minX = -180.0;
        this._viewExtent.maxX = 180.0;
        this._viewExtent.minY = -90.0;
        this._viewExtent.maxY = 90.0;
        this._drawExtent = (Extent)this._viewExtent.clone();
        this._scaleX = 1.0;
        this._scaleY = 1.0;
        this._selectColor = Color.yellow;
        this._defPointBreak.setSize(10.0f);
        this._defLabelBreak.setText("Text");
        this._defLabelBreak.setFont(new Font(GlobalUtil.getDefaultFontName(), 0, 12));
        this._defPolylineBreak.setColor(Color.red);
        this._defPolylineBreak.setWidth(2.0f);
        this._defPolygonBreak.setColor(new Color(104, 255, 104, 125));
    }

    public MapView(ProjectionInfo proj) {
        this();
        this._projection.setProjInfo(proj);
    }

    public boolean isDoubleBuffer() {
        return this.doubleBuffer;
    }

    public void setDoubleBuffer(boolean value) {
        this.doubleBuffer = value;
    }

    public void setTileLoadListener(TileLoadListener value) {
        this.tileLoadListener = value;
    }

    public LayerCollection getLayers() {
        return this.layers;
    }

    public void setLayers(LayerCollection layers) {
        this.layers = layers;
    }

    public int getLayerNum() {
        return this.layers.size();
    }

    public int getSelectedLayerHandle() {
        return this._selectedLayer;
    }

    public void setSelectedLayerHandle(int handle) {
        this._selectedLayer = handle;
    }

    public MapLayer getLastAddedLayer() {
        int hnd = 0;
        for (MapLayer layer : this.layers) {
            if (layer.getHandle() <= hnd) continue;
            hnd = layer.getHandle();
        }
        return this.getLayerByHandle(hnd);
    }

    public boolean isLayoutMap() {
        return this._isLayoutMap;
    }

    public void setIsLayoutMap(boolean istrue) {
        this._isLayoutMap = istrue;
    }

    public boolean isGeoMap() {
        return this._isGeoMap;
    }

    public void setGeoMap(boolean value) {
        this._isGeoMap = value;
    }

    public Extent getExtent() {
        return this._extent;
    }

    public void setExtent(Extent extent) {
        this._extent = extent;
    }

    public Extent getViewExtent() {
        return this._viewExtent;
    }

    public void setViewExtent(Extent extent) {
        this._viewExtent = (Extent)extent.clone();
        this._drawExtent = (Extent)this._viewExtent.clone();
        if (this._isGeoMap) {
            this.setCoordinateGeoMap(extent, this.getWidth(), this.getHeight());
        } else {
            this.setCoordinateMap(extent, this.getWidth(), this.getHeight());
        }
    }

    public Color getSelectColor() {
        return this._selectColor;
    }

    public void setSelectColor(Color color) {
        this._selectColor = color;
    }

    public boolean isMultiGlobalDraw() {
        return this._multiGlobalDraw;
    }

    public void setMultiGlobalDraw(boolean istrue) {
        this._multiGlobalDraw = istrue;
    }

    public double getXScale() {
        return this._scaleX;
    }

    public double getYScale() {
        return this._scaleY;
    }

    public double getXYScaleFactor() {
        return this._XYScaleFactor;
    }

    public void setXYScaleFactor(double value) {
        this._XYScaleFactor = value;
        if (this._XYScaleFactor < 0.5 || this._XYScaleFactor > 2.0) {
            this._XYScaleFactor = 1.0;
        }
        this.zoomToExtent(this._drawExtent);
    }

    public MouseTools getMouseTool() {
        return this._mouseTool;
    }

    public void setMouseTool(MouseTools mt) {
        this._mouseTool = mt;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Cursor customCursor = Cursor.getPredefinedCursor(0);
        switch (mt) {
            case Zoom_In: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/zoom_in_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Zoom In");
                break;
            }
            case Zoom_Out: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/zoom_out_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Zoom Out");
                break;
            }
            case Pan: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/Pan_Open_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Pan");
                break;
            }
            case Identifer: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/identifer_32x32x32.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(8, 8), "Identifer");
                break;
            }
            case SelectFeatures_Rectangle: {
                customCursor = Cursor.getPredefinedCursor(1);
                break;
            }
            case Edit_Tool: 
            case Edit_FeatureVertices: {
                Image image = toolkit.getImage(this.getClass().getResource("/images/Edit_tool.png"));
                customCursor = toolkit.createCustomCursor(image, new Point(2, 2), "Edit Tool");
                break;
            }
            case New_Label: 
            case New_Point: 
            case New_Polygon: 
            case New_Polyline: 
            case New_Rectangle: 
            case New_Circle: 
            case New_Curve: 
            case New_CurvePolygon: 
            case New_Ellipse: 
            case New_Freehand: 
            case Edit_NewFeature: 
            case Edit_AddRing: 
            case Edit_FillRing: 
            case Edit_ReformFeature: 
            case Edit_SplitFeature: {
                customCursor = Cursor.getPredefinedCursor(1);
                break;
            }
            case Measurement: {
                customCursor = Cursor.getPredefinedCursor(1);
            }
        }
        this.setCursor(customCursor);
    }

    public ProjectionSet getProjection() {
        return this._projection;
    }

    public boolean isLockViewUpdate() {
        return this._lockViewUpdate;
    }

    public void setLockViewUpdate(boolean istrue) {
        this._lockViewUpdate = istrue;
    }

    public boolean isAntiAlias() {
        return this._antiAlias;
    }

    public void setAntiAlias(boolean istrue) {
        this._antiAlias = istrue;
        if (this._antiAlias) {
            this._pointAntiAlias = true;
        }
    }

    public boolean isPointAntiAlias() {
        return this._pointAntiAlias;
    }

    public void setPointAntiAlias(boolean value) {
        this._pointAntiAlias = value;
    }

    public boolean isHighSpeedWheelZoom() {
        return this._highSpeedWheelZoom;
    }

    public void setHighSpeedWheelZoom(boolean value) {
        this._highSpeedWheelZoom = value;
    }

    public GraphicCollection getSelectedGraphics() {
        return this._selectedGraphics;
    }

    public PointBreak getDefPointBreak() {
        return this._defPointBreak;
    }

    public void setDefPointBreak(PointBreak pb) {
        this._defPointBreak = pb;
    }

    public LabelBreak getDefLabelBreak() {
        return this._defLabelBreak;
    }

    public void setDefLabelBreak(LabelBreak lb) {
        this._defLabelBreak = lb;
    }

    public PolylineBreak getDefPolylineBreak() {
        return this._defPolylineBreak;
    }

    public void setDefPolylineBreak(PolylineBreak pb) {
        this._defPolylineBreak = pb;
    }

    public PolygonBreak getDefPolygonBreak() {
        return this._defPolygonBreak;
    }

    public void setDefPolygonBreak(PolygonBreak pb) {
        this._defPolygonBreak = pb;
    }

    public boolean isDrawIdentiferShape() {
        return this._drawIdentiferShape;
    }

    public void setDrawIdentiferShape(boolean istrue) {
        this._drawIdentiferShape = istrue;
    }

    public boolean isDrawGridTickLine() {
        return this._drawGridTickLine;
    }

    public void setDrawGridTickLine(boolean istrue) {
        this._drawGridTickLine = istrue;
    }

    public List<GridLabel> getGridLabels() {
        return this._gridLabels;
    }

    public Color getGridLineColor() {
        return this._gridLineColor;
    }

    public void setGridLineColor(Color color) {
        this._gridLineColor = color;
    }

    public float getGridLineSize() {
        return this._gridLineSize;
    }

    public void setGridLineSize(float size) {
        this._gridLineSize = size;
    }

    public LineStyles getGridLineStyle() {
        return this._gridLineStyle;
    }

    public void setGridLineStyle(LineStyles style) {
        this._gridLineStyle = style;
    }

    public boolean isDrawGridLine() {
        return this._drawGridLine;
    }

    public void setDrawGridLine(boolean istrue) {
        this._drawGridLine = istrue;
    }

    public double getGridXDelt() {
        return this._gridXDelt;
    }

    public void setGridXDelt(double delt) {
        this._gridXDelt = delt;
        this._gridDeltChanged = true;
    }

    public double getGridYDelt() {
        return this._gridYDelt;
    }

    public void setGridYDelt(double delt) {
        this._gridYDelt = delt;
        this._gridDeltChanged = true;
    }

    public float getGridXOrigin() {
        return this._gridXOrigin;
    }

    public void setGridXOrigin(float origin) {
        this._gridXOrigin = origin;
        this._gridDeltChanged = true;
    }

    public float getGridYOrigin() {
        return this._gridYOrigin;
    }

    public void setGridYOrigin(float origin) {
        this._gridYOrigin = origin;
        this._gridDeltChanged = true;
    }

    public List<String> getXGridStrs() {
        return this._xGridStrs;
    }

    public void setXGridStrs(List<String> value) {
        this._xGridStrs = value;
    }

    public List<String> getYGridStrs() {
        return this._yGridStrs;
    }

    public void setYGridStrs(List<String> value) {
        this._yGridStrs = value;
    }

    public GraphicCollection getGraphicCollection() {
        return this._graphicCollection;
    }

    public void setGraphicCollection(GraphicCollection aGCollection) {
        this._graphicCollection = aGCollection;
    }

    public VectorLayer getLonLatLayer() {
        return this._lonLatLayer;
    }

    public void setLonLatLayer(VectorLayer layer) {
        this._lonLatLayer = layer;
    }

    public FrmMeasurement getMeasurementForm() {
        return this._frmMeasure;
    }

    public void setMeasurementForm(FrmMeasurement form) {
        this._frmMeasure = form;
    }

    public MaskOut getMaskOut() {
        return this._maskOut;
    }

    public void setMaskOut(MaskOut value) {
        this._maskOut = value;
    }

    public BufferedImage getViewImage() {
        return this._mapBitmap;
    }

    public void addViewExtentChangedListener(IViewExtentChangedListener listener) {
        this._listeners.add(IViewExtentChangedListener.class, listener);
    }

    public void removeViewExtentChangedListener(IViewExtentChangedListener listener) {
        this._listeners.remove(IViewExtentChangedListener.class, listener);
    }

    public void fireViewExtentChangedEvent() {
        this.fireViewExtentChangedEvent(new ViewExtentChangedEvent(this));
    }

    private void fireViewExtentChangedEvent(ViewExtentChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IViewExtentChangedListener.class) continue;
            ((IViewExtentChangedListener)listeners[i + 1]).viewExtentChangedEvent(event);
        }
    }

    public void addUndoEditListener(IUndoEditListener listener) {
        this._listeners.add(IUndoEditListener.class, listener);
    }

    public void removeUndoEditListener(IUndoEditListener listener) {
        this._listeners.remove(IUndoEditListener.class, listener);
    }

    public void fireUndoEditEvent(UndoableEdit undoEdit) {
        this.fireUndoEditEvent(new UndoEditEvent(this), undoEdit);
    }

    private void fireUndoEditEvent(UndoEditEvent event, UndoableEdit undoEdit) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IUndoEditListener.class) continue;
            ((IUndoEditListener)listeners[i + 1]).undoEditEvent(event, undoEdit);
        }
    }

    public void addLayersUpdatedListener(ILayersUpdatedListener listener) {
        this._listeners.add(ILayersUpdatedListener.class, listener);
    }

    public void removeLayersUpdatedListener(ILayersUpdatedListener listener) {
        this._listeners.remove(ILayersUpdatedListener.class, listener);
    }

    public void fireLayersUpdatedEvent() {
        this.fireLayersUpdatedEvent(new LayersUpdatedEvent(this));
    }

    private void fireLayersUpdatedEvent(LayersUpdatedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != ILayersUpdatedListener.class) continue;
            ((ILayersUpdatedListener)listeners[i + 1]).layersUpdatedEvent(event);
        }
    }

    public void addGraphicSelectedListener(IGraphicSelectedListener listener) {
        this._listeners.add(IGraphicSelectedListener.class, listener);
    }

    public void removeGraphicSelectedListener(IGraphicSelectedListener listener) {
        this._listeners.remove(IGraphicSelectedListener.class, listener);
    }

    public void fireGraphicSelectedEvent() {
        this.fireGraphicSelectedEvent(new GraphicSelectedEvent(this));
    }

    private void fireGraphicSelectedEvent(GraphicSelectedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IGraphicSelectedListener.class) continue;
            ((IGraphicSelectedListener)listeners[i + 1]).graphicSelectedEvent(event);
        }
    }

    public void addShapeSelectedListener(IShapeSelectedListener listener) {
        this._listeners.add(IShapeSelectedListener.class, listener);
    }

    public void removeShapeSelectedListener(IShapeSelectedListener listener) {
        this._listeners.remove(IShapeSelectedListener.class, listener);
    }

    public void fireShapeSelectedEvent() {
        this.repaintNew();
        this.fireShapeSelectedEvent(new ShapeSelectedEvent(this));
    }

    private void fireShapeSelectedEvent(ShapeSelectedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IShapeSelectedListener.class) continue;
            ((IShapeSelectedListener)listeners[i + 1]).shapeSelectedEvent(event);
        }
    }

    public void addProjectionChangedListener(IProjectionChangedListener listener) {
        this._listeners.add(IProjectionChangedListener.class, listener);
    }

    public void removeViewExtentChangedListener(IProjectionChangedListener listener) {
        this._listeners.remove(IProjectionChangedListener.class, listener);
    }

    public void fireProjectionChangedEvent() {
        this.fireProjectionChangedEvent(new ProjectionChangedEvent(this));
    }

    private void fireProjectionChangedEvent(ProjectionChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IProjectionChangedListener.class) continue;
            ((IProjectionChangedListener)listeners[i + 1]).projectionChangedEvent(event);
        }
    }

    void onComponentResized(ComponentEvent e) {
        this.zoomToExtent(this.getViewExtent());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void onMousePressed(MouseEvent e) {
        block47: {
            block48: {
                if (e.getButton() != 1) break block48;
                Graphics2D g = (Graphics2D)this.getGraphics();
                switch (this._mouseTool) {
                    case Zoom_In: {
                        break;
                    }
                    case Pan: {
                        break;
                    }
                    case Edit_Tool: {
                        VectorLayer layer = (VectorLayer)this.getSelectedLayer();
                        List<Shape> selShapes = layer.getSelectedShapes();
                        if (selShapes.size() <= 0) break;
                        float burf = 2.5f;
                        Rectangle2D.Float selExtent = new Rectangle2D.Float((float)e.getX() - burf, (float)e.getY() - burf, burf * 2.0f, burf * 2.0f);
                        List<Integer> idxs = this.selectShapes(layer, selShapes, selExtent, true, false);
                        if (idxs.size() > 0) {
                            Rectangle2D.Double dRect = this.projToScreen(layer.getShapes().get(idxs.get(0)).getExtent(), 0.0);
                            this._selectedRectangle = dRect.width > 5.0 ? new java.awt.Rectangle((int)dRect.x, (int)dRect.y, (int)dRect.width, (int)dRect.height) : new java.awt.Rectangle((int)dRect.x - 5, (int)dRect.y - 5, (int)dRect.width + 10, (int)dRect.height + 10);
                            this._mouseTool = MouseTools.Edit_MoveSelection;
                            break;
                        }
                        break block47;
                    }
                    case SelectElements: {
                        PointF mousePoint = new PointF();
                        mousePoint.X = e.getX();
                        mousePoint.Y = e.getY();
                        double lonShift = 0.0;
                        GraphicCollection tempGraphics = new GraphicCollection();
                        if (this.selectGraphics(mousePoint, this._selectedGraphics, tempGraphics, lonShift, 3)) {
                            this._resizeRectangle = this._selectedRectangle = this.getGraphicRectangle(g, this._selectedGraphics.get(0), lonShift);
                            if (this._resizeSelectedEdge == Edge.None) {
                                this._mouseTool = MouseTools.MoveSelection;
                                break;
                            }
                            this._mouseTool = MouseTools.ResizeSelection;
                            break;
                        }
                        this._mouseTool = MouseTools.CreateSelection;
                        break;
                    }
                    case New_Point: {
                        PointShape aPS = new PointShape();
                        float[] pXY = this.screenToProj(e.getX(), e.getY());
                        aPS.setPoint(new org.meteoinfo.global.PointD(pXY[0], pXY[1]));
                        Graphic aGraphic = new Graphic();
                        aGraphic.setShape(aPS);
                        aGraphic.setLegend((PointBreak)this._defPointBreak.clone());
                        this._graphicCollection.add(aGraphic);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        this.drawGraphic(g, aGraphic, 0.0);
                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                        Objects.requireNonNull(mapViewUndoRedo);
                        MapViewUndoRedo.AddGraphicEdit edit = new MapViewUndoRedo.AddGraphicEdit(mapViewUndoRedo, this, aGraphic);
                        this.fireUndoEditEvent(edit);
                        break;
                    }
                    case New_Label: {
                        float[] pXY = this.screenToProj(e.getX(), e.getY());
                        PointShape aPS = new PointShape();
                        aPS.setPoint(new org.meteoinfo.global.PointD(pXY[0], pXY[1]));
                        Graphic aGraphic = new Graphic(aPS, (LabelBreak)this._defLabelBreak.clone());
                        this._graphicCollection.add(aGraphic);
                        this.drawGraphic(g, aGraphic, 0.0);
                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                        Objects.requireNonNull(mapViewUndoRedo);
                        MapViewUndoRedo.AddGraphicEdit edit = new MapViewUndoRedo.AddGraphicEdit(mapViewUndoRedo, this, aGraphic);
                        this.fireUndoEditEvent(edit);
                        break;
                    }
                    case Edit_NewFeature: {
                        MapLayer selLayer = this.getSelectedLayer();
                        if (selLayer == null || selLayer.getLayerType() != LayerTypes.VectorLayer) break;
                        VectorLayer layer = (VectorLayer)selLayer;
                        if (layer.getShapeType().isPoint()) {
                            float[] pXY = this.screenToProj(e.getX(), e.getY());
                            PointShape aPS = new PointShape();
                            switch (layer.getShapeType()) {
                                case Point: {
                                    aPS.setPoint(new org.meteoinfo.global.PointD(pXY[0], pXY[1]));
                                    break;
                                }
                                case PointZ: {
                                    aPS = new PointZShape();
                                    aPS.setPoint(new PointZ(pXY[0], pXY[1], 0.0, 0.0));
                                    break;
                                }
                            }
                            try {
                                layer.editAddShape(aPS);
                                this.repaintNew();
                                MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                Objects.requireNonNull(mapViewUndoRedo);
                                MapViewUndoRedo.AddFeatureEdit edit = new MapViewUndoRedo.AddFeatureEdit(mapViewUndoRedo, this, layer, aPS);
                                layer.getUndoManager().addEdit(edit);
                                this.fireUndoEditEvent(edit);
                            }
                            catch (Exception ex) {
                                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            break block47;
                        } else {
                            org.meteoinfo.global.PointD snapP;
                            if (this._startNewGraphic) {
                                this._graphicPoints = new ArrayList<PointF>();
                                this._startNewGraphic = false;
                            }
                            if ((snapP = this.selectSnapVertice(this._mouseLastPos, layer, 10)) != null) {
                                double[] screenP = this.projToScreen(snapP.X, snapP.Y);
                                this._graphicPoints.add(new PointF((float)screenP[0], (float)screenP[1]));
                                break;
                            }
                            this._graphicPoints.add(new PointF(e.getX(), e.getY()));
                            break;
                        }
                    }
                    case New_Polygon: 
                    case New_Polyline: 
                    case New_Curve: 
                    case New_CurvePolygon: 
                    case New_Freehand: 
                    case Edit_AddRing: 
                    case Edit_FillRing: 
                    case Edit_ReformFeature: 
                    case Edit_SplitFeature: 
                    case SelectFeatures_Polygon: 
                    case SelectFeatures_Lasso: {
                        if (this._startNewGraphic) {
                            this._graphicPoints = new ArrayList<PointF>();
                            this._startNewGraphic = false;
                        }
                        this._graphicPoints.add(new PointF(e.getX(), e.getY()));
                        break;
                    }
                    case Edit_FeatureVertices: {
                        VectorLayer layer = (VectorLayer)this.getSelectedLayer();
                        Shape eShape = layer.getEditingShape();
                        if (eShape == null || !eShape.isEditing()) break;
                        this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), eShape, this._editingVertices);
                        if (this._editingVerticeIndex < 0) break;
                        this._mouseTool = MouseTools.Edit_InEditingVertices;
                        break;
                    }
                    case EditVertices: {
                        if (this._selectedGraphics.size() <= 0) break;
                        this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), this._selectedGraphics.get(0).getShape(), this._editingVertices);
                        if (this._editingVerticeIndex < 0) break;
                        this._mouseTool = MouseTools.InEditingVertices;
                        break;
                    }
                    case Measurement: {
                        if (this._frmMeasure == null || !this._frmMeasure.isVisible()) break;
                        switch (this._frmMeasure.getMeasureType()) {
                            case Length: 
                            case Area: {
                                if (this._startNewGraphic) {
                                    this._graphicPoints = new ArrayList<PointF>();
                                    this._startNewGraphic = false;
                                }
                                this._frmMeasure.setPreviousValue(this._frmMeasure.getTotalValue());
                                this._graphicPoints.add(new PointF(e.getX(), e.getY()));
                                break;
                            }
                            case Feature: {
                                PointF aPoint;
                                List<Integer> selectedShapes;
                                VectorLayer aLayer;
                                MapLayer aMLayer = this.getLayerByHandle(this._selectedLayer);
                                if (aMLayer == null || aMLayer.getLayerType() != LayerTypes.VectorLayer || (aLayer = (VectorLayer)aMLayer).getShapeType() == ShapeTypes.Point || (selectedShapes = this.selectShapes(aLayer, aPoint = new PointF(e.getX(), e.getY()))).size() <= 0) break;
                                Shape aShape = aLayer.getShapes().get(selectedShapes.get(0));
                                aLayer.setIdentiferShape(selectedShapes.get(0));
                                this._drawIdentiferShape = true;
                                this.repaintOld();
                                double value = 0.0;
                                switch (aShape.getShapeType()) {
                                    case Polyline: 
                                    case PolylineZ: {
                                        this._frmMeasure.setArea(false);
                                        double areaValue = 0.0;
                                        if (this._projection.isLonLatMap()) {
                                            value = GeoComputation.getDistance(((PolylineShape)aShape).getPoints(), true);
                                            if (((PolylineShape)aShape).isClosed()) {
                                                areaValue = GeoComputation.sphericalPolygonArea(aShape.getPoints());
                                            }
                                        } else {
                                            value = ((PolylineShape)aShape).getLength();
                                            value *= this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres();
                                            if (((PolylineShape)aShape).isClosed()) {
                                                areaValue = GeoComputation.getArea(aShape.getPoints());
                                            }
                                        }
                                        if (!((PolylineShape)aShape).isClosed()) break;
                                        this._frmMeasure.setAreaValue(areaValue *= this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres() * this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres());
                                        break;
                                    }
                                    case Polygon: 
                                    case PolygonM: 
                                    case PolygonZ: {
                                        this._frmMeasure.setArea(true);
                                        value = this._projection.isLonLatMap() ? ((PolygonShape)aShape).getSphericalArea() : ((PolygonShape)aShape).getArea();
                                        value *= this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres() * this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres();
                                        break;
                                    }
                                }
                                this._frmMeasure.setCurrentValue(value);
                            }
                        }
                        break block47;
                    }
                }
                break block47;
            }
            if (e.getButton() == 3) {
                switch (this._mouseTool) {
                    case Measurement: {
                        if (!this._frmMeasure.isVisible()) break;
                        switch (this._frmMeasure.getMeasureType()) {
                            case Length: 
                            case Area: {
                                this._startNewGraphic = true;
                                this._frmMeasure.setTotalValue(0.0);
                            }
                        }
                        break;
                    }
                }
            }
        }
        this._mouseDownPoint.x = e.getX();
        this._mouseDownPoint.y = e.getY();
        this._mouseLastPos = (Point)this._mouseDownPoint.clone();
    }

    void onMouseDragged(MouseEvent e) {
        this._dragMode = true;
        int deltaX = e.getX() - this._mouseLastPos.x;
        int deltaY = e.getY() - this._mouseLastPos.y;
        this._mouseLastPos.x = e.getX();
        this._mouseLastPos.y = e.getY();
        Graphics2D g = (Graphics2D)this.getGraphics();
        g.setColor(this.getForeground());
        switch (this._mouseTool) {
            case Zoom_In: {
                this.repaintOld();
                break;
            }
            case Pan: {
                this._xShift = e.getX() - this._mouseDownPoint.x;
                this._yShift = e.getY() - this._mouseDownPoint.y;
                this.repaintOld();
                break;
            }
            case SelectFeatures_Rectangle: 
            case Edit_Tool: 
            case CreateSelection: {
                this.repaintOld();
                break;
            }
            case MoveSelection: 
            case Edit_MoveSelection: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                this.repaintOld();
                break;
            }
            case ResizeSelection: {
                Graphic aGraphic = this._selectedGraphics.get(0);
                if (this._selectedRectangle.width > 2 && this._selectedRectangle.height > 2) {
                    block10 : switch (aGraphic.getResizeAbility()) {
                        case SameWidthHeight: {
                            switch (this._resizeSelectedEdge) {
                                case TopLeft: {
                                    this._resizeRectangle.x += deltaX;
                                    this._resizeRectangle.y += deltaX;
                                    this._resizeRectangle.width -= deltaX;
                                    this._resizeRectangle.height -= deltaX;
                                    break block10;
                                }
                                case BottomRight: {
                                    this._resizeRectangle.width += deltaX;
                                    this._resizeRectangle.height += deltaX;
                                    break block10;
                                }
                                case TopRight: {
                                    this._resizeRectangle.y += deltaY;
                                    this._resizeRectangle.width -= deltaY;
                                    this._resizeRectangle.height -= deltaY;
                                    break block10;
                                }
                                case BottomLeft: {
                                    this._resizeRectangle.x += deltaX;
                                    this._resizeRectangle.width -= deltaX;
                                    this._resizeRectangle.height -= deltaX;
                                }
                            }
                            break;
                        }
                        case ResizeAll: {
                            switch (this._resizeSelectedEdge) {
                                case TopLeft: {
                                    this._resizeRectangle.x += deltaX;
                                    this._resizeRectangle.y += deltaY;
                                    this._resizeRectangle.width -= deltaX;
                                    this._resizeRectangle.height -= deltaY;
                                    break block10;
                                }
                                case BottomRight: {
                                    this._resizeRectangle.width += deltaX;
                                    this._resizeRectangle.height += deltaY;
                                    break block10;
                                }
                                case Top: {
                                    this._resizeRectangle.y += deltaY;
                                    this._resizeRectangle.height -= deltaY;
                                    break block10;
                                }
                                case Bottom: {
                                    this._resizeRectangle.height += deltaY;
                                    break block10;
                                }
                                case TopRight: {
                                    this._resizeRectangle.y += deltaY;
                                    this._resizeRectangle.width += deltaX;
                                    this._resizeRectangle.height -= deltaY;
                                    break block10;
                                }
                                case BottomLeft: {
                                    this._resizeRectangle.x += deltaX;
                                    this._resizeRectangle.width -= deltaX;
                                    this._resizeRectangle.height += deltaY;
                                    break block10;
                                }
                                case Left: {
                                    this._resizeRectangle.x += deltaX;
                                    this._resizeRectangle.width -= deltaX;
                                    break block10;
                                }
                                case Right: {
                                    this._resizeRectangle.width += deltaX;
                                }
                            }
                        }
                    }
                } else {
                    this._resizeRectangle.width = 3;
                    this._resizeRectangle.height = 3;
                }
                this.repaintOld();
                break;
            }
            case New_Rectangle: 
            case New_Circle: 
            case New_Ellipse: 
            case New_Freehand: 
            case SelectFeatures_Lasso: 
            case SelectFeatures_Circle: {
                this.repaintOld();
                break;
            }
            case InEditingVertices: {
                this.repaintOld();
                break;
            }
            case Edit_InEditingVertices: {
                VectorLayer layer = (VectorLayer)this.getSelectedLayer();
                org.meteoinfo.global.PointD snapP = this.selectSnapVertice(this._mouseLastPos, layer, 10);
                if (snapP != null) {
                    double[] screenP = this.projToScreen(snapP.X, snapP.Y);
                    this._mouseLastPos.x = (int)screenP[0];
                    this._mouseLastPos.y = (int)screenP[1];
                }
                this.repaintOld();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void onMouseMoved(MouseEvent e) {
        this._mouseLastPos.x = e.getX();
        this._mouseLastPos.y = e.getY();
        Graphics2D g = (Graphics2D)this.getGraphics();
        g.setColor(this.getForeground());
        block0 : switch (this._mouseTool) {
            case Edit_Tool: {
                VectorLayer layer = (VectorLayer)this.getSelectedLayer();
                List<Shape> selShapes = layer.getSelectedShapes();
                boolean isMove = false;
                if (selShapes.size() > 0) {
                    float burf = 2.5f;
                    Rectangle2D.Float selExtent = new Rectangle2D.Float((float)e.getX() - burf, (float)e.getY() - burf, burf * 2.0f, burf * 2.0f);
                    List<Integer> idxs = this.selectShapes(layer, selShapes, selExtent, true, false);
                    if (idxs.size() > 0) {
                        isMove = true;
                    }
                }
                if (isMove) {
                    this.setCursor(Cursor.getPredefinedCursor(13));
                    return;
                }
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Image image = toolkit.getImage(this.getClass().getResource("/images/Edit_tool.png"));
                this.setCursor(toolkit.createCustomCursor(image, new Point(2, 2), "Edit Tool"));
                return;
            }
            case SelectElements: {
                if (this._selectedGraphics.size() > 0) {
                    GraphicCollection tempGraphics = new GraphicCollection();
                    double lonShift = 0.0;
                    if (this.selectGraphics(new PointF(e.getX(), e.getY()), this._selectedGraphics, tempGraphics, lonShift, 3)) {
                        java.awt.Rectangle aRect = this.getGraphicRectangle(g, this._selectedGraphics.get(0), lonShift);
                        this._resizeSelectedEdge = MapView.intersectElementEdge(aRect, new PointF(e.getX(), e.getY()), 3.0f);
                        switch (this._selectedGraphics.get(0).getResizeAbility()) {
                            case SameWidthHeight: {
                                switch (this._resizeSelectedEdge) {
                                    case TopLeft: 
                                    case BottomRight: {
                                        this.setCursor(Cursor.getPredefinedCursor(6));
                                        return;
                                    }
                                    case TopRight: 
                                    case BottomLeft: {
                                        this.setCursor(Cursor.getPredefinedCursor(7));
                                        return;
                                    }
                                }
                                this.setCursor(Cursor.getPredefinedCursor(13));
                                return;
                            }
                            case ResizeAll: {
                                switch (this._resizeSelectedEdge) {
                                    case TopLeft: 
                                    case BottomRight: {
                                        this.setCursor(Cursor.getPredefinedCursor(6));
                                        return;
                                    }
                                    case Top: 
                                    case Bottom: {
                                        this.setCursor(Cursor.getPredefinedCursor(8));
                                        return;
                                    }
                                    case TopRight: 
                                    case BottomLeft: {
                                        this.setCursor(Cursor.getPredefinedCursor(7));
                                        return;
                                    }
                                    case Left: 
                                    case Right: {
                                        this.setCursor(Cursor.getPredefinedCursor(11));
                                        return;
                                    }
                                    case None: {
                                        this.setCursor(Cursor.getPredefinedCursor(13));
                                    }
                                }
                                return;
                            }
                        }
                        this.setCursor(Cursor.getPredefinedCursor(13));
                        return;
                    }
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            case Edit_NewFeature: 
            case Edit_AddRing: 
            case Edit_FillRing: 
            case Edit_ReformFeature: 
            case Edit_SplitFeature: {
                VectorLayer selLayer = (VectorLayer)this.getSelectedLayer();
                if (selLayer == null) {
                    return;
                }
                if (selLayer.getShapeType().isPoint()) return;
                switch (this._mouseTool) {
                    case Edit_NewFeature: {
                        org.meteoinfo.global.PointD snapP = this.selectSnapVertice(this._mouseLastPos, selLayer, 10);
                        if (snapP != null) {
                            double[] screenP = this.projToScreen(snapP.X, snapP.Y);
                            this._mouseLastPos.x = (int)screenP[0];
                            this._mouseLastPos.y = (int)screenP[1];
                            this.repaintOld();
                            return;
                        }
                        if (this._startNewGraphic) return;
                        this.repaintOld();
                        return;
                    }
                }
                if (this._startNewGraphic) return;
                this.repaintOld();
                return;
            }
            case New_Polygon: 
            case New_Polyline: 
            case New_Curve: 
            case New_CurvePolygon: 
            case New_Freehand: 
            case SelectFeatures_Polygon: {
                if (this._startNewGraphic) return;
                this.repaintOld();
                return;
            }
            case Edit_FeatureVertices: {
                VectorLayer selLayer = (VectorLayer)this.getSelectedLayer();
                if (selLayer == null) {
                    return;
                }
                Shape eShape = selLayer.getEditingShape();
                if (eShape == null || !eShape.isEditing()) return;
                this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), eShape, this._editingVertices);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (this._editingVerticeIndex >= 0) {
                    Image image = toolkit.getImage(this.getClass().getResource("/images/VertexEdit_32x32x32.png"));
                    this.setCursor(toolkit.createCustomCursor(image, new Point(8, 8), "Vertices edit"));
                    return;
                }
                if (this.isOnRing(new Point(e.getX(), e.getY()), eShape) >= 0) {
                    Image image = toolkit.getImage(this.getClass().getResource("/images/insert_vertice.png"));
                    this.setCursor(toolkit.createCustomCursor(image, new Point(8, 8), "Insert Vertice"));
                    return;
                }
                Image image = toolkit.getImage(this.getClass().getResource("/images/Edit_tool.png"));
                this.setCursor(toolkit.createCustomCursor(image, new Point(2, 2), "Edit Tool"));
                return;
            }
            case EditVertices: {
                if (this._selectedGraphics.size() <= 0) return;
                Shape eShape = this._selectedGraphics.get(0).getShape();
                this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), eShape, this._editingVertices);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                if (this._editingVerticeIndex >= 0) {
                    Image image = toolkit.getImage(this.getClass().getResource("/images/VertexEdit_32x32x32.png"));
                    this.setCursor(toolkit.createCustomCursor(image, new Point(8, 8), "Vertices edit"));
                    return;
                }
                if (this.isOnRing(new Point(e.getX(), e.getY()), eShape) >= 0) {
                    Image image = toolkit.getImage(this.getClass().getResource("/images/insert_vertice.png"));
                    this.setCursor(toolkit.createCustomCursor(image, new Point(8, 8), "Insert Vertice"));
                    return;
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            case Measurement: {
                if (this._frmMeasure == null || !this._frmMeasure.isVisible()) return;
                switch (this._frmMeasure.getMeasureType()) {
                    case Length: 
                    case Area: {
                        if (this._startNewGraphic) return;
                        this.repaintOld();
                        PointF[] fpoints = this._graphicPoints.toArray(new PointF[this._graphicPoints.size()]);
                        PointF[] points = new PointF[fpoints.length + 1];
                        System.arraycopy(fpoints, 0, points, 0, fpoints.length);
                        points[this._graphicPoints.size()] = new PointF(e.getX(), e.getY());
                        float[] pXY = this.screenToProj(e.getX(), e.getY());
                        if (this._frmMeasure.getMeasureType() == FrmMeasurement.MeasureTypes.Length) {
                            double dist;
                            float[] ppXY = this.screenToProj(this._mouseDownPoint.x, this._mouseDownPoint.y);
                            double dx = Math.abs(pXY[0] - ppXY[0]);
                            double dy = Math.abs(pXY[1] - ppXY[1]);
                            if (this._projection.isLonLatMap()) {
                                double y = (pXY[1] + ppXY[1]) / 2.0f;
                                double factor = Math.cos(y * Math.PI / 180.0);
                                dist = Math.sqrt((dx *= factor) * dx + dy * dy);
                                dist *= 111319.5;
                            } else {
                                dist = Math.sqrt(dx * dx + dy * dy);
                                dist *= this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres();
                            }
                            this._frmMeasure.setCurrentValue(dist);
                            break block0;
                        }
                        ArrayList<org.meteoinfo.global.PointD> mPoints = new ArrayList<org.meteoinfo.global.PointD>();
                        for (PointF point : points) {
                            pXY = this.screenToProj(point.X, point.Y);
                            mPoints.add(new org.meteoinfo.global.PointD(pXY[0], pXY[1]));
                        }
                        double area = GeoComputation.getArea(mPoints);
                        area = this._projection.isLonLatMap() ? area * 111319.5 * 111319.5 : (area *= this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres() * this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getFromMetres());
                        this._frmMeasure.setCurrentValue(area);
                    }
                }
            }
        }
    }

    void onMouseReleased(MouseEvent e) {
        this._dragMode = false;
        double lonRan = this._drawExtent.maxX - this._drawExtent.minX;
        double latRan = this._drawExtent.maxY - this._drawExtent.minY;
        double mouseLon = this._drawExtent.minX + (double)e.getX() / this._scaleX;
        double mouseLat = this._drawExtent.maxY - (double)e.getY() / this._scaleY;
        this._mousePos.x = e.getX();
        this._mousePos.y = e.getY();
        switch (this._mouseTool) {
            case Zoom_In: {
                double MaxY;
                double MinY;
                double MaxX;
                double MinX;
                if (Math.abs(this._mousePos.x - this._mouseDownPoint.x) > 5) {
                    double ZoomF = (double)Math.abs(this._mousePos.x - this._mouseDownPoint.x) / (double)this.getWidth();
                    double ZoomFY = (double)Math.abs(this._mousePos.y - this._mouseDownPoint.y) / (double)this.getHeight();
                    if (this._isGeoMap) {
                        if (ZoomF < ZoomFY) {
                            ZoomF = ZoomFY;
                        } else {
                            ZoomFY = ZoomF;
                        }
                    }
                    mouseLon = this._drawExtent.minX + (double)(this._mouseDownPoint.x + (this._mousePos.x - this._mouseDownPoint.x) / 2) / this._scaleX;
                    mouseLat = this._drawExtent.maxY - (double)(this._mouseDownPoint.y + (this._mousePos.y - this._mouseDownPoint.y) / 2) / this._scaleY;
                    MinX = mouseLon - lonRan / 2.0 * ZoomF;
                    MaxX = mouseLon + lonRan / 2.0 * ZoomF;
                    MinY = mouseLat - latRan / 2.0 * ZoomFY;
                    MaxY = mouseLat + latRan / 2.0 * ZoomFY;
                } else {
                    double ZoomF = e.getButton() == 1 ? 0.75 : 1.5;
                    MinX = mouseLon - lonRan / 2.0 * ZoomF;
                    MaxX = mouseLon + lonRan / 2.0 * ZoomF;
                    MinY = mouseLat - latRan / 2.0 * ZoomF;
                    MaxY = mouseLat + latRan / 2.0 * ZoomF;
                }
                if (!(MaxX - MinX > 0.001)) break;
                this.zoomToExtent(MinX, MaxX, MinY, MaxY);
                break;
            }
            case Zoom_Out: {
                double ZoomF = e.getButton() == 1 ? 1.5 : 0.75;
                double MinX = mouseLon - lonRan / 2.0 * ZoomF;
                double MaxX = mouseLon + lonRan / 2.0 * ZoomF;
                double MinY = mouseLat - latRan / 2.0 * ZoomF;
                double MaxY = mouseLat + latRan / 2.0 * ZoomF;
                this.zoomToExtent(MinX, MaxX, MinY, MaxY);
                break;
            }
            case Pan: {
                if (e.getButton() != 1) break;
                this._xShift = 0;
                this._yShift = 0;
                double lon = this._drawExtent.minX + (double)this._mouseDownPoint.x / this._scaleX;
                double lat = this._drawExtent.maxY - (double)this._mouseDownPoint.y / this._scaleY;
                double MinX = this._drawExtent.minX - (mouseLon - lon);
                double MaxX = this._drawExtent.maxX - (mouseLon - lon);
                double MinY = this._drawExtent.minY - (mouseLat - lat);
                double MaxY = this._drawExtent.maxY - (mouseLat - lat);
                this.zoomToExtent(MinX, MaxX, MinY, MaxY);
                break;
            }
            case SelectFeatures_Rectangle: 
            case Edit_Tool: {
                Rectangle2D.Float rect;
                if (e.getButton() != 1) break;
                if (this._selectedLayer < 0) {
                    return;
                }
                MapLayer aMLayer = this.getLayerByHandle(this._selectedLayer);
                if (aMLayer == null) {
                    return;
                }
                if (aMLayer.getLayerType() != LayerTypes.VectorLayer) {
                    return;
                }
                VectorLayer aLayer = (VectorLayer)aMLayer;
                boolean isPointSel = false;
                if (Math.abs(e.getX() - this._mouseDownPoint.x) > 5 || Math.abs(e.getY() - this._mouseDownPoint.y) > 5) {
                    int minx = Math.min(this._mouseDownPoint.x, e.getX());
                    int miny = Math.min(this._mouseDownPoint.y, e.getY());
                    int width = Math.abs(e.getX() - this._mouseDownPoint.x);
                    int height = Math.abs(e.getY() - this._mouseDownPoint.y);
                    rect = new Rectangle2D.Float(minx, miny, width, height);
                } else {
                    float b = 2.5f;
                    float minx = (float)e.getX() - b;
                    float miny = (float)e.getY() - b;
                    float width = b * 2.0f;
                    float height = b * 2.0f;
                    rect = new Rectangle2D.Float(minx, miny, width, height);
                    isPointSel = true;
                }
                List<Integer> selectedShapes = this.selectShapes(aLayer, rect);
                if (!e.isControlDown() && !e.isShiftDown()) {
                    aLayer.clearSelectedShapes();
                }
                if (selectedShapes.size() > 0) {
                    if (isPointSel) {
                        Shape shape;
                        shape.setSelected(!(shape = aLayer.getShapes().get(selectedShapes.get(selectedShapes.size() - 1))).isSelected());
                    } else {
                        for (int shapeIdx : selectedShapes) {
                            Shape shape;
                            shape.setSelected(!(shape = aLayer.getShapes().get(shapeIdx)).isSelected());
                        }
                    }
                } else {
                    this.repaintNew();
                }
                this.fireShapeSelectedEvent();
                break;
            }
            case CreateSelection: {
                if (e.getButton() == 1) {
                    if (!e.isControlDown() && !e.isShiftDown()) {
                        for (Graphic aGraphic : this._selectedGraphics.getGraphics()) {
                            aGraphic.getShape().setSelected(false);
                        }
                        this._selectedGraphics.clear();
                    }
                    if (Math.abs(e.getX() - this._mouseDownPoint.x) > 5 || Math.abs(e.getY() - this._mouseDownPoint.y) > 5) {
                        double lonShift;
                        GraphicCollection tempGraphics;
                        int height;
                        int width;
                        int miny;
                        int minx = Math.min(this._mouseDownPoint.x, e.getX());
                        java.awt.Rectangle rect = new java.awt.Rectangle(minx, miny = Math.min(this._mouseDownPoint.y, e.getY()), width = Math.abs(e.getX() - this._mouseDownPoint.x), height = Math.abs(e.getY() - this._mouseDownPoint.y));
                        if (this.selectGraphics(rect, tempGraphics = new GraphicCollection(), lonShift = 0.0)) {
                            if (!e.isControlDown() && !e.isShiftDown()) {
                                for (Graphic aGraphic : tempGraphics.getGraphics()) {
                                    aGraphic.getShape().setSelected(true);
                                    this._selectedGraphics.add(aGraphic);
                                }
                            } else {
                                for (Graphic aGraphic : tempGraphics.getGraphics()) {
                                    aGraphic.getShape().setSelected(!aGraphic.getShape().isSelected());
                                    if (aGraphic.getShape().isSelected()) {
                                        this._selectedGraphics.add(aGraphic);
                                        continue;
                                    }
                                    this._selectedGraphics.remove(aGraphic);
                                }
                            }
                        }
                        this.repaintNew();
                        return;
                    }
                    PointF mousePoint = new PointF(this._mouseDownPoint.x, this._mouseDownPoint.y);
                    GraphicCollection tempGraphics = new GraphicCollection();
                    double lonShift = 0.0;
                    if (this.selectGraphics(mousePoint, tempGraphics, lonShift)) {
                        Graphic aGraphic = tempGraphics.get(0);
                        if (!e.isControlDown() && !e.isShiftDown()) {
                            aGraphic.getShape().setSelected(true);
                            this._selectedGraphics.add(aGraphic);
                        } else {
                            aGraphic.getShape().setSelected(!aGraphic.getShape().isSelected());
                            if (aGraphic.getShape().isSelected()) {
                                this._selectedGraphics.add(aGraphic);
                            } else {
                                this._selectedGraphics.remove(aGraphic);
                            }
                        }
                        switch (aGraphic.getLegend().getBreakType()) {
                            case PointBreak: {
                                if (this._frmPointSymbolSet == null || !this._frmPointSymbolSet.isVisible()) break;
                                this._frmPointSymbolSet.setPointBreak((PointBreak)aGraphic.getLegend());
                                break;
                            }
                            case LabelBreak: {
                                if (this._frmLabelSymbolSet == null || !this._frmLabelSymbolSet.isVisible()) break;
                                this._frmLabelSymbolSet.setLabelBreak((LabelBreak)aGraphic.getLegend());
                                break;
                            }
                            case PolylineBreak: {
                                if (this._frmPolylineSymbolSet == null || !this._frmPolylineSymbolSet.isVisible()) break;
                                this._frmPolylineSymbolSet.setPolylineBreak((PolylineBreak)aGraphic.getLegend());
                                break;
                            }
                            case PolygonBreak: {
                                if (this._frmPolygonSymbolSet == null || !this._frmPolygonSymbolSet.isVisible()) break;
                                this._frmPolygonSymbolSet.setPolygonBreak((PolygonBreak)aGraphic.getLegend());
                            }
                        }
                    }
                    this.fireGraphicSelectedEvent();
                    this.repaintNew();
                }
                this._mouseTool = MouseTools.SelectElements;
                break;
            }
            case Edit_MoveSelection: {
                VectorLayer slayer = (VectorLayer)this.getSelectedLayer();
                List<Shape> selShapes = slayer.getSelectedShapes();
                if (selShapes.size() > 0) {
                    for (Shape shape : selShapes) {
                        this.moveShapeOnScreen(shape, this._mouseDownPoint, new Point(e.getX(), e.getY()));
                    }
                    slayer.updateExtent();
                    this.repaintNew();
                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                    Objects.requireNonNull(mapViewUndoRedo);
                    MapViewUndoRedo.MoveFeaturesEdit edit = new MapViewUndoRedo.MoveFeaturesEdit(mapViewUndoRedo, this, selShapes, this._mouseDownPoint, new Point(e.getX(), e.getY()));
                    slayer.getUndoManager().addEdit(edit);
                    this.fireUndoEditEvent(edit);
                }
                this._mouseTool = MouseTools.Edit_Tool;
                break;
            }
            case MoveSelection: {
                if (this._mouseDoubleClicked) {
                    this._mouseDoubleClicked = false;
                } else if (this._selectedGraphics.size() > 0) {
                    if (Math.abs(e.getX() - this._mouseDownPoint.x) < 2 && Math.abs(e.getY() - this._mouseDownPoint.y) < 2) {
                        Graphic aGraphic = this._selectedGraphics.get(0);
                        PointF mousePoint = new PointF(this._mouseDownPoint.x, this._mouseDownPoint.y);
                        double lonShift = 0.0;
                        GraphicCollection tempGraphics = new GraphicCollection();
                        this.selectGraphics(mousePoint, tempGraphics, lonShift);
                        if (e.isControlDown() || e.isShiftDown()) {
                            if (tempGraphics.size() > 0) {
                                aGraphic = tempGraphics.get(0);
                                aGraphic.getShape().setSelected(!aGraphic.getShape().isSelected());
                                if (aGraphic.getShape().isSelected()) {
                                    this._selectedGraphics.add(aGraphic);
                                } else {
                                    this._selectedGraphics.remove(aGraphic);
                                }
                            }
                        } else {
                            if (tempGraphics.size() > 1) {
                                aGraphic.getShape().setSelected(false);
                                int idx = tempGraphics.indexOf(aGraphic);
                                idx = idx == 0 ? tempGraphics.size() - 1 : --idx;
                                aGraphic = tempGraphics.get(idx);
                                this._selectedGraphics.clear();
                                this._selectedGraphics.add(aGraphic);
                                this._selectedGraphics.get(0).getShape().setSelected(true);
                                switch (aGraphic.getLegend().getBreakType()) {
                                    case PointBreak: {
                                        if (this._frmPointSymbolSet == null || !this._frmPointSymbolSet.isVisible()) break;
                                        this._frmPointSymbolSet.setPointBreak((PointBreak)aGraphic.getLegend());
                                        break;
                                    }
                                    case LabelBreak: {
                                        if (this._frmLabelSymbolSet == null || !this._frmLabelSymbolSet.isVisible()) break;
                                        this._frmLabelSymbolSet.setLabelBreak((LabelBreak)aGraphic.getLegend());
                                        break;
                                    }
                                    case PolylineBreak: {
                                        if (this._frmPolylineSymbolSet == null || !this._frmPolylineSymbolSet.isVisible()) break;
                                        this._frmPolylineSymbolSet.setPolylineBreak((PolylineBreak)aGraphic.getLegend());
                                        break;
                                    }
                                    case PolygonBreak: {
                                        if (this._frmPolygonSymbolSet == null || !this._frmPolygonSymbolSet.isVisible()) break;
                                        this._frmPolygonSymbolSet.setPolygonBreak((PolygonBreak)aGraphic.getLegend());
                                    }
                                }
                            }
                            this.fireGraphicSelectedEvent();
                        }
                    } else {
                        Graphic aGraphic = this._selectedGraphics.get(0);
                        Shape aShape = aGraphic.getShape();
                        this.moveShapeOnScreen(aShape, this._mouseDownPoint, new Point(e.getX(), e.getY()));
                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                        Objects.requireNonNull(mapViewUndoRedo);
                        MapViewUndoRedo.MoveGraphicEdit edit = new MapViewUndoRedo.MoveGraphicEdit(mapViewUndoRedo, this, aGraphic, this._mouseDownPoint, new Point(e.getX(), e.getY()));
                        this.fireUndoEditEvent(edit);
                        this._selectedGraphics.remove(aGraphic);
                        this._selectedGraphics.add(0, aGraphic);
                    }
                    this.repaintNew();
                }
                this._mouseTool = MouseTools.SelectElements;
                break;
            }
            case ResizeSelection: {
                Graphic aG = this._selectedGraphics.get(0);
                MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                Objects.requireNonNull(mapViewUndoRedo);
                MapViewUndoRedo.ResizeGraphicEdit edit = new MapViewUndoRedo.ResizeGraphicEdit(mapViewUndoRedo, this, aG, this._resizeRectangle);
                this.fireUndoEditEvent(edit);
                Shape shape = aG.getShape();
                this.resizeShapeOnScreen(shape, aG.getLegend(), this._resizeRectangle);
                this._selectedGraphics.remove(aG);
                this._selectedGraphics.add(0, aG);
                this.repaintNew();
                this._mouseTool = MouseTools.SelectElements;
                break;
            }
            case New_Rectangle: 
            case New_Ellipse: {
                if (e.getButton() != 1) break;
                if (Math.abs(e.getX() - this._mouseDownPoint.x) < 2 || Math.abs(e.getY() - this._mouseDownPoint.y) < 2) {
                    return;
                }
                this._startNewGraphic = true;
                this._graphicPoints = new ArrayList<PointF>();
                this._graphicPoints.add(new PointF(this._mouseDownPoint.x, this._mouseDownPoint.y));
                this._graphicPoints.add(new PointF(this._mouseDownPoint.x, e.getY()));
                this._graphicPoints.add(new PointF(e.getX(), e.getY()));
                this._graphicPoints.add(new PointF(e.getX(), this._mouseDownPoint.y));
                ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                for (PointF aPoint : this._graphicPoints) {
                    double[] pXY = this.screenToProj((double)aPoint.X, (double)aPoint.Y);
                    points.add(new org.meteoinfo.global.PointD(pXY[0], pXY[1]));
                }
                Graphic aGraphic = null;
                switch (this._mouseTool) {
                    case New_Rectangle: {
                        RectangleShape aPGS = new RectangleShape();
                        points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                        aPGS.setPoints(points);
                        aGraphic = new Graphic(aPGS, (PolygonBreak)this._defPolygonBreak.clone());
                        break;
                    }
                    case New_Ellipse: {
                        EllipseShape aES = new EllipseShape();
                        aES.setPoints(points);
                        aGraphic = new Graphic(aES, (PolygonBreak)this._defPolygonBreak.clone());
                    }
                }
                if (aGraphic != null) {
                    this._graphicCollection.add(aGraphic);
                    this.repaintNew();
                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                    Objects.requireNonNull(mapViewUndoRedo);
                    MapViewUndoRedo.AddGraphicEdit edit = new MapViewUndoRedo.AddGraphicEdit(mapViewUndoRedo, this, aGraphic);
                    this.fireUndoEditEvent(edit);
                    break;
                }
                this.repaintOld();
                break;
            }
            case New_Freehand: 
            case SelectFeatures_Lasso: {
                if (e.getButton() != 1) break;
                this._startNewGraphic = true;
                if (this._graphicPoints.size() < 2) break;
                ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                for (PointF aPoint : this._graphicPoints) {
                    float[] pXY = this.screenToProj(aPoint.X, aPoint.Y);
                    points.add(new org.meteoinfo.global.PointD(pXY[0], pXY[1]));
                }
                if (this._mouseTool == MouseTools.New_Freehand) {
                    PolylineShape aPLS = new PolylineShape();
                    aPLS.setPoints(points);
                    Graphic aGraphic = new Graphic(aPLS, (PolylineBreak)this._defPolylineBreak.clone());
                    this._graphicCollection.add(aGraphic);
                    this.repaintNew();
                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                    Objects.requireNonNull(mapViewUndoRedo);
                    MapViewUndoRedo.AddGraphicEdit edit = new MapViewUndoRedo.AddGraphicEdit(mapViewUndoRedo, this, aGraphic);
                    this.fireUndoEditEvent(edit);
                    break;
                }
                MapLayer aMLayer = this.getLayerByHandle(this._selectedLayer);
                if (aMLayer == null) {
                    return;
                }
                if (aMLayer.getLayerType() != LayerTypes.VectorLayer) {
                    return;
                }
                PolygonShape aPGS = new PolygonShape();
                points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                aPGS.setPoints(points);
                VectorLayer aLayer = (VectorLayer)aMLayer;
                if (!e.isControlDown() && !e.isShiftDown()) {
                    aLayer.clearSelectedShapes();
                }
                aLayer.selectShapes(aPGS);
                this.fireShapeSelectedEvent();
                break;
            }
            case New_Circle: 
            case SelectFeatures_Circle: {
                if (e.getButton() != 1) break;
                if (e.getX() - this._mouseDownPoint.x < 2 || e.getY() - this._mouseDownPoint.y < 2) {
                    return;
                }
                float radius = (float)Math.sqrt(Math.pow(e.getX() - this._mouseDownPoint.x, 2.0) + Math.pow(e.getY() - this._mouseDownPoint.y, 2.0));
                this._startNewGraphic = true;
                this._graphicPoints = new ArrayList<PointF>();
                this._graphicPoints.add(new PointF((float)this._mouseDownPoint.x - radius, this._mouseDownPoint.y));
                this._graphicPoints.add(new PointF(this._mouseDownPoint.x, (float)this._mouseDownPoint.y - radius));
                this._graphicPoints.add(new PointF((float)this._mouseDownPoint.x + radius, this._mouseDownPoint.y));
                this._graphicPoints.add(new PointF(this._mouseDownPoint.x, (float)this._mouseDownPoint.y + radius));
                ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                for (PointF aPoint : this._graphicPoints) {
                    float[] pXY = this.screenToProj(aPoint.X, aPoint.Y);
                    points.add(new org.meteoinfo.global.PointD(pXY[0], pXY[1]));
                }
                CircleShape aPGS = new CircleShape();
                aPGS.setPoints(points);
                if (this._mouseTool == MouseTools.New_Circle) {
                    Graphic aGraphic = new Graphic(aPGS, (PolygonBreak)this._defPolygonBreak.clone());
                    this._graphicCollection.add(aGraphic);
                    this.repaintNew();
                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                    Objects.requireNonNull(mapViewUndoRedo);
                    MapViewUndoRedo.AddGraphicEdit edit = new MapViewUndoRedo.AddGraphicEdit(mapViewUndoRedo, this, aGraphic);
                    this.fireUndoEditEvent(edit);
                    break;
                }
                MapLayer layer = this.getLayerByHandle(this._selectedLayer);
                if (layer == null) {
                    return;
                }
                if (layer.getLayerType() != LayerTypes.VectorLayer) {
                    return;
                }
                VectorLayer aLayer = (VectorLayer)layer;
                if (!e.isControlDown() && !e.isShiftDown()) {
                    aLayer.clearSelectedShapes();
                }
                aLayer.selectShapes(aPGS);
                this.fireShapeSelectedEvent();
                break;
            }
            case InEditingVertices: {
                Graphic graphic = this._selectedGraphics.get(0);
                double[] pXY = this.screenToProj((double)e.getX(), (double)e.getY());
                MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                Objects.requireNonNull(mapViewUndoRedo);
                MapViewUndoRedo.MoveGraphicVerticeEdit edit = new MapViewUndoRedo.MoveGraphicVerticeEdit(mapViewUndoRedo, this, graphic, this._editingVerticeIndex, pXY[0], pXY[1]);
                this.fireUndoEditEvent(edit);
                graphic.verticeMoveUpdate(this._editingVerticeIndex, pXY[0], pXY[1]);
                this._mouseTool = MouseTools.EditVertices;
                this.repaintNew();
                break;
            }
            case Edit_InEditingVertices: {
                VectorLayer layer = (VectorLayer)this.getSelectedLayer();
                Shape eShape = layer.getEditingShape();
                if (eShape != null && eShape.isEditing()) {
                    double[] pXY = this.screenToProj((double)e.getX(), (double)e.getY());
                    org.meteoinfo.global.PointD snapP = this.selectSnapVertice(new Point(e.getX(), e.getY()), layer, 10);
                    if (snapP != null) {
                        pXY[0] = snapP.X;
                        pXY[1] = snapP.Y;
                    }
                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                    Objects.requireNonNull(mapViewUndoRedo);
                    MapViewUndoRedo.MoveFeatureVerticeEdit edit = new MapViewUndoRedo.MoveFeatureVerticeEdit(mapViewUndoRedo, this, eShape, this._editingVerticeIndex, pXY[0], pXY[1]);
                    layer.getUndoManager().addEdit(edit);
                    this.fireUndoEditEvent(edit);
                    eShape.moveVertice(this._editingVerticeIndex, pXY[0], pXY[1]);
                    this.repaintNew();
                }
                this._mouseTool = MouseTools.Edit_FeatureVertices;
            }
        }
    }

    private void showSymbolSetForm(ColorBreak aCB) {
        switch (aCB.getBreakType()) {
            case PointBreak: {
                PointBreak aPB = (PointBreak)aCB;
                if (this._frmPointSymbolSet == null) {
                    this._frmPointSymbolSet = new FrmPointSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPointSymbolSet.setLocationRelativeTo(this);
                    this._frmPointSymbolSet.setVisible(true);
                }
                this._frmPointSymbolSet.setPointBreak(aPB);
                this._frmPointSymbolSet.setVisible(true);
                break;
            }
            case LabelBreak: {
                LabelBreak aLB = (LabelBreak)aCB;
                if (this._frmLabelSymbolSet == null) {
                    this._frmLabelSymbolSet = new FrmLabelSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, this);
                    this._frmLabelSymbolSet.setLocationRelativeTo(this);
                    this._frmLabelSymbolSet.setVisible(true);
                }
                this._frmLabelSymbolSet.setLabelBreak(aLB);
                this._frmLabelSymbolSet.setVisible(true);
                break;
            }
            case PolylineBreak: {
                PolylineBreak aPLB = (PolylineBreak)aCB;
                if (this._frmPolylineSymbolSet == null) {
                    this._frmPolylineSymbolSet = new FrmPolylineSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPolylineSymbolSet.setLocationRelativeTo(this);
                    this._frmPolylineSymbolSet.setVisible(true);
                }
                this._frmPolylineSymbolSet.setPolylineBreak(aPLB);
                this._frmPolylineSymbolSet.setVisible(true);
                break;
            }
            case PolygonBreak: {
                PolygonBreak aPGB = (PolygonBreak)aCB;
                if (this._frmPolygonSymbolSet == null) {
                    this._frmPolygonSymbolSet = new FrmPolygonSymbolSet((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, (Object)this);
                    this._frmPolygonSymbolSet.setLocationRelativeTo(this);
                    this._frmPolygonSymbolSet.setVisible(true);
                }
                this._frmPolygonSymbolSet.setPolygonBreak(aPGB);
                this._frmPolygonSymbolSet.setVisible(true);
            }
        }
    }

    void onMouseClicked(MouseEvent e) {
        block84: {
            int clickTimes;
            block82: {
                block83: {
                    clickTimes = e.getClickCount();
                    if (clickTimes != 1) break block82;
                    if (e.getButton() != 1) break block83;
                    switch (this._mouseTool) {
                        case Identifer: {
                            if (this._selectedLayer < 0) {
                                return;
                            }
                            MapLayer aMLayer = this.getLayerByHandle(this._selectedLayer);
                            if (aMLayer == null) {
                                return;
                            }
                            if (aMLayer.getLayerType() == LayerTypes.ImageLayer) {
                                return;
                            }
                            PointF aPoint = new PointF(e.getX(), e.getY());
                            if (aMLayer.getLayerType() == LayerTypes.VectorLayer) {
                                VectorLayer aLayer = (VectorLayer)aMLayer;
                                List<Integer> selectedShapes = this.selectShapes(aLayer, aPoint, true, false);
                                if (selectedShapes.size() > 0) {
                                    if (this.frmIdentifer == null) {
                                        this.frmIdentifer = new FrmIdentifer((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false, this);
                                        this.frmIdentifer.addWindowListener(new WindowAdapter(){

                                            @Override
                                            public void windowClosed(WindowEvent e) {
                                                MapView.this._drawIdentiferShape = false;
                                                MapView.this.repaintOld();
                                            }
                                        });
                                    }
                                    Object[] colNames = new String[]{"Field", "Value"};
                                    int shapeIdx = selectedShapes.get(0);
                                    aLayer.setIdentiferShape(shapeIdx);
                                    this._drawIdentiferShape = true;
                                    Object[][] tData = new Object[aLayer.getFieldNumber() + 1][2];
                                    String fieldStr = "Index";
                                    String valueStr = String.valueOf(shapeIdx);
                                    tData[0][0] = fieldStr;
                                    tData[0][1] = valueStr;
                                    if (aLayer.getShapeNum() > 0) {
                                        for (int i = 0; i < aLayer.getFieldNumber(); ++i) {
                                            Field field = aLayer.getField(i);
                                            fieldStr = field.getColumnName();
                                            Object value = aLayer.getCellValue(i, shapeIdx);
                                            if (value == null) {
                                                valueStr = "";
                                            } else if (field.getDataType() == DataType.DATE) {
                                                DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                                                valueStr = format.format((LocalDateTime)value);
                                            } else {
                                                valueStr = value.toString();
                                            }
                                            tData[i + 1][0] = fieldStr;
                                            tData[i + 1][1] = valueStr;
                                        }
                                    }
                                    DefaultTableModel dtm = new DefaultTableModel(tData, colNames){

                                        @Override
                                        public boolean isCellEditable(int row, int column) {
                                            return false;
                                        }
                                    };
                                    this.frmIdentifer.getTable().setModel(dtm);
                                    this.frmIdentifer.repaint();
                                    if (!this.frmIdentifer.isVisible()) {
                                        this.frmIdentifer.setLocationRelativeTo(this);
                                        this.frmIdentifer.setVisible(true);
                                    }
                                    this.repaintOld();
                                    break;
                                }
                            } else {
                                if (aMLayer.getLayerType() != LayerTypes.RasterLayer) break;
                                RasterLayer aRLayer = (RasterLayer)aMLayer;
                                int[] ijIdx = this.selectGridCell(aRLayer, aPoint);
                                if (ijIdx != null) {
                                    int iIdx = ijIdx[0];
                                    int jIdx = ijIdx[1];
                                    double aValue = aRLayer.getCellValue(iIdx, jIdx);
                                    if (this._frmIdentiferGrid == null) {
                                        this._frmIdentiferGrid = new FrmIdentiferGrid((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false);
                                    }
                                    this._frmIdentiferGrid.setIIndex(iIdx);
                                    this._frmIdentiferGrid.setJIndex(jIdx);
                                    this._frmIdentiferGrid.setCellValue(aValue);
                                    if (!this._frmIdentiferGrid.isVisible()) {
                                        this._frmIdentiferGrid.setLocationRelativeTo(this);
                                        this._frmIdentiferGrid.setVisible(true);
                                        break;
                                    }
                                }
                            }
                            break block84;
                        }
                        case Edit_DeleteRing: {
                            Object[] selObj;
                            MapLayer aMLayer = this.getLayerByHandle(this._selectedLayer);
                            if (aMLayer == null) {
                                return;
                            }
                            if (aMLayer.getLayerType() != LayerTypes.VectorLayer) {
                                return;
                            }
                            VectorLayer aLayer = (VectorLayer)aMLayer;
                            if (!aLayer.getShapeType().isPolygon() || (selObj = this.selectPolygonHole(aLayer, new PointF(e.getX(), e.getY()))) == null) break;
                            PolygonShape selShape = (PolygonShape)selObj[0];
                            int polyIdx = (Integer)selObj[1];
                            int holeIdx = (Integer)selObj[2];
                            List<org.meteoinfo.global.PointD> hole = selShape.getPolygons().get(polyIdx).getHoleLines().get(holeIdx);
                            selShape.getPolygons().get(polyIdx).removeHole(holeIdx);
                            MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                            Objects.requireNonNull(mapViewUndoRedo);
                            MapViewUndoRedo.RemoveRingEdit edit = new MapViewUndoRedo.RemoveRingEdit(mapViewUndoRedo, this, selShape, hole, polyIdx, holeIdx);
                            aLayer.getUndoManager().addEdit(edit);
                            this.fireUndoEditEvent(edit);
                            this.repaintNew();
                        }
                    }
                    break block84;
                }
                if (e.getButton() == 3) {
                    switch (this._mouseTool) {
                        case SelectElements: 
                        case MoveSelection: 
                        case ResizeSelection: {
                            if (this._selectedGraphics.size() <= 0) break;
                            Graphic aGraphic = this._selectedGraphics.get(0);
                            JPopupMenu jPopupMenu_Graphic = new JPopupMenu();
                            JMenu jMenu_Order = new JMenu("Order");
                            jPopupMenu_Graphic.add(jMenu_Order);
                            JMenuItem jMenuItem_BTF = new JMenuItem("Bring to Front");
                            jMenuItem_BTF.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapView.this.onBringToFrontClick(e);
                                }
                            });
                            jMenu_Order.add(jMenuItem_BTF);
                            JMenuItem jMenuItem_STB = new JMenuItem("Send to Back");
                            jMenuItem_STB.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapView.this.onSendToBackClick(e);
                                }
                            });
                            jMenu_Order.add(jMenuItem_STB);
                            JMenuItem jMenuItem_BF = new JMenuItem("Bring Forward");
                            jMenuItem_BF.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapView.this.onBringForwardClick(e);
                                }
                            });
                            jMenu_Order.add(jMenuItem_BF);
                            JMenuItem jMenuItem_SB = new JMenuItem("Send Backward");
                            jMenuItem_SB.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapView.this.onSendBackwardClick(e);
                                }
                            });
                            jMenu_Order.add(jMenuItem_SB);
                            jPopupMenu_Graphic.add(new JSeparator());
                            JMenuItem jMenuItem_Remove = new JMenuItem("Remove");
                            jMenuItem_Remove.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapView.this.onRemoveGraphicClick(e);
                                }
                            });
                            jPopupMenu_Graphic.add(jMenuItem_Remove);
                            if (aGraphic.getLegend().getBreakType() == BreakTypes.PolylineBreak || aGraphic.getLegend().getBreakType() == BreakTypes.PolygonBreak) {
                                JMenuItem jMenuItem_Reverse = new JMenuItem("Reverse");
                                jMenuItem_Reverse.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        MapView.this.onReverseGraphicClick(e);
                                    }
                                });
                                jPopupMenu_Graphic.add(jMenuItem_Reverse);
                                if (aGraphic.getShape().getShapeType() == ShapeTypes.Polyline || aGraphic.getShape().getShapeType() == ShapeTypes.Polygon) {
                                    jPopupMenu_Graphic.add(new JSeparator());
                                    JMenuItem jMenuItem_Smooth = new JMenuItem("Smooth Graphic");
                                    jMenuItem_Smooth.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            MapView.this.onGrahpicSmoothClick(e);
                                        }
                                    });
                                    jPopupMenu_Graphic.add(jMenuItem_Smooth);
                                }
                                if (aGraphic.getLegend().getBreakType() == BreakTypes.PolygonBreak) {
                                    jPopupMenu_Graphic.add(new JSeparator());
                                    JMenuItem jMenuItem_Maskout = new JMenuItem("Set Maskout");
                                    if (((PolygonBreak)aGraphic.getLegend()).isMaskout()) {
                                        jMenuItem_Maskout.setText("No Maskout");
                                    }
                                    jMenuItem_Maskout.addActionListener(new ActionListener(){

                                        @Override
                                        public void actionPerformed(ActionEvent e) {
                                            MapView.this.onGraphicMaskoutClick(e);
                                        }
                                    });
                                    jPopupMenu_Graphic.add(jMenuItem_Maskout);
                                }
                            }
                            if (aGraphic.getShape().getShapeType() == ShapeTypes.Ellipse) {
                                JMenuItem jMenuItem_Angle = new JMenuItem("Set Angle");
                                jMenuItem_Angle.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        MapView.this.onAngleGraphicClick(e);
                                    }
                                });
                                jPopupMenu_Graphic.add(jMenuItem_Angle);
                            }
                            jPopupMenu_Graphic.show(this, e.getX(), e.getY());
                            break;
                        }
                        case EditVertices: {
                            final Graphic graphic = this._selectedGraphics.get(0);
                            Shape eShape = graphic.getShape();
                            this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), eShape, this._editingVertices);
                            if (this._editingVerticeIndex < 0) break;
                            JPopupMenu jPopupMenu_Vertices = new JPopupMenu();
                            JMenuItem jMenuItem_Remove = new JMenuItem("Remove Vertice");
                            jMenuItem_Remove.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                    Objects.requireNonNull(mapViewUndoRedo);
                                    MapViewUndoRedo.RemoveGraphicVerticeEdit edit = new MapViewUndoRedo.RemoveGraphicVerticeEdit(mapViewUndoRedo, MapView.this, graphic, MapView.this._editingVerticeIndex);
                                    MapView.this.fireUndoEditEvent(edit);
                                    graphic.verticeRemoveUpdate(MapView.this._editingVerticeIndex);
                                    MapView.this.repaintNew();
                                }
                            });
                            jPopupMenu_Vertices.add(jMenuItem_Remove);
                            jPopupMenu_Vertices.show(this, e.getX(), e.getY());
                            break;
                        }
                        case Edit_FeatureVertices: {
                            final VectorLayer selLayer = (VectorLayer)this.getSelectedLayer();
                            final Shape fShape = selLayer.getEditingShape();
                            if (fShape == null || !fShape.isEditing()) break;
                            this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), fShape, this._editingVertices);
                            if (this._editingVerticeIndex < 0) break;
                            JPopupMenu jPopupMenu_Vertices = new JPopupMenu();
                            JMenuItem jMenuItem_Edit = new JMenuItem("Edit vertice");
                            jMenuItem_Edit.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    FrmVerticeEdit frmve = new FrmVerticeEdit((Frame)((JFrame)SwingUtilities.getWindowAncestor(MapView.this)), true);
                                    org.meteoinfo.global.PointD point = fShape.getPoints().get(MapView.this._editingVerticeIndex);
                                    frmve.setIndex(MapView.this._editingVerticeIndex);
                                    frmve.setPoint(point);
                                    frmve.setLocationRelativeTo(MapView.this);
                                    frmve.setVisible(true);
                                    if (frmve.isOK().booleanValue()) {
                                        double[] xy = frmve.getXY();
                                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                        Objects.requireNonNull(mapViewUndoRedo);
                                        MapViewUndoRedo.MoveFeatureVerticeEdit edit = new MapViewUndoRedo.MoveFeatureVerticeEdit(mapViewUndoRedo, MapView.this, fShape, MapView.this._editingVerticeIndex, xy[0], xy[1]);
                                        selLayer.getUndoManager().addEdit(edit);
                                        MapView.this.fireUndoEditEvent(edit);
                                        fShape.moveVertice(MapView.this._editingVerticeIndex, xy[0], xy[1]);
                                        MapView.this.repaintNew();
                                    }
                                }
                            });
                            jPopupMenu_Vertices.add(jMenuItem_Edit);
                            JMenuItem jMenuItem_Remove = new JMenuItem("Remove Vertice");
                            jMenuItem_Remove.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                    Objects.requireNonNull(mapViewUndoRedo);
                                    MapViewUndoRedo.RemoveFeatureVerticeEdit edit = new MapViewUndoRedo.RemoveFeatureVerticeEdit(mapViewUndoRedo, MapView.this, fShape, MapView.this._editingVerticeIndex);
                                    selLayer.getUndoManager().addEdit(edit);
                                    MapView.this.fireUndoEditEvent(edit);
                                    fShape.removeVerice(MapView.this._editingVerticeIndex);
                                    MapView.this.repaintNew();
                                }
                            });
                            jPopupMenu_Vertices.add(jMenuItem_Remove);
                            jPopupMenu_Vertices.show(this, e.getX(), e.getY());
                            break;
                        }
                        case Edit_Tool: {
                            final VectorLayer sLayer = (VectorLayer)this.getSelectedLayer();
                            final Shape sShape = sLayer.getSelectedShapes().get(0);
                            if (sShape == null) break;
                            JPopupMenu jPopupMenu_Shape = new JPopupMenu();
                            JMenuItem jMenuItem_Smooth = new JMenuItem("Smooth");
                            jMenuItem_Smooth.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapView.this.onShapeSmoothClick(sLayer, sShape);
                                }
                            });
                            jPopupMenu_Shape.add(jMenuItem_Smooth);
                            JMenuItem jMenuItem_Reverse = new JMenuItem("Reverse");
                            jMenuItem_Reverse.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    MapView.this.onShapeReverseClick(sShape);
                                }
                            });
                            jPopupMenu_Shape.add(jMenuItem_Reverse);
                            jPopupMenu_Shape.show(this, e.getX(), e.getY());
                        }
                    }
                }
                break block84;
            }
            if (clickTimes != 2) break block84;
            block14 : switch (this._mouseTool) {
                case SelectElements: 
                case MoveSelection: 
                case ResizeSelection: {
                    if (this._mouseTool == MouseTools.MoveSelection) {
                        this._mouseDoubleClicked = true;
                    }
                    if (this._selectedGraphics.isEmpty()) {
                        return;
                    }
                    Graphic aGraphic = this._selectedGraphics.get(0);
                    for (Graphic aG : this._selectedGraphics.getGraphics()) {
                        aG.getShape().setSelected(false);
                    }
                    this._selectedGraphics.clear();
                    PointF mousePoint = new PointF(this._mouseDownPoint.x, this._mouseDownPoint.y);
                    double lonShift = 0.0;
                    if (!this.selectGraphics(mousePoint, this._selectedGraphics, lonShift)) break;
                    if (this._selectedGraphics.size() > 1) {
                        aGraphic.getShape().setSelected(false);
                        int idx = this._selectedGraphics.indexOf(aGraphic);
                        if ((idx += 2) > this._selectedGraphics.size() - 1) {
                            idx -= this._selectedGraphics.size();
                        }
                        aGraphic = this._selectedGraphics.get(idx);
                        this._selectedGraphics.clear();
                        this._selectedGraphics.add(aGraphic);
                    }
                    aGraphic.getShape().setSelected(true);
                    this.repaintNew();
                    this.showSymbolSetForm(aGraphic.getLegend());
                    break;
                }
                case Edit_NewFeature: {
                    if (this._startNewGraphic) break;
                    this._startNewGraphic = true;
                    this._graphicPoints.remove(this._graphicPoints.size() - 1);
                    ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                    for (PointF aPoint : this._graphicPoints) {
                        float[] pXY = this.screenToProj(aPoint.X, aPoint.Y);
                        points.add(new org.meteoinfo.global.PointD(pXY[0], pXY[1]));
                    }
                    VectorLayer selLayer = (VectorLayer)this.getSelectedLayer();
                    if (selLayer.getShapeType().isLine()) {
                        PolylineShape aPLS = new PolylineShape();
                        aPLS.setPoints(points);
                        try {
                            selLayer.editAddShape(aPLS);
                            this.repaintNew();
                            MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                            Objects.requireNonNull(mapViewUndoRedo);
                            MapViewUndoRedo.AddFeatureEdit edit = new MapViewUndoRedo.AddFeatureEdit(mapViewUndoRedo, this, selLayer, aPLS);
                            selLayer.getUndoManager().addEdit(edit);
                            this.fireUndoEditEvent(edit);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        break;
                    }
                    if (!selLayer.getShapeType().isPolygon() || points.size() <= 2) break;
                    PolygonShape aPGS = new PolygonShape();
                    points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                    aPGS.setPoints(points);
                    try {
                        selLayer.editAddShape(aPGS);
                        this.repaintNew();
                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                        Objects.requireNonNull(mapViewUndoRedo);
                        MapViewUndoRedo.AddFeatureEdit edit = new MapViewUndoRedo.AddFeatureEdit(mapViewUndoRedo, this, selLayer, aPGS);
                        selLayer.getUndoManager().addEdit(edit);
                        this.fireUndoEditEvent(edit);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    break;
                }
                case Edit_AddRing: 
                case Edit_FillRing: 
                case Edit_ReformFeature: 
                case Edit_SplitFeature: {
                    if (this._startNewGraphic) break;
                    this._startNewGraphic = true;
                    this._graphicPoints.remove(this._graphicPoints.size() - 1);
                    ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                    for (PointF aPoint : this._graphicPoints) {
                        float[] pXY = this.screenToProj(aPoint.X, aPoint.Y);
                        points.add(new org.meteoinfo.global.PointD(pXY[0], pXY[1]));
                    }
                    VectorLayer selLayer = (VectorLayer)this.getSelectedLayer();
                    if (!selLayer.getShapeType().isPolygon() && !selLayer.getShapeType().isLine() || points.size() < 2) break;
                    switch (this._mouseTool) {
                        case Edit_AddRing: 
                        case Edit_FillRing: {
                            if (selLayer.getShapeType().isPolygon()) {
                                PolygonShape aPGS = new PolygonShape();
                                points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                                aPGS.setPoints(points);
                                PolygonShape tPGS = (PolygonShape)selLayer.findShape_contains(aPGS);
                                if (tPGS == null) break block14;
                                int holeIdx = tPGS.addHole(points, 0);
                                if (this._mouseTool == MouseTools.Edit_FillRing) {
                                    try {
                                        selLayer.editAddShape(aPGS);
                                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                        Objects.requireNonNull(mapViewUndoRedo);
                                        MapViewUndoRedo.FillRingEdit edit = new MapViewUndoRedo.FillRingEdit(mapViewUndoRedo, this, selLayer, tPGS, aPGS, 0, holeIdx);
                                        selLayer.getUndoManager().addEdit(edit);
                                        this.fireUndoEditEvent(edit);
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                } else {
                                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                    Objects.requireNonNull(mapViewUndoRedo);
                                    MapViewUndoRedo.AddRingEdit edit = new MapViewUndoRedo.AddRingEdit(mapViewUndoRedo, this, tPGS, points, 0, holeIdx);
                                    selLayer.getUndoManager().addEdit(edit);
                                    this.fireUndoEditEvent(edit);
                                }
                                this.repaintNew();
                                break;
                            }
                            break block84;
                        }
                        case Edit_ReformFeature: {
                            PolylineShape aPLS = new PolylineShape();
                            aPLS.setPoints(points);
                            Shape r = selLayer.findReformShape(aPLS);
                            if (r != null) {
                                Shape shape = r.reform(aPLS);
                                MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                Objects.requireNonNull(mapViewUndoRedo);
                                MapViewUndoRedo.ReplaceFeatureEdit edit = new MapViewUndoRedo.ReplaceFeatureEdit(mapViewUndoRedo, this, selLayer, r, shape);
                                selLayer.getUndoManager().addEdit(edit);
                                this.fireUndoEditEvent(edit);
                                r.cloneValue(shape);
                            }
                            this.repaintNew();
                            break;
                        }
                        case Edit_SplitFeature: {
                            PolylineShape aPLS = new PolylineShape();
                            aPLS.setPoints(points);
                            Shape r = selLayer.findShape_crosses(aPLS);
                            if (r != null) {
                                List<Shape> shapes = r.split(aPLS);
                                selLayer.editRemoveShape(r);
                                for (Shape s : shapes) {
                                    try {
                                        selLayer.editAddShape(s);
                                    }
                                    catch (Exception ex) {
                                        Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                                MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                                Objects.requireNonNull(mapViewUndoRedo);
                                MapViewUndoRedo.SplitFeatureEdit edit = new MapViewUndoRedo.SplitFeatureEdit(mapViewUndoRedo, this, selLayer, r, shapes);
                                selLayer.getUndoManager().addEdit(edit);
                                this.fireUndoEditEvent(edit);
                                this.paintLayers();
                                this.repaintNew();
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case New_Polygon: 
                case New_Polyline: 
                case New_Curve: 
                case New_CurvePolygon: 
                case New_Freehand: 
                case SelectFeatures_Polygon: {
                    PolygonShape aPGS;
                    if (this._startNewGraphic) break;
                    this._startNewGraphic = true;
                    this._graphicPoints.remove(this._graphicPoints.size() - 1);
                    ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                    for (PointF aPoint : this._graphicPoints) {
                        float[] pXY = this.screenToProj(aPoint.X, aPoint.Y);
                        points.add(new org.meteoinfo.global.PointD(pXY[0], pXY[1]));
                    }
                    Graphic aGraphic = null;
                    switch (this._mouseTool) {
                        case New_Polyline: 
                        case New_Freehand: {
                            PolylineShape aPLS = new PolylineShape();
                            aPLS.setPoints(points);
                            aGraphic = new Graphic(aPLS, (PolylineBreak)this._defPolylineBreak.clone());
                            break;
                        }
                        case New_Polygon: {
                            if (points.size() <= 2) break;
                            aPGS = new PolygonShape();
                            points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                            aPGS.setPoints(points);
                            aGraphic = new Graphic(aPGS, (PolygonBreak)this._defPolygonBreak.clone());
                            break;
                        }
                        case New_Curve: {
                            CurveLineShape aCLS = new CurveLineShape();
                            aCLS.setPoints(points);
                            aGraphic = new Graphic(aCLS, (PolylineBreak)this._defPolylineBreak.clone());
                            break;
                        }
                        case New_CurvePolygon: {
                            if (points.size() <= 2) break;
                            CurvePolygonShape aCPS = new CurvePolygonShape();
                            points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                            aCPS.setPoints(points);
                            aGraphic = new Graphic(aCPS, (PolygonBreak)this._defPolygonBreak.clone());
                        }
                    }
                    if (this._mouseTool == MouseTools.SelectFeatures_Polygon) {
                        MapLayer layer = this.getLayerByHandle(this._selectedLayer);
                        if (layer == null) {
                            return;
                        }
                        if (layer.getLayerType() != LayerTypes.VectorLayer) {
                            return;
                        }
                        aPGS = new PolygonShape();
                        points.add((org.meteoinfo.global.PointD)((org.meteoinfo.global.PointD)points.get(0)).clone());
                        aPGS.setPoints(points);
                        VectorLayer aLayer = (VectorLayer)layer;
                        if (!e.isControlDown() && !e.isShiftDown()) {
                            aLayer.clearSelectedShapes();
                        }
                        aLayer.selectShapes(aPGS);
                        this.fireShapeSelectedEvent();
                        break;
                    }
                    if (aGraphic != null) {
                        this._graphicCollection.add(aGraphic);
                        this.repaintNew();
                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                        Objects.requireNonNull(mapViewUndoRedo);
                        MapViewUndoRedo.AddGraphicEdit edit = new MapViewUndoRedo.AddGraphicEdit(mapViewUndoRedo, this, aGraphic);
                        this.fireUndoEditEvent(edit);
                        break;
                    }
                    this.repaintOld();
                    break;
                }
                case EditVertices: {
                    int idx;
                    if (this._selectedGraphics.size() <= 0) break;
                    Graphic graphic = this._selectedGraphics.get(0);
                    Shape eShape = graphic.getShape();
                    this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), eShape, this._editingVertices);
                    if (this._editingVerticeIndex >= 0 || (idx = this.isOnRing(new Point(e.getX(), e.getY()), eShape)) < 0) break;
                    float[] pXY = this.screenToProj(e.getX(), e.getY());
                    org.meteoinfo.global.PointD point = new org.meteoinfo.global.PointD(pXY[0], pXY[1]);
                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                    Objects.requireNonNull(mapViewUndoRedo);
                    MapViewUndoRedo.AddGraphicVerticeEdit edit = new MapViewUndoRedo.AddGraphicVerticeEdit(mapViewUndoRedo, this, graphic, idx, point);
                    this.fireUndoEditEvent(edit);
                    graphic.verticeAddUpdate(idx, point);
                    this.repaintNew();
                    break;
                }
                case Edit_FeatureVertices: {
                    int idx;
                    VectorLayer selLayer = (VectorLayer)this.getSelectedLayer();
                    Shape eShape = selLayer.getEditingShape();
                    if (eShape == null || !eShape.isEditing()) break;
                    this._editingVerticeIndex = this.selectEditVertices(new Point(e.getX(), e.getY()), eShape, this._editingVertices);
                    if (this._editingVerticeIndex >= 0 || (idx = this.isOnRing(new Point(e.getX(), e.getY()), eShape)) < 0) break;
                    float[] pXY = this.screenToProj(e.getX(), e.getY());
                    org.meteoinfo.global.PointD point = new org.meteoinfo.global.PointD(pXY[0], pXY[1]);
                    MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                    Objects.requireNonNull(mapViewUndoRedo);
                    MapViewUndoRedo.AddFeatureVerticeEdit edit = new MapViewUndoRedo.AddFeatureVerticeEdit(mapViewUndoRedo, this, eShape, idx, point);
                    selLayer.getUndoManager().addEdit(edit);
                    this.fireUndoEditEvent(edit);
                    eShape.addVertice(idx, point);
                    this.repaintNew();
                }
            }
        }
    }

    private void onBringToFrontClick(ActionEvent e) {
        Graphic aG = this._selectedGraphics.get(0);
        int idx = this._graphicCollection.indexOf(aG);
        if (idx < this._graphicCollection.size() - 1) {
            this._graphicCollection.remove(aG);
            this._graphicCollection.add(aG);
            this.repaintNew();
        }
    }

    private void onSendToBackClick(ActionEvent e) {
        Graphic aG = this._selectedGraphics.get(0);
        int idx = this._graphicCollection.indexOf(aG);
        if (idx > 0) {
            this._graphicCollection.remove(aG);
            this._graphicCollection.add(0, aG);
            this.repaintNew();
        }
    }

    private void onBringForwardClick(ActionEvent e) {
        Graphic aG = this._selectedGraphics.get(0);
        int idx = this._graphicCollection.indexOf(aG);
        if (idx < this._graphicCollection.size() - 1) {
            this._graphicCollection.remove(aG);
            this._graphicCollection.add(idx + 1, aG);
            this.repaintNew();
        }
    }

    private void onSendBackwardClick(ActionEvent e) {
        Graphic aG = this._selectedGraphics.get(0);
        int idx = this._graphicCollection.indexOf(aG);
        if (idx > 0) {
            this._graphicCollection.remove(aG);
            this._graphicCollection.add(idx - 1, aG);
            this.repaintNew();
        }
    }

    private void onRemoveGraphicClick(ActionEvent e) {
        this.removeSelectedGraphics();
        this._startNewGraphic = true;
        this.repaintNew();
    }

    private void onReverseGraphicClick(ActionEvent e) {
        Graphic aGraphic = this._selectedGraphics.get(0);
        List<? extends org.meteoinfo.global.PointD> points = aGraphic.getShape().getPoints();
        Collections.reverse(points);
        aGraphic.getShape().setPoints(points);
        this.repaintNew();
    }

    private void onAngleGraphicClick(ActionEvent e) {
        Graphic aGraphic = this._selectedGraphics.get(0);
        EllipseShape es = (EllipseShape)aGraphic.getShape();
        String angleStr = JOptionPane.showInputDialog(this, "Ellipse angle:", Float.valueOf(es.getAngle()));
        if (angleStr != null) {
            es.setAngle(Float.parseFloat(angleStr));
            this.repaintNew();
        }
    }

    private void onGrahpicSmoothClick(ActionEvent e) {
        Graphic aGraphic = this._selectedGraphics.get(0);
        List pointList = new ArrayList<PointD>();
        ArrayList<org.meteoinfo.global.PointD> newPoints = new ArrayList<org.meteoinfo.global.PointD>();
        for (org.meteoinfo.global.PointD pointD : aGraphic.getShape().getPoints()) {
            pointList.add(new PointD(pointD.X, pointD.Y));
        }
        if (aGraphic.getShape().getShapeType() == ShapeTypes.Polygon) {
            pointList.add((PointD)pointList.get(0));
        }
        pointList = Contour.smoothPoints(pointList);
        for (PointD pointD : pointList) {
            newPoints.add(new org.meteoinfo.global.PointD(pointD.X, pointD.Y));
        }
        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
        Objects.requireNonNull(mapViewUndoRedo);
        MapViewUndoRedo.SmoothGraphicEdit edit = new MapViewUndoRedo.SmoothGraphicEdit(mapViewUndoRedo, this, aGraphic, newPoints);
        this.fireUndoEditEvent(edit);
        aGraphic.getShape().setPoints(newPoints);
        this.repaintNew();
    }

    private void onShapeSmoothClick(VectorLayer layer, Shape shape) {
        List pointList = new ArrayList<PointD>();
        ArrayList<org.meteoinfo.global.PointD> newPoints = new ArrayList<org.meteoinfo.global.PointD>();
        for (org.meteoinfo.global.PointD pointD : shape.getPoints()) {
            pointList.add(new PointD(pointD.X, pointD.Y));
        }
        if (shape.getShapeType() == ShapeTypes.Polygon) {
            pointList.add((PointD)pointList.get(0));
        }
        pointList = Contour.smoothPoints(pointList);
        for (PointD pointD : pointList) {
            newPoints.add(new org.meteoinfo.global.PointD(pointD.X, pointD.Y));
        }
        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
        Objects.requireNonNull(mapViewUndoRedo);
        MapViewUndoRedo.SmoothFeatureEdit edit = new MapViewUndoRedo.SmoothFeatureEdit(mapViewUndoRedo, this, shape, newPoints);
        layer.getUndoManager().addEdit(edit);
        this.fireUndoEditEvent(edit);
        shape.setPoints(newPoints);
        this.repaintNew();
    }

    private void onShapeReverseClick(Shape shape) {
        shape.reverse();
        this.repaintNew();
    }

    private void onGraphicMaskoutClick(ActionEvent e) {
        Graphic aGraphic = this._selectedGraphics.get(0);
        ((PolygonBreak)aGraphic.getLegend()).setMaskout(!((PolygonBreak)aGraphic.getLegend()).isMaskout());
        this.repaintNew();
    }

    void onMouseWheelMoved(MouseWheelEvent e) {
        double lonRan = this._drawExtent.maxX - this._drawExtent.minX;
        double latRan = this._drawExtent.maxY - this._drawExtent.minY;
        double mouseLon = this._drawExtent.minX + lonRan / 2.0;
        double mouseLat = this._drawExtent.minY + latRan / 2.0;
        double ZoomF = 1.0f + (float)e.getWheelRotation() / 10.0f;
        double MinX = mouseLon - lonRan / 2.0 * ZoomF;
        double MaxX = mouseLon + lonRan / 2.0 * ZoomF;
        double MinY = mouseLat - latRan / 2.0 * ZoomF;
        double MaxY = mouseLat + latRan / 2.0 * ZoomF;
        Extent oldExtent = (Extent)this._viewExtent.clone();
        if (!this._highSpeedWheelZoom) {
            this.zoomToExtent(MinX, MaxX, MinY, MaxY);
        } else {
            this._paintScale /= ZoomF;
            float nWidth = (float)this.getWidth() * (float)this._paintScale;
            float nHeight = (float)this.getHeight() * (float)this._paintScale;
            float nx = ((float)this.getWidth() - nWidth) / 2.0f;
            float ny = ((float)this.getHeight() - nHeight) / 2.0f;
            this._xShift = (int)nx;
            this._yShift = (int)ny;
            this.repaintOld();
            this._viewExtent = new Extent(MinX, MaxX, MinY, MaxY);
            this.refreshXYScale();
            this._lastMouseWheelTime = LocalDateTime.now();
            if (!this._mouseWheelDetctionTimer.isRunning()) {
                this._mouseWheelDetctionTimer.start();
            }
        }
        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
        Objects.requireNonNull(mapViewUndoRedo);
        MapViewUndoRedo.ZoomEdit edit = new MapViewUndoRedo.ZoomEdit(mapViewUndoRedo, this, oldExtent, (Extent)this._viewExtent.clone());
        this.fireUndoEditEvent(edit);
    }

    void onKeyTyped(KeyEvent e) {
    }

    void onKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 127) {
            switch (this._mouseTool) {
                case SelectElements: 
                case CreateSelection: {
                    this.removeSelectedGraphics();
                    this._startNewGraphic = true;
                    this.repaintNew();
                    break;
                }
                case Edit_Tool: {
                    VectorLayer layer = (VectorLayer)this.getSelectedLayer();
                    List<Shape> selShapes = layer.getSelectedShapes();
                    if (selShapes.size() > 0) {
                        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
                        Objects.requireNonNull(mapViewUndoRedo);
                        MapViewUndoRedo.RemoveFeaturesEdit edit = new MapViewUndoRedo.RemoveFeaturesEdit(mapViewUndoRedo, this, layer, selShapes);
                        layer.getUndoManager().addEdit(edit);
                        this.fireUndoEditEvent(edit);
                        for (Shape shape : selShapes) {
                            layer.editRemoveShape(shape);
                        }
                    }
                    this.repaintNew();
                }
            }
        }
    }

    void onKeyReleased(KeyEvent e) {
    }

    public int addLayer(MapLayer aLayer) {
        int handle = this.getNewLayerHandle();
        aLayer.setHandle(handle);
        switch (aLayer.getLayerType()) {
            case VectorLayer: 
            case RasterLayer: {
                this.projectLayer(aLayer, false);
            }
        }
        this.layers.add(aLayer);
        this.fireLayersUpdatedEvent();
        this._extent = this.getLayersWholeExtent();
        if (this.layers.size() == 1) {
            this.zoomToExtent(this._extent);
        } else {
            this.repaintNew();
        }
        return handle;
    }

    public int addLayer(int index, MapLayer aLayer) {
        int handle = this.getNewLayerHandle();
        aLayer.setHandle(handle);
        switch (aLayer.getLayerType()) {
            case VectorLayer: 
            case RasterLayer: {
                this.projectLayer(aLayer);
            }
        }
        this.layers.add(index, aLayer);
        this.fireLayersUpdatedEvent();
        this._extent = this.getLayersWholeExtent();
        if (this.layers.size() == 1) {
            this.zoomToExtent(this._extent);
        } else {
            this.repaintNew();
        }
        return handle;
    }

    public int addWindLayer(VectorLayer aLayer, boolean EarthWind) {
        int handle = this.getNewLayerHandle();
        aLayer.setHandle(handle);
        ProjectionInfo aProjInfo = aLayer.getProjInfo();
        ProjectionInfo GeoProjInfo = KnownCoordinateSystems.geographic.world.WGS1984;
        if (!aLayer.getProjInfo().equals(this._projection.getProjInfo())) {
            if (EarthWind) {
                if (aProjInfo.getProjectionName() == ProjectionNames.LongLat) {
                    ProjectionUtil.projectLayer(aLayer, this._projection.getProjInfo());
                } else {
                    ProjectionUtil.projectWindLayer(aLayer, this._projection.getProjInfo(), false);
                    ProjectionUtil.projectLayerAngle(aLayer, GeoProjInfo, this._projection.getProjInfo());
                }
            } else {
                ProjectionUtil.projectLayer(aLayer, this._projection.getProjInfo());
            }
        }
        this.layers.add(aLayer);
        this._extent = this.getLayersWholeExtent();
        this.repaintNew();
        this.fireLayersUpdatedEvent();
        return handle;
    }

    private void projectLayer(MapLayer layer) {
        switch (layer.getLayerType()) {
            case VectorLayer: {
                VectorLayer aLayer = (VectorLayer)layer;
                boolean projectLabels = false;
                if (aLayer.getLabelPoints().size() > 0) {
                    projectLabels = true;
                }
                if (aLayer.getProjInfo().equals(this._projection.getProjInfo())) break;
                ProjectionUtil.projectLayer(aLayer, this._projection.getProjInfo(), projectLabels);
                break;
            }
            case RasterLayer: {
                RasterLayer rLayer = (RasterLayer)layer;
                if (rLayer.getProjInfo().equals(this._projection.getProjInfo())) break;
                ProjectionUtil.projectLayer(rLayer, this._projection.getProjInfo());
            }
        }
    }

    private void projectLayer(MapLayer layer, boolean projectLabels) {
        switch (layer.getLayerType()) {
            case VectorLayer: {
                VectorLayer aLayer = (VectorLayer)layer;
                if (aLayer.getProjInfo().equals(this._projection.getProjInfo())) break;
                ProjectionUtil.projectLayer(aLayer, this._projection.getProjInfo(), projectLabels);
                break;
            }
            case RasterLayer: {
                RasterLayer rLayer = (RasterLayer)layer;
                if (rLayer.getProjInfo().equals(this._projection.getProjInfo())) break;
                ProjectionUtil.projectLayer(rLayer, this._projection.getProjInfo());
            }
        }
    }

    public int getNewLayerHandle() {
        int handle = 0;
        for (MapLayer layer : this.layers) {
            if (handle >= layer.getHandle()) continue;
            handle = layer.getHandle();
        }
        return ++handle;
    }

    public MapLayer getSelectedLayer() {
        return this.getLayerByHandle(this._selectedLayer);
    }

    public Extent getLayersWholeExtent() {
        Extent aExtent = new Extent();
        for (int i = 0; i < this.layers.size(); ++i) {
            Extent bExtent = ((MapLayer)this.layers.get(i)).getExtent();
            aExtent = i == 0 ? bExtent : MIMath.getLagerExtent(aExtent, bExtent);
        }
        return aExtent;
    }

    public Extent getMeteoLayersExtent() {
        Extent aExtent = null;
        int n = 0;
        for (MapLayer layer : this.layers) {
            if (!layer.getFileName().isEmpty()) continue;
            Extent bExtent = layer.getExtent();
            aExtent = n == 0 ? bExtent : MIMath.getLagerExtent(aExtent, bExtent);
            ++n;
        }
        return aExtent;
    }

    public int getLayerHandleFromName(String name) {
        int handle = -1;
        for (MapLayer layer : this.layers) {
            if (!layer.getLayerName().equals(name)) continue;
            handle = layer.getHandle();
            break;
        }
        return handle;
    }

    public int getLayerHandleFromIdx(int lIdx) {
        return ((MapLayer)this.layers.get(lIdx)).getHandle();
    }

    public MapLayer getLayerByHandle(int handle) {
        MapLayer aLayer = null;
        for (MapLayer layer : this.layers) {
            if (layer.getHandle() != handle) continue;
            aLayer = layer;
            break;
        }
        return aLayer;
    }

    public MapLayer getLayer(String name) {
        MapLayer aLayer = null;
        for (MapLayer ml : this.layers) {
            if (!ml.getLayerName().equals(name)) continue;
            aLayer = ml;
            break;
        }
        return aLayer;
    }

    public int getLayerIdxFromHandle(int handle) {
        int lIdx = -1;
        for (int i = 0; i < this.layers.size(); ++i) {
            if (((MapLayer)this.layers.get(i)).getHandle() != handle) continue;
            lIdx = i;
            break;
        }
        return lIdx;
    }

    public void moveLayer(int lPreIdx, int lNewIdx) {
        if (lNewIdx > lPreIdx) {
            if (lNewIdx == this.layers.size() - 1) {
                this.layers.add((MapLayer)this.layers.get(lPreIdx));
            } else {
                this.layers.add(lNewIdx + 1, (MapLayer)this.layers.get(lPreIdx));
            }
            this.layers.remove(lPreIdx);
        } else {
            this.layers.add(lNewIdx, (MapLayer)this.layers.get(lPreIdx));
            this.layers.remove(lPreIdx + 1);
        }
    }

    public void removeLayer(int aIdx) {
        this.layers.remove(aIdx);
        this._extent = this.getLayersWholeExtent();
    }

    public void removeLayerHandle(int handle) {
        int lIdx = this.getLayerIdxFromHandle(handle);
        if (lIdx >= 0) {
            this.removeLayer(lIdx);
        }
    }

    public void removeLayer(MapLayer aLayer) {
        int aIdx = this.getLayerIdxFromHandle(aLayer.getHandle());
        this.removeLayer(aIdx);
    }

    public void removeAllLayers() {
        int aNum = this.layers.size();
        for (int i = 0; i < aNum; ++i) {
            this.removeLayer(0);
        }
        this.repaintNew();
    }

    public int getLineLayerIdx() {
        int lIdx = -1;
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            if (((MapLayer)this.layers.get(i)).getLayerType() == LayerTypes.VectorLayer) {
                VectorLayer bLayer = (VectorLayer)this.layers.get(i);
                switch (bLayer.getShapeType()) {
                    case Polyline: 
                    case PolylineZ: 
                    case Polygon: 
                    case PolygonM: 
                    case PolygonZ: 
                    case PolylineM: {
                        lIdx = i;
                    }
                }
                if (lIdx <= -1) continue;
                break;
            }
            lIdx = i;
            break;
        }
        return lIdx;
    }

    public int getPolygonLayerIdx() {
        int lIdx = -1;
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            if (((MapLayer)this.layers.get(i)).getLayerType() == LayerTypes.VectorLayer) {
                VectorLayer bLayer = (VectorLayer)this.layers.get(i);
                switch (bLayer.getShapeType()) {
                    case Polygon: 
                    case PolygonM: 
                    case PolygonZ: {
                        lIdx = i;
                    }
                }
                if (lIdx <= -1) continue;
                break;
            }
            lIdx = i;
            break;
        }
        return lIdx;
    }

    public int getImageLayerIdx() {
        int lIdx = -1;
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            if (((MapLayer)this.layers.get(i)).getLayerType() != LayerTypes.ImageLayer && ((MapLayer)this.layers.get(i)).getLayerType() != LayerTypes.RasterLayer && ((MapLayer)this.layers.get(i)).getLayerType() != LayerTypes.WebMapLayer) continue;
            lIdx = i;
            break;
        }
        return lIdx;
    }

    public boolean hasWebMapLayer() {
        for (MapLayer layer : this.layers) {
            if (layer.getLayerType() != LayerTypes.WebMapLayer) continue;
            return true;
        }
        return false;
    }

    @Override
    public void paintComponent(Graphics g) {
        MapLayer aLayer;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.getBackground());
        g2.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.newPaint) {
            this.paintGraphics(g2);
        } else {
            AffineTransform mx = new AffineTransform();
            mx.translate(this._xShift, this._yShift);
            mx.scale(this._paintScale, this._paintScale);
            AffineTransformOp aop = new AffineTransformOp(mx, 2);
            g2.drawImage(this._mapBitmap, aop, 0, 0);
        }
        if (this._dragMode) {
            switch (this._mouseTool) {
                case Zoom_In: {
                    int aWidth = Math.abs(this._mouseLastPos.x - this._mouseDownPoint.x);
                    int aHeight = Math.abs(this._mouseLastPos.y - this._mouseDownPoint.y);
                    int aX = Math.min(this._mouseLastPos.x, this._mouseDownPoint.x);
                    int aY = Math.min(this._mouseLastPos.y, this._mouseDownPoint.y);
                    g2.setColor(this.getForeground());
                    float[] dash1 = new float[]{2.0f};
                    g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f));
                    g2.draw(new java.awt.Rectangle(aX, aY, aWidth, aHeight));
                    break;
                }
                case MoveSelection: 
                case Edit_MoveSelection: {
                    java.awt.Rectangle rect = new java.awt.Rectangle();
                    rect.x = this._selectedRectangle.x + this._mouseLastPos.x - this._mouseDownPoint.x;
                    rect.y = this._selectedRectangle.y + this._mouseLastPos.y - this._mouseDownPoint.y;
                    rect.width = this._selectedRectangle.width;
                    rect.height = this._selectedRectangle.height;
                    g2.setColor(Color.red);
                    float[] dash2 = new float[]{2.0f};
                    g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dash2, 0.0f));
                    g2.draw(rect);
                    break;
                }
                case ResizeSelection: {
                    g2.setColor(Color.red);
                    float[] dashPattern = new float[]{2.0f, 1.0f};
                    g2.setStroke(new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f));
                    g2.draw(this._resizeRectangle);
                    break;
                }
                case SelectFeatures_Rectangle: 
                case Edit_Tool: 
                case New_Rectangle: 
                case New_Ellipse: 
                case CreateSelection: {
                    int sx = Math.min(this._mouseDownPoint.x, this._mouseLastPos.x);
                    int sy = Math.min(this._mouseDownPoint.y, this._mouseLastPos.y);
                    g2.setColor(this.getForeground());
                    g2.draw(new java.awt.Rectangle(sx, sy, Math.abs(this._mouseLastPos.x - this._mouseDownPoint.x), Math.abs(this._mouseLastPos.y - this._mouseDownPoint.y)));
                    break;
                }
                case New_Freehand: 
                case SelectFeatures_Lasso: {
                    ArrayList<PointF> points = new ArrayList<PointF>(this._graphicPoints);
                    points.add(new PointF(this._mouseLastPos.x, this._mouseLastPos.y));
                    g2.setColor(this.getForeground());
                    this._graphicPoints.add(new PointF(this._mouseLastPos.x, this._mouseLastPos.y));
                    Draw.drawPolyline(points, g2);
                    break;
                }
                case New_Circle: 
                case SelectFeatures_Circle: {
                    int radius = (int)Math.sqrt(Math.pow(this._mouseLastPos.x - this._mouseDownPoint.x, 2.0) + Math.pow(this._mouseLastPos.y - this._mouseDownPoint.y, 2.0));
                    g2.setColor(this.getForeground());
                    g2.drawLine(this._mouseDownPoint.x, this._mouseDownPoint.y, this._mouseLastPos.x, this._mouseLastPos.y);
                    g2.drawOval(this._mouseDownPoint.x - radius, this._mouseDownPoint.y - radius, radius * 2, radius * 2);
                    break;
                }
                case InEditingVertices: 
                case Edit_InEditingVertices: {
                    double[] sXY = this.projToScreen(this._editingVertices.get((int)1).X, this._editingVertices.get((int)1).Y);
                    g2.setColor(Color.black);
                    g2.drawLine((int)sXY[0], (int)sXY[1], this._mouseLastPos.x, this._mouseLastPos.y);
                    if (this._editingVertices.size() == 3) {
                        sXY = this.projToScreen(this._editingVertices.get((int)2).X, this._editingVertices.get((int)2).Y);
                        g2.drawLine((int)sXY[0], (int)sXY[1], this._mouseLastPos.x, this._mouseLastPos.y);
                    }
                    java.awt.Rectangle nRect = new java.awt.Rectangle(this._mouseLastPos.x - 3, this._mouseLastPos.y - 3, 6, 6);
                    g2.setColor(Color.cyan);
                    g2.fill(nRect);
                    g2.setColor(Color.black);
                    g2.draw(nRect);
                }
            }
        }
        block9 : switch (this._mouseTool) {
            case Edit_NewFeature: 
            case Edit_AddRing: 
            case Edit_FillRing: 
            case Edit_ReformFeature: 
            case Edit_SplitFeature: {
                VectorLayer selLayer = (VectorLayer)this.getSelectedLayer();
                if (this._startNewGraphic) break;
                ArrayList<PointF> points = new ArrayList<PointF>(this._graphicPoints);
                points.add(new PointF(this._mouseLastPos.x, this._mouseLastPos.y));
                g.setColor(this.getForeground());
                switch (this._mouseTool) {
                    case Edit_ReformFeature: 
                    case Edit_SplitFeature: {
                        Draw.drawPolyline(points, g2);
                        break block9;
                    }
                }
                if (selLayer.getShapeType().isLine()) {
                    Draw.drawPolyline(points, g2);
                    break;
                }
                if (!selLayer.getShapeType().isPolygon()) break;
                points.add((PointF)points.get(0));
                Draw.drawPolyline(points, g2);
                break;
            }
            case New_Polygon: 
            case New_Polyline: 
            case New_Curve: 
            case New_CurvePolygon: 
            case SelectFeatures_Polygon: {
                if (this._startNewGraphic) break;
                ArrayList<PointF> points = new ArrayList<PointF>(this._graphicPoints);
                points.add(new PointF(this._mouseLastPos.x, this._mouseLastPos.y));
                g.setColor(this.getForeground());
                switch (this._mouseTool) {
                    case New_Polyline: {
                        Draw.drawPolyline(points, g2);
                        break;
                    }
                    case New_Polygon: 
                    case SelectFeatures_Polygon: {
                        points.add((PointF)points.get(0));
                        Draw.drawPolyline(points, g2);
                        break;
                    }
                    case New_Curve: {
                        Draw.drawCurveLine(points, g2);
                        break;
                    }
                    case New_CurvePolygon: {
                        points.add((PointF)points.get(0));
                        Draw.drawCurveLine(points, g2);
                    }
                }
                break;
            }
            case Measurement: {
                if (this._startNewGraphic) break;
                PointF[] fpoints = this._graphicPoints.toArray(new PointF[this._graphicPoints.size()]);
                PointF[] points = new PointF[fpoints.length + 1];
                System.arraycopy(fpoints, 0, points, 0, fpoints.length);
                points[this._graphicPoints.size()] = new PointF(this._mouseLastPos.x, this._mouseLastPos.y);
                if (this._frmMeasure.getMeasureType() == FrmMeasurement.MeasureTypes.Length) {
                    g2.setColor(Color.red);
                    g2.setStroke(new BasicStroke(2.0f));
                    Draw.drawPolyline(points, g2);
                    break;
                }
                PointF[] ppoints = new PointF[points.length + 1];
                System.arraycopy(points, 0, ppoints, 0, points.length);
                ppoints[ppoints.length - 1] = this._graphicPoints.get(0);
                Color aColor = new Color(Color.blue.getRed(), Color.blue.getGreen(), Color.blue.getBlue(), 100);
                g.setColor(aColor);
                PolygonBreak aPB = new PolygonBreak();
                aPB.setColor(aColor);
                Draw.drawPolygon(ppoints, aPB, g2);
                g.setColor(Color.red);
                Draw.drawPolyline(ppoints, g2);
            }
        }
        if (this._drawIdentiferShape && this.getSelectedLayerHandle() >= 0 && (aLayer = this.getSelectedLayer()) != null && aLayer.getLayerType() == LayerTypes.VectorLayer) {
            VectorLayer vLayer = (VectorLayer)aLayer;
            this.drawIdShape(g2, vLayer.getShapes().get(vLayer.getIdentiferShape()));
        }
        g2.dispose();
    }

    @Override
    public int getWebMapZoom() {
        WebMapLayer layer = this.getWebMapLayer();
        if (layer != null) {
            return layer.getZoom();
        }
        return 0;
    }

    @Override
    public void reDraw() {
        this.repaintNew();
    }

    public void repaintNew() {
        if (this.doubleBuffer) {
            this.newPaint = false;
            this.paintLayers();
        } else {
            this.newPaint = true;
            this.repaint();
            this.updateViewImage();
        }
    }

    private void repaintOld() {
        if (this.doubleBuffer) {
            this.repaint();
        } else {
            this.newPaint = false;
            this.repaint();
        }
    }

    private void updateViewImage() {
        if (this.getWidth() < 5 || this.getHeight() < 5) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        this._mapBitmap = new BufferedImage(width, height, 2);
        Graphics2D g = this._mapBitmap.createGraphics();
        this.paint(g);
        g.dispose();
    }

    public void paintLayers() {
        if (this.getWidth() < 10 || this.getHeight() < 10) {
            return;
        }
        if (this.getLayerNum() == 0) {
            return;
        }
        if (!this._lockViewUpdate) {
            this._mapBitmap = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            Graphics2D g = this._mapBitmap.createGraphics();
            if (this.getBackground() != null) {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            if (this._antiAlias) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            } else {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
                g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
                g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
                g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
            }
            this._xGridPosLabel.clear();
            this._yGridPosLabel.clear();
            if (this._isGeoMap) {
                this.updateLonLatLayer();
                if (this._projection.isLonLatMap()) {
                    this.drawLonLatMap(g);
                } else {
                    this.drawProjectedMap(g);
                }
            } else {
                this.draw2DMap(g);
            }
            this.repaint();
        }
    }

    public void paintGraphics(Graphics2D g) {
        if (this._lockViewUpdate) {
            return;
        }
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.getMaskOutGraphicsPath(g);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this._antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
        }
        this._xGridPosLabel.clear();
        this._yGridPosLabel.clear();
        if (this._isGeoMap) {
            this.updateLonLatLayer();
            if (this._projection.isLonLatMap()) {
                this.drawLonLatMap(g);
            } else {
                this.drawProjectedMap(g);
            }
            this.getLonLatGridLabels();
        } else {
            this.draw2DMap(g);
        }
    }

    public void paintGraphics(Graphics2D g, Rectangle2D area, TileLoadListener tll) {
        java.awt.Rectangle rect = new java.awt.Rectangle((int)area.getX(), (int)area.getY(), (int)area.getWidth(), (int)area.getHeight());
        this.paintGraphics(g, rect, tll);
    }

    public void paintGraphics(Graphics2D g, java.awt.Rectangle rect, TileLoadListener tll) {
        if (this._lockViewUpdate) {
            return;
        }
        this.refreshXYScale(rect.width, rect.height);
        Color background = this.getBackground();
        if (background != null) {
            g.setColor(background);
            g.fill(rect);
        }
        AffineTransform oldMatrix = g.getTransform();
        java.awt.Rectangle oldRegion = g.getClipBounds();
        g.setClip(rect);
        this.getMaskOutGraphicsPath(g);
        g.translate(rect.x, rect.y);
        this._maskOutGraphicsPath.transform(g.getTransform());
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this._antiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
            g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
            g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
        }
        this._xGridPosLabel.clear();
        this._yGridPosLabel.clear();
        if (this._isGeoMap) {
            this.updateLonLatLayer();
            if (this._projection.isLonLatMap()) {
                this.drawLonLatMap(g, rect.width, rect.height);
            } else {
                this.drawProjectedMap(g, rect.width, rect.height, tll);
            }
            this.getLonLatGridLabels();
        } else {
            this.draw2DMap(g);
        }
        g.setTransform(oldMatrix);
        g.setClip(oldRegion);
    }

    private void drawLonLatMap(Graphics2D g) {
        this.drawLonLatMap(g, this.getWidth(), this.getHeight());
    }

    private void drawLonLatMap(Graphics2D g, int width, int heigth) {
        this.drawLayers(g, width, heigth);
        if (this._drawGridLine) {
            LegendScheme aLS = this._lonLatLayer.getLegendScheme();
            PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(0);
            aPLB.setColor(this._gridLineColor);
            aPLB.setWidth(this._gridLineSize);
            aPLB.setStyle(this._gridLineStyle);
            this.drawLonLatLayer(this._lonLatLayer, g, 0.0);
            if (this._multiGlobalDraw) {
                if (this._lonLatLayer.getExtent().minX > -360.0 && this._lonLatLayer.getExtent().maxX > 0.0) {
                    this.drawLonLatLayer(this._lonLatLayer, g, -360.0);
                }
                if (this._lonLatLayer.getExtent().maxX < 360.0 && this._lonLatLayer.getExtent().minX < 0.0) {
                    this.drawLonLatLayer(this._lonLatLayer, g, 360.0);
                }
            }
        }
        if (this._graphicCollection.size() > 0) {
            this.drawGraphicList(g, 0.0);
            if (this._multiGlobalDraw) {
                if (this._graphicCollection.getExtent().minX > -360.0 && this._graphicCollection.getExtent().maxX > 0.0) {
                    this.drawGraphicList(g, -360.0);
                }
                if (this._graphicCollection.getExtent().maxX < 360.0 && this._graphicCollection.getExtent().minX < 0.0) {
                    this.drawGraphicList(g, 360.0);
                }
            }
        }
    }

    private void drawProjectedMap(Graphics2D g) {
        this.drawProjectedMap(g, this.getWidth(), this.getHeight());
    }

    private void drawProjectedMap(Graphics2D g, int width, int heigth) {
        this.drawProjectedMap(g, width, heigth, this.tileLoadListener);
    }

    private void drawProjectedMap(Graphics2D g, int width, int heigth, TileLoadListener tll) {
        this.drawProjectedLayers(g, width, heigth, tll);
        if (this._drawGridLine) {
            this.drawLonLatLayer(this._lonLatLayer, g, 0.0);
        }
        this.drawGraphicList(g, 0.0);
    }

    private void draw2DMap(Graphics2D g) {
        this.drawLayers(g);
        this.drawXYGrid(g, this._xGridStrs, this._yGridStrs);
    }

    private void drawLayers(Graphics2D g) {
        this.drawLayers(g, this.getWidth(), this.getHeight());
    }

    private void drawLayers(Graphics2D g, int width, int height) {
        java.awt.Shape oldRegion = g.getClip();
        double geoScale = this.getGeoScale();
        for (MapLayer aLayer : this.layers) {
            if (!aLayer.isVisible() || aLayer.getVisibleScale().isEnableMinVisScale() && geoScale > aLayer.getVisibleScale().getMinVisScale() || aLayer.getVisibleScale().isEnableMaxVisScale() && geoScale < aLayer.getVisibleScale().getMaxVisScale()) continue;
            if (aLayer.isMaskout()) {
                this.setClipRegion(g);
                if (oldRegion != null) {
                    g.clip(oldRegion);
                }
            }
            switch (aLayer.getLayerType()) {
                case ImageLayer: {
                    ImageLayer aImageLayer = (ImageLayer)aLayer;
                    this.drawImage(g, aImageLayer, 0.0, width, height);
                    if (!this._multiGlobalDraw) break;
                    if (aImageLayer.getExtent().minX > -360.0 && aImageLayer.getExtent().maxX > 0.0) {
                        this.drawImage(g, aImageLayer, -360.0, width, height);
                    }
                    if (!(aImageLayer.getExtent().maxX < 360.0) || !(aImageLayer.getExtent().minX < 0.0)) break;
                    this.drawImage(g, aImageLayer, 360.0, width, height);
                    break;
                }
                case RasterLayer: {
                    RasterLayer aRLayer = (RasterLayer)aLayer;
                    this.drawRasterLayer(g, aRLayer, 0.0);
                    if (!this._multiGlobalDraw) break;
                    if (aRLayer.getExtent().minX > -360.0 && aRLayer.getExtent().maxX > 0.0) {
                        this.drawRasterLayer(g, aRLayer, -360.0);
                    }
                    if (!(aRLayer.getExtent().maxX < 360.0) || !(aRLayer.getExtent().minX < 0.0)) break;
                    this.drawRasterLayer(g, aRLayer, 360.0);
                    break;
                }
                case VectorLayer: {
                    VectorLayer aVLayer = (VectorLayer)aLayer;
                    boolean isDraw = true;
                    switch (aVLayer.getLayerDrawType()) {
                        case Vector: {
                            if (aVLayer.getShape(0).getShapeType() != ShapeTypes.WindArraw) break;
                            this.drawVectLayerWithLegendScheme(aVLayer, g, 0.0);
                            if (this._multiGlobalDraw) {
                                if (aLayer.getExtent().minX > -360.0 && aLayer.getExtent().maxX > 0.0) {
                                    this.drawVectLayerWithLegendScheme(aVLayer, g, -360.0);
                                }
                                if (aLayer.getExtent().maxX < 360.0 && aLayer.getExtent().minX < 0.0) {
                                    this.drawVectLayerWithLegendScheme(aVLayer, g, 360.0);
                                }
                            }
                            isDraw = false;
                            break;
                        }
                        case Barb: {
                            if (aVLayer.getShape(0).getShapeType() != ShapeTypes.WindBarb) break;
                            this.drawBarbLayerWithLegendScheme(aVLayer, g, 0.0);
                            if (this._multiGlobalDraw) {
                                if (aLayer.getExtent().minX > -360.0 && aLayer.getExtent().maxX > 0.0) {
                                    this.drawBarbLayerWithLegendScheme(aVLayer, g, -360.0);
                                }
                                if (aLayer.getExtent().maxX < 360.0 && aLayer.getExtent().minX < 0.0) {
                                    this.drawBarbLayerWithLegendScheme(aVLayer, g, 360.0);
                                }
                            }
                            isDraw = false;
                            break;
                        }
                        case StationModel: {
                            if (aVLayer.getShape(0).getShapeType() != ShapeTypes.StationModel) break;
                            this.drawStationModelLayer(aVLayer, g, 0.0);
                            if (this._multiGlobalDraw) {
                                if (aLayer.getExtent().minX > -360.0 && aLayer.getExtent().maxX > 0.0) {
                                    this.drawStationModelLayer(aVLayer, g, -360.0);
                                }
                                if (aLayer.getExtent().maxX < 360.0 && aLayer.getExtent().minX < 0.0) {
                                    this.drawStationModelLayer(aVLayer, g, 360.0);
                                }
                            }
                            isDraw = false;
                        }
                    }
                    if (!isDraw) break;
                    this.drawLayerWithLegendScheme(aVLayer, g, 0.0);
                    if (!this._multiGlobalDraw) break;
                    if (aLayer.getExtent().minX > -360.0 && aLayer.getExtent().maxX > 0.0) {
                        this.drawLayerWithLegendScheme(aVLayer, g, -360.0);
                    }
                    if (!(aLayer.getExtent().maxX < 360.0) || !(aLayer.getExtent().minX < 0.0)) break;
                    this.drawLayerWithLegendScheme(aVLayer, g, 360.0);
                    break;
                }
                case WebMapLayer: {
                    WebMapLayer webLayer = (WebMapLayer)aLayer;
                    this.drawWebMapLayer(webLayer, g, width, height);
                }
            }
            if (!aLayer.isMaskout()) continue;
            g.setClip(oldRegion);
        }
        this.fixMapScale = false;
    }

    private void drawImage(Graphics2D g, ImageLayer aILayer, double LonShift, int width, int height) {
        Extent lExtent = MIMath.shiftExtentLon(aILayer.getExtent(), LonShift);
        if (MIMath.isExtentCross(lExtent, this._drawExtent).booleanValue()) {
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, aILayer.getInterpolation());
            double XUL = aILayer.getExtent().minX;
            double YUL = aILayer.getExtent().maxY;
            double XBR = aILayer.getExtent().maxX;
            double YBR = aILayer.getExtent().minY;
            double[] sXY = this.projToScreen(XUL - aILayer.getWorldFilePara().xScale / 2.0, YUL - aILayer.getWorldFilePara().yScale / 2.0, LonShift);
            double sX = sXY[0];
            double sY = sXY[1];
            sXY = this.projToScreen(XBR, YBR, LonShift);
            double aWidth = sXY[0] - sX;
            double aHeight = sXY[1] - sY;
            if (aWidth < 5.0 || aHeight < 5.0) {
                return;
            }
            BufferedImage dImage = new BufferedImage(width, height, 2);
            Graphics2D dg = (Graphics2D)dImage.getGraphics();
            BufferedImage vImage = aILayer.getImage();
            double iWidth = vImage.getWidth();
            double iHeight = vImage.getHeight();
            double cw = aWidth / iWidth;
            double ch = aHeight / iHeight;
            double shx = aILayer.getWorldFilePara().xRotate;
            double shy = aILayer.getWorldFilePara().yRotate;
            AffineTransform mx = new AffineTransform();
            if (shx == 0.0 && shy == 0.0) {
                mx.translate(sX, sY);
                mx.scale(cw, ch);
            } else {
                shx = cw / aILayer.getWorldFilePara().xScale * shx;
                shy = ch / aILayer.getWorldFilePara().yScale * shy;
                mx = new AffineTransform(cw, shy, shx, ch, sX, sY);
            }
            dg.setTransform(mx);
            dg.setRenderingHint(RenderingHints.KEY_INTERPOLATION, aILayer.getInterpolation());
            dg.drawImage((Image)vImage, 0, 0, null);
            dg.dispose();
            if (aILayer.getTransparency() > 0) {
                int transPerc = 100 - aILayer.getTransparency();
                float[] scales = new float[]{1.0f, 1.0f, 1.0f, (float)transPerc / 100.0f};
                float[] offsets = new float[4];
                RescaleOp rop = new RescaleOp(scales, offsets, null);
                g.drawImage(dImage, rop, 0, 0);
            } else {
                g.drawImage((Image)dImage, 0, 0, null);
            }
        }
    }

    private void drawImage_back(Graphics2D g, ImageLayer aILayer, double LonShift, int width, int height) {
        Extent lExtent = MIMath.shiftExtentLon(aILayer.getExtent(), LonShift);
        if (MIMath.isExtentCross(lExtent, this._drawExtent).booleanValue()) {
            double XUL = aILayer.getExtent().minX;
            double YUL = aILayer.getExtent().maxY;
            double XBR = aILayer.getExtent().maxX;
            double YBR = aILayer.getExtent().minY;
            double[] sXY = this.projToScreen(XUL - aILayer.getWorldFilePara().xScale / 2.0, YUL - aILayer.getWorldFilePara().yScale / 2.0, LonShift);
            double sX = sXY[0];
            double sY = sXY[1];
            sXY = this.projToScreen(XBR, YBR, LonShift);
            double aWidth = sXY[0] - sX;
            double aHeight = sXY[1] - sY;
            if (aWidth < 5.0 || aHeight < 5.0) {
                return;
            }
            BufferedImage dImage = new BufferedImage(width, height, 2);
            Graphics2D dg = (Graphics2D)dImage.getGraphics();
            BufferedImage vImage = aILayer.getImage();
            float iWidth = vImage.getWidth();
            float iHeight = vImage.getHeight();
            float cw = (float)(aWidth / (double)iWidth);
            float ch = (float)(aHeight / (double)iHeight);
            AffineTransform mx = new AffineTransform();
            mx.translate((float)sX, (float)sY);
            mx.scale(cw, ch);
            dg.setTransform(mx);
            if (aILayer.getTransparency() > 0) {
                int transPerc = 100 - aILayer.getTransparency();
                float[] scales = new float[]{1.0f, 1.0f, 1.0f, (float)transPerc / 100.0f};
                float[] offsets = new float[4];
                RescaleOp rop = new RescaleOp(scales, offsets, null);
                dg.drawImage(vImage, rop, 0, 0);
            } else {
                dg.drawImage((Image)vImage, 0, 0, null);
            }
            dg.dispose();
            g.drawImage((Image)dImage, 0, 0, null);
        }
    }

    private void drawRasterLayer(Graphics2D g, RasterLayer aRLayer, double LonShift) {
        Extent lExtent = MIMath.shiftExtentLon(aRLayer.getExtent(), LonShift);
        if (MIMath.isExtentCross(lExtent, this._drawExtent).booleanValue()) {
            double XUL = aRLayer.getExtent().minX;
            double YUL = aRLayer.getExtent().maxY;
            double XBR = aRLayer.getExtent().maxX;
            double YBR = aRLayer.getExtent().minY;
            double[] sXY = this.projToScreen(XUL, YUL, LonShift);
            double sX = sXY[0];
            double sY = sXY[1];
            sXY = this.projToScreen(XBR, YBR, LonShift);
            double aWidth = sXY[0] - sX;
            double aHeigh = sXY[1] - sY;
            if (aWidth < 5.0 || aHeigh < 5.0) {
                return;
            }
            BufferedImage aImage = aRLayer.getImage();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, aRLayer.getInterpolation());
            g.drawImage(aImage, (int)sX, (int)sY, (int)(sX + aWidth), (int)(sY + aHeigh), 0, 0, aImage.getWidth(), aImage.getHeight(), null);
        }
    }

    private void drawProjectedLayers(Graphics2D g) {
        this.drawProjectedLayers(g, this.getWidth(), this.getHeight());
    }

    private void drawProjectedLayers(Graphics2D g, int width, int height) {
        this.drawProjectedMap(g, width, height, this.tileLoadListener);
    }

    private void drawProjectedLayers(Graphics2D g, int width, int height, TileLoadListener tll) {
        java.awt.Shape oldRegion = g.getClip();
        for (MapLayer aLayer : this.layers) {
            if (!aLayer.isVisible()) continue;
            if (aLayer.isMaskout() && aLayer.getLayerType() != LayerTypes.WebMapLayer) {
                this.setClipRegion(g);
                if (oldRegion != null) {
                    g.clip(oldRegion);
                }
            }
            block0 : switch (aLayer.getLayerType()) {
                case ImageLayer: {
                    ImageLayer aImageLayer = (ImageLayer)aLayer;
                    this.drawImage(g, aImageLayer, 0.0, width, height);
                    break;
                }
                case RasterLayer: {
                    RasterLayer aRLayer = (RasterLayer)aLayer;
                    this.drawRasterLayer(g, aRLayer, 0.0);
                    break;
                }
                case VectorLayer: {
                    VectorLayer aVLayer = (VectorLayer)aLayer;
                    switch (aLayer.getLayerDrawType()) {
                        case Vector: {
                            this.drawVectLayerWithLegendScheme(aVLayer, g, 0.0);
                            break block0;
                        }
                        case Barb: {
                            this.drawBarbLayerWithLegendScheme(aVLayer, g, 0.0);
                            break block0;
                        }
                        case StationModel: {
                            this.drawStationModelLayer(aVLayer, g, 0.0);
                            break block0;
                        }
                    }
                    this.drawLayerWithLegendScheme(aVLayer, g, 0.0);
                    break;
                }
                case WebMapLayer: {
                    WebMapLayer webLayer = (WebMapLayer)aLayer;
                    this.drawWebMapLayer(webLayer, g, width, height, tll);
                }
            }
            if (!aLayer.isMaskout()) continue;
            g.setClip(oldRegion);
        }
        this.fixMapScale = false;
    }

    public void drawLayerWithLegendScheme(VectorLayer aLayer, Graphics2D g, double LonShift) {
        Extent lExtent = MIMath.shiftExtentLon(aLayer.getExtent(), LonShift);
        if (!MIMath.isExtentCross(lExtent, this._drawExtent).booleanValue()) {
            return;
        }
        boolean hasDrawCharts = false;
        switch (aLayer.getShapeType()) {
            case Point: 
            case PointZ: 
            case PointM: {
                if (aLayer.getChartSet().isDrawCharts()) {
                    this.drawLayerCharts(g, aLayer, LonShift);
                    hasDrawCharts = true;
                }
                this.drawPointLayer(aLayer, g, LonShift);
                break;
            }
            case Polygon: 
            case PolygonM: 
            case PolygonZ: {
                this.drawPolygonLayer(aLayer, g, LonShift);
                break;
            }
            case Polyline: 
            case PolylineZ: 
            case PolylineM: {
                this.drawPolylineLayer(aLayer, g, LonShift);
            }
        }
        if (aLayer.getLabelSet().isDrawLabels()) {
            this.drawLayerLabels(g, aLayer, LonShift);
        }
        if (!hasDrawCharts && aLayer.getChartSet().isDrawCharts()) {
            this.drawLayerCharts(g, aLayer, LonShift);
        }
    }

    public void drawVectLayerWithLegendScheme(VectorLayer aLayer, Graphics2D g, double LonShift) {
        org.meteoinfo.global.PointD aPoint;
        Extent lExtent = MIMath.shiftExtentLon(aLayer.getExtent(), LonShift);
        if (!MIMath.isExtentCross(lExtent, this._drawExtent).booleanValue()) {
            return;
        }
        PointF sPoint = new PointF(0.0f, 0.0f);
        float max = ((PointBreak)aLayer.getLegendScheme().getLegendBreaks().get(0)).getSize() * 3.0f;
        ArrayList<WindArrow> windArraws = new ArrayList<WindArrow>();
        int shapeIdx = 0;
        ArrayList<Integer> idxList = new ArrayList<Integer>();
        for (Shape shape : aLayer.getShapes()) {
            WindArrow aArraw = (WindArrow)shape;
            aPoint = aArraw.getPoint();
            if (!(aPoint.X + LonShift < this._drawExtent.minX || aPoint.X + LonShift > this._drawExtent.maxX || aPoint.Y < this._drawExtent.minY || aPoint.Y > this._drawExtent.maxY)) {
                windArraws.add(aArraw);
                idxList.add(shapeIdx);
            }
            ++shapeIdx;
        }
        double zoom = (double)max / 30.0;
        aLayer.setDrawingZoom((float)zoom);
        LegendScheme aLS = aLayer.getLegendScheme();
        switch (aLS.getLegendType()) {
            case SingleSymbol: {
                ArrowBreak aPB = (ArrowBreak)aLS.getLegendBreaks().get(0);
                Color color = aPB.getColor();
                for (WindArrow aArraw : windArraws) {
                    aPoint = aArraw.getPoint();
                    double[] xy = this.projToScreen(aPoint.X, aPoint.Y, LonShift);
                    sPoint.X = (float)xy[0];
                    sPoint.Y = (float)xy[1];
                    Draw.drawArraw(sPoint, aArraw, aPB, g, zoom);
                }
                break;
            }
            case UniqueValue: {
                break;
            }
            case GraduatedColor: {
                for (int w = 0; w < windArraws.size(); ++w) {
                    WindArrow aArraw = (WindArrow)windArraws.get(w);
                    shapeIdx = (Integer)idxList.get(w);
                    aPoint = aArraw.getPoint();
                    double[] xy = this.projToScreen(aPoint.X, aPoint.Y, LonShift);
                    sPoint.X = (float)xy[0];
                    sPoint.Y = (float)xy[1];
                    String vStr = aLayer.getCellValue(aLS.getFieldName(), shapeIdx).toString().trim();
                    double value = vStr.isEmpty() ? 0.0 : Double.parseDouble(vStr);
                    int blNum = 0;
                    for (int i = 0; i < aLS.getLegendBreaks().size(); ++i) {
                        ArrowBreak aPB = (ArrowBreak)aLS.getLegendBreaks().get(i);
                        if (!(value == Double.parseDouble(aPB.getStartValue().toString()) || value > Double.parseDouble(aPB.getStartValue().toString()) && value < Double.parseDouble(aPB.getEndValue().toString())) && (blNum != aLS.getLegendBreaks().size() || value != Double.parseDouble(aPB.getEndValue().toString()))) continue;
                        Color color = aPB.getColor();
                        Draw.drawArraw(sPoint, aArraw, aPB, g, zoom);
                    }
                }
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void drawBarbLayerWithLegendScheme(VectorLayer aLayer, Graphics2D g, double LonShift) {
        org.meteoinfo.global.PointD aPoint;
        Extent lExtent = MIMath.shiftExtentLon(aLayer.getExtent(), LonShift);
        if (!MIMath.isExtentCross(lExtent, this._drawExtent).booleanValue()) {
            return;
        }
        PointF sPoint = new PointF(0.0f, 0.0f);
        LegendScheme aLS = aLayer.getLegendScheme();
        ArrayList<WindBarb> windBarbs = new ArrayList<WindBarb>();
        int shapeIdx = 0;
        for (Shape shape : aLayer.getShapes()) {
            WindBarb wBarb = (WindBarb)shape;
            aPoint = wBarb.getPoint();
            if (!(aPoint.X + LonShift < this._drawExtent.minX || aPoint.X + LonShift > this._drawExtent.maxX || aPoint.Y < this._drawExtent.minY || aPoint.Y > this._drawExtent.maxY)) {
                windBarbs.add(wBarb);
            }
            ++shapeIdx;
        }
        ArrayList<Extent> extentList = new ArrayList<Extent>();
        Extent extent = new Extent();
        Extent aExtent = new Extent();
        if (aLS.getLegendType() == LegendType.SingleSymbol) {
            PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(0);
            for (WindBarb aWB : windBarbs) {
                aPoint = aWB.getPoint();
                double[] xy = this.projToScreen(aPoint.X, aPoint.Y, LonShift);
                sPoint.X = (float)xy[0];
                sPoint.Y = (float)xy[1];
                if (aLayer.getAvoidCollision()) {
                    void var14_13;
                    float aSize = aPB.getSize() / 2.0f;
                    aExtent.minX = sPoint.X - aSize;
                    aExtent.maxX = sPoint.X + aSize;
                    aExtent.minY = sPoint.Y - aSize;
                    aExtent.maxY = sPoint.Y + aSize;
                    if (extentList.isEmpty()) {
                        Extent extent2 = (Extent)aExtent.clone();
                        extentList.add((Extent)aExtent.clone());
                        Draw.drawWindBarb(sPoint, aWB, aPB, g);
                        continue;
                    }
                    if (!MIMath.isExtentCross(aExtent, (Extent)var14_13).booleanValue()) {
                        extentList.add((Extent)aExtent.clone());
                        Extent extent3 = MIMath.getLagerExtent((Extent)var14_13, aExtent);
                        Draw.drawWindBarb(sPoint, aWB, aPB, g);
                        continue;
                    }
                    boolean ifDraw = true;
                    for (int i = 0; i < extentList.size(); ++i) {
                        if (!MIMath.isExtentCross(aExtent, (Extent)extentList.get(i)).booleanValue()) continue;
                        ifDraw = false;
                        break;
                    }
                    if (!ifDraw) continue;
                    extentList.add((Extent)aExtent.clone());
                    Extent extent4 = MIMath.getLagerExtent((Extent)var14_13, aExtent);
                    Draw.drawWindBarb(sPoint, aWB, aPB, g);
                    continue;
                }
                Draw.drawWindBarb(sPoint, aWB, aPB, g);
            }
        } else {
            shapeIdx = 0;
            for (WindBarb aWB : windBarbs) {
                String vStr = aLayer.getCellValue(aLS.getFieldName(), shapeIdx).toString().trim();
                double value = vStr == null || vStr.isEmpty() ? 0.0 : Double.parseDouble(vStr);
                aPoint = aWB.getPoint();
                double[] xy = this.projToScreen(aPoint.X, aPoint.Y, LonShift);
                sPoint.X = (float)xy[0];
                sPoint.Y = (float)xy[1];
                if (aLayer.getAvoidCollision()) {
                    void var14_17;
                    PointBreak aPB;
                    float aSize = ((PointBreak)aLS.getLegendBreaks().get(0)).getSize() / 2.0f;
                    aExtent.minX = sPoint.X - aSize;
                    aExtent.maxX = sPoint.X + aSize;
                    aExtent.minY = sPoint.Y - aSize;
                    aExtent.maxY = sPoint.Y + aSize;
                    if (extentList.isEmpty()) {
                        Extent extent5 = (Extent)aExtent.clone();
                        extentList.add((Extent)aExtent.clone());
                        for (ColorBreak aCB : aLS.getLegendBreaks()) {
                            aPB = (PointBreak)aCB;
                            if (value != Double.parseDouble(aPB.getStartValue().toString()) && (!(value > Double.parseDouble(aPB.getStartValue().toString())) || !(value < Double.parseDouble(aPB.getEndValue().toString())))) continue;
                            Draw.drawWindBarb(sPoint, aWB, aPB, g);
                        }
                    } else if (!MIMath.isExtentCross(aExtent, (Extent)var14_17).booleanValue()) {
                        extentList.add((Extent)aExtent.clone());
                        Extent extent6 = MIMath.getLagerExtent((Extent)var14_17, aExtent);
                        for (ColorBreak aCB : aLS.getLegendBreaks()) {
                            aPB = (PointBreak)aCB;
                            if (value != Double.parseDouble(aPB.getStartValue().toString()) && (!(value > Double.parseDouble(aPB.getStartValue().toString())) || !(value < Double.parseDouble(aPB.getEndValue().toString())))) continue;
                            Draw.drawWindBarb(sPoint, aWB, aPB, g);
                        }
                    } else {
                        boolean ifDraw = true;
                        for (int i = 0; i < extentList.size(); ++i) {
                            if (!MIMath.isExtentCross(aExtent, (Extent)extentList.get(i)).booleanValue()) continue;
                            ifDraw = false;
                            break;
                        }
                        if (ifDraw) {
                            extentList.add((Extent)aExtent.clone());
                            Extent extent7 = MIMath.getLagerExtent((Extent)var14_17, aExtent);
                            for (ColorBreak aCB : aLS.getLegendBreaks()) {
                                PointBreak aPB2 = (PointBreak)aCB;
                                if (value != Double.parseDouble(aPB2.getStartValue().toString()) && (!(value > Double.parseDouble(aPB2.getStartValue().toString())) || !(value < Double.parseDouble(aPB2.getEndValue().toString())))) continue;
                                Draw.drawWindBarb(sPoint, aWB, aPB2, g);
                            }
                        }
                    }
                } else {
                    for (ColorBreak aCB : aLS.getLegendBreaks()) {
                        PointBreak aPB = (PointBreak)aCB;
                        if (value != Double.parseDouble(aPB.getStartValue().toString()) && (!(value > Double.parseDouble(aPB.getStartValue().toString())) || !(value < Double.parseDouble(aPB.getEndValue().toString())))) continue;
                        Draw.drawWindBarb(sPoint, aWB, aPB, g);
                    }
                }
                ++shapeIdx;
            }
        }
    }

    private void drawLonLatLayer(VectorLayer aLayer, Graphics2D g, double LonShift) {
        Extent lExtent = MIMath.shiftExtentLon(aLayer.getExtent(), LonShift);
        if (!MIMath.isExtentCross(lExtent, this._drawExtent).booleanValue()) {
            return;
        }
        LegendScheme aLS = this._lonLatLayer.getLegendScheme();
        PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(0);
        aPLB.setColor(this._gridLineColor);
        aPLB.setWidth(this._gridLineSize);
        aPLB.setStyle(this._gridLineStyle);
        for (PolylineShape polylineShape : aLayer.getShapes()) {
            if (!polylineShape.isVisible() || !aPLB.getDrawPolyline()) continue;
            this.drawLonLatPolylineShape(g, polylineShape, aPLB, LonShift);
        }
    }

    private void drawLonLatPolylineShape(Graphics2D g, PolylineShape aPLS, PolylineBreak aPLB, double LonShift) {
        Extent shapeExtent = MIMath.shiftExtentLon(aPLS.getExtent(), LonShift);
        if (!MIMath.isExtentCross(shapeExtent, this._drawExtent).booleanValue()) {
            return;
        }
        List<? extends org.meteoinfo.global.PointD> newPList = aPLS.getPoints();
        PointF[] Points = new PointF[newPList.size()];
        for (int i = 0; i < newPList.size(); ++i) {
            org.meteoinfo.global.PointD wPoint = newPList.get(i);
            double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
            PointF aPoint = new PointF();
            aPoint.X = (float)sXY[0];
            aPoint.Y = (float)sXY[1];
            Points[i] = aPoint;
        }
        Color aColor = aPLB.getColor();
        if (aPLS.isSelected()) {
            aColor = this._selectColor;
        }
        float[] dashPattern = MapView.getDashPattern(aPLB.getStyle());
        BasicStroke pen = new BasicStroke(aPLB.getWidth(), 0, 0, 10.0f, dashPattern, 0.0f);
        g.setColor(aColor);
        g.setStroke(pen);
        if (aPLS.getPartNum() <= 1) {
            int p = 0;
            int i = 1;
            while (i < Points.length) {
                g.draw(new Line2D.Float(Points[p].X, Points[p].Y, Points[i].X, Points[i].Y));
                p = i++;
            }
        } else {
            for (int p = 0; p < aPLS.getPartNum(); ++p) {
                int pp;
                PointF[] Pointps;
                if (p == aPLS.getPartNum() - 1) {
                    Pointps = new PointF[aPLS.getPointNum() - aPLS.parts[p]];
                    for (pp = aPLS.parts[p]; pp < aPLS.getPointNum(); ++pp) {
                        Pointps[pp - aPLS.parts[p]] = Points[pp];
                    }
                } else {
                    Pointps = new PointF[aPLS.parts[p + 1] - aPLS.parts[p]];
                    for (pp = aPLS.parts[p]; pp < aPLS.parts[p + 1]; ++pp) {
                        Pointps[pp - aPLS.parts[p]] = Points[pp];
                    }
                }
                int f = 0;
                int i = 1;
                while (i < Pointps.length) {
                    g.draw(new Line2D.Float(Pointps[f].X, Pointps[f].Y, Pointps[i].X, Pointps[i].Y));
                    f = i++;
                }
            }
        }
    }

    private void drawPointLayer(VectorLayer aLayer, Graphics2D g, double LonShift) {
        RenderingHints rend = g.getRenderingHints();
        if (this._pointAntiAlias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        PointF aPoint = new PointF();
        LegendScheme aLS = aLayer.getLegendScheme();
        ArrayList<Extent> extentList = new ArrayList<Extent>();
        Extent maxExtent = new Extent();
        for (PointShape pointShape : aLayer.getShapes()) {
            PointBreak aPB;
            if (!pointShape.isVisible() || pointShape.getPoint().X + LonShift < this._drawExtent.minX || pointShape.getPoint().X + LonShift > this._drawExtent.maxX || pointShape.getPoint().Y < this._drawExtent.minY || pointShape.getPoint().Y > this._drawExtent.maxY || pointShape.getLegendIndex() < 0 || !(aPB = (PointBreak)aLS.getLegendBreaks().get(pointShape.getLegendIndex())).isDrawShape()) continue;
            double[] screenXY = this.projToScreen(pointShape.getPoint().X, pointShape.getPoint().Y, LonShift);
            aPoint.X = (float)screenXY[0];
            aPoint.Y = (float)screenXY[1];
            boolean ifDraw = true;
            if (aLayer.getAvoidCollision()) {
                float aSize = aPB.getSize() / 2.0f;
                Extent aExtent = new Extent();
                aExtent.minX = aPoint.X - aSize;
                aExtent.maxX = aPoint.X + aSize;
                aExtent.minY = aPoint.Y - aSize;
                aExtent.maxY = aPoint.Y + aSize;
                if (extentList.isEmpty()) {
                    maxExtent = (Extent)aExtent.clone();
                    extentList.add(aExtent);
                } else if (!MIMath.isExtentCross(aExtent, maxExtent).booleanValue()) {
                    extentList.add(aExtent);
                    maxExtent = MIMath.getLagerExtent(maxExtent, aExtent);
                } else {
                    for (Extent extent : extentList) {
                        if (!MIMath.isExtentCross(aExtent, extent).booleanValue()) continue;
                        ifDraw = false;
                        break;
                    }
                    if (ifDraw) {
                        extentList.add(aExtent);
                        maxExtent = MIMath.getLagerExtent(maxExtent, aExtent);
                    }
                }
            }
            if (!ifDraw) continue;
            if (pointShape.isSelected()) {
                PointBreak newPB = (PointBreak)aPB.clone();
                newPB.setColor(this._selectColor);
                newPB.setSize(10.0f);
                if (aPB.getSize() > 10.0f) {
                    newPB.setSize(aPB.getSize());
                } else {
                    newPB.setDrawOutline(false);
                }
                Draw.drawMapPoint(new PointF(aPoint.X, aPoint.Y), newPB, g);
                if (!pointShape.isEditing()) continue;
                Draw.drawSelectedVertice(g, aPoint, 8.0f, Color.red, Color.cyan);
                continue;
            }
            Draw.drawMapPoint(aPoint, aPB, g);
        }
        if (this._pointAntiAlias) {
            g.setRenderingHints(rend);
        }
    }

    private void drawStationModelLayer(VectorLayer aLayer, Graphics2D g, double LonShift) {
        PointF aPoint = new PointF();
        LegendScheme aLS = aLayer.getLegendScheme();
        ArrayList<Extent> extentList = new ArrayList<Extent>();
        Extent maxExtent = new Extent();
        for (StationModelShape stationModelShape : aLayer.getShapes()) {
            PointBreak aPB;
            if (stationModelShape.getPoint().X + LonShift < this._drawExtent.minX || stationModelShape.getPoint().X + LonShift > this._drawExtent.maxX || stationModelShape.getPoint().Y < this._drawExtent.minY || stationModelShape.getPoint().Y > this._drawExtent.maxY || stationModelShape.getLegendIndex() < 0 || !(aPB = (PointBreak)aLS.getLegendBreaks().get(stationModelShape.getLegendIndex())).isDrawShape()) continue;
            double[] screenXY = this.projToScreen(stationModelShape.getPoint().X, stationModelShape.getPoint().Y, LonShift);
            aPoint.X = (float)screenXY[0];
            aPoint.Y = (float)screenXY[1];
            boolean ifDraw = true;
            if (aLayer.getAvoidCollision()) {
                float aSize = aPB.getSize();
                Extent aExtent = new Extent();
                aExtent.minX = aPoint.X - aSize;
                aExtent.maxX = aPoint.X + aSize;
                aExtent.minY = aPoint.Y - aSize;
                aExtent.maxY = aPoint.Y + aSize;
                if (extentList.isEmpty()) {
                    maxExtent = (Extent)aExtent.clone();
                    extentList.add(aExtent);
                } else if (!MIMath.isExtentCross(aExtent, maxExtent).booleanValue()) {
                    extentList.add(aExtent);
                    maxExtent = MIMath.getLagerExtent(maxExtent, aExtent);
                } else {
                    for (Extent extent : extentList) {
                        if (!MIMath.isExtentCross(aExtent, extent).booleanValue()) continue;
                        ifDraw = false;
                        break;
                    }
                    if (ifDraw) {
                        extentList.add(aExtent);
                        maxExtent = MIMath.getLagerExtent(maxExtent, aExtent);
                    }
                }
            }
            if (!ifDraw) continue;
            if (stationModelShape.isSelected()) {
                PointBreak newPB = (PointBreak)aPB.clone();
                newPB.setColor(this._selectColor);
                Draw.drawStationModel(this._selectColor, this.getForeground(), aPoint, stationModelShape, g, aPB.getSize(), aPB.getSize() / 8.0f * 3.0f);
                continue;
            }
            Draw.drawStationModel(aPB.getColor(), this.getForeground(), aPoint, stationModelShape, g, aPB.getSize(), aPB.getSize() / 8.0f * 3.0f);
        }
    }

    private void drawPolygonLayer(VectorLayer aLayer, Graphics2D g, double LonShift) {
        LegendScheme aLS = aLayer.getLegendScheme();
        for (int s = 0; s < aLayer.getShapeNum(); ++s) {
            PolygonBreak aPGB;
            PolygonShape polygonShape = (PolygonShape)aLayer.getShapes().get(s);
            if (!polygonShape.isVisible() || polygonShape.getLegendIndex() < 0 || !(aPGB = (PolygonBreak)aLS.getLegendBreaks().get(polygonShape.getLegendIndex())).isDrawShape()) continue;
            this.drawPolygonShape(g, polygonShape, aPGB, LonShift);
        }
        for (PolygonShape polygonShape : aLayer.getShapes()) {
            if (!polygonShape.isEditing()) continue;
            ArrayList pointList = new ArrayList();
            for (Polygon polygon : polygonShape.getPolygons()) {
                int i;
                ArrayList<PointF> rPoints = new ArrayList<PointF>();
                for (i = 0; i < polygon.getOutLine().size(); ++i) {
                    org.meteoinfo.global.PointD wPoint = polygon.getOutLine().get(i);
                    double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
                    rPoints.add(new PointF((float)sXY[0], (float)sXY[1]));
                }
                for (i = 0; i < polygon.getHoleLines().size(); ++i) {
                    for (int j = 0; j < polygon.getHoleLines().get(i).size(); ++j) {
                        org.meteoinfo.global.PointD wPoint = polygon.getHoleLines().get(i).get(j);
                        double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
                        rPoints.add(new PointF((float)sXY[0], (float)sXY[1]));
                    }
                }
                pointList.addAll(rPoints);
            }
            for (PointF pointF : pointList) {
                Draw.drawSelectedVertice(g, pointF, 8.0f, Color.red, Color.cyan);
            }
        }
    }

    private void drawPolylineLayer(VectorLayer aLayer, Graphics2D g, double LonShift) {
        LegendScheme aLS = aLayer.getLegendScheme();
        if (aLS.isGeometry()) {
            for (int s = 0; s < aLayer.getShapeNum(); ++s) {
                PolylineShape aPLS = (PolylineShape)aLayer.getShapes().get(s);
                if (!aPLS.isVisible()) continue;
                this.drawPolylineShape(g, aPLS, aLS, LonShift);
            }
        } else {
            boolean isStreamline = false;
            switch (aLayer.getLayerDrawType()) {
                case Streamline: {
                    isStreamline = true;
                }
            }
            for (int s = 0; s < aLayer.getShapeNum(); ++s) {
                PolylineBreak aPLB;
                PolylineShape aPLS = (PolylineShape)aLayer.getShapes().get(s);
                if (!aPLS.isVisible() || aPLS.getLegendIndex() < 0 || !(aPLB = (PolylineBreak)aLS.getLegendBreaks().get(aPLS.getLegendIndex())).getDrawPolyline() && !aPLB.getDrawSymbol()) continue;
                this.drawPolylineShape(g, aPLS, aPLB, LonShift, isStreamline);
            }
        }
    }

    private static float[] getDashPattern(LineStyles style) {
        float[] dashPattern = new float[]{4.0f};
        switch (style) {
            case SOLID: {
                dashPattern = null;
                break;
            }
            case DASH: {
                dashPattern = new float[]{4.0f};
                break;
            }
            case DOT: {
                dashPattern = new float[]{2.0f};
                break;
            }
            case DASHDOT: {
                dashPattern = new float[]{10.0f, 6.0f, 2.0f, 6.0f};
                break;
            }
            case DASHDOTDOT: {
                dashPattern = new float[]{10.0f, 6.0f, 2.0f, 6.0f, 2.0f, 6.0f};
            }
        }
        return dashPattern;
    }

    private void drawPolylineShape(Graphics2D g, PolylineShape aPLS, PolylineBreak aPLB, double LonShift, boolean isStreamline) {
        this.drawPolylineShape(g, aPLS, aPLB, LonShift, isStreamline, false, false);
    }

    /*
     * WARNING - void declaration
     */
    private void drawPolylineShape(Graphics2D g, PolylineShape aPLS, PolylineBreak aPLB, double LonShift, boolean isStreamline, boolean isSelected, boolean isIdentifer) {
        Extent shapeExtent = MIMath.shiftExtentLon(aPLS.getExtent(), LonShift);
        if (!MIMath.isExtentCross(shapeExtent, this._drawExtent).booleanValue()) {
            return;
        }
        int len1 = aPLS.getPoints().size();
        GeneralPath path = new GeneralPath(0, len1);
        Color aColor = aPLB.getColor();
        Float size = Float.valueOf(aPLB.getWidth());
        if (!isIdentifer && aPLS.isSelected()) {
            aColor = this._selectColor;
            size = Float.valueOf(2.5f);
        }
        float[] dashPattern = MapView.getDashPattern(aPLB.getStyle());
        BasicStroke pen = new BasicStroke(size.floatValue(), 0, 0, 10.0f, dashPattern, 0.0f);
        g.setColor(aColor);
        g.setStroke(pen);
        ArrayList<PointF> drawPs = new ArrayList<PointF>();
        if (aPLB.getDrawPolyline()) {
            for (Polyline polyline : aPLS.getPolylines()) {
                PointF[] Points = new PointF[polyline.getPointList().size()];
                for (int i = 0; i < polyline.getPointList().size(); ++i) {
                    org.meteoinfo.global.PointD wPoint = polyline.getPointList().get(i);
                    double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
                    if (i == 0) {
                        path.moveTo(sXY[0], sXY[1]);
                    } else {
                        path.lineTo(sXY[0], sXY[1]);
                    }
                    Points[i] = new PointF((float)sXY[0], (float)sXY[1]);
                    drawPs.add(new PointF((float)sXY[0], (float)sXY[1]));
                }
                if (isStreamline) {
                    Draw.drawPolyline(Points, aPLB, g);
                }
                g.draw(path);
                path.reset();
            }
        }
        if (aPLB.getDrawSymbol()) {
            void var18_19;
            Iterator rend = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            boolean bl = false;
            while (var18_19 < drawPs.size()) {
                if (var18_19 % aPLB.getSymbolInterval() == false) {
                    Draw.drawPoint(aPLB.getSymbolStyle(), (PointF)drawPs.get((int)var18_19), aPLB.getSymbolFillColor(), aPLB.getSymbolColor(), aPLB.getSymbolSize(), true, aPLB.isFillSymbol(), g);
                }
                ++var18_19;
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rend);
        }
        if (aPLS.isEditing()) {
            for (PointF pointF : drawPs) {
                Draw.drawSelectedVertice(g, pointF, 8.0f, Color.red, Color.cyan);
            }
        }
        if (isSelected) {
            Extent aExtent = MIMath.getPointFsExtent(drawPs);
            g.setColor(Color.cyan);
            g.drawRect((int)aExtent.minX, (int)aExtent.minY, (int)aExtent.getWidth(), (int)aExtent.getHeight());
        }
    }

    private void drawPolylineShape(Graphics2D g, PolylineShape aPLS, LegendScheme ls, double LonShift) {
        Extent shapeExtent = MIMath.shiftExtentLon(aPLS.getExtent(), LonShift);
        if (!MIMath.isExtentCross(shapeExtent, this._drawExtent).booleanValue()) {
            return;
        }
        int len1 = aPLS.getPoints().size();
        GeneralPath path = new GeneralPath(0, len1);
        ArrayList<PointF> drawPs = new ArrayList<PointF>();
        boolean isZ = ls.getFieldName().equals("Geometry_Z");
        for (Polyline polyline : aPLS.getPolylines()) {
            for (int i = 0; i < polyline.getPointList().size(); ++i) {
                PointZ wPoint = (PointZ)polyline.getPointList().get(i);
                double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
                if (i == 0) {
                    path.moveTo(sXY[0], sXY[1]);
                } else {
                    path.lineTo(sXY[0], sXY[1]);
                    double v = isZ ? wPoint.Z : wPoint.M;
                    PolylineBreak aPLB = (PolylineBreak)ls.findLegendBreak(v);
                    Color aColor = aPLB.getColor();
                    Float size = Float.valueOf(aPLB.getWidth());
                    float[] dashPattern = MapView.getDashPattern(aPLB.getStyle());
                    BasicStroke pen = new BasicStroke(size.floatValue(), 0, 0, 10.0f, dashPattern, 0.0f);
                    g.setColor(aColor);
                    g.setStroke(pen);
                    g.draw(path);
                    path.reset();
                    path.moveTo(sXY[0], sXY[1]);
                    if (aPLB.getDrawSymbol()) {
                        Object rend = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        for (int j = 0; j < drawPs.size(); ++j) {
                            Draw.drawPoint(aPLB.getSymbolStyle(), new PointF((float)sXY[0], (float)sXY[1]), aPLB.getSymbolFillColor(), aPLB.getSymbolColor(), aPLB.getSymbolSize(), true, aPLB.isFillSymbol(), g);
                        }
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rend);
                    }
                }
                drawPs.add(new PointF((float)sXY[0], (float)sXY[1]));
            }
        }
        if (aPLS.isEditing()) {
            for (PointF pointF : drawPs) {
                Draw.drawSelectedVertice(g, pointF, 8.0f, Color.red, Color.cyan);
            }
        }
    }

    private void drawPolygonShape(Graphics2D g, PolygonShape aPGS, PolygonBreak aPGB, double LonShift) {
        this.drawPolygonShape(g, aPGS, aPGB, LonShift, false);
    }

    private void drawPolygonShape(Graphics2D g, PolygonShape aPGS, PolygonBreak aPGB, double LonShift, boolean isSelected) {
        Extent shapeExtent = MIMath.shiftExtentLon(aPGS.getExtent(), LonShift);
        if (!MIMath.isExtentCross(shapeExtent, this._drawExtent).booleanValue()) {
            return;
        }
        ArrayList<PointF> pointList = new ArrayList<PointF>();
        for (Polygon polygon : aPGS.getPolygons()) {
            pointList.addAll(this.drawPolygon(g, polygon, aPGB, LonShift, aPGS.isSelected()));
        }
        if (isSelected) {
            Extent aExtent = MIMath.getPointFsExtent(pointList);
            g.setColor(Color.red);
            g.drawRect((int)aExtent.minX, (int)aExtent.minY, (int)aExtent.getWidth(), (int)aExtent.getHeight());
        }
    }

    private List<PointF> drawPolygon(Graphics2D g, Polygon aPG, PolygonBreak aPGB, double LonShift, boolean isSelected) {
        double[] sXY;
        org.meteoinfo.global.PointD wPoint;
        int len = aPG.getOutLine().size();
        GeneralPath path = new GeneralPath(0, len);
        path.moveTo(0.0f, 0.0f);
        ArrayList<PointF> rPoints = new ArrayList<PointF>();
        for (int i = 0; i < aPG.getOutLine().size(); ++i) {
            wPoint = aPG.getOutLine().get(i);
            sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
            if (i == 0) {
                path.moveTo(sXY[0], sXY[1]);
            } else {
                path.lineTo(sXY[0], sXY[1]);
            }
            rPoints.add(new PointF((float)sXY[0], (float)sXY[1]));
        }
        if (aPG.hasHole()) {
            for (int h = 0; h < aPG.getHoleLines().size(); ++h) {
                List<? extends org.meteoinfo.global.PointD> newPList = aPG.getHoleLines().get(h);
                for (int j = 0; j < newPList.size(); ++j) {
                    wPoint = newPList.get(j);
                    sXY = this.projToScreen(wPoint.X, wPoint.Y, LonShift);
                    if (j == 0) {
                        path.moveTo(sXY[0], sXY[1]);
                        continue;
                    }
                    path.lineTo(sXY[0], sXY[1]);
                }
            }
        }
        path.closePath();
        if (aPGB.isDrawFill()) {
            Color aColor = aPGB.getColor();
            if (isSelected) {
                aColor = this._selectColor;
            }
            if (aPGB.isUsingHatchStyle()) {
                int size = aPGB.getStyleSize();
                BufferedImage bi = Draw.getHatchImage(aPGB.getStyle(), size, aPGB.getColor(), aPGB.getBackColor());
                Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, size, size);
                g.setPaint(new TexturePaint(bi, rect));
                g.fill(path);
            } else {
                g.setColor(aColor);
                g.fill(path);
            }
        } else if (isSelected) {
            g.setColor(this._selectColor);
            g.fill(path);
        }
        if (aPGB.isDrawOutline()) {
            BasicStroke pen = new BasicStroke(aPGB.getOutlineSize());
            g.setStroke(pen);
            g.setColor(aPGB.getOutlineColor());
            g.draw(path);
        }
        return rPoints;
    }

    private void drawWebMapLayer(WebMapLayer layer, Graphics2D g, int width, int height) {
        this.drawWebMapLayer(layer, g, width, height, this.tileLoadListener);
    }

    private void drawWebMapLayer(WebMapLayer layer, Graphics2D g, int width, int height, TileLoadListener tll) {
        org.meteoinfo.global.PointD geoCenter = this.getGeoCenter();
        layer.setAddressLocation(new GeoPosition(geoCenter.Y, geoCenter.X));
        if (this.fixMapScale) {
            layer.setWebMapScale(this._scaleX);
            layer.setZoom(this.zoomLevel);
        } else {
            this.zoomLevel = layer.getZoom();
            double webMapScale = layer.getWebMapScale();
            if (!MIMath.doubleEquals(this._scaleX, webMapScale)) {
                int minZoom = layer.getTileFactory().getInfo().getMinimumZoomLevel();
                int maxZoom = layer.getTileFactory().getInfo().getMaximumZoomLevel();
                int nzoom = minZoom;
                for (int i = maxZoom; i >= minZoom; --i) {
                    layer.setZoom(i);
                    double scale = this.getWebMapScale(layer, i, width, height);
                    if (!(this._scaleX < scale) && !MIMath.doubleEquals(this._scaleX, scale)) continue;
                    this.setScale(scale, width, height);
                    nzoom = i;
                    webMapScale = scale;
                    layer.setWebMapScale(webMapScale);
                    break;
                }
                boolean addOne = false;
                if (this.zoomLevel == minZoom) {
                    addOne = true;
                } else if (nzoom < maxZoom) {
                    addOne = true;
                }
                if (addOne) {
                    this.zoomLevel = nzoom + 1;
                    webMapScale = this.getWebMapScale(layer, this.zoomLevel, width, height);
                    this.setScale(webMapScale, width, height);
                    layer.setWebMapScale(webMapScale);
                    layer.setZoom(this.zoomLevel);
                } else {
                    this.zoomLevel = nzoom;
                }
            }
            this.fixMapScale = true;
        }
        if (layer.isMaskout()) {
            java.awt.Shape oldRegion = g.getClip();
            this.setClipRegion(g);
            if (oldRegion != null) {
                g.clip(oldRegion);
            }
        }
        layer.drawWebMapLayer(g, width, height, tll);
    }

    private double getWebMapScale(WebMapLayer layer, int zoom, int width, int height) {
        Point2D center = layer.getCenter();
        double minx = center.getX() - (double)(width / 2);
        double miny = center.getY() - (double)(height / 2);
        double maxx = center.getX() + (double)(width / 2);
        double maxy = center.getY() + (double)(height / 2);
        GeoPosition pos1 = GeoUtil.getPosition(new Point2D.Double(minx, miny), zoom, layer.getTileFactory().getInfo());
        GeoPosition pos2 = GeoUtil.getPosition(new Point2D.Double(maxx, maxy), zoom, layer.getTileFactory().getInfo());
        org.meteoinfo.global.PointD p1 = Reproject.reprojectPoint(new org.meteoinfo.global.PointD(pos1.getLongitude(), pos1.getLatitude()), KnownCoordinateSystems.geographic.world.WGS1984, this.getProjection().getProjInfo());
        org.meteoinfo.global.PointD p2 = Reproject.reprojectPoint(new org.meteoinfo.global.PointD(pos2.getLongitude(), pos2.getLatitude()), KnownCoordinateSystems.geographic.world.WGS1984, this.getProjection().getProjInfo());
        if (pos2.getLongitude() - pos1.getLongitude() < 360.0) {
            double xlen = p2.X - p1.X;
            return (double)width / xlen;
        }
        double ylen = Math.abs(p2.Y - p1.Y);
        return (double)height / ylen;
    }

    public WebMapLayer getWebMapLayer() {
        for (MapLayer layer : this.layers) {
            if (layer.getLayerType() != LayerTypes.WebMapLayer) continue;
            return (WebMapLayer)layer;
        }
        return null;
    }

    public void drawGraphicList(Graphics2D g, double lonShift) {
        if (this._graphicCollection.size() > 0) {
            Extent aExtent = MIMath.shiftExtentLon(this._graphicCollection.getExtent(), lonShift);
            if (!MIMath.isExtentCross(aExtent, this._drawExtent).booleanValue()) {
                return;
            }
            Object aSM = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            for (int i = 0; i < this._graphicCollection.getNumGraphics(); ++i) {
                Graphic graphic = this._graphicCollection.get(i);
                for (int j = 0; j < graphic.getNumGraphics(); ++j) {
                    Graphic gg = graphic.getGraphicN(j);
                    this.drawGraphic(g, gg, lonShift);
                }
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aSM);
        }
    }

    public void drawGraphic(Graphics2D g, Graphic graphic, java.awt.Rectangle rect) {
        this.refreshXYScale(rect.width, rect.height);
        AffineTransform oldMatrix = g.getTransform();
        java.awt.Rectangle oldRegion = g.getClipBounds();
        g.setClip(rect);
        this.getMaskOutGraphicsPath(g);
        g.translate(rect.x, rect.y);
        this._maskOutGraphicsPath.transform(g.getTransform());
        RenderingHints rend = g.getRenderingHints();
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        this.drawGraphic(g, graphic, 0.0);
        g.setTransform(oldMatrix);
        g.setClip(oldRegion);
        g.setRenderingHints(rend);
    }

    public void drawGraphic(Graphics2D g, Graphic aGraphic, double lonShift) {
        Extent aExtent = MIMath.shiftExtentLon(aGraphic.getShape().getExtent(), lonShift);
        if (MIMath.isExtentCross(aExtent, this._drawExtent).booleanValue()) {
            Object rend = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            switch (aGraphic.getShape().getShapeType()) {
                case Polygon: 
                case Rectangle: 
                case Circle: 
                case CurvePolygon: 
                case Ellipse: {
                    if (!((PolygonBreak)aGraphic.getLegend()).isMaskout()) break;
                    this.setClipRegion(g);
                }
            }
            List<? extends org.meteoinfo.global.PointD> points = aGraphic.getShape().getPoints();
            PointF[] screenPoints = new PointF[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                double[] sXY = this.projToScreen(points.get((int)i).X, points.get((int)i).Y, lonShift);
                screenPoints[i] = new PointF((float)sXY[0], (float)sXY[1]);
            }
            Draw.drawGrahpic(screenPoints, aGraphic, g, this._mouseTool == MouseTools.EditVertices);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rend);
        }
    }

    private void getMaskOutGraphicsPath(Graphics2D g) {
        int aLayerHandle;
        if (this._maskOut.isMask() && (aLayerHandle = this.getLayerHandleFromName(this._maskOut.getMaskLayer())) > 0) {
            GeneralPath tPath = new GeneralPath();
            VectorLayer aLayer = (VectorLayer)this.getLayerByHandle(aLayerHandle);
            double[] lonShiftList = new double[]{0.0};
            if (this._projection.isLonLatMap()) {
                lonShiftList = new double[]{0.0, 360.0, -360.0};
            }
            for (double lonShift : lonShiftList) {
                for (PolygonShape polygonShape : aLayer.getShapes()) {
                    for (Polygon polygon : polygonShape.getPolygons()) {
                        GeneralPath aPath = new GeneralPath();
                        for (int i = 0; i < polygon.getOutLine().size(); ++i) {
                            org.meteoinfo.global.PointD wPoint = polygon.getOutLine().get(i);
                            double[] sXY = this.projToScreen(wPoint.X, wPoint.Y, lonShift);
                            if (i == 0) {
                                aPath.moveTo(sXY[0], sXY[1]);
                                continue;
                            }
                            aPath.lineTo(sXY[0], sXY[1]);
                        }
                        tPath.append(aPath, false);
                    }
                }
            }
            this._maskOutGraphicsPath = tPath;
        }
    }

    private void setClipRegion(Graphics2D g) {
        int aLayerHandle;
        if (this._maskOut.isMask() && (aLayerHandle = this.getLayerHandleFromName(this._maskOut.getMaskLayer())) > 0) {
            this.getMaskOutGraphicsPath(g);
            g.setClip(this._maskOutGraphicsPath);
        }
    }

    public void drawIdShape(Graphics2D g, Shape aShape) {
        ArrayList<Double> lonShifts = new ArrayList<Double>();
        if (MIMath.isExtentCross(this.getViewExtent(), aShape.getExtent()).booleanValue()) {
            lonShifts.add(new Double(0.0));
        }
        if (MIMath.isExtentCross(this.getViewExtent(), MIMath.shiftExtentLon(aShape.getExtent(), 360.0)).booleanValue()) {
            lonShifts.add(new Double(360.0));
        }
        if (MIMath.isExtentCross(this.getViewExtent(), MIMath.shiftExtentLon(aShape.getExtent(), -360.0)).booleanValue()) {
            lonShifts.add(new Double(-360.0));
        }
        this.getMaskOutGraphicsPath(g);
        Iterator iterator = lonShifts.iterator();
        while (iterator.hasNext()) {
            double LonShift = (Double)iterator.next();
            switch (aShape.getShapeType()) {
                case Point: 
                case PointZ: 
                case PointM: {
                    PointShape aPS = (PointShape)aShape;
                    double[] sXY = this.projToScreen(aPS.getPoint().X, aPS.getPoint().Y, LonShift);
                    PointF aPoint = new PointF();
                    aPoint.X = (float)sXY[0];
                    aPoint.Y = (float)sXY[1];
                    PointBreak aPB = new PointBreak();
                    aPB.setOutlineColor(Color.red);
                    aPB.setSize(10.0f);
                    aPB.setStyle(PointStyle.Square);
                    aPB.setDrawFill(false);
                    Draw.drawPoint(aPoint, aPB, g);
                    break;
                }
                case Polyline: 
                case PolylineZ: 
                case PolylineM: {
                    PolylineShape aPLS = (PolylineShape)aShape;
                    PolylineBreak aPLB = new PolylineBreak();
                    aPLB.setColor(Color.red);
                    aPLB.setWidth(2.0f);
                    this.drawPolylineShape(g, aPLS, aPLB, LonShift, false, false, true);
                    break;
                }
                case Polygon: 
                case PolygonM: 
                case PolygonZ: {
                    PolygonShape aPGS = (PolygonShape)aShape;
                    PolygonBreak aPGB = new PolygonBreak();
                    aPGB.setOutlineColor(Color.red);
                    aPGB.setOutlineSize(2.0f);
                    aPGB.setColor(Color.red);
                    this.drawPolygonShape(g, aPGS, aPGB, LonShift);
                }
            }
        }
    }

    public void drawIdShape(Graphics2D g, Shape aShape, java.awt.Rectangle rect) {
        ArrayList<Double> lonShifts = new ArrayList<Double>();
        if (MIMath.isExtentCross(this.getViewExtent(), aShape.getExtent()).booleanValue()) {
            lonShifts.add(new Double(0.0));
        }
        if (MIMath.isExtentCross(this.getViewExtent(), MIMath.shiftExtentLon(aShape.getExtent(), 360.0)).booleanValue()) {
            lonShifts.add(new Double(360.0));
        }
        if (MIMath.isExtentCross(this.getViewExtent(), MIMath.shiftExtentLon(aShape.getExtent(), -360.0)).booleanValue()) {
            lonShifts.add(new Double(-360.0));
        }
        AffineTransform oldMatrix = g.getTransform();
        java.awt.Shape oldRegion = g.getClip();
        g.setClip(rect);
        this.getMaskOutGraphicsPath(g);
        g.translate(rect.x, rect.y);
        Iterator iterator = lonShifts.iterator();
        while (iterator.hasNext()) {
            double LonShift = (Double)iterator.next();
            switch (aShape.getShapeType()) {
                case Point: 
                case PointZ: 
                case PointM: {
                    PointShape aPS = (PointShape)aShape;
                    double[] sXY = this.projToScreen(aPS.getPoint().X, aPS.getPoint().Y, LonShift);
                    PointF aPoint = new PointF();
                    aPoint.X = (float)sXY[0];
                    aPoint.Y = (float)sXY[1];
                    PointBreak aPB = new PointBreak();
                    aPB.setOutlineColor(Color.red);
                    aPB.setSize(10.0f);
                    aPB.setStyle(PointStyle.Square);
                    aPB.setDrawFill(false);
                    Draw.drawPoint(aPoint, aPB, g);
                    break;
                }
                case Polyline: 
                case PolylineZ: 
                case PolylineM: {
                    PolylineShape aPLS = (PolylineShape)aShape;
                    PolylineBreak aPLB = new PolylineBreak();
                    aPLB.setColor(Color.red);
                    aPLB.setWidth(2.0f);
                    this.drawPolylineShape(g, aPLS, aPLB, LonShift, false);
                    break;
                }
                case Polygon: 
                case PolygonM: 
                case PolygonZ: {
                    PolygonShape aPGS = (PolygonShape)aShape;
                    PolygonBreak aPGB = new PolygonBreak();
                    aPGB.setOutlineColor(Color.red);
                    aPGB.setOutlineSize(2.0f);
                    aPGB.setColor(Color.red);
                    this.drawPolygonShape(g, aPGS, aPGB, LonShift);
                }
            }
        }
        g.setTransform(oldMatrix);
        g.setClip(oldRegion);
    }

    private void drawLayerLabels(Graphics2D g, VectorLayer aLayer, double LonShift) {
        Extent lExtent = MIMath.shiftExtentLon(aLayer.getExtent(), LonShift);
        if (!MIMath.isExtentCross(lExtent, this._drawExtent).booleanValue()) {
            return;
        }
        ArrayList<Extent> extentList = new ArrayList<Extent>();
        Extent maxExtent = new Extent();
        List<Graphic> LabelPoints = aLayer.getLabelPoints();
        PointF aPoint = new PointF();
        for (int i = 0; i < LabelPoints.size(); ++i) {
            Graphic aLP = LabelPoints.get(i);
            PointShape aPS = (PointShape)aLP.getShape();
            LabelBreak aLB = (LabelBreak)aLP.getLegend();
            aPS.setVisible(true);
            String LabelStr = aLB.getText();
            aPoint.X = (float)aPS.getPoint().X;
            aPoint.Y = (float)aPS.getPoint().Y;
            Font drawFont = aLB.getFont();
            if ((double)aPoint.X + LonShift < this._drawExtent.minX || (double)aPoint.X + LonShift > this._drawExtent.maxX || (double)aPoint.Y < this._drawExtent.minY || (double)aPoint.Y > this._drawExtent.maxY) continue;
            double[] xy = this.projToScreen(aPoint.X, aPoint.Y, LonShift);
            aPoint.X = (float)xy[0];
            aPoint.Y = (float)xy[1];
            FontMetrics metrics = g.getFontMetrics(drawFont);
            Dimension labSize = new Dimension(metrics.stringWidth(LabelStr), metrics.getHeight());
            switch (aLB.getAlignType()) {
                case Center: {
                    aPoint.X = (float)xy[0] - (float)(labSize.width / 2);
                    break;
                }
                case Left: {
                    aPoint.X = (float)xy[0] - (float)labSize.width;
                }
            }
            aPoint.Y += (float)(labSize.height / 2);
            aPoint.Y -= aLB.getYShift();
            aPoint.X += aLB.getXShift();
            AffineTransform tempTrans = g.getTransform();
            if (aLB.getAngle() != 0.0f) {
                AffineTransform myTrans = (AffineTransform)tempTrans.clone();
                myTrans.translate(aPoint.X, aPoint.Y);
                myTrans.rotate((double)aLB.getAngle() * Math.PI / 180.0);
                g.setTransform(myTrans);
                aPoint.X = 0.0f;
                aPoint.Y = 0.0f;
            }
            boolean ifDraw = true;
            java.awt.Rectangle rect = this.getGraphicRectangle(g, aLP, LonShift);
            Extent aExtent = new Extent();
            aExtent.minX = rect.x;
            aExtent.maxX = rect.x + rect.width;
            aExtent.minY = rect.y;
            aExtent.maxY = rect.y + rect.height;
            if (aLayer.getLabelSet().isAvoidCollision()) {
                if (extentList.isEmpty()) {
                    maxExtent = (Extent)aExtent.clone();
                    extentList.add(aExtent);
                } else if (!MIMath.isExtentCross(aExtent, maxExtent).booleanValue()) {
                    extentList.add(aExtent);
                    maxExtent = MIMath.getLagerExtent(maxExtent, aExtent);
                } else {
                    for (int j = 0; j < extentList.size(); ++j) {
                        if (!MIMath.isExtentCross(aExtent, (Extent)extentList.get(j)).booleanValue()) continue;
                        ifDraw = false;
                        break;
                    }
                    if (ifDraw) {
                        extentList.add(aExtent);
                        maxExtent = MIMath.getLagerExtent(maxExtent, aExtent);
                    } else {
                        aPS.setVisible(false);
                    }
                }
            }
            if (ifDraw) {
                if (aLayer.getLabelSet().isDrawShadow()) {
                    g.setColor(aLayer.getLabelSet().getShadowColor());
                    g.fill(new Rectangle2D.Float((float)aExtent.minX, (float)aExtent.minY, labSize.width, labSize.height));
                }
                g.setFont(drawFont);
                g.setColor(aLP.getLegend().getColor());
                g.drawString(LabelStr, aPoint.X, aPoint.Y);
                if (aPS.isSelected()) {
                    float[] dashPattern = new float[]{2.0f, 1.0f};
                    g.setColor(Color.cyan);
                    g.setStroke(new BasicStroke(1.0f, 1, 0, 10.0f, dashPattern, 0.0f));
                    g.draw(new Rectangle2D.Float((float)aExtent.minX, (float)aExtent.minY, labSize.width, labSize.height));
                }
            }
            if (aLB.getAngle() == 0.0f) continue;
            g.setTransform(tempTrans);
        }
    }

    private void drawLayerCharts(Graphics2D g, VectorLayer aLayer, double LonShift) {
        Extent lExtent = MIMath.shiftExtentLon(aLayer.getExtent(), LonShift);
        if (!MIMath.isExtentCross(lExtent, this._drawExtent).booleanValue()) {
            return;
        }
        ArrayList<Extent> extentList = new ArrayList<Extent>();
        Extent maxExtent = new Extent();
        List<ChartGraphic> chartPoints = aLayer.getChartPoints();
        PointF aPoint = new PointF();
        for (int i = 0; i < chartPoints.size(); ++i) {
            ChartGraphic aCP = chartPoints.get(i);
            PointShape aPS = (PointShape)aCP.getShape();
            ChartBreak aCB = (ChartBreak)aCP.getLegend();
            org.meteoinfo.global.PointD startPos = aCP.getStartPosition();
            aPS.setVisible(true);
            aPoint.X = (float)aPS.getPoint().X;
            aPoint.Y = (float)aPS.getPoint().Y;
            if ((double)aPoint.X + LonShift < this._drawExtent.minX || (double)aPoint.X + LonShift > this._drawExtent.maxX || (double)aPoint.Y < this._drawExtent.minY || (double)aPoint.Y > this._drawExtent.maxY) continue;
            double[] xy = this.projToScreen(aPoint.X, aPoint.Y, LonShift);
            aPoint.X = (float)xy[0];
            aPoint.Y = (float)xy[1];
            Extent aExtent = aCB.getDrawExtent((PointF)aPoint.clone());
            boolean ifDraw = true;
            if (aLayer.getChartSet().isAvoidCollision()) {
                if (extentList.isEmpty()) {
                    maxExtent = aExtent;
                    extentList.add(aExtent);
                } else if (!MIMath.isExtentCross(aExtent, maxExtent).booleanValue()) {
                    extentList.add(aExtent);
                    maxExtent = MIMath.getLagerExtent(maxExtent, aExtent);
                } else {
                    for (int j = 0; j < extentList.size(); ++j) {
                        if (!MIMath.isExtentCross(aExtent, (Extent)extentList.get(j)).booleanValue()) continue;
                        ifDraw = false;
                        break;
                    }
                    if (ifDraw) {
                        extentList.add(aExtent);
                        maxExtent = MIMath.getLagerExtent(maxExtent, aExtent);
                    } else {
                        aPS.setVisible(false);
                    }
                }
            }
            if (!ifDraw) continue;
            xy = this.projToScreen(startPos.X, startPos.Y, LonShift);
            PointF sP = new PointF((float)xy[0], (float)xy[1]);
            if (Math.abs(sP.X - aPoint.X) > 5.0f || Math.abs(sP.Y - aPoint.Y) > 5.0f) {
                g.drawLine((int)sP.X, (int)sP.Y, (int)aPoint.X, (int)aPoint.Y);
            }
            aPoint.X = (float)aExtent.minX;
            aPoint.Y = (float)aExtent.maxY;
            Draw.drawChartPoint(aPoint, aCB, g);
            if (!aPS.isSelected()) continue;
            float[] dashPattern = new float[]{2.0f, 1.0f};
            g.setColor(Color.cyan);
            g.setStroke(new BasicStroke(1.0f, 1, 0, 10.0f, dashPattern, 0.0f));
            g.draw(new Rectangle2D.Float((float)aExtent.minX, (float)aExtent.minY, (float)aExtent.getWidth(), (float)aExtent.getHeight()));
        }
    }

    private void drawXYGrid(Graphics2D g, List<String> XGridStrs, List<String> YGridStrs) {
        GridLabel aGL;
        String drawStr;
        double[] sXY;
        int i;
        if (this.layers.isEmpty()) {
            return;
        }
        int vXNum = (int)(this._drawExtent.maxX - this._drawExtent.minX);
        int vYNum = (int)(this._drawExtent.maxY - this._drawExtent.minY);
        int XDelt = vXNum / 10 + 1;
        int YDelt = vYNum / 10 + 1;
        PointF sP = new PointF(0.0f, 0.0f);
        PointF eP = new PointF(0.0f, 0.0f);
        float X = 0.0f;
        float Y = 0.0f;
        Color lineColor = this._gridLineColor;
        float[] dashPattern = MapView.getDashPattern(this._gridLineStyle);
        BasicStroke pen = new BasicStroke(this._gridLineSize, 0, 0, 10.0f, dashPattern, 0.0f);
        Font drawFont = new Font("Arial", 0, 10);
        if (!this._drawGridLine) {
            lineColor = this.getForeground();
            dashPattern = MapView.getDashPattern(LineStyles.SOLID);
            pen = new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f);
        }
        g.setColor(lineColor);
        g.setStroke(pen);
        g.setFont(drawFont);
        int XGridNum = XGridStrs.size();
        int YGridNum = YGridStrs.size();
        this._gridLabels = new ArrayList<GridLabel>();
        for (i = 0; i < XGridNum; i += XDelt) {
            if (!((double)i >= this._drawExtent.minX) || !((double)i <= this._drawExtent.maxX)) continue;
            sXY = this.projToScreen(i, this._drawExtent.minY, 0.0);
            sP.X = (float)sXY[0];
            sP.Y = (float)sXY[1];
            if (this._drawGridLine) {
                sXY = this.projToScreen(i, this._drawExtent.maxY, 0.0);
                eP.X = (float)sXY[0];
                eP.Y = (float)sXY[1];
                if ((double)i > this._drawExtent.minX && (double)i < this._drawExtent.maxX) {
                    g.draw(new Line2D.Float(sP.X, sP.Y, eP.X, eP.Y));
                }
            }
            drawStr = XGridStrs.get(i);
            aGL = new GridLabel();
            aGL.setBorder(true);
            aGL.setLabPoint(new org.meteoinfo.global.PointD(sP.X, sP.Y));
            aGL.setLabDirection(Direction.South);
            aGL.setLabString(drawStr);
            this._gridLabels.add(aGL);
        }
        this._yGridPosLabel.clear();
        for (i = 0; i < YGridNum; i += YDelt) {
            if (!((double)i > this._drawExtent.minY) || !((double)i < this._drawExtent.maxY)) continue;
            sXY = this.projToScreen(this._drawExtent.minX, i, 0.0);
            sP.X = (float)sXY[0];
            sP.Y = (float)sXY[1];
            if (this._drawGridLine) {
                sXY = this.projToScreen(this._drawExtent.maxX, i, 0.0);
                eP.X = (float)sXY[0];
                eP.Y = (float)sXY[1];
                if ((double)i > this._drawExtent.minY && (double)i < this._drawExtent.maxY) {
                    g.draw(new Line2D.Float(sP.X, sP.Y, eP.X, eP.Y));
                }
            }
            drawStr = YGridStrs.get(i);
            aGL = new GridLabel();
            aGL.setBorder(true);
            aGL.setLabPoint(new org.meteoinfo.global.PointD(sP.X, sP.Y));
            aGL.setLabDirection(Direction.Weast);
            aGL.setLabString(drawStr);
            this._gridLabels.add(aGL);
        }
    }

    public void exportToPicture(String aFile) throws FileNotFoundException, PrintException, IOException {
        if (aFile.endsWith(".ps")) {
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            String mimeType = "application/postscript";
            StreamPrintServiceFactory[] factories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(flavor, mimeType);
            FileOutputStream out = new FileOutputStream(aFile);
            if (factories.length > 0) {
                StreamPrintService service = factories[0].getPrintService(out);
                SimpleDoc doc = new SimpleDoc(new Printable(){

                    @Override
                    public int print(Graphics g, PageFormat pf, int page) {
                        if (page >= 1) {
                            return 1;
                        }
                        double sf1 = pf.getImageableWidth() / (double)(MapView.this.getWidth() + 1);
                        double sf2 = pf.getImageableHeight() / (double)(MapView.this.getHeight() + 1);
                        double s = Math.min(sf1, sf2);
                        Graphics2D g2 = (Graphics2D)g;
                        g2.translate((pf.getWidth() - pf.getImageableWidth()) / 2.0, (pf.getHeight() - pf.getImageableHeight()) / 2.0);
                        g2.scale(s, s);
                        MapView.this.paintGraphics(g2);
                        return 0;
                    }
                }, flavor, null);
                DocPrintJob job = service.createPrintJob();
                HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
                job.print(doc, attributes);
                out.close();
            }
        } else if (aFile.endsWith(".eps")) {
            int width = this.getWidth();
            int height = this.getHeight();
            Properties p = new Properties();
            p.setProperty("PageSize", "A5");
            PSGraphics2D g = new PSGraphics2D(new File(aFile), new Dimension(width, height));
            g.startExport();
            this.paintGraphics((Graphics2D)g);
            g.endExport();
            g.dispose();
        } else if (aFile.endsWith(".pdf")) {
            int width = this.getWidth();
            int height = this.getHeight();
            try {
                Document document = new Document(new Rectangle((float)width, (float)height));
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(aFile));
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                PdfTemplate pdfTemp = cb.createTemplate((float)width, (float)height);
                PdfGraphics2D g2 = new PdfGraphics2D((PdfContentByte)pdfTemp, (float)width, (float)height, true);
                this.paintGraphics((Graphics2D)g2);
                g2.dispose();
                cb.addTemplate(pdfTemp, 0.0f, 0.0f);
                document.close();
            }
            catch (DocumentException | FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if (aFile.endsWith(".emf")) {
            int width = this.getWidth();
            int height = this.getHeight();
            EMFGraphics2D g = new EMFGraphics2D(new File(aFile), new Dimension(width, height));
            g.startExport();
            this.paintGraphics((Graphics2D)g);
            g.endExport();
            g.dispose();
        } else {
            String extension = aFile.substring(aFile.lastIndexOf(46) + 1);
            if (extension.equalsIgnoreCase("bmp") || extension.equalsIgnoreCase("jpg")) {
                BufferedImage bi = extension.equalsIgnoreCase("bmp") ? new BufferedImage(this.getWidth(), this.getHeight(), 1) : new BufferedImage(this.getWidth(), this.getHeight(), 2);
                Graphics2D g = bi.createGraphics();
                if (this.getBackground() != null) {
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, bi.getWidth(), bi.getHeight());
                }
                this.paintGraphics(g);
                if (extension.equalsIgnoreCase("jpg")) {
                    BufferedImage newImage = new BufferedImage(bi.getWidth(), bi.getHeight(), 1);
                    newImage.createGraphics().drawImage(bi, 0, 0, Color.BLACK, null);
                    ImageIO.write((RenderedImage)newImage, extension, new File(aFile));
                } else {
                    ImageIO.write((RenderedImage)bi, extension, new File(aFile));
                }
            } else {
                ImageIO.write((RenderedImage)this._mapBitmap, extension, new File(aFile));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToPicture(String fileName, Integer dpi) throws FileNotFoundException, PrintException, IOException {
        if (dpi == null) {
            this.exportToPicture(fileName);
        } else {
            File output = new File(fileName);
            output.delete();
            int width = this.getWidth();
            int height = this.getHeight();
            String formatName = fileName.substring(fileName.lastIndexOf(46) + 1);
            if (formatName.equals("jpg")) {
                formatName = "jpeg";
                this.saveImage_Jpeg(fileName, width, height, dpi);
                return;
            }
            double scaleFactor = (double)dpi.intValue() / 72.0;
            BufferedImage image = new BufferedImage((int)((double)width * scaleFactor), (int)((double)height * scaleFactor), 2);
            Graphics2D g = image.createGraphics();
            AffineTransform at = g.getTransform();
            at.scale(scaleFactor, scaleFactor);
            g.setTransform(at);
            this.paintGraphics(g);
            Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName(formatName);
            while (iw.hasNext()) {
                ImageWriter writer = iw.next();
                ImageWriteParam writeParam = writer.getDefaultWriteParam();
                ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(2);
                IIOMetadata metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
                if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
                ImageUtil.setDPI(metadata, dpi.intValue());
                try (ImageOutputStream stream = ImageIO.createImageOutputStream(output);){
                    writer.setOutput(stream);
                    writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
                    break;
                }
            }
            g.dispose();
        }
    }

    private boolean saveImage_Jpeg(String file, int width, int height, int dpi) {
        double scaleFactor = (double)dpi / 72.0;
        BufferedImage bufferedImage = new BufferedImage((int)((double)width * scaleFactor), (int)((double)height * scaleFactor), 1);
        Graphics2D g = bufferedImage.createGraphics();
        AffineTransform at = g.getTransform();
        at.scale(scaleFactor, scaleFactor);
        g.setTransform(at);
        this.paintGraphics(g);
        try {
            ImageWriter imageWriter = ImageIO.getImageWritersBySuffix("jpeg").next();
            ImageOutputStream ios = ImageIO.createImageOutputStream(new File(file));
            imageWriter.setOutput(ios);
            JPEGImageWriteParam jpegParams = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
            jpegParams.setCompressionMode(2);
            jpegParams.setCompressionQuality(0.85f);
            IIOMetadata data = imageWriter.getDefaultImageMetadata(new ImageTypeSpecifier(bufferedImage), jpegParams);
            Element tree = (Element)data.getAsTree("javax_imageio_jpeg_image_1.0");
            Element jfif = (Element)tree.getElementsByTagName("app0JFIF").item(0);
            jfif.setAttribute("Xdensity", Integer.toString(dpi));
            jfif.setAttribute("Ydensity", Integer.toString(dpi));
            jfif.setAttribute("resUnits", "1");
            data.setFromTree("javax_imageio_jpeg_image_1.0", tree);
            imageWriter.write(null, new IIOImage(bufferedImage, null, data), jpegParams);
            ios.close();
            imageWriter.dispose();
        }
        catch (Exception e) {
            return false;
        }
        g.dispose();
        return true;
    }

    public VectorLayer generateLonLatLayer() {
        return this.generateLonLatLayer(this._gridXOrigin, this._gridYOrigin, this._gridXDelt, this._gridYDelt);
    }

    private VectorLayer generateLonLatLayer(double origin_Lon, double origin_Lat, double Delt_Lon, double Delt_Lat) {
        int shapeNum;
        double lat;
        ArrayList<org.meteoinfo.global.PointD> PList;
        PolylineShape aPLS;
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Polyline);
        String columnName = "Value";
        Field aDC = new Field(columnName, DataType.FLOAT);
        aLayer.editAddField(aDC);
        aDC = new Field("Longitude", DataType.STRING);
        aLayer.editAddField(aDC);
        double refLon = this._projection.getProjInfo().getRefCutLon();
        int lineNum = 0;
        Extent extent = new Extent();
        boolean isLabelLon = false;
        double lon = origin_Lon;
        while (lon <= 180.0) {
            if (!this._projection.isLonLatMap()) {
                if (refLon == 180.0 || refLon == -180.0) {
                    if (lon == 180.0 || lon == -180.0) {
                        isLabelLon = true;
                        lon = BigDecimalUtil.add(lon, Delt_Lon);
                        continue;
                    }
                } else if (MIMath.doubleEquals(lon, refLon)) {
                    isLabelLon = true;
                    lon = BigDecimalUtil.add(lon, Delt_Lon);
                    continue;
                }
            }
            aPLS = new PolylineShape();
            aPLS.setValue(lon);
            extent.minX = lon;
            extent.maxX = lon;
            extent.minY = -90.0;
            extent.maxY = 90.0;
            aPLS.setExtent(extent);
            PList = new ArrayList<org.meteoinfo.global.PointD>();
            for (lat = -90.0; lat <= 90.0; lat += 1.0) {
                PList.add(new org.meteoinfo.global.PointD(lon, lat));
            }
            aPLS.setPoints(PList);
            shapeNum = aLayer.getShapeNum();
            try {
                if (aLayer.editInsertShape(aPLS, shapeNum)) {
                    aLayer.editCellValue(0, shapeNum, (Object)lon);
                    aLayer.editCellValue(1, shapeNum, (Object)"Y");
                }
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            ++lineNum;
            lon = BigDecimalUtil.add(lon, Delt_Lon);
        }
        lat = origin_Lat;
        double cenLon = this._projection.getProjInfo().getCenterLon();
        double epsilon = 1.0E-10;
        while (lat <= 90.0) {
            aPLS = new PolylineShape();
            aPLS.setValue(lat);
            extent.minX = -180.0;
            extent.minY = lat;
            extent.maxY = lat;
            extent.maxX = 180.0;
            aPLS.setExtent(extent);
            PList = new ArrayList();
            for (lon = cenLon - 180.0 + epsilon; lon < cenLon + 180.0 - epsilon; lon += 1.0) {
                PList.add(new org.meteoinfo.global.PointD(lon, lat));
            }
            PList.add(new org.meteoinfo.global.PointD(cenLon + 180.0 - epsilon, lat));
            aPLS.setPoints(PList);
            shapeNum = aLayer.getShapeNum();
            try {
                if (aLayer.editInsertShape(aPLS, shapeNum)) {
                    aLayer.editCellValue(0, shapeNum, (Object)lat);
                    aLayer.editCellValue(1, shapeNum, (Object)"N");
                }
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            ++lineNum;
            lat = BigDecimalUtil.add(lat, Delt_Lat);
        }
        Extent lExt = new Extent();
        lExt.minX = -180.0;
        lExt.maxX = 180.0;
        lExt.minY = -90.0;
        lExt.maxY = 90.0;
        aLayer.setExtent(lExt);
        aLayer.setLayerName("Map_LonLat");
        aLayer.setFileName("");
        aLayer.setLayerDrawType(LayerDrawType.Map);
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Polyline, Color.darkGray, 1.0f));
        PolylineBreak aPLB = (PolylineBreak)aLayer.getLegendScheme().getLegendBreaks().get(0);
        aPLB.setStyle(LineStyles.DASH);
        aLayer.setVisible(true);
        return aLayer;
    }

    private VectorLayer generateLonLatLayer_bak(double origin_Lon, double origin_Lat, double Delt_Lon, double Delt_Lat) {
        int shapeNum;
        double lat;
        ArrayList<org.meteoinfo.global.PointD> PList;
        PolylineShape aPLS;
        VectorLayer aLayer = new VectorLayer(ShapeTypes.Polyline);
        String columnName = "Value";
        Field aDC = new Field(columnName, DataType.FLOAT);
        aLayer.editAddField(aDC);
        aDC = new Field("Longitude", DataType.STRING);
        aLayer.editAddField(aDC);
        double refLon = this._projection.getProjInfo().getRefCutLon();
        int lineNum = 0;
        Extent extent = new Extent();
        boolean isLabelLon = false;
        double lon = origin_Lon;
        while (!(lon >= origin_Lon) || lineNum <= 0 || !(lon - Delt_Lon < origin_Lon)) {
            if (lon > 180.0) {
                lon = BigDecimalUtil.sub(lon, 360.0);
            }
            if (!this._projection.isLonLatMap()) {
                if (refLon == 180.0 || refLon == -180.0) {
                    if (lon == 180.0 || lon == -180.0) {
                        isLabelLon = true;
                        lon = BigDecimalUtil.add(lon, Delt_Lon);
                        continue;
                    }
                } else if (MIMath.doubleEquals(lon, refLon)) {
                    isLabelLon = true;
                    lon = BigDecimalUtil.add(lon, Delt_Lon);
                    continue;
                }
            }
            aPLS = new PolylineShape();
            aPLS.setValue(lon);
            extent.minX = lon;
            extent.maxX = lon;
            extent.minY = -90.0;
            extent.maxY = 90.0;
            aPLS.setExtent(extent);
            PList = new ArrayList<org.meteoinfo.global.PointD>();
            for (lat = -90.0; lat <= 90.0; lat += 1.0) {
                PList.add(new org.meteoinfo.global.PointD(lon, lat));
            }
            aPLS.setPoints(PList);
            shapeNum = aLayer.getShapeNum();
            try {
                if (aLayer.editInsertShape(aPLS, shapeNum)) {
                    aLayer.editCellValue(0, shapeNum, (Object)lon);
                    aLayer.editCellValue(1, shapeNum, (Object)"Y");
                }
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            ++lineNum;
            lon = BigDecimalUtil.add(lon, Delt_Lon);
        }
        switch (this._projection.getProjInfo().getProjectionName()) {
            case LongLat: 
            case Oblique_Stereographic_Alternative: {
                break;
            }
            default: {
                lon = refLon - (double)1.0E-4f;
                if (lon < -180.0) {
                    lon += 360.0;
                }
                aPLS = new PolylineShape();
                aPLS.setValue(lon);
                extent.minX = lon;
                extent.maxX = lon;
                extent.minY = -90.0;
                extent.maxY = 90.0;
                aPLS.setExtent(extent);
                PList = new ArrayList();
                for (lat = -90.0; lat <= 90.0; lat += 1.0) {
                    PList.add(new org.meteoinfo.global.PointD(lon, lat));
                }
                aPLS.setPoints(PList);
                double value = isLabelLon ? refLon : -9999.0;
                shapeNum = aLayer.getShapeNum();
                try {
                    if (aLayer.editInsertShape(aPLS, shapeNum)) {
                        aLayer.editCellValue(0, shapeNum, (Object)value);
                        aLayer.editCellValue(1, shapeNum, (Object)"Y");
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
                }
                lon = refLon + (double)1.0E-4f;
                if (lon > 180.0) {
                    lon -= 360.0;
                }
                aPLS = new PolylineShape();
                aPLS.setValue(lon);
                extent.minX = lon;
                extent.maxX = lon;
                extent.minY = -90.0;
                extent.maxY = 90.0;
                aPLS.setExtent(extent);
                PList = new ArrayList();
                for (lat = -90.0; lat <= 90.0; lat += 1.0) {
                    PList.add(new org.meteoinfo.global.PointD(lon, lat));
                }
                aPLS.setPoints(PList);
                value = isLabelLon ? refLon : -9999.0;
                shapeNum = aLayer.getShapeNum();
                try {
                    if (!aLayer.editInsertShape(aPLS, shapeNum)) break;
                    aLayer.editCellValue(0, shapeNum, (Object)value);
                    aLayer.editCellValue(1, shapeNum, (Object)"Y");
                    break;
                }
                catch (Exception ex) {
                    Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        lat = -90.0;
        while (lat <= 90.0) {
            aPLS = new PolylineShape();
            aPLS.setValue(lat);
            extent.minX = -180.0;
            extent.minY = lat;
            extent.maxY = lat;
            extent.maxX = 180.0;
            aPLS.setExtent(extent);
            PList = new ArrayList();
            for (lon = -180.0; lon <= 180.0; lon += 1.0) {
                PList.add(new org.meteoinfo.global.PointD(lon, lat));
            }
            aPLS.setPoints(PList);
            shapeNum = aLayer.getShapeNum();
            try {
                if (aLayer.editInsertShape(aPLS, shapeNum)) {
                    aLayer.editCellValue(0, shapeNum, (Object)lat);
                    aLayer.editCellValue(1, shapeNum, (Object)"N");
                }
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            ++lineNum;
            lat = BigDecimalUtil.add(lat, Delt_Lat);
        }
        Extent lExt = new Extent();
        lExt.minX = -180.0;
        lExt.maxX = 180.0;
        lExt.minY = -90.0;
        lExt.maxY = 90.0;
        aLayer.setExtent(lExt);
        aLayer.setLayerName("Map_LonLat");
        aLayer.setFileName("");
        aLayer.setLayerDrawType(LayerDrawType.Map);
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Polyline, Color.darkGray, 1.0f));
        PolylineBreak aPLB = (PolylineBreak)aLayer.getLegendScheme().getLegendBreaks().get(0);
        aPLB.setStyle(LineStyles.DASH);
        aLayer.setVisible(true);
        return aLayer;
    }

    private void updateLonLatLayer() {
        if (this._lonLatLayer == null || this._gridDeltChanged) {
            this._lonLatLayer = this.generateLonLatLayer();
            if (!this._projection.isLonLatMap()) {
                ProjectionInfo toProj = this._projection.getProjInfo();
                ProjectionUtil.projectLayer(this._lonLatLayer, toProj);
            }
            this._gridDeltChanged = false;
        }
    }

    private void getLonLatGridLabels() {
        if (this._isGeoMap) {
            ArrayList labels = new ArrayList();
            if (this._projection.isLonLatMap()) {
                if (this._lonLatLayer == null) {
                    return;
                }
                for (int i = 0; i < this._lonLatLayer.getShapeNum(); ++i) {
                    PolylineShape aPLS = (PolylineShape)this._lonLatLayer.getShapes().get(i);
                    String labStr = this._lonLatLayer.getCellValue(0, i).toString().trim();
                    labStr = DataConvert.removeTailingZeros(labStr);
                    float value = Float.parseFloat(labStr);
                    String isLonStr = this._lonLatLayer.getCellValue(1, i).toString();
                    boolean isLon = "Y".equals(isLonStr);
                    if (isLon) {
                        if (value == -180.0f) {
                            labStr = "180";
                        } else if (value != 0.0f && value != 180.0f) {
                            labStr = labStr.substring(0, 1).equals("-") ? labStr.substring(1) + "W" : labStr + "E";
                        }
                    } else if (value != 0.0f) {
                        labStr = labStr.substring(0, 1).equals("-") ? labStr.substring(1) + "S" : labStr + "N";
                    }
                    ArrayList<GridLabel> gLabels = new ArrayList<GridLabel>();
                    for (int l = 0; l < aPLS.getPolylines().size(); ++l) {
                        Polyline aPL = aPLS.getPolylines().get(l);
                        gLabels.addAll(GeoComputation.getGridLabels_StraightLine(aPL, this._drawExtent, isLon));
                        if (!isLon) continue;
                        ArrayList<org.meteoinfo.global.PointD> arrayList = new ArrayList<org.meteoinfo.global.PointD>();
                        for (int j = 0; j < aPL.getPointList().size(); ++j) {
                            org.meteoinfo.global.PointD aP = (org.meteoinfo.global.PointD)aPL.getPointList().get(j).clone();
                            aP.X += 360.0;
                            arrayList.add(aP);
                        }
                        aPL = new Polyline();
                        aPL.setPointList(arrayList);
                        gLabels.addAll(GeoComputation.getGridLabels_StraightLine(aPL, this._drawExtent, isLon));
                        for (org.meteoinfo.global.PointD p : arrayList) {
                            org.meteoinfo.global.PointD aP = (org.meteoinfo.global.PointD)p.clone();
                            aP.X -= 720.0;
                        }
                        aPL = new Polyline();
                        aPL.setPointList(arrayList);
                        gLabels.addAll(GeoComputation.getGridLabels_StraightLine(aPL, this._drawExtent, isLon));
                    }
                    for (GridLabel gLabel : gLabels) {
                        gLabel.setLabString(labStr);
                    }
                    labels.addAll(gLabels);
                }
            } else {
                if (this._lonLatLayer == null) {
                    return;
                }
                ArrayList gridLabels = new ArrayList();
                for (int i = 0; i < this._lonLatLayer.getShapeNum(); ++i) {
                    Iterator aPLS = (PolylineShape)this._lonLatLayer.getShapes().get(i);
                    String labStr = this._lonLatLayer.getCellValue(0, i).toString().trim();
                    float value = Float.parseFloat(labStr = DataConvert.removeTailingZeros(labStr));
                    if ((double)value == -9999.0) continue;
                    String isLonStr = this._lonLatLayer.getCellValue(1, i).toString();
                    boolean isLon = isLonStr.equals("Y");
                    if (isLon) {
                        if (value == -180.0f) {
                            labStr = "180";
                        } else if (value != 0.0f && value != 180.0f) {
                            labStr = labStr.substring(0, 1).equals("-") ? labStr.substring(1) + "W" : labStr + "E";
                        }
                    } else {
                        if (value == 90.0f || value == -90.0f) continue;
                        if (value != 0.0f) {
                            labStr = labStr.substring(0, 1).equals("-") ? labStr.substring(1) + "S" : labStr + "N";
                        }
                    }
                    ArrayList<GridLabel> gLabels = new ArrayList<GridLabel>();
                    for (Polyline polyline : ((PolylineShape)((Object)aPLS)).getPolylines()) {
                        gLabels.addAll(GeoComputation.getGridLabels(polyline, this._drawExtent, isLon));
                    }
                    for (GridLabel gridLabel : gLabels) {
                        gridLabel.setLabString(labStr);
                        gridLabel.setValue(value);
                    }
                    gridLabels.addAll(gLabels);
                }
                switch (this._projection.getProjInfo().getProjectionName()) {
                    case Lambert_Conformal_Conic: {
                        for (GridLabel aGL : gridLabels) {
                            if (!aGL.isBorder()) {
                                if (!aGL.isLongitude()) {
                                    aGL.setLabDirection(Direction.North);
                                } else {
                                    if (aGL.getCoord().Y > 0.0 && Math.abs(aGL.getCoord().X) < 1000.0) continue;
                                    if (MIMath.lonDistance(aGL.getValue(), (float)this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getProjectionLongitudeDegrees()) > 60.0f) {
                                        if (aGL.getCoord().X < 0.0) {
                                            aGL.setLabDirection(Direction.Weast);
                                        } else {
                                            aGL.setLabDirection(Direction.East);
                                        }
                                    } else {
                                        aGL.setLabDirection(Direction.South);
                                    }
                                }
                            }
                            labels.add(aGL);
                        }
                        break;
                    }
                    case Albers_Equal_Area: 
                    case Lambert_Equal_Area_Conic: {
                        for (GridLabel aGL : gridLabels) {
                            if (!aGL.isBorder()) {
                                if (!aGL.isLongitude()) {
                                    aGL.setLabDirection(Direction.North);
                                } else {
                                    if (aGL.getCoord().Y > 7000000.0 && Math.abs(aGL.getCoord().X) < 5000000.0) continue;
                                    if (MIMath.lonDistance(aGL.getValue(), (float)this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getProjectionLongitudeDegrees()) > 60.0f) {
                                        if (aGL.getCoord().X < 0.0) {
                                            aGL.setLabDirection(Direction.Weast);
                                        } else {
                                            aGL.setLabDirection(Direction.East);
                                        }
                                    } else {
                                        aGL.setLabDirection(Direction.South);
                                    }
                                }
                            }
                            labels.add(aGL);
                        }
                        break;
                    }
                    case Mercator: {
                        for (GridLabel gl : gridLabels) {
                            if (!gl.isBorder() && gl.isLongitude() && gl.getCoord().Y > 1000.0) {
                                gl.setLabDirection(Direction.North);
                            }
                            labels.add(gl);
                        }
                        break;
                    }
                    case North_Polar_Stereographic_Azimuthal: 
                    case South_Polar_Stereographic_Azimuthal: {
                        for (GridLabel aGL : gridLabels) {
                            if (!aGL.isBorder()) {
                                if (!aGL.isLongitude() || Math.abs(aGL.getCoord().X) < 1000.0 && Math.abs(aGL.getCoord().Y) < 1000.0) continue;
                                float refLon = (float)this._projection.getProjInfo().getCoordinateReferenceSystem().getProjection().getProjectionLongitudeDegrees();
                                if (MIMath.lonDistance(aGL.getValue(), refLon) < 45.0f) {
                                    if (this._projection.getProjInfo().getProjectionName() == ProjectionNames.North_Polar_Stereographic_Azimuthal) {
                                        aGL.setLabDirection(Direction.South);
                                    } else {
                                        aGL.setLabDirection(Direction.North);
                                    }
                                } else {
                                    refLon = MIMath.lonAdd(refLon, 180.0f);
                                    if (MIMath.lonDistance(aGL.getValue(), refLon) < 45.0f) {
                                        if (this._projection.getProjInfo().getProjectionName() == ProjectionNames.North_Polar_Stereographic_Azimuthal) {
                                            aGL.setLabDirection(Direction.North);
                                        } else {
                                            aGL.setLabDirection(Direction.South);
                                        }
                                    } else if (aGL.getCoord().X < 0.0) {
                                        aGL.setLabDirection(Direction.Weast);
                                    } else {
                                        aGL.setLabDirection(Direction.East);
                                    }
                                }
                            }
                            labels.add(aGL);
                        }
                        break;
                    }
                    case Robinson: {
                        for (GridLabel aGL : gridLabels) {
                            if (!aGL.isBorder()) {
                                if (aGL.isLongitude()) {
                                    if (aGL.getCoord().Y < 0.0) {
                                        aGL.setLabDirection(Direction.South);
                                    } else {
                                        aGL.setLabDirection(Direction.North);
                                    }
                                } else if (aGL.getCoord().X < 0.0) {
                                    aGL.setLabDirection(Direction.Weast);
                                } else {
                                    aGL.setLabDirection(Direction.East);
                                }
                            }
                            labels.add(aGL);
                        }
                        break;
                    }
                    case Molleweide: 
                    case Hammer_Eckert: {
                        for (GridLabel aGL : gridLabels) {
                            if (!aGL.isBorder()) {
                                if (aGL.isLongitude()) continue;
                                if (aGL.getCoord().X < 0.0) {
                                    aGL.setLabDirection(Direction.Weast);
                                } else {
                                    aGL.setLabDirection(Direction.East);
                                }
                            }
                            labels.add(aGL);
                        }
                        break;
                    }
                    case Orthographic_Azimuthal: 
                    case Geostationary_Satellite: {
                        for (GridLabel aGL : gridLabels) {
                            if (!aGL.isBorder()) {
                                if (aGL.isLongitude()) continue;
                                if (aGL.getCoord().X < 0.0) {
                                    aGL.setLabDirection(Direction.Weast);
                                } else {
                                    aGL.setLabDirection(Direction.East);
                                }
                            }
                            labels.add(aGL);
                        }
                        break;
                    }
                    case Oblique_Stereographic_Alternative: 
                    case Transverse_Mercator: {
                        for (GridLabel aGL : gridLabels) {
                            if (!aGL.isBorder()) continue;
                            labels.add(aGL);
                        }
                        break;
                    }
                    default: {
                        labels = gridLabels;
                    }
                }
            }
            this._gridLabels.clear();
            for (GridLabel aGL : labels) {
                double[] sXY = this.projToScreen(aGL.getCoord().X, aGL.getCoord().Y);
                aGL.setLabPoint(new org.meteoinfo.global.PointD(sXY[0], sXY[1]));
                this._gridLabels.add(aGL);
            }
        }
    }

    public double[] projToScreen(double projX, double projY) {
        double screenX = (projX - this._drawExtent.minX) * this._scaleX;
        double screenY = (this._drawExtent.maxY - projY) * this._scaleY;
        return new double[]{screenX, screenY};
    }

    public double[] projToScreen(double projX, double projY, double LonShift) {
        double screenX = (projX + LonShift - this._drawExtent.minX) * this._scaleX;
        double screenY = (this._drawExtent.maxY - projY) * this._scaleY;
        return new double[]{screenX, screenY};
    }

    public Rectangle2D.Double projToScreen(Extent extent, double lonShift) {
        double[] sXY = this.projToScreen(extent.minX, extent.minY, lonShift);
        double[] eXY = this.projToScreen(extent.maxX, extent.maxY, lonShift);
        return new Rectangle2D.Double(sXY[0], eXY[1], Math.abs(eXY[0] - sXY[0]), Math.abs(eXY[1] - sXY[1]));
    }

    public double[] lonLatToScreen(double lon, double lat) {
        double screenX = 0.0;
        double screenY = 0.0;
        if (this._projection.isLonLatMap()) {
            double lonShift = this.getLonShift(lon);
            double[] sxy = this.projToScreen(lon, lat, lonShift);
            screenX = sxy[0];
            screenY = sxy[1];
        } else {
            ProjectionInfo fromProj = KnownCoordinateSystems.geographic.world.WGS1984;
            ProjectionInfo toProj = this._projection.getProjInfo();
            double[][] points = new double[][]{{lon, lat}};
            try {
                Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                double projX = points[0][0];
                double projY = points[0][1];
                double[] sxy = this.projToScreen(projX, projY);
                screenX = sxy[0];
                screenY = sxy[1];
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new double[]{screenX, screenY};
    }

    public double[] screenToProj(double screenX, double screenY) {
        double projX = screenX / this._scaleX + this._drawExtent.minX;
        double projY = this._drawExtent.maxY - screenY / this._scaleY;
        return new double[]{projX, projY};
    }

    public double[] screenToProj(double screenX, double screenY, double zoom) {
        double projX = screenX / this._scaleX * zoom + this._drawExtent.minX;
        double projY = this._drawExtent.maxY - screenY / this._scaleY * zoom;
        return new double[]{projX, projY};
    }

    public float[] screenToProj(float screenX, float screenY) {
        float projX = (float)((double)screenX / this._scaleX + this._drawExtent.minX);
        float projY = (float)(this._drawExtent.maxY - (double)screenY / this._scaleY);
        return new float[]{projX, projY};
    }

    public float[] screenToProj(float screenX, float screenY, double LonShift) {
        float projX = (float)((double)screenX / this._scaleX + this._drawExtent.minX + LonShift);
        float projY = (float)(this._drawExtent.maxY - (double)screenY / this._scaleY);
        return new float[]{projX, projY};
    }

    private double[] getProjXYShift(org.meteoinfo.global.PointD p, double x, double y) {
        double[] xy = this.projToScreen(p.X, p.Y);
        double[] pxy = this.screenToProj(xy[0] + x, xy[1] - y);
        double xShift = pxy[0] - p.X;
        double yShift = pxy[1] - p.Y;
        return new double[]{xShift, yShift};
    }

    private double[] getProjXYShift(Point point1, Point point2) {
        double[] pXY1 = this.screenToProj((double)point1.x, (double)point1.y);
        double[] pXY2 = this.screenToProj((double)point2.x, (double)point2.y);
        double xShift = pXY2[0] - pXY1[0];
        double yShift = pXY2[1] - pXY1[1];
        return new double[]{xShift, yShift};
    }

    public void moveShapeOnScreen(Shape aShape, double x, double y) {
        double[] sXY = this.getProjXYShift(aShape.getPoints().get(0), x, y);
        this.moveShape(aShape, sXY[0], sXY[1]);
    }

    public void moveGraphic(Graphic graphic, double x, double y, boolean screen) {
        Shape shape = graphic.getShape();
        if (screen) {
            this.moveShapeOnScreen(shape, x, y);
        } else {
            this.moveShape(shape, x, y);
        }
    }

    public void moveShapeOnScreen(Shape aShape, Point point1, Point point2) {
        double[] sXY = this.getProjXYShift(point1, point2);
        this.moveShape(aShape, sXY[0], sXY[1]);
    }

    private void moveShape(Shape aShape, double xShift, double yShift) {
        List<? extends org.meteoinfo.global.PointD> points = aShape.getPoints();
        for (org.meteoinfo.global.PointD pointD : points) {
            pointD.X += xShift;
            pointD.Y += yShift;
        }
        aShape.setPoints(points);
    }

    public void resizeShapeOnScreen(Shape aShape, ColorBreak legend, java.awt.Rectangle newRect) {
        double[] min = this.screenToProj((double)newRect.x, (double)newRect.y + (double)newRect.height);
        double[] max = this.screenToProj((double)newRect.x + (double)newRect.width, (double)newRect.y);
        Extent newExtent = new Extent(min[0], max[0], min[1], max[1]);
        List<? extends org.meteoinfo.global.PointD> points = aShape.getPoints();
        Extent aExtent = aShape.getExtent();
        switch (aShape.getShapeType()) {
            case Point: 
            case PointM: {
                if (legend.getBreakType() != BreakTypes.PointBreak) break;
                PointBreak aPB = (PointBreak)legend;
                aPB.setSize(newRect.width);
                break;
            }
            case Polyline: 
            case Polygon: 
            case PolygonM: 
            case PolygonZ: 
            case Circle: 
            case CurvePolygon: 
            case CurveLine: {
                this.moveShape(aShape, newExtent.minX - aExtent.minX, newExtent.minY - aExtent.minY);
                double deltaX = newExtent.getWidth() - aExtent.getWidth();
                double deltaY = newExtent.getHeight() - aExtent.getHeight();
                for (int i = 0; i < points.size(); ++i) {
                    org.meteoinfo.global.PointD aP = points.get(i);
                    aP.X += deltaX * (aP.X - aExtent.minX) / aExtent.getWidth();
                    aP.Y += deltaY * (aP.Y - aExtent.minY) / aExtent.getHeight();
                    points.set(i, aP);
                }
                aShape.setPoints(points);
                break;
            }
            case Rectangle: 
            case Ellipse: {
                points = new ArrayList<org.meteoinfo.global.PointD>();
                points.add(new org.meteoinfo.global.PointD(newExtent.minX, newExtent.minY));
                points.add(new org.meteoinfo.global.PointD(newExtent.minX, newExtent.maxY));
                points.add(new org.meteoinfo.global.PointD(newExtent.maxX, newExtent.maxY));
                points.add(new org.meteoinfo.global.PointD(newExtent.maxX, newExtent.minY));
                if (aShape.getShapeType() == ShapeTypes.Rectangle) {
                    points.add((org.meteoinfo.global.PointD)points.get(0).clone());
                }
                aShape.setPoints(points);
            }
        }
    }

    public void resizeShapeOnScreen(Graphic graphic, java.awt.Rectangle newRect) {
        this.resizeShapeOnScreen(graphic.getShape(), graphic.getLegend(), newRect);
    }

    public double getLonShift(Extent aExtent) {
        double LonShift = 0.0;
        if (this._drawExtent.maxX < aExtent.minX) {
            LonShift = -360.0;
        }
        if (this._drawExtent.minX > aExtent.maxX) {
            LonShift = 360.0;
        }
        return LonShift;
    }

    public double getLonShift(double lon) {
        double LonShift = 0.0;
        if (this._drawExtent.maxX < lon) {
            LonShift = -360.0;
        }
        if (this._drawExtent.minX > lon) {
            LonShift = 360.0;
        }
        return LonShift;
    }

    public void zoomToExtent(Extent aExtent) {
        this._viewExtent = aExtent;
        this.refreshXYScale();
        this.repaintNew();
        this.fireViewExtentChangedEvent();
    }

    public void zoomToExtent(double minX, double maxX, double minY, double maxY) {
        Extent aExtent = new Extent();
        aExtent.minX = minX;
        aExtent.maxX = maxX;
        aExtent.minY = minY;
        aExtent.maxY = maxY;
        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
        Objects.requireNonNull(mapViewUndoRedo);
        MapViewUndoRedo.ZoomEdit edit = new MapViewUndoRedo.ZoomEdit(mapViewUndoRedo, this, (Extent)this._viewExtent.clone(), (Extent)aExtent.clone());
        this.fireUndoEditEvent(edit);
        this.zoomToExtent(aExtent);
    }

    public void zoomToExtentScreen(double minX, double maxX, double minY, double maxY, double zoom) {
        double[] pMin = this.screenToProj(minX, maxY, zoom);
        double[] pMax = this.screenToProj(maxX, minY, zoom);
        this.zoomToExtent(pMin[0], pMax[0], pMin[1], pMax[1]);
    }

    public void zoomToExtentLonLatEx(Extent aExtent) {
        if (!this._projection.isLonLatMap()) {
            aExtent = this._projection.getProjectedExtentFromLonLat(aExtent);
        }
        this.zoomToExtent(aExtent);
    }

    public void zoomToExtentLonLatEx_back(Extent aExtent) {
        if (!this._projection.isLonLatMap()) {
            aExtent = this._projection.getProjectedExtentFromLonLat(aExtent);
        }
        this._viewExtent = aExtent;
        if (this._isGeoMap) {
            this.setCoordinateGeoMapEx(aExtent);
        } else {
            this.setCoordinateMap(aExtent);
        }
        this._drawExtent = aExtent;
        this.repaintNew();
        this.fireViewExtentChangedEvent();
    }

    private void setCoordinateGeoMap(Extent aExtent) {
        this.setCoordinateGeoMap(aExtent, this.getWidth(), this.getHeight());
    }

    private void setCoordinateGeoMap(Extent aExtent, int width, int height) {
        this._scaleX = (double)width / (aExtent.maxX - aExtent.minX);
        this._scaleY = (double)height / (aExtent.maxY - aExtent.minY);
        double scaleFactor = this._projection.isLonLatMap() ? this._XYScaleFactor : 1.0;
        if (this._scaleX > this._scaleY) {
            this._scaleX = this._scaleY / scaleFactor;
            double temp = aExtent.minX;
            aExtent.minX = aExtent.maxX - (double)width / this._scaleX;
            double lonRan = (aExtent.minX - temp) / 2.0;
            aExtent.minX -= lonRan;
            aExtent.maxX -= lonRan;
        } else {
            this._scaleY = this._scaleX * scaleFactor;
            double temp = aExtent.minY;
            aExtent.minY = aExtent.maxY - (double)height / this._scaleY;
            double latRan = (aExtent.minY - temp) / 2.0;
            aExtent.minY -= latRan;
            aExtent.maxY -= latRan;
        }
    }

    private void setCoordinateGeoMapEx(Extent aExtent) {
        this.setCoordinateGeoMapEx(aExtent, this.getWidth(), this.getHeight());
    }

    private void setCoordinateGeoMapEx(Extent aExtent, int width, int height) {
        this._scaleX = (double)width / (aExtent.maxX - aExtent.minX);
        this._scaleY = (double)height / (aExtent.maxY - aExtent.minY);
        double scaleFactor = this._projection.isLonLatMap() ? this._XYScaleFactor : 1.0;
        if (this._scaleX < this._scaleY) {
            this._scaleX = this._scaleY / scaleFactor;
        } else {
            this._scaleY = this._scaleX * scaleFactor;
        }
    }

    private void setCoordinateMap(Extent aExtent) {
        this.setCoordinateMap(aExtent, this.getWidth(), this.getHeight());
    }

    private void setCoordinateMap(Extent aExtent, int width, int height) {
        this._scaleX = (double)width / (aExtent.maxX - aExtent.minX);
        this._scaleY = (double)height / (aExtent.maxY - aExtent.minY);
    }

    private void setScale(double scale, int width, int height) {
        this._scaleX = scale;
        this._scaleY = scale;
        org.meteoinfo.global.PointD center = (org.meteoinfo.global.PointD)this._viewExtent.getCenterPoint().clone();
        double xlen = (double)width / scale * 0.5;
        double ylen = (double)height / scale * 0.5;
        this._drawExtent.minX = center.X - xlen;
        this._drawExtent.maxX = center.X + xlen;
        this._drawExtent.minY = center.Y - ylen;
        this._drawExtent.maxY = center.Y + ylen;
    }

    public void refreshXYScale() {
        this.refreshXYScale(this.getWidth(), this.getHeight());
    }

    public void refreshXYScale(int width, int height) {
        Extent aExtent = (Extent)this._viewExtent.clone();
        if (this._isGeoMap) {
            this.setCoordinateGeoMap(aExtent, width, height);
        } else {
            this.setCoordinateMap(aExtent, width, height);
        }
        this._drawExtent = aExtent;
    }

    private double getGeoWidth(double width) {
        double geoWidth = width / this._scaleX;
        if (this._projection.isLonLatMap()) {
            geoWidth *= this.getLonDistScale();
        }
        return geoWidth;
    }

    private double getLonDistScale() {
        double pY = (this._viewExtent.maxY + this._viewExtent.minY) / 2.0;
        double ProjX = 0.0;
        double ProjY = pY;
        double pProjX = 1.0;
        double pProjY = pY;
        double dx = Math.abs(ProjX - pProjX);
        double dy = Math.abs(ProjY - pProjY);
        double y = (ProjY + pProjY) / 2.0;
        double factor = Math.cos(y * Math.PI / 180.0);
        double dist = Math.sqrt((dx *= factor) * dx + dy * dy);
        return dist *= 111319.5;
    }

    public double getGeoScale() {
        double breakWidth = 1.0;
        double geoBreakWidth = this.getGeoWidth(breakWidth);
        double scale = geoBreakWidth * 100.0 / (breakWidth / 96.0 * 2.539999918);
        return scale;
    }

    public org.meteoinfo.global.PointD getGeoCenter() {
        org.meteoinfo.global.PointD viewCenter = this.getViewCenter();
        return Reproject.reprojectPoint(viewCenter, this.getProjection().getProjInfo(), KnownCoordinateSystems.geographic.world.WGS1984);
    }

    public org.meteoinfo.global.PointD getViewCenter() {
        return this._viewExtent.getCenterPoint();
    }

    public void setViewCenter(org.meteoinfo.global.PointD center) {
        org.meteoinfo.global.PointD oldCenter = this.getViewCenter();
        double dx = center.X - oldCenter.X;
        double dy = center.Y - oldCenter.Y;
        Extent extent = this._viewExtent.shift(dx, dy);
        this.zoomToExtent(extent);
    }

    public boolean selectGraphics(PointF aPoint, GraphicCollection selectedGraphics, double lonShift) {
        this._visibleGraphics = this.getVisibleGraphics();
        return this.selectGraphics(aPoint, this._visibleGraphics, selectedGraphics, lonShift, 0);
    }

    private GraphicCollection getVisibleGraphics() {
        GraphicCollection graphicCollection = new GraphicCollection();
        for (Graphic aGraphic : this._graphicCollection.getGraphics()) {
            graphicCollection.add(aGraphic);
        }
        for (MapLayer aLayer : this.layers) {
            if (aLayer.getLayerType() != LayerTypes.VectorLayer || !aLayer.isVisible()) continue;
            VectorLayer vLayer = (VectorLayer)aLayer;
            for (Graphic graphic : vLayer.getLabelPoints()) {
                if (!graphic.getShape().isVisible()) continue;
                graphicCollection.add(graphic);
            }
            for (Graphic graphic : vLayer.getChartPoints()) {
                if (!graphic.getShape().isVisible()) continue;
                graphicCollection.add(graphic);
            }
        }
        return graphicCollection;
    }

    public boolean selectGraphics_back(PointF aPoint, GraphicCollection baseGraphics, GraphicCollection selectedGraphics, double lonShift, int limit) {
        int i;
        if (baseGraphics.isEmpty()) {
            return false;
        }
        selectedGraphics.clear();
        Graphics2D g = (Graphics2D)this.getGraphics();
        boolean ifSel = true;
        if (this._projection.isLonLatMap()) {
            boolean ifCheckLonShift = true;
            if (baseGraphics.get(0).getShape().getShapeType() == ShapeTypes.Point) {
                for (i = 0; i < baseGraphics.size(); ++i) {
                    Graphic aGraphic = baseGraphics.get(i);
                    java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                    rect.width += limit;
                    rect.height += limit;
                    if (!MIMath.pointInRectangle(aPoint, rect)) continue;
                    selectedGraphics.add(aGraphic);
                    break;
                }
                if (selectedGraphics.size() > 0) {
                    ifCheckLonShift = false;
                    ifSel = false;
                }
            }
            if (ifCheckLonShift) {
                float[] pXY = this.screenToProj(aPoint.X, aPoint.Y);
                if ((double)pXY[0] < baseGraphics.getExtent().minX && baseGraphics.getExtent().minX > -360.0 && baseGraphics.getExtent().maxX > 0.0) {
                    lonShift = -360.0;
                }
                if ((double)pXY[0] > baseGraphics.getExtent().maxX && baseGraphics.getExtent().maxX < 360.0 && baseGraphics.getExtent().minX < 0.0) {
                    lonShift = 360.0;
                }
            }
        }
        if (ifSel) {
            for (i = 0; i < baseGraphics.size(); ++i) {
                Graphic aGraphic = baseGraphics.get(i);
                java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                rect.width += limit;
                rect.height += limit;
                if (!MIMath.pointInRectangle(aPoint, rect)) continue;
                selectedGraphics.add(aGraphic);
            }
        }
        return selectedGraphics.size() > 0;
    }

    public boolean selectGraphics(PointF aPoint, GraphicCollection baseGraphics, GraphicCollection selectedGraphics, double lonShift, int limit) {
        int i;
        if (baseGraphics.isEmpty()) {
            return false;
        }
        selectedGraphics.clear();
        Graphics2D g = (Graphics2D)this.getGraphics();
        boolean ifSel = true;
        double[] projXY = this.screenToProj((double)aPoint.X, (double)aPoint.Y);
        double projX = projXY[0] + lonShift;
        double projY = projXY[1];
        org.meteoinfo.global.PointD pp = new org.meteoinfo.global.PointD(projX, projY);
        double buffer = 5.0 / this._scaleX;
        if (this._projection.isLonLatMap()) {
            boolean ifCheckLonShift = true;
            block6: for (i = 0; i < baseGraphics.size(); ++i) {
                Graphic aGraphic = baseGraphics.get(i);
                switch (aGraphic.getShape().getShapeType()) {
                    case Polyline: 
                    case CurveLine: {
                        PolylineShape aPLS = (PolylineShape)aGraphic.getShape();
                        if (GeoComputation.selectPolylineShape(pp, aPLS, buffer) == null) continue block6;
                        selectedGraphics.add(aGraphic);
                        continue block6;
                    }
                    default: {
                        java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                        rect.width += limit;
                        rect.height += limit;
                        if (!MIMath.pointInRectangle(aPoint, rect)) continue block6;
                        selectedGraphics.add(aGraphic);
                    }
                }
            }
            if (selectedGraphics.size() > 0) {
                ifCheckLonShift = false;
                ifSel = false;
            }
            if (ifCheckLonShift) {
                float[] pXY = this.screenToProj(aPoint.X, aPoint.Y);
                if ((double)pXY[0] < baseGraphics.getExtent().minX && baseGraphics.getExtent().minX > -360.0 && baseGraphics.getExtent().maxX > 0.0) {
                    lonShift = -360.0;
                }
                if ((double)pXY[0] > baseGraphics.getExtent().maxX && baseGraphics.getExtent().maxX < 360.0 && baseGraphics.getExtent().minX < 0.0) {
                    lonShift = 360.0;
                }
            }
        }
        if (ifSel) {
            projX = projXY[0] + lonShift;
            pp = new org.meteoinfo.global.PointD(projX, projY);
            block7: for (i = 0; i < baseGraphics.size(); ++i) {
                Graphic aGraphic = baseGraphics.get(i);
                switch (aGraphic.getShape().getShapeType()) {
                    case Polyline: 
                    case CurveLine: {
                        PolylineShape aPLS = (PolylineShape)aGraphic.getShape();
                        if (GeoComputation.selectPolylineShape(pp, aPLS, buffer) == null) continue block7;
                        selectedGraphics.add(aGraphic);
                        continue block7;
                    }
                    default: {
                        java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                        rect.width += limit;
                        rect.height += limit;
                        if (!MIMath.pointInRectangle(aPoint, rect)) continue block7;
                        selectedGraphics.add(aGraphic);
                    }
                }
            }
        }
        return selectedGraphics.size() > 0;
    }

    public boolean selectGraphics(java.awt.Rectangle aRect, GraphicCollection selectedGraphics, double lonShift) {
        this._visibleGraphics = this.getVisibleGraphics();
        return this.selectGraphics(aRect, this._visibleGraphics, selectedGraphics, lonShift);
    }

    public boolean selectGraphics_back(java.awt.Rectangle aRect, GraphicCollection baseGraphics, GraphicCollection selectedGraphics, double lonShift) {
        int i;
        if (baseGraphics.isEmpty()) {
            return false;
        }
        selectedGraphics.clear();
        Graphics2D g = (Graphics2D)this.getGraphics();
        boolean ifSel = true;
        if (this._projection.isLonLatMap()) {
            boolean ifCheckLonShift = true;
            if (baseGraphics.get(0).getShape().getShapeType() == ShapeTypes.Point) {
                for (i = 0; i < baseGraphics.size(); ++i) {
                    Graphic aGraphic = baseGraphics.get(i);
                    java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                    if (!MIMath.isInclude(aRect, rect)) continue;
                    selectedGraphics.add(aGraphic);
                    break;
                }
                if (selectedGraphics.size() > 0) {
                    ifCheckLonShift = false;
                    ifSel = false;
                }
            }
            if (ifCheckLonShift) {
                Point aPoint = new Point(aRect.x + aRect.width / 2, aRect.y + aRect.height / 2);
                float[] pXY = this.screenToProj(aPoint.x, aPoint.y);
                if ((double)pXY[0] < baseGraphics.getExtent().minX && baseGraphics.getExtent().minX > -360.0 && baseGraphics.getExtent().maxX > 0.0) {
                    lonShift = -360.0;
                }
                if ((double)pXY[0] > baseGraphics.getExtent().maxX && baseGraphics.getExtent().maxX < 360.0 && baseGraphics.getExtent().minX < 0.0) {
                    lonShift = 360.0;
                }
            }
        }
        if (ifSel) {
            for (i = 0; i < baseGraphics.size(); ++i) {
                Graphic aGraphic = baseGraphics.get(i);
                java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                if (!MIMath.isInclude(aRect, rect)) continue;
                selectedGraphics.add(aGraphic);
            }
        }
        return selectedGraphics.size() > 0;
    }

    public boolean selectGraphics(java.awt.Rectangle aRect, GraphicCollection baseGraphics, GraphicCollection selectedGraphics, double lonShift) {
        int i;
        if (baseGraphics.isEmpty()) {
            return false;
        }
        selectedGraphics.clear();
        Graphics2D g = (Graphics2D)this.getGraphics();
        boolean ifSel = true;
        if (this._projection.isLonLatMap()) {
            boolean ifCheckLonShift = true;
            for (i = 0; i < baseGraphics.size(); ++i) {
                Graphic aGraphic = baseGraphics.get(i);
                java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                if (!MIMath.isInclude(aRect, rect)) continue;
                selectedGraphics.add(aGraphic);
                break;
            }
            if (selectedGraphics.size() > 0) {
                ifCheckLonShift = false;
                ifSel = false;
            }
            if (ifCheckLonShift) {
                Point aPoint = new Point(aRect.x + aRect.width / 2, aRect.y + aRect.height / 2);
                float[] pXY = this.screenToProj(aPoint.x, aPoint.y);
                if ((double)pXY[0] < baseGraphics.getExtent().minX && baseGraphics.getExtent().minX > -360.0 && baseGraphics.getExtent().maxX > 0.0) {
                    lonShift = -360.0;
                }
                if ((double)pXY[0] > baseGraphics.getExtent().maxX && baseGraphics.getExtent().maxX < 360.0 && baseGraphics.getExtent().minX < 0.0) {
                    lonShift = 360.0;
                }
            }
        }
        if (ifSel) {
            for (i = 0; i < baseGraphics.size(); ++i) {
                Graphic aGraphic = baseGraphics.get(i);
                java.awt.Rectangle rect = this.getGraphicRectangle(g, aGraphic, lonShift);
                if (!MIMath.isInclude(aRect, rect)) continue;
                selectedGraphics.add(aGraphic);
            }
        }
        return selectedGraphics.size() > 0;
    }

    private static Edge intersectElementEdge(java.awt.Rectangle screen, PointF pt, float limit) {
        Rectangle2D.Float ptRect = new Rectangle2D.Float(pt.X - limit, pt.Y - limit, 2.0f * limit, 2.0f * limit);
        if (pt.X >= (float)screen.x - limit && pt.X <= (float)screen.x + limit && pt.Y >= (float)screen.y - limit && pt.Y <= (float)screen.y + limit) {
            return Edge.TopLeft;
        }
        if (pt.X >= (float)(screen.x + screen.width) - limit && pt.X <= (float)(screen.x + screen.width) + limit && pt.Y >= (float)screen.y - limit && pt.Y <= (float)screen.y + limit) {
            return Edge.TopRight;
        }
        if (pt.X >= (float)(screen.x + screen.width) - limit && pt.X <= (float)(screen.x + screen.width) + limit && pt.Y >= (float)(screen.y + screen.height) - limit && pt.Y <= (float)(screen.y + screen.height) + limit) {
            return Edge.BottomRight;
        }
        if (pt.X >= (float)screen.x - limit && pt.X <= (float)screen.x + limit && pt.Y >= (float)(screen.y + screen.height) - limit && pt.Y <= (float)(screen.y + screen.height) + limit) {
            return Edge.BottomLeft;
        }
        if (ptRect.intersects(new Rectangle2D.Float(screen.x, screen.y, screen.width, 1.0f))) {
            return Edge.Top;
        }
        if (ptRect.intersects(new Rectangle2D.Float(screen.x, screen.y, 1.0f, screen.height))) {
            return Edge.Left;
        }
        if (ptRect.intersects(new Rectangle2D.Float(screen.x, screen.y + screen.height, screen.width, 1.0f))) {
            return Edge.Bottom;
        }
        if (ptRect.intersects(new Rectangle2D.Float(screen.x + screen.width, screen.y, 1.0f, screen.height))) {
            return Edge.Right;
        }
        return Edge.None;
    }

    private org.meteoinfo.global.PointD selectSnapVertice(Point aPoint, VectorLayer layer, int buffer) {
        PolygonShape poly = new PolygonShape();
        ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
        float[] pXY = this.screenToProj(aPoint.x - buffer, aPoint.y + buffer);
        float minX = pXY[0];
        float minY = pXY[1];
        pXY = this.screenToProj(aPoint.x + buffer, aPoint.y - buffer);
        float maxX = pXY[0];
        float maxY = pXY[1];
        points.add(new org.meteoinfo.global.PointD(minX, minY));
        points.add(new org.meteoinfo.global.PointD(minX, maxY));
        points.add(new org.meteoinfo.global.PointD(maxX, maxY));
        points.add(new org.meteoinfo.global.PointD(maxX, minY));
        points.add(new org.meteoinfo.global.PointD(minX, minY));
        poly.setPoints(points);
        for (Shape shape : layer.getShapes()) {
            if (shape.isEditing() || !poly.intersects(shape) || poly.within(shape)) continue;
            for (org.meteoinfo.global.PointD pointD : shape.getPoints()) {
                if (!MIMath.pointInExtent(pointD, poly.getExtent())) continue;
                return pointD;
            }
        }
        return null;
    }

    private int selectEditVertices(Point aPoint, Shape aShape, List<org.meteoinfo.global.PointD> vertices) {
        int vIdx = -1;
        List<? extends org.meteoinfo.global.PointD> points = aShape.getPoints();
        int buffer = 4;
        Extent aExtent = new Extent();
        float[] pXY = this.screenToProj(aPoint.x - buffer, aPoint.y + buffer);
        aExtent.minX = pXY[0];
        aExtent.minY = pXY[1];
        pXY = this.screenToProj(aPoint.x + buffer, aPoint.y - buffer);
        aExtent.maxX = pXY[0];
        aExtent.maxY = pXY[1];
        vertices.clear();
        for (int i = 0; i < points.size(); ++i) {
            if (!MIMath.pointInExtent(points.get(i), aExtent)) continue;
            vIdx = i;
            vertices.add(points.get(i));
            switch (aShape.getShapeType()) {
                case Point: 
                case PointZ: {
                    vertices.add(points.get(0));
                    break;
                }
                case Polyline: 
                case CurveLine: {
                    if (i == 0) {
                        vertices.add(points.get(i + 1));
                        break;
                    }
                    if (i == points.size() - 1) {
                        vertices.add(points.get(i - 1));
                        break;
                    }
                    vertices.add(points.get(i - 1));
                    vertices.add(points.get(i + 1));
                    break;
                }
                default: {
                    if (i == 0) {
                        vertices.add(points.get(i + 1));
                        org.meteoinfo.global.PointD aPD = points.get(points.size() - 1);
                        if (aPD.X == points.get((int)i).X && aPD.Y == points.get((int)i).Y) {
                            vertices.add(points.get(points.size() - 2));
                            break;
                        }
                        vertices.add(aPD);
                        break;
                    }
                    if (i == points.size() - 1) {
                        vertices.add(points.get(i - 1));
                        org.meteoinfo.global.PointD aPD = points.get(0);
                        if (aPD.X == points.get((int)i).X && aPD.Y == points.get((int)i).Y) {
                            vertices.add(points.get(1));
                            break;
                        }
                        vertices.add(points.get(0));
                        break;
                    }
                    vertices.add(points.get(i - 1));
                    vertices.add(points.get(i + 1));
                    break;
                }
            }
            break;
        }
        return vIdx;
    }

    private int isOnRing(Point aPoint, Shape aShape) {
        int buffer = 2;
        Extent aExtent = new Extent();
        float[] pXY = this.screenToProj(aPoint.x - buffer, aPoint.y + buffer);
        aExtent.minX = pXY[0];
        aExtent.minY = pXY[1];
        pXY = this.screenToProj(aPoint.x + buffer, aPoint.y - buffer);
        aExtent.maxX = pXY[0];
        aExtent.maxY = pXY[1];
        org.meteoinfo.global.PointD bPoint = aExtent.getCenterPoint();
        if (MIMath.isExtentCross(aExtent, aShape.getExtent()).booleanValue()) {
            switch (aShape.getShapeType()) {
                case Polyline: {
                    PolylineShape lShape = (PolylineShape)aShape;
                    for (Polyline polyline : lShape.getPolylines()) {
                        Object object = GeoComputation.selectPolyline(bPoint, polyline.getPointList(), aExtent.getWidth() / 2.0);
                        if (object == null) continue;
                        return (Integer)((Object[])object)[0];
                    }
                    break;
                }
                case Polygon: {
                    PolygonShape pShape = (PolygonShape)aShape;
                    for (Polygon polygon : pShape.getPolygons()) {
                        for (List<org.meteoinfo.global.PointD> list : polygon.getRings()) {
                            Object sel = GeoComputation.selectPolyline(bPoint, list, aExtent.getWidth() / 2.0);
                            if (sel == null) continue;
                            return (Integer)((Object[])sel)[0];
                        }
                    }
                    break;
                }
            }
        }
        return -1;
    }

    public PolygonShape selectShape(VectorLayer layer, PointF p) {
        float sX = p.X;
        float sY = p.Y;
        double[] projXY = this.screenToProj((double)p.X, (double)p.Y);
        double projX = projXY[0];
        double projY = projXY[1];
        if (this._projection.isLonLatMap()) {
            double[] sXY;
            if (projX < layer.getExtent().minX && layer.getExtent().minX > -360.0 && layer.getExtent().maxX > 0.0) {
                sXY = this.projToScreen(projX, projY, 360.0);
                sX = (float)sXY[0];
                sY = (float)sXY[1];
            }
            if (projX > layer.getExtent().maxX && layer.getExtent().maxX < 360.0 && layer.getExtent().minX < 0.0) {
                sXY = this.projToScreen(projX, projY, -360.0);
                sX = (float)sXY[0];
                sY = (float)sXY[1];
            }
        }
        projXY = this.screenToProj((double)sX, (double)sY);
        projX = projXY[0];
        projY = projXY[1];
        for (int i = 0; i < layer.getShapeNum(); ++i) {
            PolygonShape shape = (PolygonShape)layer.getShapes().get(i);
            if (!GeoComputation.pointInPolygon(shape, new org.meteoinfo.global.PointD(projX, projY))) continue;
            return shape;
        }
        return null;
    }

    public Object[] selectPolygonHole(VectorLayer layer, PointF p) {
        float sX = p.X;
        float sY = p.Y;
        double[] projXY = this.screenToProj((double)p.X, (double)p.Y);
        double projX = projXY[0];
        double projY = projXY[1];
        if (this._projection.isLonLatMap()) {
            double[] sXY;
            if (projX < layer.getExtent().minX && layer.getExtent().minX > -360.0 && layer.getExtent().maxX > 0.0) {
                sXY = this.projToScreen(projX, projY, 360.0);
                sX = (float)sXY[0];
                sY = (float)sXY[1];
            }
            if (projX > layer.getExtent().maxX && layer.getExtent().maxX < 360.0 && layer.getExtent().minX < 0.0) {
                sXY = this.projToScreen(projX, projY, -360.0);
                sX = (float)sXY[0];
                sY = (float)sXY[1];
            }
        }
        projXY = this.screenToProj((double)sX, (double)sY);
        projX = projXY[0];
        projY = projXY[1];
        return layer.selectPolygonHole(new org.meteoinfo.global.PointD(projX, projY));
    }

    public List<Integer> selectShapes(VectorLayer aLayer, PointF aPoint, boolean onlyVisible, boolean isSel) {
        float sX = aPoint.X;
        float sY = aPoint.Y;
        double[] projXY = this.screenToProj((double)aPoint.X, (double)aPoint.Y);
        double ProjX = projXY[0];
        double ProjY = projXY[1];
        if (this._projection.isLonLatMap()) {
            double[] sXY;
            if (ProjX < aLayer.getExtent().minX && aLayer.getExtent().minX > -360.0 && aLayer.getExtent().maxX > 0.0) {
                sXY = this.projToScreen(ProjX, ProjY, 360.0);
                sX = (float)sXY[0];
                sY = (float)sXY[1];
            }
            if (ProjX > aLayer.getExtent().maxX && aLayer.getExtent().maxX < 360.0 && aLayer.getExtent().minX < 0.0) {
                sXY = this.projToScreen(ProjX, ProjY, -360.0);
                sX = (float)sXY[0];
                sY = (float)sXY[1];
            }
        }
        int Buffer2 = 5;
        Extent aExtent = new Extent();
        projXY = this.screenToProj((double)sX - (double)Buffer2, (double)(sY + (float)Buffer2));
        ProjX = projXY[0];
        ProjY = projXY[1];
        aExtent.minX = ProjX;
        aExtent.minY = ProjY;
        projXY = this.screenToProj((double)sX + (double)Buffer2, (double)(sY - (float)Buffer2));
        ProjX = projXY[0];
        ProjY = projXY[1];
        aExtent.maxX = ProjX;
        aExtent.maxY = ProjY;
        List<Integer> selectedShapes = onlyVisible ? aLayer.selectShapes(aExtent, aLayer.getVisibleShapes(), isSel) : aLayer.selectShapes(aExtent, isSel);
        return selectedShapes;
    }

    public List<Integer> selectShapes(VectorLayer aLayer, PointF aPoint) {
        return this.selectShapes(aLayer, aPoint, false, false);
    }

    public List<Integer> selectShapes(VectorLayer aLayer, List<Shape> baseShapes, Rectangle2D.Float rect, boolean isSingleSel, boolean isSel) {
        Extent aExtent = new Extent();
        double[] projs = this.screenToProj(rect.getMinX(), rect.getMinY());
        aExtent.minX = projs[0];
        aExtent.maxY = projs[1];
        projs = this.screenToProj(rect.getMaxX(), rect.getMaxY());
        aExtent.maxX = projs[0];
        aExtent.minY = projs[1];
        if (this._projection.isLonLatMap()) {
            if (aExtent.maxX < aLayer.getExtent().minX && aLayer.getExtent().minX > -360.0 && aLayer.getExtent().maxX > 0.0) {
                aExtent = MIMath.shiftExtentLon(aExtent, 360.0);
            }
            if (aExtent.minX > aLayer.getExtent().maxX && aLayer.getExtent().maxX < 360.0 && aLayer.getExtent().minX < 0.0) {
                aExtent = MIMath.shiftExtentLon(aExtent, -360.0);
            }
        }
        List<Integer> selectedShapes = aLayer.selectShapes(aExtent, baseShapes, isSingleSel);
        if (isSel) {
            for (int i : selectedShapes) {
                aLayer.getShapes().get(i).setSelected(true);
            }
        }
        return selectedShapes;
    }

    public List<Integer> selectShapes(VectorLayer aLayer, Rectangle2D.Float rect, boolean isSingleSel) {
        return this.selectShapes(aLayer, aLayer.getShapes(), rect, isSingleSel, false);
    }

    public List<Integer> selectShapes(VectorLayer aLayer, Rectangle2D.Float rect) {
        return this.selectShapes(aLayer, aLayer.getShapes(), rect, false, false);
    }

    public int[] selectGridCell(RasterLayer aLayer, PointF aPoint) {
        double LonShift = 0.0;
        double[] projXY = this.screenToProj((double)aPoint.X, (double)aPoint.Y);
        double aX = projXY[0];
        double aY = projXY[1];
        if (this._projection.isLonLatMap()) {
            if (aX < aLayer.getExtent().minX && aLayer.getExtent().minX > -360.0 && aLayer.getExtent().maxX > 0.0) {
                LonShift = 360.0;
            }
            if (aX > aLayer.getExtent().maxX && aLayer.getExtent().maxX < 360.0 && aLayer.getExtent().minX < 0.0) {
                LonShift = -360.0;
            }
        }
        Extent aExtent = new Extent();
        double XDelt = aLayer.getGridData().xArray[1] - aLayer.getGridData().xArray[0];
        double YDelt = aLayer.getGridData().yArray[1] - aLayer.getGridData().yArray[0];
        aExtent.minX = (aX += (double)((float)LonShift)) - XDelt / 2.0;
        aExtent.maxX = aX + XDelt / 2.0;
        aExtent.minY = aY - YDelt / 2.0;
        aExtent.maxY = aY + YDelt / 2.0;
        int iIdx = -1;
        int jIdx = -1;
        for (int i = 0; i < aLayer.getGridData().getYNum(); ++i) {
            if (!(aLayer.getGridData().yArray[i] >= aExtent.minY) || !(aLayer.getGridData().yArray[i] <= aExtent.maxY)) continue;
            iIdx = i;
            break;
        }
        for (int j = 0; j < aLayer.getGridData().getXNum(); ++j) {
            if (!(aLayer.getGridData().xArray[j] >= aExtent.minX) || !(aLayer.getGridData().xArray[j] <= aExtent.maxX)) continue;
            jIdx = j;
            break;
        }
        if (iIdx == -1 || jIdx == -1) {
            return null;
        }
        return new int[]{iIdx, jIdx};
    }

    public java.awt.Rectangle getGraphicRectangle(Graphics2D g, Graphic aGraphic, double lonShift) {
        java.awt.Rectangle rect = new java.awt.Rectangle();
        switch (aGraphic.getShape().getShapeType()) {
            case Point: 
            case PointM: {
                PointShape aPS = (PointShape)aGraphic.getShape();
                double[] sXY = this.projToScreen(aPS.getPoint().X, aPS.getPoint().Y, lonShift);
                float aX = (float)sXY[0];
                float aY = (float)sXY[1];
                switch (aGraphic.getLegend().getBreakType()) {
                    case PointBreak: {
                        PointBreak aPB = (PointBreak)aGraphic.getLegend();
                        int buffer = (int)aPB.getSize() + 2;
                        rect.x = (int)aX - buffer / 2;
                        rect.y = (int)aY - buffer / 2;
                        rect.width = buffer;
                        rect.height = buffer;
                        break;
                    }
                    case LabelBreak: {
                        LabelBreak aLB = (LabelBreak)aGraphic.getLegend();
                        g.setFont(aLB.getFont());
                        Dimension dimension = Draw.getStringDimension(aLB.getText(), g);
                        switch (aLB.getAlignType()) {
                            case Center: {
                                aX -= (float)(dimension.width / 2);
                                break;
                            }
                            case Left: {
                                aX -= (float)dimension.width;
                            }
                        }
                        aY -= aLB.getYShift();
                        rect.x = (int)aX;
                        rect.y = (int)(aY -= (float)(dimension.height / 3));
                        rect.width = dimension.width;
                        rect.height = dimension.height;
                        break;
                    }
                    case ChartBreak: {
                        ChartBreak aCB = (ChartBreak)aGraphic.getLegend();
                        rect = aCB.getDrawExtent(new PointF(aX, aY)).convertToRectangle();
                    }
                }
                break;
            }
            case Polyline: 
            case Polygon: 
            case Rectangle: 
            case Circle: 
            case CurvePolygon: 
            case Ellipse: 
            case CurveLine: {
                List<? extends org.meteoinfo.global.PointD> newPList = aGraphic.getShape().getPoints();
                ArrayList<org.meteoinfo.global.PointD> points = new ArrayList<org.meteoinfo.global.PointD>();
                for (org.meteoinfo.global.PointD pointD : newPList) {
                    double[] sXY = this.projToScreen(pointD.X, pointD.Y, lonShift);
                    float aX = (float)sXY[0];
                    float aY = (float)sXY[1];
                    points.add(new org.meteoinfo.global.PointD(aX, aY));
                }
                Extent aExtent = MIMath.getPointsExtent(points);
                rect.x = (int)aExtent.minX;
                rect.y = (int)aExtent.minY;
                rect.width = (int)(aExtent.maxX - aExtent.minX);
                rect.height = (int)(aExtent.maxY - aExtent.minY);
            }
        }
        return rect;
    }

    public java.awt.Rectangle getGraphicRectangle(Graphic aGraphic, double lonShift) {
        return this.getGraphicRectangle((Graphics2D)this.getGraphics(), aGraphic, lonShift);
    }

    public java.awt.Rectangle getGraphicRectangle(Graphic aGraphic) {
        return this.getGraphicRectangle((Graphics2D)this.getGraphics(), aGraphic, 0.0);
    }

    public void addGraphic(Graphic graphic) {
        this._graphicCollection.add(graphic);
    }

    public void removeGraphic(Graphic aGraphic) {
        if (aGraphic.getClass().equals(ChartGraphic.class)) {
            for (MapLayer aLayer : this.layers) {
                VectorLayer aVLayer;
                if (aLayer.getLayerType() != LayerTypes.VectorLayer || !(aVLayer = (VectorLayer)aLayer).getChartPoints().contains((ChartGraphic)aGraphic)) continue;
                aVLayer.getChartPoints().remove((ChartGraphic)aGraphic);
                break;
            }
        } else if (this._graphicCollection.contains(aGraphic)) {
            this._graphicCollection.remove(aGraphic);
        } else {
            for (MapLayer aLayer : this.layers) {
                VectorLayer aVLayer;
                if (aLayer.getLayerType() != LayerTypes.VectorLayer || !(aVLayer = (VectorLayer)aLayer).getLabelPoints().contains(aGraphic)) continue;
                aVLayer.getLabelPoints().remove(aGraphic);
                break;
            }
        }
    }

    public void removeSelectedGraphics() {
        MapViewUndoRedo mapViewUndoRedo = new MapViewUndoRedo();
        Objects.requireNonNull(mapViewUndoRedo);
        MapViewUndoRedo.RemoveGraphicsEdit edit = new MapViewUndoRedo.RemoveGraphicsEdit(mapViewUndoRedo, this, this._selectedGraphics.getGraphics());
        this.fireUndoEditEvent(edit);
        for (Graphic aGraphic : this._selectedGraphics.getGraphics()) {
            this.removeGraphic(aGraphic);
        }
        this._selectedGraphics.clear();
    }

    public void exportExtentsElement(org.w3c.dom.Document m_Doc, Element parent) {
        Element Extents = m_Doc.createElement("Extents");
        Attr xMin = m_Doc.createAttribute("xMin");
        Attr xMax = m_Doc.createAttribute("xMax");
        Attr yMin = m_Doc.createAttribute("yMin");
        Attr yMax = m_Doc.createAttribute("yMax");
        xMin.setValue(String.valueOf(this._viewExtent.minX));
        xMax.setValue(String.valueOf(this._viewExtent.maxX));
        yMin.setValue(String.valueOf(this._viewExtent.minY));
        yMax.setValue(String.valueOf(this._viewExtent.maxY));
        Extents.setAttributeNode(xMin);
        Extents.setAttributeNode(xMax);
        Extents.setAttributeNode(yMin);
        Extents.setAttributeNode(yMax);
        parent.appendChild(Extents);
    }

    public void exportMapPropElement(org.w3c.dom.Document m_Doc, Element parent) {
        Element mapProperty = m_Doc.createElement("MapProperty");
        Attr BackColor = m_Doc.createAttribute("BackColor");
        Attr ForeColor = m_Doc.createAttribute("ForeColor");
        Attr SmoothingMode = m_Doc.createAttribute("SmoothingMode");
        Attr pointSmoothingMode = m_Doc.createAttribute("PointSmoothingMode");
        Attr xyScaleFactor = m_Doc.createAttribute("XYScaleFactor");
        Attr multiGlobalDraw = m_Doc.createAttribute("MultiGlobalDraw");
        Attr selectColor = m_Doc.createAttribute("SelectColor");
        Attr highSpeedWheelZoom = m_Doc.createAttribute("HighSpeedWheelZoom");
        BackColor.setValue(ColorUtil.toHexEncoding(this.getBackground()));
        ForeColor.setValue(ColorUtil.toHexEncoding(this.getForeground()));
        SmoothingMode.setValue(String.valueOf(this._antiAlias));
        pointSmoothingMode.setValue(String.valueOf(this._pointAntiAlias));
        xyScaleFactor.setValue(String.valueOf(this._XYScaleFactor));
        multiGlobalDraw.setValue(String.valueOf(this._multiGlobalDraw));
        selectColor.setValue(ColorUtil.toHexEncoding(this._selectColor));
        highSpeedWheelZoom.setValue(String.valueOf(this._highSpeedWheelZoom));
        mapProperty.setAttributeNode(BackColor);
        mapProperty.setAttributeNode(ForeColor);
        mapProperty.setAttributeNode(SmoothingMode);
        mapProperty.setAttributeNode(pointSmoothingMode);
        mapProperty.setAttributeNode(xyScaleFactor);
        mapProperty.setAttributeNode(multiGlobalDraw);
        mapProperty.setAttributeNode(selectColor);
        mapProperty.setAttributeNode(highSpeedWheelZoom);
        parent.appendChild(mapProperty);
    }

    public void exportGridLineElement(org.w3c.dom.Document m_Doc, Element parent) {
        Element GridLine2 = m_Doc.createElement("GridLine");
        Attr GridLineColor = m_Doc.createAttribute("GridLineColor");
        Attr GridLineSize = m_Doc.createAttribute("GridLineSize");
        Attr GridLineStyle = m_Doc.createAttribute("GridLineStyle");
        Attr DrawGridLine = m_Doc.createAttribute("DrawGridLine");
        Attr DrawGridTickLine = m_Doc.createAttribute("DrawGridTickLine");
        GridLineColor.setValue(ColorUtil.toHexEncoding(this._gridLineColor));
        GridLineSize.setValue(String.valueOf(this._gridLineSize));
        GridLineStyle.setValue(this._gridLineStyle.toString());
        DrawGridLine.setValue(String.valueOf(this._drawGridLine));
        DrawGridTickLine.setValue(String.valueOf(this._drawGridTickLine));
        GridLine2.setAttributeNode(GridLineColor);
        GridLine2.setAttributeNode(GridLineSize);
        GridLine2.setAttributeNode(GridLineStyle);
        GridLine2.setAttributeNode(DrawGridLine);
        GridLine2.setAttributeNode(DrawGridTickLine);
        parent.appendChild(GridLine2);
    }

    public void exportMaskOutElement(org.w3c.dom.Document m_Doc, Element parent) {
        Element MaskOut2 = m_Doc.createElement("MaskOut");
        Attr SetMaskLayer = m_Doc.createAttribute("SetMaskLayer");
        Attr MaskLayer = m_Doc.createAttribute("MaskLayer");
        SetMaskLayer.setValue(String.valueOf(this._maskOut.isMask()));
        MaskLayer.setValue(this._maskOut.getMaskLayer());
        MaskOut2.setAttributeNode(SetMaskLayer);
        MaskOut2.setAttributeNode(MaskLayer);
        parent.appendChild(MaskOut2);
    }

    public void exportProjectionElement(org.w3c.dom.Document m_Doc, Element parent) {
        Element Projection2 = m_Doc.createElement("Projection");
        Attr IsLonLatMap = m_Doc.createAttribute("IsLonLatMap");
        Attr ProjStr = m_Doc.createAttribute("ProjStr");
        IsLonLatMap.setValue(String.valueOf(this._projection.isLonLatMap()));
        ProjStr.setValue(this._projection.getProjInfo().toProj4String());
        Projection2.setAttributeNode(IsLonLatMap);
        Projection2.setAttributeNode(ProjStr);
        parent.appendChild(Projection2);
    }

    public void exportVectorLayerElement(org.w3c.dom.Document m_Doc, Element parent, VectorLayer aVLayer, String projectFilePath) {
        Element Layer = m_Doc.createElement("Layer");
        Attr Handle = m_Doc.createAttribute("Handle");
        Attr LayerName = m_Doc.createAttribute("LayerName");
        Attr FileName = m_Doc.createAttribute("FileName");
        Attr Visible = m_Doc.createAttribute("Visible");
        Attr IsMaskout = m_Doc.createAttribute("IsMaskout");
        Attr LayerType = m_Doc.createAttribute("LayerType");
        Attr LayerDrawType2 = m_Doc.createAttribute("LayerDrawType");
        Attr ShapeType = m_Doc.createAttribute("ShapeType");
        Attr AvoidCollision = m_Doc.createAttribute("AvoidCollision");
        Attr TransparencyPerc = m_Doc.createAttribute("TransparencyPerc");
        Attr Expanded = m_Doc.createAttribute("Expanded");
        Handle.setValue(String.valueOf(aVLayer.getHandle()));
        LayerName.setValue(aVLayer.getLayerName());
        try {
            FileName.setValue(GlobalUtil.getRelativePath(aVLayer.getFileName(), projectFilePath));
        }
        catch (IOException ex) {
            Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
        }
        Visible.setValue(String.valueOf(aVLayer.isVisible()));
        IsMaskout.setValue(String.valueOf(aVLayer.isMaskout()));
        LayerType.setValue(aVLayer.getLayerType().toString());
        LayerDrawType2.setValue(aVLayer.getLayerDrawType().toString());
        ShapeType.setValue(aVLayer.getShapeType().toString());
        AvoidCollision.setValue(String.valueOf(aVLayer.getAvoidCollision()));
        TransparencyPerc.setValue(String.valueOf(aVLayer.getTransparency()));
        Expanded.setValue(String.valueOf(aVLayer.isExpanded()));
        Layer.setAttributeNode(Handle);
        Layer.setAttributeNode(LayerName);
        Layer.setAttributeNode(FileName);
        Layer.setAttributeNode(Visible);
        Layer.setAttributeNode(IsMaskout);
        Layer.setAttributeNode(LayerType);
        Layer.setAttributeNode(LayerDrawType2);
        Layer.setAttributeNode(ShapeType);
        Layer.setAttributeNode(AvoidCollision);
        Layer.setAttributeNode(TransparencyPerc);
        Layer.setAttributeNode(Expanded);
        aVLayer.getLegendScheme().exportToXML(m_Doc, Layer);
        this.exportLabelSet(m_Doc, Layer, aVLayer.getLabelSet());
        this.exportGraphics(m_Doc, Layer, aVLayer.getLabelPoints());
        this.exportChartSet(m_Doc, Layer, aVLayer.getChartSet());
        this.exportChartGraphics(m_Doc, Layer, aVLayer.getChartPoints());
        this.exportVisibleScale(m_Doc, Layer, aVLayer.getVisibleScale());
        parent.appendChild(Layer);
    }

    private void exportLabelSet(org.w3c.dom.Document m_Doc, Element parent, LabelSet aLabelSet) {
        Element LabelSet2 = m_Doc.createElement("LabelSet");
        Attr DrawLabels = m_Doc.createAttribute("DrawLabels");
        Attr FieldName = m_Doc.createAttribute("FieldName");
        Attr FontName = m_Doc.createAttribute("FontName");
        Attr FontSize = m_Doc.createAttribute("FontSize");
        Attr LabelColor = m_Doc.createAttribute("LabelColor");
        Attr DrawShadow = m_Doc.createAttribute("DrawShadow");
        Attr ShadowColor = m_Doc.createAttribute("ShadowColor");
        Attr AlignType2 = m_Doc.createAttribute("AlignType");
        Attr Offset = m_Doc.createAttribute("Offset");
        Attr AvoidCollision = m_Doc.createAttribute("AvoidCollision");
        Attr autoDecimal = m_Doc.createAttribute("AutoDecimal");
        Attr decimalDigits = m_Doc.createAttribute("DecimalDigits");
        DrawLabels.setValue(String.valueOf(aLabelSet.isDrawLabels()));
        FieldName.setValue(aLabelSet.getFieldName());
        FontName.setValue(aLabelSet.getLabelFont().getFontName());
        FontSize.setValue(String.valueOf(aLabelSet.getLabelFont().getSize()));
        LabelColor.setValue(ColorUtil.toHexEncoding(aLabelSet.getLabelColor()));
        DrawShadow.setValue(String.valueOf(aLabelSet.isDrawShadow()));
        ShadowColor.setValue(ColorUtil.toHexEncoding(aLabelSet.getShadowColor()));
        AlignType2.setValue(aLabelSet.getLabelAlignType().toString());
        Offset.setValue(String.valueOf(aLabelSet.getYOffset()));
        AvoidCollision.setValue(String.valueOf(aLabelSet.isAvoidCollision()));
        autoDecimal.setValue(String.valueOf(aLabelSet.isAutoDecimal()));
        decimalDigits.setValue(String.valueOf(aLabelSet.getDecimalDigits()));
        LabelSet2.setAttributeNode(DrawLabels);
        LabelSet2.setAttributeNode(FieldName);
        LabelSet2.setAttributeNode(FontName);
        LabelSet2.setAttributeNode(FontSize);
        LabelSet2.setAttributeNode(LabelColor);
        LabelSet2.setAttributeNode(DrawShadow);
        LabelSet2.setAttributeNode(ShadowColor);
        LabelSet2.setAttributeNode(AlignType2);
        LabelSet2.setAttributeNode(Offset);
        LabelSet2.setAttributeNode(AvoidCollision);
        LabelSet2.setAttributeNode(autoDecimal);
        LabelSet2.setAttributeNode(decimalDigits);
        parent.appendChild(LabelSet2);
    }

    private void exportChartSet(org.w3c.dom.Document m_Doc, Element parent, ChartSet aChartSet) {
        Element chartSet = m_Doc.createElement("ChartSet");
        Attr drawCharts = m_Doc.createAttribute("DrawCharts");
        Attr chartType = m_Doc.createAttribute("ChartType");
        Attr fieldNames = m_Doc.createAttribute("FieldNames");
        Attr xShift = m_Doc.createAttribute("XShift");
        Attr yShift = m_Doc.createAttribute("YShift");
        Attr maxSize = m_Doc.createAttribute("MaxSize");
        Attr minSize = m_Doc.createAttribute("MinSize");
        Attr maxValue = m_Doc.createAttribute("MaxValue");
        Attr minValue = m_Doc.createAttribute("MinValue");
        Attr barWidth = m_Doc.createAttribute("BarWidth");
        Attr avoidCollision = m_Doc.createAttribute("AvoidCollision");
        Attr alignType = m_Doc.createAttribute("AlignType");
        Attr view3D = m_Doc.createAttribute("View3D");
        Attr thickness = m_Doc.createAttribute("Thickness");
        Attr drawLabel = m_Doc.createAttribute("DrawLabel");
        Attr fontName = m_Doc.createAttribute("FontName");
        Attr fontSize = m_Doc.createAttribute("FontSize");
        Attr labelColor = m_Doc.createAttribute("LabelColor");
        drawCharts.setValue(String.valueOf(aChartSet.isDrawCharts()));
        chartType.setValue(String.valueOf((Object)aChartSet.getChartType()));
        String fns = "";
        for (int i = 0; i < aChartSet.getFieldNames().size(); ++i) {
            fns = i == 0 ? aChartSet.getFieldNames().get(i) : fns + "," + aChartSet.getFieldNames().get(i);
        }
        fieldNames.setValue(fns);
        xShift.setValue(String.valueOf(aChartSet.getXShift()));
        yShift.setValue(String.valueOf(aChartSet.getYShift()));
        maxSize.setValue(String.valueOf(aChartSet.getMaxSize()));
        minSize.setValue(String.valueOf(aChartSet.getMinSize()));
        maxValue.setValue(String.valueOf(aChartSet.getMaxValue()));
        minValue.setValue(String.valueOf(aChartSet.getMinValue()));
        barWidth.setValue(String.valueOf(aChartSet.getBarWidth()));
        avoidCollision.setValue(String.valueOf(aChartSet.isAvoidCollision()));
        alignType.setValue(aChartSet.getAlignType().toString());
        view3D.setValue(String.valueOf(aChartSet.isView3D()));
        thickness.setValue(String.valueOf(aChartSet.getThickness()));
        drawLabel.setValue(String.valueOf(aChartSet.isDrawLabel()));
        fontName.setValue(aChartSet.getLabelFont().getFontName());
        fontSize.setValue(String.valueOf(aChartSet.getLabelFont().getSize()));
        labelColor.setValue(ColorUtil.toHexEncoding(aChartSet.getLabelColor()));
        chartSet.setAttributeNode(drawCharts);
        chartSet.setAttributeNode(chartType);
        chartSet.setAttributeNode(fieldNames);
        chartSet.setAttributeNode(xShift);
        chartSet.setAttributeNode(yShift);
        chartSet.setAttributeNode(maxSize);
        chartSet.setAttributeNode(minSize);
        chartSet.setAttributeNode(maxValue);
        chartSet.setAttributeNode(minValue);
        chartSet.setAttributeNode(barWidth);
        chartSet.setAttributeNode(avoidCollision);
        chartSet.setAttributeNode(alignType);
        chartSet.setAttributeNode(view3D);
        chartSet.setAttributeNode(thickness);
        chartSet.setAttributeNode(drawLabel);
        chartSet.setAttributeNode(fontName);
        chartSet.setAttributeNode(fontSize);
        chartSet.setAttributeNode(labelColor);
        aChartSet.getLegendScheme().exportToXML(m_Doc, chartSet);
        parent.appendChild(chartSet);
    }

    private void exportChartGraphics(org.w3c.dom.Document m_Doc, Element parent, List<ChartGraphic> graphicList) {
        Element graphics = m_Doc.createElement("ChartGraphics");
        for (Graphic graphic : graphicList) {
            graphic.exportToXML(m_Doc, graphics);
        }
        parent.appendChild(graphics);
    }

    public void exportGraphics(org.w3c.dom.Document m_Doc, Element parent, List<Graphic> graphicList) {
        Element graphics = m_Doc.createElement("Graphics");
        for (Graphic aGraphic : graphicList) {
            aGraphic.exportToXML(m_Doc, graphics);
        }
        parent.appendChild(graphics);
    }

    private void exportVisibleScale(org.w3c.dom.Document m_Doc, Element parent, VisibleScale visibleScale) {
        Element visibleScaleElem = m_Doc.createElement("VisibleScale");
        Attr enableMinVisScale = m_Doc.createAttribute("EnableMinVisScale");
        Attr enableMaxVisScale = m_Doc.createAttribute("EnableMaxVisScale");
        Attr minVisScale = m_Doc.createAttribute("MinVisScale");
        Attr maxVisScale = m_Doc.createAttribute("MaxVisScale");
        enableMinVisScale.setValue(String.valueOf(visibleScale.isEnableMinVisScale()));
        enableMaxVisScale.setValue(String.valueOf(visibleScale.isEnableMaxVisScale()));
        minVisScale.setValue(String.valueOf(visibleScale.getMinVisScale()));
        maxVisScale.setValue(String.valueOf(visibleScale.getMaxVisScale()));
        visibleScaleElem.setAttributeNode(enableMinVisScale);
        visibleScaleElem.setAttributeNode(enableMaxVisScale);
        visibleScaleElem.setAttributeNode(minVisScale);
        visibleScaleElem.setAttributeNode(maxVisScale);
        parent.appendChild(visibleScaleElem);
    }

    public void exportImageLayer(org.w3c.dom.Document m_Doc, Element parent, ImageLayer aILayer, String projectFilePath) {
        Element Layer = m_Doc.createElement("Layer");
        Attr Handle = m_Doc.createAttribute("Handle");
        Attr LayerName = m_Doc.createAttribute("LayerName");
        Attr FileName = m_Doc.createAttribute("FileName");
        Attr Visible = m_Doc.createAttribute("Visible");
        Attr IsMaskout = m_Doc.createAttribute("IsMaskout");
        Attr LayerType = m_Doc.createAttribute("LayerType");
        Attr LayerDrawType2 = m_Doc.createAttribute("LayerDrawType");
        Attr transparencyPerc = m_Doc.createAttribute("TransparencyPerc");
        Attr transparencyColor = m_Doc.createAttribute("TransparencyColor");
        Attr setTransColor = m_Doc.createAttribute("SetTransColor");
        Attr attrInterpolation = m_Doc.createAttribute("Interpolation");
        Handle.setValue(String.valueOf(aILayer.getHandle()));
        LayerName.setValue(aILayer.getLayerName());
        try {
            FileName.setValue(GlobalUtil.getRelativePath(aILayer.getFileName(), projectFilePath));
        }
        catch (IOException ex) {
            Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
        }
        Visible.setValue(String.valueOf(aILayer.isVisible()));
        IsMaskout.setValue(String.valueOf(aILayer.isMaskout()));
        LayerType.setValue(aILayer.getLayerType().toString());
        LayerDrawType2.setValue(aILayer.getLayerDrawType().toString());
        transparencyPerc.setValue(String.valueOf(aILayer.getTransparency()));
        transparencyColor.setValue(ColorUtil.toHexEncoding(aILayer.getTransparencyColor()));
        setTransColor.setValue(String.valueOf(aILayer.isUseTransColor()));
        attrInterpolation.setValue(aILayer.getInterpolationStr());
        Layer.setAttributeNode(Handle);
        Layer.setAttributeNode(LayerName);
        Layer.setAttributeNode(FileName);
        Layer.setAttributeNode(Visible);
        Layer.setAttributeNode(IsMaskout);
        Layer.setAttributeNode(LayerType);
        Layer.setAttributeNode(LayerDrawType2);
        Layer.setAttributeNode(transparencyPerc);
        Layer.setAttributeNode(transparencyColor);
        Layer.setAttributeNode(setTransColor);
        Layer.setAttributeNode(attrInterpolation);
        this.exportVisibleScale(m_Doc, Layer, aILayer.getVisibleScale());
        parent.appendChild(Layer);
    }

    public void exportRasterLayer(org.w3c.dom.Document m_Doc, Element parent, RasterLayer aILayer, String projectFilePath) {
        Element Layer = m_Doc.createElement("Layer");
        Attr Handle = m_Doc.createAttribute("Handle");
        Attr LayerName = m_Doc.createAttribute("LayerName");
        Attr FileName = m_Doc.createAttribute("FileName");
        Attr Visible = m_Doc.createAttribute("Visible");
        Attr IsMaskout = m_Doc.createAttribute("IsMaskout");
        Attr LayerType = m_Doc.createAttribute("LayerType");
        Attr LayerDrawType2 = m_Doc.createAttribute("LayerDrawType");
        Attr transparencyPerc = m_Doc.createAttribute("TransparencyPerc");
        Attr transparencyColor = m_Doc.createAttribute("TransparencyColor");
        Attr setTransColor = m_Doc.createAttribute("SetTransColor");
        Attr attrInterpolation = m_Doc.createAttribute("Interpolation");
        Handle.setValue(String.valueOf(aILayer.getHandle()));
        LayerName.setValue(aILayer.getLayerName());
        try {
            FileName.setValue(GlobalUtil.getRelativePath(aILayer.getFileName(), projectFilePath));
        }
        catch (IOException ex) {
            Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
        }
        Visible.setValue(String.valueOf(aILayer.isVisible()));
        IsMaskout.setValue(String.valueOf(aILayer.isMaskout()));
        LayerType.setValue(aILayer.getLayerType().toString());
        LayerDrawType2.setValue(aILayer.getLayerDrawType().toString());
        transparencyPerc.setValue(String.valueOf(aILayer.getTransparency()));
        transparencyColor.setValue(ColorUtil.toHexEncoding(aILayer.getTransparencyColor()));
        setTransColor.setValue(String.valueOf(aILayer.isUseTransColor()));
        attrInterpolation.setValue(aILayer.getInterpolationStr());
        Layer.setAttributeNode(Handle);
        Layer.setAttributeNode(LayerName);
        Layer.setAttributeNode(FileName);
        Layer.setAttributeNode(Visible);
        Layer.setAttributeNode(IsMaskout);
        Layer.setAttributeNode(LayerType);
        Layer.setAttributeNode(LayerDrawType2);
        Layer.setAttributeNode(transparencyPerc);
        Layer.setAttributeNode(transparencyColor);
        Layer.setAttributeNode(setTransColor);
        Layer.setAttributeNode(attrInterpolation);
        aILayer.getLegendScheme().exportToXML(m_Doc, Layer);
        this.exportVisibleScale(m_Doc, Layer, aILayer.getVisibleScale());
        parent.appendChild(Layer);
    }

    public void exportWebMapLayer(org.w3c.dom.Document m_Doc, Element parent, WebMapLayer wmLayer, String projectFilePath) {
        Element Layer = m_Doc.createElement("Layer");
        Attr Handle = m_Doc.createAttribute("Handle");
        Attr LayerName = m_Doc.createAttribute("LayerName");
        Attr webProvider = m_Doc.createAttribute("WebMapProvider");
        Attr Visible = m_Doc.createAttribute("Visible");
        Attr IsMaskout = m_Doc.createAttribute("IsMaskout");
        Attr LayerType = m_Doc.createAttribute("LayerType");
        Attr LayerDrawType2 = m_Doc.createAttribute("LayerDrawType");
        Attr transparencyPerc = m_Doc.createAttribute("TransparencyPerc");
        Handle.setValue(String.valueOf(wmLayer.getHandle()));
        LayerName.setValue(wmLayer.getLayerName());
        Visible.setValue(String.valueOf(wmLayer.isVisible()));
        webProvider.setValue(wmLayer.getWebMapProvider().toString());
        IsMaskout.setValue(String.valueOf(wmLayer.isMaskout()));
        LayerType.setValue(wmLayer.getLayerType().toString());
        LayerDrawType2.setValue(wmLayer.getLayerDrawType().toString());
        transparencyPerc.setValue(String.valueOf(wmLayer.getTransparency()));
        Layer.setAttributeNode(Handle);
        Layer.setAttributeNode(LayerName);
        Layer.setAttributeNode(Visible);
        Layer.setAttributeNode(webProvider);
        Layer.setAttributeNode(IsMaskout);
        Layer.setAttributeNode(LayerType);
        Layer.setAttributeNode(LayerDrawType2);
        Layer.setAttributeNode(transparencyPerc);
        parent.appendChild(Layer);
    }

    public void loadMapPropElement(Element parent) {
        Node mapProperty = parent.getElementsByTagName("MapProperty").item(0);
        try {
            Node hswz;
            Node selColor;
            Node mgd;
            Node scaleFactor;
            this.setBackground(ColorUtil.parseToColor(mapProperty.getAttributes().getNamedItem("BackColor").getNodeValue()));
            this.setForeground(ColorUtil.parseToColor(mapProperty.getAttributes().getNamedItem("ForeColor").getNodeValue()));
            this._antiAlias = Boolean.parseBoolean(mapProperty.getAttributes().getNamedItem("SmoothingMode").getNodeValue());
            Node paa = mapProperty.getAttributes().getNamedItem("PointSmoothingMode");
            if (paa != null) {
                this._pointAntiAlias = Boolean.parseBoolean(paa.getNodeValue());
            }
            if ((scaleFactor = mapProperty.getAttributes().getNamedItem("XYScaleFactor")) != null) {
                this._XYScaleFactor = Double.parseDouble(scaleFactor.getNodeValue());
            }
            if ((mgd = mapProperty.getAttributes().getNamedItem("MultiGlobalDraw")) != null) {
                this._multiGlobalDraw = Boolean.parseBoolean(mgd.getNodeValue());
            }
            if ((selColor = mapProperty.getAttributes().getNamedItem("SelectColor")) != null) {
                this._selectColor = ColorUtil.parseToColor(selColor.getNodeValue());
            }
            if ((hswz = mapProperty.getAttributes().getNamedItem("HighSpeedWheelZoom")) != null) {
                this._highSpeedWheelZoom = Boolean.parseBoolean(hswz.getNodeValue());
            }
        }
        catch (NumberFormatException | DOMException runtimeException) {
            // empty catch block
        }
    }

    public void loadGridLineElement(Element parent) {
        Node GridLine2 = parent.getElementsByTagName("GridLine").item(0);
        try {
            this._gridLineColor = ColorUtil.parseToColor(GridLine2.getAttributes().getNamedItem("GridLineColor").getNodeValue());
            this._gridLineSize = Integer.parseInt(GridLine2.getAttributes().getNamedItem("GridLineSize").getNodeValue());
            this._gridLineStyle = LineStyles.valueOf(GridLine2.getAttributes().getNamedItem("GridLineStyle").getNodeValue().toUpperCase());
            this._drawGridLine = Boolean.parseBoolean(GridLine2.getAttributes().getNamedItem("DrawGridLine").getNodeValue());
            this._drawGridTickLine = Boolean.parseBoolean(GridLine2.getAttributes().getNamedItem("DrawGridTickLine").getNodeValue());
        }
        catch (NumberFormatException | DOMException runtimeException) {
            // empty catch block
        }
    }

    public void loadMaskOutElement(Element parent) {
        Node MaskOut2 = parent.getElementsByTagName("MaskOut").item(0);
        try {
            this._maskOut.setMask(Boolean.parseBoolean(MaskOut2.getAttributes().getNamedItem("SetMaskLayer").getNodeValue()));
            this._maskOut.setMaskLayer(MaskOut2.getAttributes().getNamedItem("MaskLayer").getNodeValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void loadProjectionElement(Element parent) {
        Node Projection2 = parent.getElementsByTagName("Projection").item(0);
        try {
            this._projection.setProjStr(Projection2.getAttributes().getNamedItem("ProjStr").getNodeValue());
            if (this._projection.getProjInfo().getProjectionName() != ProjectionNames.LongLat) {
                ProjectionInfo toProj = ProjectionInfo.factory(this._projection.getProjStr());
                this.projectLayers(toProj);
            }
        }
        catch (NumberFormatException | DOMException runtimeException) {
            // empty catch block
        }
    }

    public void loadExtentsElement(Element parent) {
        Node Extents = parent.getElementsByTagName("Extents").item(0);
        Extent aExtent = new Extent();
        aExtent.minX = Double.parseDouble(Extents.getAttributes().getNamedItem("xMin").getNodeValue());
        aExtent.maxX = Double.parseDouble(Extents.getAttributes().getNamedItem("xMax").getNodeValue());
        aExtent.minY = Double.parseDouble(Extents.getAttributes().getNamedItem("yMin").getNodeValue());
        aExtent.maxY = Double.parseDouble(Extents.getAttributes().getNamedItem("yMax").getNodeValue());
        this.setViewExtent(aExtent);
    }

    public VectorLayer loadVectorLayer(String pPath, Node aVLayer) {
        String fn = aVLayer.getAttributes().getNamedItem("FileName").getNodeValue();
        File lFile = new File(fn);
        if (!lFile.isAbsolute()) {
            Path path = Paths.get(pPath, fn);
            fn = path.toString();
        } else {
            fn = lFile.getAbsolutePath();
        }
        System.out.println(fn);
        VectorLayer aLayer = null;
        if (new File(fn).isFile()) {
            NodeList visScaleNodes;
            try {
                aLayer = (VectorLayer)MapDataManage.loadLayer(fn);
            }
            catch (IOException ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (aLayer == null) {
                return aLayer;
            }
            try {
                aLayer.setHandle(Integer.parseInt(aVLayer.getAttributes().getNamedItem("Handle").getNodeValue()));
                aLayer.setLayerName(aVLayer.getAttributes().getNamedItem("LayerName").getNodeValue());
                aLayer.setVisible(Boolean.parseBoolean(aVLayer.getAttributes().getNamedItem("Visible").getNodeValue()));
                aLayer.setMaskout(Boolean.parseBoolean(aVLayer.getAttributes().getNamedItem("IsMaskout").getNodeValue()));
                aLayer.setTransparency(Integer.parseInt(aVLayer.getAttributes().getNamedItem("TransparencyPerc").getNodeValue()));
                aLayer.setAvoidCollision(Boolean.parseBoolean(aVLayer.getAttributes().getNamedItem("AvoidCollision").getNodeValue()));
                aLayer.setExpanded(Boolean.parseBoolean(aVLayer.getAttributes().getNamedItem("Expanded").getNodeValue()));
                aLayer.setLayerType(LayerTypes.valueOf(aVLayer.getAttributes().getNamedItem("LayerType").getNodeValue()));
                aLayer.setLayerDrawType(LayerDrawType.valueOf(aVLayer.getAttributes().getNamedItem("LayerDrawType").getNodeValue()));
            }
            catch (NumberFormatException | DOMException ex) {
                // empty catch block
            }
            Node LS = ((Element)aVLayer).getElementsByTagName("LegendScheme").item(0);
            LegendScheme ls = new LegendScheme(aLayer.getShapeType());
            ls.importFromXML(LS);
            aLayer.setLegendScheme(ls);
            Node labelNode = ((Element)aVLayer).getElementsByTagName("LabelSet").item(0);
            LabelSet aLabelSet = new LabelSet();
            this.loadLabelSet(labelNode, aLabelSet);
            aLayer.setLabelSet(aLabelSet);
            GraphicCollection gc = this.loadGraphicCollection((Element)aVLayer);
            aLayer.setLabelPoints(gc.getGraphics());
            NodeList chartNodes = ((Element)aVLayer).getElementsByTagName("ChartSet");
            if (chartNodes.getLength() > 0) {
                Node chartNode = chartNodes.item(0);
                ChartSet aChartSet = new ChartSet();
                this.loadChartSet(chartNode, aChartSet);
                aLayer.setChartSet(aChartSet);
                List<ChartGraphic> cgc = this.loadChartGraphicCollection((Element)aVLayer);
                aLayer.setChartPoints(cgc);
                aLayer.updateChartsProp();
            }
            if ((visScaleNodes = ((Element)aVLayer).getElementsByTagName("VisibleScale")).getLength() > 0) {
                Node visScaleNode = visScaleNodes.item(0);
                VisibleScale visScale = aLayer.getVisibleScale();
                this.loadVisibleScale(visScaleNode, visScale);
            }
        }
        return aLayer;
    }

    private void loadLabelSet(Node LabelNode, LabelSet aLabelSet) {
        try {
            aLabelSet.setDrawLabels(Boolean.parseBoolean(LabelNode.getAttributes().getNamedItem("DrawLabels").getNodeValue()));
            aLabelSet.setFieldName(LabelNode.getAttributes().getNamedItem("FieldName").getNodeValue());
            String fontName = LabelNode.getAttributes().getNamedItem("FontName").getNodeValue();
            float fontSize = Float.parseFloat(LabelNode.getAttributes().getNamedItem("FontSize").getNodeValue());
            aLabelSet.setLabelFont(new Font(fontName, 0, (int)fontSize));
            aLabelSet.setLabelColor(ColorUtil.parseToColor(LabelNode.getAttributes().getNamedItem("LabelColor").getNodeValue()));
            aLabelSet.setDrawShadow(Boolean.parseBoolean(LabelNode.getAttributes().getNamedItem("DrawShadow").getNodeValue()));
            aLabelSet.setShadowColor(ColorUtil.parseToColor(LabelNode.getAttributes().getNamedItem("ShadowColor").getNodeValue()));
            aLabelSet.setLabelAlignType(AlignType.valueOf(LabelNode.getAttributes().getNamedItem("AlignType").getNodeValue()));
            aLabelSet.setYOffset(Integer.parseInt(LabelNode.getAttributes().getNamedItem("Offset").getNodeValue()));
            aLabelSet.setAvoidCollision(Boolean.parseBoolean(LabelNode.getAttributes().getNamedItem("AvoidCollision").getNodeValue()));
            aLabelSet.setAutoDecimal(Boolean.parseBoolean(LabelNode.getAttributes().getNamedItem("AutoDecimal").getNodeValue()));
            aLabelSet.setDecimalDigits(Integer.parseInt(LabelNode.getAttributes().getNamedItem("DecimalDigits").getNodeValue()));
        }
        catch (NumberFormatException | DOMException runtimeException) {
            // empty catch block
        }
    }

    private void loadChartSet(Node chartNode, ChartSet aChartSet) {
        try {
            aChartSet.setDrawCharts(Boolean.parseBoolean(chartNode.getAttributes().getNamedItem("DrawCharts").getNodeValue()));
            aChartSet.setChartType(ChartTypes.valueOf(chartNode.getAttributes().getNamedItem("ChartType").getNodeValue()));
            aChartSet.setFieldNames(new ArrayList<String>(Arrays.asList(chartNode.getAttributes().getNamedItem("FieldNames").getNodeValue().split(","))));
            aChartSet.setXShift(Integer.parseInt(chartNode.getAttributes().getNamedItem("XShift").getNodeValue()));
            aChartSet.setYShift(Integer.parseInt(chartNode.getAttributes().getNamedItem("YShift").getNodeValue()));
            aChartSet.setMaxSize(Integer.parseInt(chartNode.getAttributes().getNamedItem("MaxSize").getNodeValue()));
            aChartSet.setMinSize(Integer.parseInt(chartNode.getAttributes().getNamedItem("MinSize").getNodeValue()));
            aChartSet.setMaxValue(Float.parseFloat(chartNode.getAttributes().getNamedItem("MaxValue").getNodeValue()));
            aChartSet.setMinValue(Float.parseFloat(chartNode.getAttributes().getNamedItem("MinValue").getNodeValue()));
            aChartSet.setBarWidth(Integer.parseInt(chartNode.getAttributes().getNamedItem("BarWidth").getNodeValue()));
            aChartSet.setAvoidCollision(Boolean.parseBoolean(chartNode.getAttributes().getNamedItem("AvoidCollision").getNodeValue()));
            aChartSet.setAlignType(AlignType.valueOf(chartNode.getAttributes().getNamedItem("AlignType").getNodeValue()));
            aChartSet.setView3D(Boolean.parseBoolean(chartNode.getAttributes().getNamedItem("View3D").getNodeValue()));
            aChartSet.setThickness(Integer.parseInt(chartNode.getAttributes().getNamedItem("Thickness").getNodeValue()));
            aChartSet.setDrawLabel(Boolean.parseBoolean(chartNode.getAttributes().getNamedItem("DrawLabel").getNodeValue()));
            String fontName = chartNode.getAttributes().getNamedItem("FontName").getNodeValue();
            float fontSize = Float.parseFloat(chartNode.getAttributes().getNamedItem("FontSize").getNodeValue());
            aChartSet.setLabelFont(new Font(fontName, 0, (int)fontSize));
            aChartSet.setLabelColor(ColorUtil.parseToColor(chartNode.getAttributes().getNamedItem("LabelColor").getNodeValue()));
        }
        catch (Exception fontName) {
            // empty catch block
        }
        Node lsNode = ((Element)chartNode).getElementsByTagName("LegendScheme").item(0);
        aChartSet.getLegendScheme().importFromXML(lsNode);
    }

    private void loadVisibleScale(Node visScaleNode, VisibleScale visibleScale) {
        try {
            visibleScale.setEnableMinVisScale(Boolean.parseBoolean(visScaleNode.getAttributes().getNamedItem("EnableMinVisScale").getNodeValue()));
            visibleScale.setEnableMaxVisScale(Boolean.parseBoolean(visScaleNode.getAttributes().getNamedItem("EnableMaxVisScale").getNodeValue()));
            visibleScale.setMinVisScale(Double.parseDouble(visScaleNode.getAttributes().getNamedItem("MinVisScale").getNodeValue()));
            visibleScale.setMaxVisScale(Double.parseDouble(visScaleNode.getAttributes().getNamedItem("MaxVisScale").getNodeValue()));
        }
        catch (NumberFormatException | DOMException runtimeException) {
            // empty catch block
        }
    }

    public ImageLayer loadImageLayer(Node aILayer) {
        String aFile = aILayer.getAttributes().getNamedItem("FileName").getNodeValue();
        File lFile = new File(aFile);
        String curDir = System.getProperty("user.dir");
        if (new File(curDir).isFile()) {
            System.setProperty("user.dir", new File(curDir).getParent());
        }
        aFile = lFile.getAbsolutePath();
        ImageLayer aLayer = null;
        if (new File(aFile).exists()) {
            try {
                aLayer = MapDataManage.readImageFile(aFile);
            }
            catch (IOException ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                NodeList visScaleNodes;
                aLayer.setHandle(Integer.parseInt(aILayer.getAttributes().getNamedItem("Handle").getNodeValue()));
                aLayer.setLayerName(aILayer.getAttributes().getNamedItem("LayerName").getNodeValue());
                aLayer.setVisible(Boolean.parseBoolean(aILayer.getAttributes().getNamedItem("Visible").getNodeValue()));
                aLayer.setMaskout(Boolean.parseBoolean(aILayer.getAttributes().getNamedItem("IsMaskout").getNodeValue()));
                aLayer.setLayerType(LayerTypes.valueOf(aILayer.getAttributes().getNamedItem("LayerType").getNodeValue()));
                aLayer.setLayerDrawType(LayerDrawType.valueOf(aILayer.getAttributes().getNamedItem("LayerDrawType").getNodeValue()));
                aLayer.setTransparency(Integer.parseInt(aILayer.getAttributes().getNamedItem("TransparencyPerc").getNodeValue()));
                aLayer.setTransparencyColor(ColorUtil.parseToColor(aILayer.getAttributes().getNamedItem("TransparencyColor").getNodeValue()));
                aLayer.setUseTransColor(Boolean.parseBoolean(aILayer.getAttributes().getNamedItem("SetTransColor").getNodeValue()));
                Node attrInterp = aILayer.getAttributes().getNamedItem("Interpolation");
                if (attrInterp != null) {
                    aLayer.setInterpolation(attrInterp.getNodeValue());
                }
                if ((visScaleNodes = ((Element)aILayer).getElementsByTagName("VisibleScale")).getLength() > 0) {
                    Node visScaleNode = visScaleNodes.item(0);
                    VisibleScale visScale = aLayer.getVisibleScale();
                    this.loadVisibleScale(visScaleNode, visScale);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return aLayer;
    }

    public RasterLayer loadRasterLayer(Node aILayer) throws Exception {
        String aFile = aILayer.getAttributes().getNamedItem("FileName").getNodeValue();
        File lFile = new File(aFile);
        String curDir = System.getProperty("user.dir");
        if (new File(curDir).isFile()) {
            System.setProperty("user.dir", new File(curDir).getParent());
        }
        aFile = lFile.getAbsolutePath();
        RasterLayer aLayer = null;
        if (new File(aFile).exists()) {
            try {
                aLayer = (RasterLayer)MapDataManage.loadLayer(aFile);
            }
            catch (IOException ex) {
                Logger.getLogger(MapView.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                aLayer.setHandle(Integer.parseInt(aILayer.getAttributes().getNamedItem("Handle").getNodeValue()));
                aLayer.setLayerName(aILayer.getAttributes().getNamedItem("LayerName").getNodeValue());
                aLayer.setVisible(Boolean.parseBoolean(aILayer.getAttributes().getNamedItem("Visible").getNodeValue()));
                aLayer.setMaskout(Boolean.parseBoolean(aILayer.getAttributes().getNamedItem("IsMaskout").getNodeValue()));
                aLayer.setLayerType(LayerTypes.valueOf(aILayer.getAttributes().getNamedItem("LayerType").getNodeValue()));
                aLayer.setLayerDrawType(LayerDrawType.valueOf(aILayer.getAttributes().getNamedItem("LayerDrawType").getNodeValue()));
                aLayer.setTransparency(Integer.parseInt(aILayer.getAttributes().getNamedItem("TransparencyPerc").getNodeValue()));
                aLayer.setTransparencyColor(ColorUtil.parseToColor(aILayer.getAttributes().getNamedItem("TransparencyColor").getNodeValue()));
                aLayer.setUseTransColor(Boolean.parseBoolean(aILayer.getAttributes().getNamedItem("SetTransColor").getNodeValue()));
                Node attrInterp = aILayer.getAttributes().getNamedItem("Interpolation");
                if (attrInterp != null) {
                    aLayer.setInterpolation(attrInterp.getNodeValue());
                }
                Node LS = ((Element)aILayer).getElementsByTagName("LegendScheme").item(0);
                LegendScheme ls = new LegendScheme(aLayer.getShapeType());
                ls.importFromXML(LS);
                aLayer.setLegendScheme(ls);
                NodeList visScaleNodes = ((Element)aILayer).getElementsByTagName("VisibleScale");
                if (visScaleNodes.getLength() > 0) {
                    Node visScaleNode = visScaleNodes.item(0);
                    VisibleScale visScale = aLayer.getVisibleScale();
                    this.loadVisibleScale(visScaleNode, visScale);
                }
            }
            catch (NumberFormatException | DOMException runtimeException) {
                // empty catch block
            }
        }
        return aLayer;
    }

    public WebMapLayer loadWebMapLayer(Node wmLayer) throws Exception {
        WebMapLayer aLayer = new WebMapLayer();
        try {
            aLayer.setHandle(Integer.parseInt(wmLayer.getAttributes().getNamedItem("Handle").getNodeValue()));
            aLayer.setLayerName(wmLayer.getAttributes().getNamedItem("LayerName").getNodeValue());
            aLayer.setVisible(Boolean.parseBoolean(wmLayer.getAttributes().getNamedItem("Visible").getNodeValue()));
            aLayer.setWebMapProvider(WebMapProvider.valueOf(wmLayer.getAttributes().getNamedItem("WebMapProvider").getNodeValue()));
            aLayer.setMaskout(Boolean.parseBoolean(wmLayer.getAttributes().getNamedItem("IsMaskout").getNodeValue()));
            aLayer.setLayerType(LayerTypes.valueOf(wmLayer.getAttributes().getNamedItem("LayerType").getNodeValue()));
            aLayer.setLayerDrawType(LayerDrawType.valueOf(wmLayer.getAttributes().getNamedItem("LayerDrawType").getNodeValue()));
            aLayer.setTransparency(Integer.parseInt(wmLayer.getAttributes().getNamedItem("TransparencyPerc").getNodeValue()));
        }
        catch (NumberFormatException | DOMException runtimeException) {
            // empty catch block
        }
        return aLayer;
    }

    public void loadGraphics(Element parent) {
        this._graphicCollection = this.loadGraphicCollection(parent);
    }

    private List<ChartGraphic> loadChartGraphicCollection(Element parent) {
        ArrayList<ChartGraphic> gc = new ArrayList<ChartGraphic>();
        Element graphics = (Element)parent.getElementsByTagName("ChartGraphics").item(0);
        if (graphics != null) {
            NodeList nList = graphics.getElementsByTagName("Graphic");
            for (int i = 0; i < nList.getLength(); ++i) {
                Node graphicNode = nList.item(i);
                ChartGraphic aGraphic = new ChartGraphic();
                aGraphic.importFromXML((Element)graphicNode);
                gc.add(aGraphic);
            }
        }
        return gc;
    }

    private GraphicCollection loadGraphicCollection(Element parent) {
        GraphicCollection gc = new GraphicCollection();
        Node graphics = null;
        for (int i = 0; i < parent.getChildNodes().getLength(); ++i) {
            Node aNode = parent.getChildNodes().item(i);
            if (!"Graphics".equals(aNode.getNodeName())) continue;
            graphics = aNode;
            break;
        }
        if (graphics != null) {
            NodeList nList = ((Element)graphics).getElementsByTagName("Graphic");
            for (int i = 0; i < nList.getLength(); ++i) {
                Node graphicNode = nList.item(i);
                Graphic aGraphic = new Graphic();
                aGraphic.importFromXML((Element)graphicNode);
                gc.add(aGraphic);
            }
        }
        return gc;
    }

    public void projectLayers(ProjectionInfo toProj) {
        this._projection.projectLayers(this, toProj);
        this.fireProjectionChangedEvent();
    }

    public void showMeasurementForm() {
        if (this._frmMeasure == null) {
            this._frmMeasure = new FrmMeasurement((Frame)((JFrame)SwingUtilities.getWindowAncestor(this)), false);
            this._frmMeasure.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    MapView.this.repaintOld();
                    MapView.this.setDrawIdentiferShape(false);
                }
            });
            this._frmMeasure.setLocationRelativeTo(this);
            this._frmMeasure.setVisible(true);
        } else if (!this._frmMeasure.isVisible()) {
            this._frmMeasure.setVisible(true);
        }
    }
}

