/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.locationtech.proj4j.CRSFactory;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.global.event.IProjectionChangedListener;
import org.meteoinfo.global.event.ProjectionChangedEvent;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.RasterLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.map.MapView;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionUtil;
import org.meteoinfo.projection.Reproject;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.shape.CircleShape;
import org.meteoinfo.shape.CurveLineShape;
import org.meteoinfo.shape.CurvePolygonShape;
import org.meteoinfo.shape.EllipseShape;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.GraphicCollection;
import org.meteoinfo.shape.PointShape;
import org.meteoinfo.shape.Polygon;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.Polyline;
import org.meteoinfo.shape.PolylineShape;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.StationModelShape;
import org.meteoinfo.shape.WindArrow;
import org.meteoinfo.shape.WindBarb;

public class ProjectionSet {
    private final EventListenerList _listeners = new EventListenerList();
    CRSFactory _crsFactory = new CRSFactory();
    private ProjectionInfo _projInfo;

    public ProjectionSet() {
        this._projInfo = KnownCoordinateSystems.geographic.world.WGS1984;
    }

    public void addProjectionChangedListener(IProjectionChangedListener listener) {
        this._listeners.add(IProjectionChangedListener.class, listener);
    }

    public void removeViewExtentChangedListener(IProjectionChangedListener listener) {
        this._listeners.remove(IProjectionChangedListener.class, listener);
    }

    public void fireProjectionChangedEvent() {
        this.fireProjectionChangedEvent(new ProjectionChangedEvent(this));
    }

    private void fireProjectionChangedEvent(ProjectionChangedEvent event) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != IProjectionChangedListener.class) continue;
            ((IProjectionChangedListener)listeners[i + 1]).projectionChangedEvent(event);
        }
    }

    public boolean isLonLatMap() {
        return "longlat".equals(this._projInfo.getCoordinateReferenceSystem().getProjection().toString().toLowerCase());
    }

    public ProjectionInfo getProjInfo() {
        return this._projInfo;
    }

    public void setProjInfo(ProjectionInfo projInfo) {
        this._projInfo = projInfo;
    }

    public String getProjStr() {
        return this._projInfo.toProj4String();
    }

    public void setProjStr(String projStr) {
        this._projInfo = ProjectionInfo.factory(projStr);
    }

    public Extent getProjectedExtentFromLonLat(Extent sExtent) {
        Extent aExtent = new Extent();
        ProjectionInfo fromProj = KnownCoordinateSystems.geographic.world.WGS1984;
        ProjectionInfo toProj = this._projInfo;
        double[][] points = new double[][]{{sExtent.minX, sExtent.minY}, {sExtent.minX, sExtent.maxY}, {sExtent.maxX, sExtent.maxY}, {sExtent.maxX, sExtent.minY}};
        Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
        aExtent.minX = Math.min(points[0][0], points[1][0]);
        aExtent.minY = Math.min(points[0][1], points[3][1]);
        aExtent.maxX = Math.max(points[2][0], points[3][0]);
        aExtent.maxY = Math.max(points[1][1], points[2][1]);
        return aExtent;
    }

    public void projectLayers(MapView aMapView, ProjectionInfo toProj) {
        this.projectLayers(aMapView, toProj, true);
    }

    public void projectLayers(MapView aMapView, ProjectionInfo toProj, boolean isUpdateView) {
        if (aMapView.getProjection().getProjInfo().toProj4String().equals(toProj.toProj4String())) {
            return;
        }
        aMapView.setLockViewUpdate(true);
        ProjectionInfo fromProj = aMapView.getProjection().getProjInfo();
        aMapView.getProjection().setProjInfo(toProj);
        double refLon = toProj.getRefCutLon();
        block4: for (int i = 0; i < aMapView.getLayers().size(); ++i) {
            switch (((MapLayer)aMapView.getLayers().get(i)).getLayerType()) {
                case VectorLayer: {
                    VectorLayer oLayer = (VectorLayer)aMapView.getLayers().get(i);
                    ProjectionUtil.projectLayer(oLayer, toProj);
                    continue block4;
                }
                case RasterLayer: {
                    RasterLayer oRLayer = (RasterLayer)aMapView.getLayers().get(i);
                    ProjectionUtil.projectLayer(oRLayer, toProj);
                }
            }
        }
        if (aMapView.getGraphicCollection().size() > 0) {
            GraphicCollection newGCollection = this.projectGraphics(aMapView.getGraphicCollection(), fromProj, toProj);
            aMapView.setGraphicCollection(newGCollection);
        }
        aMapView.setExtent(aMapView.getLayersWholeExtent());
        Extent aExten = aMapView.getExtent();
        aMapView.setLonLatLayer(aMapView.generateLonLatLayer());
        ProjectionUtil.projectLayer(aMapView.getLonLatLayer(), toProj);
        for (int i = 0; i < aMapView.getLonLatLayer().getShapeNum(); ++i) {
            PolylineShape aPLS = (PolylineShape)aMapView.getLonLatLayer().getShapes().get(i);
            if (aPLS.getPolylines().size() != 2) continue;
            PointD aP = aPLS.getPolylines().get(0).getPointList().get(aPLS.getPolylines().get(0).getPointList().size() - 1);
            PointD bP = aPLS.getPolylines().get(1).getPointList().get(aPLS.getPolylines().get(1).getPointList().size() - 1);
            boolean isJoin = false;
            if (refLon == 0.0) {
                if (Math.abs(aP.X) < 0.1 && Math.abs(bP.X) < 0.1 && MIMath.doubleEquals(aP.Y, bP.Y)) {
                    isJoin = true;
                }
            } else if (MIMath.doubleEquals(aP.X, bP.X) && MIMath.doubleEquals(aP.Y, bP.Y)) {
                isJoin = true;
            }
            if (!isJoin) continue;
            ArrayList<Polyline> polyLines = new ArrayList<Polyline>();
            Polyline aPL = new Polyline();
            ArrayList<? extends PointD> pList = new ArrayList<PointD>(aPLS.getPolylines().get(1).getPointList());
            ArrayList<? extends PointD> bPList = new ArrayList<PointD>(aPLS.getPolylines().get(0).getPointList());
            Collections.reverse(bPList);
            pList.addAll(bPList);
            aPL.setPointList(pList);
            polyLines.add(aPL);
            aPLS.setPolylines(polyLines);
        }
        if (isUpdateView) {
            aMapView.setLockViewUpdate(false);
        }
        aMapView.zoomToExtent(aExten);
        this.fireProjectionChangedEvent();
    }

    private PointShape projectPointShape(PointShape aPS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        PointShape newPS = (PointShape)aPS.clone();
        double[][] points = new double[][]{{newPS.getPoint().X, newPS.getPoint().Y}};
        double[] fromP = new double[]{newPS.getPoint().X, newPS.getPoint().Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (!Double.isNaN(points[0][0]) && !Double.isNaN(points[0][1])) {
                double[] toP = points[0];
                newPS.setPoint(new PointD(points[0][0], points[0][1]));
                switch (aPS.getShapeType()) {
                    case WindBarb: {
                        ((WindBarb)newPS).angle = this.projectAngle(((WindBarb)newPS).angle, fromP, toP, fromProj, toProj);
                        break;
                    }
                    case WindArraw: {
                        ((WindArrow)newPS).angle = this.projectAngle(((WindArrow)newPS).angle, fromP, toP, fromProj, toProj);
                        break;
                    }
                    case StationModel: {
                        ((StationModelShape)newPS).windBarb.angle = this.projectAngle(((StationModelShape)newPS).windBarb.angle, fromP, toP, fromProj, toProj);
                    }
                }
                return newPS;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private PolylineShape projectPolylineShape(PolylineShape aPLS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Polyline> polyLines = new ArrayList<Polyline>();
        for (int i = 0; i < aPLS.getPolylines().size(); ++i) {
            ArrayList<PointD> newPoints = new ArrayList<PointD>();
            Polyline aPL = aPLS.getPolylines().get(i);
            for (int j = 0; j < aPL.getPointList().size(); ++j) {
                double[][] points = new double[1][];
                PointD wPoint = aPL.getPointList().get(j);
                double x = wPoint.X;
                if (fromProj.isLonLat()) {
                    if (x > 180.0) {
                        x -= 360.0;
                    } else if (x < -180.0) {
                        x += 360.0;
                    }
                }
                points[0] = new double[]{x, wPoint.Y};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                    if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) continue;
                    wPoint.X = points[0][0];
                    wPoint.Y = points[0][1];
                    newPoints.add(wPoint);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (newPoints.size() <= 1) continue;
            Polyline bPL = new Polyline();
            bPL.setPointList(newPoints);
            polyLines.add(bPL);
        }
        if (polyLines.size() > 0) {
            aPLS.setPolylines(polyLines);
            return aPLS;
        }
        return null;
    }

    private CurveLineShape projectCurvelineShape(CurveLineShape aPLS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Polyline> polyLines = new ArrayList<Polyline>();
        for (int i = 0; i < aPLS.getPolylines().size(); ++i) {
            ArrayList<PointD> newPoints = new ArrayList<PointD>();
            Polyline aPL = aPLS.getPolylines().get(i);
            for (int j = 0; j < aPL.getPointList().size(); ++j) {
                double[][] points = new double[1][];
                PointD wPoint = aPL.getPointList().get(j);
                points[0] = new double[]{wPoint.X, wPoint.Y};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                    if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) continue;
                    wPoint = new PointD();
                    wPoint.X = points[0][0];
                    wPoint.Y = points[0][1];
                    newPoints.add(wPoint);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            if (newPoints.size() <= 1) continue;
            Polyline bPL = new Polyline();
            bPL.setPointList(newPoints);
            polyLines.add(bPL);
        }
        if (polyLines.size() > 0) {
            aPLS.setPolylines(polyLines);
            return aPLS;
        }
        return null;
    }

    public PolygonShape projectPolygonShape(PolygonShape aPGS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < aPGS.getPolygons().size(); ++i) {
            Polygon aPG = aPGS.getPolygons().get(i);
            Polygon bPG = null;
            for (int r = 0; r < aPG.getRingNumber(); ++r) {
                List<? extends PointD> pList = aPG.getRings().get(r);
                ArrayList<PointD> newPoints = new ArrayList<PointD>();
                for (int j = 0; j < pList.size(); ++j) {
                    double[][] points = new double[1][];
                    PointD wPoint = pList.get(j);
                    points[0] = new double[]{wPoint.X, wPoint.Y};
                    try {
                        Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                        if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) continue;
                        wPoint = new PointD();
                        wPoint.X = points[0][0];
                        wPoint.Y = points[0][1];
                        newPoints.add(wPoint);
                        continue;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                if (r == 0) {
                    if (newPoints.size() <= 2) break;
                    bPG = new Polygon();
                    bPG.setOutLine(newPoints);
                    continue;
                }
                if (newPoints.size() <= 2 || bPG == null) continue;
                bPG.addHole(newPoints);
            }
            if (bPG == null) continue;
            polygons.add(bPG);
        }
        if (polygons.size() > 0) {
            aPGS.setPolygons(polygons);
            return aPGS;
        }
        return null;
    }

    private CurvePolygonShape projectCurvePolygonShape(CurvePolygonShape aPGS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < aPGS.getPolygons().size(); ++i) {
            Polygon aPG = aPGS.getPolygons().get(i);
            Polygon bPG = null;
            for (int r = 0; r < aPG.getRingNumber(); ++r) {
                List<? extends PointD> pList = aPG.getRings().get(r);
                ArrayList<PointD> newPoints = new ArrayList<PointD>();
                for (int j = 0; j < pList.size(); ++j) {
                    double[][] points = new double[1][];
                    PointD wPoint = pList.get(j);
                    points[0] = new double[]{wPoint.X, wPoint.Y};
                    try {
                        Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                        if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) continue;
                        wPoint = new PointD();
                        wPoint.X = points[0][0];
                        wPoint.Y = points[0][1];
                        newPoints.add(wPoint);
                        continue;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                if (r == 0) {
                    if (newPoints.size() <= 2) break;
                    bPG = new Polygon();
                    bPG.setOutLine(newPoints);
                    continue;
                }
                if (newPoints.size() <= 2 || bPG == null) continue;
                bPG.addHole(newPoints);
            }
            if (bPG == null) continue;
            polygons.add(bPG);
        }
        if (polygons.size() > 0) {
            aPGS.setPolygons(polygons);
            return aPGS;
        }
        return null;
    }

    private CircleShape projectCircleShape(CircleShape aCS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        double radius = Math.abs(aCS.getPoints().get((int)1).X - aCS.getPoints().get((int)0).X);
        double[][] points = new double[1][];
        PointD centerPoint = new PointD(aCS.getPoints().get((int)0).X + radius, aCS.getPoints().get((int)0).Y);
        points[0] = new double[]{centerPoint.X, centerPoint.Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) {
                return null;
            }
            centerPoint.X = points[0][0];
            centerPoint.Y = points[0][1];
        }
        catch (Exception e) {
            return null;
        }
        points = new double[1][];
        PointD leftPoint = aCS.getPoints().get(0);
        points[0] = new double[]{leftPoint.X, leftPoint.Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) {
                return null;
            }
            leftPoint.X = points[0][0];
            leftPoint.Y = points[0][1];
        }
        catch (Exception e) {
            return null;
        }
        radius = Math.abs(centerPoint.X - leftPoint.X);
        ArrayList<PointD> newPoints = new ArrayList<PointD>();
        newPoints.add(new PointD(centerPoint.X - radius, centerPoint.Y));
        newPoints.add(new PointD(centerPoint.X, centerPoint.Y - radius));
        newPoints.add(new PointD(centerPoint.X + radius, centerPoint.Y));
        newPoints.add(new PointD(centerPoint.X, centerPoint.Y + radius));
        CircleShape newCS = new CircleShape();
        newCS.setPoints(newPoints);
        return newCS;
    }

    private EllipseShape projectEllipseShape(EllipseShape aES, ProjectionInfo fromProj, ProjectionInfo toProj) {
        double xRadius = Math.abs(aES.getPoints().get((int)2).X - aES.getPoints().get((int)0).X) / 2.0;
        double yRadius = Math.abs(aES.getPoints().get((int)2).Y - aES.getPoints().get((int)0).Y) / 2.0;
        double[][] points = new double[1][];
        PointD centerPoint = new PointD(aES.getExtent().minX + xRadius, aES.getExtent().minY + yRadius);
        points[0] = new double[]{centerPoint.X, centerPoint.Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) {
                return null;
            }
            centerPoint.X = points[0][0];
            centerPoint.Y = points[0][1];
        }
        catch (Exception e) {
            return null;
        }
        points = new double[1][];
        PointD lbPoint = new PointD(aES.getExtent().minX, aES.getExtent().minY);
        points[0] = new double[]{lbPoint.X, lbPoint.Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) {
                return null;
            }
            lbPoint.X = points[0][0];
            lbPoint.Y = points[0][1];
        }
        catch (Exception e) {
            return null;
        }
        xRadius = Math.abs(centerPoint.X - lbPoint.X);
        yRadius = Math.abs(centerPoint.Y - lbPoint.Y);
        ArrayList<PointD> newPoints = new ArrayList<PointD>();
        newPoints.add(new PointD(centerPoint.X - xRadius, centerPoint.Y - yRadius));
        newPoints.add(new PointD(centerPoint.X - xRadius, centerPoint.Y + yRadius));
        newPoints.add(new PointD(centerPoint.X + xRadius, centerPoint.Y + yRadius));
        newPoints.add(new PointD(centerPoint.X + xRadius, centerPoint.Y - yRadius));
        EllipseShape newES = new EllipseShape();
        newES.setPoints(newPoints);
        return newES;
    }

    public double projectAngle(double oAngle, double[] fromP1, double[] toP1, ProjectionInfo fromProj, ProjectionInfo toProj) {
        double pAngle = oAngle;
        double[][] points = new double[1][];
        if (fromP1[1] == 90.0) {
            double[] fromP2 = new double[]{fromP1[0], fromP1[1] - 10.0};
            points[0] = (double[])fromP2.clone();
            try {
                Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                double[] toP2 = points[0];
                double x = toP2[0] - toP1[0];
                double y = toP2[1] - toP1[1];
                double aLen = Math.sqrt(x * x + y * y);
                double angle = Math.asin(x / aLen) * 180.0 / Math.PI;
                if (x < 0.0 && y < 0.0) {
                    angle = 180.0 - angle;
                } else if (x > 0.0 && y < 0.0) {
                    angle = 180.0 - angle;
                } else if (x < 0.0 && y > 0.0) {
                    angle = 360.0 + angle;
                }
                if (aLen == 0.0) {
                    System.out.print("Error");
                }
                if ((pAngle = oAngle + (angle - 180.0)) > 360.0) {
                    pAngle -= 360.0;
                } else if (pAngle < 0.0) {
                    pAngle += 360.0;
                }
            }
            catch (Exception x) {}
        } else {
            double[] fromP2 = new double[]{fromP1[0] + 10.0, fromP1[1]};
            points[0] = (double[])fromP2.clone();
            try {
                Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                double[] toP2 = points[0];
                double x = toP2[0] - toP1[0];
                double y = toP2[1] - toP1[1];
                double aLen = Math.sqrt(x * x + y * y);
                if (aLen == 0.0) {
                    return pAngle;
                }
                double angle = Math.asin(x / aLen) * 180.0 / Math.PI;
                if (Double.isNaN(angle)) {
                    return pAngle;
                }
                if (x < 0.0 && y < 0.0) {
                    angle = 180.0 - angle;
                } else if (x > 0.0 && y < 0.0) {
                    angle = 180.0 - angle;
                } else if (x < 0.0 && y > 0.0) {
                    angle = 360.0 + angle;
                }
                pAngle = oAngle + (angle - 90.0);
                if (pAngle > 360.0) {
                    pAngle -= 360.0;
                } else if (pAngle < 0.0) {
                    pAngle += 360.0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pAngle;
    }

    private GraphicCollection projectGraphics(GraphicCollection aGCollection, ProjectionInfo fromProj, ProjectionInfo toProj) {
        GraphicCollection newGCollection = new GraphicCollection();
        for (Graphic aGraphic : aGCollection.getGraphics()) {
            aGraphic.setShape(this.projectShape(aGraphic.getShape(), fromProj, toProj));
            if (aGraphic.getShape() == null) continue;
            newGCollection.add(aGraphic);
        }
        return newGCollection;
    }

    private List<Graphic> projectGraphics(List<Graphic> graphics, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Graphic> newGraphics = new ArrayList<Graphic>();
        for (Graphic aGraphic : graphics) {
            Shape aShape = this.projectShape(aGraphic.getShape(), fromProj, toProj);
            if (aShape == null) continue;
            newGraphics.add(new Graphic(aShape, aGraphic.getLegend()));
        }
        return newGraphics;
    }

    private Shape projectShape(Shape aShape, ProjectionInfo fromProj, ProjectionInfo toProj) {
        Shape newShape;
        switch (aShape.getShapeType()) {
            case Point: 
            case PointM: {
                newShape = this.projectPointShape((PointShape)aShape, fromProj, toProj);
                break;
            }
            case Polyline: 
            case PolylineM: {
                newShape = this.projectPolylineShape((PolylineShape)aShape, fromProj, toProj);
                break;
            }
            case CurveLine: {
                newShape = this.projectCurvelineShape((CurveLineShape)aShape, fromProj, toProj);
                break;
            }
            case Polygon: 
            case PolygonM: 
            case Rectangle: {
                newShape = this.projectPolygonShape((PolygonShape)aShape, fromProj, toProj);
                break;
            }
            case CurvePolygon: {
                newShape = this.projectCurvePolygonShape((CurvePolygonShape)aShape, fromProj, toProj);
                break;
            }
            case Circle: {
                newShape = this.projectCircleShape((CircleShape)aShape, fromProj, toProj);
                break;
            }
            case Ellipse: {
                newShape = this.projectEllipseShape((EllipseShape)aShape, fromProj, toProj);
                break;
            }
            default: {
                newShape = null;
            }
        }
        return newShape;
    }
}

