/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.interpolate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.math3.analysis.BivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.interpolation.AkimaSplineInterpolator;
import org.apache.commons.math3.analysis.interpolation.BicubicInterpolator;
import org.apache.commons.math3.analysis.interpolation.DividedDifferenceInterpolator;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.interpolation.LoessInterpolator;
import org.apache.commons.math3.analysis.interpolation.NevilleInterpolator;
import org.apache.commons.math3.analysis.interpolation.SplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;
import org.meteoinfo.geoprocess.GeoComputation;
import org.meteoinfo.global.PointD;
import org.meteoinfo.math.ArrayUtil;
import org.meteoinfo.math.KDTree;
import org.meteoinfo.math.spatial.KDTree;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.shape.PolygonShape;

public class InterpUtil {
    public static PolynomialSplineFunction linearInterpFunc(Array x, Array y) {
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray_Double(x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray_Double(y);
        LinearInterpolator li = new LinearInterpolator();
        PolynomialSplineFunction psf = li.interpolate(xd, yd);
        return psf;
    }

    public static UnivariateFunction getInterpFunc(Array x, Array y, String kind) {
        SplineInterpolator li;
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray_Double(x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray_Double(y);
        switch (kind) {
            case "spline": 
            case "cubic": {
                li = new SplineInterpolator();
                break;
            }
            case "akima": {
                li = new AkimaSplineInterpolator();
                break;
            }
            case "divided": {
                li = new DividedDifferenceInterpolator();
                break;
            }
            case "loess": {
                li = new LoessInterpolator();
                break;
            }
            case "neville": {
                li = new NevilleInterpolator();
                break;
            }
            default: {
                li = new LinearInterpolator();
            }
        }
        UnivariateFunction psf = li.interpolate(xd, yd);
        return psf;
    }

    public static BivariateFunction getBiInterpFunc(Array x, Array y, Array z) {
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray_Double(x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray_Double(y);
        double[][] zd = (double[][])ArrayUtil.copyToNDJavaArray_Double(z);
        BicubicInterpolator li = new BicubicInterpolator();
        BivariateFunction func = li.interpolate(xd, yd, zd);
        return func;
    }

    public static Array evaluate(UnivariateFunction func, Array x) {
        Array r = Array.factory(DataType.DOUBLE, x.getShape());
        IndexIterator xIter = x.getIndexIterator();
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, func.value(xIter.getDoubleNext()));
            ++i;
        }
        return r;
    }

    public static double evaluate(UnivariateFunction func, Number x) {
        return func.value(x.doubleValue());
    }

    public static Array evaluate(BivariateFunction func, Array x, Array y) {
        Array r = Array.factory(DataType.DOUBLE, x.getShape());
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, func.value(xIter.getDoubleNext(), yIter.getDoubleNext()));
            ++i;
        }
        return r;
    }

    public static double evaluate(BivariateFunction func, Number x, Number y) {
        return func.value(x.doubleValue(), y.doubleValue());
    }

    public static Array cressman(List<Number> x_s, List<Number> y_s, Array v_s, List<Number> X, List<Number> Y, List<Number> radList) {
        double val;
        double sum;
        int j;
        double y;
        double x;
        int i;
        v_s = v_s.copyIfView();
        int xNum = X.size();
        int yNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{yNum, xNum});
        int irad = radList.size();
        double xMin = X.get(0).doubleValue();
        double yMin = Y.get(0).doubleValue();
        double xDelt = X.get(1).doubleValue() - X.get(0).doubleValue();
        double yDelt = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        double[][] stationData = new double[pNum][5];
        for (i = 0; i < pNum; ++i) {
            x = x_s.get(i).doubleValue();
            y = y_s.get(i).doubleValue();
            stationData[i][0] = x;
            stationData[i][1] = y;
            stationData[i][2] = v_s.getDouble(i);
            stationData[i][3] = (x - xMin) / xDelt;
            stationData[i][4] = (y - yMin) / yDelt;
        }
        KDTree.Euclidean<double[]> kdTree = new KDTree.Euclidean<double[]>(2);
        for (i = 0; i < pNum; ++i) {
            if (Double.isNaN(stationData[i][2])) continue;
            kdTree.addPoint(new double[]{stationData[i][0], stationData[i][1]}, stationData[i]);
        }
        double HITOP = -9.999E20;
        double HIBOT = 9.999E20;
        double[][] TOP = new double[yNum][xNum];
        double[][] BOT = new double[yNum][xNum];
        for (i = 0; i < yNum; ++i) {
            for (j = 0; j < xNum; ++j) {
                TOP[i][j] = HITOP;
                BOT[i][j] = HIBOT;
            }
        }
        double rad = radList.size() > 0 ? radList.get(0).doubleValue() : 4.0;
        for (i = 0; i < yNum; ++i) {
            y = Y.get(i).doubleValue();
            for (j = 0; j < xNum; ++j) {
                x = X.get(j).doubleValue();
                int stNum = 0;
                sum = 0.0;
                ArrayList neighbours = kdTree.ballSearch(new double[]{x, y}, rad * rad);
                for (double[] station : neighbours) {
                    val = station[2];
                    sum += val;
                    ++stNum;
                    if (TOP[i][j] < val) {
                        TOP[i][j] = val;
                    }
                    if (!(BOT[i][j] > val)) continue;
                    BOT[i][j] = val;
                }
                if (stNum == 0) {
                    r.setDouble(i * xNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * xNum + j, sum / (double)stNum);
            }
        }
        for (int p = 0; p < irad; ++p) {
            rad = radList.get(p).doubleValue();
            for (i = 0; i < yNum; ++i) {
                y = Y.get(i).doubleValue();
                for (j = 0; j < xNum; ++j) {
                    if (Double.isNaN(r.getDouble(i * xNum + j))) continue;
                    x = X.get(j).doubleValue();
                    sum = 0.0;
                    double wSum = 0.0;
                    ArrayList neighbours = kdTree.ballSearch(new double[]{x, y}, rad * rad);
                    for (double[] station : neighbours) {
                        double calVal;
                        val = station[2];
                        double sx = station[0];
                        double sy = station[1];
                        double sxi = station[3];
                        double syi = station[4];
                        if (sxi < 0.0 || sxi >= (double)(xNum - 1) || syi < 0.0 || syi >= (double)(yNum - 1)) continue;
                        double dis = Math.sqrt(Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0));
                        int i1 = (int)syi;
                        int j1 = (int)sxi;
                        int i2 = i1 + 1;
                        int j2 = j1 + 1;
                        double a = r.getDouble(i1 * xNum + j1);
                        double b = r.getDouble(i1 * xNum + j2);
                        double c = r.getDouble(i2 * xNum + j1);
                        double d = r.getDouble(i2 * xNum + j2);
                        ArrayList<Double> dList = new ArrayList<Double>();
                        if (!Double.isNaN(a)) {
                            dList.add(a);
                        }
                        if (!Double.isNaN(b)) {
                            dList.add(b);
                        }
                        if (!Double.isNaN(c)) {
                            dList.add(c);
                        }
                        if (Double.isNaN(d)) {
                            dList.add(d);
                        }
                        if (dList.isEmpty()) continue;
                        if (dList.size() == 1) {
                            calVal = (Double)dList.get(0);
                        } else if (dList.size() <= 3) {
                            double aSum = 0.0;
                            Iterator iterator = dList.iterator();
                            while (iterator.hasNext()) {
                                double dd = (Double)iterator.next();
                                aSum += dd;
                            }
                            calVal = aSum / (double)dList.size();
                        } else {
                            double x1val = a + (c - a) * (syi - (double)i1);
                            double x2val = b + (d - b) * (syi - (double)i1);
                            calVal = x1val + (x2val - x1val) * (sxi - (double)j1);
                        }
                        double eVal = val - calVal;
                        double w = (rad * rad - dis * dis) / (rad * rad + dis * dis);
                        sum += eVal * w;
                        wSum += w;
                    }
                    if (!(wSum >= 1.0E-6)) continue;
                    double aData = r.getDouble(i * xNum + j) + sum / wSum;
                    r.setDouble(i * xNum + j, Math.max(BOT[i][j], Math.min(TOP[i][j], aData)));
                }
            }
        }
        return r;
    }

    public static Array barnes(List<Number> x_s, List<Number> y_s, Array v_s, List<Number> X, List<Number> Y, List<Number> radList, double kappa, double gamma) {
        double w;
        double sy;
        double sx;
        double val;
        double wSum;
        double sum;
        int j;
        double y;
        double x;
        int i;
        v_s = v_s.copyIfView();
        int xNum = X.size();
        int yNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{yNum, xNum});
        int irad = radList.size();
        double xMin = X.get(0).doubleValue();
        double yMin = Y.get(0).doubleValue();
        double xDelt = X.get(1).doubleValue() - X.get(0).doubleValue();
        double yDelt = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        double[][] stationData = new double[pNum][5];
        for (i = 0; i < pNum; ++i) {
            x = x_s.get(i).doubleValue();
            y = y_s.get(i).doubleValue();
            stationData[i][0] = x;
            stationData[i][1] = y;
            stationData[i][2] = v_s.getDouble(i);
            stationData[i][3] = (x - xMin) / xDelt;
            stationData[i][4] = (y - yMin) / yDelt;
        }
        KDTree.Euclidean<double[]> kdTree = new KDTree.Euclidean<double[]>(2);
        for (i = 0; i < pNum; ++i) {
            if (Double.isNaN(stationData[i][2])) continue;
            kdTree.addPoint(new double[]{stationData[i][0], stationData[i][1]}, stationData[i]);
        }
        double HITOP = -9.999E20;
        double HIBOT = 9.999E20;
        double[][] TOP = new double[yNum][xNum];
        double[][] BOT = new double[yNum][xNum];
        for (i = 0; i < yNum; ++i) {
            for (j = 0; j < xNum; ++j) {
                TOP[i][j] = HITOP;
                BOT[i][j] = HIBOT;
            }
        }
        double rad = radList.size() > 0 ? radList.get(0).doubleValue() : 4.0;
        for (i = 0; i < yNum; ++i) {
            y = Y.get(i).doubleValue();
            for (j = 0; j < xNum; ++j) {
                x = X.get(j).doubleValue();
                int stNum = 0;
                sum = 0.0;
                wSum = 0.0;
                ArrayList neighbours = kdTree.ballSearch(new double[]{x, y}, rad * rad);
                for (double[] station : neighbours) {
                    val = station[2];
                    sx = station[0];
                    sy = station[1];
                    double dis = Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0);
                    w = Math.exp(-dis / (4.0 * kappa));
                    wSum += w;
                    sum += w * val;
                    ++stNum;
                    if (TOP[i][j] < val) {
                        TOP[i][j] = val;
                    }
                    if (!(BOT[i][j] > val)) continue;
                    BOT[i][j] = val;
                }
                if (stNum == 0) {
                    r.setDouble(i * xNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * xNum + j, sum / (double)stNum);
            }
        }
        for (int p = 0; p < irad; ++p) {
            rad = radList.get(p).doubleValue();
            for (i = 0; i < yNum; ++i) {
                y = Y.get(i).doubleValue();
                for (j = 0; j < xNum; ++j) {
                    if (Double.isNaN(r.getDouble(i * xNum + j))) continue;
                    x = X.get(j).doubleValue();
                    sum = 0.0;
                    wSum = 0.0;
                    ArrayList neighbours = kdTree.ballSearch(new double[]{x, y}, rad * rad);
                    for (double[] station : neighbours) {
                        double calVal;
                        val = station[2];
                        sx = station[0];
                        sy = station[1];
                        double sxi = station[3];
                        double syi = station[4];
                        if (sxi < 0.0 || sxi >= (double)(xNum - 1) || syi < 0.0 || syi >= (double)(yNum - 1)) continue;
                        double dis = Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0);
                        int i1 = (int)syi;
                        int j1 = (int)sxi;
                        int i2 = i1 + 1;
                        int j2 = j1 + 1;
                        double a = r.getDouble(i1 * xNum + j1);
                        double b = r.getDouble(i1 * xNum + j2);
                        double c = r.getDouble(i2 * xNum + j1);
                        double d = r.getDouble(i2 * xNum + j2);
                        ArrayList<Double> dList = new ArrayList<Double>();
                        if (!Double.isNaN(a)) {
                            dList.add(a);
                        }
                        if (!Double.isNaN(b)) {
                            dList.add(b);
                        }
                        if (!Double.isNaN(c)) {
                            dList.add(c);
                        }
                        if (Double.isNaN(d)) {
                            dList.add(d);
                        }
                        if (dList.isEmpty()) continue;
                        if (dList.size() == 1) {
                            calVal = (Double)dList.get(0);
                        } else if (dList.size() <= 3) {
                            double aSum = 0.0;
                            Iterator iterator = dList.iterator();
                            while (iterator.hasNext()) {
                                double dd = (Double)iterator.next();
                                aSum += dd;
                            }
                            calVal = aSum / (double)dList.size();
                        } else {
                            double x1val = a + (c - a) * (syi - (double)i1);
                            double x2val = b + (d - b) * (syi - (double)i1);
                            calVal = x1val + (x2val - x1val) * (sxi - (double)j1);
                        }
                        double eVal = val - calVal;
                        w = Math.exp(-dis / (4.0 * kappa * gamma));
                        sum += eVal * w;
                        wSum += w;
                    }
                    if (!(wSum >= 1.0E-6)) continue;
                    double aData = r.getDouble(i * xNum + j) + sum / wSum;
                    r.setDouble(i * xNum + j, Math.max(BOT[i][j], Math.min(TOP[i][j], aData)));
                }
            }
        }
        return r;
    }

    public static Array barnes(List<Number> x_s, List<Number> y_s, Array v_s, List<Number> X, List<Number> Y, double kappa, double gamma) {
        double w;
        double sy;
        double sx;
        double val;
        double wSum;
        double sum;
        int j;
        double y;
        double x;
        int i;
        v_s = v_s.copyIfView();
        int xNum = X.size();
        int yNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{yNum, xNum});
        double xMin = X.get(0).doubleValue();
        double xMax = X.get(xNum - 1).doubleValue();
        double yMin = Y.get(0).doubleValue();
        double yMax = Y.get(yNum - 1).doubleValue();
        double xDelt = X.get(1).doubleValue() - X.get(0).doubleValue();
        double yDelt = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        double[][] stationData = new double[pNum][5];
        for (i = 0; i < pNum; ++i) {
            x = x_s.get(i).doubleValue();
            y = y_s.get(i).doubleValue();
            stationData[i][0] = x;
            stationData[i][1] = y;
            stationData[i][2] = v_s.getDouble(i);
            stationData[i][3] = (x - xMin) / xDelt;
            stationData[i][4] = (y - yMin) / yDelt;
        }
        for (i = 0; i < yNum; ++i) {
            y = Y.get(i).doubleValue();
            for (j = 0; j < xNum; ++j) {
                x = X.get(j).doubleValue();
                sum = 0.0;
                wSum = 0.0;
                for (double[] station : stationData) {
                    val = station[2];
                    sx = station[0];
                    sy = station[1];
                    if (Double.isNaN(val) || sx < xMin || sx > xMax || sy < yMin || sy > yMax) continue;
                    double dis = Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0);
                    w = Math.exp(-dis / (4.0 * kappa));
                    wSum += w;
                    sum += w * val;
                }
                r.setDouble(i * xNum + j, sum / wSum);
            }
        }
        for (i = 0; i < yNum; ++i) {
            y = Y.get(i).doubleValue();
            for (j = 0; j < xNum; ++j) {
                x = X.get(j).doubleValue();
                sum = 0.0;
                wSum = 0.0;
                for (double[] station : stationData) {
                    double calVal;
                    val = station[2];
                    sx = station[0];
                    sy = station[1];
                    double sxi = station[3];
                    double syi = station[4];
                    if (Double.isNaN(val) || sx < xMin || sx > xMax || sy < yMin || sy > yMax) continue;
                    int i1 = (int)syi;
                    int j1 = (int)sxi;
                    int i2 = i1 + 1;
                    int j2 = j1 + 1;
                    double a = r.getDouble(i1 * xNum + j1);
                    double b = r.getDouble(i1 * xNum + j2);
                    double c = r.getDouble(i2 * xNum + j1);
                    double d = r.getDouble(i2 * xNum + j2);
                    ArrayList<Double> dList = new ArrayList<Double>();
                    if (!Double.isNaN(a)) {
                        dList.add(a);
                    }
                    if (!Double.isNaN(b)) {
                        dList.add(b);
                    }
                    if (!Double.isNaN(c)) {
                        dList.add(c);
                    }
                    if (Double.isNaN(d)) {
                        dList.add(d);
                    }
                    if (dList.isEmpty()) continue;
                    if (dList.size() == 1) {
                        calVal = (Double)dList.get(0);
                    } else if (dList.size() <= 3) {
                        double aSum = 0.0;
                        Iterator iterator = dList.iterator();
                        while (iterator.hasNext()) {
                            double dd = (Double)iterator.next();
                            aSum += dd;
                        }
                        calVal = aSum / (double)dList.size();
                    } else {
                        double x1val = a + (c - a) * (syi - (double)i1);
                        double x2val = b + (d - b) * (syi - (double)i1);
                        calVal = x1val + (x2val - x1val) * (sxi - (double)j1);
                    }
                    double eVal = val - calVal;
                    double dis = Math.pow(sx - x, 2.0) + Math.pow(sy - y, 2.0);
                    w = Math.exp(-dis / (4.0 * kappa * gamma));
                    wSum += w;
                    sum += w * eVal;
                }
                r.setDouble(i * xNum + j, r.getDouble(i * xNum + j) + sum / wSum);
            }
        }
        return r;
    }

    public static Array interpolation_Inside_Mean(Array x_s, Array y_s, Array a, Array X, Array Y, boolean centerPoint) {
        int j;
        int i;
        double ey;
        double ex;
        double sy;
        double sx;
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        a = a.copyIfView();
        X = X.copyIfView();
        Y = Y.copyIfView();
        int colNum = (int)X.getSize();
        int rowNum = (int)Y.getSize();
        int pNum = (int)x_s.getSize();
        Array r = Array.factory(DataType.DOUBLE, new int[]{rowNum, colNum});
        double dX = X.getDouble(1) - X.getDouble(0);
        double dY = Y.getDouble(1) - Y.getDouble(0);
        int[][] pNums = new int[rowNum][colNum];
        if (centerPoint) {
            sx = X.getDouble(0) - dX * 0.5;
            sy = Y.getDouble(0) - dY * 0.5;
            ex = X.getDouble(colNum - 1) + dX * 0.5;
            ey = Y.getDouble(rowNum - 1) + dY * 0.5;
        } else {
            sx = X.getDouble(0);
            sy = Y.getDouble(0);
            ex = X.getDouble(colNum - 1);
            ey = Y.getDouble(rowNum - 1);
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, 0.0);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.getDouble(p);
            double y = y_s.getDouble(p);
            if (x < sx || x > ex || y < sy || y > ey) continue;
            j = (int)((x - sx) / dX);
            int i2 = (int)((y - sy) / dY);
            if (i2 >= rowNum) {
                i2 = rowNum - 1;
            }
            if (j >= colNum) {
                j = colNum - 1;
            }
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, r.getDouble(i2 * colNum + j) + v);
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] == 0) {
                    r.setDouble(i * colNum + j, Double.NaN);
                    continue;
                }
                r.setDouble(i * colNum + j, r.getDouble(i * colNum + j) / (double)pNums[i][j]);
            }
        }
        return r;
    }

    public static Array interpolation_Inside_Max(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, boolean centerPoint) {
        int j;
        int i;
        double ey;
        double ex;
        double sy;
        double sx;
        a = a.copyIfView();
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        double min = Double.NEGATIVE_INFINITY;
        if (centerPoint) {
            sx = X.get(0).doubleValue() - dX * 0.5;
            sy = Y.get(0).doubleValue() - dY * 0.5;
            ex = X.get(colNum - 1).doubleValue() + dX * 0.5;
            ey = Y.get(rowNum - 1).doubleValue() + dY * 0.5;
        } else {
            sx = X.get(0).doubleValue();
            sy = Y.get(0).doubleValue();
            ex = X.get(colNum - 1).doubleValue();
            ey = Y.get(rowNum - 1).doubleValue();
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, min);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.get(p).doubleValue();
            double y = y_s.get(p).doubleValue();
            if (x < sx || x > ex || y < sy || y > ey) continue;
            j = (int)((x - sx) / dX);
            int i2 = (int)((y - sy) / dY);
            if (i2 >= rowNum) {
                i2 = rowNum - 1;
            }
            if (j >= colNum) {
                j = colNum - 1;
            }
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, Math.max(r.getDouble(i2 * colNum + j), v));
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] != 0 && !Double.isInfinite(r.getDouble(i * colNum + j))) continue;
                r.setDouble(i * colNum + j, Double.NaN);
            }
        }
        return r;
    }

    public static Array interpolation_Inside_Min(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, boolean centerPoint) {
        int j;
        int i;
        double ey;
        double ex;
        double sy;
        double sx;
        a = a.copyIfView();
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        double max = Double.MAX_VALUE;
        if (centerPoint) {
            sx = X.get(0).doubleValue() - dX * 0.5;
            sy = Y.get(0).doubleValue() - dY * 0.5;
            ex = X.get(colNum - 1).doubleValue() + dX * 0.5;
            ey = Y.get(rowNum - 1).doubleValue() + dY * 0.5;
        } else {
            sx = X.get(0).doubleValue();
            sy = Y.get(0).doubleValue();
            ex = X.get(colNum - 1).doubleValue();
            ey = Y.get(rowNum - 1).doubleValue();
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
                r.setDouble(i * colNum + j, max);
            }
        }
        for (int p = 0; p < pNum; ++p) {
            double v = a.getDouble(p);
            if (Double.isNaN(v)) continue;
            double x = x_s.get(p).doubleValue();
            double y = y_s.get(p).doubleValue();
            if (x < sx || x > ex || y < sy || y > ey) continue;
            j = (int)((x - sx) / dX);
            int i2 = (int)((y - sy) / dY);
            if (i2 >= rowNum) {
                i2 = rowNum - 1;
            }
            if (j >= colNum) {
                j = colNum - 1;
            }
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
            r.setDouble(i2 * colNum + j, Math.min(r.getDouble(i2 * colNum + j), v));
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                if (pNums[i][j] != 0 && r.getDouble(i * colNum + j) != Double.MAX_VALUE) continue;
                r.setDouble(i * colNum + j, Double.NaN);
            }
        }
        return r;
    }

    public static Object interpolation_Inside_Count(List<Number> x_s, List<Number> y_s, List<Number> X, List<Number> Y, boolean pointDensity, boolean centerPoint) {
        double y;
        double x;
        int j;
        int i;
        double ey;
        double ex;
        double sy;
        double sx;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.INT, new int[]{rowNum, colNum});
        double dX = X.get(1).doubleValue() - X.get(0).doubleValue();
        double dY = Y.get(1).doubleValue() - Y.get(0).doubleValue();
        int[][] pNums = new int[rowNum][colNum];
        if (centerPoint) {
            sx = X.get(0).doubleValue() - dX * 0.5;
            sy = Y.get(0).doubleValue() - dY * 0.5;
            ex = X.get(colNum - 1).doubleValue() + dX * 0.5;
            ey = Y.get(rowNum - 1).doubleValue() + dY * 0.5;
        } else {
            sx = X.get(0).doubleValue();
            sy = Y.get(0).doubleValue();
            ex = X.get(colNum - 1).doubleValue();
            ey = Y.get(rowNum - 1).doubleValue();
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                pNums[i][j] = 0;
            }
        }
        for (int p = 0; p < pNum; ++p) {
            x = x_s.get(p).doubleValue();
            y = y_s.get(p).doubleValue();
            if (x < sx || x > ex || y < sy || y > ey) continue;
            j = (int)((x - sx) / dX);
            int i2 = (int)((y - sy) / dY);
            if (i2 >= rowNum) {
                i2 = rowNum - 1;
            }
            if (j >= colNum) {
                j = colNum - 1;
            }
            int[] nArray = pNums[i2];
            int n = j;
            nArray[n] = nArray[n] + 1;
        }
        for (i = 0; i < rowNum; ++i) {
            for (j = 0; j < colNum; ++j) {
                r.setInt(i * colNum + j, pNums[i][j]);
            }
        }
        if (pointDensity) {
            Array pds = Array.factory(DataType.INT, new int[]{pNum});
            for (int p = 0; p < pNum; ++p) {
                x = x_s.get(p).doubleValue();
                y = y_s.get(p).doubleValue();
                if (x < sx || x > ex || y < sy || y > ey) continue;
                int j2 = (int)((x - sx) / dX);
                int i3 = (int)((y - sy) / dY);
                pds.setInt(p, pNums[i3][j2]);
            }
            return new Array[]{r, pds};
        }
        return r;
    }

    public static Array interpolation_Nearest(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, double radius) {
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array rdata = Array.factory(DataType.DOUBLE, new int[]{rowNum, colNum});
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(2);
        IndexIterator iter = a.getIndexIterator();
        for (i = 0; i < pNum; ++i) {
            double v = iter.getDoubleNext();
            kdTree.addPoint(new double[]{x_s.get(i).doubleValue(), y_s.get(i).doubleValue()}, v);
        }
        if (radius == Double.POSITIVE_INFINITY) {
            for (i = 0; i < rowNum; ++i) {
                double gy = Y.get(i).doubleValue();
                for (int j = 0; j < colNum; ++j) {
                    double gx = X.get(j).doubleValue();
                    KDTree.SearchResult r = kdTree.nearestNeighbours(new double[]{gx, gy}, 1).get(0);
                    rdata.setDouble(i * colNum + j, (double)((Double)r.payload));
                }
            }
        } else {
            for (i = 0; i < rowNum; ++i) {
                double gy = Y.get(i).doubleValue();
                for (int j = 0; j < colNum; ++j) {
                    double gx = X.get(j).doubleValue();
                    KDTree.SearchResult r = kdTree.nearestNeighbours(new double[]{gx, gy}, 1).get(0);
                    if (Math.sqrt(r.distance) <= radius) {
                        rdata.setDouble(i * colNum + j, (double)((Double)r.payload));
                        continue;
                    }
                    rdata.setDouble(i * colNum + j, Double.NaN);
                }
            }
        }
        return rdata;
    }

    public static Array interpolation_Nearest(Array x_s, Array y_s, Array a, Array X, Array Y, double radius) {
        int i;
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        a = a.copyIfView();
        X = X.copyIfView();
        Y = Y.copyIfView();
        int colNum = (int)X.getSize();
        int rowNum = (int)Y.getSize();
        int pNum = (int)x_s.getSize();
        Array rdata = Array.factory(DataType.DOUBLE, new int[]{rowNum, colNum});
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(2);
        for (i = 0; i < pNum; ++i) {
            double v = a.getDouble(i);
            kdTree.addPoint(new double[]{x_s.getDouble(i), y_s.getDouble(i)}, v);
        }
        if (radius == Double.POSITIVE_INFINITY) {
            for (i = 0; i < rowNum; ++i) {
                double gy = Y.getDouble(i);
                for (int j = 0; j < colNum; ++j) {
                    double gx = X.getDouble(j);
                    KDTree.SearchResult r = kdTree.nearestNeighbours(new double[]{gx, gy}, 1).get(0);
                    rdata.setDouble(i * colNum + j, (double)((Double)r.payload));
                }
            }
        } else {
            for (i = 0; i < rowNum; ++i) {
                double gy = Y.getDouble(i);
                for (int j = 0; j < colNum; ++j) {
                    double gx = X.getDouble(j);
                    KDTree.SearchResult r = kdTree.nearestNeighbours(new double[]{gx, gy}, 1).get(0);
                    if (Math.sqrt(r.distance) <= radius) {
                        rdata.setDouble(i * colNum + j, (double)((Double)r.payload));
                        continue;
                    }
                    rdata.setDouble(i * colNum + j, Double.NaN);
                }
            }
        }
        return rdata;
    }

    public static Array interpolation_Surface(Array x_s, Array y_s, Array a, Array X, Array Y) {
        x_s = x_s.copyIfView();
        y_s = y_s.copyIfView();
        a = a.copyIfView();
        X = X.copyIfView();
        Y = Y.copyIfView();
        int[] shape = x_s.getShape();
        int colNum = shape[1];
        int rowNum = shape[0];
        int xn = (int)X.getSize();
        int yn = (int)Y.getSize();
        Array r = Array.factory(DataType.DOUBLE, new int[]{yn, xn});
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, Double.NaN);
            ++i;
        }
        double dX = X.getDouble(1) - X.getDouble(0);
        double dY = Y.getDouble(1) - Y.getDouble(0);
        for (int i2 = 0; i2 < rowNum - 1; ++i2) {
            for (int j = 0; j < colNum - 1; ++j) {
                double v = a.getDouble(i2 * colNum + j);
                if (Double.isNaN(v)) continue;
                double xll = x_s.getDouble(i2 * colNum + j);
                double xtl = x_s.getDouble((i2 + 1) * colNum + j);
                double xtr = x_s.getDouble((i2 + 1) * colNum + j + 1);
                double xlr = x_s.getDouble(i2 * colNum + j + 1);
                double yll = y_s.getDouble(i2 * colNum + j);
                double ytl = y_s.getDouble((i2 + 1) * colNum + j);
                double ytr = y_s.getDouble((i2 + 1) * colNum + j + 1);
                double ylr = y_s.getDouble(i2 * colNum + j + 1);
                if (Double.isNaN(xll) || Double.isNaN(xtl) || Double.isNaN(xtr) || Double.isNaN(xlr) || Double.isNaN(yll) || Double.isNaN(ytl) || Double.isNaN(ytr) || Double.isNaN(ylr)) continue;
                PolygonShape ps = new PolygonShape();
                ArrayList<PointD> points = new ArrayList<PointD>();
                points.add(new PointD(xll, yll));
                points.add(new PointD(xtl, ytl));
                points.add(new PointD(xtr, ytr));
                points.add(new PointD(xlr, ylr));
                points.add((PointD)((PointD)points.get(0)).clone());
                ps.setPoints(points);
                int minxi = (int)((ps.getExtent().minX - X.getDouble(0)) / dX);
                int maxxi = (int)((ps.getExtent().maxX - X.getDouble(0)) / dX);
                int minyi = (int)((ps.getExtent().minY - Y.getDouble(0)) / dY);
                int maxyi = (int)((ps.getExtent().maxY - Y.getDouble(0)) / dY);
                if (++maxxi < 0 || minxi >= xn || ++maxyi < 0 || minyi >= yn) continue;
                if (minxi < 0) {
                    minxi = 0;
                }
                if (maxxi >= xn) {
                    maxxi = xn - 1;
                }
                if (maxyi >= yn) {
                    maxyi = yn - 1;
                }
                for (int m = minyi; m <= maxyi; ++m) {
                    double y = Y.getDouble(m);
                    for (int n = minxi; n <= maxxi; ++n) {
                        double x = X.getDouble(n);
                        if (!GeoComputation.pointInPolygon(ps, x, y)) continue;
                        r.setDouble(m * xn + n, v);
                    }
                }
            }
        }
        return r;
    }

    public static Array interpolation_IDW_Radius(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, int neededPointNum, double radius) {
        double v;
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{rowNum, colNum});
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(2);
        IndexIterator iter = a.getIndexIterator();
        for (i = 0; i < pNum; ++i) {
            v = iter.getDoubleNext();
            if (Double.isNaN(v)) continue;
            kdTree.addPoint(new double[]{x_s.get(i).doubleValue(), y_s.get(i).doubleValue()}, v);
        }
        for (i = 0; i < rowNum; ++i) {
            double gy = Y.get(i).doubleValue();
            for (int j = 0; j < colNum; ++j) {
                double gx = X.get(j).doubleValue();
                ArrayList srs = kdTree.ballSearch_distance(new double[]{gx, gy}, radius * radius);
                if (srs == null || srs.size() < neededPointNum) {
                    r.setDouble(i * colNum + j, Double.NaN);
                    continue;
                }
                double v_sum = 0.0;
                double weight_sum = 0.0;
                boolean match = false;
                for (KDTree.SearchResult searchResult : srs) {
                    v = (Double)searchResult.payload;
                    if (searchResult.distance == 0.0) {
                        r.setDouble(i * colNum + j, v);
                        match = true;
                        break;
                    }
                    double w = 1.0 / searchResult.distance;
                    weight_sum += w;
                    v_sum += v * w;
                }
                if (match) continue;
                r.setDouble(i * colNum + j, v_sum / weight_sum);
            }
        }
        return r;
    }

    public static Array interpolation_IDW_Neighbor(List<Number> x_s, List<Number> y_s, Array a, List<Number> X, List<Number> Y, Integer points) {
        double v;
        int i;
        int colNum = X.size();
        int rowNum = Y.size();
        int pNum = x_s.size();
        Array r = Array.factory(DataType.DOUBLE, new int[]{rowNum, colNum});
        int n = 0;
        IndexIterator iter = a.getIndexIterator();
        KDTree.Euclidean<Double> kdTree = new KDTree.Euclidean<Double>(2);
        for (i = 0; i < pNum; ++i) {
            v = iter.getDoubleNext();
            if (Double.isNaN(v)) continue;
            kdTree.addPoint(new double[]{x_s.get(i).doubleValue(), y_s.get(i).doubleValue()}, v);
            ++n;
        }
        if (points == null) {
            points = n;
        }
        for (i = 0; i < rowNum; ++i) {
            double gy = Y.get(i).doubleValue();
            for (int j = 0; j < colNum; ++j) {
                double gx = X.get(j).doubleValue();
                ArrayList srs = kdTree.nearestNeighbours(new double[]{gx, gy}, points);
                double v_sum = 0.0;
                double weight_sum = 0.0;
                boolean match = false;
                for (KDTree.SearchResult searchResult : srs) {
                    v = (Double)searchResult.payload;
                    if (searchResult.distance == 0.0) {
                        r.setDouble(i * colNum + j, v);
                        match = true;
                        break;
                    }
                    double w = 1.0 / searchResult.distance;
                    weight_sum += w;
                    v_sum += v * w;
                }
                if (match) continue;
                r.setDouble(i * colNum + j, v_sum / weight_sum);
            }
        }
        return r;
    }
}

