/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.random;

import java.util.List;
import org.apache.commons.math3.random.MersenneTwister;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;

public class MTRandom
extends MersenneTwister {
    public MTRandom() {
    }

    public MTRandom(int seed) {
        super(seed);
    }

    public Array rand(int n) {
        Array r = Array.factory(DataType.DOUBLE, new int[]{n});
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, this.nextDouble());
            ++i;
        }
        return r;
    }

    public Array rand(List<Integer> shape) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory(DataType.DOUBLE, ashape);
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, this.nextDouble());
            ++i;
        }
        return a;
    }

    public double randn() {
        return this.nextGaussian();
    }

    public Array randn(int n) {
        Array r = Array.factory(DataType.DOUBLE, new int[]{n});
        int i = 0;
        while ((long)i < r.getSize()) {
            r.setDouble(i, this.nextGaussian());
            ++i;
        }
        return r;
    }

    public Array randn(List<Integer> shape) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory(DataType.DOUBLE, ashape);
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, this.nextGaussian());
            ++i;
        }
        return a;
    }

    public int randint(int bound) {
        return this.nextInt(bound);
    }

    public Array randint(int bound, int n) {
        Array a = Array.factory(DataType.INT, new int[]{n});
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, (double)this.nextInt(bound));
            ++i;
        }
        return a;
    }

    public Array randint(int bound, List<Integer> shape) {
        int[] ashape = new int[shape.size()];
        for (int i = 0; i < shape.size(); ++i) {
            ashape[i] = shape.get(i);
        }
        Array a = Array.factory(DataType.INT, ashape);
        int i = 0;
        while ((long)i < a.getSize()) {
            a.setDouble(i, (double)this.nextInt(bound));
            ++i;
        }
        return a;
    }

    public void shuffle(Array x) {
        for (int i = (int)x.getSize() - 1; i > 0; --i) {
            int index = this.nextInt(i);
            Object tmp = x.getObject(index);
            x.setObject(index, x.getObject(i));
            x.setObject(i, tmp);
        }
    }
}

