/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.stats;

import java.util.ArrayList;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.StatUtils;
import org.apache.commons.math3.stat.correlation.Covariance;
import org.apache.commons.math3.stat.correlation.KendallsCorrelation;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.correlation.SpearmansCorrelation;
import org.apache.commons.math3.stat.inference.TestUtils;
import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.meteoinfo.math.ArrayMath;
import org.meteoinfo.math.ArrayUtil;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.MAMath;
import org.meteoinfo.ndarray.Range;

public class StatsUtil {
    public static double covariance(Array x, Array y, boolean bias) {
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray_Double(x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray_Double(y);
        double r = new Covariance().covariance(xd, yd, bias);
        return r;
    }

    public static Array cov(Array x, Array y, boolean bias) {
        x = x.copyIfView();
        y = y.copyIfView();
        int m = x.getShape()[0];
        int n = 1;
        if (x.getRank() == 2) {
            n = x.getShape()[1];
        }
        double[][] aa = new double[m][n * 2];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n * 2; ++j) {
                aa[i][j] = j < n ? x.getDouble(i * n + j) : y.getDouble(i * n + j - n);
            }
        }
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        Covariance cov = new Covariance((RealMatrix)matrix, bias);
        RealMatrix mcov = cov.getCovarianceMatrix();
        m = mcov.getColumnDimension();
        n = mcov.getRowDimension();
        Array r = Array.factory(DataType.DOUBLE, new int[]{m, n});
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                r.setDouble(i * n + j, mcov.getEntry(i, j));
            }
        }
        return r;
    }

    public static Object cov(Array a, boolean bias) {
        if (a.getRank() == 1) {
            double[] ad = (double[])ArrayUtil.copyToNDJavaArray_Double(a);
            Covariance cov = new Covariance();
            return cov.covariance(ad, ad);
        }
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray_Double(a);
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        Covariance cov = new Covariance((RealMatrix)matrix, bias);
        RealMatrix mcov = cov.getCovarianceMatrix();
        int m = mcov.getColumnDimension();
        int n = mcov.getRowDimension();
        Array r = Array.factory(DataType.DOUBLE, new int[]{m, n});
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                r.setDouble(i * n + j, mcov.getEntry(i, j));
            }
        }
        return r;
    }

    public static double kendalltau(Array x, Array y) {
        double[] xd = (double[])ArrayUtil.copyToNDJavaArray_Double(x);
        double[] yd = (double[])ArrayUtil.copyToNDJavaArray_Double(y);
        KendallsCorrelation kc = new KendallsCorrelation();
        double r = kc.correlation(xd, yd);
        return r;
    }

    public static double[] pearsonr(Array x, Array y) {
        x = x.copyIfView();
        y = y.copyIfView();
        if (ArrayMath.containsNaN(x) || ArrayMath.containsNaN(y)) {
            Array[] xy = ArrayMath.removeNaN(x, y);
            if (xy == null) {
                return new double[]{Double.NaN, Double.NaN};
            }
            x = xy[0];
            y = xy[1];
        }
        if (MAMath.isEqual(x, y)) {
            return new double[]{1.0, 0.0};
        }
        int m = (int)x.getSize();
        int n = 1;
        double[][] aa = new double[m][n * 2];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n * 2; ++j) {
                aa[i][j] = j < n ? x.getDouble(i * n + j) : y.getDouble(i * n + j - n);
            }
        }
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        PearsonsCorrelation pc = new PearsonsCorrelation((RealMatrix)matrix);
        double r = pc.getCorrelationMatrix().getEntry(0, 1);
        double pvalue = pc.getCorrelationPValues().getEntry(0, 1);
        return new double[]{r, pvalue};
    }

    public static Array[] pearsonr(Array x, Array y, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = x.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.DOUBLE, shape);
        Array pv = Array.factory(DataType.DOUBLE, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            Array xx = ArrayMath.section(x, ranges);
            Array yy = ArrayMath.section(y, ranges);
            double[] rp = StatsUtil.pearsonr(xx, yy);
            r.setDouble(i, rp[0]);
            pv.setDouble(i, rp[1]);
            indexr.incr();
            ++i;
        }
        return new Array[]{r, pv};
    }

    public static Array spearmanr(Array x, Array y) {
        x = x.copyIfView();
        y = y.copyIfView();
        int m = x.getShape()[0];
        int n = 1;
        if (x.getRank() == 2) {
            n = x.getShape()[1];
        }
        double[][] aa = new double[m][n * 2];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n * 2; ++j) {
                aa[i][j] = j < n ? x.getDouble(i * n + j) : y.getDouble(i * n + j - n);
            }
        }
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        SpearmansCorrelation cov = new SpearmansCorrelation((RealMatrix)matrix);
        RealMatrix mcov = cov.getCorrelationMatrix();
        m = mcov.getColumnDimension();
        n = mcov.getRowDimension();
        Array r = Array.factory(DataType.DOUBLE, new int[]{m, n});
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                r.setDouble(i * n + j, mcov.getEntry(i, j));
            }
        }
        return r;
    }

    public static Object spearmanr(Array a) {
        if (a.getRank() == 1) {
            double[] ad = (double[])ArrayUtil.copyToNDJavaArray_Double(a);
            Covariance cov = new Covariance();
            return cov.covariance(ad, ad);
        }
        double[][] aa = (double[][])ArrayUtil.copyToNDJavaArray_Double(a);
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(aa, false);
        SpearmansCorrelation cov = new SpearmansCorrelation((RealMatrix)matrix);
        RealMatrix mcov = cov.getCorrelationMatrix();
        int m = mcov.getColumnDimension();
        int n = mcov.getRowDimension();
        Array r = Array.factory(DataType.DOUBLE, new int[]{m, n});
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                r.setDouble(i * n + j, mcov.getEntry(i, j));
            }
        }
        return r;
    }

    public static Array[] multipleLineRegress_OLS(Array y, Array x) {
        return StatsUtil.multipleLineRegress_OLS(y, x, false);
    }

    public static Array[] multipleLineRegress_OLS(Array y, Array x, boolean noIntercept) {
        int i;
        OLSMultipleLinearRegression regression = new OLSMultipleLinearRegression();
        regression.setNoIntercept(noIntercept);
        double[] yy = (double[])ArrayUtil.copyToNDJavaArray_Double(y);
        double[][] xx = (double[][])ArrayUtil.copyToNDJavaArray_Double(x);
        regression.newSampleData(yy, xx);
        double[] para = regression.estimateRegressionParameters();
        double[] residuals = regression.estimateResiduals();
        int k = para.length;
        int n = residuals.length;
        Array aPara = Array.factory(DataType.DOUBLE, new int[]{k});
        Array aResiduals = Array.factory(DataType.DOUBLE, new int[]{n});
        for (i = 0; i < k; ++i) {
            aPara.setDouble(i, para[i]);
        }
        for (i = 0; i < k; ++i) {
            aResiduals.setDouble(i, residuals[i]);
        }
        return new Array[]{aPara, aResiduals};
    }

    public static double percentile(Array a, double p) {
        double[] v = (double[])a.get1DJavaArray(Double.class);
        double r = StatUtils.percentile((double[])v, (double)p);
        return r;
    }

    public static Array percentile(Array a, double p, int axis) throws InvalidRangeException {
        int idx;
        int[] dataShape = a.getShape();
        int[] shape = new int[dataShape.length - 1];
        for (int i = 0; i < dataShape.length; ++i) {
            idx = i;
            if (idx == axis) continue;
            if (idx > axis) {
                --idx;
            }
            shape[idx] = dataShape[i];
        }
        Array r = Array.factory(DataType.DOUBLE, shape);
        Index indexr = r.getIndex();
        int i = 0;
        while ((long)i < r.getSize()) {
            int[] current = indexr.getCurrentCounter();
            ArrayList<Range> ranges = new ArrayList<Range>();
            for (int j = 0; j < dataShape.length; ++j) {
                if (j == axis) {
                    ranges.add(new Range(0, dataShape[j] - 1, 1));
                    continue;
                }
                idx = j;
                if (idx > axis) {
                    --idx;
                }
                ranges.add(new Range(current[idx], current[idx], 1));
            }
            Array aa = ArrayMath.section(a, ranges);
            double[] v = (double[])aa.get1DJavaArray(Double.class);
            double q = StatUtils.percentile((double[])v, (double)p);
            r.setDouble(i, q);
            indexr.incr();
            ++i;
        }
        return r;
    }

    public static double[] tTest(Array a, double mu) {
        double[] ad = (double[])ArrayUtil.copyToNDJavaArray_Double(a);
        double s = TestUtils.t((double)mu, (double[])ad);
        double p = TestUtils.tTest((double)mu, (double[])ad);
        return new double[]{s, p};
    }

    public static double[] tTest(Array a, Array b) {
        double[] ad = (double[])ArrayUtil.copyToNDJavaArray_Double(a);
        double[] bd = (double[])ArrayUtil.copyToNDJavaArray_Double(b);
        double s = TestUtils.t((double[])ad, (double[])bd);
        double p = TestUtils.tTest((double[])ad, (double[])bd);
        return new double[]{s, p};
    }

    public static double[] pairedTTest(Array a, Array b) {
        double[] ad = (double[])ArrayUtil.copyToNDJavaArray_Double(a);
        double[] bd = (double[])ArrayUtil.copyToNDJavaArray_Double(b);
        double s = TestUtils.pairedT((double[])ad, (double[])bd);
        double p = TestUtils.pairedTTest((double[])ad, (double[])bd);
        return new double[]{s, p};
    }

    public static double[] chiSquareTest(Array e, Array o) {
        double[] ed = (double[])ArrayUtil.copyToNDJavaArray_Double(e);
        long[] od = (long[])ArrayUtil.copyToNDJavaArray_Long(o);
        double s = TestUtils.chiSquare((double[])ed, (long[])od);
        double p = TestUtils.chiSquareTest((double[])ed, (long[])od);
        return new double[]{s, p};
    }

    public static double[] chiSquareTest(Array o) {
        long[][] od = (long[][])ArrayUtil.copyToNDJavaArray_Long(o);
        double s = TestUtils.chiSquare((long[][])od);
        double p = TestUtils.chiSquareTest((long[][])od);
        return new double[]{s, p};
    }
}

