/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import java.nio.ByteBuffer;
import java.time.LocalDateTime;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.ArrayObject;
import org.meteoinfo.ndarray.Complex;
import org.meteoinfo.ndarray.ForbiddenConversionException;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.Index0D;
import org.meteoinfo.ndarray.Index1D;
import org.meteoinfo.ndarray.Index2D;
import org.meteoinfo.ndarray.Index3D;
import org.meteoinfo.ndarray.Index4D;
import org.meteoinfo.ndarray.Index5D;
import org.meteoinfo.ndarray.Index6D;
import org.meteoinfo.ndarray.Index7D;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Section;

public class ArrayChar
extends Array {
    protected char[] storage;

    static ArrayChar factory(Index index) {
        return ArrayChar.factory(index, null);
    }

    static ArrayChar factory(Index index, char[] storage) {
        switch (index.getRank()) {
            case 0: {
                return new D0(index, storage);
            }
            case 1: {
                return new D1(index, storage);
            }
            case 2: {
                return new D2(index, storage);
            }
            case 3: {
                return new D3(index, storage);
            }
            case 4: {
                return new D4(index, storage);
            }
            case 5: {
                return new D5(index, storage);
            }
            case 6: {
                return new D6(index, storage);
            }
            case 7: {
                return new D7(index, storage);
            }
        }
        return new ArrayChar(index, storage);
    }

    public ArrayChar(int[] dimensions) {
        super(dimensions);
        this.storage = new char[(int)this.indexCalc.getSize()];
    }

    ArrayChar(Index ima, char[] data) {
        super(ima);
        this.storage = data != null ? data : new char[(int)ima.getSize()];
    }

    public ArrayChar(String s) {
        super(new int[]{s.length()});
        this.storage = new char[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            this.storage[i] = s.charAt(i);
        }
    }

    @Override
    protected Array createView(Index index) {
        return ArrayChar.factory(index, this.storage);
    }

    @Override
    public Object getStorage() {
        return this.storage;
    }

    @Override
    protected void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        char[] ja;
        for (char aJa : ja = (char[])javaArray) {
            iter.setCharNext(aJa);
        }
    }

    @Override
    protected void copyTo1DJavaArray(IndexIterator iter, Object javaArray) {
        char[] ja = (char[])javaArray;
        for (int i = 0; i < ja.length; ++i) {
            ja[i] = iter.getCharNext();
        }
    }

    @Override
    public ByteBuffer getDataAsByteBuffer() {
        ByteBuffer bb = ByteBuffer.allocate((int)this.getSize());
        this.resetLocalIterator();
        while (this.hasNext()) {
            bb.put(this.nextByte());
        }
        return bb;
    }

    @Override
    public Class getElementType() {
        return Character.TYPE;
    }

    public char get(Index i) {
        return this.storage[i.currentElement()];
    }

    public void set(Index i, char value) {
        this.storage[i.currentElement()] = value;
    }

    @Override
    public double getDouble(Index i) {
        return this.storage[i.currentElement()];
    }

    @Override
    public void setDouble(Index i, double value) {
        this.storage[i.currentElement()] = (char)value;
    }

    @Override
    public float getFloat(Index i) {
        return this.storage[i.currentElement()];
    }

    @Override
    public void setFloat(Index i, float value) {
        this.storage[i.currentElement()] = (char)value;
    }

    @Override
    public long getLong(Index i) {
        return this.storage[i.currentElement()];
    }

    @Override
    public void setLong(Index i, long value) {
        this.storage[i.currentElement()] = (char)value;
    }

    @Override
    public int getInt(Index i) {
        return this.storage[i.currentElement()];
    }

    @Override
    public void setInt(Index i, int value) {
        this.storage[i.currentElement()] = (char)value;
    }

    @Override
    public short getShort(Index i) {
        return (short)this.storage[i.currentElement()];
    }

    @Override
    public void setShort(Index i, short value) {
        this.storage[i.currentElement()] = (char)value;
    }

    @Override
    public byte getByte(Index i) {
        return (byte)this.storage[i.currentElement()];
    }

    @Override
    public void setByte(Index i, byte value) {
        this.storage[i.currentElement()] = (char)value;
    }

    @Override
    public char getChar(Index i) {
        return this.storage[i.currentElement()];
    }

    @Override
    public void setChar(Index i, char value) {
        this.storage[i.currentElement()] = value;
    }

    @Override
    public boolean getBoolean(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(Index i, boolean value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public Complex getComplex(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setComplex(Index i, Complex value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public LocalDateTime getDate(Index i) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setDate(Index i, LocalDateTime value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public Object getObject(Index i) {
        return Character.valueOf(this.storage[i.currentElement()]);
    }

    @Override
    public void setObject(Index i, Object value) {
        this.storage[i.currentElement()] = ((Character)value).charValue();
    }

    public String getString() {
        int rank = this.getRank();
        if (rank == 0) {
            return new String(this.storage);
        }
        if (rank != 1) {
            throw new IllegalArgumentException("ArayChar.getString rank must be 1");
        }
        int strLen = this.indexCalc.getShape(0);
        int count = 0;
        for (int k = 0; k < strLen && '\u0000' != this.storage[k]; ++k) {
            ++count;
        }
        return new String(this.storage, 0, count);
    }

    @Override
    public String getString(int index) {
        Index ima = this.getIndex();
        return this.getString(ima.set(index));
    }

    @Override
    public String getString(Index ima) {
        int rank = this.getRank();
        if (rank == 0) {
            throw new IllegalArgumentException("ArayChar.getString rank must not be 0");
        }
        if (rank == 1) {
            return this.getString();
        }
        int strLen = this.indexCalc.getShape(rank - 1);
        char[] carray = new char[strLen];
        int count = 0;
        for (int k = 0; k < strLen; ++k) {
            ima.setDim(rank - 1, k);
            carray[k] = this.getChar(ima);
            if ('\u0000' == carray[k]) break;
            ++count;
        }
        return new String(carray, 0, count);
    }

    public void setString(String val) {
        int rank = this.getRank();
        if (rank != 1) {
            throw new IllegalArgumentException("ArayChar.setString rank must be 1");
        }
        int arrayLen = this.indexCalc.getShape(0);
        int strLen = Math.min(val.length(), arrayLen);
        for (int k = 0; k < strLen; ++k) {
            this.storage[k] = val.charAt(k);
        }
        char c = '\u0000';
        for (int k = strLen; k < arrayLen; ++k) {
            this.storage[k] = c;
        }
    }

    @Override
    public void setString(int index, String val) {
        int rank = this.getRank();
        if (rank != 2) {
            throw new IllegalArgumentException("ArrayChar.setString rank must be 2");
        }
        Index ima = this.getIndex();
        this.setString(ima.set(index), val);
    }

    @Override
    public void setString(Index ima, String val) {
        int rank = this.getRank();
        if (rank == 0) {
            throw new IllegalArgumentException("ArrayChar.setString rank must not be 0");
        }
        int arrayLen = this.indexCalc.getShape(rank - 1);
        int strLen = Math.min(val.length(), arrayLen);
        int count = 0;
        for (int k = 0; k < strLen; ++k) {
            ima.setDim(rank - 1, k);
            this.setChar(ima, val.charAt(k));
            ++count;
        }
        char c = '\u0000';
        for (int k = count; k < arrayLen; ++k) {
            ima.setDim(rank - 1, k);
            this.setChar(ima, c);
        }
    }

    @Override
    public double getDouble(int index) {
        return this.storage[index];
    }

    @Override
    public void setDouble(int index, double value) {
        this.storage[index] = (char)value;
    }

    @Override
    public float getFloat(int index) {
        return this.storage[index];
    }

    @Override
    public void setFloat(int index, float value) {
        this.storage[index] = (char)value;
    }

    @Override
    public long getLong(int index) {
        return this.storage[index];
    }

    @Override
    public void setLong(int index, long value) {
        this.storage[index] = (char)value;
    }

    @Override
    public int getInt(int index) {
        return this.storage[index];
    }

    @Override
    public void setInt(int index, int value) {
        this.storage[index] = (char)value;
    }

    @Override
    public short getShort(int index) {
        return (short)this.storage[index];
    }

    @Override
    public void setShort(int index, short value) {
        this.storage[index] = (char)value;
    }

    @Override
    public byte getByte(int index) {
        return (byte)this.storage[index];
    }

    @Override
    public void setByte(int index, byte value) {
        this.storage[index] = (char)value;
    }

    @Override
    public char getChar(int index) {
        return this.storage[index];
    }

    @Override
    public void setChar(int index, char value) {
        this.storage[index] = value;
    }

    @Override
    public boolean getBoolean(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setBoolean(int index, boolean value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public Complex getComplex(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setComplex(int index, Complex value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public LocalDateTime getDate(int index) {
        throw new ForbiddenConversionException();
    }

    @Override
    public void setDate(int index, LocalDateTime value) {
        throw new ForbiddenConversionException();
    }

    @Override
    public Object getObject(int index) {
        return Character.valueOf(this.getChar(index));
    }

    @Override
    public void setObject(int index, Object value) {
        this.storage[index] = ((Character)value).charValue();
    }

    @Override
    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        StringIterator ii = this.getStringIterator();
        int count = 0;
        while (ii.hasNext()) {
            if (count > 0) {
                sbuff.append(",");
            }
            String data = ii.next();
            sbuff.append(data);
            ++count;
        }
        return sbuff.toString();
    }

    public StringIterator getStringIterator() {
        return new StringIterator();
    }

    public ArrayObject make1DStringArray() {
        int nelems = this.getRank() == 0 ? 1 : (int)this.getSize() / this.indexCalc.getShape(this.getRank() - 1);
        Array sarr = Array.factory(String.class, new int[]{nelems});
        IndexIterator newsiter = sarr.getIndexIterator();
        StringIterator siter = this.getStringIterator();
        while (siter.hasNext()) {
            newsiter.setObjectNext(siter.next());
        }
        return (ArrayObject)sarr;
    }

    public static ArrayChar makeFromString(String s, int max) {
        D1 result = new D1(max);
        for (int i = 0; i < max && i < s.length(); ++i) {
            result.setChar(i, s.charAt(i));
        }
        return result;
    }

    public static ArrayChar makeFromStringArray(ArrayObject values) {
        IndexIterator ii = values.getIndexIterator();
        int strlen = 0;
        while (ii.hasNext()) {
            String s = (String)ii.next();
            strlen = Math.max(s.length(), strlen);
        }
        return ArrayChar.makeFromStringArray(values, strlen);
    }

    public static ArrayChar makeFromStringArray(ArrayObject values, int strlen) {
        try {
            Section section = new Section(values.getShape());
            section.appendRange(strlen);
            int[] shape = section.getShape();
            long size = section.computeSize();
            char[] cdata = new char[(int)size];
            int start = 0;
            IndexIterator ii = values.getIndexIterator();
            while (ii.hasNext()) {
                String s = (String)ii.next();
                for (int k = 0; k < s.length() && k < strlen; ++k) {
                    cdata[start + k] = s.charAt(k);
                }
                start += strlen;
            }
            Array carr = Array.factory(Character.TYPE, shape, (Object)cdata);
            return (ArrayChar)carr;
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
            return null;
        }
    }

    public class StringIterator {
        private IndexIterator ii;
        private int strLen;
        private char[] carray;

        StringIterator() {
            this.ii = ArrayChar.this.getIndexIterator();
            this.strLen = ArrayChar.this.rank == 0 ? 1 : ArrayChar.this.indexCalc.getShape(ArrayChar.this.rank - 1);
            this.carray = new char[this.strLen];
        }

        public int getNumElems() {
            return (int)ArrayChar.this.getSize() / this.strLen;
        }

        public boolean hasNext() {
            return this.ii.hasNext();
        }

        public String next() {
            int stop = this.strLen;
            for (int k = 0; k < this.strLen; ++k) {
                this.carray[k] = this.ii.getCharNext();
                if ('\u0000' != this.carray[k] || stop != this.strLen) continue;
                stop = k;
            }
            return new String(this.carray, 0, stop);
        }
    }

    public static class D7
    extends ArrayChar {
        private Index7D ix;

        public D7(int len0, int len1, int len2, int len3, int len4, int len5, int len6) {
            super(new int[]{len0, len1, len2, len3, len4, len5, len6});
            this.ix = (Index7D)this.indexCalc;
        }

        private D7(Index i, char[] store) {
            super(i, store);
            this.ix = (Index7D)this.indexCalc;
        }

        public char get(int i, int j, int k, int l, int m, int n, int o) {
            return this.storage[this.ix.setDirect(i, j, k, l, m, n, o)];
        }

        public void set(int i, int j, int k, int l, int m, int n, int o, char value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m, (int)n, (int)o)] = value;
        }
    }

    public static class D6
    extends ArrayChar {
        private Index6D ix;

        public D6(int len0, int len1, int len2, int len3, int len4, int len5) {
            super(new int[]{len0, len1, len2, len3, len4, len5});
            this.ix = (Index6D)this.indexCalc;
        }

        private D6(Index i, char[] store) {
            super(i, store);
            this.ix = (Index6D)this.indexCalc;
        }

        public char get(int i, int j, int k, int l, int m, int n) {
            return this.storage[this.ix.setDirect(i, j, k, l, m, n)];
        }

        public void set(int i, int j, int k, int l, int m, int n, char value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m, (int)n)] = value;
        }
    }

    public static class D5
    extends ArrayChar {
        private Index5D ix;

        public D5(int len0, int len1, int len2, int len3, int len4) {
            super(new int[]{len0, len1, len2, len3, len4});
            this.ix = (Index5D)this.indexCalc;
        }

        private D5(Index i, char[] store) {
            super(i, store);
            this.ix = (Index5D)this.indexCalc;
        }

        public char get(int i, int j, int k, int l, int m) {
            return this.storage[this.ix.setDirect(i, j, k, l, m)];
        }

        public void set(int i, int j, int k, int l, int m, char value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l, (int)m)] = value;
        }
    }

    public static class D4
    extends ArrayChar {
        private Index4D ix;

        public D4(int len0, int len1, int len2, int len3) {
            super(new int[]{len0, len1, len2, len3});
            this.ix = (Index4D)this.indexCalc;
        }

        private D4(Index i, char[] store) {
            super(i, store);
            this.ix = (Index4D)this.indexCalc;
        }

        public char get(int i, int j, int k, int l) {
            return this.storage[this.ix.setDirect(i, j, k, l)];
        }

        public void set(int i, int j, int k, int l, char value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k, (int)l)] = value;
        }
    }

    public static class D3
    extends ArrayChar {
        private Index3D ix;

        public D3(int len0, int len1, int len2) {
            super(new int[]{len0, len1, len2});
            this.ix = (Index3D)this.indexCalc;
        }

        private D3(Index i, char[] store) {
            super(i, store);
            this.ix = (Index3D)this.indexCalc;
        }

        public char get(int i, int j, int k) {
            return this.storage[this.ix.setDirect(i, j, k)];
        }

        public void set(int i, int j, int k, char value) {
            this.storage[this.ix.setDirect((int)i, (int)j, (int)k)] = value;
        }
    }

    public static class D2
    extends ArrayChar {
        private Index2D ix;

        public D2(int len0, int len1) {
            super(new int[]{len0, len1});
            this.ix = (Index2D)this.indexCalc;
        }

        private D2(Index i, char[] store) {
            super(i, store);
            this.ix = (Index2D)this.indexCalc;
        }

        public char get(int i, int j) {
            return this.storage[this.ix.setDirect(i, j)];
        }

        public void set(int i, int j, char value) {
            this.storage[this.ix.setDirect((int)i, (int)j)] = value;
        }
    }

    public static class D1
    extends ArrayChar {
        private Index1D ix;

        public D1(int len0) {
            super(new int[]{len0});
            this.ix = (Index1D)this.indexCalc;
        }

        private D1(Index i, char[] store) {
            super(i, store);
            this.ix = (Index1D)this.indexCalc;
        }

        public char get(int i) {
            return this.storage[this.ix.setDirect(i)];
        }

        public void set(int i, char value) {
            this.storage[this.ix.setDirect((int)i)] = value;
        }
    }

    public static class D0
    extends ArrayChar {
        private Index0D ix;

        public D0() {
            super(new int[0]);
            this.ix = (Index0D)this.indexCalc;
        }

        private D0(Index i, char[] store) {
            super(i, store);
            this.ix = (Index0D)this.indexCalc;
        }

        public char get() {
            return this.storage[this.ix.currentElement()];
        }

        public void set(char value) {
            this.storage[this.ix.currentElement()] = value;
        }
    }
}

