/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.ArrayStructureBak;
import org.meteoinfo.ndarray.ArrayStructureW;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.StructureData;
import org.meteoinfo.ndarray.StructureDataIterator;
import org.meteoinfo.ndarray.StructureMembers;
import org.meteoinfo.util.Indent;

public class ArraySequence
extends ArrayStructureBak {
    protected StructureDataIterator iter;

    protected ArraySequence(StructureMembers sm, int[] shape) {
        super(sm, shape);
    }

    public ArraySequence(StructureMembers members, StructureDataIterator iter, int nelems) {
        super(members, new int[]{0});
        this.iter = iter;
        this.nelems = nelems;
    }

    @Override
    public Class getElementType() {
        return StructureDataIterator.class;
    }

    @Override
    public StructureDataIterator getStructureDataIterator() {
        this.iter = this.iter.reset();
        return this.iter;
    }

    public int getStructureDataCount() {
        return this.nelems;
    }

    @Override
    public long getSizeBytes() {
        return this.nelems * this.members.getStructureSize();
    }

    @Override
    protected StructureData makeStructureData(ArrayStructureBak as, int index) {
        throw new UnsupportedOperationException("Cannot subset a Sequence");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public Array extractMemberArray(StructureMembers.Member proxym) throws IOException {
        if (proxym.getDataArray() != null) {
            return proxym.getDataArray();
        }
        dataType = proxym.getDataType();
        isScalar = proxym.getSize() == 1 || dataType == DataType.SEQUENCE;
        mshape = proxym.getShape();
        rrank = 1 + mshape.length;
        rshape = new int[rrank];
        rshape[0] = this.nelems;
        System.arraycopy(mshape, 0, rshape, 1, mshape.length);
        if (this.nelems < 0) {
            return this.extractMemberArrayFromIteration(proxym, rshape);
        }
        if (dataType == DataType.STRUCTURE) {
            membersw = new StructureMembers(proxym.getStructureMembers());
            result = new ArrayStructureW(membersw, rshape);
        } else {
            result = Array.factory(dataType.getPrimitiveClassType(), rshape);
        }
        sdataIter = this.getStructureDataIterator();
        resultIter = result.getIndexIterator();
lbl19:
        // 10 sources

        try {
            while (sdataIter.hasNext()) {
                block35: {
                    block34: {
                        block33: {
                            block32: {
                                block31: {
                                    block30: {
                                        block29: {
                                            block28: {
                                                sdata = sdataIter.next();
                                                realm = sdata.getStructureMembers().findMember(proxym.getName());
                                                if (isScalar) {
                                                    if (dataType == DataType.DOUBLE) {
                                                        resultIter.setDoubleNext(sdata.getScalarDouble(realm));
                                                        continue;
                                                    }
                                                    if (dataType == DataType.FLOAT) {
                                                        resultIter.setFloatNext(sdata.getScalarFloat(realm));
                                                        continue;
                                                    }
                                                    if (dataType == DataType.BYTE || dataType == DataType.ENUM1) {
                                                        resultIter.setByteNext(sdata.getScalarByte(realm));
                                                        continue;
                                                    }
                                                    if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
                                                        resultIter.setShortNext(sdata.getScalarShort(realm));
                                                        continue;
                                                    }
                                                    if (dataType == DataType.INT || dataType == DataType.ENUM4) {
                                                        resultIter.setIntNext(sdata.getScalarInt(realm));
                                                        continue;
                                                    }
                                                    if (dataType == DataType.LONG) {
                                                        resultIter.setLongNext(sdata.getScalarLong(realm));
                                                        continue;
                                                    }
                                                    if (dataType == DataType.CHAR) {
                                                        resultIter.setCharNext(sdata.getScalarChar(realm));
                                                        continue;
                                                    }
                                                    if (dataType == DataType.STRING) {
                                                        resultIter.setObjectNext(sdata.getScalarString(realm));
                                                        continue;
                                                    }
                                                    if (dataType == DataType.STRUCTURE) {
                                                        resultIter.setObjectNext(sdata.getScalarStructure(realm));
                                                        continue;
                                                    }
                                                    if (dataType != DataType.SEQUENCE) continue;
                                                    resultIter.setObjectNext(sdata.getArraySequence(realm));
                                                    continue;
                                                }
                                                if (dataType != DataType.DOUBLE) break block28;
                                                for (double aData : data /* !! */  = sdata.getJavaArrayDouble(realm)) {
                                                    resultIter.setDoubleNext(aData);
                                                }
                                                ** GOTO lbl19
                                            }
                                            if (dataType != DataType.FLOAT) break block29;
                                            for (double aData : data /* !! */  = (double[])sdata.getJavaArrayFloat(realm)) {
                                                resultIter.setFloatNext((float)aData);
                                            }
                                            ** GOTO lbl19
                                        }
                                        if (dataType != DataType.BYTE && dataType != DataType.ENUM1) break block30;
                                        for (double aData : data /* !! */  = (double[])sdata.getJavaArrayByte(realm)) {
                                            resultIter.setByteNext((byte)aData);
                                        }
                                        ** GOTO lbl19
                                    }
                                    if (dataType != DataType.SHORT && dataType != DataType.ENUM2) break block31;
                                    for (double aData : data /* !! */  = (double[])sdata.getJavaArrayShort(realm)) {
                                        resultIter.setShortNext((short)aData);
                                    }
                                    ** GOTO lbl19
                                }
                                if (dataType != DataType.INT && dataType != DataType.ENUM4) break block32;
                                for (double aData : data /* !! */  = (double[])sdata.getJavaArrayInt(realm)) {
                                    resultIter.setIntNext((int)aData);
                                }
                                ** GOTO lbl19
                            }
                            if (dataType != DataType.LONG) break block33;
                            for (double aData : data /* !! */  = (double[])sdata.getJavaArrayLong(realm)) {
                                resultIter.setLongNext((long)aData);
                            }
                            ** GOTO lbl19
                        }
                        if (dataType != DataType.CHAR) break block34;
                        for (double aData : data /* !! */  = (double[])sdata.getJavaArrayChar(realm)) {
                            resultIter.setCharNext((char)aData);
                        }
                        ** GOTO lbl19
                    }
                    if (dataType != DataType.STRING) break block35;
                    for (double aData : data /* !! */  = (double[])sdata.getJavaArrayString(realm)) {
                        resultIter.setObjectNext(aData);
                    }
                    ** GOTO lbl19
                }
                if (dataType != DataType.STRUCTURE) continue;
                as = sdata.getArrayStructure(realm);
                innerIter = as.getStructureDataIterator();
                while (innerIter.hasNext()) {
                    resultIter.setObjectNext(innerIter.next());
                }
                ** GOTO lbl19
            }
        }
        finally {
            sdataIter.finish();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Array extractMemberArrayFromIteration(StructureMembers.Member proxym, int[] rshape) throws IOException {
        DataType dataType = proxym.getDataType();
        StructureDataIterator sdataIter = this.getStructureDataIterator();
        Object[] dataArray = null;
        int count = 0;
        int initial = 1000;
        try {
            if (dataType == DataType.DOUBLE) {
                ArrayList<Double> result = new ArrayList<Double>(initial);
                while (sdataIter.hasNext()) {
                    Object data;
                    StructureData sdata = sdataIter.next();
                    StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                    for (Object aData : data = (Object)sdata.getJavaArrayDouble(realm)) {
                        result.add((double)aData);
                    }
                    ++count;
                }
                double[] da = new double[result.size()];
                int i = 0;
                for (Double d : result) {
                    da[i++] = d;
                }
                dataArray = da;
            } else if (dataType == DataType.FLOAT) {
                ArrayList<Float> result = new ArrayList<Float>(initial);
                while (sdataIter.hasNext()) {
                    Object data;
                    StructureData sdata = sdataIter.next();
                    StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                    for (Object aData : data = (Object)sdata.getJavaArrayFloat(realm)) {
                        result.add(Float.valueOf((float)aData));
                    }
                    ++count;
                }
                float[] da = new float[result.size()];
                int i = 0;
                for (Float f : result) {
                    da[i++] = f.floatValue();
                }
                dataArray = da;
            } else if (dataType == DataType.BYTE || dataType == DataType.ENUM1) {
                ArrayList<Byte> result = new ArrayList<Byte>(initial);
                while (sdataIter.hasNext()) {
                    Object data;
                    StructureData sdata = sdataIter.next();
                    StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                    for (Object aData : data = (Object)sdata.getJavaArrayByte(realm)) {
                        result.add((byte)aData);
                    }
                    ++count;
                }
                byte[] da = new byte[result.size()];
                int i = 0;
                for (Byte by : result) {
                    da[i++] = by;
                }
                dataArray = da;
            } else if (dataType == DataType.SHORT || dataType == DataType.ENUM2) {
                ArrayList<Short> result = new ArrayList<Short>(initial);
                while (sdataIter.hasNext()) {
                    Object data;
                    StructureData sdata = sdataIter.next();
                    StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                    for (Object aData : data = (Object)sdata.getJavaArrayShort(realm)) {
                        result.add((short)aData);
                    }
                    ++count;
                }
                short[] da = new short[result.size()];
                int i = 0;
                for (Short s : result) {
                    da[i++] = s;
                }
                dataArray = da;
            } else if (dataType == DataType.INT || dataType == DataType.ENUM4) {
                ArrayList<Integer> result = new ArrayList<Integer>(initial);
                while (sdataIter.hasNext()) {
                    Object data;
                    StructureData sdata = sdataIter.next();
                    StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                    for (Object aData : data = (Object)sdata.getJavaArrayInt(realm)) {
                        result.add((int)aData);
                    }
                    ++count;
                }
                int[] da = new int[result.size()];
                int i = 0;
                for (Integer n : result) {
                    da[i++] = n;
                }
                dataArray = da;
            } else if (dataType == DataType.LONG) {
                ArrayList<Long> result = new ArrayList<Long>(initial);
                while (sdataIter.hasNext()) {
                    Object data;
                    StructureData sdata = sdataIter.next();
                    StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                    for (Object aData : data = (Object)sdata.getJavaArrayLong(realm)) {
                        result.add((long)aData);
                    }
                    ++count;
                }
                long[] da = new long[result.size()];
                int i = 0;
                for (Long l : result) {
                    da[i++] = l;
                }
                dataArray = da;
            } else if (dataType == DataType.CHAR) {
                ArrayList<Character> result = new ArrayList<Character>(initial);
                while (sdataIter.hasNext()) {
                    Object data;
                    StructureData sdata = sdataIter.next();
                    StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                    for (Object aData : data = (Object)sdata.getJavaArrayChar(realm)) {
                        result.add(Character.valueOf((char)aData));
                    }
                    ++count;
                }
                char[] da = new char[result.size()];
                int i = 0;
                for (Character c : result) {
                    da[i++] = c.charValue();
                }
                dataArray = da;
            } else if (dataType == DataType.STRING) {
                ArrayList<String> result = new ArrayList<String>(initial);
                while (sdataIter.hasNext()) {
                    StructureData sdata = sdataIter.next();
                    StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                    String[] data = sdata.getJavaArrayString(realm);
                    result.addAll(Arrays.asList(data));
                    ++count;
                }
                String[] da = new String[result.size()];
                int i = 0;
                for (String string : result) {
                    da[i++] = string;
                }
                dataArray = da;
            } else if (dataType == DataType.STRUCTURE) {
                ArrayList<StructureData> result = new ArrayList<StructureData>(initial);
                while (sdataIter.hasNext()) {
                    StructureData sdata = sdataIter.next();
                    StructureMembers.Member realm = sdata.getStructureMembers().findMember(proxym.getName());
                    ArrayStructureBak as = sdata.getArrayStructure(realm);
                    StructureDataIterator structureDataIterator = as.getStructureDataIterator();
                    while (structureDataIterator.hasNext()) {
                        result.add(structureDataIterator.next());
                    }
                    ++count;
                }
                StructureData[] da = new StructureData[result.size()];
                rshape[0] = count;
                StructureMembers membersw = new StructureMembers(proxym.getStructureMembers());
                ArrayStructureW arrayStructureW = new ArrayStructureW(membersw, rshape, da);
                return arrayStructureW;
            }
        }
        finally {
            sdataIter.finish();
        }
        rshape[0] = count;
        return Array.factory(dataType.getPrimitiveClassType(), rshape, (Object)dataArray);
    }

    @Override
    public String toString() {
        return "seq n=" + Integer.toString(this.nelems);
    }

    @Override
    public void showInternal(Formatter f, Indent indent) {
        super.showInternal(f, indent);
        f.format("%sStructureDataIterator Class=%s hash=0x%x%n", indent, this.iter.getClass().getName(), this.iter.hashCode());
        if (this.iter instanceof ArrayStructureBak.ArrayStructureIterator) {
            ArrayStructureBak.ArrayStructureIterator ii = (ArrayStructureBak.ArrayStructureIterator)this.iter;
            ii.getArrayStructure().showInternal(f, indent.incr());
            indent.decr();
        }
    }
}

