/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import java.time.LocalDateTime;
import java.util.List;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.Complex;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.Section;

public class IndexConstant
extends Index {
    protected IndexConstant(int rank) {
        super(rank);
    }

    protected IndexConstant(int[] shape) {
        super(shape);
    }

    protected IndexConstant(int[] shape, int[] stride) {
        super(shape, stride);
    }

    @Override
    public int currentElement() {
        return 0;
    }

    @Override
    Index flip(int index) {
        return this;
    }

    @Override
    Index sectionNoReduce(List<Range> ranges) throws InvalidRangeException {
        Section curr = new Section(this.shape);
        Section want = curr.compose(new Section(ranges));
        return new IndexConstant(want.getShape());
    }

    @Override
    Index section(List<Range> ranges) throws InvalidRangeException {
        Section curr = new Section(this.shape);
        Section want = curr.compose(new Section(ranges)).reduce();
        return new IndexConstant(want.getShape());
    }

    @Override
    Index reduce() {
        Section curr = new Section(this.shape);
        Section want = curr.reduce();
        return new IndexConstant(want.getShape());
    }

    @Override
    Index reduce(int dim) {
        if (dim < 0 || dim >= this.rank) {
            throw new IllegalArgumentException("illegal reduce dim " + dim);
        }
        if (this.shape[dim] != 1) {
            throw new IllegalArgumentException("illegal reduce dim " + dim + " : length != 1");
        }
        Section curr = new Section(this.shape);
        Section want = curr.removeRange(dim);
        return new IndexConstant(want.getShape());
    }

    @Override
    Index transpose(int index1, int index2) {
        return this;
    }

    @Override
    Index permute(int[] dims) {
        return this;
    }

    @Override
    public boolean isFastIterator() {
        return false;
    }

    @Override
    IndexIterator getIndexIterator(Array maa) {
        return new IteratorConstant(this.size, maa);
    }

    private static class IteratorConstant
    implements IndexIterator {
        private int currElement = -1;
        private final Array maa;
        private long size;
        private Index counter = null;

        IteratorConstant(long size, Array maa) {
            this.size = size;
            this.maa = maa;
        }

        @Override
        public boolean hasNext() {
            return (long)this.currElement < this.size - 1L;
        }

        public boolean hasMore(int howMany) {
            return (long)this.currElement < this.size - (long)howMany;
        }

        public String toString() {
            if (this.counter == null) {
                this.counter = new Index(this.maa.getShape());
            }
            this.counter.setCurrentCounter(this.currElement);
            return this.counter.toString();
        }

        @Override
        public int[] getCurrentCounter() {
            if (this.counter == null) {
                this.counter = new Index(this.maa.getShape());
            }
            this.counter.setCurrentCounter(this.currElement);
            return this.counter.current;
        }

        @Override
        public double getDoubleCurrent() {
            return this.maa.getDouble(0);
        }

        @Override
        public double getDoubleNext() {
            ++this.currElement;
            return this.maa.getDouble(0);
        }

        @Override
        public void setDoubleCurrent(double val) {
            this.maa.setDouble(0, val);
        }

        @Override
        public void setDoubleNext(double val) {
            ++this.currElement;
            this.maa.setDouble(0, val);
        }

        @Override
        public float getFloatCurrent() {
            return this.maa.getFloat(this.currElement);
        }

        @Override
        public float getFloatNext() {
            ++this.currElement;
            return this.maa.getFloat(0);
        }

        @Override
        public void setFloatCurrent(float val) {
            this.maa.setFloat(this.currElement, val);
        }

        @Override
        public void setFloatNext(float val) {
            ++this.currElement;
            this.maa.setFloat(0, val);
        }

        @Override
        public long getLongCurrent() {
            return this.maa.getLong(this.currElement);
        }

        @Override
        public long getLongNext() {
            ++this.currElement;
            return this.maa.getLong(0);
        }

        @Override
        public void setLongCurrent(long val) {
            this.maa.setLong(this.currElement, val);
        }

        @Override
        public void setLongNext(long val) {
            ++this.currElement;
            this.maa.setLong(0, val);
        }

        @Override
        public int getIntCurrent() {
            return this.maa.getInt(this.currElement);
        }

        @Override
        public int getIntNext() {
            ++this.currElement;
            return this.maa.getInt(0);
        }

        @Override
        public void setIntCurrent(int val) {
            this.maa.setInt(this.currElement, val);
        }

        @Override
        public void setIntNext(int val) {
            ++this.currElement;
            this.maa.setInt(0, val);
        }

        @Override
        public short getShortCurrent() {
            return this.maa.getShort(this.currElement);
        }

        @Override
        public short getShortNext() {
            ++this.currElement;
            return this.maa.getShort(0);
        }

        @Override
        public void setShortCurrent(short val) {
            this.maa.setShort(this.currElement, val);
        }

        @Override
        public void setShortNext(short val) {
            ++this.currElement;
            this.maa.setShort(0, val);
        }

        @Override
        public byte getByteCurrent() {
            return this.maa.getByte(this.currElement);
        }

        @Override
        public byte getByteNext() {
            ++this.currElement;
            return this.maa.getByte(0);
        }

        @Override
        public void setByteCurrent(byte val) {
            this.maa.setByte(this.currElement, val);
        }

        @Override
        public void setByteNext(byte val) {
            ++this.currElement;
            this.maa.setByte(0, val);
        }

        @Override
        public char getCharCurrent() {
            return this.maa.getChar(this.currElement);
        }

        @Override
        public char getCharNext() {
            ++this.currElement;
            return this.maa.getChar(0);
        }

        @Override
        public void setCharCurrent(char val) {
            this.maa.setChar(this.currElement, val);
        }

        @Override
        public void setCharNext(char val) {
            ++this.currElement;
            this.maa.setChar(0, val);
        }

        @Override
        public boolean getBooleanCurrent() {
            return this.maa.getBoolean(this.currElement);
        }

        @Override
        public boolean getBooleanNext() {
            ++this.currElement;
            return this.maa.getBoolean(0);
        }

        @Override
        public void setBooleanCurrent(boolean val) {
            this.maa.setBoolean(this.currElement, val);
        }

        @Override
        public void setBooleanNext(boolean val) {
            ++this.currElement;
            this.maa.setBoolean(0, val);
        }

        @Override
        public String getStringCurrent() {
            return this.maa.getString(this.currElement);
        }

        @Override
        public String getStringNext() {
            ++this.currElement;
            return this.maa.getString(0);
        }

        @Override
        public void setStringCurrent(String val) {
            this.maa.setString(this.currElement, val);
        }

        @Override
        public void setStringNext(String val) {
            ++this.currElement;
            this.maa.setString(0, val);
        }

        @Override
        public Complex getComplexCurrent() {
            return this.maa.getComplex(this.currElement);
        }

        @Override
        public Complex getComplexNext() {
            ++this.currElement;
            return this.maa.getComplex(0);
        }

        @Override
        public void setComplexCurrent(Complex val) {
            this.maa.setComplex(this.currElement, val);
        }

        @Override
        public void setComplexNext(Complex val) {
            ++this.currElement;
            this.maa.setComplex(0, val);
        }

        @Override
        public LocalDateTime getDateCurrent() {
            return this.maa.getDate(this.currElement);
        }

        @Override
        public LocalDateTime getDateNext() {
            ++this.currElement;
            return this.maa.getDate(0);
        }

        @Override
        public void setDateCurrent(LocalDateTime val) {
            this.maa.setDate(this.currElement, val);
        }

        @Override
        public void setDateNext(LocalDateTime val) {
            ++this.currElement;
            this.maa.setDate(0, val);
        }

        @Override
        public Object getObjectCurrent() {
            return this.maa.getObject(this.currElement);
        }

        @Override
        public Object getObjectNext() {
            ++this.currElement;
            return this.maa.getObject(0);
        }

        @Override
        public void setObjectCurrent(Object val) {
            this.maa.setObject(this.currElement, val);
        }

        @Override
        public void setObjectNext(Object val) {
            ++this.currElement;
            this.maa.setObject(0, val);
        }

        @Override
        public Object next() {
            ++this.currElement;
            return this.maa.getObject(0);
        }
    }
}

