/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray;

import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.ArrayChar;
import org.meteoinfo.ndarray.ArraySequence;
import org.meteoinfo.ndarray.ArrayStructureBak;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.StructureData;
import org.meteoinfo.ndarray.StructureMembers;
import org.meteoinfo.util.Indent;

public class StructureDataW
extends StructureData {
    protected final Map<StructureMembers.Member, Array> memberData;

    public StructureDataW(StructureMembers members) {
        super(members);
        this.memberData = new HashMap<StructureMembers.Member, Array>(2 * members.getMembers().size());
    }

    public StructureDataW(StructureMembers members, int size) {
        super(members);
        this.memberData = new HashMap<StructureMembers.Member, Array>(2 * size);
    }

    public void setMemberData(StructureMembers.Member m, Array data) {
        if (data == null) {
            throw new IllegalArgumentException("data cant be null");
        }
        this.memberData.put(m, data);
    }

    public void setMemberData(String memberName, Array data) {
        StructureMembers.Member m = this.members.findMember(memberName);
        if (m == null) {
            throw new IllegalArgumentException("illegal member name =" + memberName);
        }
        this.setMemberData(m, data);
    }

    @Override
    public Array getArray(StructureMembers.Member m) {
        if (m == null) {
            throw new IllegalArgumentException("member is null");
        }
        return this.memberData.get(m);
    }

    @Override
    public float convertScalarFloat(StructureMembers.Member m) {
        return this.getScalarFloat(m);
    }

    @Override
    public double convertScalarDouble(StructureMembers.Member m) {
        return this.getScalarDouble(m);
    }

    @Override
    public int convertScalarInt(StructureMembers.Member m) {
        return this.getScalarInt(m);
    }

    @Override
    public long convertScalarLong(StructureMembers.Member m) {
        return this.getScalarLong(m);
    }

    @Override
    public double getScalarDouble(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getDouble(Index.scalarIndexImmutable);
    }

    @Override
    public double[] getJavaArrayDouble(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (double[])data.getStorage();
    }

    @Override
    public float getScalarFloat(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getFloat(Index.scalarIndexImmutable);
    }

    @Override
    public float[] getJavaArrayFloat(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (float[])data.getStorage();
    }

    @Override
    public byte getScalarByte(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getByte(Index.scalarIndexImmutable);
    }

    @Override
    public byte[] getJavaArrayByte(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (byte[])data.getStorage();
    }

    @Override
    public int getScalarInt(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getInt(Index.scalarIndexImmutable);
    }

    @Override
    public int[] getJavaArrayInt(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (int[])data.getStorage();
    }

    @Override
    public short getScalarShort(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getShort(Index.scalarIndexImmutable);
    }

    @Override
    public short[] getJavaArrayShort(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (short[])data.getStorage();
    }

    @Override
    public long getScalarLong(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getLong(Index.scalarIndexImmutable);
    }

    @Override
    public long[] getJavaArrayLong(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (long[])data.getStorage();
    }

    @Override
    public char getScalarChar(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return data.getChar(Index.scalarIndexImmutable);
    }

    @Override
    public char[] getJavaArrayChar(StructureMembers.Member m) {
        Array data = this.getArray(m);
        return (char[])data.getStorage();
    }

    @Override
    public String getScalarString(StructureMembers.Member m) {
        int count;
        if (m.getDataType() == DataType.STRING) {
            Array data = this.getArray(m);
            if (data == null) {
                data = this.getArray(m);
            }
            return (String)data.getObject(0);
        }
        char[] ba = this.getJavaArrayChar(m);
        for (count = 0; count < ba.length && '\u0000' != ba[count]; ++count) {
        }
        return new String(ba, 0, count);
    }

    @Override
    public String[] getJavaArrayString(StructureMembers.Member m) {
        if (m.getDataType() == DataType.STRING) {
            Array data = this.getArray(m);
            int n = m.getSize();
            String[] result = new String[n];
            for (int i = 0; i < result.length; ++i) {
                result[i] = (String)data.getObject(i);
            }
            return result;
        }
        if (m.getDataType() == DataType.CHAR) {
            ArrayChar data = (ArrayChar)this.getArray(m);
            ArrayChar.StringIterator iter = data.getStringIterator();
            String[] result = new String[iter.getNumElems()];
            int count = 0;
            while (iter.hasNext()) {
                result[count++] = iter.next();
            }
            return result;
        }
        throw new IllegalArgumentException("getJavaArrayString: not String DataType :" + (Object)((Object)m.getDataType()));
    }

    @Override
    public StructureData getScalarStructure(StructureMembers.Member m) {
        ArrayStructureBak data = (ArrayStructureBak)this.getArray(m);
        return data.getStructureData(0);
    }

    @Override
    public ArrayStructureBak getArrayStructure(StructureMembers.Member m) {
        return (ArrayStructureBak)this.getArray(m);
    }

    @Override
    public ArraySequence getArraySequence(StructureMembers.Member m) {
        return (ArraySequence)this.getArray(m);
    }

    @Override
    public void showInternal(Formatter f, Indent indent) {
        super.showInternal(f, indent);
        for (StructureMembers.Member m : this.memberData.keySet()) {
            Array data = this.memberData.get(m);
            f.format("%s %s = %s%n", indent, m, data);
        }
    }
}

