/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.projection;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.mapdata.Field;
import org.meteoinfo.geoprocess.GeoComputation;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.layer.RasterLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.map.ProjectionSet;
import org.meteoinfo.math.ArrayUtil;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.Reproject;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.shape.CircleShape;
import org.meteoinfo.shape.CurveLineShape;
import org.meteoinfo.shape.CurvePolygonShape;
import org.meteoinfo.shape.EllipseShape;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.GraphicCollection;
import org.meteoinfo.shape.PointShape;
import org.meteoinfo.shape.Polygon;
import org.meteoinfo.shape.PolygonShape;
import org.meteoinfo.shape.Polyline;
import org.meteoinfo.shape.PolylineShape;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.shape.StationModelShape;
import org.meteoinfo.shape.WindArrow;
import org.meteoinfo.shape.WindBarb;
import org.meteoinfo.table.DataColumn;
import org.meteoinfo.table.DataRow;
import org.meteoinfo.table.DataTable;

public class ProjectionUtil {
    public static Extent getProjectionGlobalExtent(ProjectionInfo toProj) {
        ProjectionInfo fromProj = KnownCoordinateSystems.geographic.world.WGS1984;
        double minX = Double.NaN;
        double minY = Double.NaN;
        double maxX = Double.NaN;
        double maxY = Double.NaN;
        int si = -90;
        int ei = 90;
        switch (toProj.getProjectionName()) {
            case Lambert_Conformal_Conic: {
                si = -80;
                break;
            }
            case North_Polar_Stereographic_Azimuthal: {
                si = 0;
                break;
            }
            case South_Polar_Stereographic_Azimuthal: {
                ei = 0;
            }
        }
        for (int i = si; i <= ei; ++i) {
            double y = i;
            for (int j = -180; j <= 180; ++j) {
                double x = i;
                double[][] points = new double[][]{{x, y}};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                    x = points[0][0];
                    y = points[0][1];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    if (Double.isNaN(minX)) {
                        minX = x;
                        minY = y;
                    } else {
                        if (x < minX) {
                            minX = x;
                        }
                        if (y < minY) {
                            minY = y;
                        }
                    }
                    if (Double.isNaN(maxX)) {
                        maxX = x;
                        maxY = y;
                        continue;
                    }
                    if (x > maxX) {
                        maxX = x;
                    }
                    if (!(y > maxY)) continue;
                    maxY = y;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Extent aExtent = new Extent();
        aExtent.minX = minX;
        aExtent.maxX = maxX;
        aExtent.minY = minY;
        aExtent.maxY = maxY;
        return aExtent;
    }

    public static Extent getProjectionExtent(ProjectionInfo fromProj, ProjectionInfo toProj, List<Number> x, List<Number> y) {
        int i;
        double[] X = new double[x.size()];
        double[] Y = new double[y.size()];
        for (i = 0; i < X.length; ++i) {
            X[i] = x.get(i).doubleValue();
        }
        for (i = 0; i < Y.length; ++i) {
            Y[i] = y.get(i).doubleValue();
        }
        return ProjectionUtil.getProjectionExtent(fromProj, toProj, X, Y);
    }

    public static Extent getProjectionExtent(ProjectionInfo fromProj, ProjectionInfo toProj, Array x, Array y) {
        x = x.copyIfView();
        y = y.copyIfView();
        double[] X = (double[])ArrayUtil.copyToNDJavaArray_Double(x);
        double[] Y = (double[])ArrayUtil.copyToNDJavaArray_Double(y);
        return ProjectionUtil.getProjectionExtent(fromProj, toProj, X, Y);
    }

    public static Extent getProjectionExtent(ProjectionInfo fromProj, ProjectionInfo toProj, double[] X, double[] Y) {
        double y;
        double x;
        double[][] points;
        int j;
        int i;
        double minX = Double.NaN;
        double minY = Double.NaN;
        double maxX = Double.NaN;
        double maxY = Double.NaN;
        int minXI = X.length;
        int minYI = Y.length;
        int maxXI = -1;
        int maxYI = -1;
        block8: for (i = 0; i < Y.length; ++i) {
            for (j = 0; j < X.length; ++j) {
                points = new double[][]{{X[j], Y[i]}};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                    x = points[0][0];
                    y = points[0][1];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    if (Double.isNaN(minY)) {
                        minY = y;
                        minYI = i;
                    }
                    if (i == minYI) {
                        if (!(y < minY)) continue;
                        minY = y;
                        continue;
                    }
                    if (i <= minYI) continue;
                    continue block8;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        block10: for (i = Y.length - 1; i >= 0; --i) {
            for (j = 0; j < X.length; ++j) {
                points = new double[][]{{X[j], Y[i]}};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                    x = points[0][0];
                    y = points[0][1];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    if (Double.isNaN(maxY)) {
                        maxY = y;
                        maxYI = i;
                    }
                    if (i == maxYI) {
                        if (!(y > maxY)) continue;
                        maxY = y;
                        continue;
                    }
                    if (i >= maxYI) continue;
                    continue block10;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        block12: for (j = 0; j < X.length; ++j) {
            for (i = 0; i < Y.length; ++i) {
                points = new double[][]{{X[j], Y[i]}};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                    x = points[0][0];
                    y = points[0][1];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    if (Double.isNaN(minX)) {
                        minX = x;
                        minXI = j;
                    }
                    if (j == minXI) {
                        if (!(x < minX)) continue;
                        minX = x;
                        continue;
                    }
                    if (j <= minXI) continue;
                    continue block12;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        block14: for (j = X.length - 1; j >= 0; --j) {
            for (i = 0; i < Y.length; ++i) {
                points = new double[][]{{X[j], Y[i]}};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                    x = points[0][0];
                    y = points[0][1];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    if (Double.isNaN(maxX)) {
                        maxX = x;
                        maxXI = j;
                    }
                    if (j == maxXI) {
                        if (!(x > maxX)) continue;
                        maxX = x;
                        continue;
                    }
                    if (j >= maxXI) continue;
                    continue block14;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (Double.isNaN(minX)) {
            return null;
        }
        if (Double.isNaN(minY)) {
            return null;
        }
        if (Double.isNaN(maxX)) {
            return null;
        }
        if (Double.isNaN(maxY)) {
            return null;
        }
        if (toProj.isLonLat() && maxX < minX && maxX < 0.0) {
            maxX += 360.0;
        }
        Extent aExtent = new Extent();
        aExtent.minX = minX;
        aExtent.maxX = maxX;
        aExtent.minY = minY;
        aExtent.maxY = maxY;
        return aExtent;
    }

    public static Extent getProjectionExtent_bak2(ProjectionInfo fromProj, ProjectionInfo toProj, double[] X, double[] Y) {
        double minX = Double.NaN;
        double minY = Double.NaN;
        double maxX = Double.NaN;
        double maxY = Double.NaN;
        for (int i = 0; i < Y.length; ++i) {
            for (int j = 0; j < X.length; ++j) {
                double[][] points = new double[][]{{X[j], Y[i]}};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                    double x = points[0][0];
                    double y = points[0][1];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    if (Double.isNaN(minX)) {
                        minX = x;
                        minY = y;
                        maxX = x;
                        maxY = y;
                        continue;
                    }
                    if (x < minX) {
                        minX = x;
                    } else if (x > maxX) {
                        maxX = x;
                    }
                    if (y < minY) {
                        minY = y;
                        continue;
                    }
                    if (!(y > maxY)) continue;
                    maxY = y;
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        Extent aExtent = new Extent();
        aExtent.minX = minX;
        aExtent.maxX = maxX;
        aExtent.minY = minY;
        aExtent.maxY = maxY;
        return aExtent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Extent getProjectionExtent_bak(ProjectionInfo fromProj, ProjectionInfo toProj, double[] X, double[] Y) {
        double y;
        double x;
        int i;
        double minX = Double.NaN;
        double minY = Double.NaN;
        double maxX = Double.NaN;
        double maxY = Double.NaN;
        block18: for (i = 0; i < Y.length; ++i) {
            double[][] points;
            block34: {
                switch (toProj.getProjectionName()) {
                    case Lambert_Conformal_Conic: {
                        if (!(Y[i] < -80.0)) break;
                        continue block18;
                    }
                    case North_Polar_Stereographic_Azimuthal: {
                        if (!(Y[i] < 0.0)) break;
                        continue block18;
                    }
                    case South_Polar_Stereographic_Azimuthal: {
                        if (Y[i] > 0.0) continue block18;
                    }
                }
                points = new double[][]{{X[0], Y[i]}};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                    x = points[0][0];
                    y = points[0][1];
                    if (Double.isNaN(x) || Double.isNaN(y)) continue;
                    if (Double.isNaN(minX)) {
                        minX = x;
                        minY = y;
                        break block34;
                    }
                    if (x < minX) {
                        minX = x;
                    }
                    if (!(y < minY)) break block34;
                    minY = y;
                }
                catch (Exception e) {
                    continue;
                }
            }
            points[0] = new double[]{X[X.length - 1], Y[i]};
            try {
                Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                x = points[0][0];
                y = points[0][1];
                if (Double.isNaN(x) || Double.isNaN(y)) continue;
                if (Double.isNaN(maxX)) {
                    maxY = y;
                    maxX = x;
                    continue;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (!(y > maxY)) continue;
                maxY = y;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int yIdx = 0;
        int eyIdx = Y.length - 1;
        block9 : switch (toProj.getProjectionName()) {
            case Lambert_Conformal_Conic: {
                for (i = 0; i < Y.length; ++i) {
                    if (!(Y[i] >= -80.0)) continue;
                    yIdx = i;
                    break block9;
                }
                break;
            }
            case North_Polar_Stereographic_Azimuthal: {
                for (i = 0; i < Y.length; ++i) {
                    if (!(Y[i] >= 0.0)) continue;
                    yIdx = i;
                    break block9;
                }
                break;
            }
            case South_Polar_Stereographic_Azimuthal: {
                for (i = 0; i < Y.length; ++i) {
                    if (!(Y[i] > 0.0)) continue;
                    eyIdx = i - 1;
                    break block9;
                }
                break;
            }
        }
        if (eyIdx < 0) {
            eyIdx = 0;
        }
        i = 0;
        while (true) {
            block35: {
                double[][] points;
                block36: {
                    if (i >= X.length) {
                        Extent aExtent = new Extent();
                        aExtent.minX = minX;
                        aExtent.maxX = maxX;
                        aExtent.minY = minY;
                        aExtent.maxY = maxY;
                        return aExtent;
                    }
                    points = new double[][]{{X[i], Y[yIdx]}};
                    try {
                        Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                        x = points[0][0];
                        y = points[0][1];
                        if (Double.isNaN(x) || Double.isNaN(y)) break block35;
                        if (Double.isNaN(minX)) {
                            minX = x;
                            minY = y;
                            break block36;
                        }
                        if (x < minX) {
                            minX = x;
                        }
                        if (!(y < minY)) break block36;
                        minY = y;
                    }
                    catch (Exception e) {
                        break block35;
                    }
                }
                points[0] = new double[]{X[i], Y[eyIdx]};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, 1);
                    x = points[0][0];
                    y = points[0][1];
                    if (Double.isNaN(x) || Double.isNaN(y)) break block35;
                    if (Double.isNaN(maxX)) {
                        maxX = x;
                        maxY = y;
                        break block35;
                    }
                    if (x > maxX) {
                        maxX = x;
                    }
                    if (y > maxY) {
                        maxY = y;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public static void projectLayer(VectorLayer oLayer, ProjectionInfo toProj) {
        double refLon = toProj.getCoordinateReferenceSystem().getProjection().getProjectionLongitudeDegrees();
        if ((refLon += 180.0) > 180.0) {
            refLon -= 360.0;
        } else if (refLon < -180.0) {
            refLon += 360.0;
        }
        ProjectionUtil.projectLayer(oLayer, toProj, refLon, true);
    }

    public static void projectLayer(VectorLayer oLayer, ProjectionInfo toProj, boolean projectLabels) {
        double refLon = toProj.getCoordinateReferenceSystem().getProjection().getProjectionLongitudeDegrees();
        if ((refLon += 180.0) > 180.0) {
            refLon -= 360.0;
        } else if (refLon < -180.0) {
            refLon += 360.0;
        }
        ProjectionUtil.projectLayer(oLayer, toProj, refLon, projectLabels);
    }

    public static void projectLayer(VectorLayer oLayer, ProjectionInfo toProj, double refCutLon) {
        ProjectionUtil.projectLayer(oLayer, toProj, refCutLon, true);
    }

    /*
     * Unable to fully structure code
     */
    public static void projectLayer(VectorLayer oLayer, ProjectionInfo toProj, double refCutLon, boolean projectLabels) {
        fromProj = oLayer.getProjInfo();
        if (fromProj.equals(toProj)) {
            if (oLayer.isProjected()) {
                oLayer.getOriginData();
            }
            return;
        }
        if (oLayer.isProjected()) {
            oLayer.getOriginData();
        } else {
            oLayer.updateOriginData();
        }
        refLon = refCutLon;
        if (oLayer.getExtent().maxX > 180.0 && oLayer.getExtent().minX > refLon) {
            refLon += 360.0;
        }
        newPoints = new ArrayList<PointD>();
        lExtent = new Extent();
        aTable = new DataTable();
        for (DataColumn aDC : oLayer.getAttributeTable().getTable().getColumns()) {
            bDC = new Field(aDC.getColumnName(), aDC.getDataType());
            aTable.getColumns().add(bDC);
        }
        cutoff = toProj.getCutoff();
        switch (1.$SwitchMap$org$meteoinfo$shape$ShapeTypes[oLayer.getShapeType().ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                shapePoints = new ArrayList<PointShape>();
                newPoints.clear();
                block31: for (s = 0; s < oLayer.getShapeNum(); ++s) {
                    aPS = (PointShape)oLayer.getShapes().get(s);
                    if (fromProj.getProjectionName() != ProjectionNames.LongLat) ** GOTO lbl-1000
                    switch (1.$SwitchMap$org$meteoinfo$projection$ProjectionNames[toProj.getProjectionName().ordinal()]) {
                        case 1: {
                            if (aPS.getPoint().Y < (double)cutoff) {
                                continue block31;
                            }
                            ** GOTO lbl44
                        }
                        case 2: {
                            if (aPS.getPoint().Y < (double)cutoff) {
                                continue block31;
                            }
                            ** GOTO lbl44
                        }
                        case 3: {
                            if (aPS.getPoint().Y > (double)cutoff) {
                                continue block31;
                            }
                            ** GOTO lbl44
                        }
                        case 4: {
                            if (aPS.getPoint().Y > (double)cutoff || aPS.getPoint().Y < (double)(-cutoff)) continue block31;
                        }
lbl44:
                        // 5 sources

                        default: lbl-1000:
                        // 2 sources

                        {
                            if ((aPS = ProjectionUtil.projectPointShape(aPS, fromProj, toProj)) == null) continue block31;
                            shapePoints.add(aPS);
                            newPoints.add(aPS.getPoint());
                            aDR = (DataRow)oLayer.getAttributeTable().getTable().getRows().get(s);
                            try {
                                aTable.addRow(aDR);
                                continue block31;
                            }
                            catch (Exception ex) {
                                Logger.getLogger(ProjectionSet.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                }
                oLayer.setShapes(new ArrayList<E>(shapePoints));
                oLayer.setExtent(MIMath.getPointsExtent(newPoints));
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                newPolylines = new ArrayList<PolylineShape>();
                for (s = 0; s < oLayer.getShapeNum(); ++s) {
                    aPLS = (PolylineShape)oLayer.getShapes().get(s);
                    plsList = new ArrayList<PolylineShape>();
                    if (fromProj.getProjectionName() == ProjectionNames.LongLat) {
                        switch (1.$SwitchMap$org$meteoinfo$projection$ProjectionNames[toProj.getProjectionName().ordinal()]) {
                            case 1: {
                                if (!(aPLS.getExtent().minY < (double)cutoff)) break;
                                aPLS = GeoComputation.clipPolylineShape_Lat(aPLS, cutoff, true);
                                break;
                            }
                            case 2: {
                                if (!(aPLS.getExtent().minY < (double)cutoff)) break;
                                aPLS = GeoComputation.clipPolylineShape_Lat(aPLS, cutoff, true);
                                break;
                            }
                            case 3: {
                                if (!(aPLS.getExtent().maxY > (double)cutoff)) break;
                                aPLS = GeoComputation.clipPolylineShape_Lat(aPLS, cutoff, false);
                                break;
                            }
                            case 4: {
                                if (aPLS.getExtent().maxY > (double)cutoff) {
                                    aPLS = GeoComputation.clipPolylineShape_Lat(aPLS, cutoff, false);
                                }
                                if (!(aPLS.getExtent().minY < (double)(-cutoff))) break;
                                aPLS = GeoComputation.clipPolylineShape_Lat(aPLS, -cutoff, true);
                            }
                        }
                        if (aPLS == null) continue;
                        if (aPLS.getExtent().minX <= refLon && aPLS.getExtent().maxX >= refLon) {
                            switch (1.$SwitchMap$org$meteoinfo$projection$ProjectionNames[toProj.getProjectionName().ordinal()]) {
                                case 2: 
                                case 3: {
                                    plsList.add(aPLS);
                                    break;
                                }
                                default: {
                                    plsList.add(GeoComputation.clipPolylineShape_Lon(aPLS, refLon));
                                    break;
                                }
                            }
                        } else {
                            plsList.add(aPLS);
                        }
                    } else {
                        plsList.add(aPLS);
                    }
                    for (i = 0; i < plsList.size(); ++i) {
                        aPLS = (PolylineShape)plsList.get(i);
                        if ((aPLS = ProjectionUtil.projectPolylineShape(aPLS, fromProj, toProj)) == null) continue;
                        newPolylines.add(aPLS);
                        aDR = (DataRow)oLayer.getAttributeTable().getTable().getRows().get(s);
                        try {
                            aTable.addRow(aDR);
                        }
                        catch (Exception ex) {
                            Logger.getLogger(ProjectionSet.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        lExtent = s == 0 && i == 0 ? (Extent)aPLS.getExtent().clone() : MIMath.getLagerExtent(lExtent, aPLS.getExtent());
                    }
                }
                oLayer.setShapes(new ArrayList<E>(newPolylines));
                newPolylines.clear();
                oLayer.setExtent(lExtent);
                break;
            }
            case 11: 
            case 12: {
                newPolygons = new ArrayList<PolygonShape>();
                for (s = 0; s < oLayer.getShapeNum(); ++s) {
                    aDR = (DataRow)oLayer.getAttributeTable().getTable().getRows().get(s);
                    aPGS = (PolygonShape)oLayer.getShapes().get(s);
                    pgsList = new ArrayList<PolygonShape>();
                    if (fromProj.getProjectionName() == ProjectionNames.LongLat) {
                        switch (1.$SwitchMap$org$meteoinfo$projection$ProjectionNames[toProj.getProjectionName().ordinal()]) {
                            case 1: {
                                if (!(aPGS.getExtent().minY < (double)cutoff)) break;
                                aPGS = GeoComputation.clipPolygonShape_Lat(aPGS, cutoff, true);
                                break;
                            }
                            case 2: {
                                if (!(aPGS.getExtent().minY < (double)cutoff)) break;
                                aPGS = GeoComputation.clipPolygonShape_Lat(aPGS, cutoff, true);
                                break;
                            }
                            case 3: {
                                if (!(aPGS.getExtent().maxY > (double)cutoff)) break;
                                aPGS = GeoComputation.clipPolygonShape_Lat(aPGS, cutoff, false);
                                break;
                            }
                            case 4: {
                                if (aPGS.getExtent().maxY > (double)cutoff) {
                                    aPGS = GeoComputation.clipPolygonShape_Lat(aPGS, cutoff, false);
                                }
                                if (!(aPGS.getExtent().minY < (double)(-cutoff))) break;
                                aPGS = GeoComputation.clipPolygonShape_Lat(aPGS, -cutoff, true);
                            }
                        }
                        if (aPGS == null) continue;
                        if (aPGS.getExtent().minX <= refLon && aPGS.getExtent().maxX >= refLon) {
                            pgsList.add(GeoComputation.clipPolygonShape_Lon(aPGS, refLon));
                        } else {
                            pgsList.add(aPGS);
                        }
                    } else {
                        pgsList.add(aPGS);
                    }
                    for (i = 0; i < pgsList.size(); ++i) {
                        aPGS = (PolygonShape)pgsList.get(i);
                        if ((aPGS = ProjectionUtil.projectPolygonShape(aPGS, fromProj, toProj)) == null) continue;
                        newPolygons.add(aPGS);
                        aTable.getRows().add(aDR);
                        lExtent = s == 0 ? (Extent)aPGS.getExtent().clone() : MIMath.getLagerExtent(lExtent, aPGS.getExtent());
                    }
                }
                oLayer.setShapes(new ArrayList<E>(newPolygons));
                newPolygons.clear();
                oLayer.setExtent(lExtent);
            }
        }
        oLayer.getAttributeTable().setTable(aTable);
        if (oLayer.getLabelPoints().size() > 0) {
            if (projectLabels) {
                oLayer.setLabelPoints(ProjectionUtil.projectGraphics(oLayer.getLabelPoints(), fromProj, toProj));
            } else {
                oLayer.setLabelPoints(new ArrayList<Graphic>(oLayer.getLabelPoints()));
            }
        }
    }

    public static void projectLayer(RasterLayer oLayer, ProjectionInfo toProj) {
        try {
            if (oLayer.getProjInfo().toProj4String().equals(toProj.toProj4String())) {
                if (oLayer.isProjected()) {
                    oLayer.getOriginData();
                    oLayer.updateGridData();
                    if (oLayer.getLegendScheme().getBreakNum() < 50) {
                        oLayer.updateImage();
                    } else {
                        oLayer.setPaletteByLegend();
                    }
                }
                return;
            }
            if (!oLayer.isProjected()) {
                oLayer.updateOriginData();
            } else {
                oLayer.getOriginData();
            }
            oLayer.setGridData(oLayer.getGridData().project(oLayer.getProjInfo(), toProj));
            oLayer.updateImage(oLayer.getLegendScheme());
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(ProjectionSet.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VectorLayer projectLayerAngle(VectorLayer oLayer, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<PointD> newPoints = new ArrayList<PointD>();
        VectorLayer aLayer = (VectorLayer)oLayer.clone();
        DataTable aTable = new DataTable();
        for (DataColumn aDC : oLayer.getAttributeTable().getTable().getColumns()) {
            Field bDC = new Field(aDC.getColumnName(), aDC.getDataType());
            aTable.getColumns().add(bDC);
        }
        ArrayList<PointShape> vectors = new ArrayList<PointShape>();
        newPoints.clear();
        int s = 0;
        while (true) {
            block15: {
                PointShape aPS;
                block14: {
                    if (s >= aLayer.getShapeNum()) {
                        aLayer.setShapes(new ArrayList(vectors));
                        aLayer.setExtent(MIMath.getPointsExtent(newPoints));
                        aLayer.getAttributeTable().setTable(aTable);
                        return aLayer;
                    }
                    aPS = (PointShape)aLayer.getShapes().get(s);
                    if (fromProj.getProjectionName() != ProjectionNames.LongLat) break block14;
                    switch (toProj.getProjectionName()) {
                        case Lambert_Conformal_Conic: 
                        case North_Polar_Stereographic_Azimuthal: {
                            if (!(aPS.getPoint().X < -89.0)) break;
                            break block15;
                        }
                        case South_Polar_Stereographic_Azimuthal: {
                            if (aPS.getPoint().Y > 89.0) break block15;
                        }
                    }
                }
                double[] fromP = new double[]{aPS.getPoint().X, aPS.getPoint().Y};
                double[][] points = new double[][]{(double[])fromP.clone()};
                try {
                    Reproject.reprojectPoints(points, toProj, fromProj, 0, points.length);
                    double[] toP = points[0];
                    switch (aLayer.getLayerDrawType()) {
                        case Vector: {
                            ((WindArrow)aPS).angle = ProjectionUtil.projectAngle(((WindArrow)aPS).angle, toP, fromP, fromProj, toProj);
                            break;
                        }
                        case Barb: {
                            ((WindBarb)aPS).angle = ProjectionUtil.projectAngle(((WindBarb)aPS).angle, toP, fromP, fromProj, toProj);
                            break;
                        }
                        case StationModel: {
                            ((StationModelShape)aPS).windBarb.angle = ProjectionUtil.projectAngle(((StationModelShape)aPS).windBarb.angle, toP, fromP, fromProj, toProj);
                            break;
                        }
                    }
                    newPoints.add(aPS.getPoint());
                    vectors.add(aPS);
                    DataRow aDR = (DataRow)oLayer.getAttributeTable().getTable().getRows().get(s);
                    aTable.getRows().add(aDR);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++s;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void projectWindLayer(VectorLayer oLayer, ProjectionInfo toProj, boolean IfReprojectAngle) {
        ProjectionInfo fromProj = oLayer.getProjInfo();
        if (fromProj.toProj4String().equals(toProj.toProj4String())) {
            if (oLayer.isProjected()) {
                oLayer.getOriginData();
            }
            return;
        }
        if (oLayer.isProjected()) {
            oLayer.getOriginData();
        } else {
            oLayer.updateOriginData();
        }
        double refLon = toProj.getRefCutLon();
        if (oLayer.getExtent().maxX > 180.0 && oLayer.getExtent().minX > refLon) {
            refLon += 360.0;
        }
        ArrayList<PointD> newPoints = new ArrayList<PointD>();
        DataTable aTable = new DataTable();
        for (DataColumn aDC : oLayer.getAttributeTable().getTable().getColumns()) {
            Field bDC = new Field(aDC.getColumnName(), aDC.getDataType());
            aTable.getColumns().add(bDC);
        }
        ArrayList<PointShape> shapes = new ArrayList<PointShape>();
        newPoints.clear();
        block12: for (int s = 0; s < oLayer.getShapeNum(); ++s) {
            PointShape aPS = (PointShape)oLayer.getShapes().get(s);
            if (fromProj.getProjectionName() == ProjectionNames.LongLat) {
                switch (toProj.getProjectionName()) {
                    case Lambert_Conformal_Conic: 
                    case North_Polar_Stereographic_Azimuthal: {
                        if (!(aPS.getPoint().Y < -89.0)) break;
                        continue block12;
                    }
                    case South_Polar_Stereographic_Azimuthal: {
                        if (aPS.getPoint().Y > 89.0) continue block12;
                    }
                }
            }
            double[] fromP = new double[]{aPS.getPoint().X, aPS.getPoint().Y};
            double[][] points = new double[][]{(double[])fromP.clone()};
            try {
                Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                double[] toP = points[0];
                PointD aPoint = new PointD();
                aPoint.X = (float)toP[0];
                aPoint.Y = (float)toP[1];
                aPS.setPoint(aPoint);
                if (IfReprojectAngle) {
                    switch (oLayer.getLayerDrawType()) {
                        case Vector: {
                            ((WindArrow)aPS).angle = ProjectionUtil.projectAngle(((WindArrow)aPS).angle, fromP, toP, fromProj, toProj);
                            break;
                        }
                        case Barb: {
                            ((WindBarb)aPS).angle = ProjectionUtil.projectAngle(((WindBarb)aPS).angle, fromP, toP, fromProj, toProj);
                            break;
                        }
                        case StationModel: {
                            ((StationModelShape)aPS).windBarb.angle = ProjectionUtil.projectAngle(((StationModelShape)aPS).windBarb.angle, fromP, toP, fromProj, toProj);
                            break;
                        }
                    }
                }
                newPoints.add(aPoint);
                shapes.add(aPS);
                DataRow aDR = (DataRow)oLayer.getAttributeTable().getTable().getRows().get(s);
                aTable.getRows().add(aDR);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        oLayer.setShapes(new ArrayList(shapes));
        oLayer.setExtent(MIMath.getPointsExtent(newPoints));
        oLayer.getAttributeTable().setTable(aTable);
        if (oLayer.getLabelPoints().size() > 0) {
            oLayer.setLabelPoints(ProjectionUtil.projectGraphics(oLayer.getLabelPoints(), fromProj, toProj));
        }
    }

    private static PointShape projectPointShape(PointShape aPS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        PointShape newPS = (PointShape)aPS.clone();
        double[][] points = new double[1][];
        PointD oP = newPS.getPoint();
        points[0] = new double[]{oP.X, oP.Y};
        double[] fromP = new double[]{oP.X, oP.Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (!Double.isNaN(points[0][0]) && !Double.isNaN(points[0][1])) {
                double[] toP = points[0];
                PointD rp = (PointD)oP.clone();
                rp.X = points[0][0];
                rp.Y = points[0][1];
                newPS.setPoint(rp);
                switch (aPS.getShapeType()) {
                    case WindBarb: {
                        ((WindBarb)newPS).angle = ProjectionUtil.projectAngle(((WindBarb)newPS).angle, fromP, toP, fromProj, toProj);
                        break;
                    }
                    case WindArraw: {
                        ((WindArrow)newPS).angle = ProjectionUtil.projectAngle(((WindArrow)newPS).angle, fromP, toP, fromProj, toProj);
                        break;
                    }
                    case StationModel: {
                        ((StationModelShape)newPS).windBarb.angle = ProjectionUtil.projectAngle(((StationModelShape)newPS).windBarb.angle, fromP, toP, fromProj, toProj);
                    }
                }
                return newPS;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static PolylineShape projectPolylineShape(PolylineShape aPLS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Polyline> polyLines = new ArrayList<Polyline>();
        for (int i = 0; i < aPLS.getPolylines().size(); ++i) {
            ArrayList<PointD> newPoints = new ArrayList<PointD>();
            Polyline aPL = aPLS.getPolylines().get(i);
            for (int j = 0; j < aPL.getPointList().size(); ++j) {
                double[][] points = new double[1][];
                PointD wPoint = aPL.getPointList().get(j);
                double x = wPoint.X;
                if (fromProj.isLonLat()) {
                    if (x > 180.0) {
                        x -= 360.0;
                    } else if (x < -180.0) {
                        x += 360.0;
                    }
                }
                points[0] = new double[]{x, wPoint.Y};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                    if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) continue;
                    wPoint.X = points[0][0];
                    wPoint.Y = points[0][1];
                    newPoints.add(wPoint);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            if (newPoints.size() <= 1) continue;
            Polyline bPL = new Polyline();
            bPL.setPointList(newPoints);
            polyLines.add(bPL);
        }
        if (polyLines.size() > 0) {
            aPLS.setPolylines(polyLines);
            return aPLS;
        }
        return null;
    }

    public static double projectAngle(double oAngle, double[] fromP1, double[] toP1, ProjectionInfo fromProj, ProjectionInfo toProj) {
        double pAngle = oAngle;
        double[][] points = new double[1][];
        if (fromP1[1] == 90.0) {
            double[] fromP2 = new double[]{fromP1[0], fromP1[1] - 10.0};
            points[0] = (double[])fromP2.clone();
            try {
                Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                double[] toP2 = points[0];
                double x = toP2[0] - toP1[0];
                double y = toP2[1] - toP1[1];
                double aLen = Math.sqrt(x * x + y * y);
                double angle = Math.asin(x / aLen) * 180.0 / Math.PI;
                if (x < 0.0 && y < 0.0) {
                    angle = 180.0 - angle;
                } else if (x > 0.0 && y < 0.0) {
                    angle = 180.0 - angle;
                } else if (x < 0.0 && y > 0.0) {
                    angle = 360.0 + angle;
                }
                if (aLen == 0.0) {
                    System.out.print("Error");
                }
                if ((pAngle = oAngle + (angle - 180.0)) > 360.0) {
                    pAngle -= 360.0;
                } else if (pAngle < 0.0) {
                    pAngle += 360.0;
                }
            }
            catch (Exception x) {}
        } else {
            double[] fromP2 = new double[]{fromP1[0] + 10.0, fromP1[1]};
            points[0] = (double[])fromP2.clone();
            try {
                Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                double[] toP2 = points[0];
                double x = toP2[0] - toP1[0];
                double y = toP2[1] - toP1[1];
                double aLen = Math.sqrt(x * x + y * y);
                if (aLen == 0.0) {
                    return pAngle;
                }
                double angle = Math.asin(x / aLen) * 180.0 / Math.PI;
                if (Double.isNaN(angle)) {
                    return pAngle;
                }
                if (x < 0.0 && y < 0.0) {
                    angle = 180.0 - angle;
                } else if (x > 0.0 && y < 0.0) {
                    angle = 180.0 - angle;
                } else if (x < 0.0 && y > 0.0) {
                    angle = 360.0 + angle;
                }
                pAngle = oAngle + (angle - 90.0);
                if (pAngle > 360.0) {
                    pAngle -= 360.0;
                } else if (pAngle < 0.0) {
                    pAngle += 360.0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pAngle;
    }

    public static PolygonShape projectPolygonShape(PolygonShape aPGS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < aPGS.getPolygons().size(); ++i) {
            Polygon aPG = aPGS.getPolygons().get(i);
            Polygon bPG = null;
            for (int r = 0; r < aPG.getRingNumber(); ++r) {
                List<? extends PointD> pList = aPG.getRings().get(r);
                ArrayList<PointD> newPoints = new ArrayList<PointD>();
                for (int j = 0; j < pList.size(); ++j) {
                    double[][] points = new double[1][];
                    PointD wPoint = pList.get(j);
                    points[0] = new double[]{wPoint.X, wPoint.Y};
                    try {
                        Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                        if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) continue;
                        wPoint = new PointD();
                        wPoint.X = points[0][0];
                        wPoint.Y = points[0][1];
                        newPoints.add(wPoint);
                        continue;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                if (r == 0) {
                    if (newPoints.size() <= 2) break;
                    bPG = new Polygon();
                    bPG.setOutLine(newPoints);
                    continue;
                }
                if (newPoints.size() <= 2) continue;
                bPG.addHole(newPoints);
            }
            if (bPG == null) continue;
            polygons.add(bPG);
        }
        if (polygons.size() > 0) {
            aPGS.setPolygons(polygons);
            return aPGS;
        }
        return null;
    }

    public static Graphic projectGraphic(Graphic graphic, ProjectionInfo fromProj, ProjectionInfo toProj) {
        Shape shape = ProjectionUtil.projectShape(graphic.getShape(), fromProj, toProj);
        return new Graphic(shape, graphic.getLegend());
    }

    private static GraphicCollection projectGraphics(GraphicCollection aGCollection, ProjectionInfo fromProj, ProjectionInfo toProj) {
        GraphicCollection newGCollection = new GraphicCollection();
        for (Graphic aGraphic : aGCollection.getGraphics()) {
            aGraphic.setShape(ProjectionUtil.projectShape(aGraphic.getShape(), fromProj, toProj));
            if (aGraphic.getShape() == null) continue;
            newGCollection.add(aGraphic);
        }
        return newGCollection;
    }

    private static List<Graphic> projectGraphics(List<Graphic> graphics, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Graphic> newGraphics = new ArrayList<Graphic>();
        for (Graphic aGraphic : graphics) {
            Shape aShape = ProjectionUtil.projectShape(aGraphic.getShape(), fromProj, toProj);
            if (aShape == null) continue;
            newGraphics.add(new Graphic(aShape, aGraphic.getLegend()));
        }
        return newGraphics;
    }

    private static Shape projectShape(Shape aShape, ProjectionInfo fromProj, ProjectionInfo toProj) {
        Shape newShape;
        switch (aShape.getShapeType()) {
            case Point: 
            case PointM: {
                newShape = ProjectionUtil.projectPointShape((PointShape)aShape, fromProj, toProj);
                break;
            }
            case Polyline: 
            case PolylineM: {
                newShape = ProjectionUtil.projectPolylineShape((PolylineShape)aShape, fromProj, toProj);
                break;
            }
            case CurveLine: {
                newShape = ProjectionUtil.projectCurvelineShape((CurveLineShape)aShape, fromProj, toProj);
                break;
            }
            case Polygon: 
            case PolygonM: 
            case Rectangle: {
                newShape = ProjectionUtil.projectPolygonShape((PolygonShape)aShape, fromProj, toProj);
                break;
            }
            case CurvePolygon: {
                newShape = ProjectionUtil.projectCurvePolygonShape((CurvePolygonShape)aShape, fromProj, toProj);
                break;
            }
            case Circle: {
                newShape = ProjectionUtil.projectCircleShape((CircleShape)aShape, fromProj, toProj);
                break;
            }
            case Ellipse: {
                newShape = ProjectionUtil.projectEllipseShape((EllipseShape)aShape, fromProj, toProj);
                break;
            }
            default: {
                newShape = null;
            }
        }
        return newShape;
    }

    private static CurveLineShape projectCurvelineShape(CurveLineShape aPLS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Polyline> polyLines = new ArrayList<Polyline>();
        for (int i = 0; i < aPLS.getPolylines().size(); ++i) {
            ArrayList<PointD> newPoints = new ArrayList<PointD>();
            Polyline aPL = aPLS.getPolylines().get(i);
            for (int j = 0; j < aPL.getPointList().size(); ++j) {
                double[][] points = new double[1][];
                PointD wPoint = aPL.getPointList().get(j);
                points[0] = new double[]{wPoint.X, wPoint.Y};
                try {
                    Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                    if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) continue;
                    wPoint = new PointD();
                    wPoint.X = points[0][0];
                    wPoint.Y = points[0][1];
                    newPoints.add(wPoint);
                    continue;
                }
                catch (Exception e) {
                    break;
                }
            }
            if (newPoints.size() <= 1) continue;
            Polyline bPL = new Polyline();
            bPL.setPointList(newPoints);
            polyLines.add(bPL);
        }
        if (polyLines.size() > 0) {
            aPLS.setPolylines(polyLines);
            return aPLS;
        }
        return null;
    }

    private static CurvePolygonShape projectCurvePolygonShape(CurvePolygonShape aPGS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int i = 0; i < aPGS.getPolygons().size(); ++i) {
            Polygon aPG = aPGS.getPolygons().get(i);
            Polygon bPG = null;
            for (int r = 0; r < aPG.getRingNumber(); ++r) {
                List<? extends PointD> pList = aPG.getRings().get(r);
                ArrayList<PointD> newPoints = new ArrayList<PointD>();
                for (int j = 0; j < pList.size(); ++j) {
                    double[][] points = new double[1][];
                    PointD wPoint = pList.get(j);
                    points[0] = new double[]{wPoint.X, wPoint.Y};
                    try {
                        Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
                        if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) continue;
                        wPoint = new PointD();
                        wPoint.X = points[0][0];
                        wPoint.Y = points[0][1];
                        newPoints.add(wPoint);
                        continue;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                if (r == 0) {
                    if (newPoints.size() <= 2) break;
                    bPG = new Polygon();
                    bPG.setOutLine(newPoints);
                    continue;
                }
                if (newPoints.size() <= 2) continue;
                bPG.addHole(newPoints);
            }
            if (bPG == null) continue;
            polygons.add(bPG);
        }
        if (polygons.size() > 0) {
            aPGS.setPolygons(polygons);
            return aPGS;
        }
        return null;
    }

    private static CircleShape projectCircleShape(CircleShape aCS, ProjectionInfo fromProj, ProjectionInfo toProj) {
        double radius = Math.abs(aCS.getPoints().get((int)1).X - aCS.getPoints().get((int)0).X);
        double[][] points = new double[1][];
        PointD centerPoint = new PointD(aCS.getPoints().get((int)0).X + radius, aCS.getPoints().get((int)0).Y);
        points[0] = new double[]{centerPoint.X, centerPoint.Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) {
                return null;
            }
            centerPoint.X = points[0][0];
            centerPoint.Y = points[0][1];
        }
        catch (Exception e) {
            return null;
        }
        points = new double[1][];
        PointD leftPoint = aCS.getPoints().get(0);
        points[0] = new double[]{leftPoint.X, leftPoint.Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) {
                return null;
            }
            leftPoint.X = points[0][0];
            leftPoint.Y = points[0][1];
        }
        catch (Exception e) {
            return null;
        }
        radius = Math.abs(centerPoint.X - leftPoint.X);
        ArrayList<PointD> newPoints = new ArrayList<PointD>();
        newPoints.add(new PointD(centerPoint.X - radius, centerPoint.Y));
        newPoints.add(new PointD(centerPoint.X, centerPoint.Y - radius));
        newPoints.add(new PointD(centerPoint.X + radius, centerPoint.Y));
        newPoints.add(new PointD(centerPoint.X, centerPoint.Y + radius));
        CircleShape newCS = new CircleShape();
        newCS.setPoints(newPoints);
        return newCS;
    }

    private static EllipseShape projectEllipseShape(EllipseShape aES, ProjectionInfo fromProj, ProjectionInfo toProj) {
        double xRadius = Math.abs(aES.getPoints().get((int)2).X - aES.getPoints().get((int)0).X) / 2.0;
        double yRadius = Math.abs(aES.getPoints().get((int)2).Y - aES.getPoints().get((int)0).Y) / 2.0;
        double[][] points = new double[1][];
        PointD centerPoint = new PointD(aES.getExtent().minX + xRadius, aES.getExtent().minY + yRadius);
        points[0] = new double[]{centerPoint.X, centerPoint.Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) {
                return null;
            }
            centerPoint.X = points[0][0];
            centerPoint.Y = points[0][1];
        }
        catch (Exception e) {
            return null;
        }
        points = new double[1][];
        PointD lbPoint = new PointD(aES.getExtent().minX, aES.getExtent().minY);
        points[0] = new double[]{lbPoint.X, lbPoint.Y};
        try {
            Reproject.reprojectPoints(points, fromProj, toProj, 0, points.length);
            if (Double.isNaN(points[0][0]) || Double.isNaN(points[0][1])) {
                return null;
            }
            lbPoint.X = points[0][0];
            lbPoint.Y = points[0][1];
        }
        catch (Exception e) {
            return null;
        }
        xRadius = Math.abs(centerPoint.X - lbPoint.X);
        yRadius = Math.abs(centerPoint.Y - lbPoint.Y);
        ArrayList<PointD> newPoints = new ArrayList<PointD>();
        newPoints.add(new PointD(centerPoint.X - xRadius, centerPoint.Y - yRadius));
        newPoints.add(new PointD(centerPoint.X - xRadius, centerPoint.Y + yRadius));
        newPoints.add(new PointD(centerPoint.X + xRadius, centerPoint.Y + yRadius));
        newPoints.add(new PointD(centerPoint.X + xRadius, centerPoint.Y - yRadius));
        EllipseShape newES = new EllipseShape();
        newES.setPoints(newPoints);
        return newES;
    }
}

