/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.shape;

import org.meteoinfo.global.PointD;
import org.meteoinfo.legend.ChartBreak;
import org.meteoinfo.shape.Graphic;
import org.meteoinfo.shape.PointShape;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ChartGraphic
extends Graphic {
    private PointD startPosition;

    public ChartGraphic() {
    }

    public ChartGraphic(PointShape shape, ChartBreak legend) {
        super(shape, legend);
        this.startPosition = (PointD)shape.getPoint().clone();
    }

    public PointD getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(PointD value) {
        this.startPosition = value;
    }

    public void setShape(PointShape aShape) {
        super.setShape(aShape);
        this.startPosition = (PointD)aShape.getPoint().clone();
    }

    @Override
    public void exportToXML(Document doc, Element parent) {
        Element graphic = doc.createElement("Graphic");
        this.addShape(doc, graphic, this.getShape());
        this.addLegend(doc, graphic, this.getLegend(), this.getShape().getShapeType());
        this.addStartPosition(doc, graphic, this.startPosition);
        parent.appendChild(graphic);
    }

    private void addStartPosition(Document doc, Element parent, PointD pos) {
        Element startPos = doc.createElement("StartPosition");
        Attr xAttr = doc.createAttribute("X");
        Attr yAttr = doc.createAttribute("Y");
        xAttr.setValue(String.valueOf(pos.X));
        yAttr.setValue(String.valueOf(pos.Y));
        startPos.setAttributeNode(xAttr);
        startPos.setAttributeNode(yAttr);
        parent.appendChild(startPos);
    }

    @Override
    public void importFromXML(Element graphicNode) {
        PointD sP;
        Node shape = graphicNode.getElementsByTagName("Shape").item(0);
        this.setShape((PointShape)this.loadShape(shape));
        Node legend = graphicNode.getElementsByTagName("Legend").item(0);
        this.setLegend(this.loadLegend(legend, this.getShape().getShapeType()));
        Node startPos = graphicNode.getElementsByTagName("StartPosition").item(0);
        if (startPos != null && (sP = this.loadStartPosition(startPos)) != null) {
            this.startPosition = sP;
        }
    }

    private PointD loadStartPosition(Node startPosNode) {
        PointD sP = null;
        try {
            double x = Double.parseDouble(startPosNode.getAttributes().getNamedItem("X").getNodeValue());
            double y = Double.parseDouble(startPosNode.getAttributes().getNamedItem("Y").getNodeValue());
            sP = new PointD(x, y);
        }
        catch (DOMException dOMException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return sP;
    }
}

