/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.shape;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.global.PointD;
import org.meteoinfo.global.PointF;

public class Polyline {
    private Extent _extent = new Extent();
    private List<? extends PointD> _pointList = new ArrayList<PointD>();

    public List<? extends PointD> getPointList() {
        return this._pointList;
    }

    public void setPointList(List<? extends PointD> points) {
        this._pointList = points;
        this._extent = MIMath.getPointsExtent(this._pointList);
    }

    public Extent getExtent() {
        return this._extent;
    }

    public void setPoints(PointF[] points) {
        ArrayList<? extends PointD> pointList = new ArrayList<PointD>();
        for (PointF aP : points) {
            pointList.add(new PointD(aP.X, aP.Y));
        }
        this._pointList = pointList;
        this._extent = MIMath.getPointsExtent(this._pointList);
    }

    public boolean isClosed() {
        PointD sPoint = this._pointList.get(0);
        PointD ePoint = this._pointList.get(this._pointList.size() - 1);
        return MIMath.doubleEquals(sPoint.X, ePoint.X) && MIMath.doubleEquals(sPoint.Y, ePoint.Y);
    }

    public double getLength() {
        double length = 0.0;
        for (int i = 0; i < this._pointList.size() - 1; ++i) {
            double dx = this._pointList.get((int)(i + 1)).X - this._pointList.get((int)i).X;
            double dy = this._pointList.get((int)(i + 1)).Y - this._pointList.get((int)i).Y;
            length += Math.sqrt(dx * dx + dy * dy);
        }
        return length;
    }

    public double[] getLengths() {
        double[] lengths = new double[this._pointList.size() - 1];
        for (int i = 0; i < this._pointList.size() - 1; ++i) {
            double dx = this._pointList.get((int)(i + 1)).X - this._pointList.get((int)i).X;
            double dy = this._pointList.get((int)(i + 1)).Y - this._pointList.get((int)i).Y;
            lengths[i] = Math.sqrt(dx * dx + dy * dy);
        }
        return lengths;
    }

    public List<double[]> getPositions(double aLen) {
        double length = this.getLength();
        int n = (int)(length / aLen);
        if (n <= 0) {
            return null;
        }
        ArrayList<double[]> pos = new ArrayList<double[]>();
        double[] lengths = this.getLengths();
        int idx = 0;
        double sLen = lengths[0];
        for (int i = 0; i < n; ++i) {
            double len = aLen * (double)(i + 1);
            for (int j = idx; j < lengths.length; ++j) {
                if (sLen > len) {
                    idx = j;
                    break;
                }
                sLen += lengths[j + 1];
            }
            PointD aPoint = this._pointList.get(idx);
            PointD bPoint = this._pointList.get(idx + 1);
            double x = aPoint.X + (bPoint.X - aPoint.X) * (lengths[idx] - (sLen - len)) / lengths[idx];
            double y = aPoint.Y + (bPoint.Y - aPoint.Y) * (lengths[idx] - (sLen - len)) / lengths[idx];
            double U = bPoint.X - aPoint.X;
            double V = bPoint.Y - aPoint.Y;
            double angle = Math.atan(V / U) * 180.0 / Math.PI;
            if (U < 0.0) {
                angle += 180.0;
            }
            double[] data = new double[]{x, y, angle};
            pos.add(data);
        }
        return pos;
    }
}

