/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.meteoinfo.desktop.forms;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.meteoinfo.desktop.config.PythonInteractiveInterpreter;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.console.JConsole;
import org.meteoinfo.desktop.codecomplete.JIntrospect;
import org.python.core.Py;

/**
 *
 * @author yaqiang
 */
public class FrmConsole extends javax.swing.JFrame {

    private FrmMain frmMain = null;

    /**
     * Creates new form FrmConsole
     *
     * @param parent
     */
    public FrmConsole(java.awt.Frame parent) {
        super();
        initComponents();
        this.setSize(600, 400);

        frmMain = (FrmMain) parent;

        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/MeteoInfo_1_16x16x8.png"));
        } catch (Exception e) {
        }
        this.setIconImage(image);
    }

    /**
     * Initialize console
     */
    public void InitializeConsole() {
        JConsole console = new JConsole();
        console.setLocale(Locale.getDefault());
        System.out.println(console.getFont());
        console.setPreferredSize(new Dimension(600, 400));
        console.println(new ImageIcon(this.getClass().getResource("/images/jython_small_c.png")));        

//        boolean isDebug = java.lang.management.ManagementFactory.getRuntimeMXBean().
//                getInputArguments().toString().contains("jdwp");
        String pluginPath = this.frmMain.getStartupPath() + File.separator + "plugins";
        List<String> jarfns = GlobalUtil.getFiles(pluginPath, ".jar");

        Py.getSystemState().setdefaultencoding("utf-8");
        PythonInteractiveInterpreter interp = new PythonInteractiveInterpreter(console);

        this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        try {
            interp.exec("import sys");
            //interp.exec("sys.path.append('" + path + "')");
            //interp.exec("from milab import *");
            //interp.exec("mipylib.miplot.isinteractive = True");
            interp.set("miapp", frmMain);
            for (String jarfn : jarfns) {
                interp.exec("sys.path.append('" + jarfn + "')");
            }
        } catch (Exception e) {
            e.printStackTrace();
            this.setCursor(Cursor.getDefaultCursor());
        }

        new Thread(interp).start();
        this.setCursor(Cursor.getDefaultCursor());
        JIntrospect nameComplete = new JIntrospect(interp);
        console.setNameCompletion(nameComplete);
        this.getContentPane().add(console, BorderLayout.CENTER);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(FrmConsole.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(FrmConsole.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(FrmConsole.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(FrmConsole.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the dialog */
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                FrmConsole dialog = new FrmConsole(new javax.swing.JFrame());
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
}
