/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop.forms;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.meteoinfo.data.mapdata.Field;
import org.meteoinfo.desktop.forms.FrmMain;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.shape.Shape;
import org.meteoinfo.table.DataRow;

public class FrmSelectByAttributes
extends JDialog {
    private final List<VectorLayer> _mapLayers;
    private VectorLayer _selectLayer;
    private String _selectField;
    private final FrmMain _frmMain;
    private ButtonGroup buttonGroup1;
    private JButton jButton_And;
    private JButton jButton_Clear;
    private JButton jButton_EQ;
    private JButton jButton_GE;
    private JButton jButton_GT;
    private JButton jButton_GetValues;
    private JButton jButton_LE;
    private JButton jButton_LT;
    private JButton jButton_NE;
    private JButton jButton_Not;
    private JButton jButton_Or;
    private JButton jButton_Select;
    private JCheckBox jCheckBox_OnlySelVisible;
    private JComboBox jComboBox_Layer;
    private JComboBox jComboBox_Method;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JList jList_Fields;
    private JList jList_UniqueValues;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField jTextField_QueryString;

    public FrmSelectByAttributes(Frame parent, boolean modal) {
        super(parent, modal);
        int i;
        this.initComponents();
        this._frmMain = (FrmMain)parent;
        this._mapLayers = new ArrayList<VectorLayer>();
        for (i = 0; i < this._frmMain.getMapDocument().getActiveMapFrame().getMapView().getLayerNum(); ++i) {
            MapLayer mLayer = (MapLayer)this._frmMain.getMapDocument().getActiveMapFrame().getMapView().getLayers().get(i);
            if (mLayer.getLayerType() != LayerTypes.VectorLayer) continue;
            VectorLayer aLayer = (VectorLayer)mLayer;
            this._mapLayers.add(aLayer);
        }
        this.jComboBox_Layer.removeAllItems();
        if (this._mapLayers.size() > 0) {
            for (i = 0; i < this._mapLayers.size(); ++i) {
                this.jComboBox_Layer.addItem(this._mapLayers.get(i).getLayerName());
            }
            this.jComboBox_Layer.setSelectedIndex(0);
        }
        this.jComboBox_Method.removeAllItems();
        this.jComboBox_Method.addItem("Create a new selection");
        this.jComboBox_Method.addItem("Add to current selection");
        this.jComboBox_Method.addItem("Remove from current selection");
        this.jComboBox_Method.addItem("Select from current selection");
        this.jComboBox_Method.setSelectedIndex(0);
    }

    private void get_Fields() {
        this.jList_Fields.removeAll();
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        for (int i = 0; i < this._selectLayer.getFieldNumber(); ++i) {
            listModel.addElement(this._selectLayer.getField(i).getColumnName());
        }
        this.jList_Fields.setModel(listModel);
        this.jList_Fields.setSelectionMode(0);
        this.jList_Fields.setSelectedIndex(0);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jComboBox_Layer = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBox_Method = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList_Fields = new JList();
        this.jLabel4 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jList_UniqueValues = new JList();
        this.jButton_EQ = new JButton();
        this.jButton_NE = new JButton();
        this.jButton_And = new JButton();
        this.jButton_GT = new JButton();
        this.jButton_GE = new JButton();
        this.jButton_Or = new JButton();
        this.jButton_LT = new JButton();
        this.jButton_LE = new JButton();
        this.jButton_Not = new JButton();
        this.jButton_GetValues = new JButton();
        this.jLabel5 = new JLabel();
        this.jTextField_QueryString = new JTextField();
        this.jButton_Select = new JButton();
        this.jButton_Clear = new JButton();
        this.jCheckBox_OnlySelVisible = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Select By Attribute");
        this.jLabel1.setText("Layer:");
        this.jComboBox_Layer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Layer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByAttributes.this.jComboBox_LayerActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Method:");
        this.jComboBox_Method.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel3.setText("Fields:");
        this.jList_Fields.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList_Fields.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmSelectByAttributes.this.jList_FieldsMouseClicked(evt);
            }
        });
        this.jList_Fields.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FrmSelectByAttributes.this.jList_FieldsValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList_Fields);
        this.jLabel4.setText("Unique Values:");
        this.jList_UniqueValues.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrmSelectByAttributes.this.jList_UniqueValuesMouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList_UniqueValues);
        this.jButton_EQ.setText("=");
        this.jButton_EQ.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByAttributes.this.jButton_EQActionPerformed(evt);
            }
        });
        this.jButton_NE.setText("<>");
        this.jButton_NE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByAttributes.this.jButton_NEActionPerformed(evt);
            }
        });
        this.jButton_And.setFont(new Font("Arial", 0, 12));
        this.jButton_And.setText("And");
        this.jButton_And.setPreferredSize(new Dimension(53, 27));
        this.jButton_And.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByAttributes.this.jButton_AndActionPerformed(evt);
            }
        });
        this.jButton_GT.setText(">");
        this.jButton_GT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByAttributes.this.jButton_GTActionPerformed(evt);
            }
        });
        this.jButton_GE.setText(">=");
        this.jButton_GE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByAttributes.this.jButton_GEActionPerformed(evt);
            }
        });
        this.jButton_Or.setFont(new Font("Arial", 0, 12));
        this.jButton_Or.setText("Or");
        this.jButton_Or.setPreferredSize(new Dimension(53, 27));
        this.jButton_Or.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByAttributes.this.jButton_OrActionPerformed(evt);
            }
        });
        this.jButton_LT.setText("<");
        this.jButton_LT.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByAttributes.this.jButton_LTActionPerformed(evt);
            }
        });
        this.jButton_LE.setText("<=");
        this.jButton_LE.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByAttributes.this.jButton_LEActionPerformed(evt);
            }
        });
        this.jButton_Not.setFont(new Font("Arial", 0, 12));
        this.jButton_Not.setText("Not");
        this.jButton_Not.setPreferredSize(new Dimension(53, 27));
        this.jButton_Not.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByAttributes.this.jButton_NotActionPerformed(evt);
            }
        });
        this.jButton_GetValues.setText("Get Values");
        this.jButton_GetValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByAttributes.this.jButton_GetValuesActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Select query string:");
        this.jButton_Select.setText("Select");
        this.jButton_Select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByAttributes.this.jButton_SelectActionPerformed(evt);
            }
        });
        this.jButton_Clear.setText("Clear");
        this.jButton_Clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSelectByAttributes.this.jButton_ClearActionPerformed(evt);
            }
        });
        this.jCheckBox_OnlySelVisible.setText("Only selection visible");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(116, Short.MAX_VALUE).addComponent(this.jButton_Select).addGap(74, 74, 74).addComponent(this.jButton_Clear).addGap(108, 108, 108)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jTextField_QueryString).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 126, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton_EQ, -1, -1, Short.MAX_VALUE).addComponent(this.jButton_GT, -1, -1, Short.MAX_VALUE).addComponent(this.jButton_LT)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton_NE, -1, -1, Short.MAX_VALUE).addComponent(this.jButton_GE, -1, -1, Short.MAX_VALUE).addComponent(this.jButton_LE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton_Or, -2, 52, -2).addComponent(this.jButton_Not, -2, -1, -2).addComponent(this.jButton_And, -2, -1, -2))).addComponent(this.jButton_GetValues)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_Layer, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_Method, 0, -1, Short.MAX_VALUE)))).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel4).addGap(21, 21, 21)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_OnlySelVisible).addComponent(this.jLabel5)).addGap(0, 0, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox_Layer, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBox_Method, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1).addComponent(this.jScrollPane2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_QueryString, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox_OnlySelVisible).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 27, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_Select).addComponent(this.jButton_Clear))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_EQ).addComponent(this.jButton_NE).addComponent(this.jButton_And, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_GT).addComponent(this.jButton_GE).addComponent(this.jButton_Or, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_LT).addComponent(this.jButton_LE).addComponent(this.jButton_Not, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jButton_GetValues).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        this.pack();
    }

    private void jComboBox_LayerActionPerformed(ActionEvent evt) {
        if (this.jComboBox_Layer.getItemCount() == 0) {
            return;
        }
        this._selectLayer = this._mapLayers.get(this.jComboBox_Layer.getSelectedIndex());
        this.get_Fields();
    }

    private void jList_FieldsValueChanged(ListSelectionEvent evt) {
        if (this.jList_Fields.getSelectedValue() == null) {
            return;
        }
        String selField = this.jList_Fields.getSelectedValue().toString();
        if (!selField.equals(this._selectField)) {
            this.jList_UniqueValues.removeAll();
            this.jList_UniqueValues.setEnabled(false);
            this.jButton_GetValues.setEnabled(true);
        }
        this._selectField = selField;
    }

    private void jButton_GetValuesActionPerformed(ActionEvent evt) {
        ArrayList<String> valueList = new ArrayList<String>();
        boolean isNumeric = MIMath.isNumeric((Field)this._selectLayer.getField(this._selectField));
        for (int i = 0; i < this._selectLayer.getAttributeTable().getTable().getRowCount(); ++i) {
            if (valueList.contains(this._selectLayer.getAttributeTable().getTable().getValue(i, this._selectField).toString())) continue;
            valueList.add(this._selectLayer.getAttributeTable().getTable().getValue(i, this._selectField).toString());
        }
        Collections.sort(valueList);
        this.jList_UniqueValues.setEnabled(true);
        DefaultListModel<String> listModel = new DefaultListModel<String>();
        if (isNumeric) {
            for (String vStr : valueList) {
                listModel.addElement(vStr);
            }
        } else {
            for (String vStr : valueList) {
                listModel.addElement("\"" + vStr + "\"");
            }
        }
        this.jList_UniqueValues.setModel(listModel);
        this.jList_UniqueValues.setSelectionMode(0);
        this.jButton_GetValues.setEnabled(false);
    }

    private void jButton_EQActionPerformed(ActionEvent evt) {
        this.jTextField_QueryString.setText(this.jTextField_QueryString.getText() + " = ");
    }

    private void jButton_NEActionPerformed(ActionEvent evt) {
        this.jTextField_QueryString.setText(this.jTextField_QueryString.getText() + " <> ");
    }

    private void jButton_GTActionPerformed(ActionEvent evt) {
        this.jTextField_QueryString.setText(this.jTextField_QueryString.getText() + " > ");
    }

    private void jButton_LTActionPerformed(ActionEvent evt) {
        this.jTextField_QueryString.setText(this.jTextField_QueryString.getText() + " < ");
    }

    private void jButton_GEActionPerformed(ActionEvent evt) {
        this.jTextField_QueryString.setText(this.jTextField_QueryString.getText() + " >= ");
    }

    private void jButton_LEActionPerformed(ActionEvent evt) {
        this.jTextField_QueryString.setText(this.jTextField_QueryString.getText() + " <= ");
    }

    private void jButton_AndActionPerformed(ActionEvent evt) {
        this.jTextField_QueryString.setText(this.jTextField_QueryString.getText() + " and ");
    }

    private void jButton_OrActionPerformed(ActionEvent evt) {
        this.jTextField_QueryString.setText(this.jTextField_QueryString.getText() + " or ");
    }

    private void jButton_NotActionPerformed(ActionEvent evt) {
        this.jTextField_QueryString.setText(this.jTextField_QueryString.getText() + " not ");
    }

    private void jList_FieldsMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.jTextField_QueryString.setText(this.jTextField_QueryString.getText() + this.jList_Fields.getSelectedValue().toString());
        }
    }

    private void jList_UniqueValuesMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.jTextField_QueryString.setText(this.jTextField_QueryString.getText() + this.jList_UniqueValues.getSelectedValue().toString());
        }
    }

    private void jButton_SelectActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        String expression = this.jTextField_QueryString.getText();
        boolean onlySelVisible = this.jCheckBox_OnlySelVisible.isSelected();
        List rows = this._selectLayer.getAttributeTable().getTable().select(expression);
        ArrayList<Integer> rowIdxs = new ArrayList<Integer>();
        for (DataRow row : rows) {
            rowIdxs.add(row.getRowIndex());
        }
        switch (this.jComboBox_Method.getSelectedIndex()) {
            case 0: {
                for (int i = 0; i < this._selectLayer.getShapeNum(); ++i) {
                    if (rowIdxs.contains(i)) {
                        ((Shape)this._selectLayer.getShapes().get(i)).setSelected(true);
                        continue;
                    }
                    ((Shape)this._selectLayer.getShapes().get(i)).setSelected(false);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this._selectLayer.getShapeNum(); ++i) {
                    if (!rowIdxs.contains(i)) continue;
                    ((Shape)this._selectLayer.getShapes().get(i)).setSelected(true);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this._selectLayer.getShapeNum(); ++i) {
                    if (!rowIdxs.contains(i)) continue;
                    ((Shape)this._selectLayer.getShapes().get(i)).setSelected(false);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this._selectLayer.getShapeNum(); ++i) {
                    if (!((Shape)this._selectLayer.getShapes().get(i)).isSelected() || rowIdxs.contains(i)) continue;
                    ((Shape)this._selectLayer.getShapes().get(i)).setSelected(false);
                }
                break;
            }
        }
        if (onlySelVisible) {
            for (Shape shape : this._selectLayer.getShapes()) {
                shape.setVisible(shape.isSelected());
            }
        }
        this._frmMain.refreshMap();
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButton_ClearActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this._selectLayer.clearSelectedShapes();
        for (Shape shape : this._selectLayer.getShapes()) {
            shape.setVisible(true);
        }
        this._frmMain.refreshMap();
        this.jTextField_QueryString.setText("");
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmSelectByAttributes.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmSelectByAttributes.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmSelectByAttributes.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmSelectByAttributes.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmSelectByAttributes dialog = new FrmSelectByAttributes((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

