/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop.forms;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.desktop.forms.FrmMain;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.map.MapView;

public class FrmConvexhull
extends JDialog {
    List<VectorLayer> _vLayers = new ArrayList<VectorLayer>();
    private final FrmMain _parent;
    private JButton jButton_Apply;
    private JCheckBox jCheckBox_IsMerge;
    private JCheckBox jCheckBox_SelFeatureOnly;
    private JComboBox jComboBox_SubjectLayer;
    private JLabel jLabel1;

    public FrmConvexhull(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        this._parent = (FrmMain)parent;
        this.initialize();
    }

    private void initialize() {
        MapView mapView = this._parent.getMapDocument().getActiveMapFrame().getMapView();
        this.jComboBox_SubjectLayer.removeAllItems();
        for (int i = 0; i < mapView.getLayerNum(); ++i) {
            MapLayer layer = (MapLayer)mapView.getLayers().get(i);
            if (layer.getLayerType() != LayerTypes.VectorLayer) continue;
            this._vLayers.add((VectorLayer)layer);
            this.jComboBox_SubjectLayer.addItem(layer.getLayerName());
        }
        if (this.jComboBox_SubjectLayer.getItemCount() > 0) {
            this.jComboBox_SubjectLayer.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox_SubjectLayer = new JComboBox();
        this.jCheckBox_SelFeatureOnly = new JCheckBox();
        this.jButton_Apply = new JButton();
        this.jCheckBox_IsMerge = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Convexhull");
        this.jLabel1.setText("Subject layer:");
        this.jComboBox_SubjectLayer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCheckBox_SelFeatureOnly.setText("Selected features only");
        this.jButton_Apply.setText("Apply");
        this.jButton_Apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmConvexhull.this.jButton_ApplyActionPerformed(evt);
            }
        });
        this.jCheckBox_IsMerge.setSelected(true);
        this.jCheckBox_IsMerge.setText("Create only one convexhull");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_SubjectLayer, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_IsMerge).addComponent(this.jCheckBox_SelFeatureOnly).addComponent(this.jLabel1)).addGap(0, 185, Short.MAX_VALUE))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButton_Apply, -2, 85, -2).addGap(149, 149, 149)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_SubjectLayer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox_SelFeatureOnly).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox_IsMerge).addGap(18, 18, 18).addComponent(this.jButton_Apply).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton_ApplyActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        VectorLayer fromLayer = this._vLayers.get(this.jComboBox_SubjectLayer.getSelectedIndex());
        boolean onlySel = this.jCheckBox_SelFeatureOnly.isSelected();
        boolean isMerge = this.jCheckBox_IsMerge.isSelected();
        VectorLayer newLayer = fromLayer.convexhull(onlySel, isMerge);
        newLayer.setLayerName("Convexhull_" + newLayer.getLayerName());
        this._parent.getMapDocument().getActiveMapFrame().addLayer((MapLayer)newLayer);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmConvexhull.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmConvexhull.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmConvexhull.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmConvexhull.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmConvexhull dialog = new FrmConvexhull(new FrmMain(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

