/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop.forms;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.data.meteodata.GridDataSetting;
import org.meteoinfo.geoprocess.analysis.InterpolationMethods;
import org.meteoinfo.geoprocess.analysis.InterpolationSetting;

public class FrmInterpolate
extends JDialog {
    private InterpolationSetting _interpSetting = new InterpolationSetting();
    private boolean _isOK = false;
    private JButton jButton_Cancel;
    private JButton jButton_OK;
    private JComboBox jComboBox_Methods;
    private JLabel jLabel_MaxX;
    private JLabel jLabel_MaxY;
    private JLabel jLabel_Method;
    private JLabel jLabel_MinNum;
    private JLabel jLabel_MinX;
    private JLabel jLabel_MinY;
    private JLabel jLabel_MissingValue;
    private JLabel jLabel_Radius;
    private JLabel jLabel_XNum;
    private JLabel jLabel_XSize;
    private JLabel jLabel_YNum;
    private JLabel jLabel_YSize;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField jTextField_MaxX;
    private JTextField jTextField_MaxY;
    private JTextField jTextField_MinNum;
    private JTextField jTextField_MinX;
    private JTextField jTextField_MinY;
    private JTextField jTextField_MissingValue;
    private JTextField jTextField_Radius;
    private JTextField jTextField_XNum;
    private JTextField jTextField_XSize;
    private JTextField jTextField_YNum;
    private JTextField jTextField_YSize;

    public FrmInterpolate(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel_MinX = new JLabel();
        this.jTextField_MinX = new JTextField();
        this.jLabel_MaxX = new JLabel();
        this.jTextField_MaxX = new JTextField();
        this.jLabel_MinY = new JLabel();
        this.jTextField_MinY = new JTextField();
        this.jLabel_MaxY = new JLabel();
        this.jTextField_MaxY = new JTextField();
        this.jLabel_XSize = new JLabel();
        this.jTextField_XSize = new JTextField();
        this.jLabel_YSize = new JLabel();
        this.jTextField_YSize = new JTextField();
        this.jLabel_XNum = new JLabel();
        this.jTextField_XNum = new JTextField();
        this.jLabel_YNum = new JLabel();
        this.jTextField_YNum = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel_Method = new JLabel();
        this.jComboBox_Methods = new JComboBox();
        this.jLabel_Radius = new JLabel();
        this.jTextField_Radius = new JTextField();
        this.jLabel_MinNum = new JLabel();
        this.jTextField_MinNum = new JTextField();
        this.jLabel_MissingValue = new JLabel();
        this.jTextField_MissingValue = new JTextField();
        this.jButton_OK = new JButton();
        this.jButton_Cancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Interpolate");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Output Grid Set"));
        this.jLabel_MinX.setText("minX:");
        this.jTextField_MinX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmInterpolate.this.jTextField_MinXActionPerformed(evt);
            }
        });
        this.jLabel_MaxX.setText("maxX:");
        this.jTextField_MaxX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmInterpolate.this.jTextField_MaxXActionPerformed(evt);
            }
        });
        this.jLabel_MinY.setText("minY:");
        this.jTextField_MinY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmInterpolate.this.jTextField_MinYActionPerformed(evt);
            }
        });
        this.jLabel_MaxY.setText("maxY:");
        this.jTextField_MaxY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmInterpolate.this.jTextField_MaxYActionPerformed(evt);
            }
        });
        this.jLabel_XSize.setText("XSize:");
        this.jTextField_XSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmInterpolate.this.jTextField_XSizeActionPerformed(evt);
            }
        });
        this.jLabel_YSize.setText("YSize:");
        this.jTextField_YSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmInterpolate.this.jTextField_YSizeActionPerformed(evt);
            }
        });
        this.jLabel_XNum.setText("XNum:");
        this.jTextField_XNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmInterpolate.this.jTextField_XNumActionPerformed(evt);
            }
        });
        this.jLabel_YNum.setText("YNum:");
        this.jTextField_YNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmInterpolate.this.jTextField_YNumActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_MinX, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_MinY, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_XSize, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_XNum, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField_MinX, -2, 87, -2).addComponent(this.jTextField_MinY, -2, 87, -2).addComponent(this.jTextField_XSize, -2, 87, -2).addComponent(this.jTextField_XNum, -2, 87, -2)).addGap(28, 28, 28).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_MaxX, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_MaxY, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_YSize, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_YNum, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField_MaxX, -2, 87, -2).addComponent(this.jTextField_MaxY, -2, 87, -2).addComponent(this.jTextField_YSize, -2, 87, -2).addComponent(this.jTextField_YNum, -2, 87, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_MinX).addComponent(this.jTextField_MinX, -2, -1, -2).addComponent(this.jLabel_MaxX).addComponent(this.jTextField_MaxX, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_MinY).addComponent(this.jTextField_MinY, -2, -1, -2).addComponent(this.jLabel_MaxY).addComponent(this.jTextField_MaxY, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_XSize).addComponent(this.jTextField_XSize, -2, -1, -2).addComponent(this.jLabel_YSize).addComponent(this.jTextField_YSize, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_XNum).addComponent(this.jTextField_XNum, -2, -1, -2).addComponent(this.jLabel_YNum).addComponent(this.jTextField_YNum, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Method Set"));
        this.jLabel_Method.setText("Method:");
        this.jComboBox_Methods.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Methods.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmInterpolate.this.jComboBox_MethodsActionPerformed(evt);
            }
        });
        this.jLabel_Radius.setText("Radius:");
        this.jLabel_MinNum.setText("MinNum:");
        this.jLabel_MissingValue.setText("Missing Value:");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.jLabel_Method).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Methods, -2, 176, -2)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel_MinNum).addComponent(this.jLabel_Radius)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jTextField_MinNum, -2, 44, -2).addGap(18, 18, 18).addComponent(this.jLabel_MissingValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_MissingValue)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jTextField_Radius, -2, 156, -2).addGap(0, 0, Short.MAX_VALUE))))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Method).addComponent(this.jComboBox_Methods, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_Radius).addComponent(this.jTextField_Radius, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_MinNum).addComponent(this.jTextField_MinNum, -2, -1, -2).addComponent(this.jLabel_MissingValue).addComponent(this.jTextField_MissingValue, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmInterpolate.this.jButton_OKActionPerformed(evt);
            }
        });
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmInterpolate.this.jButton_CancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGap(67, 67, 67).addComponent(this.jButton_OK, -2, 72, -2).addGap(39, 39, 39).addComponent(this.jButton_Cancel))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_OK).addComponent(this.jButton_Cancel)).addContainerGap(21, Short.MAX_VALUE)));
        this.pack();
    }

    private void jTextField_XSizeActionPerformed(ActionEvent evt) {
        this.setXYNum();
    }

    private void jTextField_YSizeActionPerformed(ActionEvent evt) {
        this.setXYNum();
    }

    private void jTextField_MinXActionPerformed(ActionEvent evt) {
        this.setXYSize();
    }

    private void jTextField_MaxXActionPerformed(ActionEvent evt) {
        this.setXYSize();
    }

    private void jTextField_MinYActionPerformed(ActionEvent evt) {
        this.setXYSize();
    }

    private void jTextField_MaxYActionPerformed(ActionEvent evt) {
        this.setXYSize();
    }

    private void jTextField_XNumActionPerformed(ActionEvent evt) {
        this.setXYSize();
    }

    private void jTextField_YNumActionPerformed(ActionEvent evt) {
        this.setXYSize();
    }

    private void jComboBox_MethodsActionPerformed(ActionEvent evt) {
        if (this.jComboBox_Methods.getItemCount() == 0) {
            return;
        }
        InterpolationMethods method = InterpolationMethods.valueOf((String)this.jComboBox_Methods.getSelectedItem().toString());
        switch (method) {
            case IDW_Radius: {
                this.jTextField_Radius.setEnabled(true);
                this.jTextField_MinNum.setEnabled(true);
                this.jTextField_Radius.setText(String.valueOf(this._interpSetting.getRadius()));
                break;
            }
            case IDW_Neighbors: {
                this.jTextField_Radius.setEnabled(false);
                this.jTextField_MinNum.setEnabled(true);
                this.jTextField_Radius.setText(String.valueOf(this._interpSetting.getRadius()));
                break;
            }
            case Cressman: {
                this.jTextField_Radius.setEnabled(true);
                this.jTextField_MinNum.setEnabled(false);
                String radStr = "";
                for (int i = 0; i < this._interpSetting.getRadiusList().size(); ++i) {
                    radStr = radStr + String.valueOf(this._interpSetting.getRadiusList().get(i)) + ";";
                }
                radStr = radStr.substring(0, radStr.length() - 1);
                this.jTextField_Radius.setText(radStr);
            }
        }
    }

    private void jButton_OKActionPerformed(ActionEvent evt) {
        this._isOK = true;
        this.dispose();
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public boolean isOK() {
        return this._isOK;
    }

    public void setParameters(InterpolationSetting interpSetting) {
        this._interpSetting = interpSetting;
        this.jTextField_MinX.setText(String.valueOf(interpSetting.getGridDataSetting().dataExtent.minX));
        this.jTextField_MaxX.setText(String.valueOf(interpSetting.getGridDataSetting().dataExtent.maxX));
        this.jTextField_MinY.setText(String.valueOf(interpSetting.getGridDataSetting().dataExtent.minY));
        this.jTextField_MaxY.setText(String.valueOf(interpSetting.getGridDataSetting().dataExtent.maxY));
        this.jTextField_XNum.setText(String.valueOf(interpSetting.getGridDataSetting().xNum));
        this.jTextField_YNum.setText(String.valueOf(interpSetting.getGridDataSetting().yNum));
        this.setXYSize();
        this.jComboBox_Methods.removeAllItems();
        this.jComboBox_Methods.addItem(InterpolationMethods.IDW_Radius.toString());
        this.jComboBox_Methods.addItem(InterpolationMethods.IDW_Neighbors.toString());
        this.jComboBox_Methods.addItem(InterpolationMethods.Cressman.toString());
        this.jComboBox_Methods.addItem(InterpolationMethods.AssignPointToGrid.toString());
        this.jComboBox_Methods.setSelectedItem(this._interpSetting.getInterpolationMethod().toString());
        switch (this._interpSetting.getInterpolationMethod()) {
            case Cressman: {
                String radStr = "";
                for (int i = 0; i < this._interpSetting.getRadiusList().size(); ++i) {
                    radStr = radStr + String.valueOf(this._interpSetting.getRadiusList().get(i)) + ";";
                }
                radStr = radStr.substring(0, radStr.length() - 1);
                this.jTextField_Radius.setText(radStr);
                this.jTextField_MinNum.setText(String.valueOf(this._interpSetting.getMinPointNum()));
                this.jTextField_MissingValue.setText(String.valueOf(this._interpSetting.getMissingValue()));
                this.jTextField_MissingValue.setEnabled(false);
                break;
            }
            case IDW_Radius: 
            case IDW_Neighbors: {
                this.jTextField_Radius.setText(Double.valueOf(this._interpSetting.getRadius()).toString());
                this.jTextField_MinNum.setText(String.valueOf(this._interpSetting.getMinPointNum()));
                this.jTextField_MissingValue.setText(String.valueOf(this._interpSetting.getMissingValue()));
                this.jTextField_MissingValue.setEnabled(false);
                break;
            }
        }
    }

    public InterpolationSetting getParameters() {
        float minX = Float.parseFloat(this.jTextField_MinX.getText());
        float maxX = Float.parseFloat(this.jTextField_MaxX.getText());
        float minY = Float.parseFloat(this.jTextField_MinY.getText());
        float maxY = Float.parseFloat(this.jTextField_MaxY.getText());
        GridDataSetting aGDP = new GridDataSetting();
        aGDP.dataExtent.minX = minX;
        aGDP.dataExtent.maxX = maxX;
        aGDP.dataExtent.minY = minY;
        aGDP.dataExtent.maxY = maxY;
        aGDP.xNum = Integer.parseInt(this.jTextField_XNum.getText());
        aGDP.yNum = Integer.parseInt(this.jTextField_YNum.getText());
        InterpolationSetting interpSetting = new InterpolationSetting();
        interpSetting.setGridDataSetting(aGDP);
        interpSetting.setInterpolationMethod(InterpolationMethods.valueOf((String)this.jComboBox_Methods.getSelectedItem().toString()));
        switch (interpSetting.getInterpolationMethod()) {
            case Cressman: {
                if (!this.jTextField_Radius.getText().isEmpty()) {
                    String[] radStrs = this.jTextField_Radius.getText().split(";");
                    ArrayList<Double> radList = new ArrayList<Double>();
                    for (int i = 0; i < radStrs.length; ++i) {
                        radList.add(Double.parseDouble(radStrs[i]));
                    }
                    interpSetting.setRadiusList(radList);
                } else {
                    interpSetting.setRadiusList(new ArrayList());
                }
                interpSetting.setMinPointNum(Integer.parseInt(this.jTextField_MinNum.getText()));
                break;
            }
            case IDW_Radius: 
            case IDW_Neighbors: {
                interpSetting.setRadius(Double.parseDouble(this.jTextField_Radius.getText()));
                interpSetting.setMinPointNum(Integer.parseInt(this.jTextField_MinNum.getText()));
            }
        }
        return interpSetting;
    }

    private void setXYSize() {
        float minX = Float.parseFloat(this.jTextField_MinX.getText());
        float maxX = Float.parseFloat(this.jTextField_MaxX.getText());
        float minY = Float.parseFloat(this.jTextField_MinY.getText());
        float maxY = Float.parseFloat(this.jTextField_MaxY.getText());
        int XNum = Integer.parseInt(this.jTextField_XNum.getText());
        int YNum = Integer.parseInt(this.jTextField_YNum.getText());
        float XSize = (maxX - minX) / (float)(XNum - 1);
        float YSize = (maxY - minY) / (float)(YNum - 1);
        this.jTextField_XSize.setText(String.valueOf(XSize));
        this.jTextField_YSize.setText(String.valueOf(YSize));
    }

    private void setXYNum() {
        float minX = Float.parseFloat(this.jTextField_MinX.getText());
        float maxX = Float.parseFloat(this.jTextField_MaxX.getText());
        float minY = Float.parseFloat(this.jTextField_MinY.getText());
        float maxY = Float.parseFloat(this.jTextField_MaxY.getText());
        float XSize = Float.parseFloat(this.jTextField_XSize.getText());
        float YSize = Float.parseFloat(this.jTextField_YSize.getText());
        int XNum = (int)((maxX - minX) / XSize);
        int YNum = (int)((maxY - minY) / YSize);
        maxX = minX + (float)XNum * XSize;
        maxY = minY + (float)YNum * YSize;
        this.jTextField_XNum.setText(String.valueOf(++XNum));
        this.jTextField_YNum.setText(String.valueOf(++YNum));
        this.jTextField_MaxX.setText(String.valueOf(maxX));
        this.jTextField_MaxY.setText(String.valueOf(maxY));
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmInterpolate.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmInterpolate.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmInterpolate.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmInterpolate.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmInterpolate dialog = new FrmInterpolate((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

