/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop.forms;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.desktop.forms.FrmMain;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.map.MapView;

public class FrmSymDifference
extends JDialog {
    List<VectorLayer> _vLayers = new ArrayList<VectorLayer>();
    List<VectorLayer> _polygonLayers = new ArrayList<VectorLayer>();
    private final FrmMain _parent;
    private JButton jButton_Apply;
    private JCheckBox jCheckBox_SelFeatureOnly_Difference;
    private JCheckBox jCheckBox_SelFeatureOnly_Subject;
    private JComboBox jComboBox_SubjectLayer;
    private JComboBox jComboBox_SymDifferenceLayer;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public FrmSymDifference(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.initComponents();
        this._parent = (FrmMain)parent;
        this.initialize();
    }

    private void initialize() {
        MapView mapView = this._parent.getMapDocument().getActiveMapFrame().getMapView();
        this.jComboBox_SubjectLayer.removeAllItems();
        this.jComboBox_SymDifferenceLayer.removeAllItems();
        for (int i = 0; i < mapView.getLayerNum(); ++i) {
            MapLayer layer = (MapLayer)mapView.getLayers().get(i);
            if (layer.getLayerType() != LayerTypes.VectorLayer) continue;
            this._vLayers.add((VectorLayer)layer);
            this.jComboBox_SubjectLayer.addItem(layer.getLayerName());
            switch (layer.getShapeType()) {
                case Polygon: 
                case PolygonZ: 
                case PolygonM: {
                    this._polygonLayers.add((VectorLayer)layer);
                    this.jComboBox_SymDifferenceLayer.addItem(layer.getLayerName());
                }
            }
        }
        if (this.jComboBox_SubjectLayer.getItemCount() > 0) {
            this.jComboBox_SubjectLayer.setSelectedIndex(0);
        }
        if (this.jComboBox_SymDifferenceLayer.getItemCount() > 0) {
            this.jComboBox_SymDifferenceLayer.setSelectedIndex(0);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox_SubjectLayer = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBox_SymDifferenceLayer = new JComboBox();
        this.jCheckBox_SelFeatureOnly_Difference = new JCheckBox();
        this.jButton_Apply = new JButton();
        this.jCheckBox_SelFeatureOnly_Subject = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Symmetrical Difference");
        this.jLabel1.setText("Subject layer:");
        this.jComboBox_SubjectLayer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel2.setText("Symmetrical Difference layer:");
        this.jComboBox_SymDifferenceLayer.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_SymDifferenceLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSymDifference.this.jComboBox_SymDifferenceLayerActionPerformed(evt);
            }
        });
        this.jCheckBox_SelFeatureOnly_Difference.setText("Selected features only");
        this.jButton_Apply.setText("Apply");
        this.jButton_Apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmSymDifference.this.jButton_ApplyActionPerformed(evt);
            }
        });
        this.jCheckBox_SelFeatureOnly_Subject.setText("Selected features only");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(134, 134, 134).addComponent(this.jButton_Apply, -2, 85, -2).addContainerGap(167, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_SubjectLayer, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBox_SymDifferenceLayer, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_SelFeatureOnly_Subject).addComponent(this.jLabel1).addComponent(this.jCheckBox_SelFeatureOnly_Difference).addComponent(this.jLabel2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_SubjectLayer, -2, -1, -2).addGap(6, 6, 6).addComponent(this.jCheckBox_SelFeatureOnly_Subject).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_SymDifferenceLayer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBox_SelFeatureOnly_Difference).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 12, Short.MAX_VALUE).addComponent(this.jButton_Apply).addContainerGap()));
        this.pack();
    }

    private void jButton_ApplyActionPerformed(ActionEvent evt) {
        if (this.jComboBox_SubjectLayer.getSelectedItem().toString().equals(this.jComboBox_SymDifferenceLayer.getSelectedItem().toString())) {
            JOptionPane.showMessageDialog(null, "The two layers are same!");
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        VectorLayer fromLayer = this._vLayers.get(this.jComboBox_SubjectLayer.getSelectedIndex());
        VectorLayer clipLayer = this._polygonLayers.get(this.jComboBox_SymDifferenceLayer.getSelectedIndex());
        boolean onlySel = this.jCheckBox_SelFeatureOnly_Subject.isSelected();
        List clipShapes = this.jCheckBox_SelFeatureOnly_Difference.isSelected() ? clipLayer.getSelectedShapes() : clipLayer.getShapes();
        VectorLayer newLayer = fromLayer.symDifference(clipShapes, onlySel);
        newLayer.setLayerName("Intersection_" + newLayer.getLayerName());
        this._parent.getMapDocument().getActiveMapFrame().addLayer((MapLayer)newLayer);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jComboBox_SymDifferenceLayerActionPerformed(ActionEvent evt) {
        if (this.jComboBox_SymDifferenceLayer.getItemCount() > 0) {
            VectorLayer aLayer = this._polygonLayers.get(this.jComboBox_SymDifferenceLayer.getSelectedIndex());
            List selIndexes = aLayer.getSelectedShapeIndexes();
            if (selIndexes.size() > 0) {
                this.jCheckBox_SelFeatureOnly_Difference.setEnabled(true);
                this.jCheckBox_SelFeatureOnly_Difference.setText("Selected features only (" + String.valueOf(selIndexes.size()) + " features selected)");
            } else {
                this.jCheckBox_SelFeatureOnly_Difference.setEnabled(false);
                this.jCheckBox_SelFeatureOnly_Difference.setSelected(false);
                this.jCheckBox_SelFeatureOnly_Difference.setText("Selected features only");
            }
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmSymDifference.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmSymDifference dialog = new FrmSymDifference(new FrmMain(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

