/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop.forms;

import com.l2fprod.common.swing.JFontChooser;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.DefaultCaret;
import org.fife.ui.rsyntaxtextarea.TextEditorPane;
import org.meteoinfo.desktop.config.EncodingUtil;
import org.meteoinfo.desktop.config.GenericFileFilter;
import org.meteoinfo.desktop.config.JTextAreaPrintStream;
import org.meteoinfo.desktop.config.JTextAreaWriter;
import org.meteoinfo.desktop.config.TextEditor;
import org.meteoinfo.desktop.forms.FrmMain;
import org.meteoinfo.global.util.GlobalUtil;
import org.meteoinfo.ui.ButtonTabComponent;
import org.python.util.PythonInterpreter;

public class FrmTextEditor
extends JFrame {
    private FrmMain _parent = null;
    private Font _font = new Font("Simsun", 0, 15);
    private String _scriptLanguage = "Jython";
    private Dimension _splitPanelSize;
    private JButton jButton_CloseFile;
    private JButton jButton_NewFile;
    private JButton jButton_OpenFile;
    private JButton jButton_Redo;
    private JButton jButton_RunScript;
    private JButton jButton_SaveFile;
    private JButton jButton_Undo;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem_CloseFile;
    private JMenuItem jMenuItem_Copy;
    private JMenuItem jMenuItem_Cut;
    private JMenuItem jMenuItem_Exit;
    private JMenuItem jMenuItem_NewFile;
    private JMenuItem jMenuItem_OpenFile;
    private JMenuItem jMenuItem_Paste;
    private JMenuItem jMenuItem_SaveAs;
    private JMenuItem jMenuItem_SaveFile;
    private JMenuItem jMenuItem_SetFont;
    private JMenu jMenu_File;
    private JMenu jMenu_Options;
    private JMenu jMenu_ScriptLanguage;
    private JRadioButtonMenuItem jRadioButtonMenuItem_Groovy;
    private JRadioButtonMenuItem jRadioButtonMenuItem_Jython;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator5;
    private JSplitPane jSplitPane1;
    private JTabbedPane jTabbedPane1;
    private JTextArea jTextArea_Output;
    private JToolBar jToolBar1;

    public Font getTextFont() {
        return this._font;
    }

    public void setTextFont(Font font) {
        this._font = font;
        for (Component tab : this.jTabbedPane1.getComponents()) {
            if (!(tab instanceof TextEditor)) continue;
            ((TextEditor)tab).setTextFont(this._font);
        }
        this.jTextArea_Output.setFont(this._font);
    }

    public String getScriptLanguage() {
        return this._scriptLanguage;
    }

    public void setScriptLanguage(String value) {
        this._scriptLanguage = value;
        if (this._scriptLanguage.equals("Groovy")) {
            this.setTitle("MeteoInfo Script - Groovy");
            this.jRadioButtonMenuItem_Groovy.setSelected(true);
            this.jRadioButtonMenuItem_Jython.setSelected(false);
        } else {
            this.setTitle("MeteoInfo Script - Jython");
            this.jRadioButtonMenuItem_Groovy.setSelected(false);
            this.jRadioButtonMenuItem_Jython.setSelected(true);
        }
    }

    public FrmTextEditor() {
        this.initComponents();
        DefaultCaret caret = (DefaultCaret)this.jTextArea_Output.getCaret();
        caret.setUpdatePolicy(2);
        this.setDefaultCloseOperation(0);
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/snake.png"));
            this.setIconImage(image);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setScriptLanguage(this._scriptLanguage);
        this.addNewTextEditor("New file");
        this._splitPanelSize = this.jSplitPane1.getBounds().getSize();
        this.setSize(600, 600);
        this.jSplitPane1.setDividerLocation(5);
    }

    public FrmTextEditor(JFrame parent) {
        this();
        this._parent = (FrmMain)parent;
        this.setScriptLanguage(this._parent.getOptions().getScriptLanguage());
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButton_NewFile = new JButton();
        this.jButton_OpenFile = new JButton();
        this.jButton_CloseFile = new JButton();
        this.jButton_SaveFile = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButton_Undo = new JButton();
        this.jButton_Redo = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButton_RunScript = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea_Output = new JTextArea();
        this.jTabbedPane1 = new JTabbedPane();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu_File = new JMenu();
        this.jMenuItem_NewFile = new JMenuItem();
        this.jMenuItem_OpenFile = new JMenuItem();
        this.jMenuItem_SaveFile = new JMenuItem();
        this.jMenuItem_SaveAs = new JMenuItem();
        this.jMenuItem_CloseFile = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.jMenuItem_Exit = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem_Cut = new JMenuItem();
        this.jMenuItem_Copy = new JMenuItem();
        this.jMenuItem_Paste = new JMenuItem();
        this.jMenu_Options = new JMenu();
        this.jMenuItem_SetFont = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.jMenu_ScriptLanguage = new JMenu();
        this.jRadioButtonMenuItem_Groovy = new JRadioButtonMenuItem();
        this.jRadioButtonMenuItem_Jython = new JRadioButtonMenuItem();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FrmTextEditor.this.formWindowClosing(evt);
            }
        });
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setPreferredSize(new Dimension(74, 25));
        this.jButton_NewFile.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_NewFile.Image.png")));
        this.jButton_NewFile.setToolTipText("New File");
        this.jButton_NewFile.setFocusable(false);
        this.jButton_NewFile.setHorizontalTextPosition(0);
        this.jButton_NewFile.setVerticalTextPosition(3);
        this.jButton_NewFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jButton_NewFileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_NewFile);
        this.jButton_OpenFile.setIcon(new ImageIcon(this.getClass().getResource("/images/Folder_1_16x16x8.png")));
        this.jButton_OpenFile.setToolTipText("Open File");
        this.jButton_OpenFile.setFocusable(false);
        this.jButton_OpenFile.setHorizontalTextPosition(0);
        this.jButton_OpenFile.setVerticalTextPosition(3);
        this.jButton_OpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jButton_OpenFileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_OpenFile);
        this.jButton_CloseFile.setIcon(new ImageIcon(this.getClass().getResource("/images/closefile.png")));
        this.jButton_CloseFile.setToolTipText("Close File");
        this.jButton_CloseFile.setFocusable(false);
        this.jButton_CloseFile.setHorizontalTextPosition(0);
        this.jButton_CloseFile.setVerticalTextPosition(3);
        this.jButton_CloseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jButton_CloseFileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_CloseFile);
        this.jButton_SaveFile.setIcon(new ImageIcon(this.getClass().getResource("/images/Disk_1_16x16x8.png")));
        this.jButton_SaveFile.setToolTipText("Save File");
        this.jButton_SaveFile.setFocusable(false);
        this.jButton_SaveFile.setHorizontalTextPosition(0);
        this.jButton_SaveFile.setVerticalTextPosition(3);
        this.jButton_SaveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jButton_SaveFileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_SaveFile);
        this.jToolBar1.add(this.jSeparator1);
        this.jButton_Undo.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Undo.Image.png")));
        this.jButton_Undo.setToolTipText("Undo");
        this.jButton_Undo.setFocusable(false);
        this.jButton_Undo.setHorizontalTextPosition(0);
        this.jButton_Undo.setVerticalTextPosition(3);
        this.jButton_Undo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jButton_UndoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Undo);
        this.jButton_Redo.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Redo.Image.png")));
        this.jButton_Redo.setToolTipText("Redo");
        this.jButton_Redo.setFocusable(false);
        this.jButton_Redo.setHorizontalTextPosition(0);
        this.jButton_Redo.setVerticalTextPosition(3);
        this.jButton_Redo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jButton_RedoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Redo);
        this.jToolBar1.add(this.jSeparator2);
        this.jButton_RunScript.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_RunScript.Image.png")));
        this.jButton_RunScript.setToolTipText("Run Script");
        this.jButton_RunScript.setFocusable(false);
        this.jButton_RunScript.setHorizontalTextPosition(0);
        this.jButton_RunScript.setVerticalTextPosition(3);
        this.jButton_RunScript.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jButton_RunScriptActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_RunScript);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.jSplitPane1.setDividerLocation(300);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                FrmTextEditor.this.jSplitPane1ComponentResized(evt);
            }
        });
        this.jTextArea_Output.setColumns(20);
        this.jTextArea_Output.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea_Output);
        this.jSplitPane1.setRightComponent(this.jScrollPane1);
        this.jSplitPane1.setLeftComponent(this.jTabbedPane1);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.jMenu_File.setMnemonic('F');
        this.jMenu_File.setText("File");
        this.jMenuItem_NewFile.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.jMenuItem_NewFile.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_NewFile.Image.png")));
        this.jMenuItem_NewFile.setText("New");
        this.jMenuItem_NewFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jMenuItem_NewFileActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_NewFile);
        this.jMenuItem_OpenFile.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.jMenuItem_OpenFile.setIcon(new ImageIcon(this.getClass().getResource("/images/Folder_1_16x16x8.png")));
        this.jMenuItem_OpenFile.setText("Open ...");
        this.jMenuItem_OpenFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jMenuItem_OpenFileActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_OpenFile);
        this.jMenuItem_SaveFile.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.jMenuItem_SaveFile.setIcon(new ImageIcon(this.getClass().getResource("/images/Disk_1_16x16x8.png")));
        this.jMenuItem_SaveFile.setText("Save");
        this.jMenuItem_SaveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jMenuItem_SaveFileActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_SaveFile);
        this.jMenuItem_SaveAs.setText("Save As ...");
        this.jMenuItem_SaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jMenuItem_SaveAsActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_SaveAs);
        this.jMenuItem_CloseFile.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.jMenuItem_CloseFile.setIcon(new ImageIcon(this.getClass().getResource("/images/closefile.png")));
        this.jMenuItem_CloseFile.setText("Close");
        this.jMenuItem_CloseFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jMenuItem_CloseFileActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_CloseFile);
        this.jMenu_File.add(this.jSeparator3);
        this.jMenuItem_Exit.setText("Exit");
        this.jMenuItem_Exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jMenuItem_ExitActionPerformed(evt);
            }
        });
        this.jMenu_File.add(this.jMenuItem_Exit);
        this.jMenuBar1.add(this.jMenu_File);
        this.jMenu2.setMnemonic('E');
        this.jMenu2.setText("Edit");
        this.jMenuItem_Cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.jMenuItem_Cut.setIcon(new ImageIcon(this.getClass().getResource("/images/TSMI_EditCut.Image.png")));
        this.jMenuItem_Cut.setText("Cut");
        this.jMenuItem_Cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jMenuItem_CutActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem_Cut);
        this.jMenuItem_Copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.jMenuItem_Copy.setIcon(new ImageIcon(this.getClass().getResource("/images/menuEditCopy.Image.png")));
        this.jMenuItem_Copy.setText("Copy");
        this.jMenuItem_Copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jMenuItem_CopyActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem_Copy);
        this.jMenuItem_Paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.jMenuItem_Paste.setIcon(new ImageIcon(this.getClass().getResource("/images/pasteToolStripButton.Image.png")));
        this.jMenuItem_Paste.setText("Paste");
        this.jMenuItem_Paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jMenuItem_PasteActionPerformed(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem_Paste);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu_Options.setMnemonic('O');
        this.jMenu_Options.setText("Options");
        this.jMenuItem_SetFont.setIcon(new ImageIcon(this.getClass().getResource("/images/miSetFont.Image.png")));
        this.jMenuItem_SetFont.setText("Set Font");
        this.jMenuItem_SetFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jMenuItem_SetFontActionPerformed(evt);
            }
        });
        this.jMenu_Options.add(this.jMenuItem_SetFont);
        this.jMenu_Options.add(this.jSeparator5);
        this.jMenu_ScriptLanguage.setText("Script Language");
        this.jRadioButtonMenuItem_Groovy.setSelected(true);
        this.jRadioButtonMenuItem_Groovy.setText("Groovy");
        this.jRadioButtonMenuItem_Groovy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jRadioButtonMenuItem_GroovyActionPerformed(evt);
            }
        });
        this.jMenu_ScriptLanguage.add(this.jRadioButtonMenuItem_Groovy);
        this.jRadioButtonMenuItem_Jython.setSelected(true);
        this.jRadioButtonMenuItem_Jython.setText("Jython");
        this.jRadioButtonMenuItem_Jython.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTextEditor.this.jRadioButtonMenuItem_JythonActionPerformed(evt);
            }
        });
        this.jMenu_ScriptLanguage.add(this.jRadioButtonMenuItem_Jython);
        this.jMenu_Options.add(this.jMenu_ScriptLanguage);
        this.jMenuBar1.add(this.jMenu_Options);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void jButton_NewFileActionPerformed(ActionEvent evt) {
        this.addNewTextEditor("New file");
    }

    private void jButton_OpenFileActionPerformed(ActionEvent evt) {
        if (this._scriptLanguage.equals("Groovy")) {
            this.doOpen_Groovy();
        } else {
            this.doOpen_Jython();
        }
    }

    private void jButton_CloseFileActionPerformed(ActionEvent evt) {
        this.closeFile();
    }

    private void jButton_SaveFileActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.getActiveTextEditor();
        if (textEditor != null) {
            this.doSave(textEditor);
        }
    }

    private void jButton_UndoActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.getActiveTextEditor();
        textEditor.getTextArea().undoLastAction();
    }

    private void jButton_RedoActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.getActiveTextEditor();
        textEditor.getTextArea().redoLastAction();
    }

    private void jButton_RunScriptActionPerformed(ActionEvent evt) {
        TextEditor editor = this.getActiveTextEditor();
        if (!editor.getFileName().isEmpty()) {
            editor.saveFile(editor.getFile());
        }
        if (this._scriptLanguage.equals("Groovy")) {
            this.runGroovyScript();
        } else {
            this.runPythonScript();
        }
    }

    private void jMenuItem_NewFileActionPerformed(ActionEvent evt) {
        this.jButton_NewFile.doClick();
    }

    private void jMenuItem_OpenFileActionPerformed(ActionEvent evt) {
        this.jButton_OpenFile.doClick();
    }

    private void jMenuItem_SaveFileActionPerformed(ActionEvent evt) {
        this.jButton_SaveFile.doClick();
    }

    private void jMenuItem_SaveAsActionPerformed(ActionEvent evt) {
        TextEditor editor = this.getActiveTextEditor();
        if (editor != null) {
            if (this._scriptLanguage.equals("Groovy")) {
                this.doSaveAs_Groovy(editor);
            } else {
                this.doSaveAs_Jython(editor);
            }
        }
    }

    private void jMenuItem_CloseFileActionPerformed(ActionEvent evt) {
        this.jButton_CloseFile.doClick();
    }

    private void jMenuItem_ExitActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jMenuItem_CutActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.getActiveTextEditor();
        textEditor.getTextArea().cut();
    }

    private void jMenuItem_CopyActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.getActiveTextEditor();
        textEditor.getTextArea().copy();
    }

    private void jMenuItem_PasteActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.getActiveTextEditor();
        textEditor.getTextArea().paste();
    }

    private void jMenuItem_SetFontActionPerformed(ActionEvent evt) {
        TextEditor textEditor = this.getActiveTextEditor();
        Font tFont = JFontChooser.showDialog((Component)this, null, (Font)textEditor.getTextArea().getFont());
        if (tFont != null) {
            this.setTextFont(tFont);
            this._parent.getOptions().setTextFont(tFont);
        }
    }

    private void jRadioButtonMenuItem_GroovyActionPerformed(ActionEvent evt) {
        this.setScriptLanguage("Groovy");
    }

    private void jRadioButtonMenuItem_JythonActionPerformed(ActionEvent evt) {
        this.setScriptLanguage("Jython");
    }

    private void jSplitPane1ComponentResized(ComponentEvent evt) {
        Dimension size = this.jSplitPane1.getBounds().getSize();
        int heightdelta = size.height - this._splitPanelSize.height;
        this.jSplitPane1.setDividerLocation(this.jSplitPane1.getDividerLocation() + heightdelta);
        this._splitPanelSize = this.jSplitPane1.getBounds().getSize();
    }

    private void formWindowClosing(WindowEvent evt) {
        boolean isDispose = true;
        for (int i = 0; i < this.jTabbedPane1.getTabCount(); ++i) {
            TextEditor textEditor = (TextEditor)this.jTabbedPane1.getComponentAt(i);
            if (textEditor == null) continue;
            boolean ifClose = true;
            if (textEditor.getTextArea().isDirty()) {
                int result;
                String fName = textEditor.getFileName();
                if (fName.isEmpty()) {
                    fName = "New file";
                }
                if ((result = JOptionPane.showConfirmDialog(null, MessageFormat.format("Save changes to \"{0}\"", fName), "Save?", 1)) == 0) {
                    if (!this.doSave(textEditor)) {
                        ifClose = false;
                    }
                } else if (result == 2) {
                    ifClose = false;
                }
            }
            if (ifClose) continue;
            isDispose = false;
            break;
        }
        if (isDispose) {
            this.dispose();
        }
    }

    private void runPythonScript() {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){
            PrintStream oout = System.out;
            PrintStream oerr = System.err;

            @Override
            protected String doInBackground() throws Exception {
                JTextAreaWriter writer = new JTextAreaWriter(FrmTextEditor.this.jTextArea_Output);
                JTextAreaPrintStream printStream = new JTextAreaPrintStream((OutputStream)System.out, FrmTextEditor.this.jTextArea_Output);
                FrmTextEditor.this.jTextArea_Output.setText("");
                PythonInterpreter interp = new PythonInterpreter();
                interp.setOut((Writer)writer);
                interp.setErr((Writer)writer);
                System.setOut(printStream);
                System.setErr(printStream);
                String pluginPath = FrmTextEditor.this._parent.getStartupPath() + File.separator + "plugins";
                List jarfns = GlobalUtil.getFiles((String)pluginPath, (String)".jar");
                String path = FrmTextEditor.this._parent.getStartupPath() + File.separator + "pylib";
                try {
                    interp.exec("import sys");
                    interp.exec("sys.path.append('" + path + "')");
                    interp.set("miapp", (Object)FrmTextEditor.this._parent);
                    for (String jarfn : jarfns) {
                        interp.exec("sys.path.append('" + jarfn + "')");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                TextEditorPane textArea = FrmTextEditor.this.getActiveTextArea();
                String code = textArea.getText();
                String encoding = EncodingUtil.findEncoding(code);
                if (encoding != null) {
                    try {
                        interp.execfile((InputStream)new ByteArrayInputStream(code.getBytes(encoding)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        interp.execfile((InputStream)new ByteArrayInputStream(code.getBytes()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return "";
            }

            @Override
            protected void done() {
                System.setOut(this.oout);
                System.setErr(this.oerr);
            }
        };
        worker.execute();
    }

    private void runGroovyScript() {
        SwingWorker<String, String> worker = new SwingWorker<String, String>(){
            PrintStream oout = System.out;
            PrintStream oerr = System.err;

            @Override
            protected String doInBackground() throws Exception {
                JTextAreaPrintStream printStream = new JTextAreaPrintStream((OutputStream)System.out, FrmTextEditor.this.jTextArea_Output);
                FrmTextEditor.this.jTextArea_Output.setText("");
                GroovyShell shell = new GroovyShell();
                System.setOut(printStream);
                System.setErr(printStream);
                shell.setVariable("miapp", (Object)FrmTextEditor.this._parent);
                TextEditorPane textArea = FrmTextEditor.this.getActiveTextArea();
                String code = textArea.getText();
                try {
                    Script script = shell.parse(code);
                    script.run();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return "";
            }

            @Override
            protected void done() {
                System.setOut(this.oout);
                System.setErr(this.oerr);
            }
        };
        worker.execute();
    }

    private TextEditor addNewTextEditor(String title) {
        final TextEditor tab = new TextEditor(this.jTabbedPane1, title);
        this.jTabbedPane1.add((Component)tab, title);
        this.jTabbedPane1.setSelectedComponent(tab);
        tab.setTextFont(this._font);
        if (this._scriptLanguage.equals("Groovy")) {
            tab.getTextArea().setSyntaxEditingStyle("text/groovy");
        } else {
            tab.getTextArea().setSyntaxEditingStyle("text/python");
        }
        tab.getTextArea().discardAllEdits();
        tab.getTextArea().setDirty(false);
        tab.setTitle(title);
        ButtonTabComponent btc = new ButtonTabComponent(this.jTabbedPane1);
        ButtonTabComponent.TabButton button = btc.getTabButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmTextEditor.this.closeFile(tab);
            }
        });
        this.jTabbedPane1.setTabComponentAt(this.jTabbedPane1.indexOfComponent(tab), (Component)btc);
        return tab;
    }

    private void doOpen_Groovy() {
        JFileChooser aDlg = new JFileChooser();
        aDlg.setMultiSelectionEnabled(true);
        aDlg.setAcceptAllFileFilterUsed(false);
        File dir = new File(System.getProperty("user.dir"));
        if (dir.isDirectory()) {
            aDlg.setCurrentDirectory(dir);
        }
        String[] fileExts = new String[]{"groovy"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Groovy File (*.groovy)");
        aDlg.setFileFilter(mapFileFilter);
        if (0 == aDlg.showOpenDialog(this)) {
            File[] files = aDlg.getSelectedFiles();
            System.setProperty("user.dir", files[0].getParent());
            this.openFiles(files);
        }
    }

    private void doOpen_Jython() {
        JFileChooser aDlg = new JFileChooser();
        aDlg.setMultiSelectionEnabled(true);
        aDlg.setAcceptAllFileFilterUsed(false);
        File dir = new File(System.getProperty("user.dir"));
        if (dir.isDirectory()) {
            aDlg.setCurrentDirectory(dir);
        }
        String[] fileExts = new String[]{"py"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Jython File (*.py)");
        aDlg.setFileFilter(mapFileFilter);
        if (0 == aDlg.showOpenDialog(this)) {
            File[] files = aDlg.getSelectedFiles();
            System.setProperty("user.dir", files[0].getParent());
            this.openFiles(files);
        }
    }

    public void openFiles(File[] files) {
        TextEditor textEditor;
        if (this.jTabbedPane1.getTabCount() == 1 && (textEditor = this.getActiveTextEditor()).getTextArea().getDocument().getLength() == 0 && textEditor.getFileName().isEmpty()) {
            this.removeTextEditor(textEditor);
        }
        for (File file : files) {
            TextEditor editor = this.addNewTextEditor(file.getName());
            editor.openFile(file);
        }
    }

    private void closeFile() {
        this.closeFile(this.getActiveTextEditor());
    }

    private void closeFile(TextEditor textEditor) {
        if (textEditor != null) {
            boolean ifClose = true;
            if (textEditor.getTextArea().isDirty()) {
                int result;
                String fName = textEditor.getFileName();
                if (fName.isEmpty()) {
                    fName = "New file";
                }
                if ((result = JOptionPane.showConfirmDialog(null, MessageFormat.format("Save changes to \"{0}\"", fName), "Save?", 1)) == 0) {
                    if (!this.doSave(textEditor)) {
                        ifClose = false;
                    }
                } else if (result == 2) {
                    ifClose = false;
                }
            }
            if (ifClose) {
                this.removeTextEditor(textEditor);
            }
        }
    }

    private boolean doSave(TextEditor editor) {
        if (editor.getFileName().isEmpty()) {
            if (this._scriptLanguage.equals("Groovy")) {
                return this.doSaveAs_Groovy(editor);
            }
            return this.doSaveAs_Jython(editor);
        }
        editor.saveFile(editor.getFile());
        return true;
    }

    private boolean doSaveAs_Groovy(TextEditor editor) {
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"groovy"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Groovy File (*.groovy)");
        aDlg.setFileFilter(mapFileFilter);
        if (editor.getFile() != null) {
            aDlg.setSelectedFile(editor.getFile());
        } else {
            File dir = new File(System.getProperty("user.dir"));
            if (dir.isDirectory()) {
                aDlg.setCurrentDirectory(dir);
            }
        }
        aDlg.setAcceptAllFileFilterUsed(false);
        if (aDlg.showSaveDialog(this) == 0) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            String fileName = file.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }
            file = new File(fileName);
            editor.saveFile(file);
            return true;
        }
        return false;
    }

    private boolean doSaveAs_Jython(TextEditor editor) {
        JFileChooser aDlg = new JFileChooser();
        String[] fileExts = new String[]{"py"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Python File (*.py)");
        aDlg.setFileFilter(mapFileFilter);
        if (editor.getFile() != null) {
            aDlg.setSelectedFile(editor.getFile());
        } else {
            File dir = new File(System.getProperty("user.dir"));
            if (dir.isDirectory()) {
                aDlg.setCurrentDirectory(dir);
            }
        }
        if (aDlg.showSaveDialog(this) == 0) {
            File file = aDlg.getSelectedFile();
            System.setProperty("user.dir", file.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            String fileName = file.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }
            file = new File(fileName);
            editor.saveFile(file);
            return true;
        }
        return false;
    }

    private void removeTextEditor(TextEditor editor) {
        this.jTabbedPane1.remove(editor);
    }

    private TextEditorPane getActiveTextArea() {
        TextEditor textEditor = this.getActiveTextEditor();
        if (textEditor != null) {
            return textEditor.getTextArea();
        }
        return null;
    }

    private TextEditor getTextEditor(ButtonTabComponent btc) {
        int idx = this.jTabbedPane1.indexOfTabComponent((Component)btc);
        return (TextEditor)this.jTabbedPane1.getComponentAt(idx);
    }

    private TextEditor getActiveTextEditor() {
        if (this.jTabbedPane1.getTabCount() == 0) {
            return null;
        }
        return (TextEditor)this.jTabbedPane1.getSelectedComponent();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmTextEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmTextEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmTextEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmTextEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FrmTextEditor().setVisible(true);
            }
        });
    }
}

