/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop.forms;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.desktop.forms.FrmMain;
import org.meteoinfo.global.Extent;
import org.meteoinfo.map.MapView;

public class FrmZoomToExtent
extends JDialog {
    private final FrmMain parent;
    private JButton jButton_Close;
    private JButton jButton_Zoom;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JTextField jTextField_MaxLat;
    private JTextField jTextField_MaxLon;
    private JTextField jTextField_MinLat;
    private JTextField jTextField_MinLon;

    public FrmZoomToExtent(Frame parent, boolean modal) {
        super(parent, modal);
        this.parent = (FrmMain)parent;
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextField_MinLon = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextField_MaxLon = new JTextField();
        this.jLabel3 = new JLabel();
        this.jTextField_MinLat = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextField_MaxLat = new JTextField();
        this.jButton_Zoom = new JButton();
        this.jButton_Close = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                FrmZoomToExtent.this.formWindowOpened(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Lon/Lat Extent"));
        this.jLabel1.setText("Min Lon:");
        this.jTextField_MinLon.setText("jTextField1");
        this.jLabel2.setText("Max Lon:");
        this.jTextField_MaxLon.setText("jTextField1");
        this.jLabel3.setText("Min Lat:");
        this.jTextField_MinLat.setText("jTextField1");
        this.jLabel4.setText("Max Lat:");
        this.jTextField_MaxLat.setText("jTextField1");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_MinLon, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_MinLat, -2, -1, -2))).addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_MaxLat, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_MaxLon, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField_MinLon, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.jTextField_MaxLon, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.jTextField_MaxLat, -2, -1, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextField_MinLat, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton_Zoom.setText("Zoom");
        this.jButton_Zoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmZoomToExtent.this.jButton_ZoomActionPerformed(evt);
            }
        });
        this.jButton_Close.setText("Close");
        this.jButton_Close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmZoomToExtent.this.jButton_CloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButton_Zoom).addGap(65, 65, 65).addComponent(this.jButton_Close).addGap(69, 69, 69)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_Zoom).addComponent(this.jButton_Close)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        double maxLat;
        double minLat;
        double maxLon;
        double minLon;
        MapView mapView = this.parent.getMapDocument().getActiveMapFrame().getMapView();
        if (mapView.getProjection().isLonLatMap()) {
            minLon = mapView.getViewExtent().minX;
            maxLon = mapView.getViewExtent().maxX;
            minLat = mapView.getViewExtent().minY;
            maxLat = mapView.getViewExtent().maxY;
        } else {
            minLon = 0.0;
            maxLon = 0.0;
            minLat = 0.0;
            maxLat = 0.0;
        }
        this.jTextField_MinLon.setText(String.format("%.2f", minLon));
        this.jTextField_MaxLon.setText(String.format("%.2f", maxLon));
        this.jTextField_MinLat.setText(String.format("%.2f", minLat));
        this.jTextField_MaxLat.setText(String.format("%.2f", maxLat));
    }

    private void jButton_ZoomActionPerformed(ActionEvent evt) {
        double minLon = Double.parseDouble(this.jTextField_MinLon.getText());
        double maxLon = Double.parseDouble(this.jTextField_MaxLon.getText());
        double minLat = Double.parseDouble(this.jTextField_MinLat.getText());
        double maxLat = Double.parseDouble(this.jTextField_MaxLat.getText());
        if (minLon >= maxLon || minLat >= maxLat) {
            JOptionPane.showMessageDialog(this, "Lon/Lat set error!", "Error", 0);
            return;
        }
        Extent aExtent = new Extent();
        aExtent.minX = minLon;
        aExtent.maxX = maxLon;
        aExtent.minY = minLat;
        aExtent.maxY = maxLat;
        FrmMain frmMain = this.parent;
        if (frmMain.getMainTab().getSelectedIndex() == 0) {
            frmMain.getMapDocument().getActiveMapFrame().getMapView().zoomToExtentLonLatEx(aExtent);
        } else if (frmMain.getMainTab().getSelectedIndex() == 1) {
            frmMain.getMapDocument().getMapLayout().getActiveLayoutMap().zoomToExtentLonLatEx(aExtent);
            frmMain.getMapDocument().getMapLayout().paintGraphics();
        }
    }

    private void jButton_CloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmZoomToExtent.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmZoomToExtent.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmZoomToExtent.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmZoomToExtent.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmZoomToExtent dialog = new FrmZoomToExtent((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

