/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop.forms;

import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.data.meteodata.netcdf.NetCDFDataInfo;
import org.meteoinfo.desktop.config.GenericFileFilter;

public class FrmJoinNCFiles
extends JDialog {
    private JButton jButton_DataFolder;
    private JButton jButton_Join;
    private JButton jButton_Select;
    private JButton jButton_SelectAll;
    private JButton jButton_UnSelectAll;
    private JButton jButton_UnSelecte;
    private JLabel jLabel1;
    private JLabel jLabel_DataFolder;
    private JList jList_AllFiles;
    private JList jList_SelectedFiles;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTextField jTextField_TimeDimName;

    public FrmJoinNCFiles(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jList_AllFiles.setModel(new DefaultListModel());
        this.jList_SelectedFiles.setModel(new DefaultListModel());
        File path = new File(System.getProperty("user.dir"));
        this.setDataFolder(path);
    }

    private void initComponents() {
        this.jButton_DataFolder = new JButton();
        this.jLabel_DataFolder = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList_AllFiles = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jList_SelectedFiles = new JList();
        this.jButton_SelectAll = new JButton();
        this.jButton_UnSelecte = new JButton();
        this.jButton_Select = new JButton();
        this.jButton_UnSelectAll = new JButton();
        this.jButton_Join = new JButton();
        this.jLabel1 = new JLabel();
        this.jTextField_TimeDimName = new JTextField();
        this.setDefaultCloseOperation(2);
        this.jButton_DataFolder.setIcon(new ImageIcon(this.getClass().getResource("/images/Folder_1_16x16x8.png")));
        this.jButton_DataFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmJoinNCFiles.this.jButton_DataFolderActionPerformed(evt);
            }
        });
        this.jLabel_DataFolder.setBorder(BorderFactory.createEtchedBorder());
        this.jList_AllFiles.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jList_AllFiles);
        this.jList_SelectedFiles.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane2.setViewportView(this.jList_SelectedFiles);
        this.jButton_SelectAll.setFont(new Font("\u5b8b\u4f53", 1, 15));
        this.jButton_SelectAll.setText(">>");
        this.jButton_SelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmJoinNCFiles.this.jButton_SelectAllActionPerformed(evt);
            }
        });
        this.jButton_UnSelecte.setFont(new Font("\u5b8b\u4f53", 1, 15));
        this.jButton_UnSelecte.setText("<");
        this.jButton_UnSelecte.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmJoinNCFiles.this.jButton_UnSelecteActionPerformed(evt);
            }
        });
        this.jButton_Select.setFont(new Font("\u5b8b\u4f53", 1, 15));
        this.jButton_Select.setText(">");
        this.jButton_Select.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmJoinNCFiles.this.jButton_SelectActionPerformed(evt);
            }
        });
        this.jButton_UnSelectAll.setFont(new Font("\u5b8b\u4f53", 1, 15));
        this.jButton_UnSelectAll.setText("<<");
        this.jButton_UnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmJoinNCFiles.this.jButton_UnSelectAllActionPerformed(evt);
            }
        });
        this.jButton_Join.setText("Join");
        this.jButton_Join.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmJoinNCFiles.this.jButton_JoinActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Time Dimension Name:");
        this.jTextField_TimeDimName.setText("time");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 220, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton_Select, -2, 54, -2).addComponent(this.jButton_UnSelecte, -2, 54, -2).addComponent(this.jButton_SelectAll, -2, 54, -2).addComponent(this.jButton_UnSelectAll, -2, 54, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2)).addGroup(layout.createSequentialGroup().addComponent(this.jButton_DataFolder, -2, 36, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel_DataFolder, -1, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_TimeDimName, -2, 175, -2).addGap(32, 32, 32).addComponent(this.jButton_Join, -2, 79, -2).addGap(0, 58, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jButton_DataFolder, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel_DataFolder, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(70, 70, 70).addComponent(this.jButton_Select).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_UnSelecte).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_SelectAll).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_UnSelectAll)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane2, -1, 275, Short.MAX_VALUE).addComponent(this.jScrollPane1)))).addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_Join).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTextField_TimeDimName, -2, -1, -2))).addContainerGap(24, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton_DataFolderActionPerformed(ActionEvent evt) {
        JFileChooser aDlg = new JFileChooser();
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        if (pathDir.isDirectory()) {
            aDlg.setCurrentDirectory(pathDir);
        }
        aDlg.setFileSelectionMode(1);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getAbsolutePath());
            this.setDataFolder(aFile);
        }
    }

    private void jButton_SelectActionPerformed(ActionEvent evt) {
        DefaultListModel listModel_sel = (DefaultListModel)this.jList_SelectedFiles.getModel();
        List selNames = this.jList_AllFiles.getSelectedValuesList();
        for (String name : selNames) {
            listModel_sel.addElement(name);
        }
    }

    private void jButton_UnSelecteActionPerformed(ActionEvent evt) {
        DefaultListModel listModel_sel = (DefaultListModel)this.jList_SelectedFiles.getModel();
        List selNames = this.jList_SelectedFiles.getSelectedValuesList();
        for (String name : selNames) {
            listModel_sel.removeElement(name);
        }
    }

    private void jButton_SelectAllActionPerformed(ActionEvent evt) {
        DefaultListModel listModel_all = (DefaultListModel)this.jList_AllFiles.getModel();
        DefaultListModel listModel_sel = (DefaultListModel)this.jList_SelectedFiles.getModel();
        listModel_sel.clear();
        for (int i = 0; i < listModel_all.getSize(); ++i) {
            listModel_sel.addElement(listModel_all.getElementAt(i));
        }
    }

    private void jButton_UnSelectAllActionPerformed(ActionEvent evt) {
        DefaultListModel listModel_sel = (DefaultListModel)this.jList_SelectedFiles.getModel();
        listModel_sel.clear();
    }

    private void jButton_JoinActionPerformed(ActionEvent evt) {
        DefaultListModel listModel_sel = (DefaultListModel)this.jList_SelectedFiles.getModel();
        ArrayList<String> sfns = new ArrayList<String>();
        for (int i = 0; i < listModel_sel.getSize(); ++i) {
            sfns.add(listModel_sel.getElementAt(i).toString());
        }
        if (sfns.size() < 2) {
            JOptionPane.showMessageDialog(null, "At least two files should be selected for joining!", "Error", 0);
            return;
        }
        String path = this.jLabel_DataFolder.getText();
        ArrayList<String> fns = new ArrayList<String>();
        for (String sfn : sfns) {
            String fn = path + File.separator + sfn;
            if (!new File(fn).isFile()) continue;
            fns.add(fn);
        }
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"nc"};
        GenericFileFilter ncFileFilter = new GenericFileFilter(fileExts, "NetCDF file (*.nc)");
        aDlg.setFileFilter(ncFileFilter);
        aDlg.setAcceptAllFileFilterUsed(false);
        if (0 == aDlg.showSaveDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());
            String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
            String fileName = aFile.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tDimName = this.jTextField_TimeDimName.getText();
            NetCDFDataInfo.joinDataFiles(fns, (String)fileName, (String)tDimName);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void setDataFolder(File path) {
        if (!path.isDirectory()) {
            return;
        }
        this.jLabel_DataFolder.setText(path.getAbsolutePath());
        DefaultListModel listModel_all = (DefaultListModel)this.jList_AllFiles.getModel();
        DefaultListModel listModel_sel = (DefaultListModel)this.jList_SelectedFiles.getModel();
        listModel_all.clear();
        listModel_sel.clear();
        Object[] files = path.listFiles();
        Arrays.sort(files);
        for (Object file : files) {
            if (!((File)file).isFile()) continue;
            String name = ((File)file).getName();
            listModel_all.addElement(name);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmJoinNCFiles.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmJoinNCFiles.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmJoinNCFiles.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmJoinNCFiles.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmJoinNCFiles dialog = new FrmJoinNCFiles((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

