/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.meteoinfo.desktop.config.Plugin;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PluginCollection
extends ArrayList<Plugin> {
    private String _pluginPath;
    private String _pluginConfigFile;

    public String getPluginPath() {
        return this._pluginPath;
    }

    public void setPluginPath(String value) {
        this._pluginPath = value;
    }

    public String getPluginConfigFile() {
        return this._pluginConfigFile;
    }

    public void setPluginConfigFile(String value) {
        this._pluginConfigFile = value;
    }

    public void saveConfigFile() throws ParserConfigurationException {
        this.saveConfigFile(this._pluginConfigFile);
    }

    public void saveConfigFile(String fileName) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element pluginsElem = doc.createElement("Plugins");
        for (Plugin plugin : this) {
            Element pluginElem = doc.createElement("Plugin");
            Attr pluginNameAttr = doc.createAttribute("Name");
            Attr pluginAuthorAttr = doc.createAttribute("Author");
            Attr pluginVersionAttr = doc.createAttribute("Version");
            Attr pluginDescriptionAttr = doc.createAttribute("Description");
            Attr pluginJarPathAttr = doc.createAttribute("JarPath");
            Attr pluginClassNameAttr = doc.createAttribute("ClassName");
            Attr pluginIsLoadAttr = doc.createAttribute("IsLoad");
            pluginNameAttr.setValue(plugin.getName());
            pluginAuthorAttr.setValue(plugin.getAuthor());
            pluginVersionAttr.setValue(plugin.getVersion());
            pluginDescriptionAttr.setValue(plugin.getDescription());
            pluginJarPathAttr.setValue(plugin.getJarPath());
            pluginClassNameAttr.setValue(plugin.getClassName());
            pluginIsLoadAttr.setValue(String.valueOf(plugin.isLoad()));
            pluginElem.setAttributeNode(pluginNameAttr);
            pluginElem.setAttributeNode(pluginAuthorAttr);
            pluginElem.setAttributeNode(pluginVersionAttr);
            pluginElem.setAttributeNode(pluginDescriptionAttr);
            pluginElem.setAttributeNode(pluginJarPathAttr);
            pluginElem.setAttributeNode(pluginClassNameAttr);
            pluginElem.setAttributeNode(pluginIsLoadAttr);
            pluginsElem.appendChild(pluginElem);
        }
        doc.appendChild(pluginsElem);
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            DOMSource source = new DOMSource(doc);
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            PrintWriter pw = new PrintWriter(new FileOutputStream(fileName));
            StreamResult result = new StreamResult(pw);
            transformer.transform(source, result);
        }
        catch (TransformerException transformerException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadConfigFile(String fileName) throws ParserConfigurationException, SAXException, IOException {
        if (!new File(fileName).exists()) {
            return;
        }
        this._pluginConfigFile = fileName;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
        InputSource is = new InputSource(br);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(is);
        try {
            this.clear();
            Element pluginsElem = doc.getDocumentElement();
            NodeList pluginNodeList = pluginsElem.getElementsByTagName("Plugin");
            for (int i = 0; i < pluginNodeList.getLength(); ++i) {
                Node pluginNode = pluginNodeList.item(i);
                Plugin plugin = new Plugin();
                NamedNodeMap attrs = pluginNode.getAttributes();
                plugin.setName(attrs.getNamedItem("Name").getNodeValue());
                plugin.setAuthor(attrs.getNamedItem("Author").getNodeValue());
                plugin.setVersion(attrs.getNamedItem("Version").getNodeValue());
                plugin.setDescription(attrs.getNamedItem("Description").getNodeValue());
                String jarPath = attrs.getNamedItem("JarPath").getNodeValue();
                jarPath = this._pluginPath + File.separator + jarPath;
                if (!new File(jarPath).exists()) continue;
                plugin.setJarFileName(jarPath);
                plugin.setClassName(attrs.getNamedItem("ClassName").getNodeValue());
                plugin.setLoad(Boolean.parseBoolean(attrs.getNamedItem("IsLoad").getNodeValue()));
                this.add(plugin);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

