/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop.config;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import org.meteoinfo.console.JConsole;
import org.meteoinfo.console.JavaCharStream;
import org.python.util.InteractiveConsole;

public class PythonInteractiveInterpreter
extends InteractiveConsole
implements Runnable {
    transient Reader in;
    transient PrintStream out;
    transient PrintStream err;
    JConsole console;

    public PythonInteractiveInterpreter(JConsole console) {
        this.cflags.source_is_utf8 = true;
        this.console = console;
        this.in = console.getIn();
        this.out = console.getOut();
        this.err = console.getErr();
        this.setOut(this.out);
        this.setErr(this.err);
    }

    @Override
    public void run() {
        boolean eof = false;
        JavaCharStream stream = new JavaCharStream(this.in, 1, 1);
        String ps1 = ">>> ";
        String ps2 = "... ";
        this.out.print(PythonInteractiveInterpreter.getDefaultBanner() + "\n");
        this.out.print(ps1);
        String line = "";
        while (!eof) {
            System.out.flush();
            System.err.flush();
            Thread.yield();
            try {
                boolean retVal;
                boolean eol = false;
                line = "";
                while (!eol) {
                    char aChar = stream.readChar();
                    eol = aChar == '\n';
                    if (eol) continue;
                    line = line + aChar;
                }
                if (line.equals(";")) {
                    line = "";
                }
                if (retVal = this.push(line)) {
                    this.out.print(ps2);
                    continue;
                }
                this.out.print(ps1);
            }
            catch (IOException iOException) {}
        }
    }
}

