/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop.codecomplete;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.meteoinfo.console.NameCompletion;
import org.python.core.Py;
import org.python.core.PyFunction;
import org.python.core.PyList;
import org.python.core.PyMethod;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.util.PythonInterpreter;

public class JIntrospect
implements NameCompletion {
    private final Pattern IMPORT_PACKAGE = Pattern.compile("import\\s+(.+)\\.");
    private final Pattern FROM_PACKAGE_IMPORT = Pattern.compile("from\\s+(\\w+(?:\\.\\w+)*)\\.?(?:\\s*import\\s*)?");
    private final PythonInterpreter interp;

    public JIntrospect(PythonInterpreter interp) {
        this.interp = interp;
    }

    public List<String> completePackageName(String target) {
        String[] targetComponents = target.split("\\.");
        String base = targetComponents[0];
        PySystemState state = this.interp.getSystemState();
        PyObject importer = state.getBuiltins().__getitem__((PyObject)Py.newString((String)"__import__"));
        PyObject module = importer.__call__((PyObject)Py.newString((String)base));
        if (targetComponents.length > 1) {
            for (int i = 1; i < targetComponents.length; ++i) {
                module = module.__getattr__(targetComponents[i]);
            }
        }
        PyList plist = (PyList)module.__dir__();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < plist.__len__(); ++i) {
            String name = plist.get(i).toString();
            if (name.startsWith("__")) continue;
            list.add(name);
        }
        return list;
    }

    public String getPackageName(String command) {
        Matcher match = this.IMPORT_PACKAGE.matcher(command);
        if (match.find()) {
            return match.group(1);
        }
        match = this.FROM_PACKAGE_IMPORT.matcher(command);
        if (match.find()) {
            return match.group(1);
        }
        return null;
    }

    public List<String> getAutoCompleteList(String command) throws IOException {
        return this.getAutoCompleteList(command, true, true, true);
    }

    public List<String> getAutoCompleteList(String command, boolean includeMagic, boolean includeSingle, boolean includeDouble) throws IOException {
        if (command.startsWith("import ") || command.startsWith("from ")) {
            String target = this.getPackageName(command);
            if (target == null) {
                return null;
            }
            return this.completePackageName(target);
        }
        String root = this.getRoot(command, ".");
        if (root.isEmpty()) {
            return null;
        }
        try {
            PyObject object = this.interp.eval(root);
            PyList plist = (PyList)object.__dir__();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < plist.__len__(); ++i) {
                String name = plist.get(i).toString();
                if (name.startsWith("__")) continue;
                list.add(name);
            }
            return list;
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean ispython(Object object) {
        if (object instanceof Class) {
            return false;
        }
        if (object instanceof Object) {
            return false;
        }
        return !(object instanceof PyReflectedFunction);
    }

    public String[] completeName(String paramString) {
        List<String> names = null;
        try {
            names = this.getAutoCompleteList(paramString, true, true, true);
        }
        catch (IOException ex) {
            Logger.getLogger(JIntrospect.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (names == null) {
            return null;
        }
        Collections.sort(names);
        return names.toArray(new String[names.size()]);
    }

    public String getRoot(String command, String terminator) throws IOException {
        PyList tokens;
        String[] temp = command.split("\n");
        if ((command = temp[temp.length - 1]).startsWith("... ")) {
            command = command.substring(4);
        }
        command = command.trim();
        if (terminator.equals("(")) {
            if (command.endsWith("(")) {
                command = command.substring(0, command.length() - 1);
            }
        } else {
            command = this.rtrimTerminus(command, terminator);
        }
        if ((tokens = this.getTokens(command)) == null || tokens.isEmpty()) {
            return "";
        }
        PyTuple token = (PyTuple)tokens.get(tokens.size() - 1);
        if ((Integer)token.get(0) == 0) {
            tokens.remove(tokens.size() - 1);
        }
        if (tokens.isEmpty()) {
            return "";
        }
        token = (PyTuple)tokens.get(tokens.size() - 1);
        if (terminator.equals(".") && (!token.get(1).toString().equals(".") || (Integer)token.get(0) != 51)) {
            return "";
        }
        if (command.endsWith(terminator)) {
            int size = terminator.length();
            command = command.substring(0, command.length() - size);
        }
        command = command.trim();
        tokens = this.getTokens(command);
        tokens.reverse();
        String line = "";
        Integer start = null;
        String prefix = "";
        String laststring = ".";
        ArrayList<String> emptyTypes = new ArrayList<String>();
        emptyTypes.add("[]");
        emptyTypes.add("()");
        emptyTypes.add("{}");
        for (int i = 0; i < tokens.size(); ++i) {
            token = (PyTuple)tokens.get(i);
            int tokentype = (Integer)token.get(0);
            String tokenstring = token.get(1).toString();
            line = token.get(4).toString();
            if (tokentype == 0) continue;
            if (!(tokentype != 1 && tokentype != 2 && tokentype != 3 || laststring.equals("."))) {
                int idx = (Integer)((PyTuple)token.get(3)).get(1);
                if (prefix.isEmpty() || !line.substring(idx, idx + 1).equals(" ")) break;
                prefix = "";
                break;
            }
            if (tokentype == 1 || tokentype == 2 || tokentype == 3 || tokentype == 51 && tokenstring.equals(".")) {
                if (!prefix.isEmpty()) {
                    prefix = "";
                    break;
                }
                start = (int)((Integer)((PyTuple)token.get(2)).get(1));
            } else {
                if (tokenstring.length() != 1 || !"[({])}".contains(tokenstring) || emptyTypes.contains(prefix) && "[({".contains(tokenstring)) break;
                prefix = tokenstring + prefix;
            }
            laststring = tokenstring;
        }
        if (start == null) {
            start = line.length();
        }
        String root = line.substring(start);
        if (emptyTypes.contains(prefix)) {
            root = prefix + root;
        }
        return root;
    }

    public PyList getTokens(String command) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        sb.append("import cStringIO");
        sb.append("\n");
        sb.append("import tokenize");
        sb.append("\n");
        sb.append("command = str('");
        sb.append(command);
        sb.append("')");
        sb.append("\n");
        sb.append("f = cStringIO.StringIO(command)");
        sb.append("\n");
        sb.append("tokens = []");
        sb.append("\n");
        sb.append("def eater(*args):");
        sb.append("\n");
        sb.append("    tokens.append(args)");
        sb.append("\n");
        sb.append("tokenize.tokenize_loop(f.readline, eater)");
        sb.append("\n");
        String code = sb.toString();
        String encoding = "utf-8";
        PythonInterpreter pi = new PythonInterpreter();
        try {
            pi.execfile((InputStream)new ByteArrayInputStream(code.getBytes(encoding)));
            PyList tokens = (PyList)pi.get("tokens");
            return tokens;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String rtrimTerminus(String command, String terminator) {
        String[] pieces;
        if (terminator != null && (pieces = command.split(terminator)).length > 1) {
            command = pieces[0];
            for (int i = 1; i < pieces.length - 1; ++i) {
                command = command + terminator + pieces[i];
            }
            command = command + terminator;
        }
        return command;
    }

    public String[] getCallTipJava(String command) throws IOException {
        String[] callTip = new String[]{"", "", ""};
        String root = this.getRoot(command, "(");
        try {
            PyObject object = this.interp.eval(root);
            if (object instanceof PyFunction) {
                String name;
                PyFunction func = (PyFunction)object;
                callTip[2] = name = func.__doc__.toString();
            } else if (object instanceof PyMethod) {
                String name;
                PyMethod method = (PyMethod)object;
                PyFunction func = (PyFunction)method.__func__;
                callTip[2] = name = func.__doc__.toString();
            } else {
                callTip[2] = object.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return callTip;
    }

    public String[] getTip(String command) {
        try {
            return this.getCallTipJava(command);
        }
        catch (IOException ex) {
            Logger.getLogger(JIntrospect.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

