/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop.forms;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.locationtech.proj4j.proj.Projection;
import org.meteoinfo.desktop.forms.FrmMain;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionNames;
import org.meteoinfo.projection.info.ProjectionInfo;

public class FrmProjection
extends JDialog {
    private final FrmMain _parent;
    private boolean _isLoading = false;
    private ProjectionInfo projInfo;
    private JButton jButton_Apply;
    private JButton jButton_Close;
    private JComboBox jComboBox_Projection;
    private JLabel jLabel1;
    private JLabel jLabel_CentralMeridian;
    private JLabel jLabel_FalseEasting;
    private JLabel jLabel_FalseNorthing;
    private JLabel jLabel_RefLat;
    private JLabel jLabel_ScaleFactor;
    private JLabel jLabel_StdPara1;
    private JLabel jLabel_StdPara2;
    private JPanel jPanel_Parameters;
    private JTextField jTextField_CentralMeridian;
    private JTextField jTextField_FalseEasting;
    private JTextField jTextField_FalseNorthing;
    private JTextField jTextField_RefLat;
    private JTextField jTextField_ScaleFactor;
    private JTextField jTextField_StandPara1;
    private JTextField jTextField_StandPara2;

    public FrmProjection(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this._parent = (FrmMain)parent;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jComboBox_Projection = new JComboBox();
        this.jPanel_Parameters = new JPanel();
        this.jLabel_CentralMeridian = new JLabel();
        this.jTextField_CentralMeridian = new JTextField();
        this.jLabel_RefLat = new JLabel();
        this.jTextField_RefLat = new JTextField();
        this.jLabel_StdPara1 = new JLabel();
        this.jTextField_StandPara1 = new JTextField();
        this.jLabel_StdPara2 = new JLabel();
        this.jTextField_StandPara2 = new JTextField();
        this.jLabel_FalseEasting = new JLabel();
        this.jTextField_FalseEasting = new JTextField();
        this.jLabel_FalseNorthing = new JLabel();
        this.jTextField_FalseNorthing = new JTextField();
        this.jLabel_ScaleFactor = new JLabel();
        this.jTextField_ScaleFactor = new JTextField();
        this.jButton_Apply = new JButton();
        this.jButton_Close = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                FrmProjection.this.formWindowOpened(evt);
            }
        });
        ResourceBundle bundle = ResourceBundle.getBundle("bundle/Bundle_FrmProjection");
        this.jLabel1.setText(bundle.getString("FrmProjection.jLabel1.text"));
        this.jComboBox_Projection.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Projection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmProjection.this.jComboBox_ProjectionActionPerformed(evt);
            }
        });
        this.jPanel_Parameters.setBorder(BorderFactory.createTitledBorder(bundle.getString("FrmProjection.jPanel_Parameters.border.title")));
        this.jLabel_CentralMeridian.setText(bundle.getString("FrmProjection.jLabel_CentralMeridian.text"));
        this.jLabel_RefLat.setText(bundle.getString("FrmProjection.jLabel_RefLat.text"));
        this.jLabel_StdPara1.setText(bundle.getString("FrmProjection.jLabel_StdPara1.text"));
        this.jLabel_StdPara2.setText(bundle.getString("FrmProjection.jLabel_StdPara2.text"));
        this.jLabel_FalseEasting.setText(bundle.getString("FrmProjection.jLabel_FalseEasting.text"));
        this.jLabel_FalseNorthing.setText(bundle.getString("FrmProjection.jLabel_FalseNorthing.text"));
        this.jLabel_ScaleFactor.setText(bundle.getString("FrmProjection.jLabel_ScaleFactor.text"));
        GroupLayout jPanel_ParametersLayout = new GroupLayout(this.jPanel_Parameters);
        this.jPanel_Parameters.setLayout(jPanel_ParametersLayout);
        jPanel_ParametersLayout.setHorizontalGroup(jPanel_ParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ParametersLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_ParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ParametersLayout.createSequentialGroup().addGroup(jPanel_ParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_StdPara1).addComponent(this.jLabel_RefLat).addComponent(this.jLabel_CentralMeridian)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_ParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField_CentralMeridian, -1, 243, Short.MAX_VALUE).addComponent(this.jTextField_RefLat).addComponent(this.jTextField_StandPara1))).addGroup(jPanel_ParametersLayout.createSequentialGroup().addGroup(jPanel_ParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_StdPara2).addComponent(this.jLabel_FalseEasting).addComponent(this.jLabel_FalseNorthing).addComponent(this.jLabel_ScaleFactor)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_ParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField_StandPara2).addComponent(this.jTextField_FalseEasting).addComponent(this.jTextField_FalseNorthing).addComponent(this.jTextField_ScaleFactor)))).addContainerGap()));
        jPanel_ParametersLayout.setVerticalGroup(jPanel_ParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_ParametersLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_ParametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_CentralMeridian).addComponent(this.jTextField_CentralMeridian, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_ParametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_RefLat).addComponent(this.jTextField_RefLat, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel_ParametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_StdPara1).addComponent(this.jTextField_StandPara1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_ParametersLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel_StdPara2).addComponent(this.jTextField_StandPara2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_ParametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_FalseEasting).addComponent(this.jTextField_FalseEasting, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_ParametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_FalseNorthing).addComponent(this.jTextField_FalseNorthing, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_ParametersLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_ScaleFactor).addComponent(this.jTextField_ScaleFactor, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton_Apply.setText(bundle.getString("FrmProjection.jButton_Apply.text"));
        this.jButton_Apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmProjection.this.jButton_ApplyActionPerformed(evt);
            }
        });
        this.jButton_Close.setText(bundle.getString("FrmProjection.jButton_Close.text"));
        this.jButton_Close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmProjection.this.jButton_CloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel_Parameters, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Projection, 0, -1, Short.MAX_VALUE).addGap(9, 9, 9))).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(112, 112, 112).addComponent(this.jButton_Apply).addGap(59, 59, 59).addComponent(this.jButton_Close).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox_Projection, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel_Parameters, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton_Close, -1, 31, Short.MAX_VALUE).addComponent(this.jButton_Apply, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this._isLoading = true;
        this.jComboBox_Projection.removeAllItems();
        block3: for (ProjectionNames pName : ProjectionNames.values()) {
            switch (pName) {
                case Lambert_Equal_Area_Conic: 
                case Lambert_Azimuthal_Equal_Area: 
                case Stereographic_Azimuthal: 
                case Wagner3: 
                case Undefine: {
                    continue block3;
                }
                default: {
                    this.jComboBox_Projection.addItem(pName.toString());
                }
            }
        }
        this._isLoading = false;
        this.jComboBox_Projection.setSelectedItem(this._parent.getMapDocument().getActiveMapFrame().getMapView().getProjection().getProjInfo().getProjectionName().toString());
    }

    private void jComboBox_ProjectionActionPerformed(ActionEvent evt) {
        if (this._isLoading) {
            return;
        }
        ProjectionNames aPrjName = ProjectionNames.valueOf((String)this.jComboBox_Projection.getSelectedItem().toString());
        ProjectionInfo aProjInfo = this._parent.getMapDocument().getActiveMapFrame().getMapView().getProjection().getProjInfo();
        Projection aProj = aProjInfo.getCoordinateReferenceSystem().getProjection();
        ResourceBundle bundle = ResourceBundle.getBundle("bundle/Bundle_FrmProjection");
        this.jLabel_RefLat.setText(bundle.getString("FrmProjection.jLabel_RefLat.text"));
        switch (aPrjName) {
            case LongLat: {
                this.jPanel_Parameters.setEnabled(false);
                for (Component aControl : this.jPanel_Parameters.getComponents()) {
                    aControl.setVisible(false);
                }
                break;
            }
            case Lambert_Conformal_Conic: 
            case Albers_Equal_Area: {
                this.jPanel_Parameters.setEnabled(true);
                for (Component aControl : this.jPanel_Parameters.getComponents()) {
                    aControl.setVisible(true);
                }
                this.jLabel_ScaleFactor.setVisible(false);
                this.jTextField_ScaleFactor.setVisible(false);
                if (aProjInfo.getProjectionName() == aPrjName) {
                    this.jTextField_CentralMeridian.setText(String.valueOf(aProj.getProjectionLongitudeDegrees()));
                    this.jTextField_RefLat.setText(String.valueOf(aProj.getProjectionLatitudeDegrees()));
                    this.jTextField_StandPara1.setText(String.valueOf(aProj.getProjectionLatitude1Degrees()));
                    this.jTextField_StandPara2.setText(String.valueOf(aProj.getProjectionLatitude2Degrees()));
                    this.jTextField_FalseEasting.setText(String.valueOf(aProj.getFalseEasting()));
                    this.jTextField_FalseNorthing.setText(String.valueOf(aProj.getFalseNorthing()));
                    break;
                }
                this.jTextField_CentralMeridian.setText("105");
                this.jTextField_RefLat.setText("0");
                this.jTextField_StandPara1.setText("25");
                this.jTextField_StandPara2.setText("47");
                this.jTextField_FalseEasting.setText("0");
                this.jTextField_FalseNorthing.setText("0");
                break;
            }
            case Lambert_Azimuthal_Equal_Area: {
                this.jPanel_Parameters.setEnabled(true);
                for (Component aControl : this.jPanel_Parameters.getComponents()) {
                    aControl.setVisible(false);
                }
                this.jLabel_CentralMeridian.setVisible(true);
                this.jTextField_CentralMeridian.setVisible(true);
                this.jLabel_RefLat.setVisible(true);
                this.jTextField_RefLat.setVisible(true);
                this.jLabel_FalseEasting.setVisible(true);
                this.jTextField_FalseEasting.setVisible(true);
                this.jLabel_FalseNorthing.setVisible(true);
                this.jTextField_FalseNorthing.setVisible(true);
                if (aProjInfo.getProjectionName() == aPrjName) {
                    this.jTextField_CentralMeridian.setText(String.valueOf(aProj.getProjectionLongitudeDegrees()));
                    this.jTextField_RefLat.setText(String.valueOf(aProj.getProjectionLatitudeDegrees()));
                    this.jTextField_FalseEasting.setText(String.valueOf(aProj.getFalseEasting()));
                    this.jTextField_FalseNorthing.setText(String.valueOf(aProj.getFalseNorthing()));
                    break;
                }
                this.jTextField_CentralMeridian.setText("105");
                this.jTextField_RefLat.setText("90");
                this.jTextField_FalseEasting.setText("0");
                this.jTextField_FalseNorthing.setText("0");
                break;
            }
            case North_Polar_Stereographic_Azimuthal: 
            case South_Polar_Stereographic_Azimuthal: {
                this.jPanel_Parameters.setEnabled(true);
                for (Component aControl : this.jPanel_Parameters.getComponents()) {
                    aControl.setVisible(false);
                }
                this.jLabel_CentralMeridian.setVisible(true);
                this.jTextField_CentralMeridian.setVisible(true);
                this.jLabel_StdPara1.setVisible(true);
                this.jTextField_StandPara1.setVisible(true);
                this.jLabel_ScaleFactor.setVisible(true);
                this.jTextField_ScaleFactor.setVisible(true);
                this.jLabel_FalseEasting.setVisible(true);
                this.jTextField_FalseEasting.setVisible(true);
                this.jLabel_FalseNorthing.setVisible(true);
                this.jTextField_FalseNorthing.setVisible(true);
                if (aProjInfo.getProjectionName() == aPrjName) {
                    this.jTextField_CentralMeridian.setText(String.valueOf(aProj.getProjectionLongitudeDegrees()));
                    this.jTextField_StandPara1.setText(String.valueOf(aProj.getTrueScaleLatitudeDegrees()));
                    this.jTextField_ScaleFactor.setText(String.valueOf(aProj.getScaleFactor()));
                    this.jTextField_FalseEasting.setText(String.valueOf(aProj.getFalseEasting()));
                    this.jTextField_FalseNorthing.setText(String.valueOf(aProj.getFalseNorthing()));
                    break;
                }
                this.jTextField_CentralMeridian.setText("105");
                if (aPrjName == ProjectionNames.North_Polar_Stereographic_Azimuthal) {
                    this.jTextField_StandPara1.setText("90");
                } else {
                    this.jTextField_StandPara1.setText("-90");
                }
                this.jTextField_ScaleFactor.setText("1.0");
                this.jTextField_FalseEasting.setText("0");
                this.jTextField_FalseNorthing.setText("0");
                break;
            }
            case Mercator: {
                this.jPanel_Parameters.setEnabled(true);
                for (Component aControl : this.jPanel_Parameters.getComponents()) {
                    aControl.setVisible(false);
                }
                this.jLabel_CentralMeridian.setVisible(true);
                this.jTextField_CentralMeridian.setVisible(true);
                this.jLabel_StdPara1.setVisible(true);
                this.jTextField_StandPara1.setVisible(true);
                this.jLabel_FalseEasting.setVisible(true);
                this.jTextField_FalseEasting.setVisible(true);
                this.jLabel_FalseNorthing.setVisible(true);
                this.jTextField_FalseNorthing.setVisible(true);
                if (aProjInfo.getProjectionName() == aPrjName) {
                    this.jTextField_CentralMeridian.setText(String.valueOf(aProj.getProjectionLongitudeDegrees()));
                    this.jTextField_StandPara1.setText(String.valueOf(aProj.getProjectionLatitude1Degrees()));
                    this.jTextField_FalseEasting.setText(String.valueOf(aProj.getFalseEasting()));
                    this.jTextField_FalseNorthing.setText(String.valueOf(aProj.getFalseNorthing()));
                    break;
                }
                this.jTextField_CentralMeridian.setText("105");
                this.jTextField_StandPara1.setText("0");
                this.jTextField_FalseEasting.setText("0");
                this.jTextField_FalseNorthing.setText("0");
                break;
            }
            case Robinson: 
            case Molleweide: 
            case Hammer_Eckert: {
                this.jPanel_Parameters.setEnabled(true);
                for (Component aControl : this.jPanel_Parameters.getComponents()) {
                    aControl.setVisible(false);
                }
                this.jLabel_CentralMeridian.setVisible(true);
                this.jTextField_CentralMeridian.setVisible(true);
                if (aProjInfo.getProjectionName() == aPrjName) {
                    this.jTextField_CentralMeridian.setText(String.valueOf(aProj.getProjectionLongitudeDegrees()));
                    break;
                }
                this.jTextField_CentralMeridian.setText("105");
                break;
            }
            case Geostationary_Satellite: {
                this.jPanel_Parameters.setEnabled(true);
                for (Component aControl : this.jPanel_Parameters.getComponents()) {
                    aControl.setVisible(false);
                }
                this.jLabel_CentralMeridian.setVisible(true);
                this.jTextField_CentralMeridian.setVisible(true);
                this.jLabel_RefLat.setText(bundle.getString("FrmProjection.jLabel_RefLat_1.text"));
                this.jLabel_RefLat.setVisible(true);
                this.jTextField_RefLat.setVisible(true);
                if (aProjInfo.getProjectionName() == aPrjName) {
                    this.jTextField_CentralMeridian.setText(String.valueOf(aProj.getProjectionLongitudeDegrees()));
                    this.jTextField_RefLat.setText(String.valueOf(aProj.getHeightOfOrbit()));
                    break;
                }
                this.jTextField_CentralMeridian.setText("105");
                this.jTextField_RefLat.setText("35785831");
                break;
            }
            case Orthographic_Azimuthal: 
            case Oblique_Stereographic_Alternative: 
            case Transverse_Mercator: {
                this.jPanel_Parameters.setEnabled(true);
                for (Component aControl : this.jPanel_Parameters.getComponents()) {
                    aControl.setVisible(false);
                }
                this.jLabel_CentralMeridian.setVisible(true);
                this.jTextField_CentralMeridian.setVisible(true);
                this.jLabel_RefLat.setVisible(true);
                this.jTextField_RefLat.setVisible(true);
                if (aProjInfo.getProjectionName() == aPrjName) {
                    this.jTextField_CentralMeridian.setText(String.valueOf(aProj.getProjectionLongitudeDegrees()));
                    this.jTextField_RefLat.setText(String.valueOf(aProj.getProjectionLatitudeDegrees()));
                    break;
                }
                this.jTextField_CentralMeridian.setText("105");
                this.jTextField_RefLat.setText("45");
                break;
            }
            case Sinusoidal: {
                this.jPanel_Parameters.setEnabled(true);
                for (Component aControl : this.jPanel_Parameters.getComponents()) {
                    aControl.setVisible(false);
                }
                this.jLabel_CentralMeridian.setVisible(true);
                this.jTextField_CentralMeridian.setVisible(true);
                if (aProjInfo.getProjectionName() == aPrjName) {
                    this.jTextField_CentralMeridian.setText(String.valueOf(aProj.getProjectionLongitudeDegrees()));
                    break;
                }
                this.jTextField_CentralMeridian.setText("105");
                break;
            }
            case Cylindrical_Equal_Area: {
                this.jPanel_Parameters.setEnabled(true);
                for (Component aControl : this.jPanel_Parameters.getComponents()) {
                    aControl.setVisible(false);
                }
                this.jLabel_CentralMeridian.setVisible(true);
                this.jTextField_CentralMeridian.setVisible(true);
                this.jLabel_StdPara1.setVisible(true);
                this.jTextField_StandPara1.setVisible(true);
                this.jLabel_FalseEasting.setVisible(true);
                this.jTextField_FalseEasting.setVisible(true);
                this.jLabel_FalseNorthing.setVisible(true);
                this.jTextField_FalseNorthing.setVisible(true);
                if (aProjInfo.getProjectionName() == aPrjName) {
                    this.jTextField_CentralMeridian.setText(String.valueOf(aProj.getProjectionLongitudeDegrees()));
                    this.jTextField_StandPara1.setText(String.valueOf(aProj.getProjectionLatitude1Degrees()));
                    this.jTextField_FalseEasting.setText(String.valueOf(aProj.getFalseEasting()));
                    this.jTextField_FalseNorthing.setText(String.valueOf(aProj.getFalseNorthing()));
                    break;
                }
                this.jTextField_CentralMeridian.setText("105");
                this.jTextField_StandPara1.setText("0");
                this.jTextField_FalseEasting.setText("0");
                this.jTextField_FalseNorthing.setText("0");
            }
        }
        if (this.jTextField_FalseEasting.getText().isEmpty()) {
            this.jTextField_FalseEasting.setText("0");
        }
        if (this.jTextField_FalseNorthing.getText().isEmpty()) {
            this.jTextField_FalseNorthing.setText("0");
        }
    }

    private void jButton_ApplyActionPerformed(ActionEvent evt) {
        String toProjStr;
        this.setCursor(Cursor.getPredefinedCursor(3));
        ProjectionNames aPrjName = ProjectionNames.valueOf((String)this.jComboBox_Projection.getSelectedItem().toString());
        switch (aPrjName) {
            case Lambert_Conformal_Conic: {
                toProjStr = "+proj=lcc +lat_1=" + this.jTextField_StandPara1.getText() + " +lat_2=" + this.jTextField_StandPara2.getText() + " +lat_0=" + this.jTextField_RefLat.getText() + " +lon_0=" + this.jTextField_CentralMeridian.getText() + " +x_0=" + this.jTextField_FalseEasting.getText() + " +y_0=" + this.jTextField_FalseNorthing.getText();
                break;
            }
            case Albers_Equal_Area: {
                toProjStr = "+proj=aea +lat_1=" + this.jTextField_StandPara1.getText() + " +lat_2=" + this.jTextField_StandPara2.getText() + " +lat_0=" + this.jTextField_RefLat.getText() + " +lon_0=" + this.jTextField_CentralMeridian.getText() + " +x_0=" + this.jTextField_FalseEasting.getText() + " +y_0=" + this.jTextField_FalseNorthing.getText();
                break;
            }
            case Lambert_Azimuthal_Equal_Area: {
                toProjStr = "+proj=laea +lat_0=" + this.jTextField_RefLat.getText() + " +lon_0=" + this.jTextField_CentralMeridian.getText() + " +x_0=" + this.jTextField_FalseEasting.getText() + " +y_0=" + this.jTextField_FalseNorthing.getText();
                break;
            }
            case North_Polar_Stereographic_Azimuthal: {
                toProjStr = "+proj=stere +lat_ts=" + this.jTextField_StandPara1.getText() + " +lat_0=90 +lon_0=" + this.jTextField_CentralMeridian.getText();
                break;
            }
            case South_Polar_Stereographic_Azimuthal: {
                toProjStr = "+proj=stere +lat_ts=" + this.jTextField_StandPara1.getText() + " +lat_0=-90 +lon_0=" + this.jTextField_CentralMeridian.getText();
                break;
            }
            case Mercator: {
                toProjStr = "+proj=merc +lat_ts=" + this.jTextField_StandPara1.getText() + " +lon_0=" + this.jTextField_CentralMeridian.getText() + " +x_0=" + this.jTextField_FalseEasting.getText() + " +y_0=" + this.jTextField_FalseNorthing.getText();
                break;
            }
            case Robinson: {
                toProjStr = "+proj=robin +lon_0=" + this.jTextField_CentralMeridian.getText();
                break;
            }
            case Molleweide: {
                toProjStr = "+proj=moll +lon_0=" + this.jTextField_CentralMeridian.getText();
                break;
            }
            case Hammer_Eckert: {
                toProjStr = "+proj=hammer +lon_0=" + this.jTextField_CentralMeridian.getText();
                break;
            }
            case Orthographic_Azimuthal: {
                toProjStr = "+proj=ortho +lon_0=" + this.jTextField_CentralMeridian.getText() + " +lat_0=" + this.jTextField_RefLat.getText();
                break;
            }
            case Geostationary_Satellite: {
                toProjStr = "+proj=geos +lon_0=" + this.jTextField_CentralMeridian.getText() + " +h=" + this.jTextField_RefLat.getText();
                break;
            }
            case Oblique_Stereographic_Alternative: {
                toProjStr = "+proj=stere +lon_0=" + this.jTextField_CentralMeridian.getText() + " +lat_0=" + this.jTextField_RefLat.getText();
                break;
            }
            case Transverse_Mercator: {
                toProjStr = "+proj=tmerc +lon_0=" + this.jTextField_CentralMeridian.getText() + " +lat_0=" + this.jTextField_RefLat.getText();
                break;
            }
            case LongLat: {
                toProjStr = KnownCoordinateSystems.geographic.world.WGS1984.toProj4String();
                break;
            }
            case Sinusoidal: {
                toProjStr = "+proj=sinu+lon_0=" + this.jTextField_CentralMeridian.getText();
                break;
            }
            case Cylindrical_Equal_Area: {
                toProjStr = "+proj=cea +lat_ts=" + this.jTextField_StandPara1.getText() + " +lon_0=" + this.jTextField_CentralMeridian.getText() + " +x_0=" + this.jTextField_FalseEasting.getText() + " +y_0=" + this.jTextField_FalseNorthing.getText();
                break;
            }
            default: {
                toProjStr = "+proj=robin +lon_0=" + this.jTextField_CentralMeridian.getText();
            }
        }
        ProjectionInfo toProj = ProjectionInfo.factory((String)toProjStr);
        this._parent.getMapDocument().getActiveMapFrame().getMapView().projectLayers(toProj);
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void jButton_CloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmProjection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmProjection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmProjection.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmProjection.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmProjection dialog = new FrmProjection((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

