/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop.forms;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableModel;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.XYListDataset;
import org.meteoinfo.data.meteodata.ascii.LonLatStationDataInfo;
import org.meteoinfo.desktop.config.GenericFileFilter;
import org.meteoinfo.global.MIMath;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.info.ProjectionInfo;
import org.meteoinfo.table.RowHeaderTable;

public class FrmViewData
extends JFrame {
    private double _missingValue;
    private String _dataType = "GridData";
    private Object _data;
    private String[] _colNames;
    private JButton jButton_Chart;
    private JButton jButton_Save;
    private JButton jButton_Stat;
    private JButton jButton_ToStation;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JTable jTable1;
    private JToolBar jToolBar1;

    public void setMissingValue(double value) {
        this._missingValue = value;
    }

    public void setGridData(GridData value) {
        this._data = value;
        this._dataType = "GridData";
        this.jButton_ToStation.setEnabled(true);
        GridData gData = (GridData)this._data;
        int xNum = gData.getXNum();
        int yNum = gData.getYNum();
        Object[][] tData = new Object[yNum][xNum];
        this._colNames = new String[xNum];
        for (int i = 0; i < xNum; ++i) {
            this._colNames[i] = String.valueOf(i);
        }
        double min = gData.getMaxMinValue()[1];
        int dNum = MIMath.getDecimalNum((double)min);
        String dFormat = "%1$." + String.valueOf(dNum) + "f";
        for (int i = 0; i < yNum; ++i) {
            for (int j = 0; j < xNum; ++j) {
                tData[i][j] = String.format(dFormat, gData.data[i][j]);
            }
        }
        DefaultTableModel model = new DefaultTableModel(tData, this._colNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jTable1.setModel(model);
        this.jScrollPane1.setRowHeaderView((Component)new RowHeaderTable(this.jTable1, 40, true));
    }

    public void setStationData(StationData value) {
        this._data = value;
        this._dataType = "StationData";
        this.jButton_ToStation.setEnabled(false);
        StationData sData = (StationData)this._data;
        double min = sData.getMinValue();
        int dNum = MIMath.getDecimalNum((double)min);
        String dFormat = "%1$." + String.valueOf(dNum) + "f";
        int yNum = sData.getStNum();
        int xNum = 4;
        Object[][] tData = new Object[yNum][xNum];
        for (int i = 0; i < xNum; ++i) {
            int j;
            if (i == 0) {
                for (j = 0; j < yNum; ++j) {
                    tData[j][i] = sData.stations.get(j);
                }
                continue;
            }
            if (i <= 2) {
                for (j = 0; j < yNum; ++j) {
                    tData[j][i] = String.valueOf(sData.data[j][i - 1]);
                }
                continue;
            }
            for (j = 0; j < yNum; ++j) {
                tData[j][i] = String.format(dFormat, sData.data[j][i - 1]);
            }
        }
        DefaultTableModel model = new DefaultTableModel(tData, this._colNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jTable1.setModel(model);
        this.jScrollPane1.setRowHeaderView((Component)new RowHeaderTable(this.jTable1, 40));
    }

    public void setXYData(XYListDataset value) {
        this._data = value;
        this._dataType = "XYData";
        this.jButton_ToStation.setEnabled(false);
        double min = value.getY(0, 0);
        int dNum = MIMath.getDecimalNum((double)min);
        String dFormat = "%1$." + String.valueOf(dNum) + "f";
        int yNum = value.getItemCount();
        int xNum = value.getSeriesCount() * 2;
        this._colNames = new String[xNum];
        for (int i = 0; i < xNum / 2; ++i) {
            this._colNames[i * 2] = value.getSeriesKey(i) + "_X";
            this._colNames[i * 2 + 1] = value.getSeriesKey(i) + "_Y";
        }
        Object[][] tData = new Object[yNum][xNum];
        for (int i = 0; i < xNum / 2; ++i) {
            for (int j = 0; j < yNum; ++j) {
                tData[j][i * 2] = value.getX(i, j);
                tData[j][i * 2 + 1] = value.getY(i, j);
            }
        }
        DefaultTableModel model = new DefaultTableModel(tData, this._colNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.jTable1.setModel(model);
        this.jScrollPane1.setRowHeaderView((Component)new RowHeaderTable(this.jTable1, 40));
    }

    public FrmViewData() {
        this.initComponents();
        this.setSize(600, 400);
        this.setDefaultCloseOperation(2);
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/MeteoInfo_1_16x16x8.png"));
            this.setIconImage(image);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jButton_Stat.setEnabled(false);
        this.jButton_Chart.setEnabled(false);
    }

    public FrmViewData(String[] colNames) {
        this();
        this._colNames = colNames;
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButton_Save = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButton_ToStation = new JButton();
        this.jButton_Stat = new JButton();
        this.jButton_Chart = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.setDefaultCloseOperation(3);
        this.jToolBar1.setRollover(true);
        this.jButton_Save.setIcon(new ImageIcon(this.getClass().getResource("/images/Disk_1_16x16x8.png")));
        this.jButton_Save.setToolTipText("Save File");
        this.jButton_Save.setFocusable(false);
        this.jButton_Save.setHorizontalTextPosition(0);
        this.jButton_Save.setVerticalTextPosition(3);
        this.jButton_Save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmViewData.this.jButton_SaveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Save);
        this.jToolBar1.add(this.jSeparator1);
        this.jButton_ToStation.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_NewPoint.Image.png")));
        this.jButton_ToStation.setToolTipText("To Station Data");
        this.jButton_ToStation.setFocusable(false);
        this.jButton_ToStation.setHorizontalTextPosition(0);
        this.jButton_ToStation.setVerticalTextPosition(3);
        this.jButton_ToStation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmViewData.this.jButton_ToStationActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ToStation);
        this.jButton_Stat.setIcon(new ImageIcon(this.getClass().getResource("/images/Statictics.png")));
        this.jButton_Stat.setToolTipText("Statistics");
        this.jButton_Stat.setFocusable(false);
        this.jButton_Stat.setHorizontalTextPosition(0);
        this.jButton_Stat.setVerticalTextPosition(3);
        this.jToolBar1.add(this.jButton_Stat);
        this.jButton_Chart.setIcon(new ImageIcon(this.getClass().getResource("/images/chart.png")));
        ResourceBundle bundle = ResourceBundle.getBundle("bundle/Bundle_FrmMeteoData");
        this.jButton_Chart.setToolTipText(bundle.getString("FrmMeteoData.jButton_1DPlot.toolTipText"));
        this.jButton_Chart.setFocusable(false);
        this.jButton_Chart.setHorizontalTextPosition(0);
        this.jButton_Chart.setVerticalTextPosition(3);
        this.jButton_Chart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmViewData.this.jButton_ChartActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Chart);
        this.getContentPane().add((Component)this.jToolBar1, "First");
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jTable1.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.pack();
    }

    private void jButton_ChartActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(null, "Under developing!");
    }

    private void jButton_ToStationActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"txt", "csv"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Supported Formats");
        aDlg.setFileFilter(mapFileFilter);
        if (0 == aDlg.showOpenDialog(this)) {
            File inf = aDlg.getSelectedFile();
            String inFile = inf.getAbsolutePath();
            JFileChooser outDlg = new JFileChooser();
            outDlg.setCurrentDirectory(pathDir);
            fileExts = new String[]{"csv"};
            GenericFileFilter txtFileFilter = new GenericFileFilter(fileExts, "CSV file (*.csv)");
            outDlg.setFileFilter(txtFileFilter);
            outDlg.setAcceptAllFileFilterUsed(false);
            if (0 == outDlg.showSaveDialog(this)) {
                ProjectionInfo projInfo;
                this.setCursor(Cursor.getPredefinedCursor(3));
                String fileName = outDlg.getSelectedFile().getAbsolutePath();
                String extent = ((GenericFileFilter)outDlg.getFileFilter()).getFileExtent();
                if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                    fileName = fileName + "." + extent;
                }
                if ((projInfo = ((GridData)this._data).projInfo).isLonLat()) {
                    try {
                        ((GridData)this._data).toStation(inFile, fileName);
                    }
                    catch (FileNotFoundException ex) {
                        Logger.getLogger(FrmViewData.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(FrmViewData.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    int result = JOptionPane.showConfirmDialog(null, "If project stations?", "Confirm", 1);
                    if (result == 0) {
                        try {
                            ProjectionInfo fromProj;
                            LonLatStationDataInfo aDataInfo = new LonLatStationDataInfo();
                            aDataInfo.readDataInfo(inFile);
                            StationData inStData = aDataInfo.getNullStationData();
                            inStData.projInfo = fromProj = KnownCoordinateSystems.geographic.world.WGS1984;
                            StationData outStData = ((GridData)this._data).toStation(inStData);
                            outStData.saveAsCSVFile(fileName, "data");
                        }
                        catch (FileNotFoundException ex) {
                            Logger.getLogger(FrmViewData.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(FrmViewData.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    } else {
                        try {
                            ((GridData)this._data).toStation(inFile, fileName);
                        }
                        catch (FileNotFoundException ex) {
                            Logger.getLogger(FrmViewData.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(FrmViewData.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private void jButton_SaveActionPerformed(ActionEvent evt) {
        GenericFileFilter txtFileFilter;
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser outDlg = new JFileChooser();
        outDlg.setCurrentDirectory(pathDir);
        if (this._data instanceof GridData) {
            String[] fileExts = new String[]{"dat"};
            txtFileFilter = new GenericFileFilter(fileExts, "Surfer ASCII file (*.dat)");
        } else {
            String[] fileExts = new String[]{"csv"};
            txtFileFilter = new GenericFileFilter(fileExts, "CSV file (*.csv)");
        }
        outDlg.setFileFilter(txtFileFilter);
        outDlg.setAcceptAllFileFilterUsed(false);
        if (0 == outDlg.showSaveDialog(this)) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            String fileName = outDlg.getSelectedFile().getAbsolutePath();
            String extent = ((GenericFileFilter)outDlg.getFileFilter()).getFileExtent();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }
            if (this._data instanceof GridData) {
                ((GridData)this._data).saveAsSurferASCIIFile(fileName);
            } else {
                ((StationData)this._data).saveAsCSVFile(fileName, this._colNames[this._colNames.length - 1]);
            }
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmViewData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmViewData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmViewData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmViewData.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FrmViewData().setVisible(true);
            }
        });
    }
}

