/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.meteoinfo.desktop.forms;

import org.meteoinfo.data.GridData;
import org.meteoinfo.ndarray.Dimension;
import org.meteoinfo.data.meteodata.DrawMeteoData;
import org.meteoinfo.data.meteodata.DrawType2D;
import org.meteoinfo.data.meteodata.MeteoDataInfo;
import org.meteoinfo.data.meteodata.PlotDimension;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.grads.GrADSDataInfo;
import org.meteoinfo.global.Extent;
import org.meteoinfo.global.PointF;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.print.PrintException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.meteoinfo.ndarray.DimensionType;
import org.meteoinfo.layer.FrmLabelSet;
import org.meteoinfo.layer.LayerTypes;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layer.VectorLayer;
import org.meteoinfo.layout.FrmPageSet;
import org.meteoinfo.layout.LayoutLegend;
import org.meteoinfo.layout.LegendStyles;
import org.meteoinfo.layout.MouseMode;
import org.meteoinfo.legend.FrmLegendSet;
import org.meteoinfo.legend.LayerNode;
import org.meteoinfo.legend.LegendManage;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.LegendType;
import org.meteoinfo.legend.MapFrame;
import org.meteoinfo.legend.NodeTypes;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.desktop.config.GenericFileFilter;
import org.meteoinfo.image.AnimatedGifEncoder;
import org.meteoinfo.shape.ShapeTypes;

/**
 *
 * @author Yaqiang Wang
 */
public class FrmSectionPlot extends javax.swing.JFrame {
    // <editor-fold desc ="Variables">

    private JButton _currentTool = null;
    private MeteoDataInfo _meteoDataInfo = new MeteoDataInfo();
    private GridData _gridData = null;
    private int _lastAddedLayerHandle;
    private PlotDimension _plotDimension;
    private List<String> _XGridStrs = new ArrayList<>();
    private List<String> _YGridStrs = new ArrayList<>();
    private boolean _useSameLegendScheme = false;
    private LegendScheme _legendScheme = null;
    private boolean _isLoading = false;
    private DrawType2D _2DDrawType = DrawType2D.Contour;
    private int _skipY = 1;
    private int _skipX = 1;
    private double[] _CValues, _X, _Y;
    private Color[] _colors;
    private int _strmDensity = 4;
    private boolean _isSamePlotDim = false;
    private boolean _enableAnimation = true;
    private boolean _isRunning = false;
    // </editor-fold>

    /**
     * Creates new form FrmSectionPlot
     *
     * @param aDataInfo
     */
    public FrmSectionPlot(MeteoDataInfo aDataInfo) {
        initComponents();

        this.layersLegend1.setMapLayout(mapLayout1);
        this.mapLayout1.getActiveMapFrame().setLayoutBounds(new Rectangle(40, 36, 606, 420));
        this.mapLayout1.getActiveMapFrame().getMapView().setGeoMap(false);
        this.jComboBox_Variable.setEditable(true);
//        this.jTextField_NewVariable.setVisible(false);
//        Graphics g = this.getGraphics();
//        FontMetrics metrics = g.getFontMetrics(this.jLabel_Variable.getFont());
//        this.jLabel_Variable.setSize(metrics.stringWidth(this.jLabel_Variable.getText()), metrics.getHeight());
//        this.jLabel_Variable.setLocation(this.jComboBox_Variable.getX() - this.jLabel_Variable.getWidth() - 4, this.jLabel_Variable.getY());

        this.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        _meteoDataInfo = aDataInfo;
        //TB_NewVariable.Visible = false;                

        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/MeteoInfo_1_16x16x8.png"));
        } catch (Exception e) {
        }
        this.setIconImage(image);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jToolBar1 = new javax.swing.JToolBar();
        jButton_DataInfo = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JToolBar.Separator();
        jButton_Draw = new javax.swing.JButton();
        jButton_ViewData = new javax.swing.JButton();
        jButton_ClearDraw = new javax.swing.JButton();
        jSeparator2 = new javax.swing.JToolBar.Separator();
        jButton_PreTime = new javax.swing.JButton();
        jButton_NexTime = new javax.swing.JButton();
        jButton_Animator = new javax.swing.JButton();
        jButton_CreateAnimatorFile = new javax.swing.JButton();
        jSeparator3 = new javax.swing.JToolBar.Separator();
        jButton_DrawSetting = new javax.swing.JButton();
        jSeparator4 = new javax.swing.JToolBar.Separator();
        jButton_SelectElement = new javax.swing.JButton();
        jButton_ZoomIn = new javax.swing.JButton();
        jButton_ZoomOut = new javax.swing.JButton();
        jButton_Pan = new javax.swing.JButton();
        jButton_FullExtent = new javax.swing.JButton();
        jButton_ZoomToLayer = new javax.swing.JButton();
        jButton_Identifer = new javax.swing.JButton();
        jSeparator5 = new javax.swing.JToolBar.Separator();
        jButton_LabelSet = new javax.swing.JButton();
        jSeparator6 = new javax.swing.JToolBar.Separator();
        jButton_PageSet = new javax.swing.JButton();
        jButton_PageZoomIn = new javax.swing.JButton();
        jButton_PageZoomOut = new javax.swing.JButton();
        jButton_FitToScreen = new javax.swing.JButton();
        jComboBox_PageZoom = new javax.swing.JComboBox();
        jSeparator7 = new javax.swing.JToolBar.Separator();
        jButton_SavePicture = new javax.swing.JButton();
        jSplitPane1 = new javax.swing.JSplitPane();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel_Setting = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        jLabel_Variable = new javax.swing.JLabel();
        jComboBox_DrawType = new javax.swing.JComboBox();
        jCheckBox_YReverse = new javax.swing.JCheckBox();
        jCheckBox_ColorVar = new javax.swing.JCheckBox();
        jLabel4 = new javax.swing.JLabel();
        jComboBox_PlotDim = new javax.swing.JComboBox();
        jPanel1 = new javax.swing.JPanel();
        jCheckBox_Time = new javax.swing.JCheckBox();
        jComboBox_Time1 = new javax.swing.JComboBox();
        jCheckBox_Level = new javax.swing.JCheckBox();
        jComboBox_Time2 = new javax.swing.JComboBox();
        jComboBox_Level1 = new javax.swing.JComboBox();
        jComboBox_Level2 = new javax.swing.JComboBox();
        jCheckBox_Lat = new javax.swing.JCheckBox();
        jComboBox_Lat1 = new javax.swing.JComboBox();
        jComboBox_Lat2 = new javax.swing.JComboBox();
        jCheckBox_Lon = new javax.swing.JCheckBox();
        jComboBox_Lon1 = new javax.swing.JComboBox();
        jComboBox_Lon2 = new javax.swing.JComboBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList_Stations = new javax.swing.JList();
        jComboBox_Variable = new javax.swing.JComboBox();
        jPanel_Layers = new javax.swing.JPanel();
        layersLegend1 = new org.meteoinfo.legend.LayersLegend();
        mapLayout1 = new org.meteoinfo.layout.MapLayout();
        jToolBar2 = new javax.swing.JToolBar();
        jLabel_Coordinate = new javax.swing.JLabel();
        jLabel_Status = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("bundle/Bundle_FrmSectionPlot"); // NOI18N
        setTitle(bundle.getString("FrmSectionPlot.title")); // NOI18N
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jToolBar1.setFloatable(false);
        jToolBar1.setRollover(true);

        jButton_DataInfo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/information.png"))); // NOI18N
        java.util.ResourceBundle bundle1 = java.util.ResourceBundle.getBundle("bundle/Bundle_FrmMeteoData"); // NOI18N
        jButton_DataInfo.setToolTipText(bundle1.getString("FrmMeteoData.jButton_DataInfo.toolTipText")); // NOI18N
        jButton_DataInfo.setFocusable(false);
        jButton_DataInfo.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_DataInfo.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_DataInfo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_DataInfoActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_DataInfo);
        jToolBar1.add(jSeparator1);

        jButton_Draw.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/MeteoInfo_1_16x16x8.png"))); // NOI18N
        jButton_Draw.setToolTipText(bundle1.getString("FrmMeteoData.jButton_Draw.toolTipText")); // NOI18N
        jButton_Draw.setFocusable(false);
        jButton_Draw.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_Draw.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_Draw.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_DrawActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_Draw);

        jButton_ViewData.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_ViewData.Image.png"))); // NOI18N
        jButton_ViewData.setToolTipText(bundle1.getString("FrmMeteoData.jButton_ViewData.toolTipText")); // NOI18N
        jButton_ViewData.setFocusable(false);
        jButton_ViewData.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_ViewData.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_ViewData.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ViewDataActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_ViewData);

        jButton_ClearDraw.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_ClearDrawing.Image.png"))); // NOI18N
        jButton_ClearDraw.setToolTipText(bundle1.getString("FrmMeteoData.jButton_ClearDraw.toolTipText")); // NOI18N
        jButton_ClearDraw.setFocusable(false);
        jButton_ClearDraw.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_ClearDraw.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_ClearDraw.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ClearDrawActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_ClearDraw);
        jToolBar1.add(jSeparator2);

        jButton_PreTime.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_PreTime.Image.png"))); // NOI18N
        jButton_PreTime.setToolTipText(bundle1.getString("FrmMeteoData.jButton_PreTime.toolTipText")); // NOI18N
        jButton_PreTime.setFocusable(false);
        jButton_PreTime.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_PreTime.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_PreTime.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_PreTimeActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_PreTime);

        jButton_NexTime.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_NextTime.Image.png"))); // NOI18N
        jButton_NexTime.setToolTipText(bundle1.getString("FrmMeteoData.jButton_NexTime.toolTipText")); // NOI18N
        jButton_NexTime.setFocusable(false);
        jButton_NexTime.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_NexTime.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_NexTime.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_NexTimeActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_NexTime);

        jButton_Animator.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/animation-1.png"))); // NOI18N
        jButton_Animator.setFocusable(false);
        jButton_Animator.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_Animator.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_Animator.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_AnimatorActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_Animator);

        jButton_CreateAnimatorFile.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/Animation-2.png"))); // NOI18N
        jButton_CreateAnimatorFile.setToolTipText(bundle1.getString("FrmMeteoData.jButton_CreateAnimatorFile.toolTipText")); // NOI18N
        jButton_CreateAnimatorFile.setFocusable(false);
        jButton_CreateAnimatorFile.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_CreateAnimatorFile.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_CreateAnimatorFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_CreateAnimatorFileActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_CreateAnimatorFile);
        jToolBar1.add(jSeparator3);

        jButton_DrawSetting.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_DrawSetting.Image.png"))); // NOI18N
        jButton_DrawSetting.setToolTipText(bundle1.getString("FrmMeteoData.jButton_DrawSetting.toolTipText")); // NOI18N
        jButton_DrawSetting.setFocusable(false);
        jButton_DrawSetting.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_DrawSetting.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_DrawSetting.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_DrawSettingActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_DrawSetting);
        jToolBar1.add(jSeparator4);

        jButton_SelectElement.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/Arrow.png"))); // NOI18N
        java.util.ResourceBundle bundle2 = java.util.ResourceBundle.getBundle("bundle/Bundle_FrmMain"); // NOI18N
        jButton_SelectElement.setToolTipText(bundle2.getString("FrmMain.jButton_SelectElement.toolTipText")); // NOI18N
        jButton_SelectElement.setFocusable(false);
        jButton_SelectElement.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_SelectElement.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_SelectElement.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_SelectElementActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_SelectElement);

        jButton_ZoomIn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_ZoomIn.Image.png"))); // NOI18N
        jButton_ZoomIn.setToolTipText(bundle2.getString("FrmMain.jButton_ZoomIn.toolTipText")); // NOI18N
        jButton_ZoomIn.setFocusable(false);
        jButton_ZoomIn.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_ZoomIn.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_ZoomIn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ZoomInActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_ZoomIn);

        jButton_ZoomOut.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_ZoomOut.Image.png"))); // NOI18N
        jButton_ZoomOut.setToolTipText(bundle2.getString("FrmMain.jButton_ZoomOut.toolTipText")); // NOI18N
        jButton_ZoomOut.setFocusable(false);
        jButton_ZoomOut.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_ZoomOut.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_ZoomOut.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ZoomOutActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_ZoomOut);

        jButton_Pan.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_Pan.Image.png"))); // NOI18N
        jButton_Pan.setToolTipText(bundle2.getString("FrmMain.jButton_Pan.toolTipText")); // NOI18N
        jButton_Pan.setFocusable(false);
        jButton_Pan.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_Pan.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_Pan.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_PanActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_Pan);

        jButton_FullExtent.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_FullExent.Image.png"))); // NOI18N
        jButton_FullExtent.setToolTipText(bundle2.getString("FrmMain.jButton_FullExtent.toolTipText")); // NOI18N
        jButton_FullExtent.setFocusable(false);
        jButton_FullExtent.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_FullExtent.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_FullExtent.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_FullExtentActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_FullExtent);

        jButton_ZoomToLayer.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_ZoomToLayer.Image.png"))); // NOI18N
        jButton_ZoomToLayer.setToolTipText(bundle2.getString("FrmMain.jButton_ZoomToLayer.toolTipText")); // NOI18N
        jButton_ZoomToLayer.setFocusable(false);
        jButton_ZoomToLayer.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_ZoomToLayer.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_ZoomToLayer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_ZoomToLayerActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_ZoomToLayer);

        jButton_Identifer.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/information.png"))); // NOI18N
        jButton_Identifer.setToolTipText(bundle2.getString("FrmMain.jButton_Identifer.toolTipText")); // NOI18N
        jButton_Identifer.setFocusable(false);
        jButton_Identifer.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_Identifer.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_Identifer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_IdentiferActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_Identifer);
        jToolBar1.add(jSeparator5);

        jButton_LabelSet.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_LabelSet.Image.png"))); // NOI18N
        jButton_LabelSet.setToolTipText(bundle2.getString("FrmMain.jButton_LabelSet.toolTipText")); // NOI18N
        jButton_LabelSet.setFocusable(false);
        jButton_LabelSet.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_LabelSet.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_LabelSet.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_LabelSetActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_LabelSet);
        jToolBar1.add(jSeparator6);

        jButton_PageSet.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/page_portrait.png"))); // NOI18N
        jButton_PageSet.setToolTipText(bundle2.getString("FrmMain.jButton_PageSet.toolTipText")); // NOI18N
        jButton_PageSet.setFocusable(false);
        jButton_PageSet.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_PageSet.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_PageSet.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_PageSetActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_PageSet);

        jButton_PageZoomIn.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_PageZoomIn.Image.png"))); // NOI18N
        jButton_PageZoomIn.setToolTipText(bundle2.getString("FrmMain.jButton_PageZoomIn.toolTipText")); // NOI18N
        jButton_PageZoomIn.setFocusable(false);
        jButton_PageZoomIn.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_PageZoomIn.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_PageZoomIn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_PageZoomInActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_PageZoomIn);

        jButton_PageZoomOut.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/TSB_PageZoomOut.Image.png"))); // NOI18N
        jButton_PageZoomOut.setToolTipText(bundle2.getString("FrmMain.jButton_PageZoomOut.toolTipText")); // NOI18N
        jButton_PageZoomOut.setFocusable(false);
        jButton_PageZoomOut.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_PageZoomOut.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_PageZoomOut.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_PageZoomOutActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_PageZoomOut);

        jButton_FitToScreen.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/ZoomFullMap.png"))); // NOI18N
        jButton_FitToScreen.setToolTipText(bundle2.getString("FrmMain.jButton_FitToScreen.toolTipText")); // NOI18N
        jButton_FitToScreen.setFocusable(false);
        jButton_FitToScreen.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_FitToScreen.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_FitToScreen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_FitToScreenActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_FitToScreen);

        jComboBox_PageZoom.setEditable(true);
        jComboBox_PageZoom.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_PageZoom.setMinimumSize(new java.awt.Dimension(20, 24));
        jComboBox_PageZoom.setPreferredSize(new java.awt.Dimension(40, 24));
        jComboBox_PageZoom.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox_PageZoomActionPerformed(evt);
            }
        });
        jToolBar1.add(jComboBox_PageZoom);
        jToolBar1.add(jSeparator7);

        jButton_SavePicture.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/Save_Image.png"))); // NOI18N
        jButton_SavePicture.setToolTipText(bundle2.getString("FrmMain.jButton_SavePicture.toolTipText")); // NOI18N
        jButton_SavePicture.setFocusable(false);
        jButton_SavePicture.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton_SavePicture.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton_SavePicture.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton_SavePictureActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton_SavePicture);

        jSplitPane1.setDividerLocation(250);

        jLabel3.setText(bundle.getString("FrmSectionPlot.jLabel3.text")); // NOI18N

        jLabel_Variable.setText(bundle.getString("FrmSectionPlot.jLabel_Variable.text")); // NOI18N

        jComboBox_DrawType.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_DrawType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox_DrawTypeActionPerformed(evt);
            }
        });

        jCheckBox_YReverse.setText(bundle.getString("FrmSectionPlot.jCheckBox_YReverse.text")); // NOI18N

        jCheckBox_ColorVar.setText(bundle.getString("FrmSectionPlot.jCheckBox_ColorVar.text")); // NOI18N

        jLabel4.setText(bundle.getString("FrmSectionPlot.jLabel4.text")); // NOI18N

        jComboBox_PlotDim.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_PlotDim.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox_PlotDimActionPerformed(evt);
            }
        });

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("FrmSectionPlot.jPanel1.border.title"))); // NOI18N

        jCheckBox_Time.setText(bundle.getString("FrmSectionPlot.jCheckBox_Time.text")); // NOI18N
        jCheckBox_Time.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jCheckBox_TimeStateChanged(evt);
            }
        });

        jComboBox_Time1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jCheckBox_Level.setText(bundle.getString("FrmSectionPlot.jCheckBox_Level.text")); // NOI18N
        jCheckBox_Level.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jCheckBox_LevelStateChanged(evt);
            }
        });

        jComboBox_Time2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jComboBox_Level1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jComboBox_Level2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jCheckBox_Lat.setText(bundle.getString("FrmSectionPlot.jCheckBox_Lat.text")); // NOI18N
        jCheckBox_Lat.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jCheckBox_LatStateChanged(evt);
            }
        });

        jComboBox_Lat1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jComboBox_Lat2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jCheckBox_Lon.setText(bundle.getString("FrmSectionPlot.jCheckBox_Lon.text")); // NOI18N
        jCheckBox_Lon.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jCheckBox_LonStateChanged(evt);
            }
        });

        jComboBox_Lon1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jComboBox_Lon2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));

        jList_Stations.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jScrollPane1.setViewportView(jList_Stations);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jCheckBox_Lat)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jComboBox_Lat2, 0, 213, Short.MAX_VALUE)
                            .addComponent(jComboBox_Lat1, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(jCheckBox_Lon)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jComboBox_Lon1, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jScrollPane1)
                            .addComponent(jComboBox_Lon2, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jCheckBox_Level)
                            .addComponent(jCheckBox_Time))
                        .addGap(6, 6, 6)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jComboBox_Time1, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jComboBox_Time2, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jComboBox_Level1, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jComboBox_Level2, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBox_Time)
                    .addComponent(jComboBox_Time1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jComboBox_Time2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBox_Level)
                    .addComponent(jComboBox_Level1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jComboBox_Level2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBox_Lat)
                    .addComponent(jComboBox_Lat1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jComboBox_Lat2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBox_Lon)
                    .addComponent(jComboBox_Lon1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jComboBox_Lon2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 72, Short.MAX_VALUE))
        );

        jComboBox_Variable.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Item 1", "Item 2", "Item 3", "Item 4" }));
        jComboBox_Variable.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox_VariableActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel_SettingLayout = new javax.swing.GroupLayout(jPanel_Setting);
        jPanel_Setting.setLayout(jPanel_SettingLayout);
        jPanel_SettingLayout.setHorizontalGroup(
            jPanel_SettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_SettingLayout.createSequentialGroup()
                .addGroup(jPanel_SettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel_SettingLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel_SettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel_SettingLayout.createSequentialGroup()
                                .addComponent(jCheckBox_YReverse)
                                .addGap(18, 18, 18)
                                .addComponent(jCheckBox_ColorVar)
                                .addGap(0, 4, Short.MAX_VALUE))
                            .addGroup(jPanel_SettingLayout.createSequentialGroup()
                                .addComponent(jLabel4)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jComboBox_PlotDim, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .addGroup(jPanel_SettingLayout.createSequentialGroup()
                                .addGroup(jPanel_SettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(jPanel_SettingLayout.createSequentialGroup()
                                        .addComponent(jLabel3)
                                        .addGap(8, 8, 8))
                                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel_SettingLayout.createSequentialGroup()
                                        .addComponent(jLabel_Variable)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)))
                                .addGroup(jPanel_SettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jComboBox_DrawType, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(jComboBox_Variable, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))))
                .addContainerGap())
        );
        jPanel_SettingLayout.setVerticalGroup(
            jPanel_SettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel_SettingLayout.createSequentialGroup()
                .addGap(9, 9, 9)
                .addGroup(jPanel_SettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel_Variable)
                    .addComponent(jComboBox_Variable, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel_SettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(jComboBox_DrawType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel_SettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCheckBox_YReverse)
                    .addComponent(jCheckBox_ColorVar))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel_SettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel4)
                    .addComponent(jComboBox_PlotDim, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab(bundle.getString("FrmSectionPlot.jPanel_Setting.TabConstraints.tabTitle"), jPanel_Setting); // NOI18N

        javax.swing.GroupLayout jPanel_LayersLayout = new javax.swing.GroupLayout(jPanel_Layers);
        jPanel_Layers.setLayout(jPanel_LayersLayout);
        jPanel_LayersLayout.setHorizontalGroup(
            jPanel_LayersLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(layersLegend1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 244, Short.MAX_VALUE)
        );
        jPanel_LayersLayout.setVerticalGroup(
            jPanel_LayersLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(layersLegend1, javax.swing.GroupLayout.DEFAULT_SIZE, 520, Short.MAX_VALUE)
        );

        jTabbedPane1.addTab(bundle.getString("FrmSectionPlot.jPanel_Layers.TabConstraints.tabTitle"), jPanel_Layers); // NOI18N

        jSplitPane1.setLeftComponent(jTabbedPane1);
        jSplitPane1.setRightComponent(mapLayout1);

        jToolBar2.setFloatable(false);
        jToolBar2.setRollover(true);

        jLabel_Coordinate.setText(bundle2.getString("FrmMain.jLabel_Coordinate.text")); // NOI18N
        jLabel_Coordinate.setPreferredSize(new java.awt.Dimension(80, 15));
        jToolBar2.add(jLabel_Coordinate);

        jLabel_Status.setText(bundle2.getString("FrmMain.jLabel_Status.text")); // NOI18N
        jToolBar2.add(jLabel_Status);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jSplitPane1)
            .addComponent(jToolBar2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 666, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 134, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSplitPane1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jToolBar2, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton_DataInfoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_DataInfoActionPerformed
        // TODO add your handling code here:
        FrmDataInfo frmDI = new FrmDataInfo();
        frmDI.setLocationRelativeTo(this);
        frmDI.setText(_meteoDataInfo.getInfoText());
        frmDI.setVisible(true);
    }//GEN-LAST:event_jButton_DataInfoActionPerformed

    private void jButton_DrawActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_DrawActionPerformed
        // TODO add your handling code here:
        if (this.jComboBox_PlotDim.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(null, "It's not a muti dimension variable: " + this.jComboBox_Variable.getSelectedItem().toString() + "!");
            return;
        }

        this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

        _plotDimension = PlotDimension.valueOf(this.jComboBox_PlotDim.getSelectedItem().toString());
        _meteoDataInfo.setDimensionSet(_plotDimension);
        _meteoDataInfo.setTimeIndex(this.jComboBox_Time1.getSelectedIndex());
        _meteoDataInfo.setLevelIndex(this.jComboBox_Lat1.getSelectedIndex());
        _meteoDataInfo.setLatIndex(this.jComboBox_Lat1.getSelectedIndex());
        _meteoDataInfo.setLonIndex(this.jComboBox_Lon1.getSelectedIndex());

        //Get X/Y
        //GetXYCoords();
        getXYGridStrs();
        this.mapLayout1.getActiveMapFrame().getMapView().setXGridStrs(new ArrayList<>(_XGridStrs));
        this.mapLayout1.getActiveMapFrame().getMapView().setYGridStrs(new ArrayList<>(_YGridStrs));

        //Draw 2D figure
        switch (_meteoDataInfo.getDataType()) {
            case GrADS_Grid:
            //case MeteoDataType.MICAPS_4:                    
            case HYSPLIT_Conc:
            case ARL_Grid:
            case NetCDF:
            case GRIB1:
            case GRIB2:
                getGridData();
                drawGrid();
                break;
            case GrADS_Station:
                _gridData = ((GrADSDataInfo) _meteoDataInfo.getDataInfo()).getGridData_Station(
                        this.jComboBox_Variable.getSelectedIndex(), this.jList_Stations.getSelectedValuesList().get(0).toString());
                drawGrid();
                break;
        }

        if (!_useSameLegendScheme) {
            MapLayer aLayer = this.mapLayout1.getActiveMapFrame().getMapView().getLayerByHandle(_lastAddedLayerHandle);
            if (aLayer != null) {
                VectorLayer sLayer = (VectorLayer) aLayer;
                if (sLayer.getExtent().maxX > sLayer.getExtent().minX && sLayer.getExtent().maxY
                        > sLayer.getExtent().minY) {
                    zoomToExtent(sLayer.getExtent());
                }
            }
        }

        //TSB_Draw.Enabled = false;
        this.jButton_DrawSetting.setEnabled(true);
        if (!this.jCheckBox_Time.isSelected()) {
            if (this.jComboBox_Time1.getItemCount() > 1) {
                this.jButton_NexTime.setEnabled(true);
                this.jButton_PreTime.setEnabled(true);
                this.jButton_Animator.setEnabled(true);

            }
        }

        this.setCursor(Cursor.getDefaultCursor());
    }//GEN-LAST:event_jButton_DrawActionPerformed

    private void display() {
        _plotDimension = PlotDimension.valueOf(this.jComboBox_PlotDim.getSelectedItem().toString());
        _meteoDataInfo.setDimensionSet(_plotDimension);
        _meteoDataInfo.setTimeIndex(this.jComboBox_Time1.getSelectedIndex());
        _meteoDataInfo.setLevelIndex(this.jComboBox_Lat1.getSelectedIndex());
        _meteoDataInfo.setLatIndex(this.jComboBox_Lat1.getSelectedIndex());
        _meteoDataInfo.setLonIndex(this.jComboBox_Lon1.getSelectedIndex());

        //Get X/Y
        //GetXYCoords();
        getXYGridStrs();
        this.mapLayout1.getActiveMapFrame().getMapView().setXGridStrs(new ArrayList<>(_XGridStrs));
        this.mapLayout1.getActiveMapFrame().getMapView().setYGridStrs(new ArrayList<>(_YGridStrs));

        //Draw 2D figure
        switch (_meteoDataInfo.getDataType()) {
            case GrADS_Grid:
            //case MeteoDataType.MICAPS_4:                    
            case HYSPLIT_Conc:
            case ARL_Grid:
            case NetCDF:
            case GRIB1:
            case GRIB2:
                getGridData();
                drawGrid();
                break;
            case GrADS_Station:
                _gridData = ((GrADSDataInfo) _meteoDataInfo.getDataInfo()).getGridData_Station(
                        this.jComboBox_Variable.getSelectedIndex(), this.jList_Stations.getSelectedValuesList().get(0).toString());
                drawGrid();
                break;
        }

        if (!_useSameLegendScheme) {
            MapLayer aLayer = this.mapLayout1.getActiveMapFrame().getMapView().getLayerByHandle(_lastAddedLayerHandle);
            if (aLayer != null) {
                VectorLayer sLayer = (VectorLayer) aLayer;
                if (sLayer.getExtent().maxX > sLayer.getExtent().minX && sLayer.getExtent().maxY
                        > sLayer.getExtent().minY) {
                    zoomToExtent(sLayer.getExtent());
                }
            }
        }
    }

    private void jButton_ViewDataActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ViewDataActionPerformed
        // TODO add your handling code here:
        if (_gridData == null) {
            return;
        }

        if (_gridData.data == null) {
            return;
        }

        if (_gridData.data.length == 0) {
            return;
        }
        
        FrmViewData frmData = new FrmViewData();
        //frmData.setProjectionInfo(_meteoDataInfo.getProjectionInfo());
        frmData.setGridData(_gridData);
        frmData.setLocationRelativeTo(this);
        frmData.setVisible(true);
    }//GEN-LAST:event_jButton_ViewDataActionPerformed

    private void jButton_ClearDrawActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ClearDrawActionPerformed
        // TODO add your handling code here:
        //Remove last layer
        //this.layersLegend1.getActiveMapFrame().removeLayerByHandle(_lastAddedLayerHandle);
        this.layersLegend1.getActiveMapFrame().removeAllLayers();
        //this.jButton_Draw.setEnabled(true);
    }//GEN-LAST:event_jButton_ClearDrawActionPerformed

    private void jButton_PreTimeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_PreTimeActionPerformed
        // TODO add your handling code here:
        _useSameLegendScheme = true;
        if (this.jComboBox_Time1.getSelectedIndex() > 0) {
            this.jComboBox_Time1.setSelectedIndex(this.jComboBox_Time1.getSelectedIndex() - 1);
        } else {
            this.jComboBox_Time1.setSelectedIndex(this.jComboBox_Time1.getItemCount() - 1);
        }
        this.mapLayout1.getActiveMapFrame().getMapView().setLockViewUpdate(true);
        this.layersLegend1.getActiveMapFrame().removeLayerByHandle(_lastAddedLayerHandle);
        this.mapLayout1.getActiveMapFrame().getMapView().setLockViewUpdate(false);
        this.jButton_Draw.doClick();
    }//GEN-LAST:event_jButton_PreTimeActionPerformed

    private void jButton_NexTimeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_NexTimeActionPerformed
        // TODO add your handling code here:
        _useSameLegendScheme = true;
        if (this.jComboBox_Time1.getSelectedIndex() < this.jComboBox_Time1.getItemCount() - 1) {
            this.jComboBox_Time1.setSelectedIndex(this.jComboBox_Time1.getSelectedIndex() + 1);
        } else {
            this.jComboBox_Time1.setSelectedIndex(0);
        }
        this.mapLayout1.getActiveMapFrame().getMapView().setLockViewUpdate(true);
        this.layersLegend1.getActiveMapFrame().removeLayerByHandle(_lastAddedLayerHandle);
        this.mapLayout1.getActiveMapFrame().getMapView().setLockViewUpdate(false);
        this.jButton_Draw.doClick();
    }//GEN-LAST:event_jButton_NexTimeActionPerformed

    private void jButton_AnimatorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_AnimatorActionPerformed
        // TODO add your handling code here:
        if (this._isRunning) {
            this._enableAnimation = false;
        } else {
            run_Animation(false);
        }
    }//GEN-LAST:event_jButton_AnimatorActionPerformed

    private void run_Animation(final boolean isCreateFile) {
        File file;
        final AnimatedGifEncoder encoder = new AnimatedGifEncoder();
        if (isCreateFile) {
            JFileChooser aDlg = new JFileChooser();
            String[] fileExts = new String[]{"gif"};
            GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Gif File (*.gif)");
            aDlg.setFileFilter(mapFileFilter);
            File dir = new File(System.getProperty("user.dir"));
            if (dir.isDirectory()) {
                aDlg.setCurrentDirectory(dir);
            }
            aDlg.setAcceptAllFileFilterUsed(false);
            if (aDlg.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
                file = aDlg.getSelectedFile();
                System.setProperty("user.dir", file.getParent());
                String extent = ((GenericFileFilter) aDlg.getFileFilter()).getFileExtent();
                String fileName = file.getAbsolutePath();
                if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                    fileName = fileName + "." + extent;
                }
                encoder.setRepeat(0);
                encoder.setDelay(1000);
                encoder.start(fileName);
            }
        }

        switch (_meteoDataInfo.getDataType()) {
            default:
                if (this.jComboBox_Time1.getItemCount() > 1) {
                    SwingWorker worker = new SwingWorker<String, String>() {
                        @Override
                        protected String doInBackground() throws Exception {
                            jButton_Animator.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/stop.png")));
                            _isRunning = true;
                            _useSameLegendScheme = true;
                            for (int i = 0; i < jComboBox_Time1.getItemCount(); i++) {
                                if (!_enableAnimation) {
                                    _enableAnimation = true;
                                    _isRunning = false;
                                    jButton_Animator.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/animation-1.png")));
                                    return "";
                                }

                                jComboBox_Time1.setSelectedIndex(i);
                                FrmSectionPlot.this.layersLegend1.getActiveMapFrame().getMapView().setLockViewUpdate(true);
                                //Remove last layer
                                FrmSectionPlot.this.layersLegend1.getActiveMapFrame().removeLayerByHandle(_lastAddedLayerHandle);
                                FrmSectionPlot.this.layersLegend1.getActiveMapFrame().getMapView().setLockViewUpdate(false);
                                display();

                                if (isCreateFile) {
                                    encoder.addFrame(FrmSectionPlot.this.layersLegend1.getActiveMapFrame().getMapView().getViewImage());
                                } else {
                                    try {
                                        Thread.sleep(500);
                                    } catch (InterruptedException ex) {
                                        Logger.getLogger(FrmMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                                    }
                                }
                            }

                            _enableAnimation = true;
                            _isRunning = false;
                            jButton_Animator.setIcon(new javax.swing.ImageIcon(getClass().getResource("/images/animation-1.png")));
                            encoder.finish();
                            return "";
                        }
                    };
                    worker.execute();
                }
                break;
        }
    }

    private void jButton_CreateAnimatorFileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_CreateAnimatorFileActionPerformed
        // TODO add your handling code here:
        this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        run_Animation(true);
        this.setCursor(Cursor.getDefaultCursor());
    }//GEN-LAST:event_jButton_CreateAnimatorFileActionPerformed

    private void jButton_DrawSettingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_DrawSettingActionPerformed
        // TODO add your handling code here:
        MapLayer aLayer = this.layersLegend1.getActiveMapFrame().getMapView().getLayerByHandle(_lastAddedLayerHandle);
        FrmLegendSet aFrmLS = new FrmLegendSet(this, true);
        aFrmLS.setLegendScheme(_legendScheme);
        String fieldName = this.jComboBox_Variable.getSelectedItem().toString();
        aFrmLS.setLocationRelativeTo(this);
        aFrmLS.setVisible(true);
        if (aFrmLS.isOK()) {
            this.layersLegend1.getActiveMapFrame().removeLayerByHandle(_lastAddedLayerHandle);
            this._legendScheme = aFrmLS.getLegendScheme();
            drawMeteoMap(false, _legendScheme);
            this.layersLegend1.getActiveMapFrame().getMapView().paintLayers();
        }
    }//GEN-LAST:event_jButton_DrawSettingActionPerformed

    private void jButton_SelectElementActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_SelectElementActionPerformed
        // TODO add your handling code here:
        this.mapLayout1.setMouseMode(MouseMode.Select);

        setCurrentTool((JButton) evt.getSource());
    }//GEN-LAST:event_jButton_SelectElementActionPerformed

    private void jButton_ZoomInActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ZoomInActionPerformed
        // TODO add your handling code here:
        this.mapLayout1.setMouseMode(MouseMode.Map_ZoomIn);

        setCurrentTool((JButton) evt.getSource());
    }//GEN-LAST:event_jButton_ZoomInActionPerformed

    private void jButton_ZoomOutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ZoomOutActionPerformed
        // TODO add your handling code here:
        this.mapLayout1.setMouseMode(MouseMode.Map_ZoomOut);

        setCurrentTool((JButton) evt.getSource());
    }//GEN-LAST:event_jButton_ZoomOutActionPerformed

    private void jButton_PanActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_PanActionPerformed
        // TODO add your handling code here:
        this.mapLayout1.setMouseMode(MouseMode.Map_Pan);

        setCurrentTool((JButton) evt.getSource());
    }//GEN-LAST:event_jButton_PanActionPerformed

    private void jButton_FullExtentActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_FullExtentActionPerformed
        // TODO add your handling code here:
        this.mapLayout1.getActiveMapFrame().getMapView().zoomToExtent(this.mapLayout1.getActiveMapFrame().getMapView().getExtent());
    }//GEN-LAST:event_jButton_FullExtentActionPerformed

    private void jButton_ZoomToLayerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_ZoomToLayerActionPerformed
        // TODO add your handling code here:
        if (this.layersLegend1.getSelectedNode() == null) {
            return;
        }

        if (this.layersLegend1.getSelectedNode().getNodeType() == NodeTypes.LayerNode) {
            MapFrame aMF = this.layersLegend1.getCurrentMapFrame();
            MapLayer aLayer = ((LayerNode) this.layersLegend1.getSelectedNode()).getMapLayer();
            if (aLayer != null) {
                aMF.getMapView().zoomToExtent(aLayer.getExtent());
            }
        }
    }//GEN-LAST:event_jButton_ZoomToLayerActionPerformed

    private void jButton_IdentiferActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_IdentiferActionPerformed
        // TODO add your handling code here:
        this.mapLayout1.setMouseMode(MouseMode.Map_Identifer);

        setCurrentTool((JButton) evt.getSource());
    }//GEN-LAST:event_jButton_IdentiferActionPerformed

    private void jButton_LabelSetActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_LabelSetActionPerformed
        // TODO add your handling code here:
        if (this.layersLegend1.getSelectedNode() == null) {
            return;
        }

        if (this.layersLegend1.getSelectedNode().getNodeType() == NodeTypes.LayerNode) {
            LayerNode aLN = (LayerNode) this.layersLegend1.getSelectedNode();
            MapLayer aMLayer = aLN.getMapFrame().getMapView().getLayerByHandle(aLN.getLayerHandle());
            if (aMLayer.getLayerType() == LayerTypes.VectorLayer) {
                VectorLayer aLayer = (VectorLayer) aMLayer;
                if (aLayer.getShapeNum() > 0) {
                    FrmLabelSet aFrmLabel = new FrmLabelSet(this, false, this.layersLegend1.getActiveMapFrame().getMapView());
                    aFrmLabel.setLayer(aLayer);
                    aFrmLabel.setLocationRelativeTo(this);
                    aFrmLabel.setVisible(true);
                }
            }
        }
    }//GEN-LAST:event_jButton_LabelSetActionPerformed

    private void jButton_PageSetActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_PageSetActionPerformed
        // TODO add your handling code here:
        FrmPageSet aFrmPageSet = new FrmPageSet(this, true);
        aFrmPageSet.setMapLayout(this.mapLayout1);
        aFrmPageSet.setPaperSize(this.layersLegend1.getMapLayout().getPaperSize());
        aFrmPageSet.setLandscape(this.layersLegend1.getMapLayout().isLandscape());
        aFrmPageSet.setLocationRelativeTo(this);
        aFrmPageSet.setVisible(true);
    }//GEN-LAST:event_jButton_PageSetActionPerformed

    private void jButton_PageZoomInActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_PageZoomInActionPerformed
        // TODO add your handling code here:
        this.mapLayout1.setZoom(this.mapLayout1.getZoom() * 1.2F);
        this.mapLayout1.paintGraphics();
    }//GEN-LAST:event_jButton_PageZoomInActionPerformed

    private void jButton_PageZoomOutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_PageZoomOutActionPerformed
        // TODO add your handling code here:
        this.mapLayout1.setZoom(this.mapLayout1.getZoom() * 0.8F);
        this.mapLayout1.paintGraphics();
    }//GEN-LAST:event_jButton_PageZoomOutActionPerformed

    private void jButton_FitToScreenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_FitToScreenActionPerformed
        // TODO add your handling code here:
        float zoomX = (float) this.layersLegend1.getMapLayout().getWidth() / this.layersLegend1.getMapLayout().getPageBounds().width;
        float zoomY = (float) this.layersLegend1.getMapLayout().getHeight() / this.layersLegend1.getMapLayout().getPageBounds().height;
        float zoom = Math.min(zoomX, zoomY);
        PointF aP = new PointF(0, 0);
        this.layersLegend1.getMapLayout().setPageLocation(aP);
        this.layersLegend1.getMapLayout().setZoom(zoom);
        this.layersLegend1.getMapLayout().paintGraphics();
    }//GEN-LAST:event_jButton_FitToScreenActionPerformed

    private void jComboBox_PageZoomActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox_PageZoomActionPerformed
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }
        String zoomStr = this.jComboBox_PageZoom.getSelectedItem().toString().trim();
        if (zoomStr.endsWith("%")) {
            zoomStr = zoomStr.substring(0, zoomStr.length() - 1);
        }
        try {
            float zoom = Float.parseFloat(zoomStr);
            this.layersLegend1.getMapLayout().setZoom(zoom / 100);
            this.layersLegend1.getMapLayout().paintGraphics();
        } catch (Exception e) {
        }
    }//GEN-LAST:event_jComboBox_PageZoomActionPerformed

    private void jButton_SavePictureActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton_SavePictureActionPerformed
        // TODO add your handling code here:
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"png"};
        GenericFileFilter pngFileFilter = new GenericFileFilter(fileExts, "Png Image (*.png)");
        aDlg.addChoosableFileFilter(pngFileFilter);
        fileExts = new String[]{"gif"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Gif Image (*.gif)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        fileExts = new String[]{"jpg"};
        mapFileFilter = new GenericFileFilter(fileExts, "Jpeg Image (*.jpg)");
        aDlg.addChoosableFileFilter(mapFileFilter);
//        fileExts = new String[]{"bmp"};
//        mapFileFilter = new GenericFileFilter(fileExts, "Bitmap Image (*.bmp)");
//        aDlg.addChoosableFileFilter(mapFileFilter);
//        fileExts = new String[]{"tif"};
//        mapFileFilter = new GenericFileFilter(fileExts, "Tiff Image (*.tif)");
//        aDlg.addChoosableFileFilter(mapFileFilter);
        fileExts = new String[]{"eps"};
        mapFileFilter = new GenericFileFilter(fileExts, "EPS file (*.eps)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        fileExts = new String[]{"pdf"};
        mapFileFilter = new GenericFileFilter(fileExts, "PDF file (*.pdf)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        fileExts = new String[]{"emf"};
        mapFileFilter = new GenericFileFilter(fileExts, "EMF file (*.emf)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        fileExts = new String[]{"ps"};
        mapFileFilter = new GenericFileFilter(fileExts, "Postscript file (*.ps)");
        aDlg.addChoosableFileFilter(mapFileFilter);
        aDlg.setFileFilter(pngFileFilter);
        aDlg.setAcceptAllFileFilterUsed(false);
        if (JFileChooser.APPROVE_OPTION == aDlg.showSaveDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());
            String extent = ((GenericFileFilter) aDlg.getFileFilter()).getFileExtent();
            String fileName = aFile.getAbsolutePath();
            if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                fileName = fileName + "." + extent;
            }

            try {
                this.layersLegend1.getMapLayout().exportToPicture(fileName);
            } catch (FileNotFoundException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            } catch (PrintException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IOException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }//GEN-LAST:event_jButton_SavePictureActionPerformed

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        // TODO add your handling code here:
        //Set size
        _isLoading = true;
        this.setSize(1020, 600);

        //Set 2D panel
        //setMapLayerPanel();
        //this.layersLegend1.getMapFrames().get(0).setLayoutBounds(new Rectangle(40, 36, 606, 420));
        //this.layersLegend1.getMapFrames().get(0).getMapView().setGeoMap(false);
        //this.layersLegend1.getMapFrames().get(0).setIsFireMapViewUpdate(true);
        //this.mapLayout1.setMapFrames(this.layersLegend1.getMapFrames());
        //this.mapLayout1.addElement(new LayoutMap(this.mapLayout1.getMapFrames().get(0)));
        LayoutLegend legend = this.mapLayout1.addLegend(660, 100);
        legend.setLegendStyle(LegendStyles.Bar_Vertical);
        legend.setWidth(36);
        legend.setHeight(295);
        this.mapLayout1.addText("MeteoInfo: Meteorological Data Infomation System", 320, 20, "Arial", 16);
        this.mapLayout1.paintGraphics();

        //Set layout zoom combobox
        this.jComboBox_PageZoom.removeAllItems();
        String[] zooms = new String[]{"20%", "50%", "75%", "100%", "150%", "200%", "300%"};
        for (String zoom : zooms) {
            this.jComboBox_PageZoom.addItem(zoom);
        }
        this.jComboBox_PageZoom.setSelectedItem(String.valueOf((int) (this.mapLayout1.getZoom() * 100)) + "%");

        //Set map title
        //m_Title = Resources.GlobalResource.ResourceManager.GetString("SectionPlot_Title");
        //Set current tool
        this.jButton_SelectElement.doClick();

        //Set dimensions
        this.jComboBox_Lat2.setVisible(false);
        this.jComboBox_Level2.setVisible(false);
        this.jComboBox_Lon2.setVisible(false);
        this.jComboBox_Time2.setVisible(false);
        this.jCheckBox_Time.setEnabled(false);
        this.jCheckBox_Level.setEnabled(false);
        this.jCheckBox_Lon.setEnabled(false);
        this.jCheckBox_Lat.setEnabled(false);
        this.jCheckBox_ColorVar.setVisible(false);

        updateDimensions();

        //Set draw type
        _isLoading = true;
        this.jComboBox_DrawType.removeAllItems();
        switch (_meteoDataInfo.getDataType()) {
            case HYSPLIT_Particle:
                this.jComboBox_DrawType.addItem(DrawType2D.Station_Point);
                break;
            default:
                this.jComboBox_DrawType.addItem(DrawType2D.Contour);
                this.jComboBox_DrawType.addItem(DrawType2D.Shaded);
                this.jComboBox_DrawType.addItem(DrawType2D.Grid_Fill);
                this.jComboBox_DrawType.addItem(DrawType2D.Grid_Point);
                this.jComboBox_DrawType.addItem(DrawType2D.Vector);
                this.jComboBox_DrawType.addItem(DrawType2D.Barb);
                this.jComboBox_DrawType.addItem(DrawType2D.Streamline);
                break;
        }
        this.jComboBox_DrawType.setSelectedIndex(0);

        if (_meteoDataInfo.isGridData()) {
            this.jList_Stations.setVisible(false);
            this.jScrollPane1.setVisible(false);
        } else {
            this.jList_Stations.setVisible(true);
            this.jScrollPane1.setVisible(true);
            this.jCheckBox_Lat.setVisible(false);
            this.jCheckBox_Lon.setVisible(false);
            this.jComboBox_Lat1.setVisible(false);
            this.jComboBox_Lat2.setVisible(false);
            this.jComboBox_Lon1.setVisible(false);
            this.jComboBox_Lon2.setVisible(false);
        }

        _isLoading = false;
    }//GEN-LAST:event_formWindowOpened

    private void jComboBox_VariableActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox_VariableActionPerformed
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }

        _useSameLegendScheme = false;
        //m_UseSameGridInterSet = false;
        Variable var = _meteoDataInfo.getDataInfo().getVariable(this.jComboBox_Variable.getSelectedItem().toString());
        if (var == null) {
            return;
        }

        _meteoDataInfo.setVariableIndex(this.jComboBox_Variable.getSelectedIndex());
        this.setVariableParas(var);
        updateEndDimSetS(this.jComboBox_Level1, this.jComboBox_Level2);

        this.jButton_Draw.setEnabled(true);
        this.jButton_Animator.setEnabled(false);
        this.jButton_PreTime.setEnabled(false);
        this.jButton_NexTime.setEnabled(false);

        //Set plot dimensions
        _isLoading = true;
        String pdStr = this.jComboBox_PlotDim.getSelectedItem().toString();
        this.jComboBox_PlotDim.removeAllItems();
        if (_meteoDataInfo.isGridData()) {
            if (this.jComboBox_Level1.getItemCount() > 1) {
                this.jComboBox_PlotDim.addItem(PlotDimension.Level_Lat.toString());
                this.jComboBox_PlotDim.addItem(PlotDimension.Level_Lon.toString());
            }
            if (this.jComboBox_Time1.getItemCount() > 1) {
                this.jComboBox_PlotDim.addItem(PlotDimension.Time_Lat.toString());
                this.jComboBox_PlotDim.addItem(PlotDimension.Time_Lon.toString());
            }
        }
        if (this.jComboBox_Level1.getItemCount() > 1 && this.jComboBox_Time1.getItemCount() > 1) {
            this.jComboBox_PlotDim.addItem(PlotDimension.Level_Time.toString());
        }

        List<String> dimItems = new ArrayList<>();
        for (int i = 0; i < this.jComboBox_PlotDim.getItemCount(); i++) {
            dimItems.add(this.jComboBox_PlotDim.getItemAt(i).toString());
        }
        _isLoading = false;
        if (!"".equals(pdStr) && dimItems.contains(pdStr)) {
            _isSamePlotDim = true;
            this.jComboBox_PlotDim.setSelectedItem(pdStr);
        } else {
            _isSamePlotDim = false;
            if (this.jComboBox_PlotDim.getItemCount() > 0) {
                this.jComboBox_PlotDim.setSelectedIndex(0);
            }
        }
    }//GEN-LAST:event_jComboBox_VariableActionPerformed

    private void jComboBox_PlotDimActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox_PlotDimActionPerformed
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }

        _plotDimension = PlotDimension.valueOf(this.jComboBox_PlotDim.getSelectedItem().toString());

        _meteoDataInfo.setDimensionSet(_plotDimension);
        switch (_plotDimension) {
            case Level_Lat:
            case Level_Lon:
            case Level_Time:
                this.jCheckBox_YReverse.setVisible(true);
                break;
            default:
                this.jCheckBox_YReverse.setVisible(false);
                break;
        }

        setDimensions();

        if (!_isSamePlotDim) {
            if (this.mapLayout1.getActiveMapFrame().getMapView().getLayerNum() > 0) {
                this.layersLegend1.getActiveMapFrame().removeMeteoLayers();
            }
        }

        this.jButton_Draw.setEnabled(true);
        this.jButton_Animator.setEnabled(false);
        this.jButton_PreTime.setEnabled(false);
        this.jButton_NexTime.setEnabled(false);
    }//GEN-LAST:event_jComboBox_PlotDimActionPerformed

    private void jComboBox_DrawTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox_DrawTypeActionPerformed
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }

        _2DDrawType = DrawType2D.valueOf(this.jComboBox_DrawType.getSelectedItem().toString());
        this.jButton_Draw.setEnabled(true);
        _useSameLegendScheme = false;

        //m_UseSameGridInterSet = false;
        this.jButton_Animator.setEnabled(false);
        this.jButton_PreTime.setEnabled(false);
        this.jButton_NexTime.setEnabled(false);

        //Set CHB_ColorVar visible
        switch (_2DDrawType) {
            case Vector:
            case Barb:
                this.jCheckBox_ColorVar.setVisible(true);
                break;
            default:
                this.jCheckBox_ColorVar.setVisible(false);
                break;
        }
    }//GEN-LAST:event_jComboBox_DrawTypeActionPerformed

    private void jCheckBox_TimeStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jCheckBox_TimeStateChanged
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }

        this.jComboBox_Time2.setVisible(this.jCheckBox_Time.isSelected());
        if (this.jCheckBox_Time.isSelected()) {
            if (this.jComboBox_Time1.getItemCount() > 0) {
                this.jComboBox_Time1.setSelectedIndex(0);
                this.jComboBox_Time2.setSelectedIndex(this.jComboBox_Time2.getItemCount() - 1);
            }
            this.jComboBox_Time1.setEnabled(false);
            this.jComboBox_Time2.setEnabled(false);
        } else {
            this.jComboBox_Time1.setEnabled(true);
            this.jComboBox_Time2.setEnabled(true);
        }
    }//GEN-LAST:event_jCheckBox_TimeStateChanged

    private void jCheckBox_LevelStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jCheckBox_LevelStateChanged
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }

        this.jComboBox_Level2.setVisible(this.jCheckBox_Level.isSelected());
        if (this.jCheckBox_Level.isSelected()) {
            if (this.jComboBox_Level1.getItemCount() > 0) {
                this.jComboBox_Level1.setSelectedIndex(0);
                this.jComboBox_Level2.setSelectedIndex(this.jComboBox_Level2.getItemCount() - 1);
            }
            this.jComboBox_Level1.setEnabled(false);
            this.jComboBox_Level2.setEnabled(false);
        } else {
            this.jComboBox_Level1.setEnabled(true);
            this.jComboBox_Level2.setEnabled(true);
        }
    }//GEN-LAST:event_jCheckBox_LevelStateChanged

    private void jCheckBox_LatStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jCheckBox_LatStateChanged
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }

        this.jComboBox_Lat2.setVisible(this.jCheckBox_Lat.isSelected());
        if (this.jCheckBox_Lat.isSelected()) {
            if (this.jComboBox_Lat1.getItemCount() > 0) {
                this.jComboBox_Lat1.setSelectedIndex(0);
                this.jComboBox_Lat2.setSelectedIndex(this.jComboBox_Lat2.getItemCount() - 1);
            }
            this.jComboBox_Lat1.setEnabled(false);
            this.jComboBox_Lat2.setEnabled(false);
        } else {
            this.jComboBox_Lat1.setEnabled(true);
            this.jComboBox_Lat2.setEnabled(true);
        }
    }//GEN-LAST:event_jCheckBox_LatStateChanged

    private void jCheckBox_LonStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jCheckBox_LonStateChanged
        // TODO add your handling code here:
        if (_isLoading) {
            return;
        }

        this.jComboBox_Lon2.setVisible(this.jCheckBox_Lon.isSelected());
        if (this.jCheckBox_Lon.isSelected()) {
            if (this.jComboBox_Lon1.getItemCount() > 0) {
                this.jComboBox_Lon1.setSelectedIndex(0);
                this.jComboBox_Lon2.setSelectedIndex(this.jComboBox_Lon2.getItemCount() - 1);
            }
            this.jComboBox_Lon1.setEnabled(false);
            this.jComboBox_Lon2.setEnabled(false);
        } else {
            this.jComboBox_Lon1.setEnabled(true);
            this.jComboBox_Lon2.setEnabled(true);
        }
    }//GEN-LAST:event_jCheckBox_LonStateChanged

    // <editor-fold desc="Methods">
    private void setVariableParas(Variable var) {
        int i;
        int levelIdx = this.jComboBox_Level1.getSelectedIndex();

        this.jComboBox_Level1.removeAllItems();
        Dimension zDim = var.getZDimension();
        if (zDim == null) {
            this.jComboBox_Level1.addItem("Surface");
            this.jComboBox_Level1.setSelectedIndex(0);
        } else {
            for (i = 0; i < var.getLevelNum(); i++) {
                this.jComboBox_Level1.addItem(String.valueOf(zDim.getDimValue().get(i)));
            }
            if ((levelIdx > -1) && (this.jComboBox_Level1.getItemCount() > levelIdx)) {
                this.jComboBox_Level1.setSelectedIndex(levelIdx);
            } else {
                this.jComboBox_Level1.setSelectedIndex(0);
            }
        }
    }

    private void updateDimensions() {
        int i;

        //Set time
        this.jComboBox_Time1.removeAllItems();
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        for (i = 0; i < _meteoDataInfo.getDataInfo().getTimeNum(); i++) {
            this.jComboBox_Time1.addItem(sdf.format(_meteoDataInfo.getDataInfo().getTimes().get(i)));
        }
        this.jComboBox_Time1.setSelectedIndex(0);

        //Set lon/lat
        this.jComboBox_Lon1.removeAllItems();
        for (i = 0; i < (_meteoDataInfo.getDataInfo()).getXDimension().getLength(); i++) {
            this.jComboBox_Lon1.addItem(String.valueOf((_meteoDataInfo.getDataInfo()).getXDimension().getDimValue().get(i)));
        }
        this.jComboBox_Lon1.setSelectedIndex(0);

        this.jComboBox_Lat1.removeAllItems();
        for (i = 0; i < (_meteoDataInfo.getDataInfo()).getYDimension().getLength(); i++) {
            this.jComboBox_Lat1.addItem(String.valueOf((_meteoDataInfo.getDataInfo()).getYDimension().getDimValue().get(i)));
        }
        this.jComboBox_Lat1.setSelectedIndex(0);

        updateEndDimSet();

        //Set vars
        this.jComboBox_Variable.setEnabled(true);
        this.jComboBox_Variable.removeAllItems();
        for (i = 0; i < _meteoDataInfo.getDataInfo().getVariableNum(); i++) {
            Variable var = _meteoDataInfo.getDataInfo().getVariables().get(i);
            if (var.isPlottable()) {
                if (var.getDimNumber() == 2){
                    if (var.getDimension(DimensionType.T) == null &&  var.getDimension(DimensionType.Z) == null){
                        continue;
                    }
                }
                this.jComboBox_Variable.addItem(var.getName());
            }
        }
        _isLoading = false;
        this.jComboBox_Variable.setSelectedIndex(0);
    }

    private void updateEndDimSet() {
        int i;
        this.jComboBox_Time2.removeAllItems();
        for (i = 0; i < this.jComboBox_Time1.getItemCount(); i++) {
            this.jComboBox_Time2.addItem(this.jComboBox_Time1.getItemAt(i));
        }
        this.jComboBox_Time2.setSelectedIndex(this.jComboBox_Time2.getItemCount() - 1);

        this.jComboBox_Level2.removeAllItems();
        for (i = 0; i < this.jComboBox_Level1.getItemCount(); i++) {
            this.jComboBox_Level2.addItem(this.jComboBox_Level1.getItemAt(i));
        }
        this.jComboBox_Level2.setSelectedIndex(this.jComboBox_Level2.getItemCount() - 1);

        this.jComboBox_Lon2.removeAllItems();
        for (i = 0; i < this.jComboBox_Lon1.getItemCount(); i++) {
            this.jComboBox_Lon2.addItem(this.jComboBox_Lon1.getItemAt(i));
        }
        this.jComboBox_Lon2.setSelectedIndex(this.jComboBox_Lon2.getItemCount() - 1);

        this.jComboBox_Lat2.removeAllItems();
        for (i = 0; i < this.jComboBox_Lat1.getItemCount(); i++) {
            this.jComboBox_Lat2.addItem(this.jComboBox_Lat1.getItemAt(i));
        }
        this.jComboBox_Lat2.setSelectedIndex(this.jComboBox_Lat2.getItemCount() - 1);
    }

    private void updateEndDimSetS(JComboBox CB1, JComboBox CB2) {
        CB2.removeAllItems();
        for (int i = 0; i < CB1.getItemCount(); i++) {
            CB2.addItem(CB1.getItemAt(i));
        }
        CB2.setSelectedIndex(CB2.getItemCount() - 1);
    }

    private void setDimensions() {
        switch (_plotDimension) {
            case Time_Lon:
                this.jCheckBox_Lat.setSelected(false);
                this.jCheckBox_Level.setSelected(false);
                this.jCheckBox_Time.setSelected(true);
                this.jCheckBox_Lon.setSelected(true);
                break;
            case Time_Lat:
                this.jCheckBox_Lat.setSelected(true);
                this.jCheckBox_Level.setSelected(false);
                this.jCheckBox_Time.setSelected(true);
                this.jCheckBox_Lon.setSelected(false);
                break;
            case Level_Time:
                this.jCheckBox_Lat.setSelected(false);
                this.jCheckBox_Level.setSelected(true);
                this.jCheckBox_Time.setSelected(true);
                this.jCheckBox_Lon.setSelected(false);
                break;
            case Level_Lon:
                this.jCheckBox_Lat.setSelected(false);
                this.jCheckBox_Level.setSelected(true);
                this.jCheckBox_Time.setSelected(false);
                this.jCheckBox_Lon.setSelected(true);
                break;
            case Level_Lat:
                this.jCheckBox_Lat.setSelected(true);
                this.jCheckBox_Level.setSelected(true);
                this.jCheckBox_Time.setSelected(false);
                this.jCheckBox_Lon.setSelected(false);
                break;
        }
    }

    private void setCurrentTool(JButton currentTool) {
        if (!(_currentTool == null)) {
            _currentTool.setSelected(false);
        }
        _currentTool = currentTool;
        _currentTool.setSelected(true);
        jLabel_Status.setText(_currentTool.getToolTipText());

//        if (!"jButton_EditVertices".equals(_currentTool.getName())) {
//            //this.jButton_EditVertices.setEnabled(false);
//            if (_isEditingVertices) {
//                if (this.jTabbedPane_Main.getSelectedIndex() == 0) {
//                    _mapView.paintLayers();
//                } else {
//                    _mapDocument.getMapLayout().paintGraphics();
//                }
//
//                _isEditingVertices = false;
//            }
//        }
    }

    public void drawMeteoMap(boolean isNew, LegendScheme aLS) {
        switch (_meteoDataInfo.getDataType()) {
            case GrADS_Grid:
            case GrADS_Station:
            case MICAPS_4:
            case HYSPLIT_Conc:
            case ARL_Grid:
            case NetCDF:
            case GRIB1:
            case GRIB2:
                drawMeteoMap_Grid(isNew, aLS);
                break;
        }
    }

    private void drawMeteoMap_Grid(Boolean isNew, LegendScheme aLS) {
        VectorLayer aLayer = null;
        String LName = getLayerName(_plotDimension);
        String fieldName = this.jComboBox_Variable.getSelectedItem().toString();
        switch (_2DDrawType) {
            case Contour:
                aLayer = DrawMeteoData.createContourLayer(_gridData, aLS, LName, fieldName, true);
                aLayer.addLabelsContourDynamic(this.layersLegend1.getActiveMapFrame().getMapView().getViewExtent());
                break;
            case Shaded:
                aLayer = DrawMeteoData.createShadedLayer(_gridData, aLS, LName, fieldName, true);
                break;
            case Grid_Fill:
                aLayer = DrawMeteoData.createGridFillLayer(_gridData, aLS, LName, fieldName);
                break;
            case Grid_Point:
                aLayer = DrawMeteoData.createGridPointLayer(_gridData, aLS, LName, fieldName);
                break;
            case Vector:
                GridData[] uvData = getUVGridData();
                if (uvData != null) {
                    GridData uData = uvData[0];
                    GridData vData = uvData[1];
                    aLayer = DrawMeteoData.createGridVectorLayer(uData, vData, _gridData, aLS, this.jCheckBox_ColorVar.isSelected(),
                            LName, _meteoDataInfo.getMeteoUVSet().isUV());
                }
                break;
            case Barb:
                uvData = getUVGridData();
                if (uvData != null) {
                    GridData uData = uvData[0];
                    GridData vData = uvData[1];
                    setXYCoords(uData);
                    setXYCoords(vData);
                    if (this.jCheckBox_ColorVar.isSelected()) {
                        Object[] ccs = LegendManage.getContoursAndColors(aLS);
                        this._CValues = (double[]) ccs[0];
                        this._colors = (Color[]) ccs[1];
                    }
                    aLayer = DrawMeteoData.createGridBarbLayer(uData, vData, _gridData, aLS,
                            this.jCheckBox_ColorVar.isSelected(), LName, _meteoDataInfo.getMeteoUVSet().isUV());
                }
                break;
            case Streamline:
                uvData = getUVGridData();
                if (uvData != null) {
                    GridData uData = uvData[0];
                    GridData vData = uvData[1];
                    setXYCoords(uData);
                    setXYCoords(vData);
                    if (this.jCheckBox_ColorVar.isSelected()) {
                        Object[] ccs = LegendManage.getContoursAndColors(aLS);
                        this._CValues = (double[]) ccs[0];
                        this._colors = (Color[]) ccs[1];
                    }
                    aLayer = DrawMeteoData.createStreamlineLayer(uData, vData, _strmDensity, aLS,
                            LName, _meteoDataInfo.getMeteoUVSet().isUV());
                }
                break;
        }

        if (aLayer != null) {
            if (aLayer.getShapeType() == ShapeTypes.Polygon) {
                _lastAddedLayerHandle = this.layersLegend1.getActiveMapFrame().insertPolygonLayer(aLayer);
            } else {
                _lastAddedLayerHandle = this.layersLegend1.getActiveMapFrame().insertPolylineLayer(aLayer);
            }
        } else {
            JOptionPane.showMessageDialog(null, "There is no layer created!");
        }
    }

    private String getLayerName(PlotDimension aPD) {
        String layerName;
        layerName = this.jComboBox_DrawType.getSelectedItem().toString() + "_"
                + this.jComboBox_Variable.getSelectedItem().toString();
        if (this.jComboBox_Level1.isEnabled()) {
            layerName += "_" + this.jComboBox_Level1.getSelectedItem().toString();
        }
        if (this.jComboBox_Lon1.isEnabled()) {
            layerName += "_" + this.jComboBox_Lon1.getSelectedItem().toString();
        }
        if (this.jComboBox_Lat1.isEnabled()) {
            layerName += "_" + this.jComboBox_Lat1.getSelectedItem().toString();
        }
        if (this.jComboBox_Time1.isEnabled()) {
            layerName += "_" + this.jComboBox_Time1.getSelectedItem().toString();
        }

        return layerName;
    }

    private GridData[] getUVGridData() {
        int i;

        //Set U/V strings
        if (!_meteoDataInfo.getMeteoUVSet().isFixUVStr()) {
            List<String> vList = new ArrayList<>();
            for (i = 0; i < this.jComboBox_Variable.getItemCount(); i++) {
                vList.add(this.jComboBox_Variable.getItemAt(i).toString());
            }

            if (!_meteoDataInfo.getMeteoUVSet().autoSetUVStr(vList)) {
                FrmUVSet aFrmUVSet = new FrmUVSet((JFrame) SwingUtilities.getWindowAncestor(this), true);
                aFrmUVSet.setUVItems(vList);
                aFrmUVSet.setUV(true);
                if (aFrmUVSet.isOK()) {
                    String[] uvStr = aFrmUVSet.getUVItems();
                    String uStr = uvStr[0];
                    String vStr = uvStr[1];
                    _meteoDataInfo.getMeteoUVSet().setUV(aFrmUVSet.isUV());
                    _meteoDataInfo.getMeteoUVSet().setUStr(uStr);
                    _meteoDataInfo.getMeteoUVSet().setVStr(vStr);
                    _meteoDataInfo.getMeteoUVSet().setFixUVStr(true);
                    _skipX = aFrmUVSet.getXSkip();
                    _skipY = aFrmUVSet.getYSkip();
                } else {
                    JOptionPane.showMessageDialog(null, "U/V variables were not set!");
                    return null;
                }
            }
        }

        //Get U/V grid data            
        GridData udata = _meteoDataInfo.getGridData(_meteoDataInfo.getMeteoUVSet().getUStr());
        GridData vdata = _meteoDataInfo.getGridData(_meteoDataInfo.getMeteoUVSet().getVStr());

        if (udata == null || vdata == null) {
            return null;
        }

        //Skip the grid data
        if (_skipY != 1 || _skipX != 1) {
            udata = udata.skip(_skipY, _skipX);
            vdata = vdata.skip(_skipY, _skipX);
        }

        return new GridData[]{udata, vdata};
    }

    private void getXYGridStrs() {
        _XGridStrs.clear();
        _YGridStrs.clear();
        int i;

        switch (_plotDimension) {
            case Time_Lat:
                _XGridStrs = getLatGridStr();
                _YGridStrs = getTimeGridStr();
                break;
            case Time_Lon:
                _XGridStrs = getLonGridStr();
                _YGridStrs = getTimeGridStr();
                break;
            case Level_Lat:
                _XGridStrs = getLatGridStr();
                for (i = 0; i < this.jComboBox_Level1.getItemCount(); i++) {
                    _YGridStrs.add(this.jComboBox_Level1.getItemAt(i).toString());
                }
                break;
            case Level_Lon:
                _XGridStrs = getLonGridStr();
                for (i = 0; i < this.jComboBox_Level1.getItemCount(); i++) {
                    _YGridStrs.add(this.jComboBox_Level1.getItemAt(i).toString());
                }
                break;
            case Level_Time:
                _XGridStrs = getTimeGridStr();
                for (i = 0; i < this.jComboBox_Level1.getItemCount(); i++) {
                    _YGridStrs.add(this.jComboBox_Level1.getItemAt(i).toString());
                }
                break;
        }

        //Set if y reverse
        if (this.jCheckBox_YReverse.isVisible() && this.jCheckBox_YReverse.isSelected()) {
            Collections.reverse(_YGridStrs);
        }
    }

    private List<String> getLonGridStr() {
        List<String> GStrList = new ArrayList<>();
        String drawStr;
        int i;

        if (_meteoDataInfo.IsLonLat) {
            float lon;
            for (i = 0; i < this.jComboBox_Lon1.getItemCount(); i++) {
                lon = Float.parseFloat(this.jComboBox_Lon1.getItemAt(i).toString());
                if (lon < 0) {
                    lon = lon + 360;
                }
                if (lon > 0 && lon <= 180) {
                    drawStr = String.valueOf(lon) + "E";
                } else if (lon == 0 || lon == 360) {
                    drawStr = "0";
                } else if (lon == 180) {
                    drawStr = "180";
                } else {
                    drawStr = String.valueOf(360 - lon) + "W";
                }
                GStrList.add(drawStr);
            }
        } else {
            for (i = 0; i < this.jComboBox_Lon1.getItemCount(); i++) {
                drawStr = this.jComboBox_Lon1.getItemAt(i).toString();
                GStrList.add(drawStr);
            }
        }

        return GStrList;
    }

    private List<String> getLatGridStr() {
        List<String> GStrList = new ArrayList<>();
        String drawStr;
        int i;

        if (_meteoDataInfo.IsLonLat) {
            float lat;
            for (i = 0; i < this.jComboBox_Lat1.getItemCount(); i++) {
                lat = Float.parseFloat(this.jComboBox_Lat1.getItemAt(i).toString());
                if (lat > 0) {
                    drawStr = String.valueOf(lat) + "N";
                } else if (lat < 0) {
                    drawStr = String.valueOf(-lat) + "S";
                } else {
                    drawStr = "EQ";
                }
                GStrList.add(drawStr);
            }
        } else {
            for (i = 0; i < this.jComboBox_Lat1.getItemCount(); i++) {
                drawStr = this.jComboBox_Lat1.getItemAt(i).toString();
                GStrList.add(drawStr);
            }
        }

        return GStrList;
    }

    private List<String> getTimeGridStr() {
        List<String> GStrList = new ArrayList<>();
        int i;
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        List<LocalDateTime> DTList = new ArrayList<>();
        for (i = 0; i < this.jComboBox_Time1.getItemCount(); i++) {
            DTList.add(LocalDateTime.parse(this.jComboBox_Time1.getItemAt(i).toString(), dateFormat));
        }

        String timeFormat;
        Duration duration = Duration.between(DTList.get(0), DTList.get(1));
        if (duration.getSeconds() < 3600) {
            timeFormat = "yyyy-MM-dd HH:mm";
        } else if (duration.toHours() < 24) {
            timeFormat = "yyyy-MM-dd HH";
        } else {
            timeFormat = "yyyy-MM-dd";
        }

        LocalDateTime ldt = DTList.get(0);
        int sYear = ldt.getYear();
        int sMonth = ldt.getDayOfMonth();
        ldt = DTList.get(DTList.size() - 1);
        int eYear = ldt.getYear();
        int eMonth = ldt.getDayOfMonth();
        if (sYear == eYear) {
            timeFormat = timeFormat.substring(5);
            if (sMonth == eMonth) {
                timeFormat = timeFormat.substring(3);
            }
        }

        DateTimeFormatter dataFormat = DateTimeFormatter.ofPattern(timeFormat);
        for (i = 0; i < DTList.size(); i++) {
            GStrList.add(dataFormat.format(DTList.get(i)));
        }

        return GStrList;
    }

    private void getGridData() {
        //this.jComboBox_Variable.actionPerformed(null);
        _gridData = _meteoDataInfo.getGridData(this.jComboBox_Variable.getSelectedItem().toString());
    }

    private void drawGrid() {
        //Set X/Y coordinates to integer 1 to x/y number
        setXYCoords(_gridData);

        if (this.jCheckBox_YReverse.isVisible() && this.jCheckBox_YReverse.isSelected()) {
            double[][] aGD = (double[][]) _gridData.data.clone();
            int yn = _gridData.getYNum();
            int xn = _gridData.getXNum();
            for (int i = 0; i < yn; i++) {
                for (int j = 0; j < xn; j++) {
                    _gridData.data[i][j] = aGD[yn - i - 1][j];
                }
            }
        }

        if (!_useSameLegendScheme) {
            createLegendScheme();
        }
        drawMeteoMap(true, _legendScheme);
    }

    private void createLegendScheme() {
        switch (_2DDrawType) {
            case Contour:
                _legendScheme = LegendManage.createLegendSchemeFromGridData(_gridData,
                        LegendType.UniqueValue, ShapeTypes.Polyline);
                break;
            case Shaded:
            case Grid_Fill:
                _legendScheme = LegendManage.createLegendSchemeFromGridData(_gridData,
                        LegendType.GraduatedColor, ShapeTypes.Polygon);
                break;
            case Grid_Point:
                _legendScheme = LegendManage.createLegendSchemeFromGridData(_gridData,
                        LegendType.GraduatedColor, ShapeTypes.Point);
                break;
            case Vector:
                if (this.jCheckBox_ColorVar.isSelected()) {
                    _legendScheme = LegendManage.createLegendSchemeFromGridData(_gridData,
                            LegendType.GraduatedColor, ShapeTypes.Point);
                    PointBreak aPB;
                    for (int i = 0; i < _legendScheme.getLegendBreaks().size(); i++) {
                        aPB = (PointBreak) _legendScheme.getLegendBreaks().get(i);
                        aPB.setSize(10);
                    }
                } else {
                    _legendScheme = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point,
                            Color.blue, 10);
                }
                break;
            case Barb:
                if (this.jCheckBox_ColorVar.isSelected()) {
                    _legendScheme = LegendManage.createLegendSchemeFromGridData(_gridData,
                            LegendType.GraduatedColor, ShapeTypes.Point);
                    PointBreak aPB;
                    for (int i = 0; i < _legendScheme.getLegendBreaks().size(); i++) {
                        aPB = (PointBreak) _legendScheme.getLegendBreaks().get(i);
                        aPB.setSize(10);
                    }
                } else {
                    _legendScheme = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Point,
                            Color.blue, 10);
                }
                break;
            case Streamline:
                _legendScheme = LegendManage.createSingleSymbolLegendScheme(ShapeTypes.Polyline,
                        Color.blue, 1);
                break;
        }
    }

    private void setXYCoords(GridData aGridData) {
        if (aGridData == null) {
            aGridData = new GridData();
        }
        int i;
        int xNum = 0, yNum = 0;
        switch (_plotDimension) {
            case Time_Lon:
                xNum = this.jComboBox_Lon1.getItemCount();
                yNum = this.jComboBox_Time1.getItemCount();
                aGridData.xArray = new double[xNum];
                aGridData.yArray = new double[yNum];
                break;
            case Time_Lat:
                xNum = this.jComboBox_Lat1.getItemCount();
                yNum = this.jComboBox_Time1.getItemCount();
                aGridData.xArray = new double[xNum];
                aGridData.yArray = new double[yNum];
                break;
            case Level_Lat:
                xNum = this.jComboBox_Lat1.getItemCount();
                yNum = this.jComboBox_Level1.getItemCount();
                aGridData.xArray = new double[xNum];
                aGridData.yArray = new double[yNum];
                break;
            case Level_Lon:
                xNum = this.jComboBox_Lon1.getItemCount();
                yNum = this.jComboBox_Level1.getItemCount();
                aGridData.xArray = new double[xNum];
                aGridData.yArray = new double[yNum];
                break;
            case Level_Time:
                xNum = this.jComboBox_Time1.getItemCount();
                yNum = this.jComboBox_Level1.getItemCount();
                aGridData.xArray = new double[xNum];
                aGridData.yArray = new double[yNum];
                break;
        }

        for (i = 0; i < xNum; i++) {
            aGridData.xArray[i] = i;
        }
        for (i = 0; i < yNum; i++) {
            aGridData.yArray[i] = i;
        }
    }

    private void zoomToExtent(Extent aExtent) {
        this.mapLayout1.getActiveMapFrame().getMapView().zoomToExtent(aExtent);
    }
    // </editor-fold>

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        /* Set the Nimbus look and feel */
        //<editor-fold defaultstate="collapsed" desc=" Look and feel setting code (optional) ">
        /* If Nimbus (introduced in Java SE 6) is not available, stay with the default look and feel.
         * For details see http://download.oracle.com/javase/tutorial/uiswing/lookandfeel/plaf.html 
         */
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(FrmSectionPlot.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(FrmSectionPlot.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(FrmSectionPlot.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(FrmSectionPlot.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        //</editor-fold>

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new FrmSectionPlot(null).setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton_Animator;
    private javax.swing.JButton jButton_ClearDraw;
    private javax.swing.JButton jButton_CreateAnimatorFile;
    private javax.swing.JButton jButton_DataInfo;
    private javax.swing.JButton jButton_Draw;
    private javax.swing.JButton jButton_DrawSetting;
    private javax.swing.JButton jButton_FitToScreen;
    private javax.swing.JButton jButton_FullExtent;
    private javax.swing.JButton jButton_Identifer;
    private javax.swing.JButton jButton_LabelSet;
    private javax.swing.JButton jButton_NexTime;
    private javax.swing.JButton jButton_PageSet;
    private javax.swing.JButton jButton_PageZoomIn;
    private javax.swing.JButton jButton_PageZoomOut;
    private javax.swing.JButton jButton_Pan;
    private javax.swing.JButton jButton_PreTime;
    private javax.swing.JButton jButton_SavePicture;
    private javax.swing.JButton jButton_SelectElement;
    private javax.swing.JButton jButton_ViewData;
    private javax.swing.JButton jButton_ZoomIn;
    private javax.swing.JButton jButton_ZoomOut;
    private javax.swing.JButton jButton_ZoomToLayer;
    private javax.swing.JCheckBox jCheckBox_ColorVar;
    private javax.swing.JCheckBox jCheckBox_Lat;
    private javax.swing.JCheckBox jCheckBox_Level;
    private javax.swing.JCheckBox jCheckBox_Lon;
    private javax.swing.JCheckBox jCheckBox_Time;
    private javax.swing.JCheckBox jCheckBox_YReverse;
    private javax.swing.JComboBox jComboBox_DrawType;
    private javax.swing.JComboBox jComboBox_Lat1;
    private javax.swing.JComboBox jComboBox_Lat2;
    private javax.swing.JComboBox jComboBox_Level1;
    private javax.swing.JComboBox jComboBox_Level2;
    private javax.swing.JComboBox jComboBox_Lon1;
    private javax.swing.JComboBox jComboBox_Lon2;
    private javax.swing.JComboBox jComboBox_PageZoom;
    private javax.swing.JComboBox jComboBox_PlotDim;
    private javax.swing.JComboBox jComboBox_Time1;
    private javax.swing.JComboBox jComboBox_Time2;
    private javax.swing.JComboBox jComboBox_Variable;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel_Coordinate;
    private javax.swing.JLabel jLabel_Status;
    private javax.swing.JLabel jLabel_Variable;
    private javax.swing.JList jList_Stations;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel_Layers;
    private javax.swing.JPanel jPanel_Setting;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JToolBar.Separator jSeparator1;
    private javax.swing.JToolBar.Separator jSeparator2;
    private javax.swing.JToolBar.Separator jSeparator3;
    private javax.swing.JToolBar.Separator jSeparator4;
    private javax.swing.JToolBar.Separator jSeparator5;
    private javax.swing.JToolBar.Separator jSeparator6;
    private javax.swing.JToolBar.Separator jSeparator7;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JToolBar jToolBar2;
    private org.meteoinfo.legend.LayersLegend layersLegend1;
    private org.meteoinfo.layout.MapLayout mapLayout1;
    // End of variables declaration//GEN-END:variables
}
