/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop;

import com.formdev.flatlaf.FlatDarculaLaf;
import com.formdev.flatlaf.FlatDarkLaf;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLightLaf;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.parsers.ParserConfigurationException;
import org.meteoinfo.desktop.StackWindow;
import org.meteoinfo.desktop.config.Options;
import org.meteoinfo.desktop.forms.FrmMain;
import org.meteoinfo.desktop.forms.FrmTextEditor;
import org.meteoinfo.global.DataConvert;
import org.meteoinfo.global.util.FontUtil;
import org.meteoinfo.global.util.GlobalUtil;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.InteractiveConsole;
import org.python.util.PythonInterpreter;
import org.xml.sax.SAXException;

public class MeteoInfoMap {
    public static void main(String[] args) {
        List fontFns;
        String fontPath;
        if (args.length >= 1 && args[0].equalsIgnoreCase("-r")) {
            fontPath = GlobalUtil.getAppPath(FrmMain.class) + File.separator + "fonts";
            fontFns = GlobalUtil.getFiles((String)fontPath, (String)".ttc");
            for (String fontFn : fontFns) {
                System.out.println("Register: " + fontFn);
                FontUtil.registerFont((String)fontFn);
            }
            args = (String[])DataConvert.resizeArray((Object)args, (int)(args.length - 1));
        }
        if (args.length >= 1) {
            String fn;
            if (args[0].equalsIgnoreCase("-e")) {
                MeteoInfoMap.runTextEditor(args);
            } else if (args[0].equalsIgnoreCase("-i")) {
                MeteoInfoMap.runInteractive();
            } else if (args[0].equalsIgnoreCase("-b")) {
                if (args.length == 1) {
                    System.out.println("Script file name is needed!");
                    System.exit(0);
                } else {
                    fn = args[1];
                    if (new File(fn).isFile()) {
                        System.setProperty("java.awt.headless", "true");
                        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        System.out.println("Headless mode: " + ge.isHeadless());
                        MeteoInfoMap.runScript(args, fn, 1);
                    } else {
                        System.out.println("The script file does not exist!");
                        System.exit(0);
                    }
                }
            } else if (args[0].equalsIgnoreCase("-eng") || args[0].equalsIgnoreCase("-cn")) {
                MeteoInfoMap.runApplication(args[0].substring(1));
            } else if (args[0].equalsIgnoreCase("-r")) {
                fontPath = GlobalUtil.getAppPath(FrmMain.class) + File.separator + "fonts";
                fontFns = GlobalUtil.getFiles((String)fontPath, (String)".ttc");
                for (String fontFn : fontFns) {
                    System.out.println("Register: " + fontFn);
                    FontUtil.registerFont((String)fontFn);
                }
                MeteoInfoMap.runApplication();
            } else {
                fn = args[0];
                if (new File(fn).isFile()) {
                    MeteoInfoMap.runScript(args, fn, 0);
                } else {
                    System.out.println("The script file does not exist!");
                    System.exit(0);
                }
            }
        } else {
            MeteoInfoMap.runApplication();
        }
    }

    private static void runScript(String[] args, String fn, int idx) {
        String ext = GlobalUtil.getFileExtension((String)fn);
        System.out.println("Running Jython script...");
        PySystemState state = new PySystemState();
        if (args.length > idx + 1) {
            for (int i = idx + 1; i < args.length; ++i) {
                state.argv.append((PyObject)new PyString(args[i]));
            }
        }
        PythonInterpreter interp = new PythonInterpreter(null, state);
        String pluginPath = GlobalUtil.getAppPath(FrmMain.class) + File.separator + "plugins";
        List jarfns = GlobalUtil.getFiles((String)pluginPath, (String)".jar");
        String path = GlobalUtil.getAppPath(FrmMain.class) + File.separator + "pylib";
        interp.exec("import sys");
        interp.exec("sys.path.append('" + path + "')");
        for (String jarfn : jarfns) {
            interp.exec("sys.path.append('" + jarfn + "')");
        }
        interp.execfile(fn);
        System.exit(0);
    }

    private static void runInteractive() {
        InteractiveConsole console = new InteractiveConsole();
        try {
            console.exec("import sys");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        console.interact();
    }

    private static void runTextEditor(final String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmTextEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmTextEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmTextEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmTextEditor.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String fn;
                FrmTextEditor frmTE = new FrmTextEditor();
                frmTE.setDefaultCloseOperation(3);
                frmTE.setLocationRelativeTo(null);
                frmTE.setVisible(true);
                if (args.length > 1 && new File(fn = args[1]).isFile()) {
                    frmTE.openFiles(new File[]{new File(fn)});
                }
            }
        });
    }

    private static String getStartupPath() {
        String startupPath;
        boolean isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
        if (isDebug) {
            startupPath = System.getProperty("user.dir");
            if (startupPath.endsWith("MeteoInfo")) {
                startupPath = startupPath + "/MeteoInfoMap";
            }
        } else {
            startupPath = GlobalUtil.getAppPath(FrmMain.class);
        }
        return startupPath;
    }

    private static Options loadConfigureFile(String startupPath) {
        String fn = startupPath + File.separator + "config.xml";
        Options options = new Options();
        if (new File(fn).exists()) {
            try {
                options.loadConfigFile(fn);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                Logger.getLogger(FrmMain.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return options;
    }

    private static void runApplication() {
        MeteoInfoMap.runApplication(null);
    }

    private static void runApplication(final String locale) {
        final String startupPath = MeteoInfoMap.getStartupPath();
        final Options options = MeteoInfoMap.loadConfigureFile(startupPath);
        String laf = options.getLookFeel();
        if (laf.equals("FlatLightLaf")) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new FlatLightLaf());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (laf.equals("FlatDarculaLaf")) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new FlatDarculaLaf());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (laf.equals("FlatDarkLaf")) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new FlatDarkLaf());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (laf.equals("FlatIntelliJLaf")) {
            try {
                UIManager.setLookAndFeel((LookAndFeel)new FlatIntelliJLaf());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                String lafName;
                switch (laf) {
                    case "CDE/Motif": {
                        lafName = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
                        break;
                    }
                    case "Metal": {
                        lafName = "javax.swing.plaf.metal.MetalLookAndFeel";
                        break;
                    }
                    case "Windows": {
                        lafName = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                        break;
                    }
                    case "Windows Classic": {
                        lafName = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";
                        break;
                    }
                    case "Nimbus": {
                        lafName = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
                        break;
                    }
                    case "Mac": {
                        lafName = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
                        break;
                    }
                    case "GTK": {
                        lafName = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                        break;
                    }
                    default: {
                        lafName = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
                    }
                }
                UIManager.setLookAndFeel(lafName);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
                Logger.getLogger(MeteoInfoMap.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
                if (locale != null) {
                    switch (locale.toLowerCase()) {
                        case "eng": {
                            Locale.setDefault(Locale.ENGLISH);
                            break;
                        }
                        case "cn": {
                            Locale.setDefault(Locale.CHINA);
                        }
                    }
                }
                StackWindow sw = null;
                if (!isDebug) {
                    StackWindow handler = sw = new StackWindow("Show Exception Stack", 600, 400);
                    Thread.setDefaultUncaughtExceptionHandler(handler);
                    System.setOut(sw.printStream);
                    System.setErr(sw.printStream);
                }
                FontUtil.registerWeatherFont();
                FrmMain frame = new FrmMain(startupPath, options);
                frame.setDefaultCloseOperation(0);
                frame.setVisible(true);
                if (sw != null) {
                    sw.setLocationRelativeTo(frame);
                }
            }
        });
    }

    private static void registerFonts() {
        FontUtil.registerWeatherFont();
        String fn = GlobalUtil.getAppPath(FrmMain.class);
        String path = fn + File.separator + "font";
        File pathDir = new File(path);
        if (pathDir.isDirectory()) {
            File[] files = pathDir.listFiles();
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (File file : files) {
                try {
                    Font font = Font.createFont(0, file);
                    ge.registerFont(font);
                }
                catch (FontFormatException ex) {
                    Logger.getLogger(MeteoInfoMap.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(MeteoInfoMap.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }
}

