/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop;

import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.OutputStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.meteoinfo.desktop.config.JTextAreaPrintStream;

public class StackWindow
extends JFrame
implements Thread.UncaughtExceptionHandler {
    private final JTextArea textArea;
    JTextAreaPrintStream printStream;

    public StackWindow(String title, int width, int height) {
        super(title);
        this.setSize(width, height);
        this.textArea = new JTextArea();
        JScrollPane pane = new JScrollPane(this.textArea);
        this.textArea.setEditable(false);
        this.getContentPane().add(pane);
        this.printStream = new JTextAreaPrintStream((OutputStream)System.out, this.textArea);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                StackWindow.this.formWindowClosed(evt);
            }
        });
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.addStackInfo(e);
    }

    public void addStackInfo(final Throwable t) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                StackWindow.this.setVisible(true);
                StackWindow.this.toFront();
                t.printStackTrace(StackWindow.this.printStream);
                StackWindow.this.textArea.setCaretPosition(0);
            }
        });
    }

    private void formWindowClosed(WindowEvent evt) {
        this.textArea.setText("");
    }
}

