/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.desktop.forms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.meteoinfo.chart.Chart;
import org.meteoinfo.chart.ChartPanel;
import org.meteoinfo.chart.Location;
import org.meteoinfo.chart.plot.ChartPlotMethod;
import org.meteoinfo.chart.plot.Plot;
import org.meteoinfo.chart.plot.PlotOrientation;
import org.meteoinfo.chart.plot.XY1DPlot;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.XYDataset;
import org.meteoinfo.data.XYListDataset;
import org.meteoinfo.data.meteodata.MeteoDataInfo;
import org.meteoinfo.data.meteodata.PlotDimension;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.hysplit.HYSPLITTrajDataInfo;
import org.meteoinfo.desktop.config.GenericFileFilter;
import org.meteoinfo.desktop.forms.FrmDataInfo;
import org.meteoinfo.desktop.forms.FrmMain;
import org.meteoinfo.desktop.forms.FrmMeteoData;
import org.meteoinfo.desktop.forms.FrmViewData;
import org.meteoinfo.global.PointD;
import org.meteoinfo.image.AnimatedGifEncoder;
import org.meteoinfo.layer.LayerDrawType;
import org.meteoinfo.layer.MapLayer;
import org.meteoinfo.layout.LayoutChart;
import org.meteoinfo.layout.MapLayout;
import org.meteoinfo.legend.ColorBreak;
import org.meteoinfo.legend.LegendManage;
import org.meteoinfo.legend.LegendScheme;
import org.meteoinfo.legend.PointBreak;
import org.meteoinfo.legend.PolygonBreak;
import org.meteoinfo.legend.PolylineBreak;
import org.meteoinfo.shape.ShapeTypes;

public class FrmOneDim
extends JFrame {
    private FrmMain mainGUI;
    private MeteoDataInfo _meteoDataInfo = new MeteoDataInfo();
    private ChartPanel _chartPanel;
    private PlotDimension _plotDimension;
    private String _graphType;
    private List<PointD> _pointList = new ArrayList<PointD>();
    private boolean _isLoading = false;
    private boolean isSamePlotDim = false;
    private boolean _enableAnimation = true;
    private boolean _isRunning = false;
    private JButton jButton_Animator;
    private JButton jButton_ClearDraw;
    private JButton jButton_DataInfo;
    private JButton jButton_Draw;
    private JButton jButton_NexTime;
    private JButton jButton_PreTime;
    private JButton jButton_ViewData;
    private JCheckBox jCheckBox_Lat;
    private JCheckBox jCheckBox_Level;
    private JCheckBox jCheckBox_Lon;
    private JCheckBox jCheckBox_Time;
    private JCheckBox jCheckBox_YReverse;
    private JComboBox jComboBox_DrawType;
    private JComboBox jComboBox_Lat1;
    private JComboBox jComboBox_Lat2;
    private JComboBox jComboBox_Level1;
    private JComboBox jComboBox_Level2;
    private JComboBox jComboBox_Lon1;
    private JComboBox jComboBox_Lon2;
    private JComboBox jComboBox_PlotDim;
    private JComboBox jComboBox_Time1;
    private JComboBox jComboBox_Time2;
    private JComboBox jComboBox_Variable;
    private JLabel jLabel_DrawType;
    private JLabel jLabel_PlotDims;
    private JLabel jLabel_Variable;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel_Dimensions;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JSplitPane jSplitPane1;
    private JToolBar jToolBar1;

    public FrmOneDim(FrmMain frmMain, MeteoDataInfo aDataInfo) {
        this.initComponents();
        this.mainGUI = frmMain;
        this.jComboBox_Variable.setEditable(true);
        this._chartPanel = new ChartPanel(null);
        this.jSplitPane1.setRightComponent((Component)this._chartPanel);
        JPopupMenu popupMenu = this._chartPanel.getPopupMenu();
        if (popupMenu != null) {
            JMenuItem addToLayoutMI = new JMenuItem("Add to Layout");
            addToLayoutMI.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FrmOneDim.this.onAddToLayoutClick();
                }
            });
            popupMenu.add(addToLayoutMI);
        }
        this.setDefaultCloseOperation(2);
        this._meteoDataInfo = aDataInfo;
        BufferedImage image = null;
        try {
            image = ImageIO.read(this.getClass().getResource("/images/MeteoInfo_1_16x16x8.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setIconImage(image);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButton_DataInfo = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButton_Draw = new JButton();
        this.jButton_ViewData = new JButton();
        this.jButton_ClearDraw = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButton_PreTime = new JButton();
        this.jButton_NexTime = new JButton();
        this.jButton_Animator = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel_DrawType = new JLabel();
        this.jComboBox_DrawType = new JComboBox();
        this.jLabel_PlotDims = new JLabel();
        this.jComboBox_PlotDim = new JComboBox();
        this.jPanel_Dimensions = new JPanel();
        this.jCheckBox_Time = new JCheckBox();
        this.jComboBox_Time1 = new JComboBox();
        this.jCheckBox_Level = new JCheckBox();
        this.jComboBox_Time2 = new JComboBox();
        this.jComboBox_Level1 = new JComboBox();
        this.jComboBox_Level2 = new JComboBox();
        this.jCheckBox_Lat = new JCheckBox();
        this.jComboBox_Lat1 = new JComboBox();
        this.jComboBox_Lat2 = new JComboBox();
        this.jCheckBox_Lon = new JCheckBox();
        this.jComboBox_Lon1 = new JComboBox();
        this.jComboBox_Lon2 = new JComboBox();
        this.jLabel_Variable = new JLabel();
        this.jComboBox_Variable = new JComboBox();
        this.jCheckBox_YReverse = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.setDefaultCloseOperation(3);
        ResourceBundle bundle = ResourceBundle.getBundle("bundle/Bundle_FrmOneDim");
        this.setTitle(bundle.getString("FrmOneDim.title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                FrmOneDim.this.formWindowOpened(evt);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jButton_DataInfo.setIcon(new ImageIcon(this.getClass().getResource("/images/information.png")));
        ResourceBundle bundle1 = ResourceBundle.getBundle("bundle/Bundle_FrmMeteoData");
        this.jButton_DataInfo.setToolTipText(bundle1.getString("FrmMeteoData.jButton_DataInfo.toolTipText"));
        this.jButton_DataInfo.setFocusable(false);
        this.jButton_DataInfo.setHorizontalTextPosition(0);
        this.jButton_DataInfo.setVerticalTextPosition(3);
        this.jButton_DataInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmOneDim.this.jButton_DataInfoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_DataInfo);
        this.jToolBar1.add(this.jSeparator1);
        this.jButton_Draw.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_Draw.Image.png")));
        this.jButton_Draw.setToolTipText(bundle1.getString("FrmMeteoData.jButton_Draw.toolTipText"));
        this.jButton_Draw.setFocusable(false);
        this.jButton_Draw.setHorizontalTextPosition(0);
        this.jButton_Draw.setVerticalTextPosition(3);
        this.jButton_Draw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmOneDim.this.jButton_DrawActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Draw);
        this.jButton_ViewData.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_ViewData.Image.png")));
        this.jButton_ViewData.setToolTipText(bundle1.getString("FrmMeteoData.jButton_ViewData.toolTipText"));
        this.jButton_ViewData.setFocusable(false);
        this.jButton_ViewData.setHorizontalTextPosition(0);
        this.jButton_ViewData.setVerticalTextPosition(3);
        this.jButton_ViewData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmOneDim.this.jButton_ViewDataActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ViewData);
        this.jButton_ClearDraw.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_ClearDrawing.Image.png")));
        this.jButton_ClearDraw.setToolTipText(bundle1.getString("FrmMeteoData.jButton_ClearDraw.toolTipText"));
        this.jButton_ClearDraw.setFocusable(false);
        this.jButton_ClearDraw.setHorizontalTextPosition(0);
        this.jButton_ClearDraw.setVerticalTextPosition(3);
        this.jButton_ClearDraw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmOneDim.this.jButton_ClearDrawActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_ClearDraw);
        this.jToolBar1.add(this.jSeparator2);
        this.jButton_PreTime.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_PreTime.Image.png")));
        this.jButton_PreTime.setToolTipText(bundle1.getString("FrmMeteoData.jButton_PreTime.toolTipText"));
        this.jButton_PreTime.setFocusable(false);
        this.jButton_PreTime.setHorizontalTextPosition(0);
        this.jButton_PreTime.setVerticalTextPosition(3);
        this.jButton_PreTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmOneDim.this.jButton_PreTimeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_PreTime);
        this.jButton_NexTime.setIcon(new ImageIcon(this.getClass().getResource("/images/TSB_NextTime.Image.png")));
        this.jButton_NexTime.setToolTipText(bundle1.getString("FrmMeteoData.jButton_NexTime.toolTipText"));
        this.jButton_NexTime.setFocusable(false);
        this.jButton_NexTime.setHorizontalTextPosition(0);
        this.jButton_NexTime.setVerticalTextPosition(3);
        this.jButton_NexTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmOneDim.this.jButton_NexTimeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_NexTime);
        this.jButton_Animator.setIcon(new ImageIcon(this.getClass().getResource("/images/animation-1.png")));
        this.jButton_Animator.setToolTipText(bundle1.getString("FrmMeteoData.jButton_Animator.toolTipText"));
        this.jButton_Animator.setFocusable(false);
        this.jButton_Animator.setHorizontalTextPosition(0);
        this.jButton_Animator.setVerticalTextPosition(3);
        this.jButton_Animator.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmOneDim.this.jButton_AnimatorActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton_Animator);
        this.jSplitPane1.setDividerLocation(250);
        this.jSplitPane1.setPreferredSize(new Dimension(737, 465));
        this.jPanel1.setPreferredSize(new Dimension(250, 463));
        this.jLabel_DrawType.setText(bundle.getString("FrmOneDim.jLabel_DrawType.text"));
        this.jComboBox_DrawType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_DrawType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmOneDim.this.jComboBox_DrawTypeActionPerformed(evt);
            }
        });
        this.jLabel_PlotDims.setText(bundle.getString("FrmOneDim.jLabel_PlotDims.text"));
        this.jComboBox_PlotDim.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_PlotDim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmOneDim.this.jComboBox_PlotDimActionPerformed(evt);
            }
        });
        this.jPanel_Dimensions.setBorder(BorderFactory.createTitledBorder(""));
        this.jCheckBox_Time.setText(bundle.getString("FrmOneDim.jCheckBox_Time.text"));
        this.jCheckBox_Time.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmOneDim.this.jCheckBox_TimeStateChanged(evt);
            }
        });
        this.jComboBox_Time1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCheckBox_Level.setText(bundle.getString("FrmOneDim.jCheckBox_Level.text"));
        this.jCheckBox_Level.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmOneDim.this.jCheckBox_LevelStateChanged(evt);
            }
        });
        this.jComboBox_Time2.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Level1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Level2.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCheckBox_Lat.setText(bundle.getString("FrmOneDim.jCheckBox_Lat.text"));
        this.jCheckBox_Lat.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmOneDim.this.jCheckBox_LatStateChanged(evt);
            }
        });
        this.jComboBox_Lat1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Lat2.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jCheckBox_Lon.setText(bundle.getString("FrmOneDim.jCheckBox_Lon.text"));
        this.jCheckBox_Lon.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrmOneDim.this.jCheckBox_LonStateChanged(evt);
            }
        });
        this.jComboBox_Lon1.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Lon2.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout jPanel_DimensionsLayout = new GroupLayout(this.jPanel_Dimensions);
        this.jPanel_Dimensions.setLayout(jPanel_DimensionsLayout);
        jPanel_DimensionsLayout.setHorizontalGroup(jPanel_DimensionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DimensionsLayout.createSequentialGroup().addGroup(jPanel_DimensionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DimensionsLayout.createSequentialGroup().addComponent(this.jCheckBox_Lat).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_DimensionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_Lat2, 0, 124, Short.MAX_VALUE).addComponent(this.jComboBox_Lat1, 0, 1, Short.MAX_VALUE))).addGroup(jPanel_DimensionsLayout.createSequentialGroup().addComponent(this.jCheckBox_Lon).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_DimensionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_Lon1, 0, 1, Short.MAX_VALUE).addComponent(this.jComboBox_Lon2, GroupLayout.Alignment.TRAILING, 0, 0, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, jPanel_DimensionsLayout.createSequentialGroup().addGroup(jPanel_DimensionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBox_Level).addComponent(this.jCheckBox_Time)).addGap(6, 6, 6).addGroup(jPanel_DimensionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox_Time1, 0, 1, Short.MAX_VALUE).addComponent(this.jComboBox_Time2, 0, 0, Short.MAX_VALUE).addComponent(this.jComboBox_Level1, 0, 1, Short.MAX_VALUE).addComponent(this.jComboBox_Level2, GroupLayout.Alignment.TRAILING, 0, 0, Short.MAX_VALUE)))).addContainerGap()));
        jPanel_DimensionsLayout.setVerticalGroup(jPanel_DimensionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_DimensionsLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_DimensionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox_Time).addComponent(this.jComboBox_Time1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Time2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_DimensionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox_Level).addComponent(this.jComboBox_Level1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Level2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_DimensionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox_Lat).addComponent(this.jComboBox_Lat1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Lat2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel_DimensionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBox_Lon).addComponent(this.jComboBox_Lon1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Lon2, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabel_Variable.setText(bundle.getString("FrmOneDim.jLabel_Variable.text"));
        this.jComboBox_Variable.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_Variable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmOneDim.this.jComboBox_VariableActionPerformed(evt);
            }
        });
        this.jCheckBox_YReverse.setText(bundle.getString("FrmOneDim.jCheckBox_YReverse.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel_PlotDims).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_PlotDim, 0, 1, Short.MAX_VALUE)).addComponent(this.jPanel_Dimensions, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel_DrawType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_DrawType, 0, 1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jCheckBox_YReverse).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel_Variable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_Variable, 0, 1, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBox_Variable, -2, -1, -2).addComponent(this.jLabel_Variable)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_DrawType).addComponent(this.jComboBox_DrawType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel_PlotDims).addComponent(this.jComboBox_PlotDim, -2, -1, -2)).addGap(14, 14, 14).addComponent(this.jCheckBox_YReverse).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel_Dimensions, -2, -1, -2).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jPanel2.setLayout(new BorderLayout());
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitPane1, -1, 764, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 476, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton_DataInfoActionPerformed(ActionEvent evt) {
        FrmDataInfo frmDI = new FrmDataInfo();
        frmDI.setLocationRelativeTo(this);
        frmDI.setText(this._meteoDataInfo.getInfoText());
        frmDI.setVisible(true);
    }

    private void jButton_DrawActionPerformed(ActionEvent evt) {
        if (this.jComboBox_PlotDim.getSelectedItem() == null) {
            JOptionPane.showMessageDialog(null, "It's not a muti dimension variable: " + this.jComboBox_Variable.getSelectedItem().toString() + "!");
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        String varName = this.jComboBox_Variable.getSelectedItem().toString();
        ChartPlotMethod method = (ChartPlotMethod)this.jComboBox_DrawType.getSelectedItem();
        switch (this._meteoDataInfo.getDataType()) {
            case HYSPLIT_Traj: {
                int varIdx = 11;
                String yLabel = "Meters AGL";
                if (varName.equals("Pressure")) {
                    varIdx = 12;
                    yLabel = "hPa";
                }
                XYListDataset ldataset = ((HYSPLITTrajDataInfo)this._meteoDataInfo.getDataInfo()).getXYDataset(varIdx);
                LegendScheme ls = null;
                MapLayer layer = this.mainGUI.getMeteoDataset().getLastAddLayer();
                if (layer != null && layer.getLayerDrawType() == LayerDrawType.TrajLine) {
                    ls = layer.getLegendScheme();
                }
                if (ls == null) {
                    ls = LegendManage.createUniqValueLegendScheme((int)ldataset.getSeriesCount(), (ShapeTypes)ShapeTypes.Polyline);
                    for (ColorBreak cb : ls.getLegendBreaks()) {
                        PolylineBreak plb = (PolylineBreak)cb;
                        plb.setDrawSymbol(true);
                        plb.setSymbolInterval(6);
                        plb.setWidth(2.0f);
                    }
                }
                boolean yInverse = varName.equals("Pressure");
                this.createChart((XYDataset)ldataset, ls.getLegendBreaks(), null, "Time", yLabel, method, PlotOrientation.VERTICAL, yInverse, false, true, false);
                break;
            }
            default: {
                this._plotDimension = PlotDimension.valueOf((String)this.jComboBox_PlotDim.getSelectedItem().toString());
                this._meteoDataInfo.setDimensionSet(this._plotDimension);
                String seriesKey = varName;
                switch (this._plotDimension) {
                    case Level: {
                        seriesKey = seriesKey + "_" + this.jComboBox_Lon1.getSelectedItem().toString() + "_" + this.jComboBox_Lat1.getSelectedItem().toString() + "_" + this.jComboBox_Time1.getSelectedItem().toString();
                        break;
                    }
                    case Time: {
                        seriesKey = seriesKey + "_" + this.jComboBox_Level1.getSelectedItem().toString() + "_" + this.jComboBox_Lon1.getSelectedItem().toString() + "_" + this.jComboBox_Lat1.getSelectedItem().toString();
                        break;
                    }
                    case Lon: {
                        seriesKey = seriesKey + "_" + this.jComboBox_Level1.getSelectedItem().toString() + "_" + this.jComboBox_Lat1.getSelectedItem().toString() + "_" + this.jComboBox_Time1.getSelectedItem().toString();
                        break;
                    }
                    case Lat: {
                        seriesKey = seriesKey + "_" + this.jComboBox_Level1.getSelectedItem().toString() + "_" + this.jComboBox_Lon1.getSelectedItem().toString() + "_" + this.jComboBox_Time1.getSelectedItem().toString();
                    }
                }
                this._meteoDataInfo.setLonIndex(this.jComboBox_Lon1.getSelectedIndex());
                double y = Double.parseDouble(this.jComboBox_Lat1.getSelectedItem().toString());
                org.meteoinfo.ndarray.Dimension ydim = this._meteoDataInfo.getDataInfo().getYDimension();
                this._meteoDataInfo.setLatIndex(ydim.getValueIndex(y));
                this._meteoDataInfo.setLevelIndex(this.jComboBox_Level1.getSelectedIndex());
                this._meteoDataInfo.setTimeIndex(this.jComboBox_Time1.getSelectedIndex());
                GridData gData = this._meteoDataInfo.getGridData(varName);
                if (gData == null) {
                    return;
                }
                int itemCount = gData.getXNum();
                double[] xvs = new double[itemCount];
                double[] yvs = new double[itemCount];
                for (int i = 0; i < itemCount; ++i) {
                    xvs[i] = gData.xArray[i];
                    yvs[i] = gData.data[0][i];
                }
                if (this.isSamePlotDim && this._chartPanel.getChart() != null) {
                    XY1DPlot plot = (XY1DPlot)this._chartPanel.getChart().getPlot();
                    plot.addSeries(seriesKey, xvs, yvs);
                    int idx = plot.getDataset().getSeriesCount() - 1;
                    ColorBreak cb = plot.getLegendBreak(idx);
                    PolylineBreak plb = new PolylineBreak();
                    plb.setCaption(seriesKey);
                    plb.setColor(cb.getColor());
                    plb.setSymbolColor(cb.getColor());
                    switch (method) {
                        case LINE: {
                            plb.setDrawSymbol(false);
                            plot.setLegendBreak(idx, (ColorBreak)plb);
                            break;
                        }
                        case LINE_POINT: {
                            plb.setDrawSymbol(true);
                            plot.setLegendBreak(idx, (ColorBreak)plb);
                            break;
                        }
                        case POINT: {
                            PointBreak pb = new PointBreak();
                            pb.setColor(cb.getColor());
                            pb.setSize(plb.getSymbolSize());
                            pb.setStyle(plb.getSymbolStyle());
                            pb.setCaption(seriesKey);
                            plot.setLegendBreak(idx, (ColorBreak)pb);
                            break;
                        }
                        case BAR: {
                            PolygonBreak pgb = new PolygonBreak();
                            pgb.setColor(cb.getColor());
                            pgb.setCaption(seriesKey);
                            plot.setLegendBreak(idx, (ColorBreak)pgb);
                        }
                    }
                    this._chartPanel.paintGraphics();
                } else {
                    XYListDataset dataset = new XYListDataset();
                    dataset.addSeries(seriesKey, xvs, yvs);
                    dataset.setMissingValue(gData.missingValue);
                    String title = varName + "_" + this.jComboBox_PlotDim.getSelectedItem().toString() + " Graph";
                    PlotOrientation po = PlotOrientation.VERTICAL;
                    boolean yInverse = this.jCheckBox_YReverse.isSelected();
                    if (this._plotDimension == PlotDimension.Level) {
                        po = PlotOrientation.HORIZONTAL;
                    }
                    String xLabel = this._plotDimension.toString();
                    boolean isTime = false;
                    if (this._plotDimension == PlotDimension.Time) {
                        isTime = true;
                    }
                    LegendScheme ls = LegendManage.createUniqValueLegendScheme((int)dataset.getSeriesCount(), (ShapeTypes)ShapeTypes.Polyline);
                    for (ColorBreak cb : ls.getLegendBreaks()) {
                        PolylineBreak plb = (PolylineBreak)cb;
                        plb.setDrawSymbol(true);
                    }
                    this.createChart((XYDataset)dataset, ls.getLegendBreaks(), title, xLabel, varName, method, po, yInverse, false, isTime, true);
                }
                if (this.jCheckBox_Time.isSelected() || this.jComboBox_Time1.getItemCount() <= 1) break;
                this.jButton_NexTime.setEnabled(true);
                this.jButton_PreTime.setEnabled(true);
                this.jButton_Animator.setEnabled(true);
            }
        }
        this.isSamePlotDim = true;
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void display() {
        String varName = this.jComboBox_Variable.getSelectedItem().toString();
        ChartPlotMethod method = (ChartPlotMethod)this.jComboBox_DrawType.getSelectedItem();
        this._plotDimension = PlotDimension.valueOf((String)this.jComboBox_PlotDim.getSelectedItem().toString());
        this._meteoDataInfo.setDimensionSet(this._plotDimension);
        String seriesKey = varName;
        switch (this._plotDimension) {
            case Level: {
                seriesKey = seriesKey + "_" + this.jComboBox_Lon1.getSelectedItem().toString() + "_" + this.jComboBox_Lat1.getSelectedItem().toString() + "_" + this.jComboBox_Time1.getSelectedItem().toString();
                break;
            }
            case Time: {
                seriesKey = seriesKey + "_" + this.jComboBox_Level1.getSelectedItem().toString() + "_" + this.jComboBox_Lon1.getSelectedItem().toString() + "_" + this.jComboBox_Lat1.getSelectedItem().toString();
                break;
            }
            case Lon: {
                seriesKey = seriesKey + "_" + this.jComboBox_Level1.getSelectedItem().toString() + "_" + this.jComboBox_Lat1.getSelectedItem().toString() + "_" + this.jComboBox_Time1.getSelectedItem().toString();
                break;
            }
            case Lat: {
                seriesKey = seriesKey + "_" + this.jComboBox_Level1.getSelectedItem().toString() + "_" + this.jComboBox_Lon1.getSelectedItem().toString() + "_" + this.jComboBox_Time1.getSelectedItem().toString();
            }
        }
        this._meteoDataInfo.setLonIndex(this.jComboBox_Lon1.getSelectedIndex());
        this._meteoDataInfo.setLatIndex(this.jComboBox_Lat1.getSelectedIndex());
        this._meteoDataInfo.setLevelIndex(this.jComboBox_Level1.getSelectedIndex());
        this._meteoDataInfo.setTimeIndex(this.jComboBox_Time1.getSelectedIndex());
        GridData gData = this._meteoDataInfo.getGridData(varName);
        if (gData == null) {
            return;
        }
        int itemCount = gData.getXNum();
        double[] xvs = new double[itemCount];
        double[] yvs = new double[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            xvs[i] = gData.xArray[i];
            yvs[i] = gData.data[0][i];
        }
        XYListDataset dataset = new XYListDataset();
        dataset.addSeries(seriesKey, xvs, yvs);
        dataset.setMissingValue(gData.missingValue);
        String title = varName + "_" + this.jComboBox_PlotDim.getSelectedItem().toString() + " Graph";
        PlotOrientation po = PlotOrientation.VERTICAL;
        boolean yInverse = false;
        if (this._plotDimension == PlotDimension.Level) {
            po = PlotOrientation.HORIZONTAL;
            yInverse = true;
        }
        String xLabel = this._plotDimension.toString();
        boolean isTime = false;
        if (this._plotDimension == PlotDimension.Time) {
            isTime = true;
        }
        LegendScheme ls = LegendManage.createUniqValueLegendScheme((int)dataset.getSeriesCount(), (ShapeTypes)ShapeTypes.Polyline);
        for (ColorBreak cb : ls.getLegendBreaks()) {
            PolylineBreak plb = (PolylineBreak)cb;
            plb.setDrawSymbol(true);
        }
        this.createChart((XYDataset)dataset, ls.getLegendBreaks(), title, xLabel, varName, method, po, yInverse, false, isTime, true);
    }

    private void jButton_ViewDataActionPerformed(ActionEvent evt) {
        if (this._chartPanel.getChart() == null) {
            return;
        }
        XYListDataset dataset = (XYListDataset)this._chartPanel.getChart().getPlot().getDataset();
        FrmViewData frmData = new FrmViewData();
        frmData.setXYData(dataset);
        frmData.setLocationRelativeTo(this);
        frmData.setVisible(true);
    }

    private void jButton_ClearDrawActionPerformed(ActionEvent evt) {
        this.isSamePlotDim = false;
        this._chartPanel.setChart(null);
        this._chartPanel.paintGraphics();
    }

    private void jButton_PreTimeActionPerformed(ActionEvent evt) {
        if (this.jComboBox_Time1.getSelectedIndex() > 0) {
            this.jComboBox_Time1.setSelectedIndex(this.jComboBox_Time1.getSelectedIndex() - 1);
        } else {
            this.jComboBox_Time1.setSelectedIndex(this.jComboBox_Time1.getItemCount() - 1);
        }
        this.isSamePlotDim = false;
        this.jButton_Draw.doClick();
    }

    private void jButton_NexTimeActionPerformed(ActionEvent evt) {
        if (this.jComboBox_Time1.getSelectedIndex() < this.jComboBox_Time1.getItemCount() - 1) {
            this.jComboBox_Time1.setSelectedIndex(this.jComboBox_Time1.getSelectedIndex() + 1);
        } else {
            this.jComboBox_Time1.setSelectedIndex(0);
        }
        this.isSamePlotDim = false;
        this.jButton_Draw.doClick();
    }

    private void jButton_AnimatorActionPerformed(ActionEvent evt) {
        if (this._isRunning) {
            this._enableAnimation = false;
        } else {
            this.run_Animation(false);
        }
    }

    private void run_Animation(final boolean isCreateFile) {
        final AnimatedGifEncoder encoder = new AnimatedGifEncoder();
        if (isCreateFile) {
            JFileChooser aDlg = new JFileChooser();
            String[] fileExts = new String[]{"gif"};
            GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "Gif File (*.gif)");
            aDlg.setFileFilter(mapFileFilter);
            File dir = new File(System.getProperty("user.dir"));
            if (dir.isDirectory()) {
                aDlg.setCurrentDirectory(dir);
            }
            aDlg.setAcceptAllFileFilterUsed(false);
            if (aDlg.showSaveDialog(this) == 0) {
                File file = aDlg.getSelectedFile();
                System.setProperty("user.dir", file.getParent());
                String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
                String fileName = file.getAbsolutePath();
                if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                    fileName = fileName + "." + extent;
                }
                encoder.setRepeat(0);
                encoder.setDelay(1000);
                encoder.start(fileName);
            }
        }
        switch (this._meteoDataInfo.getDataType()) {
            default: 
        }
        if (this.jComboBox_Time1.getItemCount() > 1) {
            SwingWorker<String, String> worker = new SwingWorker<String, String>(){

                @Override
                protected String doInBackground() throws Exception {
                    FrmOneDim.this.jButton_Animator.setIcon(new ImageIcon(this.getClass().getResource("/images/stop.png")));
                    FrmOneDim.this._isRunning = true;
                    for (int i = 0; i < FrmOneDim.this.jComboBox_Time1.getItemCount(); ++i) {
                        if (!FrmOneDim.this._enableAnimation) {
                            FrmOneDim.this._enableAnimation = true;
                            FrmOneDim.this._isRunning = false;
                            FrmOneDim.this.jButton_Animator.setIcon(new ImageIcon(this.getClass().getResource("/images/animation-1.png")));
                            return "";
                        }
                        FrmOneDim.this.jComboBox_Time1.setSelectedIndex(i);
                        FrmOneDim.this.display();
                        if (isCreateFile) {
                            encoder.addFrame(FrmOneDim.this._chartPanel.getViewImage());
                            continue;
                        }
                        try {
                            Thread.sleep(500L);
                            continue;
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(FrmMeteoData.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    FrmOneDim.this._enableAnimation = true;
                    FrmOneDim.this._isRunning = false;
                    FrmOneDim.this.jButton_Animator.setIcon(new ImageIcon(this.getClass().getResource("/images/animation-1.png")));
                    encoder.finish();
                    return "";
                }
            };
            worker.execute();
        }
    }

    private void jComboBox_VariableActionPerformed(ActionEvent evt) {
        if (this._isLoading) {
            return;
        }
        Variable var = this._meteoDataInfo.getDataInfo().getVariable(this.jComboBox_Variable.getSelectedItem().toString());
        if (var == null) {
            return;
        }
        this._meteoDataInfo.setVariableIndex(this.jComboBox_Variable.getSelectedIndex());
        this.setVariableParas(var);
        this.updateEndDimSetS(this.jComboBox_Level1, this.jComboBox_Level2);
        this.jButton_Draw.setEnabled(true);
        this.jButton_Animator.setEnabled(false);
        this.jButton_PreTime.setEnabled(false);
        this.jButton_NexTime.setEnabled(false);
        this._isLoading = true;
        String pdStr = this.jComboBox_PlotDim.getSelectedItem().toString();
        this.jComboBox_PlotDim.removeAllItems();
        if (this.jComboBox_Level1.getItemCount() > 1) {
            this.jComboBox_PlotDim.addItem(PlotDimension.Level.toString());
        }
        if (this.jComboBox_Time1.getItemCount() > 1) {
            this.jComboBox_PlotDim.addItem(PlotDimension.Time.toString());
        }
        if (this.jComboBox_Lon1.getItemCount() > 1) {
            this.jComboBox_PlotDim.addItem(PlotDimension.Lon.toString());
        }
        if (this.jComboBox_Lat1.getItemCount() > 1) {
            this.jComboBox_PlotDim.addItem(PlotDimension.Lat.toString());
        }
        ArrayList<String> dimItems = new ArrayList<String>();
        for (int i = 0; i < this.jComboBox_PlotDim.getItemCount(); ++i) {
            dimItems.add(this.jComboBox_PlotDim.getItemAt(i).toString());
        }
        this._isLoading = false;
        if (!"".equals(pdStr) && dimItems.contains(pdStr)) {
            this.isSamePlotDim = true;
            this.jComboBox_PlotDim.setSelectedItem(pdStr);
        } else {
            this.isSamePlotDim = false;
            if (this.jComboBox_PlotDim.getItemCount() > 0) {
                this.jComboBox_PlotDim.setSelectedIndex(0);
            }
        }
    }

    private void jComboBox_DrawTypeActionPerformed(ActionEvent evt) {
        if (this._isLoading) {
            return;
        }
        if (this.jComboBox_DrawType.getItemCount() == 0) {
            return;
        }
        this._graphType = this.jComboBox_DrawType.getSelectedItem().toString();
    }

    private void jComboBox_PlotDimActionPerformed(ActionEvent evt) {
        if (this._isLoading) {
            return;
        }
        this._plotDimension = PlotDimension.valueOf((String)this.jComboBox_PlotDim.getSelectedItem().toString());
        this._meteoDataInfo.setDimensionSet(this._plotDimension);
        this.setDimensions();
        this.isSamePlotDim = false;
        this.jButton_Draw.setEnabled(true);
        this.jButton_Animator.setEnabled(false);
        this.jButton_PreTime.setEnabled(false);
        this.jButton_NexTime.setEnabled(false);
    }

    private void jCheckBox_TimeStateChanged(ChangeEvent evt) {
        if (this._isLoading) {
            return;
        }
        this.jComboBox_Time2.setVisible(this.jCheckBox_Time.isSelected());
        if (this.jCheckBox_Time.isSelected()) {
            if (this.jComboBox_Time1.getItemCount() > 0) {
                this.jComboBox_Time1.setSelectedIndex(0);
                this.jComboBox_Time2.setSelectedIndex(this.jComboBox_Time2.getItemCount() - 1);
            }
            this.jComboBox_Time1.setEnabled(false);
            this.jComboBox_Time2.setEnabled(false);
        } else {
            this.jComboBox_Time1.setEnabled(true);
            this.jComboBox_Time2.setEnabled(true);
        }
    }

    private void jCheckBox_LevelStateChanged(ChangeEvent evt) {
        if (this._isLoading) {
            return;
        }
        this.jComboBox_Level2.setVisible(this.jCheckBox_Level.isSelected());
        if (this.jCheckBox_Level.isSelected()) {
            if (this.jComboBox_Level1.getItemCount() > 0) {
                this.jComboBox_Level1.setSelectedIndex(0);
                this.jComboBox_Level2.setSelectedIndex(this.jComboBox_Level2.getItemCount() - 1);
            }
            this.jComboBox_Level1.setEnabled(false);
            this.jComboBox_Level2.setEnabled(false);
        } else {
            this.jComboBox_Level1.setEnabled(true);
            this.jComboBox_Level2.setEnabled(true);
        }
    }

    private void jCheckBox_LatStateChanged(ChangeEvent evt) {
        if (this._isLoading) {
            return;
        }
        this.jComboBox_Lat2.setVisible(this.jCheckBox_Lat.isSelected());
        if (this.jCheckBox_Lat.isSelected()) {
            if (this.jComboBox_Lat1.getItemCount() > 0) {
                this.jComboBox_Lat1.setSelectedIndex(0);
                this.jComboBox_Lat2.setSelectedIndex(this.jComboBox_Lat2.getItemCount() - 1);
            }
            this.jComboBox_Lat1.setEnabled(false);
            this.jComboBox_Lat2.setEnabled(false);
        } else {
            this.jComboBox_Lat1.setEnabled(true);
            this.jComboBox_Lat2.setEnabled(true);
        }
    }

    private void jCheckBox_LonStateChanged(ChangeEvent evt) {
        if (this._isLoading) {
            return;
        }
        this.jComboBox_Lon2.setVisible(this.jCheckBox_Lon.isSelected());
        if (this.jCheckBox_Lon.isSelected()) {
            if (this.jComboBox_Lon1.getItemCount() > 0) {
                this.jComboBox_Lon1.setSelectedIndex(0);
                this.jComboBox_Lon2.setSelectedIndex(this.jComboBox_Lon2.getItemCount() - 1);
            }
            this.jComboBox_Lon1.setEnabled(false);
            this.jComboBox_Lon2.setEnabled(false);
        } else {
            this.jComboBox_Lon1.setEnabled(true);
            this.jComboBox_Lon2.setEnabled(true);
        }
    }

    private void formWindowOpened(WindowEvent evt) {
        this._isLoading = true;
        switch (this._meteoDataInfo.getDataType()) {
            case HYSPLIT_Traj: {
                this.jPanel_Dimensions.setVisible(false);
                this.jComboBox_Lat1.setVisible(false);
                this.jComboBox_Lat2.setVisible(false);
                this.jComboBox_Level1.setVisible(false);
                this.jComboBox_Level2.setVisible(false);
                this.jComboBox_Lon1.setVisible(false);
                this.jComboBox_Lon2.setVisible(false);
                this.jComboBox_PlotDim.setVisible(false);
                this.jComboBox_Time1.setVisible(false);
                this.jComboBox_Time2.setVisible(false);
                this.jCheckBox_Lat.setVisible(false);
                this.jCheckBox_Level.setVisible(false);
                this.jCheckBox_Lon.setVisible(false);
                this.jCheckBox_Time.setVisible(false);
                this.jLabel_PlotDims.setVisible(false);
                this.jComboBox_Variable.setEditable(false);
                this.jComboBox_Variable.removeAllItems();
                this.jComboBox_Variable.addItem("Altitude");
                this.jComboBox_Variable.addItem("Pressure");
                this.jComboBox_Variable.setSelectedIndex(0);
                break;
            }
            default: {
                this.jComboBox_Lat2.setVisible(false);
                this.jComboBox_Level2.setVisible(false);
                this.jComboBox_Lon2.setVisible(false);
                this.jComboBox_Time2.setVisible(false);
                this.jCheckBox_Time.setEnabled(false);
                this.jCheckBox_Level.setEnabled(false);
                this.jCheckBox_Lon.setEnabled(false);
                this.jCheckBox_Lat.setEnabled(false);
                this.updateDimensions();
            }
        }
        this.jComboBox_DrawType.removeAllItems();
        for (ChartPlotMethod method : ChartPlotMethod.values()) {
            this.jComboBox_DrawType.addItem(method);
        }
        this.jComboBox_DrawType.setSelectedItem(ChartPlotMethod.LINE_POINT);
        this._isLoading = false;
    }

    private void onAddToLayoutClick() {
        MapLayout mapLayout = this.mainGUI.getMapDocument().getMapLayout();
        LayoutChart chart = mapLayout.addChart(100, 100);
        chart.setChart(this._chartPanel.getChart());
        mapLayout.paintGraphics();
    }

    private void setVariableParas(Variable var) {
        int levelIdx = this.jComboBox_Level1.getSelectedIndex();
        this.jComboBox_Level1.removeAllItems();
        org.meteoinfo.ndarray.Dimension zDim = var.getZDimension();
        if (zDim == null) {
            this.jComboBox_Level1.addItem("Surface");
            this.jComboBox_Level1.setSelectedIndex(0);
        } else {
            for (int i = 0; i < var.getLevelNum(); ++i) {
                this.jComboBox_Level1.addItem(String.valueOf(zDim.getDimValue().get(i)));
            }
            if (levelIdx > -1 && this.jComboBox_Level1.getItemCount() > levelIdx) {
                this.jComboBox_Level1.setSelectedIndex(levelIdx);
            } else {
                this.jComboBox_Level1.setSelectedIndex(0);
            }
        }
    }

    private void updateDimensions() {
        int i;
        this.jComboBox_Time1.removeAllItems();
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        for (i = 0; i < this._meteoDataInfo.getDataInfo().getTimeNum(); ++i) {
            this.jComboBox_Time1.addItem(sdf.format((TemporalAccessor)this._meteoDataInfo.getDataInfo().getTimes().get(i)));
        }
        this.jComboBox_Time1.setSelectedIndex(0);
        this.jComboBox_Lon1.removeAllItems();
        for (i = 0; i < this._meteoDataInfo.getDataInfo().getXDimension().getLength(); ++i) {
            this.jComboBox_Lon1.addItem(String.valueOf(this._meteoDataInfo.getDataInfo().getXDimension().getDimValue().get(i)));
        }
        this.jComboBox_Lon1.setSelectedIndex(0);
        this.jComboBox_Lat1.removeAllItems();
        for (i = 0; i < this._meteoDataInfo.getDataInfo().getYDimension().getLength(); ++i) {
            this.jComboBox_Lat1.addItem(String.valueOf(this._meteoDataInfo.getDataInfo().getYDimension().getDimValue().get(i)));
        }
        this.jComboBox_Lat1.setSelectedIndex(0);
        this.updateEndDimSet();
        this.jComboBox_Variable.setEnabled(true);
        this.jComboBox_Variable.removeAllItems();
        for (i = 0; i < this._meteoDataInfo.getDataInfo().getVariableNum(); ++i) {
            Variable var = (Variable)this._meteoDataInfo.getDataInfo().getVariables().get(i);
            if (!var.isPlottable()) continue;
            this.jComboBox_Variable.addItem(var.getName());
        }
        this._isLoading = false;
        this.jComboBox_Variable.setSelectedIndex(0);
    }

    private void updateEndDimSet() {
        int i;
        this.jComboBox_Time2.removeAllItems();
        for (i = 0; i < this.jComboBox_Time1.getItemCount(); ++i) {
            this.jComboBox_Time2.addItem(this.jComboBox_Time1.getItemAt(i));
        }
        this.jComboBox_Time2.setSelectedIndex(this.jComboBox_Time2.getItemCount() - 1);
        this.jComboBox_Level2.removeAllItems();
        for (i = 0; i < this.jComboBox_Level1.getItemCount(); ++i) {
            this.jComboBox_Level2.addItem(this.jComboBox_Level1.getItemAt(i));
        }
        this.jComboBox_Level2.setSelectedIndex(this.jComboBox_Level2.getItemCount() - 1);
        this.jComboBox_Lon2.removeAllItems();
        for (i = 0; i < this.jComboBox_Lon1.getItemCount(); ++i) {
            this.jComboBox_Lon2.addItem(this.jComboBox_Lon1.getItemAt(i));
        }
        this.jComboBox_Lon2.setSelectedIndex(this.jComboBox_Lon2.getItemCount() - 1);
        this.jComboBox_Lat2.removeAllItems();
        for (i = 0; i < this.jComboBox_Lat1.getItemCount(); ++i) {
            this.jComboBox_Lat2.addItem(this.jComboBox_Lat1.getItemAt(i));
        }
        this.jComboBox_Lat2.setSelectedIndex(this.jComboBox_Lat2.getItemCount() - 1);
    }

    private void updateEndDimSetS(JComboBox CB1, JComboBox CB2) {
        CB2.removeAllItems();
        for (int i = 0; i < CB1.getItemCount(); ++i) {
            CB2.addItem(CB1.getItemAt(i));
        }
        CB2.setSelectedIndex(CB2.getItemCount() - 1);
    }

    private void setDimensions() {
        switch (this._plotDimension) {
            case Time: {
                this.jCheckBox_Lat.setSelected(false);
                this.jCheckBox_Level.setSelected(false);
                this.jCheckBox_Time.setSelected(true);
                this.jCheckBox_Lon.setSelected(false);
                break;
            }
            case Level: {
                this.jCheckBox_Lat.setSelected(false);
                this.jCheckBox_Level.setSelected(true);
                this.jCheckBox_Time.setSelected(false);
                this.jCheckBox_Lon.setSelected(false);
                break;
            }
            case Lat: {
                this.jCheckBox_Lat.setSelected(true);
                this.jCheckBox_Level.setSelected(false);
                this.jCheckBox_Time.setSelected(false);
                this.jCheckBox_Lon.setSelected(false);
                break;
            }
            case Lon: {
                this.jCheckBox_Lat.setSelected(false);
                this.jCheckBox_Level.setSelected(false);
                this.jCheckBox_Time.setSelected(false);
                this.jCheckBox_Lon.setSelected(true);
            }
        }
    }

    private void createChart(XYDataset dataset, List<ColorBreak> legendBreaks, String title, String xLabel, String yLabel, ChartPlotMethod method, PlotOrientation orientation, boolean yInverse, boolean xInverse, boolean isTime, boolean drawLegend) {
        XY1DPlot plot = new XY1DPlot(isTime, orientation, dataset);
        if (title != null) {
            plot.setTitle(title);
        }
        plot.setChartPlotMethod(method);
        plot.getAxis(Location.TOP).setVisible(false);
        plot.getAxis(Location.RIGHT).setVisible(false);
        plot.setDrawLegend(drawLegend);
        plot.getGridLine().setDrawXLine(true);
        plot.getGridLine().setDrawYLine(true);
        plot.getXAxis().setInverse(xInverse);
        plot.getYAxis().setInverse(yInverse);
        plot.getXAxis().setInsideTick(false);
        plot.getYAxis().setInsideTick(false);
        plot.getXAxis().setDrawLabel(true);
        plot.getYAxis().setDrawLabel(true);
        if (orientation == PlotOrientation.VERTICAL) {
            plot.getXAxis().setLabel(xLabel);
            plot.getYAxis().setLabel(yLabel);
        } else {
            plot.getXAxis().setLabel(yLabel);
            plot.getYAxis().setLabel(xLabel);
        }
        if (legendBreaks != null) {
            block6: for (int i = 0; i < dataset.getSeriesCount(); ++i) {
                String caption = dataset.getSeriesKey(i);
                PolylineBreak plb = (PolylineBreak)legendBreaks.get(i);
                plb.setCaption(caption);
                switch (method) {
                    case LINE: {
                        plb.setDrawSymbol(false);
                        plot.setLegendBreak(i, (ColorBreak)plb);
                        continue block6;
                    }
                    case LINE_POINT: {
                        plb.setDrawSymbol(true);
                        plot.setLegendBreak(i, (ColorBreak)plb);
                        continue block6;
                    }
                    case POINT: {
                        PointBreak pb = new PointBreak();
                        pb.setColor(plb.getSymbolColor());
                        pb.setSize(plb.getSymbolSize());
                        pb.setStyle(plb.getSymbolStyle());
                        pb.setCaption(caption);
                        plot.setLegendBreak(i, (ColorBreak)pb);
                        continue block6;
                    }
                    case BAR: {
                        PolygonBreak pgb = new PolygonBreak();
                        pgb.setColor(plb.getColor());
                        pgb.setCaption(caption);
                        plot.setLegendBreak(i, (ColorBreak)pgb);
                    }
                }
            }
        }
        Chart chart = new Chart((Plot)plot);
        this._chartPanel.setChart(chart);
        this._chartPanel.paintGraphics();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmOneDim.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmOneDim.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmOneDim.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmOneDim.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FrmOneDim(null, null).setVisible(true);
            }
        });
    }
}

