/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.Angle;
import org.locationtech.jts.geom.Coordinate;

public class AngleTest
extends TestCase {
    private static final double TOLERANCE = 1.0E-5;

    public static void main(String[] args) {
        TestRunner.run(AngleTest.class);
    }

    public AngleTest(String name) {
        super(name);
    }

    public void testAngle() throws Exception {
        AngleTest.assertEquals((double)Angle.angle((Coordinate)new Coordinate(10.0, 0.0)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle((Coordinate)new Coordinate(10.0, 10.0)), (double)0.7853981633974483, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle((Coordinate)new Coordinate(0.0, 10.0)), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle((Coordinate)new Coordinate(-10.0, 10.0)), (double)2.356194490192345, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle((Coordinate)new Coordinate(-10.0, 0.0)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle((Coordinate)new Coordinate(-10.0, -0.1)), (double)-3.131592986903128, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.angle((Coordinate)new Coordinate(-10.0, -10.0)), (double)-2.356194490192345, (double)1.0E-5);
    }

    public void testIsAcute() throws Exception {
        AngleTest.assertEquals((boolean)Angle.isAcute((Coordinate)new Coordinate(10.0, 0.0), (Coordinate)new Coordinate(0.0, 0.0), (Coordinate)new Coordinate(5.0, 10.0)), (boolean)true);
        AngleTest.assertEquals((boolean)Angle.isAcute((Coordinate)new Coordinate(10.0, 0.0), (Coordinate)new Coordinate(0.0, 0.0), (Coordinate)new Coordinate(5.0, -10.0)), (boolean)true);
        AngleTest.assertEquals((boolean)Angle.isAcute((Coordinate)new Coordinate(10.0, 0.0), (Coordinate)new Coordinate(0.0, 0.0), (Coordinate)new Coordinate(10.0, 0.0)), (boolean)true);
        AngleTest.assertEquals((boolean)Angle.isAcute((Coordinate)new Coordinate(10.0, 0.0), (Coordinate)new Coordinate(0.0, 0.0), (Coordinate)new Coordinate(-5.0, 10.0)), (boolean)false);
        AngleTest.assertEquals((boolean)Angle.isAcute((Coordinate)new Coordinate(10.0, 0.0), (Coordinate)new Coordinate(0.0, 0.0), (Coordinate)new Coordinate(-5.0, -10.0)), (boolean)false);
    }

    public void testNormalizePositive() throws Exception {
        AngleTest.assertEquals((double)Angle.normalizePositive((double)0.0), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)-1.5707963267948966), (double)4.71238898038469, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)(-Math.PI)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)-4.71238898038469), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)(Math.PI * -2)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)-7.853981633974483), (double)4.71238898038469, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)(Math.PI * -3)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)(Math.PI * -4)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)1.5707963267948966), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)Math.PI), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)4.71238898038469), (double)4.71238898038469, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)(Math.PI * 2)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)7.853981633974483), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)(Math.PI * 3)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalizePositive((double)(Math.PI * 4)), (double)0.0, (double)1.0E-5);
    }

    public void testNormalize() throws Exception {
        AngleTest.assertEquals((double)Angle.normalize((double)0.0), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)-1.5707963267948966), (double)-1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)(-Math.PI)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)-4.71238898038469), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)(Math.PI * -2)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)-7.853981633974483), (double)-1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)(Math.PI * -3)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)(Math.PI * -4)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)1.5707963267948966), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)Math.PI), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)4.71238898038469), (double)-1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)(Math.PI * 2)), (double)0.0, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)7.853981633974483), (double)1.5707963267948966, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)(Math.PI * 3)), (double)Math.PI, (double)1.0E-5);
        AngleTest.assertEquals((double)Angle.normalize((double)(Math.PI * 4)), (double)0.0, (double)1.0E-5);
    }
}

