/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.Area;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LinearRing;
import test.jts.GeometryTestCase;

public class AreaTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(AreaTest.class);
    }

    public AreaTest(String name) {
        super(name);
    }

    public void testArea() {
        this.checkAreaOfRing("LINEARRING (100 200, 200 200, 200 100, 100 100, 100 200)", 10000.0);
    }

    public void testAreaSignedCW() {
        this.checkAreaOfRingSigned("LINEARRING (100 200, 200 200, 200 100, 100 100, 100 200)", 10000.0);
    }

    public void testAreaSignedCCW() {
        this.checkAreaOfRingSigned("LINEARRING (100 200, 100 100, 200 100, 200 200, 100 200)", -10000.0);
    }

    void checkAreaOfRing(String wkt, double expectedArea) {
        LinearRing ring = (LinearRing)this.read(wkt);
        Coordinate[] ringPts = ring.getCoordinates();
        double actual1 = Area.ofRing((Coordinate[])ringPts);
        AreaTest.assertEquals((Object)actual1, (Object)expectedArea);
        CoordinateSequence ringSeq = ring.getCoordinateSequence();
        double actual2 = Area.ofRing((CoordinateSequence)ringSeq);
        AreaTest.assertEquals((Object)actual2, (Object)expectedArea);
    }

    void checkAreaOfRingSigned(String wkt, double expectedArea) {
        LinearRing ring = (LinearRing)this.read(wkt);
        Coordinate[] ringPts = ring.getCoordinates();
        double actual1 = Area.ofRingSigned((Coordinate[])ringPts);
        AreaTest.assertEquals((Object)actual1, (Object)expectedArea);
        CoordinateSequence ringSeq = ring.getCoordinateSequence();
        double actual2 = Area.ofRingSigned((CoordinateSequence)ringSeq);
        AreaTest.assertEquals((Object)actual2, (Object)expectedArea);
    }
}

