/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTFileReader;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.util.Stopwatch;
import test.jts.TestFiles;

public class InteriorPointTest
extends TestCase {
    WKTReader rdr = new WKTReader();

    public static void main(String[] args) {
        TestRunner.run(InteriorPointTest.class);
    }

    public InteriorPointTest(String name) {
        super(name);
    }

    public void testAll() throws Exception {
        this.checkInteriorPointFile(TestFiles.getResourceFilePath("world.wkt"));
        this.checkInteriorPointFile(TestFiles.getResourceFilePath("africa.wkt"));
    }

    void checkInteriorPointFile(String file) throws Exception {
        WKTFileReader fileRdr = new WKTFileReader((Reader)new FileReader(file), this.rdr);
        this.checkInteriorPointFile(fileRdr);
    }

    void checkInteriorPointResource(String resource) throws Exception {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resource);
        WKTFileReader fileRdr = new WKTFileReader((Reader)new InputStreamReader(is), this.rdr);
        this.checkInteriorPointFile(fileRdr);
    }

    private void checkInteriorPointFile(WKTFileReader fileRdr) throws IOException, ParseException {
        List polys = fileRdr.read();
        this.checkInteriorPoint(polys);
    }

    void checkInteriorPoint(List geoms) {
        Stopwatch sw = new Stopwatch();
        for (Geometry g : geoms) {
            this.checkInteriorPoint(g);
            System.out.print(".");
        }
    }

    private void checkInteriorPoint(Geometry g) {
        Point ip = g.getInteriorPoint();
        InteriorPointTest.assertTrue((boolean)g.contains((Geometry)ip));
    }
}

