/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class IsCCWTest
extends TestCase {
    private WKTReader reader = new WKTReader();

    public static void main(String[] args) {
        TestRunner.run(IsCCWTest.class);
    }

    public IsCCWTest(String name) {
        super(name);
    }

    public void testCCW() throws Exception {
        Coordinate[] pts = this.getCoordinates("POLYGON ((60 180, 140 240, 140 240, 140 240, 200 180, 120 120, 60 180))");
        IsCCWTest.assertEquals((boolean)false, (boolean)Orientation.isCCW((Coordinate[])pts));
        CoordinateSequence seq = this.getCoordinateSequence("POLYGON ((60 180, 140 240, 140 240, 140 240, 200 180, 120 120, 60 180))");
        IsCCWTest.assertEquals((boolean)false, (boolean)Orientation.isCCW((CoordinateSequence)seq));
        Coordinate[] pts2 = this.getCoordinates("POLYGON ((60 180, 140 120, 100 180, 140 240, 60 180))");
        IsCCWTest.assertEquals((boolean)true, (boolean)Orientation.isCCW((Coordinate[])pts2));
        CoordinateSequence seq2 = this.getCoordinateSequence("POLYGON ((60 180, 140 120, 100 180, 140 240, 60 180))");
        IsCCWTest.assertEquals((boolean)true, (boolean)Orientation.isCCW((CoordinateSequence)seq2));
        Coordinate[] pts2x = this.getCoordinates("POLYGON ((60 180, 140 120, 100 180, 140 240, 140 240, 60 180))");
        IsCCWTest.assertEquals((boolean)true, (boolean)Orientation.isCCW((Coordinate[])pts2x));
        CoordinateSequence seq2x = this.getCoordinateSequence("POLYGON ((60 180, 140 120, 100 180, 140 240, 140 240, 60 180))");
        IsCCWTest.assertEquals((boolean)true, (boolean)Orientation.isCCW((CoordinateSequence)seq2x));
    }

    private Coordinate[] getCoordinates(String wkt) throws ParseException {
        Geometry geom = this.reader.read(wkt);
        return geom.getCoordinates();
    }

    private CoordinateSequence getCoordinateSequence(String wkt) throws ParseException {
        Geometry geom = this.reader.read(wkt);
        if (geom.getGeometryType() != "Polygon") {
            throw new IllegalArgumentException("wkt");
        }
        Polygon poly = (Polygon)geom;
        return ((Polygon)geom).getExteriorRing().getCoordinateSequence();
    }
}

