/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;
import test.jts.GeometryTestCase;

public class PointLocationOnLineTest
extends GeometryTestCase {
    public static void main(String[] args) {
        TestRunner.run(PointLocationOnLineTest.class);
    }

    public PointLocationOnLineTest(String name) {
        super(name);
    }

    public void testOnVertex() throws Exception {
        this.checkOnLine(20.0, 20.0, "LINESTRING (0 00, 20 20, 30 30)", true);
    }

    public void testOnSegment() throws Exception {
        this.checkOnLine(10.0, 10.0, "LINESTRING (0 0, 20 20, 0 40)", true);
        this.checkOnLine(10.0, 30.0, "LINESTRING (0 0, 20 20, 0 40)", true);
    }

    public void testNotOnLine() throws Exception {
        this.checkOnLine(0.0, 100.0, "LINESTRING (10 10, 20 10, 30 10)", false);
    }

    void checkOnLine(double x, double y, String wktLine, boolean expected) {
        LineString line = (LineString)this.read(wktLine);
        PointLocationOnLineTest.assertTrue((expected == PointLocation.isOnLine((Coordinate)new Coordinate(x, y), (Coordinate[])line.getCoordinates()) ? 1 : 0) != 0);
        PointLocationOnLineTest.assertTrue((expected == PointLocation.isOnLine((Coordinate)new Coordinate(x, y), (CoordinateSequence)line.getCoordinateSequence()) ? 1 : 0) != 0);
    }
}

