/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class RobustLineIntersectorTest
extends TestCase {
    RobustLineIntersector i = new RobustLineIntersector();

    public RobustLineIntersectorTest(String Name_) {
        super(Name_);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{RobustLineIntersectorTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public void test2Lines() {
        RobustLineIntersector i = new RobustLineIntersector();
        Coordinate p1 = new Coordinate(10.0, 10.0);
        Coordinate p2 = new Coordinate(20.0, 20.0);
        Coordinate q1 = new Coordinate(20.0, 10.0);
        Coordinate q2 = new Coordinate(10.0, 20.0);
        Coordinate x = new Coordinate(15.0, 15.0);
        i.computeIntersection(p1, p2, q1, q2);
        RobustLineIntersectorTest.assertEquals((int)1, (int)i.getIntersectionNum());
        RobustLineIntersectorTest.assertEquals((int)1, (int)i.getIntersectionNum());
        RobustLineIntersectorTest.assertEquals((Object)x, (Object)i.getIntersection(0));
        RobustLineIntersectorTest.assertTrue((boolean)i.isProper());
        RobustLineIntersectorTest.assertTrue((boolean)i.hasIntersection());
    }

    public void testCollinear1() {
        RobustLineIntersector i = new RobustLineIntersector();
        Coordinate p1 = new Coordinate(10.0, 10.0);
        Coordinate p2 = new Coordinate(20.0, 10.0);
        Coordinate q1 = new Coordinate(22.0, 10.0);
        Coordinate q2 = new Coordinate(30.0, 10.0);
        i.computeIntersection(p1, p2, q1, q2);
        RobustLineIntersectorTest.assertEquals((int)0, (int)i.getIntersectionNum());
        RobustLineIntersectorTest.assertTrue((!i.isProper() ? 1 : 0) != 0);
        RobustLineIntersectorTest.assertTrue((!i.hasIntersection() ? 1 : 0) != 0);
    }

    public void testCollinear2() {
        RobustLineIntersector i = new RobustLineIntersector();
        Coordinate p1 = new Coordinate(10.0, 10.0);
        Coordinate p2 = new Coordinate(20.0, 10.0);
        Coordinate q1 = new Coordinate(20.0, 10.0);
        Coordinate q2 = new Coordinate(30.0, 10.0);
        i.computeIntersection(p1, p2, q1, q2);
        RobustLineIntersectorTest.assertEquals((int)1, (int)i.getIntersectionNum());
        RobustLineIntersectorTest.assertTrue((!i.isProper() ? 1 : 0) != 0);
        RobustLineIntersectorTest.assertTrue((boolean)i.hasIntersection());
    }

    public void testCollinear3() {
        RobustLineIntersector i = new RobustLineIntersector();
        Coordinate p1 = new Coordinate(10.0, 10.0);
        Coordinate p2 = new Coordinate(20.0, 10.0);
        Coordinate q1 = new Coordinate(15.0, 10.0);
        Coordinate q2 = new Coordinate(30.0, 10.0);
        i.computeIntersection(p1, p2, q1, q2);
        RobustLineIntersectorTest.assertEquals((int)2, (int)i.getIntersectionNum());
        RobustLineIntersectorTest.assertTrue((!i.isProper() ? 1 : 0) != 0);
        RobustLineIntersectorTest.assertTrue((boolean)i.hasIntersection());
    }

    public void testCollinear4() {
        RobustLineIntersector i = new RobustLineIntersector();
        Coordinate p1 = new Coordinate(30.0, 10.0);
        Coordinate p2 = new Coordinate(20.0, 10.0);
        Coordinate q1 = new Coordinate(10.0, 10.0);
        Coordinate q2 = new Coordinate(30.0, 10.0);
        i.computeIntersection(p1, p2, q1, q2);
        RobustLineIntersectorTest.assertEquals((int)2, (int)i.getIntersectionNum());
        RobustLineIntersectorTest.assertTrue((boolean)i.hasIntersection());
    }

    public void testEndpointIntersection() {
        this.i.computeIntersection(new Coordinate(100.0, 100.0), new Coordinate(10.0, 100.0), new Coordinate(100.0, 10.0), new Coordinate(100.0, 100.0));
        RobustLineIntersectorTest.assertTrue((boolean)this.i.hasIntersection());
        RobustLineIntersectorTest.assertEquals((int)1, (int)this.i.getIntersectionNum());
    }

    public void testEndpointIntersection2() {
        this.i.computeIntersection(new Coordinate(190.0, 50.0), new Coordinate(120.0, 100.0), new Coordinate(120.0, 100.0), new Coordinate(50.0, 150.0));
        RobustLineIntersectorTest.assertTrue((boolean)this.i.hasIntersection());
        RobustLineIntersectorTest.assertEquals((int)1, (int)this.i.getIntersectionNum());
        RobustLineIntersectorTest.assertEquals((Object)new Coordinate(120.0, 100.0), (Object)this.i.getIntersection(1));
    }

    public void testOverlap() {
        this.i.computeIntersection(new Coordinate(180.0, 200.0), new Coordinate(160.0, 180.0), new Coordinate(220.0, 240.0), new Coordinate(140.0, 160.0));
        RobustLineIntersectorTest.assertTrue((boolean)this.i.hasIntersection());
        RobustLineIntersectorTest.assertEquals((int)2, (int)this.i.getIntersectionNum());
    }

    public void testIsProper1() {
        this.i.computeIntersection(new Coordinate(30.0, 10.0), new Coordinate(30.0, 30.0), new Coordinate(10.0, 10.0), new Coordinate(90.0, 11.0));
        RobustLineIntersectorTest.assertTrue((boolean)this.i.hasIntersection());
        RobustLineIntersectorTest.assertEquals((int)1, (int)this.i.getIntersectionNum());
        RobustLineIntersectorTest.assertTrue((boolean)this.i.isProper());
    }

    public void testIsProper2() {
        this.i.computeIntersection(new Coordinate(10.0, 30.0), new Coordinate(10.0, 0.0), new Coordinate(11.0, 90.0), new Coordinate(10.0, 10.0));
        RobustLineIntersectorTest.assertTrue((boolean)this.i.hasIntersection());
        RobustLineIntersectorTest.assertEquals((int)1, (int)this.i.getIntersectionNum());
        RobustLineIntersectorTest.assertTrue((!this.i.isProper() ? 1 : 0) != 0);
    }

    public void testIsCCW() {
        RobustLineIntersectorTest.assertEquals((int)1, (int)Orientation.index((Coordinate)new Coordinate(-1.23456789E8, -40.0), (Coordinate)new Coordinate(0.0, 0.0), (Coordinate)new Coordinate(3.81039468754763E14, 1.23456789E8)));
    }

    public void testIsCCW2() {
        RobustLineIntersectorTest.assertEquals((int)0, (int)Orientation.index((Coordinate)new Coordinate(10.0, 10.0), (Coordinate)new Coordinate(20.0, 20.0), (Coordinate)new Coordinate(0.0, 0.0)));
    }

    public void testA() {
        Coordinate p1 = new Coordinate(-1.23456789E8, -40.0);
        Coordinate p2 = new Coordinate(3.81039468754763E14, 1.23456789E8);
        Coordinate q = new Coordinate(0.0, 0.0);
        LineString l = new GeometryFactory().createLineString(new Coordinate[]{p1, p2});
        Point p = new GeometryFactory().createPoint(q);
        RobustLineIntersectorTest.assertEquals((boolean)false, (boolean)l.intersects((Geometry)p));
        RobustLineIntersectorTest.assertEquals((boolean)false, (boolean)PointLocation.isOnLine((Coordinate)q, (Coordinate[])new Coordinate[]{p1, p2}));
        RobustLineIntersectorTest.assertEquals((int)-1, (int)Orientation.index((Coordinate)p1, (Coordinate)p2, (Coordinate)q));
    }
}

