/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.edgegraph;

import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.edgegraph.EdgeGraph;
import org.locationtech.jts.edgegraph.EdgeGraphBuilder;
import org.locationtech.jts.edgegraph.HalfEdge;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.io.ParseException;
import test.jts.junit.GeometryUtils;

public class EdgeGraphTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(EdgeGraphTest.class);
    }

    public EdgeGraphTest(String name) {
        super(name);
    }

    public void testNode() throws Exception {
        EdgeGraph graph = this.build("MULTILINESTRING((0 0, 1 0), (0 0, 0 1), (0 0, -1 0))");
        this.checkEdgeRing(graph, new Coordinate(0.0, 0.0), new Coordinate[]{new Coordinate(1.0, 0.0), new Coordinate(0.0, 1.0), new Coordinate(-1.0, 0.0)});
        this.checkEdge(graph, new Coordinate(0.0, 0.0), new Coordinate(1.0, 0.0));
    }

    private void checkEdgeRing(EdgeGraph graph, Coordinate p, Coordinate[] dest) {
        HalfEdge e;
        HalfEdge onext = e = graph.findEdge(p, dest[0]);
        int i = 0;
        do {
            EdgeGraphTest.assertTrue((boolean)onext.dest().equals2D(dest[i++]));
        } while ((onext = onext.oNext()) != e);
    }

    private void checkEdge(EdgeGraph graph, Coordinate p0, Coordinate p1) {
        HalfEdge e = graph.findEdge(p0, p1);
        EdgeGraphTest.assertNotNull((Object)e);
    }

    private EdgeGraph build(String wkt) throws ParseException {
        return this.build(new String[]{wkt});
    }

    private EdgeGraph build(String[] wkt) throws ParseException {
        List geoms = GeometryUtils.readWKT(wkt);
        return EdgeGraphBuilder.build((Collection)geoms);
    }
}

