/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.generator;

import java.util.NoSuchElementException;
import org.locationtech.jts.generator.GeometryGenerator;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class GridGenerator
extends GeometryGenerator {
    protected int numberColumns = 1;
    protected int numberRows = 1;
    protected int index = 0;

    public GridGenerator() {
        this.dimensions = 2;
    }

    @Override
    public Geometry create() {
        return this.geometryFactory.toGeometry(this.createEnv());
    }

    public Envelope createEnv() {
        if (!this.canCreate()) {
            throw new NoSuchElementException("There are not any grids left to create.");
        }
        if (this.geometryFactory == null) {
            throw new NullPointerException("GeometryFactory is not declared");
        }
        if (this.boundingBox == null || this.boundingBox.isNull()) {
            throw new NullPointerException("Bounding Box is not declared");
        }
        double x = this.boundingBox.getMinX();
        double dx = this.boundingBox.getMaxX() - x;
        double y = this.boundingBox.getMinY();
        double dy = this.boundingBox.getMaxY() - y;
        int row = this.numberRows == 1 ? 0 : this.index / this.numberRows;
        int col = this.numberColumns == 1 ? 0 : this.index % this.numberColumns;
        double sx = dx / (double)this.numberColumns;
        double sy = dy / (double)this.numberRows;
        double minx = x + (double)col * sx;
        double miny = y + (double)row * sy;
        Envelope box = new Envelope(this.geometryFactory.getPrecisionModel().makePrecise(minx), this.geometryFactory.getPrecisionModel().makePrecise(minx + sx), this.geometryFactory.getPrecisionModel().makePrecise(miny), this.geometryFactory.getPrecisionModel().makePrecise(miny + sy));
        ++this.index;
        return box;
    }

    public boolean canCreate() {
        return this.numberColumns * this.numberRows > this.index;
    }

    public void reset() {
        this.index = 0;
    }

    @Override
    public void setDimensions(int dimensions) {
        if (dimensions != 2) {
            throw new IllegalStateException("MAY NOT CHANGE GridGenerator's Dimensions");
        }
    }

    public int getNumberColumns() {
        return this.numberColumns;
    }

    public void setNumberColumns(int numberColumns) {
        if (numberColumns <= 0) {
            throw new IndexOutOfBoundsException("Index sizes must be positive, non zero");
        }
        this.numberColumns = numberColumns;
    }

    public int getNumberRows() {
        return this.numberRows;
    }

    public void setNumberRows(int numberRows) {
        if (numberRows <= 0) {
            throw new IndexOutOfBoundsException("Index sizes must be positive, non zero");
        }
        this.numberRows = numberRows;
    }
}

