/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;

public class CoordinateArraysTest
extends TestCase {
    private static Coordinate[] COORDS_1 = new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0), new Coordinate(3.0, 3.0)};
    private static Coordinate[] COORDS_EMPTY = new Coordinate[0];

    public static void main(String[] args) {
        TestRunner.run(CoordinateArraysTest.class);
    }

    public CoordinateArraysTest(String name) {
        super(name);
    }

    public void testPtNotInList1() {
        CoordinateArraysTest.assertTrue((boolean)CoordinateArrays.ptNotInList((Coordinate[])new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0), new Coordinate(3.0, 3.0)}, (Coordinate[])new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(1.0, 2.0), new Coordinate(1.0, 3.0)}).equals2D(new Coordinate(2.0, 2.0)));
    }

    public void testPtNotInList2() {
        CoordinateArraysTest.assertTrue((CoordinateArrays.ptNotInList((Coordinate[])new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0), new Coordinate(3.0, 3.0)}, (Coordinate[])new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0), new Coordinate(3.0, 3.0)}) == null ? 1 : 0) != 0);
    }

    public void testEnvelope1() {
        CoordinateArraysTest.assertEquals((Object)CoordinateArrays.envelope((Coordinate[])COORDS_1), (Object)new Envelope(1.0, 3.0, 1.0, 3.0));
    }

    public void testEnvelopeEmpty() {
        CoordinateArraysTest.assertEquals((Object)CoordinateArrays.envelope((Coordinate[])COORDS_EMPTY), (Object)new Envelope());
    }

    public void testIntersection_envelope1() {
        CoordinateArraysTest.assertTrue((boolean)CoordinateArrays.equals((Coordinate[])CoordinateArrays.intersection((Coordinate[])COORDS_1, (Envelope)new Envelope(1.0, 2.0, 1.0, 2.0)), (Coordinate[])new Coordinate[]{new Coordinate(1.0, 1.0), new Coordinate(2.0, 2.0)}));
    }

    public void testIntersection_envelopeDisjoint() {
        CoordinateArraysTest.assertTrue((boolean)CoordinateArrays.equals((Coordinate[])CoordinateArrays.intersection((Coordinate[])COORDS_1, (Envelope)new Envelope(10.0, 20.0, 10.0, 20.0)), (Coordinate[])COORDS_EMPTY));
    }

    public void testIntersection_empty_envelope() {
        CoordinateArraysTest.assertTrue((boolean)CoordinateArrays.equals((Coordinate[])CoordinateArrays.intersection((Coordinate[])COORDS_EMPTY, (Envelope)new Envelope(1.0, 2.0, 1.0, 2.0)), (Coordinate[])COORDS_EMPTY));
    }

    public void testIntersection_coords_emptyEnvelope() {
        CoordinateArraysTest.assertTrue((boolean)CoordinateArrays.equals((Coordinate[])CoordinateArrays.intersection((Coordinate[])COORDS_1, (Envelope)new Envelope()), (Coordinate[])COORDS_EMPTY));
    }
}

