/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;

public class CoordinateTest
extends TestCase {
    public CoordinateTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(CoordinateTest.class);
    }

    public void testConstructor3D() {
        Coordinate c = new Coordinate(350.2, 4566.8, 5266.3);
        CoordinateTest.assertEquals((Object)c.x, (Object)350.2);
        CoordinateTest.assertEquals((Object)c.y, (Object)4566.8);
        CoordinateTest.assertEquals((Object)c.z, (Object)5266.3);
    }

    public void testConstructor2D() {
        Coordinate c = new Coordinate(350.2, 4566.8);
        CoordinateTest.assertEquals((Object)c.x, (Object)350.2);
        CoordinateTest.assertEquals((Object)c.y, (Object)4566.8);
        CoordinateTest.assertEquals((Object)c.z, (Object)Double.NaN);
    }

    public void testDefaultConstructor() {
        Coordinate c = new Coordinate();
        CoordinateTest.assertEquals((Object)c.x, (Object)0.0);
        CoordinateTest.assertEquals((Object)c.y, (Object)0.0);
        CoordinateTest.assertEquals((Object)c.z, (Object)Double.NaN);
    }

    public void testCopyConstructor3D() {
        Coordinate orig = new Coordinate(350.2, 4566.8, 5266.3);
        Coordinate c = new Coordinate(orig);
        CoordinateTest.assertEquals((Object)c.x, (Object)350.2);
        CoordinateTest.assertEquals((Object)c.y, (Object)4566.8);
        CoordinateTest.assertEquals((Object)c.z, (Object)5266.3);
    }

    public void testSetCoordinate() {
        Coordinate orig = new Coordinate(350.2, 4566.8, 5266.3);
        Coordinate c = new Coordinate();
        c.setCoordinate(orig);
        CoordinateTest.assertEquals((Object)c.x, (Object)350.2);
        CoordinateTest.assertEquals((Object)c.y, (Object)4566.8);
        CoordinateTest.assertEquals((Object)c.z, (Object)5266.3);
    }

    public void testGetOrdinate() {
        Coordinate c = new Coordinate(350.2, 4566.8, 5266.3);
        CoordinateTest.assertEquals((Object)c.getOrdinate(0), (Object)350.2);
        CoordinateTest.assertEquals((Object)c.getOrdinate(1), (Object)4566.8);
        CoordinateTest.assertEquals((Object)c.getOrdinate(2), (Object)5266.3);
    }

    public void testSetOrdinate() {
        Coordinate c = new Coordinate();
        c.setOrdinate(0, 111.0);
        c.setOrdinate(1, 222.0);
        c.setOrdinate(2, 333.0);
        CoordinateTest.assertEquals((Object)c.getOrdinate(0), (Object)111.0);
        CoordinateTest.assertEquals((Object)c.getOrdinate(1), (Object)222.0);
        CoordinateTest.assertEquals((Object)c.getOrdinate(2), (Object)333.0);
    }

    public void testEquals() {
        Coordinate c1 = new Coordinate(1.0, 2.0, 3.0);
        String s = "Not a coordinate";
        CoordinateTest.assertTrue((!c1.equals((Object)s) ? 1 : 0) != 0);
        Coordinate c2 = new Coordinate(1.0, 2.0, 3.0);
        CoordinateTest.assertTrue((boolean)c1.equals2D(c2));
        Coordinate c3 = new Coordinate(1.0, 22.0, 3.0);
        CoordinateTest.assertTrue((!c1.equals2D(c3) ? 1 : 0) != 0);
    }

    public void testEquals2D() {
        Coordinate c1 = new Coordinate(1.0, 2.0, 3.0);
        Coordinate c2 = new Coordinate(1.0, 2.0, 3.0);
        CoordinateTest.assertTrue((boolean)c1.equals2D(c2));
        Coordinate c3 = new Coordinate(1.0, 22.0, 3.0);
        CoordinateTest.assertTrue((!c1.equals2D(c3) ? 1 : 0) != 0);
    }

    public void testEquals3D() {
        Coordinate c1 = new Coordinate(1.0, 2.0, 3.0);
        Coordinate c2 = new Coordinate(1.0, 2.0, 3.0);
        CoordinateTest.assertTrue((boolean)c1.equals3D(c2));
        Coordinate c3 = new Coordinate(1.0, 22.0, 3.0);
        CoordinateTest.assertTrue((!c1.equals3D(c3) ? 1 : 0) != 0);
    }

    public void testEquals2DWithinTolerance() {
        Coordinate c = new Coordinate(100.0, 200.0, 50.0);
        Coordinate aBitOff = new Coordinate(100.1, 200.1, 50.0);
        CoordinateTest.assertTrue((boolean)c.equals2D(aBitOff, 0.2));
    }

    public void testEqualsInZ() {
        Coordinate c = new Coordinate(100.0, 200.0, 50.0);
        Coordinate withSameZ = new Coordinate(100.1, 200.1, 50.1);
        CoordinateTest.assertTrue((boolean)c.equalInZ(withSameZ, 0.2));
    }

    public void testCompareTo() {
        Coordinate lowest = new Coordinate(10.0, 100.0, 50.0);
        Coordinate highest = new Coordinate(20.0, 100.0, 50.0);
        Coordinate equalToHighest = new Coordinate(20.0, 100.0, 50.0);
        Coordinate higherStill = new Coordinate(20.0, 200.0, 50.0);
        CoordinateTest.assertEquals((int)-1, (int)lowest.compareTo(highest));
        CoordinateTest.assertEquals((int)1, (int)highest.compareTo(lowest));
        CoordinateTest.assertEquals((int)-1, (int)highest.compareTo(higherStill));
        CoordinateTest.assertEquals((int)0, (int)highest.compareTo(equalToHighest));
    }

    public void testToString() {
        String expectedResult = "(100.0, 200.0, 50.0)";
        String actualResult = new Coordinate(100.0, 200.0, 50.0).toString();
        CoordinateTest.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    public void testClone() {
        Coordinate c = new Coordinate(100.0, 200.0, 50.0);
        Coordinate clone = (Coordinate)c.clone();
        CoordinateTest.assertTrue((boolean)c.equals3D(clone));
    }

    public void testDistance() {
        Coordinate coord1 = new Coordinate(0.0, 0.0, 0.0);
        Coordinate coord2 = new Coordinate(100.0, 200.0, 50.0);
        double distance = coord1.distance(coord2);
        CoordinateTest.assertEquals((double)distance, (double)223.60679774997897, (double)1.0E-5);
    }

    public void testDistance3D() {
        Coordinate coord1 = new Coordinate(0.0, 0.0, 0.0);
        Coordinate coord2 = new Coordinate(100.0, 200.0, 50.0);
        double distance = coord1.distance3D(coord2);
        CoordinateTest.assertEquals((double)distance, (double)229.128784747792, (double)1.0E-6);
    }
}

