/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class GeometryImplTest
extends TestCase {
    PrecisionModel precisionModel = new PrecisionModel(1.0);
    GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);
    WKTReader readerFloat = new WKTReader();

    public GeometryImplTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(GeometryImplTest.class);
    }

    public void testComparable() throws Exception {
        Geometry point = this.reader.read("POINT EMPTY");
        Geometry lineString = this.reader.read("LINESTRING EMPTY");
        Geometry linearRing = this.reader.read("LINEARRING EMPTY");
        Geometry polygon = this.reader.read("POLYGON EMPTY");
        Geometry mpoint = this.reader.read("MULTIPOINT EMPTY");
        Geometry mlineString = this.reader.read("MULTILINESTRING EMPTY");
        Geometry mpolygon = this.reader.read("MULTIPOLYGON EMPTY");
        Geometry gc = this.reader.read("GEOMETRYCOLLECTION EMPTY");
        Object[] geometries = new Geometry[]{gc, mpolygon, mlineString, mpoint, polygon, linearRing, lineString, point};
        Object[] geometriesExpectedOrder = new Geometry[]{point, mpoint, lineString, linearRing, mlineString, polygon, mpolygon, gc};
        Arrays.sort(geometries);
        GeometryImplTest.assertTrue((boolean)Arrays.equals(geometries, geometriesExpectedOrder));
    }

    public void testPolygonRelate() throws Exception {
        Geometry bigPolygon = this.reader.read("POLYGON ((0 0, 0 50, 50 50, 50 0, 0 0))");
        Geometry smallPolygon = this.reader.read("POLYGON ((10 10, 10 30, 30 30, 30 10, 10 10))");
        GeometryImplTest.assertTrue((boolean)bigPolygon.contains(smallPolygon));
    }

    public void testEmptyGeometryCentroid() throws Exception {
        GeometryImplTest.assertTrue((boolean)this.reader.read("POINT EMPTY").getCentroid().isEmpty());
        GeometryImplTest.assertTrue((boolean)this.reader.read("POLYGON EMPTY").getCentroid().isEmpty());
        GeometryImplTest.assertTrue((boolean)this.reader.read("LINESTRING EMPTY").getCentroid().isEmpty());
        GeometryImplTest.assertTrue((boolean)this.reader.read("GEOMETRYCOLLECTION EMPTY").getCentroid().isEmpty());
        GeometryImplTest.assertTrue((boolean)this.reader.read("GEOMETRYCOLLECTION(GEOMETRYCOLLECTION EMPTY, GEOMETRYCOLLECTION EMPTY)").getCentroid().isEmpty());
        GeometryImplTest.assertTrue((boolean)this.reader.read("MULTIPOLYGON EMPTY").getCentroid().isEmpty());
        GeometryImplTest.assertTrue((boolean)this.reader.read("MULTILINESTRING EMPTY").getCentroid().isEmpty());
        GeometryImplTest.assertTrue((boolean)this.reader.read("MULTIPOINT EMPTY").getCentroid().isEmpty());
    }

    public void testNoOutgoingDirEdgeFound() throws Exception {
        this.doTestFromCommcast2003AtYahooDotCa(this.reader);
    }

    public void testOutOfMemoryError() throws Exception {
        this.doTestFromCommcast2003AtYahooDotCa(new WKTReader());
    }

    public void testDepthMismatchAssertionFailedException() throws Exception {
        this.reader.read("MULTIPOLYGON (((100 300, 100 400, 200 400, 200 300, 100 300)),((160 300, 160 400, 260 400, 260 300, 160 300)),((160 300, 160 200, 260 200, 260 300, 160 300)))").buffer(0.0);
    }

    private void doTestFromCommcast2003AtYahooDotCa(WKTReader reader) throws ParseException {
        this.readerFloat.read("POLYGON ((708653.498611049 2402311.54647056, 708708.895756966 2402203.47250014, 708280.326454234 2402089.6337791, 708247.896591321 2402252.48269854, 708367.379593851 2402324.00761653, 708248.882609455 2402253.07294874, 708249.523621829 2402244.3124463, 708261.854734465 2402182.39086576, 708262.818392579 2402183.35452387, 708653.498611049 2402311.54647056))").intersection(reader.read("POLYGON ((708258.754920656 2402197.91172757, 708257.029447455 2402206.56901508, 708652.961095455 2402312.65463437, 708657.068786251 2402304.6356364, 708258.754920656 2402197.91172757))"));
    }

    public void testEquals() throws Exception {
        Geometry g = this.reader.read("POLYGON ((0 0, 0 50, 50 50, 50 0, 0 0))");
        Geometry same = this.reader.read("POLYGON ((0 0, 0 50, 50 50, 50 0, 0 0))");
        Geometry differentStart = this.reader.read("POLYGON ((0 50, 50 50, 50 0, 0 0, 0 50))");
        Geometry differentFourth = this.reader.read("POLYGON ((0 0, 0 50, 50 50, 50 -99, 0 0))");
        Geometry differentSecond = this.reader.read("POLYGON ((0 0, 0 99, 50 50, 50 0, 0 0))");
        this.doTestEquals(g, same, true, true, true, true);
        this.doTestEquals(g, differentStart, true, false, false, true);
        this.doTestEquals(g, differentFourth, false, false, false, false);
        this.doTestEquals(g, differentSecond, false, false, false, false);
    }

    private void doTestEquals(Geometry a, Geometry b, boolean equalsGeometry, boolean equalsObject, boolean equalsExact, boolean equalsHash) {
        GeometryImplTest.assertEquals((boolean)equalsGeometry, (boolean)a.equals(b));
        GeometryImplTest.assertEquals((boolean)equalsObject, (boolean)a.equals((Object)b));
        GeometryImplTest.assertEquals((boolean)equalsExact, (boolean)a.equalsExact(b));
        GeometryImplTest.assertEquals((boolean)equalsHash, (a.hashCode() == b.hashCode() ? 1 : 0) != 0);
    }

    public void testInvalidateEnvelope() throws Exception {
        Geometry g = this.reader.read("POLYGON ((0 0, 0 50, 50 50, 50 0, 0 0))");
        GeometryImplTest.assertEquals((Object)new Envelope(0.0, 50.0, 0.0, 50.0), (Object)g.getEnvelopeInternal());
        g.apply(new CoordinateFilter(){

            public void filter(Coordinate coord) {
                coord.x += 1.0;
                coord.y += 1.0;
            }
        });
        GeometryImplTest.assertEquals((Object)new Envelope(0.0, 50.0, 0.0, 50.0), (Object)g.getEnvelopeInternal());
        g.geometryChanged();
        GeometryImplTest.assertEquals((Object)new Envelope(1.0, 51.0, 1.0, 51.0), (Object)g.getEnvelopeInternal());
    }

    public void testEquals1() throws Exception {
        Geometry polygon1 = this.reader.read("POLYGON ((0 0, 0 50, 50 50, 50 0, 0 0))");
        Geometry polygon2 = this.reader.read("POLYGON ((50 50, 50 0, 0 0, 0 50, 50 50))");
        GeometryImplTest.assertTrue((boolean)polygon1.equals(polygon2));
    }

    public void testEqualsWithNull() throws Exception {
        Geometry polygon = this.reader.read("POLYGON ((0 0, 0 50, 50 50, 50 0, 0 0))");
        GeometryImplTest.assertTrue((!polygon.equals(null) ? 1 : 0) != 0);
        Object g = null;
        GeometryImplTest.assertTrue((!polygon.equals(g) ? 1 : 0) != 0);
    }

    public void testEqualsExactForLinearRings() throws Exception {
        LinearRing x = this.geometryFactory.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(100.0, 0.0), new Coordinate(100.0, 100.0), new Coordinate(0.0, 0.0)});
        LinearRing somethingExactlyEqual = this.geometryFactory.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(100.0, 0.0), new Coordinate(100.0, 100.0), new Coordinate(0.0, 0.0)});
        LinearRing somethingNotEqualButSameClass = this.geometryFactory.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(100.0, 0.0), new Coordinate(100.0, 555.0), new Coordinate(0.0, 0.0)});
        LinearRing sameClassButEmpty = this.geometryFactory.createLinearRing((CoordinateSequence)null);
        LinearRing anotherSameClassButEmpty = this.geometryFactory.createLinearRing((CoordinateSequence)null);
        CollectionFactory collectionFactory = new CollectionFactory(){

            @Override
            public Geometry createCollection(Geometry[] geometries) {
                return GeometryImplTest.this.geometryFactory.createMultiLineString(GeometryFactory.toLineStringArray(Arrays.asList(geometries)));
            }
        };
        this.doTestEqualsExact((Geometry)x, (Geometry)somethingExactlyEqual, (Geometry)somethingNotEqualButSameClass, (Geometry)sameClassButEmpty, (Geometry)anotherSameClassButEmpty, collectionFactory);
    }

    public void testEqualsExactForLineStrings() throws Exception {
        LineString x = this.geometryFactory.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(100.0, 0.0), new Coordinate(100.0, 100.0)});
        LineString somethingExactlyEqual = this.geometryFactory.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(100.0, 0.0), new Coordinate(100.0, 100.0)});
        LineString somethingNotEqualButSameClass = this.geometryFactory.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(100.0, 0.0), new Coordinate(100.0, 555.0)});
        LineString sameClassButEmpty = this.geometryFactory.createLineString((Coordinate[])null);
        LineString anotherSameClassButEmpty = this.geometryFactory.createLineString((Coordinate[])null);
        CollectionFactory collectionFactory = new CollectionFactory(){

            @Override
            public Geometry createCollection(Geometry[] geometries) {
                return GeometryImplTest.this.geometryFactory.createMultiLineString(GeometryFactory.toLineStringArray(Arrays.asList(geometries)));
            }
        };
        this.doTestEqualsExact((Geometry)x, (Geometry)somethingExactlyEqual, (Geometry)somethingNotEqualButSameClass, (Geometry)sameClassButEmpty, (Geometry)anotherSameClassButEmpty, collectionFactory);
        CollectionFactory collectionFactory2 = new CollectionFactory(){

            @Override
            public Geometry createCollection(Geometry[] geometries) {
                return GeometryImplTest.this.geometryFactory.createMultiLineString(GeometryFactory.toLineStringArray(Arrays.asList(geometries)));
            }
        };
        this.doTestEqualsExact((Geometry)x, (Geometry)somethingExactlyEqual, (Geometry)somethingNotEqualButSameClass, (Geometry)sameClassButEmpty, (Geometry)anotherSameClassButEmpty, collectionFactory2);
    }

    public void testEqualsExactForPoints() throws Exception {
        Point x = this.geometryFactory.createPoint(new Coordinate(100.0, 100.0));
        Point somethingExactlyEqual = this.geometryFactory.createPoint(new Coordinate(100.0, 100.0));
        Point somethingNotEqualButSameClass = this.geometryFactory.createPoint(new Coordinate(999.0, 100.0));
        Point sameClassButEmpty = this.geometryFactory.createPoint((Coordinate)null);
        Point anotherSameClassButEmpty = this.geometryFactory.createPoint((Coordinate)null);
        CollectionFactory collectionFactory = new CollectionFactory(){

            @Override
            public Geometry createCollection(Geometry[] geometries) {
                return GeometryImplTest.this.geometryFactory.createMultiPoint(GeometryFactory.toPointArray(Arrays.asList(geometries)));
            }
        };
        this.doTestEqualsExact((Geometry)x, (Geometry)somethingExactlyEqual, (Geometry)somethingNotEqualButSameClass, (Geometry)sameClassButEmpty, (Geometry)anotherSameClassButEmpty, collectionFactory);
    }

    public void testEqualsExactForPolygons() throws Exception {
        Polygon x = (Polygon)this.reader.read("POLYGON ((0 0, 0 50, 50 50, 50 0, 0 0))");
        Polygon somethingExactlyEqual = (Polygon)this.reader.read("POLYGON ((0 0, 0 50, 50 50, 50 0, 0 0))");
        Polygon somethingNotEqualButSameClass = (Polygon)this.reader.read("POLYGON ((50 50, 50 0, 0 0, 0 50, 50 50))");
        Polygon sameClassButEmpty = (Polygon)this.reader.read("POLYGON EMPTY");
        Polygon anotherSameClassButEmpty = (Polygon)this.reader.read("POLYGON EMPTY");
        CollectionFactory collectionFactory = new CollectionFactory(){

            @Override
            public Geometry createCollection(Geometry[] geometries) {
                return GeometryImplTest.this.geometryFactory.createMultiPolygon(GeometryFactory.toPolygonArray(Arrays.asList(geometries)));
            }
        };
        this.doTestEqualsExact((Geometry)x, (Geometry)somethingExactlyEqual, (Geometry)somethingNotEqualButSameClass, (Geometry)sameClassButEmpty, (Geometry)anotherSameClassButEmpty, collectionFactory);
    }

    public void testEqualsExactForGeometryCollections() throws Exception {
        Polygon polygon1 = (Polygon)this.reader.read("POLYGON ((0 0, 0 50, 50 50, 50 0, 0 0))");
        Polygon polygon2 = (Polygon)this.reader.read("POLYGON ((50 50, 50 0, 0 0, 0 50, 50 50))");
        GeometryCollection x = this.geometryFactory.createGeometryCollection(new Geometry[]{polygon1, polygon2});
        GeometryCollection somethingExactlyEqual = this.geometryFactory.createGeometryCollection(new Geometry[]{polygon1, polygon2});
        GeometryCollection somethingNotEqualButSameClass = this.geometryFactory.createGeometryCollection(new Geometry[]{polygon2});
        GeometryCollection sameClassButEmpty = this.geometryFactory.createGeometryCollection(null);
        GeometryCollection anotherSameClassButEmpty = this.geometryFactory.createGeometryCollection(null);
        CollectionFactory collectionFactory = new CollectionFactory(){

            @Override
            public Geometry createCollection(Geometry[] geometries) {
                return GeometryImplTest.this.geometryFactory.createGeometryCollection(geometries);
            }
        };
        this.doTestEqualsExact((Geometry)x, (Geometry)somethingExactlyEqual, (Geometry)somethingNotEqualButSameClass, (Geometry)sameClassButEmpty, (Geometry)anotherSameClassButEmpty, collectionFactory);
    }

    public void testGeometryCollectionIntersects1() throws Exception {
        Geometry gc0 = this.reader.read("GEOMETRYCOLLECTION ( POINT(0 0) )");
        Geometry gc1 = this.reader.read("GEOMETRYCOLLECTION ( LINESTRING(0 0, 1 1) )");
        Geometry gc2 = this.reader.read("GEOMETRYCOLLECTION ( LINESTRING(1 0, 0 1) )");
        GeometryImplTest.assertTrue((boolean)gc0.intersects(gc1));
        GeometryImplTest.assertTrue((boolean)gc1.intersects(gc2));
        GeometryImplTest.assertTrue((!gc0.intersects(gc2) ? 1 : 0) != 0);
        GeometryImplTest.assertTrue((boolean)gc1.intersects(gc0));
        GeometryImplTest.assertTrue((boolean)gc2.intersects(gc1));
        GeometryImplTest.assertTrue((!gc2.intersects(gc0) ? 1 : 0) != 0);
    }

    public void testGeometryCollectionIntersects2() throws Exception {
        Geometry gc0 = this.reader.read("POINT(0 0)");
        Geometry gc1 = this.reader.read("GEOMETRYCOLLECTION ( LINESTRING(0 0, 1 1) )");
        Geometry gc2 = this.reader.read("LINESTRING(1 0, 0 1)");
        GeometryImplTest.assertTrue((boolean)gc0.intersects(gc1));
        GeometryImplTest.assertTrue((boolean)gc1.intersects(gc2));
        GeometryImplTest.assertTrue((boolean)gc1.intersects(gc0));
        GeometryImplTest.assertTrue((boolean)gc2.intersects(gc1));
    }

    public void testGeometryCollectionIntersects3() throws Exception {
        Geometry gc0 = this.reader.read("GEOMETRYCOLLECTION ( POINT(0 0), LINESTRING(1 1, 2 2) )");
        Geometry gc1 = this.reader.read("GEOMETRYCOLLECTION ( POINT(15 15) )");
        Geometry gc2 = this.reader.read("GEOMETRYCOLLECTION ( LINESTRING(0 0, 2 0), POLYGON((10 10, 20 10, 20 20, 10 20, 10 10)))");
        GeometryImplTest.assertTrue((boolean)gc0.intersects(gc2));
        GeometryImplTest.assertTrue((!gc0.intersects(gc1) ? 1 : 0) != 0);
        GeometryImplTest.assertTrue((boolean)gc1.intersects(gc2));
        GeometryImplTest.assertTrue((boolean)gc2.intersects(gc0));
        GeometryImplTest.assertTrue((!gc1.intersects(gc0) ? 1 : 0) != 0);
        GeometryImplTest.assertTrue((boolean)gc2.intersects(gc1));
    }

    private void doTestEqualsExact(Geometry x, Geometry somethingExactlyEqual, Geometry somethingNotEqualButSameClass, Geometry sameClassButEmpty, Geometry anotherSameClassButEmpty, CollectionFactory collectionFactory) throws Exception {
        Object emptyDifferentClass = x instanceof Point ? this.geometryFactory.createGeometryCollection(null) : this.geometryFactory.createPoint((Coordinate)null);
        GeometryCollection somethingEqualButNotExactly = this.geometryFactory.createGeometryCollection(new Geometry[]{x});
        this.doTestEqualsExact(x, somethingExactlyEqual, collectionFactory.createCollection(new Geometry[]{x}), somethingNotEqualButSameClass);
        this.doTestEqualsExact(sameClassButEmpty, anotherSameClassButEmpty, (Geometry)emptyDifferentClass, x);
        this.doTestEqualsExact(x, somethingExactlyEqual, sameClassButEmpty, sameClassButEmpty);
        this.doTestEqualsExact(collectionFactory.createCollection(new Geometry[]{x, x}), collectionFactory.createCollection(new Geometry[]{x, somethingExactlyEqual}), (Geometry)somethingEqualButNotExactly, collectionFactory.createCollection(new Geometry[]{x, somethingNotEqualButSameClass}));
    }

    private void doTestEqualsExact(Geometry x, Geometry somethingExactlyEqual, Geometry somethingEqualButNotExactly, Geometry somethingNotEqualButSameClass) throws Exception {
        Geometry differentClass = x instanceof Point ? this.reader.read("POLYGON ((0 0, 0 50, 50 43949, 50 0, 0 0))") : this.reader.read("POINT ( 2351 1563 )");
        GeometryImplTest.assertTrue((boolean)x.equalsExact(x));
        GeometryImplTest.assertTrue((boolean)x.equalsExact(somethingExactlyEqual));
        GeometryImplTest.assertTrue((boolean)somethingExactlyEqual.equalsExact(x));
        GeometryImplTest.assertTrue((!x.equalsExact(somethingEqualButNotExactly) ? 1 : 0) != 0);
        GeometryImplTest.assertTrue((!somethingEqualButNotExactly.equalsExact(x) ? 1 : 0) != 0);
        GeometryImplTest.assertTrue((!x.equalsExact(somethingEqualButNotExactly) ? 1 : 0) != 0);
        GeometryImplTest.assertTrue((!somethingEqualButNotExactly.equalsExact(x) ? 1 : 0) != 0);
        GeometryImplTest.assertTrue((!x.equalsExact(differentClass) ? 1 : 0) != 0);
        GeometryImplTest.assertTrue((!differentClass.equalsExact(x) ? 1 : 0) != 0);
    }

    public static void main(String[] args) throws Exception {
        TestRunner.run((Test)GeometryImplTest.suite());
    }

    private static interface CollectionFactory {
        public Geometry createCollection(Geometry[] var1);
    }
}

