/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.io.WKTReader;

public class LineSegmentTest
extends TestCase {
    WKTReader rdr = new WKTReader();
    private static double ROOT2 = Math.sqrt(2.0);

    public static void main(String[] args) {
        TestRunner.run(LineSegmentTest.class);
    }

    public LineSegmentTest(String name) {
        super(name);
    }

    public void testProjectionFactor() {
        LineSegment seg = new LineSegment(10.0, 0.0, 10.0, 0.0);
        LineSegmentTest.assertTrue((boolean)Double.isNaN(seg.projectionFactor(new Coordinate(11.0, 0.0))));
        LineSegment seg2 = new LineSegment(10.0, 0.0, 20.0, 0.0);
        LineSegmentTest.assertTrue((seg2.projectionFactor(new Coordinate(11.0, 0.0)) == 0.1 ? 1 : 0) != 0);
    }

    public void testOffset() throws Exception {
        this.checkOffset(0.0, 0.0, 10.0, 10.0, 0.0, ROOT2, -1.0, 1.0);
        this.checkOffset(0.0, 0.0, 10.0, 10.0, 0.0, -ROOT2, 1.0, -1.0);
        this.checkOffset(0.0, 0.0, 10.0, 10.0, 1.0, ROOT2, 9.0, 11.0);
        this.checkOffset(0.0, 0.0, 10.0, 10.0, 0.5, ROOT2, 4.0, 6.0);
        this.checkOffset(0.0, 0.0, 10.0, 10.0, 0.5, -ROOT2, 6.0, 4.0);
        this.checkOffset(0.0, 0.0, 10.0, 10.0, 0.5, -ROOT2, 6.0, 4.0);
        this.checkOffset(0.0, 0.0, 10.0, 10.0, 2.0, ROOT2, 19.0, 21.0);
        this.checkOffset(0.0, 0.0, 10.0, 10.0, 2.0, -ROOT2, 21.0, 19.0);
        this.checkOffset(0.0, 0.0, 10.0, 10.0, 2.0, 5.0 * ROOT2, 15.0, 25.0);
        this.checkOffset(0.0, 0.0, 10.0, 10.0, -2.0, 5.0 * ROOT2, -25.0, -15.0);
    }

    void checkOffset(double x0, double y0, double x1, double y1, double segFrac, double offset, double expectedX, double expectedY) {
        LineSegment seg = new LineSegment(x0, y0, x1, y1);
        Coordinate p = seg.pointAlongOffset(segFrac, offset);
        LineSegmentTest.assertTrue((boolean)LineSegmentTest.equalsTolerance(new Coordinate(expectedX, expectedY), p, 1.0E-6));
    }

    public static boolean equalsTolerance(Coordinate p0, Coordinate p1, double tolerance) {
        if (Math.abs(p0.x - p1.x) > tolerance) {
            return false;
        }
        return !(Math.abs(p0.y - p1.y) > tolerance);
    }

    public void testOrientationIndexCoordinate() {
        LineSegment seg = new LineSegment(0.0, 0.0, 10.0, 10.0);
        this.checkOrientationIndex(seg, 10.0, 11.0, 1);
        this.checkOrientationIndex(seg, 10.0, 9.0, -1);
        this.checkOrientationIndex(seg, 11.0, 11.0, 0);
        this.checkOrientationIndex(seg, 11.0, 11.0000001, 1);
        this.checkOrientationIndex(seg, 11.0, 10.9999999, -1);
        this.checkOrientationIndex(seg, -2.0, -1.9999999, 1);
        this.checkOrientationIndex(seg, -2.0, -2.0000001, -1);
    }

    public void testOrientationIndexSegment() {
        LineSegment seg = new LineSegment(100.0, 100.0, 110.0, 110.0);
        this.checkOrientationIndex(seg, 100.0, 101.0, 105.0, 106.0, 1);
        this.checkOrientationIndex(seg, 100.0, 99.0, 105.0, 96.0, -1);
        this.checkOrientationIndex(seg, 200.0, 200.0, 210.0, 210.0, 0);
    }

    void checkOrientationIndex(double x0, double y0, double x1, double y1, double px, double py, int expectedOrient) {
        LineSegment seg = new LineSegment(x0, y0, x1, y1);
        this.checkOrientationIndex(seg, px, py, expectedOrient);
    }

    void checkOrientationIndex(LineSegment seg, double px, double py, int expectedOrient) {
        Coordinate p = new Coordinate(px, py);
        int orient = seg.orientationIndex(p);
        LineSegmentTest.assertTrue((orient == expectedOrient ? 1 : 0) != 0);
    }

    void checkOrientationIndex(LineSegment seg, double s0x, double s0y, double s1x, double s1y, int expectedOrient) {
        LineSegment seg2 = new LineSegment(s0x, s0y, s1x, s1y);
        int orient = seg.orientationIndex(seg2);
        LineSegmentTest.assertTrue((orient == expectedOrient ? 1 : 0) != 0);
    }
}

