/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTReader;

public class MultiPointImplTest
extends TestCase {
    PrecisionModel precisionModel = new PrecisionModel(1000.0);
    GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);

    public static void main(String[] args) {
        TestRunner.run((Test)MultiPointImplTest.suite());
    }

    public MultiPointImplTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(MultiPointImplTest.class);
    }

    public void testGetGeometryN() throws Exception {
        MultiPoint m = (MultiPoint)this.reader.read("MULTIPOINT(1.111 2.222, 3.333 4.444, 3.333 4.444)");
        Geometry g = m.getGeometryN(1);
        MultiPointImplTest.assertTrue((boolean)(g instanceof Point));
        Point p = (Point)g;
        Coordinate externalCoordinate = new Coordinate();
        Coordinate internal = p.getCoordinate();
        externalCoordinate.x = internal.x;
        externalCoordinate.y = internal.y;
        MultiPointImplTest.assertEquals((double)3.333, (double)externalCoordinate.x, (double)1.0E-10);
        MultiPointImplTest.assertEquals((double)4.444, (double)externalCoordinate.y, (double)1.0E-10);
    }

    public void testGetEnvelope() throws Exception {
        MultiPoint m = (MultiPoint)this.reader.read("MULTIPOINT(1.111 2.222, 3.333 4.444, 3.333 4.444)");
        Envelope e = m.getEnvelopeInternal();
        MultiPointImplTest.assertEquals((double)1.111, (double)e.getMinX(), (double)1.0E-10);
        MultiPointImplTest.assertEquals((double)3.333, (double)e.getMaxX(), (double)1.0E-10);
        MultiPointImplTest.assertEquals((double)2.222, (double)e.getMinY(), (double)1.0E-10);
        MultiPointImplTest.assertEquals((double)4.444, (double)e.getMaxY(), (double)1.0E-10);
    }

    public void testEquals() throws Exception {
        MultiPoint m1 = (MultiPoint)this.reader.read("MULTIPOINT(5 6, 7 8)");
        MultiPoint m2 = (MultiPoint)this.reader.read("MULTIPOINT(5 6, 7 8)");
        MultiPointImplTest.assertTrue((boolean)m1.equals((Geometry)m2));
    }
}

