/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.io.WKTReader;

public class NormalizeTest
extends TestCase {
    PrecisionModel precisionModel = new PrecisionModel(1.0);
    GeometryFactory geometryFactory = new GeometryFactory(this.precisionModel, 0);
    WKTReader reader = new WKTReader(this.geometryFactory);

    public NormalizeTest(String Name_) {
        super(Name_);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{NormalizeTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public void testNormalizePoint() throws Exception {
        Point point = (Point)this.reader.read("POINT (30 30)");
        point.normalize();
        NormalizeTest.assertEquals((Object)new Coordinate(30.0, 30.0), (Object)point.getCoordinate());
    }

    public void testNormalizeEmptyPoint() throws Exception {
        Point point = (Point)this.reader.read("POINT EMPTY");
        point.normalize();
        NormalizeTest.assertEquals(null, (Object)point.getCoordinate());
    }

    public void testComparePoint() throws Exception {
        Point p2;
        Point p1 = (Point)this.reader.read("POINT (30 30)");
        NormalizeTest.assertTrue((p1.compareTo((Object)(p2 = (Point)this.reader.read("POINT (30 40)"))) < 0 ? 1 : 0) != 0);
    }

    public void testCompareEmptyPoint() throws Exception {
        Point p2;
        Point p1 = (Point)this.reader.read("POINT (30 30)");
        NormalizeTest.assertTrue((p1.compareTo((Object)(p2 = (Point)this.reader.read("POINT EMPTY"))) > 0 ? 1 : 0) != 0);
    }

    public void testNormalizeMultiPoint() throws Exception {
        MultiPoint m = (MultiPoint)this.reader.read("MULTIPOINT(30 20, 10 10, 20 20, 30 30, 20 10)");
        m.normalize();
        MultiPoint expectedValue = (MultiPoint)this.reader.read("MULTIPOINT(10 10, 20 10, 20 20, 30 20, 30 30)");
        this.assertEqualsExact((Geometry)expectedValue, (Geometry)m);
        MultiPoint unexpectedValue = (MultiPoint)this.reader.read("MULTIPOINT(20 10, 20 20, 30 20, 30 30, 10 10)");
        NormalizeTest.assertTrue((!m.equalsExact((Geometry)unexpectedValue) ? 1 : 0) != 0);
    }

    public void testNormalizeLineString1() throws Exception {
        LineString l = (LineString)this.reader.read("LINESTRING (20 20, 160 40, 160 100, 100 120, 60 60)");
        l.normalize();
        LineString expectedValue = (LineString)this.reader.read("LINESTRING (20 20, 160 40, 160 100, 100 120, 60 60)");
        this.assertEqualsExact((Geometry)expectedValue, (Geometry)l);
    }

    public void testNormalizeLineString2() throws Exception {
        LineString l = (LineString)this.reader.read("LINESTRING (20 20, 160 40, 160 100, 100 120, 60 60)");
        l.normalize();
        LineString expectedValue = (LineString)this.reader.read("LINESTRING (20 20, 160 40, 160 100, 100 120, 60 60)");
        this.assertEqualsExact((Geometry)expectedValue, (Geometry)l);
    }

    public void testNormalizeLineString3() throws Exception {
        LineString l = (LineString)this.reader.read("LINESTRING (200 240, 140 160, 80 160, 160 80, 80 80)");
        l.normalize();
        LineString expectedValue = (LineString)this.reader.read("LINESTRING (80 80, 160 80, 80 160, 140 160, 200 240)");
        this.assertEqualsExact((Geometry)expectedValue, (Geometry)l);
    }

    public void testNormalizeLineString4() throws Exception {
        LineString l = (LineString)this.reader.read("LINESTRING (200 240, 140 160, 80 160, 160 80, 80 80)");
        l.normalize();
        LineString expectedValue = (LineString)this.reader.read("LINESTRING (80 80, 160 80, 80 160, 140 160, 200 240)");
        this.assertEqualsExact((Geometry)expectedValue, (Geometry)l);
    }

    public void testNormalizeLineString5() throws Exception {
        LineString l = (LineString)this.reader.read("LINESTRING (200 340, 140 240, 140 160, 60 240, 140 240, 200 340)");
        l.normalize();
        LineString expectedValue = (LineString)this.reader.read("LINESTRING (200 340, 140 240, 60 240, 140 160, 140 240, 200 340)");
        this.assertEqualsExact((Geometry)expectedValue, (Geometry)l);
    }

    public void testNormalizeStringNoSideEffect() throws Exception {
        LineString l = (LineString)this.reader.read("LINESTRING (200 240, 140 160, 80 160, 160 80, 80 80)");
        LineString ref = (LineString)this.reader.read("LINESTRING (200 240, 140 160)");
        LineString seg = l.getFactory().createLineString(new Coordinate[]{l.getCoordinates()[0], l.getCoordinates()[1]});
        this.assertEqualsExact((Geometry)ref, (Geometry)seg);
        l.normalize();
        this.assertEqualsExact((Geometry)ref, (Geometry)seg);
    }

    public void testNormalizeEmptyLineString() throws Exception {
        LineString l = (LineString)this.reader.read("LINESTRING EMPTY");
        l.normalize();
        LineString expectedValue = (LineString)this.reader.read("LINESTRING EMPTY");
        this.assertEqualsExact((Geometry)expectedValue, (Geometry)l);
    }

    public void testNormalizeEmptyPolygon() throws Exception {
        Polygon actualValue = (Polygon)this.reader.read("POLYGON EMPTY");
        actualValue.normalize();
        Polygon expectedValue = (Polygon)this.reader.read("POLYGON EMPTY");
        this.assertEqualsExact((Geometry)expectedValue, (Geometry)actualValue);
    }

    public void testNormalizePolygon1() throws Exception {
        Polygon actualValue = (Polygon)this.reader.read("POLYGON ((120 320, 240 200, 120 80, 20 200, 120 320), (60 200, 80 220, 80 200, 60 200), (160 200, 180 200, 180 220, 160 200), (120 140, 140 140, 140 160, 120 140), (140 240, 140 220, 120 260, 140 240))");
        actualValue.normalize();
        Polygon expectedValue = (Polygon)this.reader.read("POLYGON ((20 200, 120 320, 240 200, 120 80, 20 200), (60 200, 80 200, 80 220, 60 200), (120 140, 140 140, 140 160, 120 140), (120 260, 140 220, 140 240, 120 260), (160 200, 180 200, 180 220, 160 200))");
        this.assertEqualsExact((Geometry)expectedValue, (Geometry)actualValue);
    }

    public void testNormalizeMultiLineString() throws Exception {
        MultiLineString actualValue = (MultiLineString)this.reader.read("MULTILINESTRING ((200 260, 180 320, 260 340), (120 180, 140 100, 40 80), (200 180, 220 160, 200 180), (100 280, 120 260, 140 260, 140 240, 120 240, 120 260, 100 280))");
        actualValue.normalize();
        MultiLineString expectedValue = (MultiLineString)this.reader.read("MULTILINESTRING ((40 80, 140 100, 120 180), (100 280, 120 260, 120 240, 140 240, 140 260, 120 260, 100 280), (200 180, 220 160, 200 180), (200 260, 180 320, 260 340))");
        this.assertEqualsExact((Geometry)expectedValue, (Geometry)actualValue);
    }

    public void testNormalizeMultiPolygon() throws Exception {
        MultiPolygon actualValue = (MultiPolygon)this.reader.read("MULTIPOLYGON (((40 360, 40 280, 140 280, 140 360, 40 360), (60 340, 60 300, 120 300, 120 340, 60 340)), ((140 200, 260 200, 260 100, 140 100, 140 200), (160 180, 240 180, 240 120, 160 120, 160 180)))");
        actualValue.normalize();
        MultiPolygon expectedValue = (MultiPolygon)this.reader.read("MULTIPOLYGON (((40 280, 40 360, 140 360, 140 280, 40 280), (60 300, 120 300, 120 340, 60 340, 60 300)), ((140 100, 140 200, 260 200, 260 100, 140 100), (160 120, 240 120, 240 180, 160 180, 160 120)))");
        this.assertEqualsExact((Geometry)expectedValue, (Geometry)actualValue);
    }

    public void testNormalizeGeometryCollection() throws Exception {
        GeometryCollection actualValue = (GeometryCollection)this.reader.read("GEOMETRYCOLLECTION (LINESTRING (200 300, 200 280, 220 280, 220 320, 180 320), POINT (140 220), POLYGON ((100 80, 100 160, 20 160, 20 80, 100 80), (40 140, 40 100, 80 100, 80 140, 40 140)), POINT (100 240))");
        actualValue.normalize();
        GeometryCollection expectedValue = (GeometryCollection)this.reader.read("GEOMETRYCOLLECTION (POINT (100 240), POINT (140 220), LINESTRING (180 320, 220 320, 220 280, 200 280, 200 300), POLYGON ((20 80, 20 160, 100 160, 100 80, 20 80), (40 100, 80 100, 80 140, 40 140, 40 100)))");
        this.assertEqualsExact((Geometry)expectedValue, (Geometry)actualValue);
    }

    public void testNormalizePackedCoordinateSequence() throws Exception {
        GeometryFactory pcsFactory = new GeometryFactory((CoordinateSequenceFactory)PackedCoordinateSequenceFactory.DOUBLE_FACTORY);
        WKTReader pcsReader = new WKTReader(pcsFactory);
        Geometry geom = pcsReader.read("LINESTRING (100 100, 0 0)");
        geom.normalize();
        Geometry clone = geom.copy();
        this.assertEqualsExact(geom, clone);
    }

    private void assertEqualsExact(Geometry expectedValue, Geometry actualValue) {
        NormalizeTest.assertTrue((String)("Expected " + expectedValue + " but encountered " + actualValue), (boolean)actualValue.equalsExact(expectedValue));
    }
}

