/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.impl;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;

public class BasicCoordinateSequenceTest
extends TestCase {
    public BasicCoordinateSequenceTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run(BasicCoordinateSequenceTest.class);
    }

    public void testClone() {
        CoordinateSequence s1 = CoordinateArraySequenceFactory.instance().create(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0)});
        CoordinateSequence s2 = s1.copy();
        BasicCoordinateSequenceTest.assertTrue((boolean)s1.getCoordinate(0).equals((Object)s2.getCoordinate(0)));
        BasicCoordinateSequenceTest.assertTrue((s1.getCoordinate(0) != s2.getCoordinate(0) ? 1 : 0) != 0);
    }

    public void testCloneDimension2() {
        CoordinateSequence s1 = CoordinateArraySequenceFactory.instance().create(2, 2);
        s1.setOrdinate(0, 0, 1.0);
        s1.setOrdinate(0, 1, 2.0);
        s1.setOrdinate(1, 0, 3.0);
        s1.setOrdinate(1, 1, 4.0);
        CoordinateSequence s2 = s1.copy();
        BasicCoordinateSequenceTest.assertTrue((s1.getDimension() == s2.getDimension() ? 1 : 0) != 0);
        BasicCoordinateSequenceTest.assertTrue((boolean)s1.getCoordinate(0).equals((Object)s2.getCoordinate(0)));
        BasicCoordinateSequenceTest.assertTrue((s1.getCoordinate(0) != s2.getCoordinate(0) ? 1 : 0) != 0);
    }
}

