/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom.util;

import java.io.IOException;
import junit.framework.TestCase;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.geom.util.NoninvertibleTransformationException;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class AffineTransformationTest
extends TestCase {
    static WKTReader rdr = new WKTReader();

    public AffineTransformationTest(String name) {
        super(name);
    }

    public void testRotate1() throws IOException, ParseException {
        AffineTransformation t = AffineTransformation.rotationInstance((double)1.5707963267948966);
        this.checkTransformation(10.0, 0.0, t, 0.0, 10.0);
        this.checkTransformation(0.0, 10.0, t, -10.0, 0.0);
        this.checkTransformation(-10.0, -10.0, t, 10.0, -10.0);
    }

    public void testRotateAroundPoint1() throws IOException, ParseException {
        AffineTransformation t = AffineTransformation.rotationInstance((double)1.5707963267948966, (double)1.0, (double)1.0);
        this.checkTransformation(1.0, 1.0, t, 1.0, 1.0);
        this.checkTransformation(10.0, 0.0, t, 2.0, 10.0);
        this.checkTransformation(0.0, 10.0, t, -8.0, 0.0);
        this.checkTransformation(-10.0, -10.0, t, 12.0, -10.0);
    }

    public void testReflectXY1() throws IOException, ParseException {
        AffineTransformation t = AffineTransformation.reflectionInstance((double)1.0, (double)1.0);
        this.checkTransformation(10.0, 0.0, t, 0.0, 10.0);
        this.checkTransformation(0.0, 10.0, t, 10.0, 0.0);
        this.checkTransformation(-10.0, -10.0, t, -10.0, -10.0);
        this.checkTransformation(-3.0, -4.0, t, -4.0, -3.0);
    }

    public void testReflectXY2() throws IOException, ParseException {
        AffineTransformation t = AffineTransformation.reflectionInstance((double)1.0, (double)-1.0);
        this.checkTransformation(10.0, 0.0, t, 0.0, -10.0);
        this.checkTransformation(0.0, 10.0, t, -10.0, 0.0);
        this.checkTransformation(-10.0, -10.0, t, 10.0, 10.0);
        this.checkTransformation(-3.0, -4.0, t, 4.0, 3.0);
    }

    public void testReflectXYXY1() throws IOException, ParseException {
        AffineTransformation t = AffineTransformation.reflectionInstance((double)0.0, (double)5.0, (double)5.0, (double)0.0);
        this.checkTransformation(5.0, 0.0, t, 5.0, 0.0);
        this.checkTransformation(0.0, 0.0, t, 5.0, 5.0);
        this.checkTransformation(-10.0, -10.0, t, 15.0, 15.0);
    }

    public void testScale1() throws IOException, ParseException {
        AffineTransformation t = AffineTransformation.scaleInstance((double)2.0, (double)3.0);
        this.checkTransformation(10.0, 0.0, t, 20.0, 0.0);
        this.checkTransformation(0.0, 10.0, t, 0.0, 30.0);
        this.checkTransformation(-10.0, -10.0, t, -20.0, -30.0);
    }

    public void testShear1() throws IOException, ParseException {
        AffineTransformation t = AffineTransformation.shearInstance((double)2.0, (double)3.0);
        this.checkTransformation(10.0, 0.0, t, 10.0, 30.0);
    }

    public void testTranslate1() throws IOException, ParseException {
        AffineTransformation t = AffineTransformation.translationInstance((double)2.0, (double)3.0);
        this.checkTransformation(1.0, 0.0, t, 3.0, 3.0);
        this.checkTransformation(0.0, 0.0, t, 2.0, 3.0);
        this.checkTransformation(-10.0, -5.0, t, -8.0, -2.0);
    }

    public void testTranslateRotate1() throws IOException, ParseException {
        AffineTransformation t = AffineTransformation.translationInstance((double)3.0, (double)3.0).rotate(1.5707963267948966);
        this.checkTransformation(10.0, 0.0, t, -3.0, 13.0);
        this.checkTransformation(-10.0, -10.0, t, 7.0, -7.0);
    }

    public void testCompose1() {
        AffineTransformation t0 = AffineTransformation.translationInstance((double)10.0, (double)0.0);
        t0.rotate(1.5707963267948966);
        t0.translate(0.0, -10.0);
        AffineTransformation t1 = AffineTransformation.translationInstance((double)0.0, (double)0.0);
        t1.rotate(1.5707963267948966);
        this.checkTransformation(t0, t1);
    }

    public void testCompose2() {
        AffineTransformation t0 = AffineTransformation.reflectionInstance((double)0.0, (double)0.0, (double)1.0, (double)0.0);
        t0.reflect(0.0, 0.0, 0.0, -1.0);
        AffineTransformation t1 = AffineTransformation.rotationInstance((double)Math.PI);
        this.checkTransformation(t0, t1);
    }

    public void testComposeRotation1() {
        AffineTransformation t0 = AffineTransformation.rotationInstance((double)1.0, (double)10.0, (double)10.0);
        AffineTransformation t1 = AffineTransformation.translationInstance((double)-10.0, (double)-10.0);
        t1.rotate(1.0);
        t1.translate(10.0, 10.0);
        this.checkTransformation(t0, t1);
    }

    public void testLineString() throws IOException, ParseException, NoninvertibleTransformationException {
        this.checkTransformation("LINESTRING (1 2, 10 20, 100 200)");
    }

    public void testPolygon() throws IOException, ParseException, NoninvertibleTransformationException {
        this.checkTransformation("POLYGON ((0 0, 100 0, 100 100, 0 100, 0 0))");
    }

    public void testPolygonWithHole() throws IOException, ParseException, NoninvertibleTransformationException {
        this.checkTransformation("POLYGON ((0 0, 100 0, 100 100, 0 100, 0 0), (1 1, 1 10, 10 10, 10 1, 1 1) )");
    }

    public void testMultiPoint() throws IOException, ParseException, NoninvertibleTransformationException {
        this.checkTransformation("MULTIPOINT (0 0, 1 4, 100 200)");
    }

    public void testMultiLineString() throws IOException, ParseException, NoninvertibleTransformationException {
        this.checkTransformation("MULTILINESTRING ((0 0, 1 10), (10 10, 20 30), (123 123, 456 789))");
    }

    public void testMultiPolygon() throws IOException, ParseException, NoninvertibleTransformationException {
        this.checkTransformation("MULTIPOLYGON ( ((0 0, 100 0, 100 100, 0 100, 0 0), (1 1, 1 10, 10 10, 10 1, 1 1) ), ((200 200, 200 250, 250 250, 250 200, 200 200)) )");
    }

    public void testGeometryCollection() throws IOException, ParseException, NoninvertibleTransformationException {
        this.checkTransformation("GEOMETRYCOLLECTION ( POINT ( 1 1), LINESTRING (0 0, 10 10), POLYGON ((0 0, 100 0, 100 100, 0 100, 0 0)) )");
    }

    public void testNestedGeometryCollection() throws IOException, ParseException, NoninvertibleTransformationException {
        this.checkTransformation("GEOMETRYCOLLECTION ( POINT (20 20), GEOMETRYCOLLECTION ( POINT ( 1 1), LINESTRING (0 0, 10 10), POLYGON ((0 0, 100 0, 100 100, 0 100, 0 0)) ) )");
    }

    public void testCompose3() {
        AffineTransformation t0 = AffineTransformation.reflectionInstance((double)0.0, (double)10.0, (double)10.0, (double)0.0);
        t0.translate(-10.0, -10.0);
        AffineTransformation t1 = AffineTransformation.reflectionInstance((double)0.0, (double)0.0, (double)-1.0, (double)1.0);
        this.checkTransformation(t0, t1);
    }

    void checkTransformation(double x, double y, AffineTransformation trans, double xp, double yp) {
        Coordinate p = new Coordinate(x, y);
        Coordinate p2 = new Coordinate();
        trans.transform(p, p2);
        AffineTransformationTest.assertEquals((double)xp, (double)p2.x, (double)5.0E-5);
        AffineTransformationTest.assertEquals((double)yp, (double)p2.y, (double)5.0E-5);
        try {
            AffineTransformation invTrans = trans.getInverse();
            Coordinate pInv = new Coordinate();
            invTrans.transform(p2, pInv);
            AffineTransformationTest.assertEquals((double)x, (double)pInv.x, (double)5.0E-5);
            AffineTransformationTest.assertEquals((double)y, (double)pInv.y, (double)5.0E-5);
            double det = trans.getDeterminant();
            double detInv = invTrans.getDeterminant();
            AffineTransformationTest.assertEquals((double)det, (double)(1.0 / detInv), (double)5.0E-5);
        }
        catch (NoninvertibleTransformationException noninvertibleTransformationException) {
            // empty catch block
        }
    }

    void checkTransformation(String geomStr) throws IOException, ParseException, NoninvertibleTransformationException {
        Geometry geom = rdr.read(geomStr);
        AffineTransformation trans = AffineTransformation.rotationInstance((double)1.5707963267948966);
        AffineTransformation inv = trans.getInverse();
        Geometry transGeom = geom.copy();
        transGeom.apply((CoordinateSequenceFilter)trans);
        transGeom.apply((CoordinateSequenceFilter)inv);
        boolean isEqual = geom.equalsExact(transGeom, 5.0E-4);
        AffineTransformationTest.assertTrue((boolean)isEqual);
    }

    void checkTransformation(AffineTransformation trans0, AffineTransformation trans1) {
        double[] m0 = trans0.getMatrixEntries();
        double[] m1 = trans1.getMatrixEntries();
        for (int i = 0; i < m0.length; ++i) {
            AffineTransformationTest.assertEquals((double)m0[i], (double)m1[i], (double)5.0E-6);
        }
    }
}

