/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.kdtree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.kdtree.KdNode;
import org.locationtech.jts.index.kdtree.KdTree;
import test.jts.util.IOUtil;

public class KdTreeTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(KdTreeTest.class);
    }

    public KdTreeTest(String name) {
        super(name);
    }

    public void testSinglePoint() {
        KdNode node2;
        KdTree index = new KdTree(0.001);
        KdNode node1 = index.insert(new Coordinate(1.0, 1.0));
        KdTreeTest.assertTrue((String)"Inserting 2 identical points should create one node", (node1 == (node2 = index.insert(new Coordinate(1.0, 1.0))) ? 1 : 0) != 0);
        Envelope queryEnv = new Envelope(0.0, 10.0, 0.0, 10.0);
        List result = index.query(queryEnv);
        KdTreeTest.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        KdNode node = (KdNode)result.get(0);
        KdTreeTest.assertTrue((node.getCount() == 2 ? 1 : 0) != 0);
        KdTreeTest.assertTrue((boolean)node.isRepeated());
    }

    public void testMultiplePoint() {
        this.testQuery("MULTIPOINT ( (1 1), (2 2) )", 0.0, new Envelope(0.0, 10.0, 0.0, 10.0), "MULTIPOINT ( (1 1), (2 2) )");
    }

    public void testSubset() {
        this.testQuery("MULTIPOINT ( (1 1), (2 2), (3 3), (4 4) )", 0.0, new Envelope(1.5, 3.4, 1.5, 3.5), "MULTIPOINT ( (2 2), (3 3) )");
    }

    public void testToleranceFailure() {
        this.testQuery("MULTIPOINT ( (0 0), (-.1 1), (.1 1) )", 1.0, new Envelope(-9.0, 9.0, -9.0, 9.0), "MULTIPOINT ( (0 0), (-.1 1) )");
    }

    public void testTolerance2() {
        this.testQuery("MULTIPOINT ((10 60), (20 60), (30 60), (30 63))", 9.0, new Envelope(0.0, 99.0, 0.0, 99.0), "MULTIPOINT ((10 60), (20 60), (30 60))");
    }

    public void testTolerance2_perturbedY() {
        this.testQuery("MULTIPOINT ((10 60), (20 61), (30 60), (30 63))", 9.0, new Envelope(0.0, 99.0, 0.0, 99.0), "MULTIPOINT ((10 60), (20 61), (30 60))");
    }

    public void testSnapToNearest() {
        this.testQueryRepeated("MULTIPOINT ( (10 60), (20 60), (16 60))", 5.0, new Envelope(0.0, 99.0, 0.0, 99.0), "MULTIPOINT ( (10 60), (20 60), (20 60))");
    }

    private void testQuery(String wktInput, double tolerance, Envelope queryEnv, String wktExpected) {
        KdTree index = this.build(wktInput, tolerance);
        this.testQuery(index, queryEnv, false, IOUtil.read(wktExpected).getCoordinates());
    }

    private void testQueryRepeated(String wktInput, double tolerance, Envelope queryEnv, String wktExpected) {
        KdTree index = this.build(wktInput, tolerance);
        this.testQuery(index, queryEnv, true, IOUtil.read(wktExpected).getCoordinates());
    }

    private void testQuery(KdTree index, Envelope queryEnv, Coordinate[] expectedCoord) {
        Object[] result = KdTree.toCoordinates((Collection)index.query(queryEnv));
        Arrays.sort(result);
        Arrays.sort(expectedCoord);
        KdTreeTest.assertTrue((String)("Result count = " + result.length + ", expected count = " + expectedCoord.length), (result.length == expectedCoord.length ? 1 : 0) != 0);
        boolean isMatch = CoordinateArrays.equals((Coordinate[])result, (Coordinate[])expectedCoord);
        KdTreeTest.assertTrue((String)"Expected result coordinates not found", (boolean)isMatch);
    }

    private void testQuery(KdTree index, Envelope queryEnv, boolean includeRepeated, Coordinate[] expectedCoord) {
        Object[] result = KdTree.toCoordinates((Collection)index.query(queryEnv), (boolean)includeRepeated);
        Arrays.sort(result);
        Arrays.sort(expectedCoord);
        KdTreeTest.assertTrue((String)("Result count = " + result.length + ", expected count = " + expectedCoord.length), (result.length == expectedCoord.length ? 1 : 0) != 0);
        boolean isMatch = CoordinateArrays.equals((Coordinate[])result, (Coordinate[])expectedCoord);
        KdTreeTest.assertTrue((String)"Expected result coordinates not found", (boolean)isMatch);
    }

    private KdTree build(String wktInput, double tolerance) {
        KdTree index = new KdTree(tolerance);
        Coordinate[] coords = IOUtil.read(wktInput).getCoordinates();
        for (int i = 0; i < coords.length; ++i) {
            index.insert(coords[i]);
        }
        return index;
    }
}

