/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.quadtree;

import java.util.List;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.SpatialIndexTester;
import org.locationtech.jts.index.quadtree.Quadtree;
import test.jts.util.SerializationUtil;

public class QuadtreeTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(QuadtreeTest.class);
    }

    public QuadtreeTest(String name) {
        super(name);
    }

    public void testSpatialIndex() throws Exception {
        SpatialIndexTester tester = new SpatialIndexTester();
        tester.setSpatialIndex((SpatialIndex)new Quadtree());
        tester.init();
        tester.run();
        QuadtreeTest.assertTrue((boolean)tester.isSuccess());
    }

    public void testSerialization() throws Exception {
        SpatialIndexTester tester = new SpatialIndexTester();
        tester.setSpatialIndex((SpatialIndex)new Quadtree());
        tester.init();
        Quadtree tree = (Quadtree)tester.getSpatialIndex();
        byte[] data = SerializationUtil.serialize(tree);
        tree = (Quadtree)SerializationUtil.deserialize(data);
        tester.setSpatialIndex((SpatialIndex)tree);
        tester.run();
        QuadtreeTest.assertTrue((boolean)tester.isSuccess());
    }

    public void testNullQuery() {
        Quadtree qt = new Quadtree();
        List result1 = qt.query(null);
        QuadtreeTest.assertTrue((result1.size() == 0 ? 1 : 0) != 0);
        qt.insert(new Envelope(0.0, 10.0, 0.0, 10.0), (Object)"some data");
        List result2 = qt.query(null);
        QuadtreeTest.assertTrue((result2.size() == 0 ? 1 : 0) != 0);
    }
}

