/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.index.strtree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.SpatialIndex;
import org.locationtech.jts.index.SpatialIndexTester;
import org.locationtech.jts.index.strtree.AbstractNode;
import org.locationtech.jts.index.strtree.GeometryDistanceComparator;
import org.locationtech.jts.index.strtree.GeometryItemDistance;
import org.locationtech.jts.index.strtree.ItemBoundable;
import org.locationtech.jts.index.strtree.ItemDistance;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.util.AssertionFailedException;
import test.jts.index.STRtreeDemo;
import test.jts.util.SerializationUtil;

public class STRtreeTest
extends TestCase {
    private GeometryFactory factory = new GeometryFactory();

    public STRtreeTest(String Name_) {
        super(Name_);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{STRtreeTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    public void testEmptyTreeUsingListQuery() {
        STRtree tree = new STRtree();
        List list = tree.query(new Envelope(0.0, 0.0, 1.0, 1.0));
        STRtreeTest.assertTrue((boolean)list.isEmpty());
    }

    public void testEmptyTreeUsingItemVisitorQuery() {
        STRtree tree = new STRtree();
        tree.query(new Envelope(0.0, 0.0, 1.0, 1.0), new ItemVisitor(){

            public void visitItem(Object item) {
                Assert.assertTrue((String)"Should never reach here", (boolean)true);
            }
        });
    }

    public void testCreateParentsFromVerticalSlice() {
        this.doTestCreateParentsFromVerticalSlice(3, 2, 2, 1);
        this.doTestCreateParentsFromVerticalSlice(4, 2, 2, 2);
        this.doTestCreateParentsFromVerticalSlice(5, 2, 2, 1);
    }

    public void testSpatialIndex() throws Exception {
        SpatialIndexTester tester = new SpatialIndexTester();
        tester.setSpatialIndex((SpatialIndex)new STRtree(4));
        tester.init();
        tester.run();
        STRtreeTest.assertTrue((boolean)tester.isSuccess());
    }

    public void testSerialization() throws Exception {
        SpatialIndexTester tester = new SpatialIndexTester();
        tester.setSpatialIndex((SpatialIndex)new STRtree(4));
        tester.init();
        STRtree tree = (STRtree)tester.getSpatialIndex();
        tree.query(new Envelope());
        byte[] data = SerializationUtil.serialize(tree);
        tree = (STRtree)SerializationUtil.deserialize(data);
        tester.setSpatialIndex((SpatialIndex)tree);
        tester.run();
        STRtreeTest.assertTrue((boolean)tester.isSuccess());
    }

    public void testDisallowedInserts() {
        STRtree t = new STRtree(5);
        t.insert(new Envelope(0.0, 0.0, 0.0, 0.0), new Object());
        t.insert(new Envelope(0.0, 0.0, 0.0, 0.0), new Object());
        t.query(new Envelope());
        try {
            t.insert(new Envelope(0.0, 0.0, 0.0, 0.0), new Object());
            STRtreeTest.assertTrue((boolean)false);
        }
        catch (AssertionFailedException e) {
            STRtreeTest.assertTrue((boolean)true);
        }
    }

    public void testQuery() throws Throwable {
        ArrayList<LineString> geometries = new ArrayList<LineString>();
        geometries.add(this.factory.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(10.0, 10.0)}));
        geometries.add(this.factory.createLineString(new Coordinate[]{new Coordinate(20.0, 20.0), new Coordinate(30.0, 30.0)}));
        geometries.add(this.factory.createLineString(new Coordinate[]{new Coordinate(20.0, 20.0), new Coordinate(30.0, 30.0)}));
        STRtreeDemo.TestTree t = new STRtreeDemo.TestTree(4);
        for (Geometry geometry : geometries) {
            t.insert(geometry.getEnvelopeInternal(), new Object());
        }
        t.build();
        try {
            STRtreeTest.assertEquals((int)1, (int)t.query(new Envelope(5.0, 6.0, 5.0, 6.0)).size());
            STRtreeTest.assertEquals((int)0, (int)t.query(new Envelope(20.0, 30.0, 0.0, 10.0)).size());
            STRtreeTest.assertEquals((int)2, (int)t.query(new Envelope(25.0, 26.0, 25.0, 26.0)).size());
            STRtreeTest.assertEquals((int)3, (int)t.query(new Envelope(0.0, 100.0, 0.0, 100.0)).size());
        }
        catch (Throwable x) {
            STRtreeDemo.printSourceData(geometries, System.out);
            STRtreeDemo.printLevels(t, System.out);
            throw x;
        }
    }

    public void testVerticalSlices() {
        this.doTestVerticalSlices(3, 2, 2, 1);
        this.doTestVerticalSlices(4, 2, 2, 2);
        this.doTestVerticalSlices(5, 3, 2, 1);
    }

    public void testRemove() {
        STRtree tree = new STRtree();
        tree.insert(new Envelope(0.0, 10.0, 0.0, 10.0), (Object)"1");
        tree.insert(new Envelope(5.0, 15.0, 5.0, 15.0), (Object)"2");
        tree.insert(new Envelope(10.0, 20.0, 10.0, 20.0), (Object)"3");
        tree.insert(new Envelope(15.0, 25.0, 15.0, 25.0), (Object)"4");
        tree.remove(new Envelope(10.0, 20.0, 10.0, 20.0), (Object)"4");
        STRtreeTest.assertEquals((int)3, (int)tree.size());
    }

    public void testKNearestNeighbors() {
        int i;
        int topK = 1000;
        int totalRecords = 10000;
        GeometryFactory geometryFactory = new GeometryFactory();
        Coordinate coordinate = new Coordinate(10.1, -10.1);
        Point queryCenter = geometryFactory.createPoint(coordinate);
        int valueRange = 1000;
        ArrayList<Point> testDataset = new ArrayList<Point>();
        ArrayList correctData = new ArrayList();
        Random random = new Random();
        GeometryDistanceComparator distanceComparator = new GeometryDistanceComparator(queryCenter, true);
        for (i = 0; i < totalRecords; ++i) {
            coordinate = new Coordinate(-100.0 + (double)random.nextInt(valueRange) * 1.1, (double)random.nextInt(valueRange) * -5.1);
            Point spatialObject = geometryFactory.createPoint(coordinate);
            testDataset.add(spatialObject);
        }
        Collections.sort(testDataset, distanceComparator);
        for (i = 0; i < topK; ++i) {
            correctData.add(testDataset.get(i));
        }
        STRtree strtree = new STRtree();
        for (int i2 = 0; i2 < totalRecords; ++i2) {
            strtree.insert(((Geometry)testDataset.get(i2)).getEnvelopeInternal(), testDataset.get(i2));
        }
        strtree.query(new Envelope(1.1, 1.1, 2.1, 2.1));
        Object[] testTopK = strtree.nearestNeighbour(queryCenter.getEnvelopeInternal(), (Object)queryCenter, (ItemDistance)new GeometryItemDistance(), topK);
        List<Object> topKList = Arrays.asList(testTopK);
        Collections.sort(topKList, distanceComparator);
        int difference = 0;
        for (int i3 = 0; i3 < topK; ++i3) {
            if (distanceComparator.compare((Geometry)correctData.get(i3), (Geometry)topKList.get(i3)) == 0) continue;
            ++difference;
        }
        STRtreeTest.assertEquals((int)difference, (int)0);
    }

    private void doTestCreateParentsFromVerticalSlice(int childCount, int nodeCapacity, int expectedChildrenPerParentBoundable, int expectedChildrenOfLastParent) {
        STRtreeDemo.TestTree t = new STRtreeDemo.TestTree(nodeCapacity);
        List parentBoundables = t.createParentBoundablesFromVerticalSlice(this.itemWrappers(childCount), 0);
        for (int i = 0; i < parentBoundables.size() - 1; ++i) {
            AbstractNode parentBoundable = (AbstractNode)parentBoundables.get(i);
            STRtreeTest.assertEquals((int)expectedChildrenPerParentBoundable, (int)parentBoundable.getChildBoundables().size());
        }
        AbstractNode lastParent = (AbstractNode)parentBoundables.get(parentBoundables.size() - 1);
        STRtreeTest.assertEquals((int)expectedChildrenOfLastParent, (int)lastParent.getChildBoundables().size());
    }

    private void doTestVerticalSlices(int itemCount, int sliceCount, int expectedBoundablesPerSlice, int expectedBoundablesOnLastSlice) {
        STRtreeDemo.TestTree t = new STRtreeDemo.TestTree(2);
        List[] slices = t.verticalSlices(this.itemWrappers(itemCount), sliceCount);
        STRtreeTest.assertEquals((int)sliceCount, (int)slices.length);
        for (int i = 0; i < sliceCount - 1; ++i) {
            STRtreeTest.assertEquals((int)expectedBoundablesPerSlice, (int)slices[i].size());
        }
        STRtreeTest.assertEquals((int)expectedBoundablesOnLastSlice, (int)slices[sliceCount - 1].size());
    }

    private List itemWrappers(int size) {
        ArrayList<ItemBoundable> itemWrappers = new ArrayList<ItemBoundable>();
        for (int i = 0; i < size; ++i) {
            itemWrappers.add(new ItemBoundable((Object)new Envelope(0.0, 0.0, 0.0, 0.0), new Object()));
        }
        return itemWrappers;
    }
}

