/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.io;

import java.io.IOException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;
import org.locationtech.jts.io.AverageZFilter;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.util.GeometricShapeFactory;

public class WKBTest
extends TestCase {
    private GeometryFactory geomFactory = new GeometryFactory();
    private WKTReader rdr = new WKTReader(this.geomFactory);
    static CoordinateSequenceComparator comp2 = new CoordinateSequenceComparator(2);
    static CoordinateSequenceComparator comp3 = new CoordinateSequenceComparator(3);
    WKBReader wkbReader = new WKBReader(this.geomFactory);

    public static void main(String[] args) {
        TestRunner.run(WKBTest.class);
    }

    public WKBTest(String name) {
        super(name);
    }

    public void testFirst() throws IOException, ParseException {
        this.runWKBTest("MULTIPOINT ((0 0), (1 4), (100 200))");
    }

    public void testPointPCS() throws IOException, ParseException {
        this.runWKBTestPackedCoordinate("POINT (1 2)");
    }

    public void testPoint() throws IOException, ParseException {
        this.runWKBTest("POINT (1 2)");
    }

    public void testLineString() throws IOException, ParseException {
        this.runWKBTest("LINESTRING (1 2, 10 20, 100 200)");
    }

    public void testPolygon() throws IOException, ParseException {
        this.runWKBTest("POLYGON ((0 0, 100 0, 100 100, 0 100, 0 0))");
    }

    public void testPolygonWithHole() throws IOException, ParseException {
        this.runWKBTest("POLYGON ((0 0, 100 0, 100 100, 0 100, 0 0), (1 1, 1 10, 10 10, 10 1, 1 1) )");
    }

    public void testMultiPoint() throws IOException, ParseException {
        this.runWKBTest("MULTIPOINT ((0 0), (1 4), (100 200))");
    }

    public void testMultiLineString() throws IOException, ParseException {
        this.runWKBTest("MULTILINESTRING ((0 0, 1 10), (10 10, 20 30), (123 123, 456 789))");
    }

    public void testMultiPolygon() throws IOException, ParseException {
        this.runWKBTest("MULTIPOLYGON ( ((0 0, 100 0, 100 100, 0 100, 0 0), (1 1, 1 10, 10 10, 10 1, 1 1) ), ((200 200, 200 250, 250 250, 250 200, 200 200)) )");
    }

    public void testGeometryCollection() throws IOException, ParseException {
        this.runWKBTest("GEOMETRYCOLLECTION ( POINT ( 1 1), LINESTRING (0 0, 10 10), POLYGON ((0 0, 100 0, 100 100, 0 100, 0 0)) )");
    }

    public void testNestedGeometryCollection() throws IOException, ParseException {
        this.runWKBTest("GEOMETRYCOLLECTION ( POINT (20 20), GEOMETRYCOLLECTION ( POINT ( 1 1), LINESTRING (0 0, 10 10), POLYGON ((0 0, 100 0, 100 100, 0 100, 0 0)) ) )");
    }

    public void testLineStringEmpty() throws IOException, ParseException {
        this.runWKBTest("LINESTRING EMPTY");
    }

    public void testBigPolygon() throws IOException, ParseException {
        GeometricShapeFactory shapeFactory = new GeometricShapeFactory(this.geomFactory);
        shapeFactory.setBase(new Coordinate(0.0, 0.0));
        shapeFactory.setSize(1000.0);
        shapeFactory.setNumPoints(1000);
        Polygon geom = shapeFactory.createRectangle();
        this.runWKBTest((Geometry)geom, 2, false);
    }

    public void testPolygonEmpty() throws IOException, ParseException {
        this.runWKBTest("POLYGON EMPTY");
    }

    public void testMultiPointEmpty() throws IOException, ParseException {
        this.runWKBTest("MULTIPOINT EMPTY");
    }

    public void testMultiLineStringEmpty() throws IOException, ParseException {
        this.runWKBTest("MULTILINESTRING EMPTY");
    }

    public void testMultiPolygonEmpty() throws IOException, ParseException {
        this.runWKBTest("MULTIPOLYGON EMPTY");
    }

    public void testGeometryCollectionEmpty() throws IOException, ParseException {
        this.runWKBTest("GEOMETRYCOLLECTION EMPTY");
    }

    private void runWKBTest(String wkt) throws IOException, ParseException {
        this.runWKBTestCoordinateArray(wkt);
        this.runWKBTestPackedCoordinate(wkt);
    }

    private void runWKBTestPackedCoordinate(String wkt) throws IOException, ParseException {
        GeometryFactory geomFactory = new GeometryFactory((CoordinateSequenceFactory)new PackedCoordinateSequenceFactory(0, 2));
        WKTReader rdr = new WKTReader(geomFactory);
        Geometry g = rdr.read(wkt);
        this.runWKBTest(g, 2, true);
        this.runWKBTest(g, 2, false);
    }

    private void runWKBTestCoordinateArray(String wkt) throws IOException, ParseException {
        GeometryFactory geomFactory = new GeometryFactory();
        WKTReader rdr = new WKTReader(geomFactory);
        Geometry g = rdr.read(wkt);
        this.runWKBTest(g, 2, true);
        this.runWKBTest(g, 2, false);
        this.runWKBTest(g, 3, true);
        this.runWKBTest(g, 3, false);
    }

    private void runWKBTest(Geometry g, int dimension, boolean toHex) throws IOException, ParseException {
        this.setZ(g);
        this.runWKBTest(g, dimension, 2, toHex);
        this.runWKBTest(g, dimension, 1, toHex);
    }

    private void runWKBTest(Geometry g, int dimension, int byteOrder, boolean toHex) throws IOException, ParseException {
        this.runGeometry(g, dimension, byteOrder, toHex, 100);
        this.runGeometry(g, dimension, byteOrder, toHex, 0);
        this.runGeometry(g, dimension, byteOrder, toHex, 101010);
        this.runGeometry(g, dimension, byteOrder, toHex, -1);
    }

    private void setZ(Geometry g) {
        g.apply((CoordinateFilter)new AverageZFilter());
    }

    void runGeometry(Geometry g, int dimension, int byteOrder, boolean toHex, int srid) throws IOException, ParseException {
        boolean includeSRID = false;
        if (srid >= 0) {
            includeSRID = true;
            g.setSRID(srid);
        }
        WKBWriter wkbWriter = new WKBWriter(dimension, byteOrder, includeSRID);
        byte[] wkb = wkbWriter.write(g);
        String wkbHex = null;
        if (toHex) {
            wkbHex = WKBWriter.toHex((byte[])wkb);
        }
        if (toHex) {
            wkb = WKBReader.hexToBytes((String)wkbHex);
        }
        Geometry g2 = this.wkbReader.read(wkb);
        CoordinateSequenceComparator comp = dimension == 2 ? comp2 : comp3;
        boolean isEqual = g.compareTo((Object)g2, comp) == 0;
        WKBTest.assertTrue((boolean)isEqual);
        if (includeSRID) {
            boolean isSRIDEqual = g.getSRID() == g2.getSRID();
            WKBTest.assertTrue((boolean)isSRIDEqual);
        }
    }
}

